<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Settings;
use App\Models\Timezones;


class AboutUsController extends Controller
{
    public function about_us(Request $request)
    {
        abort_if(auth()->user()->cannot('manage_site_settings'), 404);
        if($request->isMethod('POST'))
        {

            foreach($request->only(['about_us_title','about_us_subtitle','years_of_experience','satisfied_customers','countries']) as $key => $value)
            {
                $save = ['key' => $key, 'value' => $value];
                Settings::updateOrCreate(
                    [
                        'key' => $key
                    ], $save
                );
            }

            return redirect()->back()->with('success', __('About Us updated'));
        }

        $timezones = Timezones::all();
        $settings = get_all_setting();
        return view('backend.about_us.index',compact('settings','timezones'));
    }
}
