<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Settings;
use Illuminate\Http\Request;
use DB;
class AboutUsController extends Controller
{
    public function about_us_list(Request $request)
    {
        $about_us = DB::table('settings')
                        ->select('key', 'value')
                        ->whereIn('key', ['about_us_title', 'about_us_subtitle', 'years_of_experience', 'satisfied_customers', 'countries'])
                        ->get();

        return response()->json(['about_us' => $about_us], 200);
    }
    
    public function storeAboutus(Request $request)
    {
            foreach($request->only(['about_us_titel','about_us_subtitel','years_of_experience','satisfied_customers','countries']) as $key => $value)
            {
                $save = ['key' => $key, 'value' => $value];
                Settings::updateOrCreate(
                    [
                        'key' => $key
                    ], $save
                );
            }

            return response()->json(['message' => 'About Us updated'], 200);
        
    }
}
