<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Models\BlogCategory;
use App\Models\ContactUs;
use App\Models\HeroSection;
use App\Models\Menu;
use App\Models\PageSection;
use Illuminate\Http\Request;
use App\Models\MenuItem;
use App\Models\GetInTouch;
use App\Models\Resume;
use App\Models\Offices;
use App\Models\TeamMembers;
use App\Http\Resources\MenuItemResource;
use Validator;
use Illuminate\Support\Str;
use DB;

class ApiController extends Controller
{
   public function getAllMenus()
    {
        $menuItems = MenuItem::with('children')->whereNull('parent_id')->orderBy('order')->get();

        if ($menuItems->isNotEmpty()) {
            return response()->json([
                'status' => true,
                'message' => '',
                'data' => MenuItemResource::collection($menuItems)
            ]);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Menu items not found',
                'data' => []
            ], 404);
        }
    }
    
    public function createMenu(Request $request)
    {
        // Validate the request data
        $validator = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'url' => 'required',
            'parent_id' => 'nullable|exists:menu_items,id'
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }
    
        $input = $request->all();
    
        // Create a slug from the title
        $input['slug'] = Str::slug($request->title);
        
        // Create the menu item
        $menuItem = MenuItem::create($input);
        
        return response()->json([
            'success' => true,
            'data' => $menuItem
        ], 201);
    }
    
    public function updateMenu(Request $request)
    {
        // Validate the request data
        $validator = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'url' => 'required',
            'parent_id' => 'nullable|exists:menu_items,id'
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }
    
        // Find the menu item by ID
        $menuItem = MenuItem::find($request->id);
        if (!$menuItem) {
            return response()->json([
                'success' => false,
                'message' => 'Menu item not found'
            ], 404);
        }
    
        $input = $request->all();
    
        // Create a slug from the title
        $input['slug'] = Str::slug($request->title);
    
        // Update the menu item
        $menuItem->update($input);
    
        return response()->json([
            'success' => true,
            'data' => $menuItem
        ], 200);
    }
    
    public function deleteMenu(Request $request)
    {
        // Find the menu item by ID
        $menuItem = MenuItem::find($request->id);
        if (!$menuItem) {
            return response()->json([
                'success' => false,
                'message' => 'Menu item not found'
            ], 404);
        }
    
        // Delete the menu item
        $menuItem->delete();
    
        return response()->json([
            'success' => true,
            'message' => 'Menu item deleted successfully'
        ], 200);
    }
    
    public function getAllOffices()
    {
        $Offices = Offices::where('status','1')->get();

        if ($Offices->isNotEmpty()) {
            return response()->json([
                'status' => true,
                'message' => '',
                'data' => $Offices
            ]);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Offices not found',
                'data' => []
            ], 404);
        }
    }
    
 
    
      public function createGetintuch(Request $request)
    {
        // Validate the request data
        $validator = Validator::make($request->all(), [
            'company_name' => 'required|string|max:255',
            'full_name' => 'required',
            'email' => 'required',
            'mobile' => 'required',
            'enquiry_type' => 'required',
            // 'parent_id' => 'nullable|exists:get_in_touch,id'
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }
    
        
        $getintuch = GetInTouch::create($request->all());
        
        return response()->json([
            'success' => true,
            'data' => $getintuch
        ], 201);
    }
    

     public function submitResume(Request $request)
    {
        // Validate the request data
        $validator = Validator::make($request->all(), [
            'first_name' => 'required|string|max:255',
            'last_name' => 'required',
            'email' => 'required',
            'mobile' => 'required',
            'resume_file' => 'required|file|mimes:pdf,doc,docx|max:2048',
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }
        
        $resume_file = $request->file('resume_file');
        $name = uniqid() . '.' . $resume_file->getClientOriginalExtension();
        $upload_path = 'assets/resume/';

        $resume_file->move(public_path($upload_path), $name);
        $input = $request->all();
        $input['resume_file'] = $name;
        $resume = Resume::create($input);
        
        return response()->json([
            'success' => true,
            'data' => $resume
        ], 201);
    }
    

    
    public function getOfficeById(Request $request)
    {
        // Find the menu item by ID
        $office = Offices::find($request->id);
        if (!$office) {
            return response()->json([
                'success' => false,
                'message' => 'Office not found'
            ], 404);
        }
    
    
        return response()->json([
            'success' => true,
            'message' => '',
            'data' => $office
        ], 200);
    }
    
    public function getteammemberById(Request $request)
    {
        // Find the menu item by ID
        $teammember = TeamMembers::find($request->id);
        $teammember->image = url('/').'/storage/uploads/team-members/'.$teammember->image;
        if (!$teammember) {
            return response()->json([
                'success' => false,
                'message' => 'member not found'
            ], 404);
        }
    
    
        return response()->json([
            'success' => true,
            'message' => '',
            'data' => $teammember
        ], 200);
    }
    
    
    public function getblogdetailsById(Request $request)
    {
        // Find the menu item by ID
        $blogdetails = Blog::find($request->id);
        $blogdetails->thumbnail = get_file('blog',$blogdetails->thumbnail);
        if (!$blogdetails) {
            return response()->json([
                'success' => false,
                'message' => 'blog details not found'
            ], 404);
        }
    
    
        return response()->json([
            'success' => true,
            'message' => '',
            'data' => $blogdetails
        ], 200);
    }
    
    
    public function adminLogin(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required'
        ]);

        if (auth()->attempt(['email' => $request->email, 'password' => $request->password])) {
            $user = auth()->user();

            return response()->json([
                'success' => true,
                'message' => 'Login successfully',
                'data' => $user
            ]);
        } else {
            return response()->json([
                'success' => true,
                'message' => 'Invalid Credential'
            ]);
        }

    }
    
    public function homePage(Request $request){
        
        $menuItems = MenuItem::with('children')->whereNull('parent_id')->orderBy('order')->get();
        
        $heroSections = HeroSection::orderBy('order','ASC')->get();
        
        foreach ($heroSections as $list) {
                $list->image = url('/') .'/storage/uploads/hero-section/'. $list->image;
            }
        
        $global_reach['section_1']  = DB::table('settings')->select('key', 'value')->whereIn('key', ['the_global_title', 'the_global_subtitle'])->get();
        $global_reach['section_2'] = DB::table('global_reach')->get();
        foreach ($global_reach['section_2'] as $list) {
                $list->image = url('/') .'/storage/uploads/global-reach/'. $list->image;
            }
        $blogs = Blog::limit(4)->get();
        foreach ($blogs as $list) {
                $list->thumbnail = url('/') .'/storage/uploads/blogs/'. $list->thumbnail;
            }
        $testimonial['section_1']  = DB::table('settings')->select('key', 'value')->whereIn('key', ['careers_title', 'careers_subtitle'])->get();
        $testimonial['section_2'] = DB::table('testimonial')->where('type','team')->get();    
            foreach ($testimonial['section_2'] as $list) {
                    $list->image = url('/') .'/storage/uploads/testimonial/'. $list->image;
                }
        $baseUrl = url('/') .'/assets/media/img/';

        $career = DB::table('settings')
            ->select('key', 'value')
            ->whereIn('key', ['careers_title', 'careers_subtitle', 'careers_image'])
            ->get()
            ->map(function ($item) use ($baseUrl) {
                if ($item->key === 'careers_image') {
                    $item->value = $baseUrl . $item->value;
                }
                return $item;
            });

        $about_us = DB::table('settings')
                        ->select('key', 'value')
                        ->whereIn('key', ['about_us_title', 'about_us_subtitle', 'years_of_experience', 'satisfied_customers', 'countries'])
                        ->get();
        if ($menuItems->isNotEmpty()) {
            return response()->json([
                'status' => true,
                'menu' => MenuItemResource::collection($menuItems),
                'heroSections'=>$heroSections,
                'global_reach'=>$global_reach,
                'about_us'=>$about_us,
                'blogs'=>$blogs,
                'testimonial'=>$testimonial
                
            ]);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Menu items not found',
                'data' => []
            ], 404);
        }
        
    }
    
    public function getFooter(Request $request){
        
        $footer = DB::table('settings')->select('key', 'value')->whereIn('key', ['company', 'quick_links','support','social_link_x','social_link_youtube','social_link_facebook','social_link_linkedin'])->get();
        
        foreach($footer as $list){
            if($list->key == 'company'){
               $list->value = DB::table('pages')->select('id','name','slug')->whereIn('id',json_decode($list->value, true))->get();
            }
            if($list->key == 'quick_links'){
               $list->value = DB::table('menu_items')->select('id','title','slug')->whereIn('id',json_decode($list->value, true))->get();
            }
            if($list->key == 'support'){
               $list->value = DB::table('pages')->select('id','name','slug')->whereIn('id',json_decode($list->value, true))->get();
            }
        }
        if ($footer->isNotEmpty()) {
            return response()->json([
                'status' => true,
                'footer'=>$footer
                
            ]);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'footer items not found',
                'data' => []
            ], 404);
        }
        
    }
        
    
    
}
