<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Blog;
use App\Models\BlogCategory;

class BlogController extends Controller
{
    public function blogList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $blogs = Blog::where('id',$id)->first();
        if ($blogs) {
        $blogs->thumbnail = $blogs->thumbnail ? url('/') . '/storage/uploads/blog/' . $blogs->thumbnail :null;
            }
        }
        else{
        $blogs = Blog::simplePaginate(10); 
        foreach ($blogs as $list) {
                $list->thumbnail = $list->thumbnail ? url('/') .'/storage/uploads/blog/'. $list->thumbnail : null;
            }
        
        }
        return response()->json(['blogs' => $blogs], 200);
    }
    
    public function storeBlog(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'title' => 'required|string|max:255',
                'category' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }

        $check_slug = str_slug($request->title, '-');
        if (Blog::whereSlug($check_slug)->exists())
        {
            $slug = $this->incrementSlug($check_slug);
        }
        else
        {
            $slug = $check_slug;
        }

        $blog = new Blog();
        if(!empty($request->image))
        {
            $thumbnail = upload_file($request->image,'blog');
            $blog->thumbnail = $thumbnail;
        }
        $blog->title = $request->title;
        $blog->slug = $slug;
        $blog->category_id = $request->category;
        $blog->content = $request->blog_content;
        $blog->status = $request->status;
        // $blog->created_by = get_auth_data('id');
        $blog->save();

        return response()->json(['message' => 'Blog created successfully', 'blog' => $blog]);
    }
    
    public function updateBlog(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'title' => 'required|string|max:255',
                'category' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
             return response()->json(['error' => $messages->first()]);
        }
        
        $id = $request->input('id');
        $blog = Blog::find($id);
        if (!$blog) {
            return response()->json(['error' => 'Blog not found'], 404);
        }
        
        $check_slug = str_slug($request->title, '-');
        if ($blog->getOriginal('slug') != $check_slug)
        {
            if (Blog::whereSlug($check_slug)->exists())
            {
                $slug = $this->incrementSlug($check_slug);
            }
            else
            {
                $slug = $check_slug;
            }
        }
        else
        {
            $slug = $check_slug;
        }

        if(!empty($request->image))
        {
            $thumbnail = upload_file($request->image,'blog',$blog->thumbnail);
            $blog->thumbnail = $thumbnail;
        }
        $blog->title = $request->title;
        $blog->slug = $slug;
        $blog->category_id = $request->category;
        $blog->content = $request->content;
        $blog->status = $request->status;
        $blog->update();

        return response()->json(['message' => 'Blog Update successfully', 'blog' => $blog]);
    }
    
    public function deleteBlog(Request $request)
    {   
        $id = $request->input('id');
        $blog = Blog::find($id);
        delete_file('blog',$blog->thumbnail);
        $blog->delete();
        return response()->json(['message' => 'Blog Deleted Successfully'], 200);
    }
    
    /*----------------------------- Blog Category --------------------------*/
    
    public function blogCategoryList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $blogsCategory = BlogCategory::where('id',$id)->get();
        }else{
            if($request->input('perpage') > 0){
        $blogsCategory = BlogCategory::simplePaginate($request->input('perpage'));
            }else{
             $blogsCategory = BlogCategory::get();   
            }
        }
        return response()->json(['blogsCategory' => $blogsCategory], 200);
    }
    
    
    public function storeBlogCategory(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|unique:blog_categories',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }

        $check_slug = str_slug($request->name, '-');
        if (BlogCategory::whereSlug($check_slug)->exists()) {
            $slug = $this->incrementSlug($check_slug);
        } else {
            $slug = $check_slug;
        }

        $category = new BlogCategory();
        $category->name = $request->name;
        $category->description = $request->description;
        $category->slug = $slug;
        $category->status = $request->status;
        $category->save();
        return response()->json(['message' => 'Blog Category Store successfully', 'blog_category' => $category]);
    }
    
    public function updateBlogCategory(Request $request)
    {   
        $id = $request->input('id');
        $blogCategory = BlogCategory::find($id);
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|unique:blog_categories,name,' . $id,
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }

        $check_slug = str_slug($request->name, '-');
        if ($blogCategory->getOriginal('slug') != $check_slug) {
            if (BlogCategory::whereSlug($check_slug)->exists()) {
                $slug = $this->incrementSlug($check_slug);
            } else {
                $slug = $check_slug;
            }
        } else {
            $slug = $check_slug;
        }

        $blogCategory->name = $request->name;
        $blogCategory->description = $request->description;
        $blogCategory->slug = $slug;
        $blogCategory->status = $request->status;
        $blogCategory->update();
        return response()->json(['message' => 'Blog Category Update successfully', 'blog_category' => $blogCategory]);
    }
    
    public function deleteBlogCategory(Request $request)
    {   
        $id = $request->input('id');
        $blogCategory = BlogCategory::find($id);
        $blogCategory->delete();
        return response()->json(['message' => 'Blog Category Delete successfully']);
    }

    
}
