<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PageSection;
use DB;


class PageSectionController extends Controller
{
    public function pageSectionList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $pageSections = PageSection::where('id',$id)->first();
        if ($pageSections) {
        $pageSections->image = $pageSections->image ? url('/') . '/storage/uploads/page-section/' . $pageSections->image : null;
            }
        }else{
        $pageSections = PageSection::simplePaginate(10);    
        foreach ($pageSections as $list) {
                $list->image = $list->image ? url('/') .'/storage/uploads/page-section/'. $list->image : null;
            }
        }
        return response()->json(['pageSections' => $pageSections], 200);
    }
    
    public function storePageSection(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }

        $check_slug = str_slug($request->name, '-');
        if (PageSection::whereSlug($check_slug)->exists())
        {
            $slug = $this->incrementSlug($check_slug);
        }
        else
        {
            $slug = $check_slug;
        }

        $pageSection = new PageSection();
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'page-section');
            $pageSection->image = $image;
        }
        $pageSection->name = $request->name;
        $pageSection->image_position = $request->image_position;
        $pageSection->slug = $slug;
        $pageSection->description = $request->description;
        $pageSection->status = $request->status;
        $pageSection->save();
        

        return response()->json(['message' => 'Page Section Created Successfully', 'pageSection' => $pageSection]);
    }
    
    public function updatePageSection(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
        $id = $request->input('id');
        $pageSection = PageSection::find($id);
        if (!$pageSection) {
            return response()->json(['error' => 'Page Section not found'], 404);
        }
        $check_slug = str_slug($request->name, '-');
        if ($pageSection->getOriginal('slug') != $check_slug)
        {
            if (PageSection::whereSlug($check_slug)->exists())
            {
                $slug = $this->incrementSlug($check_slug);
            }
            else
            {
                $slug = $check_slug;
            }
        }
        else
        {
            $slug = $check_slug;
        }

        if(!empty($request->image))
        {
            $image = upload_file($request->image,'page-section',$pageSection->image);
            $pageSection->image = $image;
        }
        $pageSection->name = $request->name;
        $pageSection->image_position = $request->image_position;
        $pageSection->slug = $slug;
        $pageSection->description = $request->description;
        $pageSection->status = $request->status;
        $pageSection->update();
        

        return response()->json(['message' => 'Page Section Updated Successfully', 'pageSection' => $pageSection]);
    }
    
    public function deletePageSection(Request $request)
    {
        $id = $request->input('id');
        $pageSection = PageSection::find($id);
        if (!$pageSection) {
            return response()->json([
                    'error' => 'Page Section not found'
                ], 404);
        }
        delete_file('page-section',$pageSection->image);
        $pageSection->delete();
        return response()->json(['message' => 'Page Section Deleted Successfully']);
    }
    
    public function ourjourneyList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $ourjourney = DB::table('ourjourney')->where('id',$id)->first();
        if ($ourjourney) {
        $ourjourney->images = $ourjourney->images ? url('/') . '/storage/uploads/page-section/' . $ourjourney->images : null;
            }
        }else{
        $ourjourney = DB::table('ourjourney')->simplePaginate(10);
        foreach ($ourjourney as $list) {
                $list->images =  $list->images ? url('/') .'/storage/uploads/page-section/'. $list->images : null;
            }
        }
        return response()->json(['ourjourney' => $ourjourney], 200);
    }
    
    public function storeOurjourney(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'year' => 'required',
                'description' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
        
        $data = [
            'year' => $request->post('year'),
            'descriptions' => $request->post('description'),
        ];
        
        if(!empty($request->image)) {
            $image = upload_file($request->image, 'page-section');
            $data['images'] = $image;
        }
        DB::table('ourjourney')->insert($data);
        

       return response()->json(['message' => 'Our Journey Created Successfully']);
    }
    
    public function updateOurjourney(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'year' => 'required',
                'description' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
           return response()->json(['error' => $messages->first()]);
        }
        $ourjourney =DB::table('ourjourney')->where('id', $request->id)->first();
        if (!$ourjourney) {
            return response()->json(['error' => 'Our journey not found'], 404);
        }
        
        $data = [
            'year' => $request->post('year'),
            'descriptions' => $request->post('description'),
        ];
        
        if(!empty($request->image)) {
            $image = upload_file($request->image, 'page-section');
            $data['images'] = $image;
        }
        
        DB::table('ourjourney')
                ->where('id', $request->id)
                ->update($data);

        return response()->json(['message' => 'Our Journey Updated Successfully']);
    }
    
    public function deleteOurjourney(Request $request)
    {   
        $id = $request->input('id');
        $Ourjourney = DB::table('ourjourney')->find($id);
        if (!$Ourjourney) {
            return response()->json([
                    'error' => 'Our journey not found'
                ], 404);
        }
        delete_file('page-section',$Ourjourney->images);
        DB::table('ourjourney')->where('id', $id)->delete();
        
        return response()->json(['message' => 'Our Journey Deleted Successfully']);
    }
    
}
