<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Pages;
use App\Models\PageSection;
use Illuminate\Http\Request;
use DB;

class PagesController extends Controller
{
    public function pagesList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $pages = Pages::where('id',$id)->first();
        if ($pages) {
        $pages->banner_image = $pages->banner_image ? url('/') . '/storage/uploads/page-banner/' . $pages->banner_image : null;
            }
        }else{
        $pages = Pages::simplePaginate(10);
        foreach ($pages as $list) {
                $list->banner_image = $list->banner_image ? url('/') .'/storage/uploads/page-banner/'. $list->banner_image : null;
            }
        }
        return response()->json(['pages' => $pages], 200);
    }
    
    public function storePage(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }

        $check_slug = str_slug($request->name, '-');
        if (Pages::whereSlug($check_slug)->exists())
        {
            $slug = $this->incrementSlug($check_slug);
        }
        else
        {
            $slug = $check_slug;
        }

        $page = new Pages();
        if(!empty($request->banner_image))
        {
            $banner_image = upload_file($request->banner_image,'page-banner');
            $page->banner_image = $banner_image;
        }
        $page->name = $request->name;
        $page->description = $request->description;
        $page->metatitle = $request->metatitle;
        $page->metakeyword = $request->metakeyword;
        $page->metadescription = $request->metadescription;
        $page->team_members = $request->team_members ?? 0;
        $page->partners = $request->partners ?? 0;
        $page->our_journey = $request->our_journey ?? 0;
        $page->career = $request->career;
        $page->faq_categories = $request->faq_categories;
        $page->slug = $slug;
        $page->sections = json_encode($request->sections);
        $page->status = $request->status;
        $page->save();

        return response()->json(['message' => 'Page Created Successfully', 'page' => $page]);
    }
    
    public function updatePage(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
        $id = $request->input('id');
        $page = Pages::find($id);
        if (!$page) {
            return response()->json(['error' => 'Page not found'], 404);
        }
        $check_slug = str_slug($request->name, '-');
        if ($page->getOriginal('slug') != $check_slug)
        {
            if (Pages::whereSlug($check_slug)->exists())
            {
                $slug = $this->incrementSlug($check_slug);
            }
            else
            {
                $slug = $check_slug;
            }
        }
        else
        {
            $slug = $check_slug;
        }

        if(!empty($request->banner_image))
        {
            $banner_image = upload_file($request->banner_image,'page-banner',$page->banner_image);
            $page->banner_image = $banner_image;
        }
        $page->name = $request->name;
        $page->description = $request->description;
        $page->metatitle = $request->metatitle;
        $page->metakeyword = $request->metakeyword;
        $page->metadescription = $request->metadescription;
        $page->team_members = $request->team_members ?? 0;
        $page->partners = $request->partners ?? 0;
        $page->our_journey = $request->our_journey ?? 0;
        $page->career = $request->career;
        $page->faq_categories = $request->faq_categories;
        $page->slug = $slug;
        $page->sections = json_encode($request->sections);
        $page->status = $request->status;
        $page->update();

        return response()->json(['message' => 'Page Updated Successfully', 'page' => $page]);
    }
    
    public function deletePage(Request $request)
    {   
        $id = $request->input('id');
        $page = Pages::find($id);
        if (!$page) {
            return response()->json([
                    'error' => 'Page not found'
                ], 404);
        }
        delete_file('page-banner',$page->banner_image);
        $page->delete();
        return response()->json(['message' => 'Page Deleted Successfully']);
    }
    
}
