<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RoleController extends Controller
{
    public function getAllPermission()
    {
        $permissions = Permission::all();
        $response = [
                'success' => true,
                'data' => $permissions
            ];
            return response()->json($response);
    }
    
    public function getAllrole(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $roles = Role::with(['permissions', 'users'])
            ->where('id',$id)->get();
        }else{
        $roles = Role::with(['permissions', 'users'])
            ->simplePaginate(10);    
        }
        $response = [
                'success' => true,
                'data' => $roles
            ];
            return response()->json($response);
    }
    
    public function storeRole(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|unique:roles',
                'permissions' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->with('error', $messages->first());
        }
        $role = new Role();

        $role->name = $request->name;
        $role->save();

        foreach($request->permissions as $permission_id){
            $permission = Permission::find($permission_id);
            $role->givePermissionTo($permission);
        }
        return response()->json(['message' => 'Role Created Successfully', 'role' => $role]);
    }
    
    public function updateRole(Request $request)
    {   
        $id = $request->id;
        $role = Role::find($id);
        if (!$role) {
            return response()->json(['error' => 'Role not found'], 404);
        }
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|unique:roles,name,' . $role->id . ',id',
                'permissions' => 'required',
            ]
        );
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error', $messages->first());
        }
        $permissions = Permission::all();
        foreach ($permissions as $permission) {
            $role->revokePermissionTo($permission);
        }
        foreach ($request->permissions as $permission_id) {
            $permission = Permission::find($permission_id);
            $role->givePermissionTo($permission);
        }
        $role->name = $request->name;
        $role->update();
        return response()->json(['message' => 'Role updated Successfully', 'role' => $role]);
    }
    
    public function deleteRole(Request $request)
    {
        $id = $request->id;
        $role = Role::where('id', $id)->with(['users', 'permissions'])->first();
        if ($role->users->count() > 0) {
            return redirect()->back()->withInput()->with('error', __('Role is assign to users'));
            return response()->json(['message' => 'Role is assign to users']);
        } else {
            foreach ($role->permissions as $permission) {
                $role->revokePermissionTo($permission);
            }
            $role->delete();
            return response()->json(['message' => 'Role deleted successfully']);
        }
    }
    
}
