<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use App\Models\User;


class StaffController extends Controller
{
    public function createStaff(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
                'email' => 'required|string|email|max:255|unique:users',
                'password' => 'required|string|min:6',
                'role' => 'required',
                // 'image' => [
                //     'mimes:jpeg,png,jpg|max:20480',
                // ],
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
    
        $user = new User();
        $user->name = $request->input('name');
        $user->email = $request->input('email');
        $user->phone_no = $request->input('phone_no');
        $user->password = Hash::make($request->input('password'));
        // $user->created_by = auth()->id();
        $user->status = 1;
        $user->type = 'Staff';
    
        if ($request->hasFile('image')) {
            $profile = upload_file($request->file('image'), 'profile');
            $user->profile = $profile;
        }
    
        $user->save();
    
        $role = Role::find($request->role);
        $user->assignRole($role);
    
        return response()->json(['message' => 'Staff created successfully', 'user' => $user]);
    }
    
    public function updateStaff(Request $request)
    {
        $id = $request->input('id');
        $user = User::find($id);
        
        $validator = \Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users,email,' . $user->id,
            'role' => 'required',
            // 'image' => [
            //     'sometimes',
            //     'nullable',
            //     'mimes:jpeg,png,jpg',
            //     'max:20480',
            // ],
        ]);
    
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        
    
        if (!$user) {
            return response()->json(['error' => 'User not found'], 404);
        }
    
        if ($request->hasFile('image')) {
            $profile = upload_file($request->file('image'), 'profile', $user->profile);
            $user->profile = $profile;
        }
    
        $user->name = $request->input('name');
        $user->email = $request->input('email');
        $user->phone_no = $request->input('phone_no');
        $user->update();
    
        if ($user->roles()->first()->id != $request->input('role')) {
            $user->removeRole($user->roles()->first()->id);
            $user->assignRole($request->input('role'));
        }
    
        return response()->json(['message' => 'Staff updated successfully', 'user' => $user], 200);
    }
    
    public function deleteStaff(Request $request)
    {
        $id = $request->input('id');
        $user = User::find($id);
        if (!$user) {
            return response()->json([
                    'error' => 'Staff not found'
                ], 404);
        }
        if($user->roles()->count() > 0) {
            $user->removeRole($user->roles()->first());
        }
        delete_file('profile', $user->profile);
        $user->delete();
        return response()->json(['message' => 'Delete Staff successfully'], 200);
    }
    
    public function staffList(Request $request)
    {
        $id = $request->input('id');
        if($id){
            $users = User::where('type','Staff')->where('id',$id)->first();
            if ($users) {
        $users->profile = $users->profile ? url('/') . '/storage/uploads/profile/' . $users->profile : null;
            }
        }
        else{
            $users = User::where('type','Staff')->simplePaginate(10);
            foreach ($users as $list) {
                $list->profile = $list->profile ? url('/') .'/storage/uploads/profile/'. $list->profile : null;
            }
        }
        
        return response()->json(['users' => $users], 200);
    }

}
