<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TeamMembers;


class TeamMembersController extends Controller
{
    public function teamMembersList(Request $request)
    {
        $id = $request->input('id');
        $department = $request->input('department');
        if($id){
        $teamMembers = TeamMembers::where('type','team-member')->where('id',$id)->first();
        if ($teamMembers) {
        $teamMembers->image = $teamMembers->image ? url('/') . '/storage/uploads/team-members/' . $teamMembers->image : null;
            }
        }else if($department){
        $teamMembers = TeamMembers::where('type','team-member')->where('department',$department)->simplePaginate(10);  
        foreach ($teamMembers as $list) {
                $list->image = $list->image ? url('/') .'/storage/uploads/team-member/'. $list->image : null;
            }    
        }else{
        $teamMembers = TeamMembers::where('type','team-member')->simplePaginate(10);  
        foreach ($teamMembers as $list) {
                $list->image = $list->image ? url('/') .'/storage/uploads/team-member/'. $list->image : null;
            }
        }
        return response()->json(['teamMembers' => $teamMembers], 200);
    }
    
    public function storeTeamMember(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
                'designation' => 'required|string|max:255',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }


        $teamMember = new TeamMembers();
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'team-members');
            $teamMember->image = $image;
        }
        $teamMember->name = $request->name;
        $teamMember->type = 'team-member';
        $teamMember->designation = $request->designation;
        $teamMember->department = $request->department;
        $teamMember->description = $request->description;
        $teamMember->status = $request->status;
        $teamMember->save();

        return response()->json(['message' => 'Team Member Added Successfully', 'teamMember' => $teamMember]);
    }
    
    public function updateTeamMember(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
                'designation' => 'required|string|max:255',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }

        $id = $request->input('id');
        $teamMember = TeamMembers::find($id);
        if (!$teamMember) {
            return response()->json(['error' => 'Team Member not found'], 404);
        }
        
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'team-members',$teamMember->image);
            $teamMember->image = $image;
        }
        $teamMember->name = $request->name;
        $teamMember->designation = $request->designation;
        $teamMember->department = $request->department;
        $teamMember->description = $request->description;
        $teamMember->status = $request->status;
        $teamMember->update();

        return response()->json(['message' => 'Team Member Updated Successfully', 'teamMember' => $teamMember]);
    }
    
    public function deleteTeamMember(Request $request)
    {
        $id = $request->input('id');
        $teamMember = TeamMembers::find($id);
        if (!$teamMember) {
            return response()->json([
                    'error' => 'Team Member not found'
                ], 404);
        }
        delete_file('team-members',$teamMember->image);
        $teamMember->delete();
        return redirect()->back()->with('success','Page Deleted Successfully');
    }
}
