<?php

namespace App\Http\Controllers\Api\v2;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Offices;


class OfficesController extends Controller
{
    public function OfficesList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $offices = Offices::where('id',$id)->get();
        }else{
        if($request->input('perpage') > 0){
        $offices = Offices::simplePaginate($request->input('perpage'));
        }else{
        $offices = Offices::get();    
        }
        }
        foreach($offices as $office){
            $office->image = get_file('office', $office->image);
        }
        return response()->json(['offices' => $offices], 200);
    }
    
    public function storeOffices(Request $request)
    {

        $validator = \Validator::make(
            $request->all(), [
                'country' => 'required',
                'company_name' => 'required',
                'address' => 'required',
                'web_url' => 'required',
                'status' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
             return response()->json(['error' => $messages->first()]);
        }

        $office = new Offices();
        $office->country = $request->country;
        $office->company_name = $request->company_name;
        $office->trade_id = $request->trade_id;
        $office->address = $request->address;
        $office->phone = $request->phone;
        $office->mobile = $request->mobile;
        $office->whatsapp = $request->whatsapp;
        $office->email = $request->email;
        $office->web_url = $request->web_url;
        $office->status = $request->status;
        $office->save();

        return response()->json(['message' => 'Office Created Successfully', 'office' => $office]);
    }
    
    public function updateOffices(Request $request)
    {

        $validator = \Validator::make(
            $request->all(), [
                'country' => 'required',
                'company_name' => 'required',
                'address' => 'required',
                'web_url' => 'required',
                'status' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
        
        $id = $request->input('id');
        $office = Offices::find($id);
        if (!$office) {
            return response()->json(['error' => 'Office not found'], 404);
        }
        $office->country = $request->country;
        $office->company_name = $request->company_name;
        $office->trade_id = $request->trade_id;
        $office->address = $request->address;
        $office->phone = $request->phone;
        $office->mobile = $request->mobile;
        $office->whatsapp = $request->whatsapp;
        $office->email = $request->email;
        $office->web_url = $request->web_url;
        $office->status = $request->status;
        $office->update();

        return response()->json(['message' => 'Office Updated Successfully', 'office' => $office]);
    }
    
    public function deleteOffices(Request $request)
    {
        $id = $request->input('id');
        $office = Offices::find($id);
        if (!$office) {
            return response()->json([
                    'error' => 'Page not found'
                ], 404);
        }
        $office->delete();
        return response()->json(['message' => 'Office Deleted Successfully']);
    }
    
}
