<?php

namespace App\Http\Controllers\Api\v2;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Models\BlogCategory;
use App\Models\ContactUs;
use App\Models\HeroSection;
use App\Models\Menu;
use App\Models\PageSection;
use Illuminate\Http\Request;
use App\Models\MenuItem;
use App\Models\Pages;
use App\Http\Resources\MenuItemResource;
use DB;

class SiteController extends Controller
{
    public function settings()
    {
        $settings = get_all_setting();
        $data = [
            'app_name' => $settings['app_name'],
            'footer_text' => $settings['footer_text_site'],
            'social_link_x' => $settings['social_link_x'],
            'social_link_youtube' => $settings['social_link_youtube'],
            'social_link_facebook' => $settings['social_link_facebook'],
            'social_link_linkedin' => $settings['social_link_linkedin'],
            'logo' => get_logo(),
            'favicon' => get_favicon(),
        ];
        return response()->json(['status' => 'success','message' => '','data' => $data]);
    }

    public function blogCategory()
    {
        $blogCategories = BlogCategory::where('status',1)->orderBy('name','ASC')->get(['id','name'])->toArray();
        return response()->json(['status' => 'success','message' => '','data' => $blogCategories]);
    }

    public function blogs(Request $request)
    {
        if($request->has('category'))
        {
            $blogsDb = Blog::where('status',1)->where('category_id',$request->category)->orderBy('id','DESC')->get();
        }
        else
        {
            $blogsDb = Blog::where('status',1)->orderBy('id','DESC')->get();
        }

        $blogs = [];
        foreach($blogsDb as $blog)
        {
            array_push($blogs,[
                'id' => $blog->id,
                'thumbnail' => get_file('blog',$blog->thumbnail),
                'slug' => $blog->slug,
                'title' => $blog->title,
                'content' => $blog->content,
                'created_at' => $blog->created_at->format('M d,Y'),
                'created_by' => $blog->user->name,
            ]);
        }

        return response()->json(['status' => 'success','message' => '','data' => $blogs]);
    }
    
    public function blogsv2(Request $request)
    {
        if($request->has('category'))
        {
            $blogsDb = Blog::where('status',1)->where('category_id',$request->category)->orderBy('id','DESC');
        }
        else
        {
            $blogsDb = Blog::where('status',1)->orderBy('id','DESC');
        }
        
        if($request->input('perpage') > 0){
            $blogs = $blogsDb->simplePaginate($request->input('perpage')); 
        }else{
            $blogs = $blogsDb->get();
        }
        
        foreach($blogs as $blog){
            $blog->thumbnail = get_file('blog',$blog->thumbnail);
        }

        return response()->json(['status' => 'success','message' => '','data' => $blogs]);
    }

    public function contactUs(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required',
                'email' => 'required|email',
                'mobile_no' => 'required',
                'enquiry_type' => 'required',
            ]
        );


        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(
                [
                    'status' => 'error',
                    'message' => $messages->first(),
                ]
            );
        }

        $storeArray = [
            'company_name' => $request->company_name,
            'name' => $request->name,
            'email' => $request->email,
            'mobile_no' => $request->mobile_no,
            'country' => $request->country,
            'enquiry_type' => $request->enquiry_type,
        ];

        ContactUs::updateOrCreate(
            [
                'email' => $request->email
            ],$storeArray
        );

        return response()->json(
            [
                'status' => 'success',
                'message' => "Thank you, We'll contact you soon.",
            ]
        );
    }

    public function heroSection()
    {
        $heroSectionDb = HeroSection::orderBy('order','ASC')->get();

        $heroSections = [];
        foreach($heroSectionDb as $hero)
        {
            array_push($heroSections,[
                'image' => get_file('hero-section',$hero->image),
                'title' => $hero->title,
                'description' => $hero->description,
            ]);
        }

        return response()->json(['status' => 'success','message' => '','data' => $heroSections]);
    }
    
    public function getMenuBySlug(Request $request)
    {
        $slug = $request->slug;

        $menu = Menu::where('slug',$slug)->first();
        if($menu)
        {
            $data = [
                'status' => 'success',
                'message' => '',
                'data' => [
                    'slug' => $slug,
                    'name' => $menu->name,
                    'menu_data' => json_decode($menu->data,1),
                ],
            ];

            return response()->json(['status' => 'success', 'message' => '', 'data' => $data]);
        }
        else
        {
            return response()->json(['status' => 'success','message' => 'Menu not found']);
        }
    }
    
    public function getSectionBySlug(Request $request)
    {
        $slug = $request->slug;

        // $pageSection = PageSection::where('slug',$slug)->first();

        // if($pageSection)
        // {
        //     $data = [
        //         'status' => 'success',
        //         'message' => '',
        //         'data' => [
        //             'slug' => $slug,
        //             'name' => $pageSection->name,
        //             'image' => get_file('page-section',$pageSection->image),
        //             'image_position' => $pageSection->image_position,
        //             'content' => $pageSection->description,
        //         ],
        //     ];

        //     return response()->json(['status' => 'success', 'message' => '', 'data' => $data]);
        // }
        // else
        // {
        //     return response()->json(['status' => 'success','message' => 'Page section not found']);
        // }
        
        // $pageSection = Pages::where('slug', $slug)->first();
        // $result['page'] = $pageSection;
        // $result['section'] = [];
        
        // if ($pageSection) {
        //     foreach (json_decode($pageSection->sections, true) as $list) {
        //         $section = PageSection::find($list);
        //         if ($section) {
        //             $result['section'][] = $section;
        //         }
        //     }
        // }

        // if ($pageSection) {
        //     return response()->json([
        //         'status' => 'success',
        //         'message' => '',
        //         'data' => $result,
        //     ]);
        // } else {
        //     return response()->json([
        //         'status' => 'error',
        //         'message' => 'Menu items not found',
        //         'data' => []
        //     ], 404);
        // }
        
        if($slug == 'career'){
            $pageSection = Pages::where('slug', $slug)->first();
        
            $pageSection->banner_image = $pageSection->banner_image ? url('/').'/storage/uploads/page-banner/'.$pageSection->banner_image : null;
            $pageSection->mobile_banner_image = $pageSection->mobile_banner_image ? url('/').'/storage/uploads/page-banner/'.$pageSection->mobile_banner_image : null;
            $result['page'] = $pageSection;
            $pageSection['section_1']  = DB::table('settings')->select('key', 'value')->whereIn('key', ['careers_title', 'careers_subtitle'])->get();
            $pageSection['section_2'] = DB::table('career')->simplePaginate(10);
            $result['page'] = $pageSection;
        }else{
        $pageSection = Pages::where('slug', $slug)->first();
        
        $pageSection->banner_image = $pageSection->banner_image ? url('/').'/storage/uploads/page-banner/'.$pageSection->banner_image : null;
        $pageSection->mobile_banner_image = $pageSection->mobile_banner_image ? url('/').'/storage/uploads/page-banner/'.$pageSection->mobile_banner_image : null;
        $result['page'] = $pageSection;
        $result['section'] = [];
        
        if ($pageSection) {
            foreach (json_decode($pageSection->sections, true) as $index => $list) {
                $section = PageSection::find($list);
                if ($section) {
                    $section->image = $section->image ? url('/').'/storage/uploads/page-section/'.$section->image : null;
                    if($pageSection->faq_categories != null && is_array(json_decode($pageSection->faq_categories))){
                        $faq_categories = json_decode($pageSection->faq_categories);
                        if(isset($faq_categories[$index]) && $faq_categories[$index] != null){
                            $section->faqs =  DB::table('faqs')
                        ->where('faq_category', $faq_categories[$index])->get();
                        }else{
                        $section->faqs = [];
                    }
                    }else{
                        $section->faqs = [];
                    }
                    
                    
                    $result['section'][] = $section;
                    
                }
            }
            
        }
        if ($pageSection->our_journey == 1) {
            $ourjourney = DB::table('ourjourney')->get();
            foreach ($ourjourney as $journey) {
                $journey->images = $journey->images ? url('/') .'/storage/uploads/page-section/'. $journey->images : null;
            }
            $result['section'][]['ourjourney'] = $ourjourney;
        }
        if ($pageSection->partners == 1) {
    $partners = DB::table('team_members')->where('type', 'partners')->where('status', '1')->get();
    foreach ($partners as $partner) {
        $partner->image = $partner->image ? url('/') . '/storage/uploads/partners/' . $partner->image : url('/') . '/storage/uploads/partners/default_profile.png';
    }
    $result['section'][]['partners'] = $partners;
}

        if ($pageSection->team_members == 1) {
    $team_members = DB::table('team_members')->where('type', 'team-member')->where('status', '1')->get();
    foreach ($team_members as $team_member) {
        $team_member->image = $team_member->image ? url('/') . '/storage/uploads/team-members/' . $team_member->image : url('/') . '/storage/uploads/team-members/default_profile.png';
    }
    $result['section'][]['team_members'] = $team_members;
}

        
        if ($pageSection->career != null) {
            $career = DB::table('career')->where('id',$pageSection->career)->first();
            
        }
        
        $pdfs = DB::table('pages_pdf')->where('page_id', $pageSection->id)->get();

        foreach ($pdfs as $pdf) {
            $pdf->pdf_name = $pdf->pdf_name ? url('/storage/uploads/page-pdf/' . $pdf->pdf_name) : null;
        }
        
        $result['pdfs'] = $pdfs;

        }
        
    
        if ($pageSection) {
            return response()->json([
                'status' => 'success',
                'message' => '',
                'data' => $result,
            ]);
        } else {
            return response()->json([
                'status' => 'error',
                'message' => 'Menu items not found',
                'data' => []
            ], 404);
        }
        
    }
    
    public function setImagePath(&$menuItems)
    {
        foreach ($menuItems as &$item) {
            $item->image = $item->image ? url('/') . '/storage/uploads/manu-section/' . $item->image : null;
    
            if ($item->children->isNotEmpty()) {
                $this->setImagePath($item->children);
            }
        }
    }
    
    public function getAllMenus()
    {
        $menuItems = MenuItem::whereNull('parent_id')->with('children')->orderBy('order')->get();
        $this->setImagePath($menuItems);
        if ($menuItems->isNotEmpty()) {
            return response()->json([
                'status' => 'success',
                'message' => '',
                'data' => MenuItemResource::collection($menuItems)
            ]);
        } else {
            return response()->json([
                'status' => 'error',
                'message' => 'Menu items not found',
                'data' => []
            ], 404);
        }
    }
    
    public function enquires(Request $request)
    {
        if($request->input('perpage') > 0){
        $enquires = ContactUs::simplePaginate($request->input('perpage'));
        }else{
        $enquires = ContactUs::get();
        }
        return response()->json(['enquires' => $enquires], 200);
    }
    
    public function getIntouch(Request $request)
    {
        if($request->input('perpage') > 0){
        $gettouch=DB::table('get_in_touch')->simplePaginate($request->input('perpage'));
        }else{
        $gettouch=DB::table('get_in_touch')->get();
        }
         
        return response()->json(['gettouch' => $gettouch], 200);
    }
    
    public function resume(Request $request)
    {
        if($request->input('perpage') > 0){
        $resumetouch=DB::table('resume')->simplePaginate($request->input('perpage'));
        }else{
         $resumetouch=DB::table('resume')->get();
        }
        return response()->json(['resumetouch' => $resumetouch], 200);
    }
}
