<?php

namespace App\Http\Controllers;

use App\Models\FaqCategory;
use Illuminate\Http\Request;
use DB;

class FaqCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        abort_if(auth()->user()->cannot('manage_faq_category'), 404);
        $faqCategories = FaqCategory::all();
        return view('backend.faq-category.index',compact('faqCategories'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        abort_if(auth()->user()->cannot('create_faq_category'), 404);
        return view('backend.faq-category.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        abort_if(auth()->user()->cannot('create_faq_category'), 404);
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|unique:faq_categories',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error', $messages->first());
        }
        $category = new FaqCategory();
        $category->name = $request->name;
        $category->status = $request->status == 'on' ? 1 : 0;
        $category->save();
        return redirect()->back()->withInput()->with('success', __('Category created'));
    }

    /**
     * Display the specified resource.
     */
    public function show(FaqCategory $faqCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(FaqCategory $faqCategory)
    {
        abort_if(auth()->user()->cannot('edit_faq_category'), 404);
        return view('backend.faq-category.edit',compact('faqCategory'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, FaqCategory $faqCategory)
    {
        abort_if(auth()->user()->cannot('edit_faq_category'), 404);
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|unique:faq_categories,name,' . $faqCategory->id,
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error', $messages->first());
        }
        $faqCategory->name = $request->name;
        $faqCategory->status = $request->status == 'on' ? 1 : 0;
        $faqCategory->update();
        return redirect()->back()->withInput()->with('success', __('Category updated'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(FaqCategory $faqCategory)
    {
        abort_if(auth()->user()->cannot('delete_faq_category'), 404);
        $faqCategory->delete();
        return redirect()->back()->withInput()->with('success', __('Category deleted'));
    }

    public function updateStatus(Request $request)
    {
        abort_if(auth()->user()->cannot('edit_faq_category'), 404);
        $faq = FaqCategory::find($request->id);
        $faq->status = $request->status;
        $faq->update();
        return response()->json([
            'status' => 'success',
            'message' => __('Status updated')
        ]);
    }
    
    public function faqindex($fc_id){
        abort_if(auth()->user()->cannot('create_faq'), 404);
        $faqs = DB::table('faqs')->where('faq_category',$fc_id)->get();
        return view('backend.faq-category.faq.index',compact('faqs','fc_id'));
    }
}
