<?php

namespace App\Http\Controllers;

use App\Models\Faq;
use App\Models\FaqCategory;
use Illuminate\Http\Request;

class FaqController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        abort_if(auth()->user()->cannot('manage_faq'), 404);
        $faqs = Faq::all();
        return view('backend.faq.index',compact('faqs'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        abort_if(auth()->user()->cannot('create_faq'), 404);
        $faqCategories = FaqCategory::where('status',1)->orderBy('name','ASC')->get();
        return view('backend.faq.create',compact('faqCategories'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        abort_if(auth()->user()->cannot('create_faq'), 404);
        $validator = \Validator::make(
            $request->all(), [
                'title' => 'required',
                'category' => 'required',
                'description' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error', $messages->first());
        }
        $faq = new Faq();
        $faq->title = $request->title;
        $faq->faq_category = $request->category;
        $faq->description = $request->description;
        $faq->status = $request->status ? 1 : 0;
        $faq->save();
        return redirect()->back()->with('success', __('FAQ created'));
    }

    /**
     * Display the specified resource.
     */
    public function show(Faq $faq)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Faq $faq)
    {
        abort_if(auth()->user()->cannot('edit_faq'), 404);
        $faqCategories = FaqCategory::where('status',1)->orderBy('name','ASC')->get();

        return view('backend.faq.edit',compact('faq','faqCategories'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Faq $faq)
    {
        abort_if(auth()->user()->cannot('edit_faq'), 404);
        $validator = \Validator::make(
            $request->all(), [
                'title' => 'required',
                'description' => 'required',
                // 'category' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error', $messages->first());
        }
        $faq->title = $request->title;
        // $faq->faq_category = $request->category;
        $faq->description = $request->description;
        $faq->status = $request->status ? 1 : 0;
        $faq->update();
        return redirect()->back()->with('success', __('FAQ updated'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Faq $faq)
    {
        abort_if(auth()->user()->cannot('delete_faq'), 404);
        $faq->delete();
        return redirect()->back()->with('success', __('FAQ deleted'));
    }

    public function updateStatus(Request $request)
    {
        abort_if(auth()->user()->cannot('edit_faq'), 404);
        $faq = Faq::find($request->id);
        $faq->status = $request->status;
        $faq->update();
        return response()->json([
            'status' => 'success',
            'message' => __('Status updated')
        ]);
    }
}
