<?php

namespace App\Http\Controllers;

use App\Models\HeroSection;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use DB;

class HeroController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        abort_if(auth()->user()->cannot('manage_blog'), 404);
        $heroSections = HeroSection::orderBy('order','ASC')->get();
        return view('backend.hero-section.index',compact('heroSections'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        abort_if(auth()->user()->cannot('create_blog'), 404);
        $pages = DB::table('pages')->get();
        return view('backend.hero-section.create',compact('pages'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        abort_if(auth()->user()->cannot('create_blog'), 404);
        $heroSection = new HeroSection();
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'hero-section');
            $heroSection->image = $image;
        }

        $order = HeroSection::count();

        $heroSection->order = $order + 1;
        $heroSection->title = $request->title;
        $heroSection->page_id = $request->page_id;
        $heroSection->description = $request->description;
        $heroSection->status = $request->status == 'on' ? 1 : 0;
        $heroSection->save();

        return redirect()->route('hero-section.index')->with('success','Hero Created Successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        abort_if(auth()->user()->cannot('edit_blog'), 404);
        $heroSection = HeroSection::find($id);
        $pages = DB::table('pages')->get();
        return view('backend.hero-section.edit',compact('heroSection','pages'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        abort_if(auth()->user()->cannot('edit_blog'), 404);

        $heroSection = HeroSection::find($id);
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'hero-section',$heroSection->image);
            $heroSection->image = $image;
        }
        $heroSection->title = $request->title;
         $heroSection->page_id = $request->page_id;
        $heroSection->description = $request->description;
        $heroSection->status = $request->status == 'on' ? 1 : 0;
        $heroSection->update();

        return redirect()->route('hero-section.index')->with('success','Hero Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $heroSection = HeroSection::find($id);
        delete_file('hero-section',$heroSection->image);
        $heroSection->delete();
        return redirect()->back()->with('success','Hero Deleted Successfully');
    }
// remove image

public function removeImage(Request $request)
{
    try {
        // Validate the request to ensure 'id' is provided
        $request->validate([
            'id' => 'required',
        ]);

        // Find the HeroSection entry by ID
        $heroSection = HeroSection::find($request->id);

        // Check if the entry exists and has an associated image
        if ($heroSection && $heroSection->image) {
            $imagePath = 'uploads/hero-section/' . $heroSection->image;

            delete_file('hero-section', $heroSection->image);

            // Remove the image path from the database
            $heroSection->image = null;
            $heroSection->save();

            return response()->json(['success' => true, 'message' => 'Image removed successfully.']);
        } else {
            return response()->json(['success' => false, 'message' => 'Hero section or image not found.']);
        }
    } catch (\Exception $e) {
        // Log any exceptions that occur
        Log::error('Error removing image: ' . $e->getMessage());
        return response()->json(['success' => false, 'message' => 'An error occurred while removing the image.']);
    }
}


    public function updateStatus(Request $request)
    {
        abort_if(auth()->user()->cannot('edit_hero_section'), 404);
        $heroSection = HeroSection::find($request->id);
        $heroSection->status = $request->status;
        $heroSection->update();
        return response()->json([
            'status' => 'success',
            'message' => __('Status updated')
        ]);
    }

    public function sort(Request $request)
    {
        foreach($request->order as $key => $heroId)
        {
            HeroSection::where('id',$heroId)->update(['order' => $key + 1]);
        }

        return true;
    }
}
