<?php

namespace App\Http\Controllers;

use App\Models\HeroSection;
use Illuminate\Http\Request;

class HomeSectionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        abort_if(auth()->user()->cannot('manage_blog'), 404);
        $heroSections = HeroSection::orderBy('order','ASC')->get();
        return view('backend.hero-section.index',compact('heroSections'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        abort_if(auth()->user()->cannot('create_blog'), 404);
        return view('backend.hero-section.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        abort_if(auth()->user()->cannot('create_blog'), 404);
        $heroSection = new HeroSection();
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'hero-section');
            $heroSection->image = $image;
        }

        $order = HeroSection::count();

        $heroSection->order = $order + 1;
        $heroSection->title = $request->title;
        $heroSection->description = $request->description;
        $heroSection->status = $request->status == 'on' ? 1 : 0;
        $heroSection->save();

        return redirect()->route('hero-section.index')->with('success','Hero Created Successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        abort_if(auth()->user()->cannot('edit_blog'), 404);
        $heroSection = HeroSection::find($id);
        return view('backend.hero-section.edit',compact('heroSection'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        abort_if(auth()->user()->cannot('edit_blog'), 404);

        $heroSection = HeroSection::find($id);
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'hero-section',$heroSection->image);
            $heroSection->image = $image;
        }
        $heroSection->title = $request->title;
        $heroSection->description = $request->description;
        $heroSection->status = $request->status == 'on' ? 1 : 0;
        $heroSection->update();

        return redirect()->route('hero-section.index')->with('success','Hero Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $heroSection = HeroSection::find($id);
        delete_file('hero-section',$heroSection->image);
        $heroSection->delete();
        return redirect()->back()->with('success','Hero Deleted Successfully');
    }

    public function updateStatus(Request $request)
    {
        abort_if(auth()->user()->cannot('edit_hero_section'), 404);
        $heroSection = HeroSection::find($request->id);
        $heroSection->status = $request->status;
        $heroSection->update();
        return response()->json([
            'status' => 'success',
            'message' => __('Status updated')
        ]);
    }

    public function sort(Request $request)
    {
        foreach($request->order as $key => $heroId)
        {
            HeroSection::where('id',$heroId)->update(['order' => $key + 1]);
        }

        return true;
    }
}
