<?php

namespace App\Http\Controllers;

use App\Models\TeamMembers;
use Illuminate\Http\Request;

class PartnersController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        abort_if(auth()->user()->cannot('manage_partners'), 404);
        $teamMembers = TeamMembers::where('type','partners')->get();
        return view('backend.partners.index',compact('teamMembers'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        abort_if(auth()->user()->cannot('create_partners'), 404);
        return view('backend.partners.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        abort_if(auth()->user()->cannot('create_partners'), 404);
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
                'designation' => 'required|string|max:255',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error',$messages->first());
        }


        $teamMember = new TeamMembers();
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'partners');
            $teamMember->image = $image;
        }
        $teamMember->name = $request->name;
        $teamMember->type = 'partners';
        $teamMember->designation = $request->designation;
        $teamMember->description = $request->description;
        $teamMember->status = $request->status == 'on' ? 1 : 0;
        $teamMember->save();

        return redirect()->route('partners.index')->with('success','Partners Added Successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(TeamMembers $teamMembers)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        abort_if(auth()->user()->cannot('edit_partners'), 404);
        $teamMember = TeamMembers::find($id);
        return view('backend.partners.edit',compact('teamMember'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        abort_if(auth()->user()->cannot('edit_partners'), 404);
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
                'designation' => 'required|string|max:255',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error',$messages->first());
        }

        $teamMember = TeamMembers::find($id);

        if(!empty($request->image))
        {
            $image = upload_file($request->image,'partners',$teamMember->image);
            $teamMember->image = $image;
        }
        $teamMember->name = $request->name;
        $teamMember->designation = $request->designation;
        $teamMember->description = $request->description;
        $teamMember->status = $request->status == 'on' ? 1 : 0;
        $teamMember->update();

        return redirect()->route('partners.index')->with('success','Partners Updated Successfully');
    }
    
    
    public function removeImage(Request $request)
{
    try {
        // Validate the request to ensure 'id' is provided
        $request->validate([
            'id' => 'required',
        ]);

        // Find the TeamMember entry by ID using the TeamMembers model
        $teamMember = TeamMembers::find($request->id);

        // Check if the entry exists and has an associated image
        if ($teamMember && $teamMember->image) {
            $imagePath = 'uploads/partners/' . $teamMember->image;

            // Use a helper function to delete the image file
            delete_file('partners',$teamMember->image);

            // Remove the image path from the database
            $teamMember->image = null;
            $teamMember->save();

            return response()->json(['success' => true, 'message' => 'Image removed successfully.']);
        } else {
            return response()->json(['success' => false, 'message' => 'Team member or image not found.']);
        }
    } catch (\Exception $e) {
        // Log any exceptions that occur
        Log::error('Error removing image: ' . $e->getMessage());
        return response()->json(['success' => false, 'message' => 'An error occurred while removing the image.']);
    }
}

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        abort_if(auth()->user()->cannot('delete_partners'), 404);
        $teamMember = TeamMembers::find($id);
        delete_file('partners',$teamMember->image);
        $teamMember->delete();
        return redirect()->back()->with('success','Partners Deleted Successfully');
    }

    public function updateStatus(Request $request)
    {
        abort_if(auth()->user()->cannot('edit_partners'), 404);
        $pages = TeamMembers::find($request->id);
        $pages->status = $request->status;
        $pages->update();
        return response()->json([
            'status' => 'success',
            'message' => __('Status updated')
        ]);
    }
}
