<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Log;

class TestimonialController extends Controller
{
    public function index()
    {
        $testimonial = DB::table('testimonial')->get();
        return view('backend.testimonial.index',compact('testimonial'));
    }
    
    public function manage_testimonial(Request $request, $id = '')
    {
        if ($id > 0) {
            $testimonial = DB::table('testimonial')->where('id', $id)->first();
            $result['name'] = $testimonial->name;
            $result['designation'] = $testimonial->designation;
            $result['description'] = $testimonial->description;
            $result['status'] = $testimonial->status;
            $result['type'] = $testimonial->type;
            $result['image'] = $testimonial->image;
            $result['id'] = $testimonial->id;
        } else {
            $result['name'] = "";
            $result['designation'] = "";
            $result['description'] = "";
            $result['image'] = "";
            $result['status'] = "";
            $result['type'] = "";
            $result['id'] = "";
        }
        return view('backend.testimonial.create', $result);
    }
    
    public function store(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required',
                'designation' => 'required',
                'description' => 'required',
                'type' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error',$messages->first());
        }
        
        $data = [
            'name' => $request->post('name'),
            'designation' => $request->post('designation'),
            'description' => $request->post('description'),
            'type' => $request->post('type'),
            'status' => $request->post('status') == 'on' ? 1 : 0,
        ];
            
        if(!empty($request->image)) {
            $image = upload_file($request->image, 'testimonial');
            $data['image'] = $image;
        }
        
        if ($request->id > 0) {
            DB::table('testimonial')
                ->where('id', $request->id)
                ->update($data);
            $msg = "Testimonial Updated Successfully";
        } else {
            if(empty($request->image)) {
                $data['image'] = ''; 
            }
            DB::table('testimonial')->insert($data);
            $msg = "Testimonial Created Successfully";
        }

        return redirect()->back()->with('success', $msg);
    }
    
    public function removeImage(Request $request)
{
    try {
        // Validate the request to ensure 'id' is provided
        $request->validate([
            'id' => 'required',
        ]);

        // Find the TeamMember entry by ID using the TeamMembers model
         $testimonial = DB::table('testimonial')->where('id', $request->id)->first();

        // Check if the entry exists and has an associated image
        if ($testimonial && $testimonial->image) {
            $imagePath = 'uploads/testimonial/' . $testimonial->image;

            // Use a helper function to delete the image file
            delete_file('testimonial', $testimonial->image);

            // Remove the image path from the database
            DB::table('testimonial')
                ->where('id', $request->id)
                ->update(['image' => null]);

            return response()->json(['success' => true, 'message' => 'Image removed successfully.']);
        } else {
            return response()->json(['success' => false, 'message' => 'Team member or image not found.']);
        }
    } catch (\Exception $e) {
        // Log any exceptions that occur
        Log::error('Error removing image: ' . $e->getMessage());
        return response()->json(['success' => false, 'message' => 'An error occurred while removing the image.']);
    }
}
    
    
    public function delete_testimonial($id)
    {   
        $testimonial = DB::table('testimonial')->where('id', $id)->first();

        if ($testimonial) {
            delete_file('testimonial', $testimonial->image);
            DB::table('testimonial')->where('id', $id)->delete();
            return redirect()->back()->with('success', 'Testimonial Deleted Successfully');
        } else {
            return redirect()->back()->with('error', 'Testimonial Not Found');
        }

    }
}
