<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MenuItemResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'url' => $this->url,
            'parent_id' => $this->parent_id,
            'order' => $this->order,
            'children' => MenuItemResource::collection($this->whenLoaded('children')),
        ];
    }
}
