/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./resources/assets/core/js/custom/apps/file-manager/list.js":
/*!*******************************************************************!*\
  !*** ./resources/assets/core/js/custom/apps/file-manager/list.js ***!
  \*******************************************************************/
/***/ (() => {

eval("\n\n// Class definition\nvar KTFileManagerList = function () {\n  // Define shared variables\n  var datatable;\n  var table;\n\n  // Define template element variables\n  var uploadTemplate;\n  var renameTemplate;\n  var actionTemplate;\n  var checkboxTemplate;\n\n  // Private functions\n  var initTemplates = function initTemplates() {\n    uploadTemplate = document.querySelector('[data-kt-filemanager-template=\"upload\"]');\n    renameTemplate = document.querySelector('[data-kt-filemanager-template=\"rename\"]');\n    actionTemplate = document.querySelector('[data-kt-filemanager-template=\"action\"]');\n    checkboxTemplate = document.querySelector('[data-kt-filemanager-template=\"checkbox\"]');\n  };\n  var initDatatable = function initDatatable() {\n    // Set date data order\n    var tableRows = table.querySelectorAll('tbody tr');\n    tableRows.forEach(function (row) {\n      var dateRow = row.querySelectorAll('td');\n      var dateCol = dateRow[3]; // select date from 4th column in table\n      var realDate = moment(dateCol.innerHTML, \"DD MMM YYYY, LT\").format();\n      dateCol.setAttribute('data-order', realDate);\n    });\n    var foldersListOptions = {\n      \"info\": false,\n      'order': [],\n      \"scrollY\": \"700px\",\n      \"scrollCollapse\": true,\n      \"paging\": false,\n      'ordering': false,\n      'columns': [{\n        data: 'checkbox'\n      }, {\n        data: 'name'\n      }, {\n        data: 'size'\n      }, {\n        data: 'date'\n      }, {\n        data: 'action'\n      }],\n      'language': {\n        emptyTable: \"<div class=\\\"d-flex flex-column flex-center\\\">\\n                    <img src=\\\"\".concat(hostUrl, \"media/illustrations/sketchy-1/5.png\\\" class=\\\"mw-400px\\\" />\\n                    <div class=\\\"fs-1 fw-bolder text-dark\\\">No items found.</div>\\n                    <div class=\\\"fs-6\\\">Start creating new folders or uploading a new file!</div>\\n                </div>\")\n      }\n    };\n    var filesListOptions = {\n      \"info\": false,\n      'order': [],\n      'pageLength': 10,\n      \"lengthChange\": false,\n      'ordering': false,\n      'columns': [{\n        data: 'checkbox'\n      }, {\n        data: 'name'\n      }, {\n        data: 'size'\n      }, {\n        data: 'date'\n      }, {\n        data: 'action'\n      }],\n      'language': {\n        emptyTable: \"<div class=\\\"d-flex flex-column flex-center\\\">\\n                    <img src=\\\"\".concat(hostUrl, \"media/illustrations/sketchy-1/5.png\\\" class=\\\"mw-400px\\\" />\\n                    <div class=\\\"fs-1 fw-bolder text-dark mb-4\\\">No items found.</div>\\n                    <div class=\\\"fs-6\\\">Start creating new folders or uploading a new file!</div>\\n                </div>\")\n      },\n      conditionalPaging: true\n    };\n\n    // Define datatable options to load\n    var loadOptions;\n    if (table.getAttribute('data-kt-filemanager-table') === 'folders') {\n      loadOptions = foldersListOptions;\n    } else {\n      loadOptions = filesListOptions;\n    }\n\n    // Init datatable --- more info on datatables: https://datatables.net/manual/\n    datatable = $(table).DataTable(loadOptions);\n\n    // Re-init functions on every table re-draw -- more info: https://datatables.net/reference/event/draw\n    datatable.on('draw', function () {\n      initToggleToolbar();\n      handleDeleteRows();\n      toggleToolbars();\n      resetNewFolder();\n      KTMenu.createInstances();\n      initCopyLink();\n      countTotalItems();\n      handleRename();\n    });\n  };\n\n  // Search Datatable --- official docs reference: https://datatables.net/reference/api/search()\n  var handleSearchDatatable = function handleSearchDatatable() {\n    var filterSearch = document.querySelector('[data-kt-filemanager-table-filter=\"search\"]');\n    filterSearch.addEventListener('keyup', function (e) {\n      datatable.search(e.target.value).draw();\n    });\n  };\n\n  // Delete customer\n  var handleDeleteRows = function handleDeleteRows() {\n    // Select all delete buttons\n    var deleteButtons = table.querySelectorAll('[data-kt-filemanager-table-filter=\"delete_row\"]');\n    deleteButtons.forEach(function (d) {\n      // Delete button on click\n      d.addEventListener('click', function (e) {\n        e.preventDefault();\n\n        // Select parent row\n        var parent = e.target.closest('tr');\n\n        // Get customer name\n        var fileName = parent.querySelectorAll('td')[1].innerText;\n\n        // SweetAlert2 pop up --- official docs reference: https://sweetalert2.github.io/\n        Swal.fire({\n          text: \"Are you sure you want to delete \" + fileName + \"?\",\n          icon: \"warning\",\n          showCancelButton: true,\n          buttonsStyling: false,\n          confirmButtonText: \"Yes, delete!\",\n          cancelButtonText: \"No, cancel\",\n          customClass: {\n            confirmButton: \"btn fw-bold btn-danger\",\n            cancelButton: \"btn fw-bold btn-active-light-primary\"\n          }\n        }).then(function (result) {\n          if (result.value) {\n            Swal.fire({\n              text: \"You have deleted \" + fileName + \"!.\",\n              icon: \"success\",\n              buttonsStyling: false,\n              confirmButtonText: \"Ok, got it!\",\n              customClass: {\n                confirmButton: \"btn fw-bold btn-primary\"\n              }\n            }).then(function () {\n              // Remove current row\n              datatable.row($(parent)).remove().draw();\n            });\n          } else if (result.dismiss === 'cancel') {\n            Swal.fire({\n              text: customerName + \" was not deleted.\",\n              icon: \"error\",\n              buttonsStyling: false,\n              confirmButtonText: \"Ok, got it!\",\n              customClass: {\n                confirmButton: \"btn fw-bold btn-primary\"\n              }\n            });\n          }\n        });\n      });\n    });\n  };\n\n  // Init toggle toolbar\n  var initToggleToolbar = function initToggleToolbar() {\n    // Toggle selected action toolbar\n    // Select all checkboxes\n    var checkboxes = table.querySelectorAll('[type=\"checkbox\"]');\n    if (table.getAttribute('data-kt-filemanager-table') === 'folders') {\n      checkboxes = document.querySelectorAll('#kt_file_manager_list_wrapper [type=\"checkbox\"]');\n    }\n\n    // Select elements\n    var deleteSelected = document.querySelector('[data-kt-filemanager-table-select=\"delete_selected\"]');\n\n    // Toggle delete selected toolbar\n    checkboxes.forEach(function (c) {\n      // Checkbox on click event\n      c.addEventListener('click', function () {\n        console.log(c);\n        setTimeout(function () {\n          toggleToolbars();\n        }, 50);\n      });\n    });\n\n    // Deleted selected rows\n    deleteSelected.addEventListener('click', function () {\n      // SweetAlert2 pop up --- official docs reference: https://sweetalert2.github.io/\n      Swal.fire({\n        text: \"Are you sure you want to delete selected files or folders?\",\n        icon: \"warning\",\n        showCancelButton: true,\n        buttonsStyling: false,\n        confirmButtonText: \"Yes, delete!\",\n        cancelButtonText: \"No, cancel\",\n        customClass: {\n          confirmButton: \"btn fw-bold btn-danger\",\n          cancelButton: \"btn fw-bold btn-active-light-primary\"\n        }\n      }).then(function (result) {\n        if (result.value) {\n          Swal.fire({\n            text: \"You have deleted all selected  files or folders!.\",\n            icon: \"success\",\n            buttonsStyling: false,\n            confirmButtonText: \"Ok, got it!\",\n            customClass: {\n              confirmButton: \"btn fw-bold btn-primary\"\n            }\n          }).then(function () {\n            // Remove all selected customers\n            checkboxes.forEach(function (c) {\n              if (c.checked) {\n                datatable.row($(c.closest('tbody tr'))).remove().draw();\n              }\n            });\n\n            // Remove header checked box\n            var headerCheckbox = table.querySelectorAll('[type=\"checkbox\"]')[0];\n            headerCheckbox.checked = false;\n          });\n        } else if (result.dismiss === 'cancel') {\n          Swal.fire({\n            text: \"Selected  files or folders was not deleted.\",\n            icon: \"error\",\n            buttonsStyling: false,\n            confirmButtonText: \"Ok, got it!\",\n            customClass: {\n              confirmButton: \"btn fw-bold btn-primary\"\n            }\n          });\n        }\n      });\n    });\n  };\n\n  // Toggle toolbars\n  var toggleToolbars = function toggleToolbars() {\n    // Define variables\n    var toolbarBase = document.querySelector('[data-kt-filemanager-table-toolbar=\"base\"]');\n    var toolbarSelected = document.querySelector('[data-kt-filemanager-table-toolbar=\"selected\"]');\n    var selectedCount = document.querySelector('[data-kt-filemanager-table-select=\"selected_count\"]');\n\n    // Select refreshed checkbox DOM elements \n    var allCheckboxes = table.querySelectorAll('tbody [type=\"checkbox\"]');\n\n    // Detect checkboxes state & count\n    var checkedState = false;\n    var count = 0;\n\n    // Count checked boxes\n    allCheckboxes.forEach(function (c) {\n      if (c.checked) {\n        checkedState = true;\n        count++;\n      }\n    });\n\n    // Toggle toolbars\n    if (checkedState) {\n      selectedCount.innerHTML = count;\n      toolbarBase.classList.add('d-none');\n      toolbarSelected.classList.remove('d-none');\n    } else {\n      toolbarBase.classList.remove('d-none');\n      toolbarSelected.classList.add('d-none');\n    }\n  };\n\n  // Handle new folder\n  var handleNewFolder = function handleNewFolder() {\n    // Select button\n    var newFolder = document.getElementById('kt_file_manager_new_folder');\n\n    // Handle click action\n    newFolder.addEventListener('click', function (e) {\n      e.preventDefault();\n\n      // Ignore if input already exist\n      if (table.querySelector('#kt_file_manager_new_folder_row')) {\n        return;\n      }\n\n      // Add new blank row to datatable\n      var tableBody = table.querySelector('tbody');\n      var rowElement = uploadTemplate.cloneNode(true); // Clone template markup\n      tableBody.prepend(rowElement);\n\n      // Define template interactive elements\n      var rowForm = rowElement.querySelector('#kt_file_manager_add_folder_form');\n      var rowButton = rowElement.querySelector('#kt_file_manager_add_folder');\n      var cancelButton = rowElement.querySelector('#kt_file_manager_cancel_folder');\n      var folderIcon = rowElement.querySelector('.svg-icon-2x');\n      var rowInput = rowElement.querySelector('[name=\"new_folder_name\"]');\n\n      // Define validator\n      // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/\n      var validator = FormValidation.formValidation(rowForm, {\n        fields: {\n          'new_folder_name': {\n            validators: {\n              notEmpty: {\n                message: 'Folder name is required'\n              }\n            }\n          }\n        },\n        plugins: {\n          trigger: new FormValidation.plugins.Trigger(),\n          bootstrap: new FormValidation.plugins.Bootstrap5({\n            rowSelector: '.fv-row',\n            eleInvalidClass: '',\n            eleValidClass: ''\n          })\n        }\n      });\n\n      // Handle add new folder button\n      rowButton.addEventListener('click', function (e) {\n        e.preventDefault();\n\n        // Activate indicator\n        rowButton.setAttribute(\"data-kt-indicator\", \"on\");\n\n        // Validate form before submit\n        if (validator) {\n          validator.validate().then(function (status) {\n            console.log('validated!');\n            if (status == 'Valid') {\n              // Simulate process for demo only\n              setTimeout(function () {\n                var _folderLink$classList;\n                // Create folder link\n                var folderLink = document.createElement('a');\n                var folderLinkClasses = ['text-gray-800', 'text-hover-primary'];\n                folderLink.setAttribute('href', '?page=apps/file-manager/blank');\n                (_folderLink$classList = folderLink.classList).add.apply(_folderLink$classList, folderLinkClasses);\n                folderLink.innerText = rowInput.value;\n                var newRow = datatable.row.add({\n                  'checkbox': checkboxTemplate.innerHTML,\n                  'name': folderIcon.outerHTML + folderLink.outerHTML,\n                  \"size\": '-',\n                  \"date\": '-',\n                  'action': actionTemplate.innerHTML\n                }).node();\n                $(newRow).find('td').eq(4).attr('data-kt-filemanager-table', 'action_dropdown');\n                $(newRow).find('td').eq(4).addClass('text-end'); // Add custom class to last 'td' element --- more info: https://datatables.net/forums/discussion/22341/row-add-cell-class\n\n                // Re-sort datatable to allow new folder added at the top\n                var index = datatable.row(0).index(),\n                  rowCount = datatable.data().length - 1,\n                  insertedRow = datatable.row(rowCount).data(),\n                  tempRow;\n                for (var i = rowCount; i > index; i--) {\n                  tempRow = datatable.row(i - 1).data();\n                  datatable.row(i).data(tempRow);\n                  datatable.row(i - 1).data(insertedRow);\n                }\n                toastr.options = {\n                  \"closeButton\": true,\n                  \"debug\": false,\n                  \"newestOnTop\": false,\n                  \"progressBar\": false,\n                  \"positionClass\": \"toastr-top-right\",\n                  \"preventDuplicates\": false,\n                  \"showDuration\": \"300\",\n                  \"hideDuration\": \"1000\",\n                  \"timeOut\": \"5000\",\n                  \"extendedTimeOut\": \"1000\",\n                  \"showEasing\": \"swing\",\n                  \"hideEasing\": \"linear\",\n                  \"showMethod\": \"fadeIn\",\n                  \"hideMethod\": \"fadeOut\"\n                };\n                toastr.success(rowInput.value + ' was created!');\n\n                // Disable indicator\n                rowButton.removeAttribute(\"data-kt-indicator\");\n\n                // Reset input\n                rowInput.value = '';\n                datatable.draw(false);\n              }, 2000);\n            } else {\n              // Disable indicator\n              rowButton.removeAttribute(\"data-kt-indicator\");\n            }\n          });\n        }\n      });\n\n      // Handle cancel new folder button\n      cancelButton.addEventListener('click', function (e) {\n        e.preventDefault();\n\n        // Activate indicator\n        cancelButton.setAttribute(\"data-kt-indicator\", \"on\");\n        setTimeout(function () {\n          // Disable indicator\n          cancelButton.removeAttribute(\"data-kt-indicator\");\n\n          // Toggle toastr\n          toastr.options = {\n            \"closeButton\": true,\n            \"debug\": false,\n            \"newestOnTop\": false,\n            \"progressBar\": false,\n            \"positionClass\": \"toastr-top-right\",\n            \"preventDuplicates\": false,\n            \"showDuration\": \"300\",\n            \"hideDuration\": \"1000\",\n            \"timeOut\": \"5000\",\n            \"extendedTimeOut\": \"1000\",\n            \"showEasing\": \"swing\",\n            \"hideEasing\": \"linear\",\n            \"showMethod\": \"fadeIn\",\n            \"hideMethod\": \"fadeOut\"\n          };\n          toastr.error('Cancelled new folder creation');\n          resetNewFolder();\n        }, 1000);\n      });\n    });\n  };\n\n  // Reset add new folder input\n  var resetNewFolder = function resetNewFolder() {\n    var newFolderRow = table.querySelector('#kt_file_manager_new_folder_row');\n    if (newFolderRow) {\n      newFolderRow.parentNode.removeChild(newFolderRow);\n    }\n  };\n\n  // Handle rename file or folder\n  var handleRename = function handleRename() {\n    var renameButton = table.querySelectorAll('[data-kt-filemanager-table=\"rename\"]');\n    renameButton.forEach(function (button) {\n      button.addEventListener('click', renameCallback);\n    });\n  };\n\n  // Rename callback\n  var renameCallback = function renameCallback(e) {\n    e.preventDefault();\n\n    // Define shared value\n    var nameValue;\n\n    // Stop renaming if there's an input existing\n    if (table.querySelectorAll('#kt_file_manager_rename_input').length > 0) {\n      Swal.fire({\n        text: \"Unsaved input detected. Please save or cancel the current item\",\n        icon: \"warning\",\n        buttonsStyling: false,\n        confirmButtonText: \"Ok, got it!\",\n        customClass: {\n          confirmButton: \"btn fw-bold btn-danger\"\n        }\n      });\n      return;\n    }\n\n    // Select parent row\n    var parent = e.target.closest('tr');\n\n    // Get name column\n    var nameCol = parent.querySelectorAll('td')[1];\n    var colIcon = nameCol.querySelector('.svg-icon');\n    nameValue = nameCol.innerText;\n\n    // Set rename input template\n    var renameInput = renameTemplate.cloneNode(true);\n    renameInput.querySelector('#kt_file_manager_rename_folder_icon').innerHTML = colIcon.outerHTML;\n\n    // Swap current column content with input template\n    nameCol.innerHTML = renameInput.innerHTML;\n\n    // Set input value with current file/folder name\n    parent.querySelector('#kt_file_manager_rename_input').value = nameValue;\n\n    // Rename file / folder validator\n    var renameValidator = FormValidation.formValidation(nameCol, {\n      fields: {\n        'rename_folder_name': {\n          validators: {\n            notEmpty: {\n              message: 'Name is required'\n            }\n          }\n        }\n      },\n      plugins: {\n        trigger: new FormValidation.plugins.Trigger(),\n        bootstrap: new FormValidation.plugins.Bootstrap5({\n          rowSelector: '.fv-row',\n          eleInvalidClass: '',\n          eleValidClass: ''\n        })\n      }\n    });\n\n    // Rename input button action\n    var renameInputButton = document.querySelector('#kt_file_manager_rename_folder');\n    renameInputButton.addEventListener('click', function (e) {\n      e.preventDefault();\n\n      // Detect if valid\n      if (renameValidator) {\n        renameValidator.validate().then(function (status) {\n          console.log('validated!');\n          if (status == 'Valid') {\n            // Pop up confirmation\n            Swal.fire({\n              text: \"Are you sure you want to rename \" + nameValue + \"?\",\n              icon: \"warning\",\n              showCancelButton: true,\n              buttonsStyling: false,\n              confirmButtonText: \"Yes, rename it!\",\n              cancelButtonText: \"No, cancel\",\n              customClass: {\n                confirmButton: \"btn fw-bold btn-danger\",\n                cancelButton: \"btn fw-bold btn-active-light-primary\"\n              }\n            }).then(function (result) {\n              if (result.value) {\n                Swal.fire({\n                  text: \"You have renamed \" + nameValue + \"!.\",\n                  icon: \"success\",\n                  buttonsStyling: false,\n                  confirmButtonText: \"Ok, got it!\",\n                  customClass: {\n                    confirmButton: \"btn fw-bold btn-primary\"\n                  }\n                }).then(function () {\n                  // Get new file / folder name value\n                  var newValue = document.querySelector('#kt_file_manager_rename_input').value;\n\n                  // New column data template\n                  var newData = \"<div class=\\\"d-flex align-items-center\\\">\\n                                        \".concat(colIcon.outerHTML, \"\\n                                        <a href=\\\"?page=apps/file-manager/files/\\\" class=\\\"text-gray-800 text-hover-primary\\\">\").concat(newValue, \"</a>\\n                                    </div>\");\n\n                  // Draw datatable with new content -- Add more events here for any server-side events\n                  datatable.cell($(nameCol)).data(newData).draw();\n                });\n              } else if (result.dismiss === 'cancel') {\n                Swal.fire({\n                  text: nameValue + \" was not renamed.\",\n                  icon: \"error\",\n                  buttonsStyling: false,\n                  confirmButtonText: \"Ok, got it!\",\n                  customClass: {\n                    confirmButton: \"btn fw-bold btn-primary\"\n                  }\n                });\n              }\n            });\n          }\n        });\n      }\n    });\n\n    // Cancel rename input\n    var cancelInputButton = document.querySelector('#kt_file_manager_rename_folder_cancel');\n    cancelInputButton.addEventListener('click', function (e) {\n      e.preventDefault();\n\n      // Simulate process for demo only\n      cancelInputButton.setAttribute(\"data-kt-indicator\", \"on\");\n      setTimeout(function () {\n        var revertTemplate = \"<div class=\\\"d-flex align-items-center\\\">\\n                    \".concat(colIcon.outerHTML, \"\\n                    <a href=\\\"?page=apps/file-manager/files/\\\" class=\\\"text-gray-800 text-hover-primary\\\">\").concat(nameValue, \"</a>\\n                </div>\");\n\n        // Remove spinner\n        cancelInputButton.removeAttribute(\"data-kt-indicator\");\n\n        // Draw datatable with new content -- Add more events here for any server-side events\n        datatable.cell($(nameCol)).data(revertTemplate).draw();\n\n        // Toggle toastr\n        toastr.options = {\n          \"closeButton\": true,\n          \"debug\": false,\n          \"newestOnTop\": false,\n          \"progressBar\": false,\n          \"positionClass\": \"toastr-top-right\",\n          \"preventDuplicates\": false,\n          \"showDuration\": \"300\",\n          \"hideDuration\": \"1000\",\n          \"timeOut\": \"5000\",\n          \"extendedTimeOut\": \"1000\",\n          \"showEasing\": \"swing\",\n          \"hideEasing\": \"linear\",\n          \"showMethod\": \"fadeIn\",\n          \"hideMethod\": \"fadeOut\"\n        };\n        toastr.error('Cancelled rename function');\n      }, 1000);\n    });\n  };\n\n  // Init dropzone\n  var initDropzone = function initDropzone() {\n    // set the dropzone container id\n    var id = \"#kt_modal_upload_dropzone\";\n    var dropzone = document.querySelector(id);\n\n    // set the preview element template\n    var previewNode = dropzone.querySelector(\".dropzone-item\");\n    previewNode.id = \"\";\n    var previewTemplate = previewNode.parentNode.innerHTML;\n    previewNode.parentNode.removeChild(previewNode);\n    var myDropzone = new Dropzone(id, {\n      // Make the whole body a dropzone\n      url: \"path/to/your/server\",\n      // Set the url for your upload script location\n      parallelUploads: 10,\n      previewTemplate: previewTemplate,\n      maxFilesize: 1,\n      // Max filesize in MB\n      autoProcessQueue: false,\n      // Stop auto upload\n      autoQueue: false,\n      // Make sure the files aren't queued until manually added\n      previewsContainer: id + \" .dropzone-items\",\n      // Define the container to display the previews\n      clickable: id + \" .dropzone-select\" // Define the element that should be used as click trigger to select files.\n    });\n\n    myDropzone.on(\"addedfile\", function (file) {\n      // Hook each start button\n      file.previewElement.querySelector(id + \" .dropzone-start\").onclick = function () {\n        // myDropzone.enqueueFile(file); -- default dropzone function\n\n        // Process simulation for demo only\n        var progressBar = file.previewElement.querySelector('.progress-bar');\n        progressBar.style.opacity = \"1\";\n        var width = 1;\n        var timer = setInterval(function () {\n          if (width >= 100) {\n            myDropzone.emit(\"success\", file);\n            myDropzone.emit(\"complete\", file);\n            clearInterval(timer);\n          } else {\n            width++;\n            progressBar.style.width = width + '%';\n          }\n        }, 20);\n      };\n      var dropzoneItems = dropzone.querySelectorAll('.dropzone-item');\n      dropzoneItems.forEach(function (dropzoneItem) {\n        dropzoneItem.style.display = '';\n      });\n      dropzone.querySelector('.dropzone-upload').style.display = \"inline-block\";\n      dropzone.querySelector('.dropzone-remove-all').style.display = \"inline-block\";\n    });\n\n    // Hide the total progress bar when nothing's uploading anymore\n    myDropzone.on(\"complete\", function (file) {\n      var progressBars = dropzone.querySelectorAll('.dz-complete');\n      setTimeout(function () {\n        progressBars.forEach(function (progressBar) {\n          progressBar.querySelector('.progress-bar').style.opacity = \"0\";\n          progressBar.querySelector('.progress').style.opacity = \"0\";\n          progressBar.querySelector('.dropzone-start').style.opacity = \"0\";\n        });\n      }, 300);\n    });\n\n    // Setup the buttons for all transfers\n    dropzone.querySelector(\".dropzone-upload\").addEventListener('click', function () {\n      // myDropzone.processQueue(); --- default dropzone process\n\n      // Process simulation for demo only\n      myDropzone.files.forEach(function (file) {\n        var progressBar = file.previewElement.querySelector('.progress-bar');\n        progressBar.style.opacity = \"1\";\n        var width = 1;\n        var timer = setInterval(function () {\n          if (width >= 100) {\n            myDropzone.emit(\"success\", file);\n            myDropzone.emit(\"complete\", file);\n            clearInterval(timer);\n          } else {\n            width++;\n            progressBar.style.width = width + '%';\n          }\n        }, 20);\n      });\n    });\n\n    // Setup the button for remove all files\n    dropzone.querySelector(\".dropzone-remove-all\").addEventListener('click', function () {\n      Swal.fire({\n        text: \"Are you sure you would like to remove all files?\",\n        icon: \"warning\",\n        showCancelButton: true,\n        buttonsStyling: false,\n        confirmButtonText: \"Yes, remove it!\",\n        cancelButtonText: \"No, return\",\n        customClass: {\n          confirmButton: \"btn btn-primary\",\n          cancelButton: \"btn btn-active-light\"\n        }\n      }).then(function (result) {\n        if (result.value) {\n          dropzone.querySelector('.dropzone-upload').style.display = \"none\";\n          dropzone.querySelector('.dropzone-remove-all').style.display = \"none\";\n          myDropzone.removeAllFiles(true);\n        } else if (result.dismiss === 'cancel') {\n          Swal.fire({\n            text: \"Your files was not removed!.\",\n            icon: \"error\",\n            buttonsStyling: false,\n            confirmButtonText: \"Ok, got it!\",\n            customClass: {\n              confirmButton: \"btn btn-primary\"\n            }\n          });\n        }\n      });\n    });\n\n    // On all files completed upload\n    myDropzone.on(\"queuecomplete\", function (progress) {\n      var uploadIcons = dropzone.querySelectorAll('.dropzone-upload');\n      uploadIcons.forEach(function (uploadIcon) {\n        uploadIcon.style.display = \"none\";\n      });\n    });\n\n    // On all files removed\n    myDropzone.on(\"removedfile\", function (file) {\n      if (myDropzone.files.length < 1) {\n        dropzone.querySelector('.dropzone-upload').style.display = \"none\";\n        dropzone.querySelector('.dropzone-remove-all').style.display = \"none\";\n      }\n    });\n  };\n\n  // Init copy link\n  var initCopyLink = function initCopyLink() {\n    // Select all copy link elements\n    var elements = table.querySelectorAll('[data-kt-filemanger-table=\"copy_link\"]');\n    elements.forEach(function (el) {\n      // Define elements\n      var button = el.querySelector('button');\n      var generator = el.querySelector('[data-kt-filemanger-table=\"copy_link_generator\"]');\n      var result = el.querySelector('[data-kt-filemanger-table=\"copy_link_result\"]');\n      var input = el.querySelector('input');\n\n      // Click action\n      button.addEventListener('click', function (e) {\n        e.preventDefault();\n\n        // Reset toggle\n        generator.classList.remove('d-none');\n        result.classList.add('d-none');\n        var linkTimeout;\n        clearTimeout(linkTimeout);\n        linkTimeout = setTimeout(function () {\n          generator.classList.add('d-none');\n          result.classList.remove('d-none');\n          input.select();\n        }, 2000);\n      });\n    });\n  };\n\n  // Handle move to folder\n  var handleMoveToFolder = function handleMoveToFolder() {\n    var element = document.querySelector('#kt_modal_move_to_folder');\n    var form = element.querySelector('#kt_modal_move_to_folder_form');\n    var saveButton = form.querySelector('#kt_modal_move_to_folder_submit');\n    var moveModal = new bootstrap.Modal(element);\n\n    // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/\n    var validator = FormValidation.formValidation(form, {\n      fields: {\n        'move_to_folder': {\n          validators: {\n            notEmpty: {\n              message: 'Please select a folder.'\n            }\n          }\n        }\n      },\n      plugins: {\n        trigger: new FormValidation.plugins.Trigger(),\n        bootstrap: new FormValidation.plugins.Bootstrap5({\n          rowSelector: '.fv-row',\n          eleInvalidClass: '',\n          eleValidClass: ''\n        })\n      }\n    });\n    saveButton.addEventListener('click', function (e) {\n      e.preventDefault();\n      saveButton.setAttribute(\"data-kt-indicator\", \"on\");\n      if (validator) {\n        validator.validate().then(function (status) {\n          console.log('validated!');\n          if (status == 'Valid') {\n            // Simulate process for demo only\n            setTimeout(function () {\n              Swal.fire({\n                text: \"Are you sure you would like to move to this folder\",\n                icon: \"warning\",\n                showCancelButton: true,\n                buttonsStyling: false,\n                confirmButtonText: \"Yes, move it!\",\n                cancelButtonText: \"No, return\",\n                customClass: {\n                  confirmButton: \"btn btn-primary\",\n                  cancelButton: \"btn btn-active-light\"\n                }\n              }).then(function (result) {\n                if (result.isConfirmed) {\n                  form.reset(); // Reset form\t\n                  moveModal.hide(); // Hide modal\t\t\t\n\n                  toastr.options = {\n                    \"closeButton\": true,\n                    \"debug\": false,\n                    \"newestOnTop\": false,\n                    \"progressBar\": false,\n                    \"positionClass\": \"toastr-top-right\",\n                    \"preventDuplicates\": false,\n                    \"showDuration\": \"300\",\n                    \"hideDuration\": \"1000\",\n                    \"timeOut\": \"5000\",\n                    \"extendedTimeOut\": \"1000\",\n                    \"showEasing\": \"swing\",\n                    \"hideEasing\": \"linear\",\n                    \"showMethod\": \"fadeIn\",\n                    \"hideMethod\": \"fadeOut\"\n                  };\n                  toastr.success('1 item has been moved.');\n                  saveButton.removeAttribute(\"data-kt-indicator\");\n                } else {\n                  Swal.fire({\n                    text: \"Your action has been cancelled!.\",\n                    icon: \"error\",\n                    buttonsStyling: false,\n                    confirmButtonText: \"Ok, got it!\",\n                    customClass: {\n                      confirmButton: \"btn btn-primary\"\n                    }\n                  });\n                  saveButton.removeAttribute(\"data-kt-indicator\");\n                }\n              });\n            }, 500);\n          } else {\n            saveButton.removeAttribute(\"data-kt-indicator\");\n          }\n        });\n      }\n    });\n  };\n\n  // Count total number of items\n  var countTotalItems = function countTotalItems() {\n    var counter = document.getElementById('kt_file_manager_items_counter');\n\n    // Count total number of elements in datatable --- more info: https://datatables.net/reference/api/count()\n    counter.innerText = datatable.rows().count() + ' items';\n  };\n\n  // Public methods\n  return {\n    init: function init() {\n      table = document.querySelector('#kt_file_manager_list');\n      if (!table) {\n        return;\n      }\n      initTemplates();\n      initDatatable();\n      initToggleToolbar();\n      handleSearchDatatable();\n      handleDeleteRows();\n      handleNewFolder();\n      initDropzone();\n      initCopyLink();\n      handleRename();\n      handleMoveToFolder();\n      countTotalItems();\n      KTMenu.createInstances();\n    }\n  };\n}();\n\n// On document ready\nKTUtil.onDOMContentLoaded(function () {\n  KTFileManagerList.init();\n});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./resources/assets/core/js/custom/apps/file-manager/list.js\n");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval-source-map devtool is used.
/******/ 	var __webpack_exports__ = {};
/******/ 	__webpack_modules__["./resources/assets/core/js/custom/apps/file-manager/list.js"]();
/******/ 	
/******/ })()
;