/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./resources/assets/core/js/custom/apps/user-management/users/list/table.js":
/*!**********************************************************************************!*\
  !*** ./resources/assets/core/js/custom/apps/user-management/users/list/table.js ***!
  \**********************************************************************************/
/***/ (() => {

eval("\n\nvar KTUsersList = function () {\n  // Define shared variables\n  var table = document.getElementById('kt_table_users');\n  var datatable;\n  var toolbarBase;\n  var toolbarSelected;\n  var selectedCount;\n\n  // Private functions\n  var initUserTable = function initUserTable() {\n    // Set date data order\n    var tableRows = table.querySelectorAll('tbody tr');\n    tableRows.forEach(function (row) {\n      var dateRow = row.querySelectorAll('td');\n      var lastLogin = dateRow[3].innerText.toLowerCase(); // Get last login time\n      var timeCount = 0;\n      var timeFormat = 'minutes';\n\n      // Determine date & time format -- add more formats when necessary\n      if (lastLogin.includes('yesterday')) {\n        timeCount = 1;\n        timeFormat = 'days';\n      } else if (lastLogin.includes('mins')) {\n        timeCount = parseInt(lastLogin.replace(/\\D/g, ''));\n        timeFormat = 'minutes';\n      } else if (lastLogin.includes('hours')) {\n        timeCount = parseInt(lastLogin.replace(/\\D/g, ''));\n        timeFormat = 'hours';\n      } else if (lastLogin.includes('days')) {\n        timeCount = parseInt(lastLogin.replace(/\\D/g, ''));\n        timeFormat = 'days';\n      } else if (lastLogin.includes('weeks')) {\n        timeCount = parseInt(lastLogin.replace(/\\D/g, ''));\n        timeFormat = 'weeks';\n      }\n\n      // Subtract date/time from today -- more info on moment datetime subtraction: https://momentjs.com/docs/#/durations/subtract/\n      var realDate = moment().subtract(timeCount, timeFormat).format();\n\n      // Insert real date to last login attribute\n      dateRow[3].setAttribute('data-order', realDate);\n\n      // Set real date for joined column\n      var joinedDate = moment(dateRow[5].innerHTML, \"DD MMM YYYY, LT\").format(); // select date from 5th column in table\n      dateRow[5].setAttribute('data-order', joinedDate);\n    });\n\n    // Init datatable --- more info on datatables: https://datatables.net/manual/\n    datatable = $(table).DataTable({\n      \"info\": false,\n      'order': [],\n      \"pageLength\": 10,\n      \"lengthChange\": false,\n      'columnDefs': [{\n        orderable: false,\n        targets: 0\n      },\n      // Disable ordering on column 0 (checkbox)\n      {\n        orderable: false,\n        targets: 6\n      } // Disable ordering on column 6 (actions)                \n      ]\n    });\n\n    // Re-init functions on every table re-draw -- more info: https://datatables.net/reference/event/draw\n    datatable.on('draw', function () {\n      initToggleToolbar();\n      handleDeleteRows();\n      toggleToolbars();\n    });\n  };\n\n  // Search Datatable --- official docs reference: https://datatables.net/reference/api/search()\n  var handleSearchDatatable = function handleSearchDatatable() {\n    var filterSearch = document.querySelector('[data-kt-user-table-filter=\"search\"]');\n    filterSearch.addEventListener('keyup', function (e) {\n      datatable.search(e.target.value).draw();\n    });\n  };\n\n  // Filter Datatable\n  var handleFilterDatatable = function handleFilterDatatable() {\n    // Select filter options\n    var filterForm = document.querySelector('[data-kt-user-table-filter=\"form\"]');\n    var filterButton = filterForm.querySelector('[data-kt-user-table-filter=\"filter\"]');\n    var selectOptions = filterForm.querySelectorAll('select');\n\n    // Filter datatable on submit\n    filterButton.addEventListener('click', function () {\n      var filterString = '';\n\n      // Get filter values\n      selectOptions.forEach(function (item, index) {\n        if (item.value && item.value !== '') {\n          if (index !== 0) {\n            filterString += ' ';\n          }\n\n          // Build filter value options\n          filterString += item.value;\n        }\n      });\n\n      // Filter datatable --- official docs reference: https://datatables.net/reference/api/search()\n      datatable.search(filterString).draw();\n    });\n  };\n\n  // Reset Filter\n  var handleResetForm = function handleResetForm() {\n    // Select reset button\n    var resetButton = document.querySelector('[data-kt-user-table-filter=\"reset\"]');\n\n    // Reset datatable\n    resetButton.addEventListener('click', function () {\n      // Select filter options\n      var filterForm = document.querySelector('[data-kt-user-table-filter=\"form\"]');\n      var selectOptions = filterForm.querySelectorAll('select');\n\n      // Reset select2 values -- more info: https://select2.org/programmatic-control/add-select-clear-items\n      selectOptions.forEach(function (select) {\n        $(select).val('').trigger('change');\n      });\n\n      // Reset datatable --- official docs reference: https://datatables.net/reference/api/search()\n      datatable.search('').draw();\n    });\n  };\n\n  // Delete subscirption\n  var handleDeleteRows = function handleDeleteRows() {\n    // Select all delete buttons\n    var deleteButtons = table.querySelectorAll('[data-kt-users-table-filter=\"delete_row\"]');\n    deleteButtons.forEach(function (d) {\n      // Delete button on click\n      d.addEventListener('click', function (e) {\n        e.preventDefault();\n\n        // Select parent row\n        var parent = e.target.closest('tr');\n\n        // Get user name\n        var userName = parent.querySelectorAll('td')[1].querySelectorAll('a')[1].innerText;\n\n        // SweetAlert2 pop up --- official docs reference: https://sweetalert2.github.io/\n        Swal.fire({\n          text: \"Are you sure you want to delete \" + userName + \"?\",\n          icon: \"warning\",\n          showCancelButton: true,\n          buttonsStyling: false,\n          confirmButtonText: \"Yes, delete!\",\n          cancelButtonText: \"No, cancel\",\n          customClass: {\n            confirmButton: \"btn fw-bold btn-danger\",\n            cancelButton: \"btn fw-bold btn-active-light-primary\"\n          }\n        }).then(function (result) {\n          if (result.value) {\n            Swal.fire({\n              text: \"You have deleted \" + userName + \"!.\",\n              icon: \"success\",\n              buttonsStyling: false,\n              confirmButtonText: \"Ok, got it!\",\n              customClass: {\n                confirmButton: \"btn fw-bold btn-primary\"\n              }\n            }).then(function () {\n              // Remove current row\n              datatable.row($(parent)).remove().draw();\n            }).then(function () {\n              // Detect checked checkboxes\n              toggleToolbars();\n            });\n          } else if (result.dismiss === 'cancel') {\n            Swal.fire({\n              text: customerName + \" was not deleted.\",\n              icon: \"error\",\n              buttonsStyling: false,\n              confirmButtonText: \"Ok, got it!\",\n              customClass: {\n                confirmButton: \"btn fw-bold btn-primary\"\n              }\n            });\n          }\n        });\n      });\n    });\n  };\n\n  // Init toggle toolbar\n  var initToggleToolbar = function initToggleToolbar() {\n    // Toggle selected action toolbar\n    // Select all checkboxes\n    var checkboxes = table.querySelectorAll('[type=\"checkbox\"]');\n\n    // Select elements\n    toolbarBase = document.querySelector('[data-kt-user-table-toolbar=\"base\"]');\n    toolbarSelected = document.querySelector('[data-kt-user-table-toolbar=\"selected\"]');\n    selectedCount = document.querySelector('[data-kt-user-table-select=\"selected_count\"]');\n    var deleteSelected = document.querySelector('[data-kt-user-table-select=\"delete_selected\"]');\n\n    // Toggle delete selected toolbar\n    checkboxes.forEach(function (c) {\n      // Checkbox on click event\n      c.addEventListener('click', function () {\n        setTimeout(function () {\n          toggleToolbars();\n        }, 50);\n      });\n    });\n\n    // Deleted selected rows\n    deleteSelected.addEventListener('click', function () {\n      // SweetAlert2 pop up --- official docs reference: https://sweetalert2.github.io/\n      Swal.fire({\n        text: \"Are you sure you want to delete selected customers?\",\n        icon: \"warning\",\n        showCancelButton: true,\n        buttonsStyling: false,\n        confirmButtonText: \"Yes, delete!\",\n        cancelButtonText: \"No, cancel\",\n        customClass: {\n          confirmButton: \"btn fw-bold btn-danger\",\n          cancelButton: \"btn fw-bold btn-active-light-primary\"\n        }\n      }).then(function (result) {\n        if (result.value) {\n          Swal.fire({\n            text: \"You have deleted all selected customers!.\",\n            icon: \"success\",\n            buttonsStyling: false,\n            confirmButtonText: \"Ok, got it!\",\n            customClass: {\n              confirmButton: \"btn fw-bold btn-primary\"\n            }\n          }).then(function () {\n            // Remove all selected customers\n            checkboxes.forEach(function (c) {\n              if (c.checked) {\n                datatable.row($(c.closest('tbody tr'))).remove().draw();\n              }\n            });\n\n            // Remove header checked box\n            var headerCheckbox = table.querySelectorAll('[type=\"checkbox\"]')[0];\n            headerCheckbox.checked = false;\n          }).then(function () {\n            toggleToolbars(); // Detect checked checkboxes\n            initToggleToolbar(); // Re-init toolbar to recalculate checkboxes\n          });\n        } else if (result.dismiss === 'cancel') {\n          Swal.fire({\n            text: \"Selected customers was not deleted.\",\n            icon: \"error\",\n            buttonsStyling: false,\n            confirmButtonText: \"Ok, got it!\",\n            customClass: {\n              confirmButton: \"btn fw-bold btn-primary\"\n            }\n          });\n        }\n      });\n    });\n  };\n\n  // Toggle toolbars\n  var toggleToolbars = function toggleToolbars() {\n    // Select refreshed checkbox DOM elements \n    var allCheckboxes = table.querySelectorAll('tbody [type=\"checkbox\"]');\n\n    // Detect checkboxes state & count\n    var checkedState = false;\n    var count = 0;\n\n    // Count checked boxes\n    allCheckboxes.forEach(function (c) {\n      if (c.checked) {\n        checkedState = true;\n        count++;\n      }\n    });\n\n    // Toggle toolbars\n    if (checkedState) {\n      selectedCount.innerHTML = count;\n      toolbarBase.classList.add('d-none');\n      toolbarSelected.classList.remove('d-none');\n    } else {\n      toolbarBase.classList.remove('d-none');\n      toolbarSelected.classList.add('d-none');\n    }\n  };\n  return {\n    // Public functions  \n    init: function init() {\n      if (!table) {\n        return;\n      }\n      initUserTable();\n      initToggleToolbar();\n      handleSearchDatatable();\n      handleResetForm();\n      handleDeleteRows();\n      handleFilterDatatable();\n    }\n  };\n}();\n\n// On document ready\nKTUtil.onDOMContentLoaded(function () {\n  KTUsersList.init();\n});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./resources/assets/core/js/custom/apps/user-management/users/list/table.js\n");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval-source-map devtool is used.
/******/ 	var __webpack_exports__ = {};
/******/ 	__webpack_modules__["./resources/assets/core/js/custom/apps/user-management/users/list/table.js"]();
/******/ 	
/******/ })()
;