/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./resources/assets/core/js/custom/documentation/general/datatables/server-side.js":
/*!*****************************************************************************************!*\
  !*** ./resources/assets/core/js/custom/documentation/general/datatables/server-side.js ***!
  \*****************************************************************************************/
/***/ (() => {

eval("\n\n// Class definition\nvar KTDatatablesServerSide = function () {\n  // Shared variables\n  var table;\n  var dt;\n  var filterPayment;\n\n  // Private functions\n  var initDatatable = function initDatatable() {\n    dt = $(\"#kt_datatable_example_1\").DataTable({\n      searchDelay: 500,\n      processing: true,\n      serverSide: true,\n      order: [[5, 'desc']],\n      stateSave: true,\n      select: {\n        style: 'multi',\n        selector: 'td:first-child input[type=\"checkbox\"]',\n        className: 'row-selected'\n      },\n      ajax: {\n        url: \"https://preview.keenthemes.com/api/datatables.php\"\n      },\n      columns: [{\n        data: 'RecordID'\n      }, {\n        data: 'Name'\n      }, {\n        data: 'Email'\n      }, {\n        data: 'Company'\n      }, {\n        data: 'CreditCardNumber'\n      }, {\n        data: 'Datetime'\n      }, {\n        data: null\n      }],\n      columnDefs: [{\n        targets: 0,\n        orderable: false,\n        render: function render(data) {\n          return \"\\n                            <div class=\\\"form-check form-check-sm form-check-custom form-check-solid\\\">\\n                                <input class=\\\"form-check-input\\\" type=\\\"checkbox\\\" value=\\\"\".concat(data, \"\\\" />\\n                            </div>\");\n        }\n      }, {\n        targets: 4,\n        render: function render(data, type, row) {\n          return \"<img src=\\\"\".concat(hostUrl, \"media/svg/card-logos/\").concat(row.CreditCardType, \".svg\\\" class=\\\"w-35px me-3\\\" alt=\\\"\").concat(row.CreditCardType, \"\\\">\") + data;\n        }\n      }, {\n        targets: -1,\n        data: null,\n        orderable: false,\n        className: 'text-end',\n        render: function render(data, type, row) {\n          return \"\\n                            <a href=\\\"#\\\" class=\\\"btn btn-light btn-active-light-primary btn-sm\\\" data-kt-menu-trigger=\\\"click\\\" data-kt-menu-placement=\\\"bottom-end\\\" data-kt-menu-flip=\\\"top-end\\\">\\n                                Actions\\n                                <span class=\\\"svg-icon svg-icon-5 m-0\\\">\\n                                    <svg xmlns=\\\"http://www.w3.org/2000/svg\\\" xmlns:xlink=\\\"http://www.w3.org/1999/xlink\\\" width=\\\"24px\\\" height=\\\"24px\\\" viewBox=\\\"0 0 24 24\\\" version=\\\"1.1\\\">\\n                                        <g stroke=\\\"none\\\" stroke-width=\\\"1\\\" fill=\\\"none\\\" fill-rule=\\\"evenodd\\\">\\n                                            <polygon points=\\\"0 0 24 0 24 24 0 24\\\"></polygon>\\n                                            <path d=\\\"M6.70710678,15.7071068 C6.31658249,16.0976311 5.68341751,16.0976311 5.29289322,15.7071068 C4.90236893,15.3165825 4.90236893,14.6834175 5.29289322,14.2928932 L11.2928932,8.29289322 C11.6714722,7.91431428 12.2810586,7.90106866 12.6757246,8.26284586 L18.6757246,13.7628459 C19.0828436,14.1360383 19.1103465,14.7686056 18.7371541,15.1757246 C18.3639617,15.5828436 17.7313944,15.6103465 17.3242754,15.2371541 L12.0300757,10.3841378 L6.70710678,15.7071068 Z\\\" fill=\\\"currentColor\\\" fill-rule=\\\"nonzero\\\" transform=\\\"translate(12.000003, 11.999999) rotate(-180.000000) translate(-12.000003, -11.999999)\\\"></path>\\n                                        </g>\\n                                    </svg>\\n                                </span>\\n                            </a>\\n                            <!--begin::Menu-->\\n                            <div class=\\\"menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-bold fs-7 w-125px py-4\\\" data-kt-menu=\\\"true\\\">\\n                                <!--begin::Menu item-->\\n                                <div class=\\\"menu-item px-3\\\">\\n                                    <a href=\\\"#\\\" class=\\\"menu-link px-3\\\" data-kt-docs-table-filter=\\\"edit_row\\\">\\n                                        Edit\\n                                    </a>\\n                                </div>\\n                                <!--end::Menu item-->\\n                                \\n                                <!--begin::Menu item-->\\n                                <div class=\\\"menu-item px-3\\\">\\n                                    <a href=\\\"#\\\" class=\\\"menu-link px-3\\\" data-kt-docs-table-filter=\\\"delete_row\\\">\\n                                        Delete\\n                                    </a>\\n                                </div>\\n                                <!--end::Menu item-->\\n                            </div>\\n                            <!--end::Menu-->\\n                        \";\n        }\n      }],\n      // Add data-filter attribute\n      createdRow: function createdRow(row, data, dataIndex) {\n        $(row).find('td:eq(4)').attr('data-filter', data.CreditCardType);\n      }\n    });\n    table = dt.$;\n\n    // Re-init functions on every table re-draw -- more info: https://datatables.net/reference/event/draw\n    dt.on('draw', function () {\n      initToggleToolbar();\n      toggleToolbars();\n      handleDeleteRows();\n      KTMenu.createInstances();\n    });\n  };\n\n  // Search Datatable --- official docs reference: https://datatables.net/reference/api/search()\n  var handleSearchDatatable = function handleSearchDatatable() {\n    var filterSearch = document.querySelector('[data-kt-docs-table-filter=\"search\"]');\n    filterSearch.addEventListener('keyup', function (e) {\n      dt.search(e.target.value).draw();\n    });\n  };\n\n  // Filter Datatable\n  var handleFilterDatatable = function handleFilterDatatable() {\n    // Select filter options\n    filterPayment = document.querySelectorAll('[data-kt-docs-table-filter=\"payment_type\"] [name=\"payment_type\"]');\n    var filterButton = document.querySelector('[data-kt-docs-table-filter=\"filter\"]');\n\n    // Filter datatable on submit\n    filterButton.addEventListener('click', function () {\n      // Get filter values\n      var paymentValue = '';\n\n      // Get payment value\n      filterPayment.forEach(function (r) {\n        if (r.checked) {\n          paymentValue = r.value;\n        }\n\n        // Reset payment value if \"All\" is selected\n        if (paymentValue === 'all') {\n          paymentValue = '';\n        }\n      });\n\n      // Filter datatable --- official docs reference: https://datatables.net/reference/api/search()\n      dt.search(paymentValue).draw();\n    });\n  };\n\n  // Delete customer\n  var handleDeleteRows = function handleDeleteRows() {\n    // Select all delete buttons\n    var deleteButtons = document.querySelectorAll('[data-kt-docs-table-filter=\"delete_row\"]');\n    deleteButtons.forEach(function (d) {\n      // Delete button on click\n      d.addEventListener('click', function (e) {\n        e.preventDefault();\n\n        // Select parent row\n        var parent = e.target.closest('tr');\n\n        // Get customer name\n        var customerName = parent.querySelectorAll('td')[1].innerText;\n\n        // SweetAlert2 pop up --- official docs reference: https://sweetalert2.github.io/\n        Swal.fire({\n          text: \"Are you sure you want to delete \" + customerName + \"?\",\n          icon: \"warning\",\n          showCancelButton: true,\n          buttonsStyling: false,\n          confirmButtonText: \"Yes, delete!\",\n          cancelButtonText: \"No, cancel\",\n          customClass: {\n            confirmButton: \"btn fw-bold btn-danger\",\n            cancelButton: \"btn fw-bold btn-active-light-primary\"\n          }\n        }).then(function (result) {\n          if (result.value) {\n            // Simulate delete request -- for demo purpose only\n            Swal.fire({\n              text: \"Deleting \" + customerName,\n              icon: \"info\",\n              buttonsStyling: false,\n              showConfirmButton: false,\n              timer: 2000\n            }).then(function () {\n              Swal.fire({\n                text: \"You have deleted \" + customerName + \"!.\",\n                icon: \"success\",\n                buttonsStyling: false,\n                confirmButtonText: \"Ok, got it!\",\n                customClass: {\n                  confirmButton: \"btn fw-bold btn-primary\"\n                }\n              }).then(function () {\n                // delete row data from server and re-draw datatable\n                dt.draw();\n              });\n            });\n          } else if (result.dismiss === 'cancel') {\n            Swal.fire({\n              text: customerName + \" was not deleted.\",\n              icon: \"error\",\n              buttonsStyling: false,\n              confirmButtonText: \"Ok, got it!\",\n              customClass: {\n                confirmButton: \"btn fw-bold btn-primary\"\n              }\n            });\n          }\n        });\n      });\n    });\n  };\n\n  // Reset Filter\n  var handleResetForm = function handleResetForm() {\n    // Select reset button\n    var resetButton = document.querySelector('[data-kt-docs-table-filter=\"reset\"]');\n\n    // Reset datatable\n    resetButton.addEventListener('click', function () {\n      // Reset payment type\n      filterPayment[0].checked = true;\n\n      // Reset datatable --- official docs reference: https://datatables.net/reference/api/search()\n      dt.search('').draw();\n    });\n  };\n\n  // Init toggle toolbar\n  var initToggleToolbar = function initToggleToolbar() {\n    // Toggle selected action toolbar\n    // Select all checkboxes\n    var container = document.querySelector('#kt_datatable_example_1');\n    var checkboxes = container.querySelectorAll('[type=\"checkbox\"]');\n\n    // Select elements\n    var deleteSelected = document.querySelector('[data-kt-docs-table-select=\"delete_selected\"]');\n\n    // Toggle delete selected toolbar\n    checkboxes.forEach(function (c) {\n      // Checkbox on click event\n      c.addEventListener('click', function () {\n        setTimeout(function () {\n          toggleToolbars();\n        }, 50);\n      });\n    });\n\n    // Deleted selected rows\n    deleteSelected.addEventListener('click', function () {\n      // SweetAlert2 pop up --- official docs reference: https://sweetalert2.github.io/\n      Swal.fire({\n        text: \"Are you sure you want to delete selected customers?\",\n        icon: \"warning\",\n        showCancelButton: true,\n        buttonsStyling: false,\n        showLoaderOnConfirm: true,\n        confirmButtonText: \"Yes, delete!\",\n        cancelButtonText: \"No, cancel\",\n        customClass: {\n          confirmButton: \"btn fw-bold btn-danger\",\n          cancelButton: \"btn fw-bold btn-active-light-primary\"\n        }\n      }).then(function (result) {\n        if (result.value) {\n          // Simulate delete request -- for demo purpose only\n          Swal.fire({\n            text: \"Deleting selected customers\",\n            icon: \"info\",\n            buttonsStyling: false,\n            showConfirmButton: false,\n            timer: 2000\n          }).then(function () {\n            Swal.fire({\n              text: \"You have deleted all selected customers!.\",\n              icon: \"success\",\n              buttonsStyling: false,\n              confirmButtonText: \"Ok, got it!\",\n              customClass: {\n                confirmButton: \"btn fw-bold btn-primary\"\n              }\n            }).then(function () {\n              // delete row data from server and re-draw datatable\n              dt.draw();\n            });\n\n            // Remove header checked box\n            var headerCheckbox = container.querySelectorAll('[type=\"checkbox\"]')[0];\n            headerCheckbox.checked = false;\n          });\n        } else if (result.dismiss === 'cancel') {\n          Swal.fire({\n            text: \"Selected customers was not deleted.\",\n            icon: \"error\",\n            buttonsStyling: false,\n            confirmButtonText: \"Ok, got it!\",\n            customClass: {\n              confirmButton: \"btn fw-bold btn-primary\"\n            }\n          });\n        }\n      });\n    });\n  };\n\n  // Toggle toolbars\n  var toggleToolbars = function toggleToolbars() {\n    // Define variables\n    var container = document.querySelector('#kt_datatable_example_1');\n    var toolbarBase = document.querySelector('[data-kt-docs-table-toolbar=\"base\"]');\n    var toolbarSelected = document.querySelector('[data-kt-docs-table-toolbar=\"selected\"]');\n    var selectedCount = document.querySelector('[data-kt-docs-table-select=\"selected_count\"]');\n\n    // Select refreshed checkbox DOM elements \n    var allCheckboxes = container.querySelectorAll('tbody [type=\"checkbox\"]');\n\n    // Detect checkboxes state & count\n    var checkedState = false;\n    var count = 0;\n\n    // Count checked boxes\n    allCheckboxes.forEach(function (c) {\n      if (c.checked) {\n        checkedState = true;\n        count++;\n      }\n    });\n\n    // Toggle toolbars\n    if (checkedState) {\n      selectedCount.innerHTML = count;\n      toolbarBase.classList.add('d-none');\n      toolbarSelected.classList.remove('d-none');\n    } else {\n      toolbarBase.classList.remove('d-none');\n      toolbarSelected.classList.add('d-none');\n    }\n  };\n\n  // Public methods\n  return {\n    init: function init() {\n      initDatatable();\n      handleSearchDatatable();\n      initToggleToolbar();\n      handleFilterDatatable();\n      handleDeleteRows();\n      handleResetForm();\n    }\n  };\n}();\n\n// On document ready\nKTUtil.onDOMContentLoaded(function () {\n  KTDatatablesServerSide.init();\n});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./resources/assets/core/js/custom/documentation/general/datatables/server-side.js\n");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval-source-map devtool is used.
/******/ 	var __webpack_exports__ = {};
/******/ 	__webpack_modules__["./resources/assets/core/js/custom/documentation/general/datatables/server-side.js"]();
/******/ 	
/******/ })()
;