var notifications = $(".toast-notifications"),
    buttons = $(".buttons .btn");

var toastDetails = {
    success: {
        icon: 'fas fa-check',
    },
    error: {
        icon: 'fas fa-times-circle',
    },
    warning: {
        icon: 'fas fa-times-circle',
    },
    info: {
        icon: 'fas fa-check',
    }
}

function removeToast(toast) {
    if(toast.timeoutId) clearTimeout(toast.timeoutId);
    toast.hide('slow', function(){ toast.remove(); });

}

function createToast(type, message)
{
    var className = type;
    if(type == 'error'){
        className = 'danger';
    }
    var icon = toastDetails[type].icon;
    var toast = $('<div class="alert alert-dismissible alert-'+className+' d-flex align-items-center p-4"></div>');
     toast.html(
             '<i class="'+icon+' fs-1 text-'+className+' me-4"></i>' +
                '        <div class="d-flex flex-column">' +
                '            <h4 class="mb-1 text-'+className+'">'+upperCase(type)+'</h4>' +
                '            <span>'+upperCase(message)+'</span>' +
                '        </div>'
            );

    notifications.append(toast);
    toast.timeoutId = setTimeout(function() { removeToast(toast); }, 3000);
}

$(document).on('click','.alert-dismissible',function()
{
    removeToast($(this));
});

function upperCase(text)
{
    text = text.toLowerCase().replace(/\b[a-z]/g, function(letter) {
        return letter.toUpperCase();
    });
    return text;
}
