/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@terraformer/arcgis/dist/t-arcgis.esm.js":
/*!***************************************************************!*\
  !*** ./node_modules/@terraformer/arcgis/dist/t-arcgis.esm.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"arcgisToGeoJSON\": () => (/* binding */ arcgisToGeoJSON),\n/* harmony export */   \"geojsonToArcGIS\": () => (/* binding */ geojsonToArcGIS)\n/* harmony export */ });\n/* @preserve\n* @terraformer/arcgis - v2.1.1 - MIT\n* Copyright (c) 2012-2022 Environmental Systems Research Institute, Inc.\n* Tue Aug 02 2022 14:23:48 GMT-0700 (Pacific Daylight Time)\n*/\n/* Copyright (c) 2012-2019 Environmental Systems Research Institute, Inc.\n * Apache-2.0 */\n\nvar edgeIntersectsEdge = function edgeIntersectsEdge(a1, a2, b1, b2) {\n  var uaT = (b2[0] - b1[0]) * (a1[1] - b1[1]) - (b2[1] - b1[1]) * (a1[0] - b1[0]);\n  var ubT = (a2[0] - a1[0]) * (a1[1] - b1[1]) - (a2[1] - a1[1]) * (a1[0] - b1[0]);\n  var uB = (b2[1] - b1[1]) * (a2[0] - a1[0]) - (b2[0] - b1[0]) * (a2[1] - a1[1]);\n\n  if (uB !== 0) {\n    var ua = uaT / uB;\n    var ub = ubT / uB;\n\n    if (ua >= 0 && ua <= 1 && ub >= 0 && ub <= 1) {\n      return true;\n    }\n  }\n\n  return false;\n};\nvar coordinatesContainPoint = function coordinatesContainPoint(coordinates, point) {\n  var contains = false;\n\n  for (var i = -1, l = coordinates.length, j = l - 1; ++i < l; j = i) {\n    if ((coordinates[i][1] <= point[1] && point[1] < coordinates[j][1] || coordinates[j][1] <= point[1] && point[1] < coordinates[i][1]) && point[0] < (coordinates[j][0] - coordinates[i][0]) * (point[1] - coordinates[i][1]) / (coordinates[j][1] - coordinates[i][1]) + coordinates[i][0]) {\n      contains = !contains;\n    }\n  }\n\n  return contains;\n};\nvar pointsEqual = function pointsEqual(a, b) {\n  for (var i = 0; i < a.length; i++) {\n    if (a[i] !== b[i]) {\n      return false;\n    }\n  }\n\n  return true;\n};\nvar arrayIntersectsArray = function arrayIntersectsArray(a, b) {\n  for (var i = 0; i < a.length - 1; i++) {\n    for (var j = 0; j < b.length - 1; j++) {\n      if (edgeIntersectsEdge(a[i], a[i + 1], b[j], b[j + 1])) {\n        return true;\n      }\n    }\n  }\n\n  return false;\n};\n\n/* Copyright (c) 2012-2019 Environmental Systems Research Institute, Inc.\n * Apache-2.0 */\n\nvar closeRing = function closeRing(coordinates) {\n  if (!pointsEqual(coordinates[0], coordinates[coordinates.length - 1])) {\n    coordinates.push(coordinates[0]);\n  }\n\n  return coordinates;\n}; // determine if polygon ring coordinates are clockwise. clockwise signifies outer ring, counter-clockwise an inner ring\n// or hole. this logic was found at http://stackoverflow.com/questions/1165647/how-to-determine-if-a-list-of-polygon-\n// points-are-in-clockwise-order\n\nvar ringIsClockwise = function ringIsClockwise(ringToTest) {\n  var total = 0;\n  var i = 0;\n  var rLength = ringToTest.length;\n  var pt1 = ringToTest[i];\n  var pt2;\n\n  for (i; i < rLength - 1; i++) {\n    pt2 = ringToTest[i + 1];\n    total += (pt2[0] - pt1[0]) * (pt2[1] + pt1[1]);\n    pt1 = pt2;\n  }\n\n  return total >= 0;\n}; // This function ensures that rings are oriented in the right directions\n// from http://jsperf.com/cloning-an-object/2\n\nvar shallowClone = function shallowClone(obj) {\n  var target = {};\n\n  for (var i in obj) {\n    // both arcgis attributes and geojson props are just hardcoded keys\n    if (obj.hasOwnProperty(i)) {\n      // eslint-disable-line no-prototype-builtins\n      target[i] = obj[i];\n    }\n  }\n\n  return target;\n};\n\n/* Copyright (c) 2012-2019 Environmental Systems Research Institute, Inc.\n * Apache-2.0 */\n\nvar coordinatesContainCoordinates = function coordinatesContainCoordinates(outer, inner) {\n  var intersects = arrayIntersectsArray(outer, inner);\n  var contains = coordinatesContainPoint(outer, inner[0]);\n\n  if (!intersects && contains) {\n    return true;\n  }\n\n  return false;\n}; // do any polygons in this array contain any other polygons in this array?\n// used for checking for holes in arcgis rings\n\n\nvar convertRingsToGeoJSON = function convertRingsToGeoJSON(rings) {\n  var outerRings = [];\n  var holes = [];\n  var x; // iterator\n\n  var outerRing; // current outer ring being evaluated\n\n  var hole; // current hole being evaluated\n  // for each ring\n\n  for (var r = 0; r < rings.length; r++) {\n    var ring = closeRing(rings[r].slice(0));\n\n    if (ring.length < 4) {\n      continue;\n    } // is this ring an outer ring? is it clockwise?\n\n\n    if (ringIsClockwise(ring)) {\n      var polygon = [ring.slice().reverse()]; // wind outer rings counterclockwise for RFC 7946 compliance\n\n      outerRings.push(polygon); // push to outer rings\n    } else {\n      holes.push(ring.slice().reverse()); // wind inner rings clockwise for RFC 7946 compliance\n    }\n  }\n\n  var uncontainedHoles = []; // while there are holes left...\n\n  while (holes.length) {\n    // pop a hole off out stack\n    hole = holes.pop(); // loop over all outer rings and see if they contain our hole.\n\n    var contained = false;\n\n    for (x = outerRings.length - 1; x >= 0; x--) {\n      outerRing = outerRings[x][0];\n\n      if (coordinatesContainCoordinates(outerRing, hole)) {\n        // the hole is contained push it into our polygon\n        outerRings[x].push(hole);\n        contained = true;\n        break;\n      }\n    } // ring is not contained in any outer ring\n    // sometimes this happens https://github.com/Esri/esri-leaflet/issues/320\n\n\n    if (!contained) {\n      uncontainedHoles.push(hole);\n    }\n  } // if we couldn't match any holes using contains we can try intersects...\n\n\n  while (uncontainedHoles.length) {\n    // pop a hole off out stack\n    hole = uncontainedHoles.pop(); // loop over all outer rings and see if any intersect our hole.\n\n    var intersects = false;\n\n    for (x = outerRings.length - 1; x >= 0; x--) {\n      outerRing = outerRings[x][0];\n\n      if (arrayIntersectsArray(outerRing, hole)) {\n        // the hole is contained push it into our polygon\n        outerRings[x].push(hole);\n        intersects = true;\n        break;\n      }\n    }\n\n    if (!intersects) {\n      outerRings.push([hole.reverse()]);\n    }\n  }\n\n  if (outerRings.length === 1) {\n    return {\n      type: 'Polygon',\n      coordinates: outerRings[0]\n    };\n  } else {\n    return {\n      type: 'MultiPolygon',\n      coordinates: outerRings\n    };\n  }\n};\n\nvar getId = function getId(attributes, idAttribute) {\n  var keys = idAttribute ? [idAttribute, 'OBJECTID', 'FID'] : ['OBJECTID', 'FID'];\n\n  for (var i = 0; i < keys.length; i++) {\n    var key = keys[i];\n\n    if (key in attributes && (typeof attributes[key] === 'string' || typeof attributes[key] === 'number')) {\n      return attributes[key];\n    }\n  }\n\n  throw Error('No valid id attribute found');\n};\n\nvar arcgisToGeoJSON = function arcgisToGeoJSON(arcgis, idAttribute) {\n  var geojson = {};\n\n  if (arcgis.features) {\n    geojson.type = 'FeatureCollection';\n    geojson.features = [];\n\n    for (var i = 0; i < arcgis.features.length; i++) {\n      geojson.features.push(arcgisToGeoJSON(arcgis.features[i], idAttribute));\n    }\n  }\n\n  if (typeof arcgis.x === 'number' && typeof arcgis.y === 'number') {\n    geojson.type = 'Point';\n    geojson.coordinates = [arcgis.x, arcgis.y];\n\n    if (typeof arcgis.z === 'number') {\n      geojson.coordinates.push(arcgis.z);\n    }\n  }\n\n  if (arcgis.points) {\n    geojson.type = 'MultiPoint';\n    geojson.coordinates = arcgis.points.slice(0);\n  }\n\n  if (arcgis.paths) {\n    if (arcgis.paths.length === 1) {\n      geojson.type = 'LineString';\n      geojson.coordinates = arcgis.paths[0].slice(0);\n    } else {\n      geojson.type = 'MultiLineString';\n      geojson.coordinates = arcgis.paths.slice(0);\n    }\n  }\n\n  if (arcgis.rings) {\n    geojson = convertRingsToGeoJSON(arcgis.rings.slice(0));\n  }\n\n  if (typeof arcgis.xmin === 'number' && typeof arcgis.ymin === 'number' && typeof arcgis.xmax === 'number' && typeof arcgis.ymax === 'number') {\n    geojson.type = 'Polygon';\n    geojson.coordinates = [[[arcgis.xmax, arcgis.ymax], [arcgis.xmin, arcgis.ymax], [arcgis.xmin, arcgis.ymin], [arcgis.xmax, arcgis.ymin], [arcgis.xmax, arcgis.ymax]]];\n  }\n\n  if (arcgis.geometry || arcgis.attributes) {\n    geojson.type = 'Feature';\n    geojson.geometry = arcgis.geometry ? arcgisToGeoJSON(arcgis.geometry) : null;\n    geojson.properties = arcgis.attributes ? shallowClone(arcgis.attributes) : null;\n\n    if (arcgis.attributes) {\n      try {\n        geojson.id = getId(arcgis.attributes, idAttribute);\n      } catch (err) {// don't set an id\n      }\n    }\n  } // if no valid geometry was encountered\n\n\n  if (JSON.stringify(geojson.geometry) === JSON.stringify({})) {\n    geojson.geometry = null;\n  }\n\n  if (arcgis.spatialReference && arcgis.spatialReference.wkid && arcgis.spatialReference.wkid !== 4326) {\n    console.warn('Object converted in non-standard crs - ' + JSON.stringify(arcgis.spatialReference));\n  }\n\n  return geojson;\n};\n\n/* Copyright (c) 2012-2019 Environmental Systems Research Institute, Inc.\n * Apache-2.0 */\n// outer rings are clockwise, holes are counterclockwise\n// used for converting GeoJSON Polygons to ArcGIS Polygons\n\nvar orientRings = function orientRings(poly) {\n  var output = [];\n  var polygon = poly.slice(0);\n  var outerRing = closeRing(polygon.shift().slice(0));\n\n  if (outerRing.length >= 4) {\n    if (!ringIsClockwise(outerRing)) {\n      outerRing.reverse();\n    }\n\n    output.push(outerRing);\n\n    for (var i = 0; i < polygon.length; i++) {\n      var hole = closeRing(polygon[i].slice(0));\n\n      if (hole.length >= 4) {\n        if (ringIsClockwise(hole)) {\n          hole.reverse();\n        }\n\n        output.push(hole);\n      }\n    }\n  }\n\n  return output;\n}; // This function flattens holes in multipolygons to one array of polygons\n// used for converting GeoJSON Polygons to ArcGIS Polygons\n\n\nvar flattenMultiPolygonRings = function flattenMultiPolygonRings(rings) {\n  var output = [];\n\n  for (var i = 0; i < rings.length; i++) {\n    var polygon = orientRings(rings[i]);\n\n    for (var x = polygon.length - 1; x >= 0; x--) {\n      var ring = polygon[x].slice(0);\n      output.push(ring);\n    }\n  }\n\n  return output;\n};\n\nvar geojsonToArcGIS = function geojsonToArcGIS(geojson, idAttribute) {\n  idAttribute = idAttribute || 'OBJECTID';\n  var spatialReference = {\n    wkid: 4326\n  };\n  var result = {};\n  var i;\n\n  switch (geojson.type) {\n    case 'Point':\n      result.x = geojson.coordinates[0];\n      result.y = geojson.coordinates[1];\n\n      if (geojson.coordinates[2] != null) {\n        result.z = geojson.coordinates[2];\n      }\n\n      result.spatialReference = spatialReference;\n      break;\n\n    case 'MultiPoint':\n      result.points = geojson.coordinates.slice(0);\n\n      if (geojson.coordinates[0][2] != null) {\n        result.hasZ = true;\n      }\n\n      result.spatialReference = spatialReference;\n      break;\n\n    case 'LineString':\n      result.paths = [geojson.coordinates.slice(0)];\n\n      if (geojson.coordinates[0][2] != null) {\n        result.hasZ = true;\n      }\n\n      result.spatialReference = spatialReference;\n      break;\n\n    case 'MultiLineString':\n      result.paths = geojson.coordinates.slice(0);\n\n      if (geojson.coordinates[0][0][2] != null) {\n        result.hasZ = true;\n      }\n\n      result.spatialReference = spatialReference;\n      break;\n\n    case 'Polygon':\n      result.rings = orientRings(geojson.coordinates.slice(0));\n\n      if (geojson.coordinates[0][0][2] != null) {\n        result.hasZ = true;\n      }\n\n      result.spatialReference = spatialReference;\n      break;\n\n    case 'MultiPolygon':\n      result.rings = flattenMultiPolygonRings(geojson.coordinates.slice(0));\n\n      if (geojson.coordinates[0][0][0][2] != null) {\n        result.hasZ = true;\n      }\n\n      result.spatialReference = spatialReference;\n      break;\n\n    case 'Feature':\n      if (geojson.geometry) {\n        result.geometry = geojsonToArcGIS(geojson.geometry, idAttribute);\n      }\n\n      result.attributes = geojson.properties ? shallowClone(geojson.properties) : {};\n\n      if (geojson.id) {\n        result.attributes[idAttribute] = geojson.id;\n      }\n\n      break;\n\n    case 'FeatureCollection':\n      result = [];\n\n      for (i = 0; i < geojson.features.length; i++) {\n        result.push(geojsonToArcGIS(geojson.features[i], idAttribute));\n      }\n\n      break;\n\n    case 'GeometryCollection':\n      result = [];\n\n      for (i = 0; i < geojson.geometries.length; i++) {\n        result.push(geojsonToArcGIS(geojson.geometries[i], idAttribute));\n      }\n\n      break;\n  }\n\n  return result;\n};\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@terraformer/arcgis/dist/t-arcgis.esm.js\n");

/***/ }),

/***/ "./resources/assets/core/plugins/custom/leaflet/leaflet.js":
/*!*****************************************************************!*\
  !*** ./resources/assets/core/plugins/custom/leaflet/leaflet.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

eval("// Leaflet - Leaflet is the leading open-source JavaScript library for mobile-friendly interactive maps: https://leafletjs.com/\n\nwindow.L = __webpack_require__(/*! leaflet/dist/leaflet.js */ \"./node_modules/leaflet/dist/leaflet.js\");\n__webpack_require__(/*! esri-leaflet */ \"./node_modules/esri-leaflet/src/EsriLeaflet.js\");\nwindow.L.esri = __webpack_require__(/*! esri-leaflet-geocoder */ \"./node_modules/esri-leaflet-geocoder/dist/esri-leaflet-geocoder-debug.js\");//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9yZXNvdXJjZXMvYXNzZXRzL2NvcmUvcGx1Z2lucy9jdXN0b20vbGVhZmxldC9sZWFmbGV0LmpzLmpzIiwibWFwcGluZ3MiOiJBQUFBOztBQUVBQSxNQUFNLENBQUNDLENBQUMsR0FBR0MsbUJBQU8sQ0FBQyx1RUFBeUIsQ0FBQztBQUM3Q0EsbUJBQU8sQ0FBQyxvRUFBYyxDQUFDO0FBQ3ZCRixNQUFNLENBQUNDLENBQUMsQ0FBQ0UsSUFBSSxHQUFHRCxtQkFBTyxDQUFDLHVHQUF1QixDQUFDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vcmVzb3VyY2VzL2Fzc2V0cy9jb3JlL3BsdWdpbnMvY3VzdG9tL2xlYWZsZXQvbGVhZmxldC5qcz8wMzM2Il0sInNvdXJjZXNDb250ZW50IjpbIi8vIExlYWZsZXQgLSBMZWFmbGV0IGlzIHRoZSBsZWFkaW5nIG9wZW4tc291cmNlIEphdmFTY3JpcHQgbGlicmFyeSBmb3IgbW9iaWxlLWZyaWVuZGx5IGludGVyYWN0aXZlIG1hcHM6IGh0dHBzOi8vbGVhZmxldGpzLmNvbS9cclxuXHJcbndpbmRvdy5MID0gcmVxdWlyZSgnbGVhZmxldC9kaXN0L2xlYWZsZXQuanMnKTtcclxucmVxdWlyZSgnZXNyaS1sZWFmbGV0Jyk7XHJcbndpbmRvdy5MLmVzcmkgPSByZXF1aXJlKCdlc3JpLWxlYWZsZXQtZ2VvY29kZXInKTtcclxuIl0sIm5hbWVzIjpbIndpbmRvdyIsIkwiLCJyZXF1aXJlIiwiZXNyaSJdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./resources/assets/core/plugins/custom/leaflet/leaflet.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet-geocoder/dist/esri-leaflet-geocoder-debug.js":
/*!********************************************************************************!*\
  !*** ./node_modules/esri-leaflet-geocoder/dist/esri-leaflet-geocoder-debug.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("/* esri-leaflet-geocoder - v3.1.3 - Fri Apr 08 2022 10:06:56 GMT-0500 (Central Daylight Time)\n * Copyright (c) 2022 Environmental Systems Research Institute, Inc.\n * Apache-2.0 */\n(function (global, factory) {\n   true ? factory(exports, __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\"), __webpack_require__(/*! esri-leaflet */ \"./node_modules/esri-leaflet/src/EsriLeaflet.js\")) :\n  0;\n})(this, (function (exports, leaflet, esriLeaflet) { 'use strict';\n\n  var version = \"3.1.3\";\n\n  var WorldGeocodingServiceUrl = 'https://geocode-api.arcgis.com/arcgis/rest/services/World/GeocodeServer/';\n\n  var Geocode = esriLeaflet.Task.extend({\r\n    path: 'findAddressCandidates',\r\n\r\n    params: {\r\n      outSr: 4326,\r\n      forStorage: false,\r\n      outFields: '*',\r\n      maxLocations: 20\r\n    },\r\n\r\n    setters: {\r\n      address: 'address',\r\n      neighborhood: 'neighborhood',\r\n      city: 'city',\r\n      subregion: 'subregion',\r\n      region: 'region',\r\n      postal: 'postal',\r\n      country: 'country',\r\n      text: 'singleLine',\r\n      category: 'category',\r\n      token: 'token',\r\n      apikey: 'apikey',\r\n      key: 'magicKey',\r\n      fields: 'outFields',\r\n      forStorage: 'forStorage',\r\n      maxLocations: 'maxLocations',\r\n      // World Geocoding Service (only works with singleLine)\r\n      countries: 'sourceCountry'\r\n    },\r\n\r\n    initialize: function (options) {\r\n      options = options || {};\r\n      options.url = options.url || WorldGeocodingServiceUrl;\r\n      esriLeaflet.Task.prototype.initialize.call(this, options);\r\n    },\r\n\r\n    within: function (bounds) {\r\n      bounds = leaflet.latLngBounds(bounds);\r\n      this.params.searchExtent = esriLeaflet.Util.boundsToExtent(bounds);\r\n      return this;\r\n    },\r\n\r\n    nearby: function (coords, radius) {\r\n      var centroid = leaflet.latLng(coords);\r\n      this.params.location = centroid.lng + ',' + centroid.lat;\r\n      if (radius) {\r\n        this.params.distance = Math.min(Math.max(radius, 2000), 50000);\r\n      }\r\n      return this;\r\n    },\r\n\r\n    run: function (callback, context) {\r\n      if (this.options.token) {\r\n        this.params.token = this.options.token;\r\n      }\r\n      if (this.options.apikey) {\r\n        this.params.token = this.options.apikey;\r\n      }\r\n      if (this.options.customParam) {\r\n        this.params[this.options.customParam] = this.params.singleLine;\r\n        delete this.params.singleLine;\r\n      }\r\n\r\n      return this.request(function (error, response) {\r\n        var processor = this._processGeocoderResponse;\r\n        var results = (!error) ? processor(response) : undefined;\r\n        callback.call(context, error, { results: results }, response);\r\n      }, this);\r\n    },\r\n\r\n    _processGeocoderResponse: function (response) {\r\n      var results = [];\r\n\r\n      for (var i = 0; i < response.candidates.length; i++) {\r\n        var candidate = response.candidates[i];\r\n        if (candidate.extent) {\r\n          var bounds = esriLeaflet.Util.extentToBounds(candidate.extent);\r\n        }\r\n\r\n        results.push({\r\n          text: candidate.address,\r\n          bounds: bounds,\r\n          score: candidate.score,\r\n          latlng: leaflet.latLng(candidate.location.y, candidate.location.x),\r\n          properties: candidate.attributes\r\n        });\r\n      }\r\n      return results;\r\n    }\r\n  });\r\n\r\n  function geocode (options) {\r\n    return new Geocode(options);\r\n  }\n\n  var ReverseGeocode = esriLeaflet.Task.extend({\r\n    path: 'reverseGeocode',\r\n\r\n    params: {\r\n      outSR: 4326,\r\n      returnIntersection: false\r\n    },\r\n\r\n    setters: {\r\n      distance: 'distance',\r\n      language: 'langCode',\r\n      intersection: 'returnIntersection',\r\n      apikey: 'apikey'\r\n    },\r\n\r\n    initialize: function (options) {\r\n      options = options || {};\r\n      options.url = options.url || WorldGeocodingServiceUrl;\r\n      esriLeaflet.Task.prototype.initialize.call(this, options);\r\n    },\r\n\r\n    latlng: function (coords) {\r\n      var centroid = leaflet.latLng(coords);\r\n      this.params.location = centroid.lng + ',' + centroid.lat;\r\n      return this;\r\n    },\r\n\r\n    run: function (callback, context) {\r\n      if (this.options.token) {\r\n        this.params.token = this.options.token;\r\n      }\r\n      if (this.options.apikey) {\r\n        this.params.token = this.options.apikey;\r\n      }\r\n      return this.request(function (error, response) {\r\n        var result;\r\n\r\n        if (!error) {\r\n          result = {\r\n            latlng: leaflet.latLng(response.location.y, response.location.x),\r\n            address: response.address\r\n          };\r\n        } else {\r\n          result = undefined;\r\n        }\r\n\r\n        callback.call(context, error, result, response);\r\n      }, this);\r\n    }\r\n  });\r\n\r\n  function reverseGeocode (options) {\r\n    return new ReverseGeocode(options);\r\n  }\n\n  var Suggest = esriLeaflet.Task.extend({\r\n    path: 'suggest',\r\n\r\n    params: {},\r\n\r\n    setters: {\r\n      text: 'text',\r\n      category: 'category',\r\n      countries: 'countryCode',\r\n      maxSuggestions: 'maxSuggestions'\r\n    },\r\n\r\n    initialize: function (options) {\r\n      options = options || {};\r\n      if (!options.url) {\r\n        options.url = WorldGeocodingServiceUrl;\r\n        options.supportsSuggest = true;\r\n      }\r\n      esriLeaflet.Task.prototype.initialize.call(this, options);\r\n    },\r\n\r\n    within: function (bounds) {\r\n      bounds = leaflet.latLngBounds(bounds);\r\n      var center = bounds.getCenter();\r\n      var ne = bounds.getNorthWest();\r\n      this.params.location = center.lng + ',' + center.lat;\r\n      this.params.distance = Math.min(Math.max(center.distanceTo(ne), 2000), 50000);\r\n      this.params.searchExtent = esriLeaflet.Util.boundsToExtent(bounds);\r\n      return this;\r\n    },\r\n\r\n    nearby: function (coords, radius) {\r\n      var centroid = leaflet.latLng(coords);\r\n      this.params.location = centroid.lng + ',' + centroid.lat;\r\n      if (radius) {\r\n        this.params.distance = Math.min(Math.max(radius, 2000), 50000);\r\n      }\r\n      return this;\r\n    },\r\n\r\n    run: function (callback, context) {\r\n      if (this.options.supportsSuggest) {\r\n        return this.request(function (error, response) {\r\n          callback.call(context, error, response, response);\r\n        }, this);\r\n      } else {\r\n        console.warn('this geocoding service does not support asking for suggestions');\r\n      }\r\n    }\r\n\r\n  });\r\n\r\n  function suggest (options) {\r\n    return new Suggest(options);\r\n  }\n\n  var GeocodeService = esriLeaflet.Service.extend({\r\n    initialize: function (options) {\r\n      options = options || {};\r\n      if (options.apikey) {\r\n        options.token = options.apikey;\r\n      }\r\n      if (options.url) {\r\n        esriLeaflet.Service.prototype.initialize.call(this, options);\r\n        this._confirmSuggestSupport();\r\n      } else {\r\n        options.url = WorldGeocodingServiceUrl;\r\n        options.supportsSuggest = true;\r\n        esriLeaflet.Service.prototype.initialize.call(this, options);\r\n      }\r\n    },\r\n\r\n    geocode: function () {\r\n      return geocode(this);\r\n    },\r\n\r\n    reverse: function () {\r\n      return reverseGeocode(this);\r\n    },\r\n\r\n    suggest: function () {\r\n      // requires either the Esri World Geocoding Service or a <10.3 ArcGIS Server Geocoding Service that supports suggest.\r\n      return suggest(this);\r\n    },\r\n\r\n    _confirmSuggestSupport: function () {\r\n      this.metadata(function (error, response) {\r\n        if (error) { return; }\r\n        // pre 10.3 geocoding services dont list capabilities (and dont support maxLocations)\r\n        // only SOME individual services have been configured to support asking for suggestions\r\n        if (!response.capabilities) {\r\n          this.options.supportsSuggest = false;\r\n        } else if (response.capabilities.indexOf('Suggest') > -1) {\r\n          this.options.supportsSuggest = true;\r\n        } else {\r\n          this.options.supportsSuggest = false;\r\n        }\r\n        // whether the service supports suggest or not, utilize the metadata response to determine the appropriate parameter name for single line geocoding requests\r\n        this.options.customParam = response.singleLineAddressField.name;\r\n      }, this);\r\n    }\r\n  });\r\n\r\n  function geocodeService (options) {\r\n    return new GeocodeService(options);\r\n  }\n\n  var GeosearchCore = leaflet.Evented.extend({\r\n\r\n    options: {\r\n      zoomToResult: true,\r\n      useMapBounds: 12,\r\n      searchBounds: null\r\n    },\r\n\r\n    initialize: function (control, options) {\r\n      leaflet.Util.setOptions(this, options);\r\n      this._control = control;\r\n\r\n      if (!options || !options.providers || !options.providers.length) {\r\n        throw new Error('You must specify at least one provider');\r\n      }\r\n\r\n      this._providers = options.providers;\r\n    },\r\n\r\n    _geocode: function (text, key, provider) {\r\n      var activeRequests = 0;\r\n      var allResults = [];\r\n      var bounds;\r\n\r\n      var callback = leaflet.Util.bind(function (error, results) {\r\n        activeRequests--;\r\n        if (error) {\r\n          return;\r\n        }\r\n\r\n        if (results) {\r\n          allResults = allResults.concat(results);\r\n        }\r\n\r\n        if (activeRequests <= 0) {\r\n          bounds = this._boundsFromResults(allResults);\r\n\r\n          this.fire('results', {\r\n            results: allResults,\r\n            bounds: bounds,\r\n            latlng: (bounds) ? bounds.getCenter() : undefined,\r\n            text: text\r\n          }, true);\r\n\r\n          if (this.options.zoomToResult && bounds) {\r\n            this._control._map.fitBounds(bounds);\r\n          }\r\n\r\n          this.fire('load');\r\n        }\r\n      }, this);\r\n\r\n      if (key) {\r\n        activeRequests++;\r\n        provider.results(text, key, this._searchBounds(), callback);\r\n      } else {\r\n        for (var i = 0; i < this._providers.length; i++) {\r\n          activeRequests++;\r\n          this._providers[i].results(text, key, this._searchBounds(), callback);\r\n        }\r\n      }\r\n    },\r\n\r\n    _suggest: function (text) {\r\n      var activeRequests = this._providers.length;\r\n      var suggestionsLength = 0;\r\n\r\n      var createCallback = leaflet.Util.bind(function (text, provider) {\r\n        return leaflet.Util.bind(function (error, suggestions) {\r\n          activeRequests = activeRequests - 1;\r\n          suggestionsLength += suggestions.length;\r\n\r\n          if (error) {\r\n            // an error occurred for one of the providers' suggest requests\r\n            this._control._clearProviderSuggestions(provider);\r\n\r\n            // perform additional cleanup when all requests are finished\r\n            this._control._finalizeSuggestions(activeRequests, suggestionsLength);\r\n\r\n            return;\r\n          }\r\n\r\n          if (suggestions.length) {\r\n            for (var i = 0; i < suggestions.length; i++) {\r\n              suggestions[i].provider = provider;\r\n            }\r\n          } else {\r\n            // we still need to update the UI\r\n            this._control._renderSuggestions(suggestions);\r\n          }\r\n\r\n          if (provider._lastRender !== text) {\r\n            this._control._clearProviderSuggestions(provider);\r\n          }\r\n\r\n          if (suggestions.length && this._control._input.value === text) {\r\n            provider._lastRender = text;\r\n            this._control._renderSuggestions(suggestions);\r\n          }\r\n\r\n          // perform additional cleanup when all requests are finished\r\n          this._control._finalizeSuggestions(activeRequests, suggestionsLength);\r\n        }, this);\r\n      }, this);\r\n\r\n      this._pendingSuggestions = [];\r\n\r\n      for (var i = 0; i < this._providers.length; i++) {\r\n        var provider = this._providers[i];\r\n        var request = provider.suggestions(text, this._searchBounds(), createCallback(text, provider));\r\n        this._pendingSuggestions.push(request);\r\n      }\r\n    },\r\n\r\n    _searchBounds: function () {\r\n      if (this.options.searchBounds !== null) {\r\n        return this.options.searchBounds;\r\n      }\r\n\r\n      if (this.options.useMapBounds === false) {\r\n        return null;\r\n      }\r\n\r\n      if (this.options.useMapBounds === true) {\r\n        return this._control._map.getBounds();\r\n      }\r\n\r\n      if (this.options.useMapBounds <= this._control._map.getZoom()) {\r\n        return this._control._map.getBounds();\r\n      }\r\n\r\n      return null;\r\n    },\r\n\r\n    _boundsFromResults: function (results) {\r\n      if (!results.length) {\r\n        return;\r\n      }\r\n\r\n      var nullIsland = leaflet.latLngBounds([0, 0], [0, 0]);\r\n      var resultBounds = [];\r\n      var resultLatlngs = [];\r\n\r\n      // collect the bounds and center of each result\r\n      for (var i = results.length - 1; i >= 0; i--) {\r\n        var result = results[i];\r\n\r\n        resultLatlngs.push(result.latlng);\r\n\r\n        // make sure bounds are valid and not 0,0. sometimes bounds are incorrect or not present\r\n        if (result.bounds && result.bounds.isValid() && !result.bounds.equals(nullIsland)) {\r\n          resultBounds.push(result.bounds);\r\n        }\r\n      }\r\n\r\n      // form a bounds object containing all center points\r\n      var bounds = leaflet.latLngBounds(resultLatlngs);\r\n\r\n      // and extend it to contain all bounds objects\r\n      for (var j = 0; j < resultBounds.length; j++) {\r\n        bounds.extend(resultBounds[j]);\r\n      }\r\n\r\n      return bounds;\r\n    },\r\n\r\n    _getAttribution: function () {\r\n      var attribs = [];\r\n      var providers = this._providers;\r\n\r\n      for (var i = 0; i < providers.length; i++) {\r\n        if (providers[i].options.attribution) {\r\n          attribs.push(providers[i].options.attribution);\r\n        }\r\n      }\r\n\r\n      return attribs.join(', ');\r\n    }\r\n\r\n  });\r\n\r\n  function geosearchCore (control, options) {\r\n    return new GeosearchCore(control, options);\r\n  }\n\n  var ArcgisOnlineProvider = GeocodeService.extend({\r\n    options: {\r\n      label: 'Places and Addresses',\r\n      maxResults: 5\r\n    },\r\n\r\n    suggestions: function (text, bounds, callback) {\r\n      var request = this.suggest().text(text);\r\n\r\n      if (bounds) {\r\n        request.within(bounds);\r\n      }\r\n\r\n      if (this.options.nearby) {\r\n        // \"distance\"/\"radius\" is not supported by the ArcGIS Online Geocoder,\r\n        // so that is intentionally not passed here:\r\n        request.nearby(this.options.nearby);\r\n      }\r\n\r\n      if (this.options.countries) {\r\n        request.countries(this.options.countries);\r\n      }\r\n\r\n      if (this.options.categories) {\r\n        request.category(this.options.categories);\r\n      }\r\n\r\n      // 15 is the maximum number of suggestions that can be returned\r\n      request.maxSuggestions(this.options.maxResults);\r\n\r\n      return request.run(function (error, results, response) {\r\n        var suggestions = [];\r\n        if (!error) {\r\n          while (response.suggestions.length && suggestions.length <= (this.options.maxResults - 1)) {\r\n            var suggestion = response.suggestions.shift();\r\n            if (!suggestion.isCollection) {\r\n              suggestions.push({\r\n                text: suggestion.text,\r\n                unformattedText: suggestion.text,\r\n                magicKey: suggestion.magicKey\r\n              });\r\n            }\r\n          }\r\n        }\r\n        callback(error, suggestions);\r\n      }, this);\r\n    },\r\n\r\n    results: function (text, key, bounds, callback) {\r\n      var request = this.geocode().text(text);\r\n\r\n      if (key) {\r\n        request.key(key);\r\n      }\r\n      // in the future Address/StreetName geocoding requests that include a magicKey will always only return one match\r\n      request.maxLocations(this.options.maxResults);\r\n\r\n      if (bounds) {\r\n        request.within(bounds);\r\n      }\r\n\r\n      if (this.options.forStorage) {\r\n        request.forStorage(true);\r\n      }\r\n\r\n      if (this.options.nearby) {\r\n        // \"distance\"/\"radius\" is not supported by the ArcGIS Online Geocoder,\r\n        // so that is intentionally not passed here:\r\n        request.nearby(this.options.nearby);\r\n      }\r\n\r\n      if (this.options.countries) {\r\n        request.countries(this.options.countries);\r\n      }\r\n\r\n      if (this.options.categories) {\r\n        request.category(this.options.categories);\r\n      }\r\n\r\n      return request.run(function (error, response) {\r\n        callback(error, response.results);\r\n      }, this);\r\n    }\r\n  });\r\n\r\n  function arcgisOnlineProvider (options) {\r\n    return new ArcgisOnlineProvider(options);\r\n  }\n\n  var Geosearch = leaflet.Control.extend({\r\n    includes: leaflet.Evented.prototype,\r\n\r\n    options: {\r\n      position: 'topleft',\r\n      collapseAfterResult: true,\r\n      expanded: false,\r\n      allowMultipleResults: true,\r\n      placeholder: 'Search for places or addresses',\r\n      title: 'Location Search'\r\n    },\r\n\r\n    initialize: function (options) {\r\n      leaflet.Util.setOptions(this, options);\r\n\r\n      if (!options || !options.providers || !options.providers.length) {\r\n        if (!options) {\r\n          options = {};\r\n        }\r\n        options.providers = [arcgisOnlineProvider()];\r\n      }\r\n\r\n      // instantiate the underlying class and pass along options\r\n      this._geosearchCore = geosearchCore(this, options);\r\n      this._geosearchCore._providers = options.providers;\r\n\r\n      // bubble each providers events to the control\r\n      this._geosearchCore.addEventParent(this);\r\n      for (var i = 0; i < this._geosearchCore._providers.length; i++) {\r\n        this._geosearchCore._providers[i].addEventParent(this);\r\n      }\r\n\r\n      this._geosearchCore._pendingSuggestions = [];\r\n\r\n      leaflet.Control.prototype.initialize.call(this, options);\r\n    },\r\n\r\n    _renderSuggestions: function (suggestions) {\r\n      var currentGroup;\r\n\r\n      if (suggestions.length > 0) {\r\n        this._suggestions.style.display = 'block';\r\n      }\r\n\r\n      var list;\r\n      var header;\r\n      var suggestionTextArray = [];\r\n\r\n      for (var i = 0; i < suggestions.length; i++) {\r\n        var suggestion = suggestions[i];\r\n        if (!header && this._geosearchCore._providers.length > 1 && currentGroup !== suggestion.provider.options.label) {\r\n          header = leaflet.DomUtil.create('div', 'geocoder-control-header', suggestion.provider._contentsElement);\r\n          header.textContent = suggestion.provider.options.label;\r\n          header.innerText = suggestion.provider.options.label;\r\n          currentGroup = suggestion.provider.options.label;\r\n        }\r\n\r\n        if (!list) {\r\n          list = leaflet.DomUtil.create('ul', 'geocoder-control-list', suggestion.provider._contentsElement);\r\n        }\r\n\r\n        if (suggestionTextArray.indexOf(suggestion.text) === -1) {\r\n          var suggestionItem = leaflet.DomUtil.create('li', 'geocoder-control-suggestion', list);\r\n\r\n          suggestionItem.innerHTML = suggestion.text;\r\n          suggestionItem.provider = suggestion.provider;\r\n          suggestionItem['data-magic-key'] = suggestion.magicKey;\r\n          suggestionItem.unformattedText = suggestion.unformattedText;\r\n        } else {\r\n          for (var j = 0; j < list.childNodes.length; j++) {\r\n            // if the same text already appears in the list of suggestions, append an additional ObjectID to its magicKey instead\r\n            if (list.childNodes[j].innerHTML === suggestion.text) {\r\n              list.childNodes[j]['data-magic-key'] += ',' + suggestion.magicKey;\r\n            }\r\n          }\r\n        }\r\n        suggestionTextArray.push(suggestion.text);\r\n      }\r\n\r\n      // when the geocoder position is either \"topleft\" or \"topright\":\r\n      // set the maxHeight of the suggestions box to:\r\n      //  map height\r\n      //  - suggestions offset (distance from top of suggestions to top of control)\r\n      //  - control offset (distance from top of control to top of map)\r\n      //  - 10 (extra padding)\r\n      if (this.getPosition().indexOf('top') > -1) {\r\n        this._suggestions.style.maxHeight = (this._map.getSize().y - this._suggestions.offsetTop - this._wrapper.offsetTop - 10) + 'px';\r\n      }\r\n\r\n      // when the geocoder position is either \"bottomleft\" or \"bottomright\":\r\n      // 1. set the maxHeight of the suggestions box to:\r\n      //  map height\r\n      //  - corner control container offsetHeight (height of container of bottom corner)\r\n      //  - control offsetHeight (height of geocoder control wrapper, the main expandable button)\r\n      // 2. to move it up, set the top of the suggestions box to:\r\n      //  negative offsetHeight of suggestions box (its own negative height now that it has children elements\r\n      //  - control offsetHeight (height of geocoder control wrapper, the main expandable button)\r\n      //  + 20 (extra spacing)\r\n      if (this.getPosition().indexOf('bottom') > -1) {\r\n        this._setSuggestionsBottomPosition();\r\n      }\r\n    },\r\n\r\n    _setSuggestionsBottomPosition: function () {\r\n      this._suggestions.style.maxHeight = (this._map.getSize().y - this._map._controlCorners[this.getPosition()].offsetHeight - this._wrapper.offsetHeight) + 'px';\r\n      this._suggestions.style.top = (-this._suggestions.offsetHeight - this._wrapper.offsetHeight + 20) + 'px';\r\n    },\r\n\r\n    _boundsFromResults: function (results) {\r\n      if (!results.length) {\r\n        return;\r\n      }\r\n\r\n      var nullIsland = leaflet.latLngBounds([0, 0], [0, 0]);\r\n      var resultBounds = [];\r\n      var resultLatlngs = [];\r\n\r\n      // collect the bounds and center of each result\r\n      for (var i = results.length - 1; i >= 0; i--) {\r\n        var result = results[i];\r\n\r\n        resultLatlngs.push(result.latlng);\r\n\r\n        // make sure bounds are valid and not 0,0. sometimes bounds are incorrect or not present\r\n        if (result.bounds && result.bounds.isValid() && !result.bounds.equals(nullIsland)) {\r\n          resultBounds.push(result.bounds);\r\n        }\r\n      }\r\n\r\n      // form a bounds object containing all center points\r\n      var bounds = leaflet.latLngBounds(resultLatlngs);\r\n\r\n      // and extend it to contain all bounds objects\r\n      for (var j = 0; j < resultBounds.length; j++) {\r\n        bounds.extend(resultBounds[j]);\r\n      }\r\n\r\n      return bounds;\r\n    },\r\n\r\n    clear: function () {\r\n      this._clearAllSuggestions();\r\n\r\n      if (this.options.collapseAfterResult) {\r\n        this._input.value = '';\r\n        this._lastValue = '';\r\n        this._input.placeholder = '';\r\n        leaflet.DomUtil.removeClass(this._wrapper, 'geocoder-control-expanded');\r\n      }\r\n\r\n      if (!this._map.scrollWheelZoom.enabled() && this._map.options.scrollWheelZoom) {\r\n        this._map.scrollWheelZoom.enable();\r\n      }\r\n    },\r\n\r\n    _clearAllSuggestions: function () {\r\n      this._suggestions.style.display = 'none';\r\n\r\n      for (var i = 0; i < this.options.providers.length; i++) {\r\n        this._clearProviderSuggestions(this.options.providers[i]);\r\n      }\r\n    },\r\n\r\n    _clearProviderSuggestions: function (provider) {\r\n      provider._contentsElement.innerHTML = '';\r\n    },\r\n\r\n    _finalizeSuggestions: function (activeRequests, suggestionsLength) {\r\n      // check if all requests are finished to remove the loading indicator\r\n      if (!activeRequests) {\r\n        leaflet.DomUtil.removeClass(this._input, 'geocoder-control-loading');\r\n\r\n        // when the geocoder position is either \"bottomleft\" or \"bottomright\",\r\n        // it is necessary in some cases to recalculate the maxHeight and top values of the this._suggestions element,\r\n        // even though this is also being done after each provider returns their own suggestions\r\n        if (this.getPosition().indexOf('bottom') > -1) {\r\n          this._setSuggestionsBottomPosition();\r\n        }\r\n\r\n        // also check if there were 0 total suggest results to clear the parent suggestions element\r\n        // otherwise its display value may be \"block\" instead of \"none\"\r\n        if (!suggestionsLength) {\r\n          this._clearAllSuggestions();\r\n        }\r\n      }\r\n    },\r\n\r\n    _setupClick: function () {\r\n      leaflet.DomUtil.addClass(this._wrapper, 'geocoder-control-expanded');\r\n      this._input.focus();\r\n    },\r\n\r\n    disable: function () {\r\n      this._input.disabled = true;\r\n      leaflet.DomUtil.addClass(this._input, 'geocoder-control-input-disabled');\r\n      leaflet.DomEvent.removeListener(this._wrapper, 'click', this._setupClick, this);\r\n    },\r\n\r\n    enable: function () {\r\n      this._input.disabled = false;\r\n      leaflet.DomUtil.removeClass(this._input, 'geocoder-control-input-disabled');\r\n      leaflet.DomEvent.addListener(this._wrapper, 'click', this._setupClick, this);\r\n    },\r\n\r\n    getAttribution: function () {\r\n      var attribs = [];\r\n\r\n      for (var i = 0; i < this._providers.length; i++) {\r\n        if (this._providers[i].options.attribution) {\r\n          attribs.push(this._providers[i].options.attribution);\r\n        }\r\n      }\r\n\r\n      return attribs.join(', ');\r\n    },\r\n\r\n    geocodeSuggestion: function (e) {\r\n      var suggestionItem = e.target || e.srcElement;\r\n\r\n      if (\r\n        suggestionItem.classList.contains('geocoder-control-suggestions') ||\r\n        suggestionItem.classList.contains('geocoder-control-header')\r\n      ) {\r\n        return;\r\n      }\r\n\r\n      // make sure and point at the actual 'geocoder-control-suggestion'\r\n      if (suggestionItem.classList.length < 1) {\r\n        suggestionItem = suggestionItem.parentNode;\r\n      }\r\n\r\n      this._geosearchCore._geocode(suggestionItem.unformattedText, suggestionItem['data-magic-key'], suggestionItem.provider);\r\n      this.clear();\r\n    },\r\n\r\n    onAdd: function (map) {\r\n      // include 'Powered by Esri' in map attribution\r\n      esriLeaflet.Util.setEsriAttribution(map);\r\n\r\n      this._map = map;\r\n      this._wrapper = leaflet.DomUtil.create('div', 'geocoder-control');\r\n      this._input = leaflet.DomUtil.create('input', 'geocoder-control-input leaflet-bar', this._wrapper);\r\n      this._input.title = this.options.title;\r\n\r\n      if (this.options.expanded) {\r\n        leaflet.DomUtil.addClass(this._wrapper, 'geocoder-control-expanded');\r\n        this._input.placeholder = this.options.placeholder;\r\n      }\r\n\r\n      // create the main suggested results container element\r\n      this._suggestions = leaflet.DomUtil.create('div', 'geocoder-control-suggestions leaflet-bar', this._wrapper);\r\n\r\n      // create a child contents container element for each provider inside of this._suggestions\r\n      // to maintain the configured order of providers for suggested results\r\n      for (var i = 0; i < this.options.providers.length; i++) {\r\n        this.options.providers[i]._contentsElement = leaflet.DomUtil.create('div', null, this._suggestions);\r\n      }\r\n\r\n      var credits = this._geosearchCore._getAttribution();\r\n\r\n      if (map.attributionControl) {\r\n        map.attributionControl.addAttribution(credits);\r\n      }\r\n\r\n      leaflet.DomEvent.addListener(this._input, 'focus', function (e) {\r\n        this._input.placeholder = this.options.placeholder;\r\n        leaflet.DomUtil.addClass(this._wrapper, 'geocoder-control-expanded');\r\n      }, this);\r\n\r\n      leaflet.DomEvent.addListener(this._wrapper, 'click', this._setupClick, this);\r\n\r\n      // make sure both click and touch spawn an address/poi search\r\n      leaflet.DomEvent.addListener(this._suggestions, 'mousedown', this.geocodeSuggestion, this);\r\n\r\n      leaflet.DomEvent.addListener(this._input, 'blur', function (e) {\r\n        // TODO: this is too greedy and should not \"clear\"\r\n        // when trying to use the scrollbar or clicking on a non-suggestion item (such as a provider header)\r\n        this.clear();\r\n      }, this);\r\n\r\n      leaflet.DomEvent.addListener(this._input, 'keydown', function (e) {\r\n        var text = (e.target || e.srcElement).value;\r\n\r\n        leaflet.DomUtil.addClass(this._wrapper, 'geocoder-control-expanded');\r\n\r\n        var list = this._suggestions.querySelectorAll('.' + 'geocoder-control-suggestion');\r\n        var selected = this._suggestions.querySelectorAll('.' + 'geocoder-control-selected')[0];\r\n        var selectedPosition;\r\n\r\n        for (var i = 0; i < list.length; i++) {\r\n          if (list[i] === selected) {\r\n            selectedPosition = i;\r\n            break;\r\n          }\r\n        }\r\n\r\n        switch (e.keyCode) {\r\n          case 13:\r\n            /*\r\n              if an item has been selected, geocode it\r\n              if focus is on the input textbox, geocode only if multiple results are allowed and more than two characters are present, or if a single suggestion is displayed.\r\n              if less than two characters have been typed, abort the geocode\r\n            */\r\n            if (selected) {\r\n              this._input.value = selected.innerText;\r\n              this._geosearchCore._geocode(selected.unformattedText, selected['data-magic-key'], selected.provider);\r\n              this.clear();\r\n            } else if (this.options.allowMultipleResults && text.length >= 2) {\r\n              this._geosearchCore._geocode(this._input.value, undefined);\r\n              this.clear();\r\n            } else {\r\n              if (list.length === 1) {\r\n                leaflet.DomUtil.addClass(list[0], 'geocoder-control-selected');\r\n                this._geosearchCore._geocode(list[0].innerHTML, list[0]['data-magic-key'], list[0].provider);\r\n              } else {\r\n                this.clear();\r\n                this._input.blur();\r\n              }\r\n            }\r\n            leaflet.DomEvent.preventDefault(e);\r\n            break;\r\n          case 38:\r\n            if (selected) {\r\n              leaflet.DomUtil.removeClass(selected, 'geocoder-control-selected');\r\n            }\r\n\r\n            var previousItem = list[selectedPosition - 1];\r\n\r\n            if (selected && previousItem) {\r\n              leaflet.DomUtil.addClass(previousItem, 'geocoder-control-selected');\r\n            } else {\r\n              leaflet.DomUtil.addClass(list[list.length - 1], 'geocoder-control-selected');\r\n            }\r\n            leaflet.DomEvent.preventDefault(e);\r\n            break;\r\n          case 40:\r\n            if (selected) {\r\n              leaflet.DomUtil.removeClass(selected, 'geocoder-control-selected');\r\n            }\r\n\r\n            var nextItem = list[selectedPosition + 1];\r\n\r\n            if (selected && nextItem) {\r\n              leaflet.DomUtil.addClass(nextItem, 'geocoder-control-selected');\r\n            } else {\r\n              leaflet.DomUtil.addClass(list[0], 'geocoder-control-selected');\r\n            }\r\n            leaflet.DomEvent.preventDefault(e);\r\n            break;\r\n          default:\r\n            // when the input changes we should cancel all pending suggestion requests if possible to avoid result collisions\r\n            for (var x = 0; x < this._geosearchCore._pendingSuggestions.length; x++) {\r\n              var request = this._geosearchCore._pendingSuggestions[x];\r\n              if (request && request.abort && !request.id) {\r\n                request.abort();\r\n              }\r\n            }\r\n            break;\r\n        }\r\n      }, this);\r\n\r\n      leaflet.DomEvent.addListener(this._input, 'keyup', leaflet.Util.throttle(function (e) {\r\n        var key = e.which || e.keyCode;\r\n        var text = (e.target || e.srcElement).value;\r\n\r\n        // require at least 2 characters for suggestions\r\n        if (text.length < 2) {\r\n          this._lastValue = this._input.value;\r\n          this._clearAllSuggestions();\r\n          leaflet.DomUtil.removeClass(this._input, 'geocoder-control-loading');\r\n          return;\r\n        }\r\n\r\n        // if this is the escape key it will clear the input so clear suggestions\r\n        if (key === 27) {\r\n          this._clearAllSuggestions();\r\n          return;\r\n        }\r\n\r\n        // if this is NOT the up/down arrows or enter make a suggestion\r\n        if (key !== 13 && key !== 38 && key !== 40) {\r\n          if (this._input.value !== this._lastValue) {\r\n            this._lastValue = this._input.value;\r\n            leaflet.DomUtil.addClass(this._input, 'geocoder-control-loading');\r\n            this._geosearchCore._suggest(text);\r\n          }\r\n        }\r\n      }, 50, this), this);\r\n\r\n      leaflet.DomEvent.disableClickPropagation(this._wrapper);\r\n\r\n      // when mouse moves over suggestions disable scroll wheel zoom if its enabled\r\n      leaflet.DomEvent.addListener(this._suggestions, 'mouseover', function (e) {\r\n        if (map.scrollWheelZoom.enabled() && map.options.scrollWheelZoom) {\r\n          map.scrollWheelZoom.disable();\r\n        }\r\n      });\r\n\r\n      // when mouse moves leaves suggestions enable scroll wheel zoom if its disabled\r\n      leaflet.DomEvent.addListener(this._suggestions, 'mouseout', function (e) {\r\n        if (!map.scrollWheelZoom.enabled() && map.options.scrollWheelZoom) {\r\n          map.scrollWheelZoom.enable();\r\n        }\r\n      });\r\n\r\n      this._geosearchCore.on('load', function (e) {\r\n        leaflet.DomUtil.removeClass(this._input, 'geocoder-control-loading');\r\n        this.clear();\r\n        this._input.blur();\r\n      }, this);\r\n\r\n      return this._wrapper;\r\n    }\r\n  });\r\n\r\n  function geosearch (options) {\r\n    return new Geosearch(options);\r\n  }\n\n  var FeatureLayerProvider = esriLeaflet.FeatureLayerService.extend({\r\n    options: {\r\n      label: 'Feature Layer',\r\n      maxResults: 5,\r\n      bufferRadius: 1000,\r\n      searchMode: 'contain',\r\n      formatSuggestion: function (feature) {\r\n        return feature.properties[this.options.searchFields[0]];\r\n      }\r\n    },\r\n\r\n    initialize: function (options) {\r\n      if (options.apikey) {\r\n        options.token = options.apikey;\r\n      }\r\n      esriLeaflet.FeatureLayerService.prototype.initialize.call(this, options);\r\n      if (typeof this.options.searchFields === 'string') {\r\n        this.options.searchFields = [this.options.searchFields];\r\n      }\r\n      this._suggestionsQuery = this.query();\r\n      this._resultsQuery = this.query();\r\n    },\r\n\r\n    suggestions: function (text, bounds, callback) {\r\n      var query = this._suggestionsQuery.where(this._buildQuery(text))\r\n        .returnGeometry(false);\r\n\r\n      if (bounds) {\r\n        query.intersects(bounds);\r\n      }\r\n\r\n      if (this.options.idField) {\r\n        query.fields([this.options.idField].concat(this.options.searchFields));\r\n      }\r\n\r\n      var request = query.run(function (error, results, raw) {\r\n        if (error) {\r\n          callback(error, []);\r\n        } else {\r\n          this.options.idField = raw.objectIdFieldName;\r\n          var suggestions = [];\r\n          for (var i = results.features.length - 1; i >= 0; i--) {\r\n            var feature = results.features[i];\r\n            suggestions.push({\r\n              text: this.options.formatSuggestion.call(this, feature),\r\n              unformattedText: feature.properties[this.options.searchFields[0]],\r\n              magicKey: feature.id\r\n            });\r\n          }\r\n          callback(error, suggestions.slice(0, this.options.maxResults));\r\n        }\r\n      }, this);\r\n\r\n      return request;\r\n    },\r\n\r\n    results: function (text, key, bounds, callback) {\r\n      var query = this._resultsQuery;\r\n\r\n      if (key) {\r\n        // if there are 1 or more keys available, use query.featureIds()\r\n        delete query.params.where;\r\n        query.featureIds([key]);\r\n      } else {\r\n        // if there are no keys available, use query.where()\r\n        query.where(this._buildQuery(text));\r\n      }\r\n\r\n      if (bounds) {\r\n        query.within(bounds);\r\n      }\r\n\r\n      return query.run(leaflet.Util.bind(function (error, features) {\r\n        var results = [];\r\n        for (var i = 0; i < features.features.length; i++) {\r\n          var feature = features.features[i];\r\n          if (feature) {\r\n            var bounds = this._featureBounds(feature);\r\n\r\n            var result = {\r\n              latlng: bounds.getCenter(),\r\n              bounds: bounds,\r\n              text: this.options.formatSuggestion.call(this, feature),\r\n              properties: feature.properties,\r\n              geojson: feature\r\n            };\r\n\r\n            results.push(result);\r\n\r\n            // clear query parameters for the next search\r\n            delete this._resultsQuery.params['objectIds'];\r\n          }\r\n        }\r\n        callback(error, results);\r\n      }, this));\r\n    },\r\n\r\n    orderBy: function (fieldName, order) {\r\n      this._suggestionsQuery.orderBy(fieldName, order);\r\n    },\r\n\r\n    _buildQuery: function (text) {\r\n      var queryString = [];\r\n\r\n      for (var i = this.options.searchFields.length - 1; i >= 0; i--) {\r\n        var field = 'upper(\"' + this.options.searchFields[i] + '\")';\r\n        if (this.options.searchMode === 'contain') {\r\n          queryString.push(field + \" LIKE upper('%\" + text + \"%')\");\r\n        } else if (this.options.searchMode === 'startWith') {\r\n          queryString.push(field + \" LIKE upper('\" + text + \"%')\");\r\n        } else if (this.options.searchMode === 'endWith') {\r\n          queryString.push(field + \" LIKE upper('%\" + text + \"')\");\r\n        } else if (this.options.searchMode === 'strict') {\r\n          queryString.push(field + \" LIKE upper('\" + text + \"')\");\r\n        } else {\r\n          throw new Error('L.esri.Geocoding.featureLayerProvider: Invalid parameter for \"searchMode\". Use one of \"contain\", \"startWith\", \"endWith\", or \"strict\"');\r\n        }\r\n      }\r\n      if (this.options.where) {\r\n        return this.options.where + ' AND (' + queryString.join(' OR ') + ')';\r\n      } else {\r\n        return queryString.join(' OR ');\r\n      }\r\n    },\r\n\r\n    _featureBounds: function (feature) {\r\n      var geojson = leaflet.geoJson(feature);\r\n      if (feature.geometry.type === 'Point') {\r\n        var center = geojson.getBounds().getCenter();\r\n        var lngRadius = ((this.options.bufferRadius / 40075017) * 360) / Math.cos((180 / Math.PI) * center.lat);\r\n        var latRadius = (this.options.bufferRadius / 40075017) * 360;\r\n        return leaflet.latLngBounds([center.lat - latRadius, center.lng - lngRadius], [center.lat + latRadius, center.lng + lngRadius]);\r\n      } else {\r\n        return geojson.getBounds();\r\n      }\r\n    }\r\n  });\r\n\r\n  function featureLayerProvider (options) {\r\n    return new FeatureLayerProvider(options);\r\n  }\n\n  var MapServiceProvider = esriLeaflet.MapService.extend({\r\n    options: {\r\n      layers: [0],\r\n      label: 'Map Service',\r\n      bufferRadius: 1000,\r\n      maxResults: 5,\r\n      formatSuggestion: function (feature) {\r\n        return feature.properties[feature.displayFieldName] + ' <small>' + feature.layerName + '</small>';\r\n      }\r\n    },\r\n\r\n    initialize: function (options) {\r\n      if (options.apikey) {\r\n        options.token = options.apikey;\r\n      }\r\n      esriLeaflet.MapService.prototype.initialize.call(this, options);\r\n      this._getIdFields();\r\n    },\r\n\r\n    suggestions: function (text, bounds, callback) {\r\n      var request = this.find().text(text).fields(this.options.searchFields).returnGeometry(false).layers(this.options.layers);\r\n\r\n      return request.run(function (error, results, raw) {\r\n        var suggestions = [];\r\n        if (!error) {\r\n          var count = Math.min(this.options.maxResults, results.features.length);\r\n          raw.results = raw.results.reverse();\r\n          for (var i = 0; i < count; i++) {\r\n            var feature = results.features[i];\r\n            var result = raw.results[i];\r\n            var layer = result.layerId;\r\n            var idField = this._idFields[layer];\r\n            feature.layerId = layer;\r\n            feature.layerName = this._layerNames[layer];\r\n            feature.displayFieldName = this._displayFields[layer];\r\n            if (idField) {\r\n              suggestions.push({\r\n                text: this.options.formatSuggestion.call(this, feature),\r\n                unformattedText: feature.properties[feature.displayFieldName],\r\n                magicKey: result.attributes[idField] + ':' + layer\r\n              });\r\n            }\r\n          }\r\n        }\r\n        callback(error, suggestions.reverse());\r\n      }, this);\r\n    },\r\n\r\n    results: function (text, key, bounds, callback) {\r\n      var results = [];\r\n      var request;\r\n\r\n      if (key && !key.includes(',')) {\r\n        // if there is only 1 key available, use query()\r\n        var featureId = key.split(':')[0];\r\n        var layer = key.split(':')[1];\r\n        request = this.query().layer(layer).featureIds(featureId);\r\n      } else {\r\n        // if there are no keys or more than 1 keys available, use find()\r\n        request = this.find().text(text).fields(this.options.searchFields).layers(this.options.layers);\r\n      }\r\n\r\n      return request.run(function (error, features, response) {\r\n        if (!error) {\r\n          if (response.results) {\r\n            response.results = response.results.reverse();\r\n          }\r\n          for (var i = 0; i < features.features.length; i++) {\r\n            var feature = features.features[i];\r\n            layer = layer || response.results[i].layerId;\r\n\r\n            if (feature && layer !== undefined) {\r\n              var bounds = this._featureBounds(feature);\r\n              feature.layerId = layer;\r\n              feature.layerName = this._layerNames[layer];\r\n              feature.displayFieldName = this._displayFields[layer];\r\n\r\n              var result = {\r\n                latlng: bounds.getCenter(),\r\n                bounds: bounds,\r\n                text: this.options.formatSuggestion.call(this, feature),\r\n                properties: feature.properties,\r\n                geojson: feature\r\n              };\r\n\r\n              results.push(result);\r\n            }\r\n          }\r\n        }\r\n        callback(error, results.reverse());\r\n      }, this);\r\n    },\r\n\r\n    _featureBounds: function (feature) {\r\n      var geojson = leaflet.geoJson(feature);\r\n      if (feature.geometry.type === 'Point') {\r\n        var center = geojson.getBounds().getCenter();\r\n        var lngRadius = ((this.options.bufferRadius / 40075017) * 360) / Math.cos((180 / Math.PI) * center.lat);\r\n        var latRadius = (this.options.bufferRadius / 40075017) * 360;\r\n        return leaflet.latLngBounds([center.lat - latRadius, center.lng - lngRadius], [center.lat + latRadius, center.lng + lngRadius]);\r\n      } else {\r\n        return geojson.getBounds();\r\n      }\r\n    },\r\n\r\n    _layerMetadataCallback: function (layerid) {\r\n      return leaflet.Util.bind(function (error, metadata) {\r\n        if (error) { return; }\r\n        this._displayFields[layerid] = metadata.displayField;\r\n        this._layerNames[layerid] = metadata.name;\r\n        for (var i = 0; i < metadata.fields.length; i++) {\r\n          var field = metadata.fields[i];\r\n          if (field.type === 'esriFieldTypeOID') {\r\n            this._idFields[layerid] = field.name;\r\n            break;\r\n          }\r\n        }\r\n      }, this);\r\n    },\r\n\r\n    _getIdFields: function () {\r\n      this._idFields = {};\r\n      this._displayFields = {};\r\n      this._layerNames = {};\r\n      for (var i = 0; i < this.options.layers.length; i++) {\r\n        var layer = this.options.layers[i];\r\n        this.get(layer, {}, this._layerMetadataCallback(layer));\r\n      }\r\n    }\r\n  });\r\n\r\n  function mapServiceProvider (options) {\r\n    return new MapServiceProvider(options);\r\n  }\n\n  var GeocodeServiceProvider = GeocodeService.extend({\r\n    options: {\r\n      label: 'Geocode Server',\r\n      maxResults: 5\r\n    },\r\n\r\n    suggestions: function (text, bounds, callback) {\r\n      if (this.options.supportsSuggest) {\r\n        var request = this.suggest().text(text);\r\n        if (bounds) {\r\n          request.within(bounds);\r\n        }\r\n\r\n        return request.run(function (error, results, response) {\r\n          var suggestions = [];\r\n          if (!error) {\r\n            while (response.suggestions.length && suggestions.length <= (this.options.maxResults - 1)) {\r\n              var suggestion = response.suggestions.shift();\r\n              if (!suggestion.isCollection) {\r\n                suggestions.push({\r\n                  text: suggestion.text,\r\n                  unformattedText: suggestion.text,\r\n                  magicKey: suggestion.magicKey\r\n                });\r\n              }\r\n            }\r\n          }\r\n          callback(error, suggestions);\r\n        }, this);\r\n      } else {\r\n        callback(null, []);\r\n        return false;\r\n      }\r\n    },\r\n\r\n    results: function (text, key, bounds, callback) {\r\n      var request = this.geocode().text(text);\r\n\r\n      if (key) {\r\n        request.key(key);\r\n      }\r\n\r\n      request.maxLocations(this.options.maxResults);\r\n\r\n      if (bounds) {\r\n        request.within(bounds);\r\n      }\r\n\r\n      return request.run(function (error, response) {\r\n        callback(error, response.results);\r\n      }, this);\r\n    }\r\n  });\r\n\r\n  function geocodeServiceProvider (options) {\r\n    return new GeocodeServiceProvider(options);\r\n  }\n\n  exports.ArcgisOnlineProvider = ArcgisOnlineProvider;\n  exports.FeatureLayerProvider = FeatureLayerProvider;\n  exports.Geocode = Geocode;\n  exports.GeocodeService = GeocodeService;\n  exports.GeocodeServiceProvider = GeocodeServiceProvider;\n  exports.Geosearch = Geosearch;\n  exports.GeosearchCore = GeosearchCore;\n  exports.MapServiceProvider = MapServiceProvider;\n  exports.ReverseGeocode = ReverseGeocode;\n  exports.Suggest = Suggest;\n  exports.VERSION = version;\n  exports.WorldGeocodingServiceUrl = WorldGeocodingServiceUrl;\n  exports.arcgisOnlineProvider = arcgisOnlineProvider;\n  exports.featureLayerProvider = featureLayerProvider;\n  exports.geocode = geocode;\n  exports.geocodeService = geocodeService;\n  exports.geocodeServiceProvider = geocodeServiceProvider;\n  exports.geosearch = geosearch;\n  exports.geosearchCore = geosearchCore;\n  exports.mapServiceProvider = mapServiceProvider;\n  exports.reverseGeocode = reverseGeocode;\n  exports.suggest = suggest;\n\n  Object.defineProperty(exports, '__esModule', { value: true });\n\n}));\n//# sourceMappingURL=esri-leaflet-geocoder-debug.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet-geocoder/dist/esri-leaflet-geocoder-debug.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/EsriLeaflet.js":
/*!******************************************************!*\
  !*** ./node_modules/esri-leaflet/src/EsriLeaflet.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"BasemapLayer\": () => (/* reexport safe */ _Layers_BasemapLayer__WEBPACK_IMPORTED_MODULE_15__.BasemapLayer),\n/* harmony export */   \"DynamicMapLayer\": () => (/* reexport safe */ _Layers_DynamicMapLayer__WEBPACK_IMPORTED_MODULE_19__.DynamicMapLayer),\n/* harmony export */   \"FeatureLayer\": () => (/* reexport safe */ _Layers_FeatureLayer_FeatureLayer__WEBPACK_IMPORTED_MODULE_21__.FeatureLayer),\n/* harmony export */   \"FeatureLayerService\": () => (/* reexport safe */ _Services_FeatureLayerService__WEBPACK_IMPORTED_MODULE_14__.FeatureLayerService),\n/* harmony export */   \"FeatureManager\": () => (/* reexport safe */ _Layers_FeatureLayer_FeatureManager__WEBPACK_IMPORTED_MODULE_20__.FeatureManager),\n/* harmony export */   \"Find\": () => (/* reexport safe */ _Tasks_Find__WEBPACK_IMPORTED_MODULE_7__.Find),\n/* harmony export */   \"Identify\": () => (/* reexport safe */ _Tasks_Identify__WEBPACK_IMPORTED_MODULE_8__.Identify),\n/* harmony export */   \"IdentifyFeatures\": () => (/* reexport safe */ _Tasks_IdentifyFeatures__WEBPACK_IMPORTED_MODULE_9__.IdentifyFeatures),\n/* harmony export */   \"IdentifyImage\": () => (/* reexport safe */ _Tasks_IdentifyImage__WEBPACK_IMPORTED_MODULE_10__.IdentifyImage),\n/* harmony export */   \"ImageMapLayer\": () => (/* reexport safe */ _Layers_ImageMapLayer__WEBPACK_IMPORTED_MODULE_18__.ImageMapLayer),\n/* harmony export */   \"ImageService\": () => (/* reexport safe */ _Services_ImageService__WEBPACK_IMPORTED_MODULE_13__.ImageService),\n/* harmony export */   \"MapService\": () => (/* reexport safe */ _Services_MapService__WEBPACK_IMPORTED_MODULE_12__.MapService),\n/* harmony export */   \"Query\": () => (/* reexport safe */ _Tasks_Query__WEBPACK_IMPORTED_MODULE_6__.Query),\n/* harmony export */   \"RasterLayer\": () => (/* reexport safe */ _Layers_RasterLayer__WEBPACK_IMPORTED_MODULE_17__.RasterLayer),\n/* harmony export */   \"Service\": () => (/* reexport safe */ _Services_Service__WEBPACK_IMPORTED_MODULE_11__.Service),\n/* harmony export */   \"Support\": () => (/* reexport safe */ _Support__WEBPACK_IMPORTED_MODULE_1__.Support),\n/* harmony export */   \"Task\": () => (/* reexport safe */ _Tasks_Task__WEBPACK_IMPORTED_MODULE_5__.Task),\n/* harmony export */   \"TiledMapLayer\": () => (/* reexport safe */ _Layers_TiledMapLayer__WEBPACK_IMPORTED_MODULE_16__.TiledMapLayer),\n/* harmony export */   \"Util\": () => (/* reexport safe */ _Util__WEBPACK_IMPORTED_MODULE_3__.EsriUtil),\n/* harmony export */   \"VERSION\": () => (/* binding */ version),\n/* harmony export */   \"basemapLayer\": () => (/* reexport safe */ _Layers_BasemapLayer__WEBPACK_IMPORTED_MODULE_15__.basemapLayer),\n/* harmony export */   \"dynamicMapLayer\": () => (/* reexport safe */ _Layers_DynamicMapLayer__WEBPACK_IMPORTED_MODULE_19__.dynamicMapLayer),\n/* harmony export */   \"featureLayer\": () => (/* reexport safe */ _Layers_FeatureLayer_FeatureLayer__WEBPACK_IMPORTED_MODULE_21__.featureLayer),\n/* harmony export */   \"featureLayerService\": () => (/* reexport safe */ _Services_FeatureLayerService__WEBPACK_IMPORTED_MODULE_14__.featureLayerService),\n/* harmony export */   \"find\": () => (/* reexport safe */ _Tasks_Find__WEBPACK_IMPORTED_MODULE_7__.find),\n/* harmony export */   \"get\": () => (/* reexport safe */ _Request__WEBPACK_IMPORTED_MODULE_4__.get),\n/* harmony export */   \"identify\": () => (/* reexport safe */ _Tasks_Identify__WEBPACK_IMPORTED_MODULE_8__.identify),\n/* harmony export */   \"identifyFeatures\": () => (/* reexport safe */ _Tasks_IdentifyFeatures__WEBPACK_IMPORTED_MODULE_9__.identifyFeatures),\n/* harmony export */   \"identifyImage\": () => (/* reexport safe */ _Tasks_IdentifyImage__WEBPACK_IMPORTED_MODULE_10__.identifyImage),\n/* harmony export */   \"imageMapLayer\": () => (/* reexport safe */ _Layers_ImageMapLayer__WEBPACK_IMPORTED_MODULE_18__.imageMapLayer),\n/* harmony export */   \"imageService\": () => (/* reexport safe */ _Services_ImageService__WEBPACK_IMPORTED_MODULE_13__.imageService),\n/* harmony export */   \"mapService\": () => (/* reexport safe */ _Services_MapService__WEBPACK_IMPORTED_MODULE_12__.mapService),\n/* harmony export */   \"options\": () => (/* reexport safe */ _Options__WEBPACK_IMPORTED_MODULE_2__.options),\n/* harmony export */   \"post\": () => (/* reexport safe */ _Request__WEBPACK_IMPORTED_MODULE_4__.post),\n/* harmony export */   \"query\": () => (/* reexport safe */ _Tasks_Query__WEBPACK_IMPORTED_MODULE_6__.query),\n/* harmony export */   \"request\": () => (/* reexport safe */ _Request__WEBPACK_IMPORTED_MODULE_4__.request),\n/* harmony export */   \"service\": () => (/* reexport safe */ _Services_Service__WEBPACK_IMPORTED_MODULE_11__.service),\n/* harmony export */   \"task\": () => (/* reexport safe */ _Tasks_Task__WEBPACK_IMPORTED_MODULE_5__.task),\n/* harmony export */   \"tiledMapLayer\": () => (/* reexport safe */ _Layers_TiledMapLayer__WEBPACK_IMPORTED_MODULE_16__.tiledMapLayer)\n/* harmony export */ });\n/* harmony import */ var _package_json__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../package.json */ \"./node_modules/esri-leaflet/package.json\");\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n/* harmony import */ var _Options__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options */ \"./node_modules/esri-leaflet/src/Options.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _Request__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Request */ \"./node_modules/esri-leaflet/src/Request.js\");\n/* harmony import */ var _Tasks_Task__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Tasks/Task */ \"./node_modules/esri-leaflet/src/Tasks/Task.js\");\n/* harmony import */ var _Tasks_Query__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Tasks/Query */ \"./node_modules/esri-leaflet/src/Tasks/Query.js\");\n/* harmony import */ var _Tasks_Find__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Tasks/Find */ \"./node_modules/esri-leaflet/src/Tasks/Find.js\");\n/* harmony import */ var _Tasks_Identify__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Tasks/Identify */ \"./node_modules/esri-leaflet/src/Tasks/Identify.js\");\n/* harmony import */ var _Tasks_IdentifyFeatures__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Tasks/IdentifyFeatures */ \"./node_modules/esri-leaflet/src/Tasks/IdentifyFeatures.js\");\n/* harmony import */ var _Tasks_IdentifyImage__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Tasks/IdentifyImage */ \"./node_modules/esri-leaflet/src/Tasks/IdentifyImage.js\");\n/* harmony import */ var _Services_Service__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Services/Service */ \"./node_modules/esri-leaflet/src/Services/Service.js\");\n/* harmony import */ var _Services_MapService__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Services/MapService */ \"./node_modules/esri-leaflet/src/Services/MapService.js\");\n/* harmony import */ var _Services_ImageService__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Services/ImageService */ \"./node_modules/esri-leaflet/src/Services/ImageService.js\");\n/* harmony import */ var _Services_FeatureLayerService__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Services/FeatureLayerService */ \"./node_modules/esri-leaflet/src/Services/FeatureLayerService.js\");\n/* harmony import */ var _Layers_BasemapLayer__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Layers/BasemapLayer */ \"./node_modules/esri-leaflet/src/Layers/BasemapLayer.js\");\n/* harmony import */ var _Layers_TiledMapLayer__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Layers/TiledMapLayer */ \"./node_modules/esri-leaflet/src/Layers/TiledMapLayer.js\");\n/* harmony import */ var _Layers_RasterLayer__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./Layers/RasterLayer */ \"./node_modules/esri-leaflet/src/Layers/RasterLayer.js\");\n/* harmony import */ var _Layers_ImageMapLayer__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./Layers/ImageMapLayer */ \"./node_modules/esri-leaflet/src/Layers/ImageMapLayer.js\");\n/* harmony import */ var _Layers_DynamicMapLayer__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Layers/DynamicMapLayer */ \"./node_modules/esri-leaflet/src/Layers/DynamicMapLayer.js\");\n/* harmony import */ var _Layers_FeatureLayer_FeatureManager__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./Layers/FeatureLayer/FeatureManager */ \"./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureManager.js\");\n/* harmony import */ var _Layers_FeatureLayer_FeatureLayer__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Layers/FeatureLayer/FeatureLayer */ \"./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureLayer.js\");\n// export version\r\n\r\nvar version = _package_json__WEBPACK_IMPORTED_MODULE_0__.version;\r\n\r\n\r\n// import base\r\n\r\n\r\n\r\n\r\n\r\n// export tasks\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n// export services\r\n\r\n\r\n\r\n\r\n\r\n// export layers\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/EsriLeaflet.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/BasemapLayer.js":
/*!**************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/BasemapLayer.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"BasemapLayer\": () => (/* binding */ BasemapLayer),\n/* harmony export */   \"basemapLayer\": () => (/* binding */ basemapLayer),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar tileProtocol = (window.location.protocol !== 'https:') ? 'http:' : 'https:';\r\n\r\nvar BasemapLayer = leaflet__WEBPACK_IMPORTED_MODULE_0__.TileLayer.extend({\r\n  statics: {\r\n    TILES: {\r\n      Streets: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'USGS, NOAA',\r\n          attributionUrl: 'https://static.arcgis.com/attribution/World_Street_Map'\r\n        }\r\n      },\r\n      Topographic: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'USGS, NOAA',\r\n          attributionUrl: 'https://static.arcgis.com/attribution/World_Topo_Map'\r\n        }\r\n      },\r\n      Oceans: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/arcgis/rest/services/Ocean/World_Ocean_Base/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'USGS, NOAA',\r\n          attributionUrl: 'https://static.arcgis.com/attribution/Ocean_Basemap'\r\n        }\r\n      },\r\n      OceansLabels: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/arcgis/rest/services/Ocean/World_Ocean_Reference/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__.pointerEvents) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n        }\r\n      },\r\n      NationalGeographic: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/NatGeo_World_Map/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'National Geographic, DeLorme, HERE, UNEP-WCMC, USGS, NASA, ESA, METI, NRCAN, GEBCO, NOAA, increment P Corp.'\r\n        }\r\n      },\r\n      DarkGray: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Canvas/World_Dark_Gray_Base/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'HERE, DeLorme, MapmyIndia, &copy; OpenStreetMap contributors'\r\n        }\r\n      },\r\n      DarkGrayLabels: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Canvas/World_Dark_Gray_Reference/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__.pointerEvents) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n\r\n        }\r\n      },\r\n      Gray: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Canvas/World_Light_Gray_Base/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'HERE, DeLorme, MapmyIndia, &copy; OpenStreetMap contributors'\r\n        }\r\n      },\r\n      GrayLabels: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Canvas/World_Light_Gray_Reference/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__.pointerEvents) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n        }\r\n      },\r\n      Imagery: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'DigitalGlobe, GeoEye, i-cubed, USDA, USGS, AEX, Getmapping, Aerogrid, IGN, IGP, swisstopo, and the GIS User Community',\r\n          attributionUrl: 'https://static.arcgis.com/attribution/World_Imagery'\r\n        }\r\n      },\r\n      ImageryLabels: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Reference/World_Boundaries_and_Places/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__.pointerEvents) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n        }\r\n      },\r\n      ImageryTransportation: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Reference/World_Transportation/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__.pointerEvents) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n        }\r\n      },\r\n      ShadedRelief: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/World_Shaded_Relief/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 13,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'USGS'\r\n        }\r\n      },\r\n      ShadedReliefLabels: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Reference/World_Boundaries_and_Places_Alternate/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 12,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__.pointerEvents) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n        }\r\n      },\r\n      Terrain: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/World_Terrain_Base/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 13,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'USGS, NOAA'\r\n        }\r\n      },\r\n      TerrainLabels: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Reference/World_Reference_Overlay/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 13,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__.pointerEvents) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n        }\r\n      },\r\n      USATopo: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/USA_Topo_Maps/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 15,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'USGS, National Geographic Society, i-cubed'\r\n        }\r\n      },\r\n      ImageryClarity: {\r\n        urlTemplate: tileProtocol + '//clarity.maptiles.arcgis.com/arcgis/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          attribution: 'Esri, DigitalGlobe, GeoEye, Earthstar Geographics, CNES/Airbus DS, USDA, USGS, AeroGRID, IGN, and the GIS User Community'\r\n        }\r\n      },\r\n      Physical: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/arcgis/rest/services/World_Physical_Map/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 8,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'U.S. National Park Service'\r\n        }\r\n      },\r\n      ImageryFirefly: {\r\n        urlTemplate: tileProtocol + '//fly.maptiles.arcgis.com/arcgis/rest/services/World_Imagery_Firefly/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          attribution: 'Esri, DigitalGlobe, GeoEye, Earthstar Geographics, CNES/Airbus DS, USDA, USGS, AeroGRID, IGN, and the GIS User Community',\r\n          attributionUrl: 'https://static.arcgis.com/attribution/World_Imagery'\r\n        }\r\n      }\r\n    }\r\n  },\r\n\r\n  initialize: function (key, options) {\r\n    var config;\r\n\r\n    // set the config variable with the appropriate config object\r\n    if (typeof key === 'object' && key.urlTemplate && key.options) {\r\n      config = key;\r\n    } else if (typeof key === 'string' && BasemapLayer.TILES[key]) {\r\n      config = BasemapLayer.TILES[key];\r\n    } else {\r\n      throw new Error('L.esri.BasemapLayer: Invalid parameter. Use one of \"Streets\", \"Topographic\", \"Oceans\", \"OceansLabels\", \"NationalGeographic\", \"Physical\", \"Gray\", \"GrayLabels\", \"DarkGray\", \"DarkGrayLabels\", \"Imagery\", \"ImageryLabels\", \"ImageryTransportation\", \"ImageryClarity\", \"ImageryFirefly\", ShadedRelief\", \"ShadedReliefLabels\", \"Terrain\", \"TerrainLabels\" or \"USATopo\"');\r\n    }\r\n\r\n    // merge passed options into the config options\r\n    var tileOptions = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.extend(config.options, options);\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.setOptions(this, tileOptions);\r\n\r\n    // Deprecation notice:\r\n    if (!this.options.ignoreDeprecationWarning) {\r\n      console.warn('WARNING: L.esri.BasemapLayer uses data services that are in mature support and are not being updated. Please use L.esri.Vector.vectorBasemapLayer instead. More info: https://esriurl.com/esri-leaflet-basemap');\r\n    }\r\n\r\n    if (this.options.token && config.urlTemplate.indexOf('token=') === -1) {\r\n      config.urlTemplate += ('?token=' + this.options.token);\r\n    }\r\n    if (this.options.proxy) {\r\n      config.urlTemplate = this.options.proxy + '?' + config.urlTemplate;\r\n    }\r\n\r\n    // call the initialize method on L.TileLayer to set everything up\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.TileLayer.prototype.initialize.call(this, config.urlTemplate, tileOptions);\r\n  },\r\n\r\n  onAdd: function (map) {\r\n    // include 'Powered by Esri' in map attribution\r\n    (0,_Util__WEBPACK_IMPORTED_MODULE_2__.setEsriAttribution)(map);\r\n\r\n    if (this.options.pane === 'esri-labels') {\r\n      this._initPane();\r\n    }\r\n    // some basemaps can supply dynamic attribution\r\n    if (this.options.attributionUrl) {\r\n      (0,_Util__WEBPACK_IMPORTED_MODULE_2__._getAttributionData)((this.options.proxy ? this.options.proxy + '?' : '') + this.options.attributionUrl, map);\r\n    }\r\n\r\n    map.on('moveend', _Util__WEBPACK_IMPORTED_MODULE_2__._updateMapAttribution);\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.TileLayer.prototype.onAdd.call(this, map);\r\n  },\r\n\r\n  onRemove: function (map) {\r\n    (0,_Util__WEBPACK_IMPORTED_MODULE_2__.removeEsriAttribution)(map);\r\n\r\n    map.off('moveend', _Util__WEBPACK_IMPORTED_MODULE_2__._updateMapAttribution);\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.TileLayer.prototype.onRemove.call(this, map);\r\n  },\r\n\r\n  _initPane: function () {\r\n    if (!this._map.getPane(this.options.pane)) {\r\n      var pane = this._map.createPane(this.options.pane);\r\n      pane.style.pointerEvents = 'none';\r\n      pane.style.zIndex = 500;\r\n    }\r\n  },\r\n\r\n  getAttribution: function () {\r\n    if (this.options.attribution) {\r\n      var attribution = '<span class=\"esri-dynamic-attribution\">' + this.options.attribution + '</span>';\r\n    }\r\n    return attribution;\r\n  }\r\n});\r\n\r\nfunction basemapLayer (key, options) {\r\n  return new BasemapLayer(key, options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (basemapLayer);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/BasemapLayer.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/DynamicMapLayer.js":
/*!*****************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/DynamicMapLayer.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"DynamicMapLayer\": () => (/* binding */ DynamicMapLayer),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"dynamicMapLayer\": () => (/* binding */ dynamicMapLayer)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _RasterLayer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RasterLayer */ \"./node_modules/esri-leaflet/src/Layers/RasterLayer.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _Services_MapService__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Services/MapService */ \"./node_modules/esri-leaflet/src/Services/MapService.js\");\n\r\n\r\n\r\n\r\n\r\nvar DynamicMapLayer = _RasterLayer__WEBPACK_IMPORTED_MODULE_1__.RasterLayer.extend({\r\n\r\n  options: {\r\n    updateInterval: 150,\r\n    layers: false,\r\n    layerDefs: false,\r\n    timeOptions: false,\r\n    format: 'png32',\r\n    transparent: true,\r\n    f: 'json'\r\n  },\r\n\r\n  initialize: function (options) {\r\n    options = (0,_Util__WEBPACK_IMPORTED_MODULE_2__.getUrlParams)(options);\r\n    this.service = (0,_Services_MapService__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(options);\r\n    this.service.addEventParent(this);\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.setOptions(this, options);\r\n  },\r\n\r\n  getDynamicLayers: function () {\r\n    return this.options.dynamicLayers;\r\n  },\r\n\r\n  setDynamicLayers: function (dynamicLayers) {\r\n    this.options.dynamicLayers = dynamicLayers;\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  getLayers: function () {\r\n    return this.options.layers;\r\n  },\r\n\r\n  setLayers: function (layers) {\r\n    this.options.layers = layers;\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  getLayerDefs: function () {\r\n    return this.options.layerDefs;\r\n  },\r\n\r\n  setLayerDefs: function (layerDefs) {\r\n    this.options.layerDefs = layerDefs;\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  getTimeOptions: function () {\r\n    return this.options.timeOptions;\r\n  },\r\n\r\n  setTimeOptions: function (timeOptions) {\r\n    this.options.timeOptions = timeOptions;\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  query: function () {\r\n    return this.service.query();\r\n  },\r\n\r\n  identify: function () {\r\n    return this.service.identify();\r\n  },\r\n\r\n  find: function () {\r\n    return this.service.find();\r\n  },\r\n\r\n  _getPopupData: function (e) {\r\n    var callback = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function (error, featureCollection, response) {\r\n      if (error) { return; } // we really can't do anything here but authenticate or requesterror will fire\r\n      setTimeout(leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function () {\r\n        this._renderPopup(e.latlng, error, featureCollection, response);\r\n      }, this), 300);\r\n    }, this);\r\n\r\n    var identifyRequest;\r\n    if (this.options.popup) {\r\n      identifyRequest = this.options.popup.on(this._map).at(e.latlng);\r\n    } else {\r\n      identifyRequest = this.identify().on(this._map).at(e.latlng);\r\n    }\r\n\r\n    // remove extraneous vertices from response features if it has not already been done\r\n    if (!identifyRequest.params.maxAllowableOffset) {\r\n      identifyRequest.simplify(this._map, 0.5);\r\n    }\r\n\r\n    if (!(this.options.popup && this.options.popup.params && this.options.popup.params.layers)) {\r\n      if (this.options.layers) {\r\n        identifyRequest.layers('visible:' + this.options.layers.join(','));\r\n      } else {\r\n        identifyRequest.layers('visible');\r\n      }\r\n    }\r\n\r\n    // if present, pass layer ids and sql filters through to the identify task\r\n    if (this.options.layerDefs && typeof this.options.layerDefs !== 'string' && !identifyRequest.params.layerDefs) {\r\n      for (var id in this.options.layerDefs) {\r\n        if (Object.prototype.hasOwnProperty.call(this.options.layerDefs, id)) {\r\n          identifyRequest.layerDef(id, this.options.layerDefs[id]);\r\n        }\r\n      }\r\n    }\r\n\r\n    identifyRequest.run(callback);\r\n\r\n    // set the flags to show the popup\r\n    this._shouldRenderPopup = true;\r\n    this._lastClick = e.latlng;\r\n  },\r\n\r\n  _buildExportParams: function () {\r\n    var sr = parseInt(this._map.options.crs.code.split(':')[1], 10);\r\n\r\n    var params = {\r\n      bbox: this._calculateBbox(),\r\n      size: this._calculateImageSize(),\r\n      dpi: 96,\r\n      format: this.options.format,\r\n      transparent: this.options.transparent,\r\n      bboxSR: sr,\r\n      imageSR: sr\r\n    };\r\n\r\n    if (this.options.dynamicLayers) {\r\n      params.dynamicLayers = this.options.dynamicLayers;\r\n    }\r\n\r\n    if (this.options.layers) {\r\n      if (this.options.layers.length === 0) {\r\n        return;\r\n      } else {\r\n        params.layers = 'show:' + this.options.layers.join(',');\r\n      }\r\n    }\r\n\r\n    if (this.options.layerDefs) {\r\n      params.layerDefs = typeof this.options.layerDefs === 'string' ? this.options.layerDefs : JSON.stringify(this.options.layerDefs);\r\n    }\r\n\r\n    if (this.options.timeOptions) {\r\n      params.timeOptions = JSON.stringify(this.options.timeOptions);\r\n    }\r\n\r\n    if (this.options.from && this.options.to) {\r\n      params.time = this.options.from.valueOf() + ',' + this.options.to.valueOf();\r\n    }\r\n\r\n    if (this.service.options.token) {\r\n      params.token = this.service.options.token;\r\n    }\r\n\r\n    if (this.options.proxy) {\r\n      params.proxy = this.options.proxy;\r\n    }\r\n\r\n    // use a timestamp to bust server cache\r\n    if (this.options.disableCache) {\r\n      params._ts = Date.now();\r\n    }\r\n\r\n    return params;\r\n  },\r\n\r\n  _requestExport: function (params, bounds) {\r\n    if (this.options.f === 'json') {\r\n      this.service.request('export', params, function (error, response) {\r\n        if (error) { return; } // we really can't do anything here but authenticate or requesterror will fire\r\n\r\n        if (this.options.token && response.href) {\r\n          response.href += ('?token=' + this.options.token);\r\n        }\r\n        if (this.options.proxy && response.href) {\r\n          response.href = this.options.proxy + '?' + response.href;\r\n        }\r\n        if (response.href) {\r\n          this._renderImage(response.href, bounds);\r\n        } else {\r\n          this._renderImage(response.imageData, bounds, response.contentType);\r\n        }\r\n      }, this);\r\n    } else {\r\n      params.f = 'image';\r\n      var fullUrl = this.options.url + 'export' + leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.getParamString(params);\r\n      if (this.options.proxy) {\r\n        fullUrl = this.options.proxy + '?' + fullUrl;\r\n      }\r\n      this._renderImage(fullUrl, bounds);\r\n    }\r\n  }\r\n});\r\n\r\nfunction dynamicMapLayer (url, options) {\r\n  return new DynamicMapLayer(url, options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dynamicMapLayer);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/DynamicMapLayer.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureGrid.js":
/*!**************************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureGrid.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FeatureGrid\": () => (/* binding */ FeatureGrid)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n\r\n\r\nvar FeatureGrid = leaflet__WEBPACK_IMPORTED_MODULE_0__.Layer.extend({\r\n  // @section\r\n  // @aka GridLayer options\r\n  options: {\r\n    // @option cellSize: Number|Point = 256\r\n    // Width and height of cells in the grid. Use a number if width and height are equal, or `L.point(width, height)` otherwise.\r\n    cellSize: 512,\r\n\r\n    // @option updateWhenIdle: Boolean = (depends)\r\n    // Load new cells only when panning ends.\r\n    // `true` by default on mobile browsers, in order to avoid too many requests and keep smooth navigation.\r\n    // `false` otherwise in order to display new cells _during_ panning, since it is easy to pan outside the\r\n    // [`keepBuffer`](#gridlayer-keepbuffer) option in desktop browsers.\r\n    updateWhenIdle: leaflet__WEBPACK_IMPORTED_MODULE_0__.Browser.mobile,\r\n\r\n    // @option updateInterval: Number = 150\r\n    // Cells will not update more than once every `updateInterval` milliseconds when panning.\r\n    updateInterval: 150,\r\n\r\n    // @option noWrap: Boolean = false\r\n    // Whether the layer is wrapped around the antimeridian. If `true`, the\r\n    // GridLayer will only be displayed once at low zoom levels. Has no\r\n    // effect when the [map CRS](#map-crs) doesn't wrap around. Can be used\r\n    // in combination with [`bounds`](#gridlayer-bounds) to prevent requesting\r\n    // cells outside the CRS limits.\r\n    noWrap: false,\r\n\r\n    // @option keepBuffer: Number = 1.5\r\n    // When panning the map, keep this many rows and columns of cells before unloading them.\r\n    keepBuffer: 1.5\r\n  },\r\n\r\n  initialize: function (options) {\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.setOptions(this, options);\r\n  },\r\n\r\n  onAdd: function (map) {\r\n    this._cells = {};\r\n    this._activeCells = {};\r\n    this._resetView();\r\n    this._update();\r\n  },\r\n\r\n  onRemove: function (map) {\r\n    this._removeAllCells();\r\n    this._cellZoom = undefined;\r\n  },\r\n\r\n  // @method isLoading: Boolean\r\n  // Returns `true` if any cell in the grid layer has not finished loading.\r\n  isLoading: function () {\r\n    return this._loading;\r\n  },\r\n\r\n  // @method redraw: this\r\n  // Causes the layer to clear all the cells and request them again.\r\n  redraw: function () {\r\n    if (this._map) {\r\n      this._removeAllCells();\r\n      this._update();\r\n    }\r\n    return this;\r\n  },\r\n\r\n  getEvents: function () {\r\n    var events = {\r\n      viewprereset: this._invalidateAll,\r\n      viewreset: this._resetView,\r\n      zoom: this._resetView,\r\n      moveend: this._onMoveEnd\r\n    };\r\n\r\n    if (!this.options.updateWhenIdle) {\r\n      // update cells on move, but not more often than once per given interval\r\n      if (!this._onMove) {\r\n        this._onMove = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.throttle(\r\n          this._onMoveEnd,\r\n          this.options.updateInterval,\r\n          this\r\n        );\r\n      }\r\n\r\n      events.move = this._onMove;\r\n    }\r\n\r\n    return events;\r\n  },\r\n\r\n  // @section Extension methods\r\n  // Layers extending `GridLayer` shall reimplement the following method.\r\n  // @method createCell(coords: Object, done?: Function): HTMLElement\r\n  // Called only internally, must be overridden by classes extending `GridLayer`.\r\n  // Returns the `HTMLElement` corresponding to the given `coords`. If the `done` callback\r\n  // is specified, it must be called when the cell has finished loading and drawing.\r\n  createCell: function () {\r\n    return document.createElement('div');\r\n  },\r\n\r\n  removeCell: function () {\r\n\r\n  },\r\n\r\n  reuseCell: function () {\r\n\r\n  },\r\n\r\n  cellLeave: function () {\r\n\r\n  },\r\n\r\n  cellEnter: function () {\r\n\r\n  },\r\n  // @section\r\n  // @method getCellSize: Point\r\n  // Normalizes the [cellSize option](#gridlayer-cellsize) into a point. Used by the `createCell()` method.\r\n  getCellSize: function () {\r\n    var s = this.options.cellSize;\r\n    return s instanceof leaflet__WEBPACK_IMPORTED_MODULE_0__.Point ? s : new leaflet__WEBPACK_IMPORTED_MODULE_0__.Point(s, s);\r\n  },\r\n\r\n  _pruneCells: function () {\r\n    if (!this._map) {\r\n      return;\r\n    }\r\n\r\n    var key, cell;\r\n\r\n    for (key in this._cells) {\r\n      cell = this._cells[key];\r\n      cell.retain = cell.current;\r\n    }\r\n\r\n    for (key in this._cells) {\r\n      cell = this._cells[key];\r\n      if (cell.current && !cell.active) {\r\n        var coords = cell.coords;\r\n        if (!this._retainParent(coords.x, coords.y, coords.z, coords.z - 5)) {\r\n          this._retainChildren(coords.x, coords.y, coords.z, coords.z + 2);\r\n        }\r\n      }\r\n    }\r\n\r\n    for (key in this._cells) {\r\n      if (!this._cells[key].retain) {\r\n        this._removeCell(key);\r\n      }\r\n    }\r\n  },\r\n\r\n  _removeAllCells: function () {\r\n    for (var key in this._cells) {\r\n      this._removeCell(key);\r\n    }\r\n  },\r\n\r\n  _invalidateAll: function () {\r\n    this._removeAllCells();\r\n\r\n    this._cellZoom = undefined;\r\n  },\r\n\r\n  _retainParent: function (x, y, z, minZoom) {\r\n    var x2 = Math.floor(x / 2);\r\n    var y2 = Math.floor(y / 2);\r\n    var z2 = z - 1;\r\n    var coords2 = new leaflet__WEBPACK_IMPORTED_MODULE_0__.Point(+x2, +y2);\r\n    coords2.z = +z2;\r\n\r\n    var key = this._cellCoordsToKey(coords2);\r\n    var cell = this._cells[key];\r\n\r\n    if (cell && cell.active) {\r\n      cell.retain = true;\r\n      return true;\r\n    } else if (cell && cell.loaded) {\r\n      cell.retain = true;\r\n    }\r\n\r\n    if (z2 > minZoom) {\r\n      return this._retainParent(x2, y2, z2, minZoom);\r\n    }\r\n\r\n    return false;\r\n  },\r\n\r\n  _retainChildren: function (x, y, z, maxZoom) {\r\n    for (var i = 2 * x; i < 2 * x + 2; i++) {\r\n      for (var j = 2 * y; j < 2 * y + 2; j++) {\r\n        var coords = new leaflet__WEBPACK_IMPORTED_MODULE_0__.Point(i, j);\r\n        coords.z = z + 1;\r\n\r\n        var key = this._cellCoordsToKey(coords);\r\n        var cell = this._cells[key];\r\n\r\n        if (cell && cell.active) {\r\n          cell.retain = true;\r\n          continue;\r\n        } else if (cell && cell.loaded) {\r\n          cell.retain = true;\r\n        }\r\n\r\n        if (z + 1 < maxZoom) {\r\n          this._retainChildren(i, j, z + 1, maxZoom);\r\n        }\r\n      }\r\n    }\r\n  },\r\n\r\n  _resetView: function (e) {\r\n    var animating = e && (e.pinch || e.flyTo);\r\n\r\n    if (animating) {\r\n      return;\r\n    }\r\n\r\n    this._setView(\r\n      this._map.getCenter(),\r\n      this._map.getZoom(),\r\n      animating,\r\n      animating\r\n    );\r\n  },\r\n\r\n  _setView: function (center, zoom, noPrune, noUpdate) {\r\n    var cellZoom = Math.round(zoom);\r\n\r\n    if (!noUpdate) {\r\n      this._cellZoom = cellZoom;\r\n\r\n      if (this._abortLoading) {\r\n        this._abortLoading();\r\n      }\r\n\r\n      this._resetGrid();\r\n\r\n      if (cellZoom !== undefined) {\r\n        this._update(center);\r\n      }\r\n\r\n      if (!noPrune) {\r\n        this._pruneCells();\r\n      }\r\n\r\n      // Flag to prevent _updateOpacity from pruning cells during\r\n      // a zoom anim or a pinch gesture\r\n      this._noPrune = !!noPrune;\r\n    }\r\n  },\r\n\r\n  _resetGrid: function () {\r\n    var map = this._map;\r\n    var crs = map.options.crs;\r\n    var cellSize = (this._cellSize = this.getCellSize());\r\n    var cellZoom = this._cellZoom;\r\n\r\n    var bounds = this._map.getPixelWorldBounds(this._cellZoom);\r\n    if (bounds) {\r\n      this._globalCellRange = this._pxBoundsToCellRange(bounds);\r\n    }\r\n\r\n    this._wrapX = crs.wrapLng &&\r\n      !this.options.noWrap && [\r\n      Math.floor(map.project([0, crs.wrapLng[0]], cellZoom).x / cellSize.x),\r\n      Math.ceil(map.project([0, crs.wrapLng[1]], cellZoom).x / cellSize.y)\r\n    ];\r\n    this._wrapY = crs.wrapLat &&\r\n      !this.options.noWrap && [\r\n      Math.floor(map.project([crs.wrapLat[0], 0], cellZoom).y / cellSize.x),\r\n      Math.ceil(map.project([crs.wrapLat[1], 0], cellZoom).y / cellSize.y)\r\n    ];\r\n  },\r\n\r\n  _onMoveEnd: function (e) {\r\n    var animating = e && (e.pinch || e.flyTo);\r\n\r\n    if (animating || !this._map || this._map._animatingZoom) {\r\n      return;\r\n    }\r\n\r\n    this._update();\r\n  },\r\n\r\n  _getCelldPixelBounds: function (center) {\r\n    var map = this._map;\r\n    var mapZoom = map._animatingZoom\r\n      ? Math.max(map._animateToZoom, map.getZoom())\r\n      : map.getZoom();\r\n    var scale = map.getZoomScale(mapZoom, this._cellZoom);\r\n    var pixelCenter = map.project(center, this._cellZoom).floor();\r\n    var halfSize = map.getSize().divideBy(scale * 2);\r\n\r\n    return new leaflet__WEBPACK_IMPORTED_MODULE_0__.Bounds(\r\n      pixelCenter.subtract(halfSize),\r\n      pixelCenter.add(halfSize)\r\n    );\r\n  },\r\n\r\n  // Private method to load cells in the grid's active zoom level according to map bounds\r\n  _update: function (center) {\r\n    var map = this._map;\r\n    if (!map) {\r\n      return;\r\n    }\r\n    var zoom = Math.round(map.getZoom());\r\n\r\n    if (center === undefined) {\r\n      center = map.getCenter();\r\n    }\r\n\r\n    var pixelBounds = this._getCelldPixelBounds(center);\r\n    var cellRange = this._pxBoundsToCellRange(pixelBounds);\r\n    var cellCenter = cellRange.getCenter();\r\n    var queue = [];\r\n    var margin = this.options.keepBuffer;\r\n    var noPruneRange = new leaflet__WEBPACK_IMPORTED_MODULE_0__.Bounds(\r\n      cellRange.getBottomLeft().subtract([margin, -margin]),\r\n      cellRange.getTopRight().add([margin, -margin])\r\n    );\r\n\r\n    // Sanity check: panic if the cell range contains Infinity somewhere.\r\n    if (\r\n      !(\r\n        isFinite(cellRange.min.x) &&\r\n        isFinite(cellRange.min.y) &&\r\n        isFinite(cellRange.max.x) &&\r\n        isFinite(cellRange.max.y)\r\n      )\r\n    ) {\r\n      throw new Error('Attempted to load an infinite number of cells');\r\n    }\r\n\r\n    for (var key in this._cells) {\r\n      var c = this._cells[key].coords;\r\n      if (\r\n        c.z !== this._cellZoom ||\r\n        !noPruneRange.contains(new leaflet__WEBPACK_IMPORTED_MODULE_0__.Point(c.x, c.y))\r\n      ) {\r\n        this._cells[key].current = false;\r\n      }\r\n    }\r\n\r\n    // _update just loads more cells. If the cell zoom level differs too much\r\n    // from the map's, let _setView reset levels and prune old cells.\r\n    if (Math.abs(zoom - this._cellZoom) > 1) {\r\n      this._setView(center, zoom);\r\n      return;\r\n    }\r\n\r\n    // create a queue of coordinates to load cells from\r\n    for (var j = cellRange.min.y; j <= cellRange.max.y; j++) {\r\n      for (var i = cellRange.min.x; i <= cellRange.max.x; i++) {\r\n        var coords = new leaflet__WEBPACK_IMPORTED_MODULE_0__.Point(i, j);\r\n        coords.z = this._cellZoom;\r\n\r\n        if (!this._isValidCell(coords)) {\r\n          continue;\r\n        }\r\n\r\n        var cell = this._cells[this._cellCoordsToKey(coords)];\r\n        if (cell) {\r\n          cell.current = true;\r\n        } else {\r\n          queue.push(coords);\r\n        }\r\n      }\r\n    }\r\n\r\n    // sort cell queue to load cells in order of their distance to center\r\n    queue.sort(function (a, b) {\r\n      return a.distanceTo(cellCenter) - b.distanceTo(cellCenter);\r\n    });\r\n\r\n    if (queue.length !== 0) {\r\n      // if it's the first batch of cells to load\r\n      if (!this._loading) {\r\n        this._loading = true;\r\n      }\r\n\r\n      for (i = 0; i < queue.length; i++) {\r\n        var _key = this._cellCoordsToKey(queue[i]);\r\n        var _coords = this._keyToCellCoords(_key);\r\n        if (this._activeCells[_coords]) {\r\n          this._reuseCell(queue[i]);\r\n        } else {\r\n          this._createCell(queue[i]);\r\n        }\r\n      }\r\n    }\r\n  },\r\n\r\n  _isValidCell: function (coords) {\r\n    var crs = this._map.options.crs;\r\n\r\n    if (!crs.infinite) {\r\n      // don't load cell if it's out of bounds and not wrapped\r\n      var bounds = this._globalCellRange;\r\n      if (\r\n        (!crs.wrapLng &&\r\n          (coords.x < bounds.min.x || coords.x > bounds.max.x)) ||\r\n        (!crs.wrapLat && (coords.y < bounds.min.y || coords.y > bounds.max.y))\r\n      ) {\r\n        return false;\r\n      }\r\n    }\r\n\r\n    if (!this.options.bounds) {\r\n      return true;\r\n    }\r\n\r\n    // don't load cell if it doesn't intersect the bounds in options\r\n    var cellBounds = this._cellCoordsToBounds(coords);\r\n    return (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.toLatLngBounds)(this.options.bounds).overlaps(cellBounds);\r\n  },\r\n\r\n  _keyToBounds: function (key) {\r\n    return this._cellCoordsToBounds(this._keyToCellCoords(key));\r\n  },\r\n\r\n  _cellCoordsToNwSe: function (coords) {\r\n    var map = this._map;\r\n    var cellSize = this.getCellSize();\r\n    var nwPoint = coords.scaleBy(cellSize);\r\n    var sePoint = nwPoint.add(cellSize);\r\n    var nw = map.unproject(nwPoint, coords.z);\r\n    var se = map.unproject(sePoint, coords.z);\r\n\r\n    return [nw, se];\r\n  },\r\n\r\n  // converts cell coordinates to its geographical bounds\r\n  _cellCoordsToBounds: function (coords) {\r\n    var bp = this._cellCoordsToNwSe(coords);\r\n    var bounds = new leaflet__WEBPACK_IMPORTED_MODULE_0__.LatLngBounds(bp[0], bp[1]);\r\n\r\n    if (!this.options.noWrap) {\r\n      bounds = this._map.wrapLatLngBounds(bounds);\r\n    }\r\n    return bounds;\r\n  },\r\n  // converts cell coordinates to key for the cell cache\r\n  _cellCoordsToKey: function (coords) {\r\n    return coords.x + ':' + coords.y + ':' + coords.z;\r\n  },\r\n\r\n  // converts cell cache key to coordinates\r\n  _keyToCellCoords: function (key) {\r\n    var k = key.split(':');\r\n    var coords = new leaflet__WEBPACK_IMPORTED_MODULE_0__.Point(+k[0], +k[1]);\r\n\r\n    coords.z = +k[2];\r\n    return coords;\r\n  },\r\n\r\n  _removeCell: function (key) {\r\n    var cell = this._cells[key];\r\n\r\n    if (!cell) {\r\n      return;\r\n    }\r\n\r\n    var coords = this._keyToCellCoords(key);\r\n    var wrappedCoords = this._wrapCoords(coords);\r\n    var cellBounds = this._cellCoordsToBounds(this._wrapCoords(coords));\r\n\r\n    cell.current = false;\r\n\r\n    delete this._cells[key];\r\n    this._activeCells[key] = cell;\r\n\r\n    this.cellLeave(cellBounds, wrappedCoords, key);\r\n\r\n    this.fire('cellleave', {\r\n      key: key,\r\n      coords: wrappedCoords,\r\n      bounds: cellBounds\r\n    });\r\n  },\r\n\r\n  _reuseCell: function (coords) {\r\n    var key = this._cellCoordsToKey(coords);\r\n\r\n    // save cell in cache\r\n    this._cells[key] = this._activeCells[key];\r\n    this._cells[key].current = true;\r\n\r\n    var wrappedCoords = this._wrapCoords(coords);\r\n    var cellBounds = this._cellCoordsToBounds(this._wrapCoords(coords));\r\n\r\n    this.cellEnter(cellBounds, wrappedCoords, key);\r\n\r\n    this.fire('cellenter', {\r\n      key: key,\r\n      coords: wrappedCoords,\r\n      bounds: cellBounds\r\n    });\r\n  },\r\n\r\n  _createCell: function (coords) {\r\n    var key = this._cellCoordsToKey(coords);\r\n\r\n    var wrappedCoords = this._wrapCoords(coords);\r\n    var cellBounds = this._cellCoordsToBounds(this._wrapCoords(coords));\r\n\r\n    this.createCell(cellBounds, wrappedCoords, key);\r\n\r\n    this.fire('cellcreate', {\r\n      key: key,\r\n      coords: wrappedCoords,\r\n      bounds: cellBounds\r\n    });\r\n\r\n    // save cell in cache\r\n    this._cells[key] = {\r\n      coords: coords,\r\n      current: true\r\n    };\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.requestAnimFrame(this._pruneCells, this);\r\n  },\r\n\r\n  _cellReady: function (coords, err, cell) {\r\n    var key = this._cellCoordsToKey(coords);\r\n\r\n    cell = this._cells[key];\r\n\r\n    if (!cell) {\r\n      return;\r\n    }\r\n\r\n    cell.loaded = +new Date();\r\n\r\n    cell.active = true;\r\n  },\r\n\r\n  _getCellPos: function (coords) {\r\n    return coords.scaleBy(this.getCellSize());\r\n  },\r\n\r\n  _wrapCoords: function (coords) {\r\n    var newCoords = new leaflet__WEBPACK_IMPORTED_MODULE_0__.Point(\r\n      this._wrapX ? leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.wrapNum(coords.x, this._wrapX) : coords.x,\r\n      this._wrapY ? leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.wrapNum(coords.y, this._wrapY) : coords.y\r\n    );\r\n    newCoords.z = coords.z;\r\n    return newCoords;\r\n  },\r\n\r\n  _pxBoundsToCellRange: function (bounds) {\r\n    var cellSize = this.getCellSize();\r\n    return new leaflet__WEBPACK_IMPORTED_MODULE_0__.Bounds(\r\n      bounds.min.unscaleBy(cellSize).floor(),\r\n      bounds.max.unscaleBy(cellSize).ceil().subtract([1, 1])\r\n    );\r\n  }\r\n});\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureGrid.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureLayer.js":
/*!***************************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureLayer.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FeatureLayer\": () => (/* binding */ FeatureLayer),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"featureLayer\": () => (/* binding */ featureLayer)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _FeatureManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FeatureManager */ \"./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureManager.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar FeatureLayer = _FeatureManager__WEBPACK_IMPORTED_MODULE_1__.FeatureManager.extend({\r\n  options: {\r\n    cacheLayers: true\r\n  },\r\n\r\n  /**\r\n   * Constructor\r\n   */\r\n  initialize: function (options) {\r\n    if (options.apikey) {\r\n      options.token = options.apikey;\r\n    }\r\n    _FeatureManager__WEBPACK_IMPORTED_MODULE_1__.FeatureManager.prototype.initialize.call(this, options);\r\n    this._originalStyle = this.options.style;\r\n    this._layers = {};\r\n  },\r\n\r\n  /**\r\n   * Layer Interface\r\n   */\r\n\r\n  onRemove: function (map) {\r\n    for (var i in this._layers) {\r\n      map.removeLayer(this._layers[i]);\r\n      // trigger the event when the entire featureLayer is removed from the map\r\n      this.fire(\r\n        'removefeature',\r\n        {\r\n          feature: this._layers[i].feature,\r\n          permanent: false\r\n        },\r\n        true\r\n      );\r\n    }\r\n\r\n    return _FeatureManager__WEBPACK_IMPORTED_MODULE_1__.FeatureManager.prototype.onRemove.call(this, map);\r\n  },\r\n\r\n  createNewLayer: function (geojson) {\r\n    var layer = leaflet__WEBPACK_IMPORTED_MODULE_0__.GeoJSON.geometryToLayer(geojson, this.options);\r\n    // trap for GeoJSON without geometry\r\n    if (layer) {\r\n      layer.defaultOptions = layer.options;\r\n    }\r\n    return layer;\r\n  },\r\n\r\n  _updateLayer: function (layer, geojson) {\r\n    // convert the geojson coordinates into a Leaflet LatLng array/nested arrays\r\n    // pass it to setLatLngs to update layer geometries\r\n    var latlngs = [];\r\n    var coordsToLatLng = this.options.coordsToLatLng || leaflet__WEBPACK_IMPORTED_MODULE_0__.GeoJSON.coordsToLatLng;\r\n\r\n    // copy new attributes, if present\r\n    if (geojson.properties) {\r\n      layer.feature.properties = geojson.properties;\r\n    }\r\n\r\n    switch (geojson.geometry.type) {\r\n      case 'Point':\r\n        latlngs = leaflet__WEBPACK_IMPORTED_MODULE_0__.GeoJSON.coordsToLatLng(geojson.geometry.coordinates);\r\n        layer.setLatLng(latlngs);\r\n        break;\r\n      case 'LineString':\r\n        latlngs = leaflet__WEBPACK_IMPORTED_MODULE_0__.GeoJSON.coordsToLatLngs(\r\n          geojson.geometry.coordinates,\r\n          0,\r\n          coordsToLatLng\r\n        );\r\n        layer.setLatLngs(latlngs);\r\n        break;\r\n      case 'MultiLineString':\r\n        latlngs = leaflet__WEBPACK_IMPORTED_MODULE_0__.GeoJSON.coordsToLatLngs(\r\n          geojson.geometry.coordinates,\r\n          1,\r\n          coordsToLatLng\r\n        );\r\n        layer.setLatLngs(latlngs);\r\n        break;\r\n      case 'Polygon':\r\n        latlngs = leaflet__WEBPACK_IMPORTED_MODULE_0__.GeoJSON.coordsToLatLngs(\r\n          geojson.geometry.coordinates,\r\n          1,\r\n          coordsToLatLng\r\n        );\r\n        layer.setLatLngs(latlngs);\r\n        break;\r\n      case 'MultiPolygon':\r\n        latlngs = leaflet__WEBPACK_IMPORTED_MODULE_0__.GeoJSON.coordsToLatLngs(\r\n          geojson.geometry.coordinates,\r\n          2,\r\n          coordsToLatLng\r\n        );\r\n        layer.setLatLngs(latlngs);\r\n        break;\r\n    }\r\n\r\n    // update symbol/style\r\n    this.redraw(layer.feature.id);\r\n  },\r\n\r\n  /**\r\n   * Feature Management Methods\r\n   */\r\n\r\n  createLayers: function (features) {\r\n    for (var i = features.length - 1; i >= 0; i--) {\r\n      var geojson = features[i];\r\n\r\n      var layer = this._layers[geojson.id];\r\n      var newLayer;\r\n\r\n      if (\r\n        this._visibleZoom() &&\r\n        layer &&\r\n        !this._map.hasLayer(layer) &&\r\n        (!this.options.timeField || this._featureWithinTimeRange(geojson))\r\n      ) {\r\n        this._map.addLayer(layer);\r\n        this.fire(\r\n          'addfeature',\r\n          {\r\n            feature: layer.feature\r\n          },\r\n          true\r\n        );\r\n      }\r\n\r\n      // update geometry if the layer already existed.\r\n      if (layer && (layer.setLatLngs || layer.setLatLng)) {\r\n        this._updateLayer(layer, geojson);\r\n      }\r\n\r\n      if (!layer) {\r\n        newLayer = this.createNewLayer(geojson);\r\n\r\n        if (!newLayer) {\r\n          (0,_Util__WEBPACK_IMPORTED_MODULE_2__.warn)('invalid GeoJSON encountered');\r\n        } else {\r\n          newLayer.feature = geojson;\r\n\r\n          // bubble events from individual layers to the feature layer\r\n          newLayer.addEventParent(this);\r\n\r\n          if (this.options.onEachFeature) {\r\n            this.options.onEachFeature(newLayer.feature, newLayer);\r\n          }\r\n\r\n          // cache the layer\r\n          this._layers[newLayer.feature.id] = newLayer;\r\n\r\n          // style the layer\r\n          this.setFeatureStyle(newLayer.feature.id, this.options.style);\r\n\r\n          this.fire(\r\n            'createfeature',\r\n            {\r\n              feature: newLayer.feature\r\n            },\r\n            true\r\n          );\r\n\r\n          // add the layer if the current zoom level is inside the range defined for the layer, it is within the current time bounds or our layer is not time enabled\r\n          if (\r\n            this._visibleZoom() &&\r\n            (!this.options.timeField ||\r\n              (this.options.timeField && this._featureWithinTimeRange(geojson)))\r\n          ) {\r\n            this._map.addLayer(newLayer);\r\n          }\r\n        }\r\n      }\r\n    }\r\n  },\r\n\r\n  addLayers: function (ids) {\r\n    for (var i = ids.length - 1; i >= 0; i--) {\r\n      var layer = this._layers[ids[i]];\r\n      if (\r\n        layer &&\r\n        (!this.options.timeField || this._featureWithinTimeRange(layer.feature))\r\n      ) {\r\n        this._map.addLayer(layer);\r\n        this.fire(\r\n          'addfeature',\r\n          {\r\n            feature: layer.feature\r\n          },\r\n          true\r\n        );\r\n      }\r\n    }\r\n  },\r\n\r\n  removeLayers: function (ids, permanent) {\r\n    for (var i = ids.length - 1; i >= 0; i--) {\r\n      var id = ids[i];\r\n      var layer = this._layers[id];\r\n      if (layer) {\r\n        this.fire(\r\n          'removefeature',\r\n          {\r\n            feature: layer.feature,\r\n            permanent: permanent\r\n          },\r\n          true\r\n        );\r\n        this._map.removeLayer(layer);\r\n      }\r\n      if (layer && permanent) {\r\n        delete this._layers[id];\r\n      }\r\n    }\r\n  },\r\n\r\n  cellEnter: function (bounds, coords) {\r\n    if (this._visibleZoom() && !this._zooming && this._map) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.requestAnimFrame(\r\n        leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function () {\r\n          var cacheKey = this._cacheKey(coords);\r\n          var cellKey = this._cellCoordsToKey(coords);\r\n          var layers = this._cache[cacheKey];\r\n          if (this._activeCells[cellKey] && layers) {\r\n            this.addLayers(layers);\r\n          }\r\n        }, this)\r\n      );\r\n    }\r\n  },\r\n\r\n  cellLeave: function (bounds, coords) {\r\n    if (!this._zooming) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.requestAnimFrame(\r\n        leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function () {\r\n          if (this._map) {\r\n            var cacheKey = this._cacheKey(coords);\r\n            var cellKey = this._cellCoordsToKey(coords);\r\n            var layers = this._cache[cacheKey];\r\n            var mapBounds = this._map.getBounds();\r\n            if (!this._activeCells[cellKey] && layers) {\r\n              var removable = true;\r\n\r\n              for (var i = 0; i < layers.length; i++) {\r\n                var layer = this._layers[layers[i]];\r\n                if (\r\n                  layer &&\r\n                  layer.getBounds &&\r\n                  mapBounds.intersects(layer.getBounds())\r\n                ) {\r\n                  removable = false;\r\n                }\r\n              }\r\n\r\n              if (removable) {\r\n                this.removeLayers(layers, !this.options.cacheLayers);\r\n              }\r\n\r\n              if (!this.options.cacheLayers && removable) {\r\n                delete this._cache[cacheKey];\r\n                delete this._cells[cellKey];\r\n                delete this._activeCells[cellKey];\r\n              }\r\n            }\r\n          }\r\n        }, this)\r\n      );\r\n    }\r\n  },\r\n\r\n  /**\r\n   * Styling Methods\r\n   */\r\n\r\n  resetStyle: function () {\r\n    this.options.style = this._originalStyle;\r\n    this.eachFeature(function (layer) {\r\n      this.resetFeatureStyle(layer.feature.id);\r\n    }, this);\r\n    return this;\r\n  },\r\n\r\n  setStyle: function (style) {\r\n    this.options.style = style;\r\n    this.eachFeature(function (layer) {\r\n      this.setFeatureStyle(layer.feature.id, style);\r\n    }, this);\r\n    return this;\r\n  },\r\n\r\n  resetFeatureStyle: function (id) {\r\n    var layer = this._layers[id];\r\n    var style = this._originalStyle || leaflet__WEBPACK_IMPORTED_MODULE_0__.Path.prototype.options;\r\n    if (layer) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.extend(layer.options, layer.defaultOptions);\r\n      this.setFeatureStyle(id, style);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  setFeatureStyle: function (id, style) {\r\n    var layer = this._layers[id];\r\n    if (typeof style === 'function') {\r\n      style = style(layer.feature);\r\n    }\r\n    if (layer.setStyle) {\r\n      layer.setStyle(style);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  /**\r\n   * Utility Methods\r\n   */\r\n\r\n  eachActiveFeature: function (fn, context) {\r\n    // figure out (roughly) which layers are in view\r\n    if (this._map) {\r\n      var activeBounds = this._map.getBounds();\r\n      for (var i in this._layers) {\r\n        if (this._currentSnapshot.indexOf(this._layers[i].feature.id) !== -1) {\r\n          // a simple point in poly test for point geometries\r\n          if (\r\n            typeof this._layers[i].getLatLng === 'function' &&\r\n            activeBounds.contains(this._layers[i].getLatLng())\r\n          ) {\r\n            fn.call(context, this._layers[i]);\r\n          } else if (\r\n            typeof this._layers[i].getBounds === 'function' &&\r\n            activeBounds.intersects(this._layers[i].getBounds())\r\n          ) {\r\n            // intersecting bounds check for polyline and polygon geometries\r\n            fn.call(context, this._layers[i]);\r\n          }\r\n        }\r\n      }\r\n    }\r\n    return this;\r\n  },\r\n\r\n  eachFeature: function (fn, context) {\r\n    for (var i in this._layers) {\r\n      fn.call(context, this._layers[i]);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  getFeature: function (id) {\r\n    return this._layers[id];\r\n  },\r\n\r\n  bringToBack: function () {\r\n    this.eachFeature(function (layer) {\r\n      if (layer.bringToBack) {\r\n        layer.bringToBack();\r\n      }\r\n    });\r\n  },\r\n\r\n  bringToFront: function () {\r\n    this.eachFeature(function (layer) {\r\n      if (layer.bringToFront) {\r\n        layer.bringToFront();\r\n      }\r\n    });\r\n  },\r\n\r\n  redraw: function (id) {\r\n    if (id) {\r\n      this._redraw(id);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  _redraw: function (id) {\r\n    var layer = this._layers[id];\r\n    var geojson = layer.feature;\r\n\r\n    // if this looks like a marker\r\n    if (layer && layer.setIcon && this.options.pointToLayer) {\r\n      // update custom symbology, if necessary\r\n      if (this.options.pointToLayer) {\r\n        var getIcon = this.options.pointToLayer(\r\n          geojson,\r\n          (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLng)(\r\n            geojson.geometry.coordinates[1],\r\n            geojson.geometry.coordinates[0]\r\n          )\r\n        );\r\n        var updatedIcon = getIcon.options.icon;\r\n        layer.setIcon(updatedIcon);\r\n      }\r\n    }\r\n\r\n    // looks like a vector marker (circleMarker)\r\n    if (layer && layer.setStyle && this.options.pointToLayer) {\r\n      var getStyle = this.options.pointToLayer(\r\n        geojson,\r\n        (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLng)(geojson.geometry.coordinates[1], geojson.geometry.coordinates[0])\r\n      );\r\n      var updatedStyle = getStyle.options;\r\n      this.setFeatureStyle(geojson.id, updatedStyle);\r\n    }\r\n\r\n    // looks like a path (polygon/polyline)\r\n    if (layer && layer.setStyle && this.options.style) {\r\n      this.resetFeatureStyle(geojson.id);\r\n    }\r\n  },\r\n\r\n  // This is the same as the Layer.openPopup method except it excludes the `FeatureGroup`\r\n  // logic to work around https://github.com/Leaflet/Leaflet/issues/8761\r\n  openPopup (latlng) {\r\n    if (this._popup) {\r\n      if (this._popup._prepareOpen(latlng || this._latlng)) {\r\n        // open the popup on the map\r\n        this._popup.openOn(this._map);\r\n      }\r\n    }\r\n    return this;\r\n  },\r\n\r\n  // This is the same as the `Layer.openTooltip` method except it excludes the `FeatureGroup`\r\n  // logic to work around https://github.com/Leaflet/Leaflet/issues/8761\r\n  openTooltip (latlng) {\r\n    if (this._tooltip) {\r\n      if (this._tooltip._prepareOpen(latlng)) {\r\n        // open the tooltip on the map\r\n        this._tooltip.openOn(this._map);\r\n\r\n        if (this.getElement) {\r\n          this._setAriaDescribedByOnLayer(this);\r\n        } else if (this.eachLayer) {\r\n          this.eachLayer(this._setAriaDescribedByOnLayer, this);\r\n        }\r\n      }\r\n    }\r\n    return this;\r\n  }\r\n});\r\n\r\nfunction featureLayer (options) {\r\n  return new FeatureLayer(options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (featureLayer);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureLayer.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureManager.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureManager.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FeatureManager\": () => (/* binding */ FeatureManager)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Services_FeatureLayerService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Services/FeatureLayerService */ \"./node_modules/esri-leaflet/src/Services/FeatureLayerService.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _FeatureGrid__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./FeatureGrid */ \"./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureGrid.js\");\n/* harmony import */ var tiny_binary_search__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tiny-binary-search */ \"./node_modules/tiny-binary-search/index.js\");\n\r\n\r\n\r\n\r\n\r\n\r\nvar FeatureManager = _FeatureGrid__WEBPACK_IMPORTED_MODULE_3__.FeatureGrid.extend({\r\n  /**\r\n   * Options\r\n   */\r\n\r\n  options: {\r\n    attribution: null,\r\n    where: '1=1',\r\n    fields: ['*'],\r\n    from: false,\r\n    to: false,\r\n    timeField: false,\r\n    timeFilterMode: 'server',\r\n    simplifyFactor: 0,\r\n    precision: 6,\r\n    fetchAllFeatures: false\r\n  },\r\n\r\n  /**\r\n   * Constructor\r\n   */\r\n\r\n  initialize: function (options) {\r\n    _FeatureGrid__WEBPACK_IMPORTED_MODULE_3__.FeatureGrid.prototype.initialize.call(this, options);\r\n\r\n    options = (0,_Util__WEBPACK_IMPORTED_MODULE_2__.getUrlParams)(options);\r\n    options = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.setOptions(this, options);\r\n\r\n    this.service = (0,_Services_FeatureLayerService__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(options);\r\n    this.service.addEventParent(this);\r\n\r\n    // use case insensitive regex to look for common fieldnames used for indexing\r\n    if (this.options.fields[0] !== '*') {\r\n      var oidCheck = false;\r\n      for (var i = 0; i < this.options.fields.length; i++) {\r\n        if (this.options.fields[i].match(/^(OBJECTID|FID|OID|ID)$/i)) {\r\n          oidCheck = true;\r\n        }\r\n      }\r\n      if (oidCheck === false) {\r\n        (0,_Util__WEBPACK_IMPORTED_MODULE_2__.warn)(\r\n          'no known esriFieldTypeOID field detected in fields Array.  Please add an attribute field containing unique IDs to ensure the layer can be drawn correctly.'\r\n        );\r\n      }\r\n    }\r\n\r\n    if (this.options.timeField.start && this.options.timeField.end) {\r\n      this._startTimeIndex = new tiny_binary_search__WEBPACK_IMPORTED_MODULE_4__[\"default\"]();\r\n      this._endTimeIndex = new tiny_binary_search__WEBPACK_IMPORTED_MODULE_4__[\"default\"]();\r\n    } else if (this.options.timeField) {\r\n      this._timeIndex = new tiny_binary_search__WEBPACK_IMPORTED_MODULE_4__[\"default\"]();\r\n    }\r\n\r\n    this._cache = {};\r\n    this._currentSnapshot = []; // cache of what layers should be active\r\n    this._activeRequests = 0;\r\n  },\r\n\r\n  /**\r\n   * Layer Interface\r\n   */\r\n\r\n  onAdd: function (map) {\r\n    // include 'Powered by Esri' in map attribution\r\n    (0,_Util__WEBPACK_IMPORTED_MODULE_2__.setEsriAttribution)(map);\r\n\r\n    this.service.metadata(function (err, metadata) {\r\n      if (!err) {\r\n        var supportedFormats = metadata.supportedQueryFormats;\r\n\r\n        // Check if someone has requested that we don't use geoJSON, even if it's available\r\n        var forceJsonFormat = false;\r\n        if (\r\n          this.service.options.isModern === false ||\r\n          this.options.fetchAllFeatures\r\n        ) {\r\n          forceJsonFormat = true;\r\n        }\r\n\r\n        // Unless we've been told otherwise, check to see whether service can emit GeoJSON natively\r\n        if (\r\n          !forceJsonFormat &&\r\n          supportedFormats &&\r\n          supportedFormats.indexOf('geoJSON') !== -1\r\n        ) {\r\n          this.service.options.isModern = true;\r\n        }\r\n\r\n        if (metadata.objectIdField) {\r\n          this.service.options.idAttribute = metadata.objectIdField;\r\n        }\r\n\r\n        // add copyright text listed in service metadata\r\n        if (\r\n          !this.options.attribution &&\r\n          map.attributionControl &&\r\n          metadata.copyrightText\r\n        ) {\r\n          this.options.attribution = metadata.copyrightText;\r\n          map.attributionControl.addAttribution(this.getAttribution());\r\n        }\r\n      }\r\n    }, this);\r\n\r\n    map.on('zoomend', this._handleZoomChange, this);\r\n\r\n    return _FeatureGrid__WEBPACK_IMPORTED_MODULE_3__.FeatureGrid.prototype.onAdd.call(this, map);\r\n  },\r\n\r\n  onRemove: function (map) {\r\n    (0,_Util__WEBPACK_IMPORTED_MODULE_2__.removeEsriAttribution)(map);\r\n    map.off('zoomend', this._handleZoomChange, this);\r\n\r\n    return _FeatureGrid__WEBPACK_IMPORTED_MODULE_3__.FeatureGrid.prototype.onRemove.call(this, map);\r\n  },\r\n\r\n  getAttribution: function () {\r\n    return this.options.attribution;\r\n  },\r\n\r\n  /**\r\n   * Feature Management\r\n   */\r\n\r\n  createCell: function (bounds, coords) {\r\n    // dont fetch features outside the scale range defined for the layer\r\n    if (this._visibleZoom()) {\r\n      this._requestFeatures(bounds, coords);\r\n    }\r\n  },\r\n\r\n  _requestFeatures: function (bounds, coords, callback, offset) {\r\n    this._activeRequests++;\r\n\r\n    // default param\r\n    offset = offset || 0;\r\n\r\n    var originalWhere = this.options.where;\r\n\r\n    // our first active request fires loading\r\n    if (this._activeRequests === 1) {\r\n      this.fire(\r\n        'loading',\r\n        {\r\n          bounds: bounds\r\n        },\r\n        true\r\n      );\r\n    }\r\n\r\n    return this._buildQuery(bounds, offset).run(function (\r\n      error,\r\n      featureCollection,\r\n      response\r\n    ) {\r\n      if (response && response.exceededTransferLimit) {\r\n        this.fire('drawlimitexceeded');\r\n      }\r\n\r\n      // the where changed while this request was being run so don't it.\r\n      if (this.options.where !== originalWhere) {\r\n        return;\r\n      }\r\n\r\n      // no error, features\r\n      if (!error && featureCollection && featureCollection.features.length) {\r\n        // schedule adding features until the next animation frame\r\n        leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.requestAnimFrame(\r\n          leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function () {\r\n            this._addFeatures(featureCollection.features, coords);\r\n            this._postProcessFeatures(bounds);\r\n          }, this)\r\n        );\r\n      }\r\n\r\n      // no error, no features\r\n      if (!error && featureCollection && !featureCollection.features.length) {\r\n        this._postProcessFeatures(bounds);\r\n      }\r\n\r\n      if (error) {\r\n        this._postProcessFeatures(bounds);\r\n      }\r\n\r\n      if (callback) {\r\n        callback.call(this, error, featureCollection);\r\n      }\r\n      if (\r\n        response &&\r\n        (response.exceededTransferLimit ||\r\n          (response.properties && response.properties.exceededTransferLimit)) &&\r\n        this.options.fetchAllFeatures\r\n      ) {\r\n        this._requestFeatures(\r\n          bounds,\r\n          coords,\r\n          callback,\r\n          offset + featureCollection.features.length\r\n        );\r\n      }\r\n    },\r\n    this);\r\n  },\r\n\r\n  _postProcessFeatures: function (bounds) {\r\n    // deincrement the request counter now that we have processed features\r\n    this._activeRequests--;\r\n\r\n    // if there are no more active requests fire a load event for this view\r\n    if (this._activeRequests <= 0) {\r\n      this.fire('load', {\r\n        bounds: bounds\r\n      });\r\n    }\r\n  },\r\n\r\n  _cacheKey: function (coords) {\r\n    return coords.z + ':' + coords.x + ':' + coords.y;\r\n  },\r\n\r\n  _addFeatures: function (features, coords) {\r\n    // coords is optional - will be false if coming from addFeatures() function\r\n    if (coords) {\r\n      var key = this._cacheKey(coords);\r\n      this._cache[key] = this._cache[key] || [];\r\n    }\r\n\r\n    for (var i = features.length - 1; i >= 0; i--) {\r\n      var id = features[i].id;\r\n\r\n      if (this._currentSnapshot.indexOf(id) === -1) {\r\n        this._currentSnapshot.push(id);\r\n      }\r\n      if (typeof key !== 'undefined' && this._cache[key].indexOf(id) === -1) {\r\n        this._cache[key].push(id);\r\n      }\r\n    }\r\n\r\n    if (this.options.timeField) {\r\n      this._buildTimeIndexes(features);\r\n    }\r\n\r\n    this.createLayers(features);\r\n  },\r\n\r\n  _buildQuery: function (bounds, offset) {\r\n    var query = this.service\r\n      .query()\r\n      .intersects(bounds)\r\n      .where(this.options.where)\r\n      .fields(this.options.fields)\r\n      .precision(this.options.precision);\r\n\r\n    if (this.options.fetchAllFeatures && !isNaN(parseInt(offset))) {\r\n      query = query.offset(offset);\r\n    }\r\n\r\n    query.params['resultType'] = 'tile';\r\n\r\n    if (this.options.requestParams) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.extend(query.params, this.options.requestParams);\r\n    }\r\n\r\n    if (this.options.simplifyFactor) {\r\n      query.simplify(this._map, this.options.simplifyFactor);\r\n    }\r\n\r\n    if (\r\n      this.options.timeFilterMode === 'server' &&\r\n      this.options.from &&\r\n      this.options.to\r\n    ) {\r\n      query.between(this.options.from, this.options.to);\r\n    }\r\n\r\n    return query;\r\n  },\r\n\r\n  /**\r\n   * Where Methods\r\n   */\r\n\r\n  setWhere: function (where, callback, context) {\r\n    this.options.where = where && where.length ? where : '1=1';\r\n\r\n    var oldSnapshot = [];\r\n    var newSnapshot = [];\r\n    var pendingRequests = 0;\r\n    var requestError = null;\r\n    var requestCallback = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function (error, featureCollection) {\r\n      if (error) {\r\n        requestError = error;\r\n      }\r\n\r\n      if (featureCollection) {\r\n        for (var i = featureCollection.features.length - 1; i >= 0; i--) {\r\n          newSnapshot.push(featureCollection.features[i].id);\r\n        }\r\n      }\r\n\r\n      pendingRequests--;\r\n\r\n      if (\r\n        pendingRequests <= 0 &&\r\n        this._visibleZoom() &&\r\n        where === this.options.where // the where is still the same so use this one\r\n      ) {\r\n        this._currentSnapshot = newSnapshot;\r\n        // schedule adding features for the next animation frame\r\n        leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.requestAnimFrame(\r\n          leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function () {\r\n            this.removeLayers(oldSnapshot);\r\n            this.addLayers(newSnapshot);\r\n            if (callback) {\r\n              callback.call(context, requestError);\r\n            }\r\n          }, this)\r\n        );\r\n      }\r\n    }, this);\r\n\r\n    for (var i = this._currentSnapshot.length - 1; i >= 0; i--) {\r\n      oldSnapshot.push(this._currentSnapshot[i]);\r\n    }\r\n\r\n    this._cache = {};\r\n\r\n    for (var key in this._cells) {\r\n      pendingRequests++;\r\n      var coords = this._keyToCellCoords(key);\r\n      var bounds = this._cellCoordsToBounds(coords);\r\n      this._requestFeatures(bounds, coords, requestCallback);\r\n    }\r\n\r\n    return this;\r\n  },\r\n\r\n  getWhere: function () {\r\n    return this.options.where;\r\n  },\r\n\r\n  /**\r\n   * Time Range Methods\r\n   */\r\n\r\n  getTimeRange: function () {\r\n    return [this.options.from, this.options.to];\r\n  },\r\n\r\n  setTimeRange: function (from, to, callback, context) {\r\n    var oldFrom = this.options.from;\r\n    var oldTo = this.options.to;\r\n    var pendingRequests = 0;\r\n    var requestError = null;\r\n    var requestCallback = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function (error) {\r\n      if (error) {\r\n        requestError = error;\r\n      }\r\n      this._filterExistingFeatures(oldFrom, oldTo, from, to);\r\n\r\n      pendingRequests--;\r\n\r\n      if (callback && pendingRequests <= 0) {\r\n        callback.call(context, requestError);\r\n      }\r\n    }, this);\r\n\r\n    this.options.from = from;\r\n    this.options.to = to;\r\n\r\n    this._filterExistingFeatures(oldFrom, oldTo, from, to);\r\n\r\n    if (this.options.timeFilterMode === 'server') {\r\n      for (var key in this._cells) {\r\n        pendingRequests++;\r\n        var coords = this._keyToCellCoords(key);\r\n        var bounds = this._cellCoordsToBounds(coords);\r\n        this._requestFeatures(bounds, coords, requestCallback);\r\n      }\r\n    }\r\n\r\n    return this;\r\n  },\r\n\r\n  refresh: function () {\r\n    this.setWhere(this.options.where);\r\n  },\r\n\r\n  _filterExistingFeatures: function (oldFrom, oldTo, newFrom, newTo) {\r\n    var layersToRemove =\r\n      oldFrom && oldTo\r\n        ? this._getFeaturesInTimeRange(oldFrom, oldTo)\r\n        : this._currentSnapshot;\r\n    var layersToAdd = this._getFeaturesInTimeRange(newFrom, newTo);\r\n\r\n    if (layersToAdd.indexOf) {\r\n      for (var i = 0; i < layersToAdd.length; i++) {\r\n        var shouldRemoveLayer = layersToRemove.indexOf(layersToAdd[i]);\r\n        if (shouldRemoveLayer >= 0) {\r\n          layersToRemove.splice(shouldRemoveLayer, 1);\r\n        }\r\n      }\r\n    }\r\n\r\n    // schedule adding features until the next animation frame\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.requestAnimFrame(\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function () {\r\n        this.removeLayers(layersToRemove);\r\n        this.addLayers(layersToAdd);\r\n      }, this)\r\n    );\r\n  },\r\n\r\n  _getFeaturesInTimeRange: function (start, end) {\r\n    var ids = [];\r\n    var search;\r\n\r\n    if (this.options.timeField.start && this.options.timeField.end) {\r\n      var startTimes = this._startTimeIndex.between(start, end);\r\n      var endTimes = this._endTimeIndex.between(start, end);\r\n      search = startTimes.concat(endTimes);\r\n    } else if (this._timeIndex) {\r\n      search = this._timeIndex.between(start, end);\r\n    } else {\r\n      (0,_Util__WEBPACK_IMPORTED_MODULE_2__.warn)(\r\n        'You must set timeField in the layer constructor in order to manipulate the start and end time filter.'\r\n      );\r\n      return [];\r\n    }\r\n\r\n    for (var i = search.length - 1; i >= 0; i--) {\r\n      ids.push(search[i].id);\r\n    }\r\n\r\n    return ids;\r\n  },\r\n\r\n  _buildTimeIndexes: function (geojson) {\r\n    var i;\r\n    var feature;\r\n    if (this.options.timeField.start && this.options.timeField.end) {\r\n      var startTimeEntries = [];\r\n      var endTimeEntries = [];\r\n      for (i = geojson.length - 1; i >= 0; i--) {\r\n        feature = geojson[i];\r\n        startTimeEntries.push({\r\n          id: feature.id,\r\n          value: new Date(feature.properties[this.options.timeField.start])\r\n        });\r\n        endTimeEntries.push({\r\n          id: feature.id,\r\n          value: new Date(feature.properties[this.options.timeField.end])\r\n        });\r\n      }\r\n      this._startTimeIndex.bulkAdd(startTimeEntries);\r\n      this._endTimeIndex.bulkAdd(endTimeEntries);\r\n    } else {\r\n      var timeEntries = [];\r\n      for (i = geojson.length - 1; i >= 0; i--) {\r\n        feature = geojson[i];\r\n        timeEntries.push({\r\n          id: feature.id,\r\n          value: new Date(feature.properties[this.options.timeField])\r\n        });\r\n      }\r\n\r\n      this._timeIndex.bulkAdd(timeEntries);\r\n    }\r\n  },\r\n\r\n  _featureWithinTimeRange: function (feature) {\r\n    if (!this.options.from || !this.options.to) {\r\n      return true;\r\n    }\r\n\r\n    var from = +this.options.from.valueOf();\r\n    var to = +this.options.to.valueOf();\r\n\r\n    if (typeof this.options.timeField === 'string') {\r\n      var date = +feature.properties[this.options.timeField];\r\n      return date >= from && date <= to;\r\n    }\r\n\r\n    if (this.options.timeField.start && this.options.timeField.end) {\r\n      var startDate = +feature.properties[this.options.timeField.start];\r\n      var endDate = +feature.properties[this.options.timeField.end];\r\n      return (\r\n        (startDate >= from && startDate <= to) ||\r\n        (endDate >= from && endDate <= to) ||\r\n        (startDate <= from && endDate >= to)\r\n      );\r\n    }\r\n  },\r\n\r\n  _visibleZoom: function () {\r\n    // check to see whether the current zoom level of the map is within the optional limit defined for the FeatureLayer\r\n    if (!this._map) {\r\n      return false;\r\n    }\r\n    var zoom = this._map.getZoom();\r\n    if (zoom > this.options.maxZoom || zoom < this.options.minZoom) {\r\n      return false;\r\n    } else {\r\n      return true;\r\n    }\r\n  },\r\n\r\n  _handleZoomChange: function () {\r\n    if (!this._visibleZoom()) {\r\n      // if we have moved outside the visible zoom range clear the current snapshot, no layers should be active\r\n      this.removeLayers(this._currentSnapshot);\r\n      this._currentSnapshot = [];\r\n    } else {\r\n      /*\r\n      for every cell in this._cells\r\n        1. Get the cache key for the coords of the cell\r\n        2. If this._cache[key] exists it will be an array of feature IDs.\r\n        3. Call this.addLayers(this._cache[key]) to instruct the feature layer to add the layers back.\r\n      */\r\n      for (var i in this._cells) {\r\n        var coords = this._cells[i].coords;\r\n        var key = this._cacheKey(coords);\r\n        if (this._cache[key]) {\r\n          this.addLayers(this._cache[key]);\r\n        }\r\n      }\r\n    }\r\n  },\r\n\r\n  /**\r\n   * Service Methods\r\n   */\r\n\r\n  authenticate: function (token) {\r\n    this.service.authenticate(token);\r\n    return this;\r\n  },\r\n\r\n  metadata: function (callback, context) {\r\n    this.service.metadata(callback, context);\r\n    return this;\r\n  },\r\n\r\n  query: function () {\r\n    return this.service.query();\r\n  },\r\n\r\n  _getMetadata: function (callback) {\r\n    if (this._metadata) {\r\n      var error;\r\n      callback(error, this._metadata);\r\n    } else {\r\n      this.metadata(\r\n        leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function (error, response) {\r\n          this._metadata = response;\r\n          callback(error, this._metadata);\r\n        }, this)\r\n      );\r\n    }\r\n  },\r\n\r\n  addFeature: function (feature, callback, context) {\r\n    this.addFeatures(feature, callback, context);\r\n  },\r\n\r\n  addFeatures: function (features, callback, context) {\r\n    this._getMetadata(\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function (error, metadata) {\r\n        if (error) {\r\n          if (callback) {\r\n            callback.call(this, error, null);\r\n          }\r\n          return;\r\n        }\r\n        // GeoJSON featureCollection or simple feature\r\n        var featuresArray = features.features ? features.features : [features];\r\n\r\n        this.service.addFeatures(\r\n          features,\r\n          leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function (error, response) {\r\n            if (!error) {\r\n              for (var i = featuresArray.length - 1; i >= 0; i--) {\r\n                // assign ID from result to appropriate objectid field from service metadata\r\n                featuresArray[i].properties[metadata.objectIdField] =\r\n                  featuresArray.length > 1\r\n                    ? response[i].objectId\r\n                    : response.objectId;\r\n                // we also need to update the geojson id for createLayers() to function\r\n                featuresArray[i].id =\r\n                  featuresArray.length > 1\r\n                    ? response[i].objectId\r\n                    : response.objectId;\r\n              }\r\n              this._addFeatures(featuresArray);\r\n            }\r\n\r\n            if (callback) {\r\n              callback.call(context, error, response);\r\n            }\r\n          }, this)\r\n        );\r\n      }, this)\r\n    );\r\n  },\r\n\r\n  updateFeature: function (feature, callback, context) {\r\n    this.updateFeatures(feature, callback, context);\r\n  },\r\n\r\n  updateFeatures: function (features, callback, context) {\r\n    // GeoJSON featureCollection or simple feature\r\n    var featuresArray = features.features ? features.features : [features];\r\n    this.service.updateFeatures(\r\n      features,\r\n      function (error, response) {\r\n        if (!error) {\r\n          for (var i = featuresArray.length - 1; i >= 0; i--) {\r\n            this.removeLayers([featuresArray[i].id], true);\r\n          }\r\n          this._addFeatures(featuresArray);\r\n        }\r\n\r\n        if (callback) {\r\n          callback.call(context, error, response);\r\n        }\r\n      },\r\n      this\r\n    );\r\n  },\r\n\r\n  deleteFeature: function (id, callback, context) {\r\n    this.deleteFeatures(id, callback, context);\r\n  },\r\n\r\n  deleteFeatures: function (ids, callback, context) {\r\n    return this.service.deleteFeatures(\r\n      ids,\r\n      function (error, response) {\r\n        var responseArray = response.length ? response : [response];\r\n        if (!error && responseArray.length > 0) {\r\n          for (var i = responseArray.length - 1; i >= 0; i--) {\r\n            this.removeLayers([responseArray[i].objectId], true);\r\n          }\r\n        }\r\n        if (callback) {\r\n          callback.call(context, error, response);\r\n        }\r\n      },\r\n      this\r\n    );\r\n  }\r\n});\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9MYXllcnMvRmVhdHVyZUxheWVyL0ZlYXR1cmVNYW5hZ2VyLmpzLmpzIiwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFBK0I7QUFDc0M7QUFNakQ7QUFDd0I7QUFDTztBQUNuRDtBQUNPLHFCQUFxQiw0REFBa0I7QUFDOUM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLElBQUksK0VBQXFDO0FBQ3pDO0FBQ0EsY0FBYyxtREFBWTtBQUMxQixjQUFjLG9EQUFlO0FBQzdCO0FBQ0EsbUJBQW1CLHlFQUFtQjtBQUN0QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0JBQXNCLGdDQUFnQztBQUN0RDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsUUFBUSwyQ0FBSTtBQUNaO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlDQUFpQywwREFBaUI7QUFDbEQsK0JBQStCLDBEQUFpQjtBQUNoRCxNQUFNO0FBQ04sNEJBQTRCLDBEQUFpQjtBQUM3QztBQUNBO0FBQ0E7QUFDQSxnQ0FBZ0M7QUFDaEM7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxJQUFJLHlEQUFrQjtBQUN0QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQSxXQUFXLDBFQUFnQztBQUMzQyxHQUFHO0FBQ0g7QUFDQTtBQUNBLElBQUksNERBQXFCO0FBQ3pCO0FBQ0E7QUFDQSxXQUFXLDZFQUFtQztBQUM5QyxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRLDBEQUFxQjtBQUM3QixVQUFVLDhDQUFTO0FBQ25CO0FBQ0E7QUFDQSxXQUFXO0FBQ1g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsT0FBTztBQUNQO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0NBQXNDLFFBQVE7QUFDOUM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBTSxnREFBVztBQUNqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsMEJBQTBCLDhDQUFTO0FBQ25DO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSw0REFBNEQsUUFBUTtBQUNwRTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVEsMERBQXFCO0FBQzdCLFVBQVUsOENBQVM7QUFDbkI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFdBQVc7QUFDWDtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0EsbURBQW1ELFFBQVE7QUFDM0Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLDBCQUEwQiw4Q0FBUztBQUNuQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0JBQXNCLHdCQUF3QjtBQUM5QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsSUFBSSwwREFBcUI7QUFDekIsTUFBTSw4Q0FBUztBQUNmO0FBQ0E7QUFDQSxPQUFPO0FBQ1A7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0EsTUFBTTtBQUNOLE1BQU0sMkNBQUk7QUFDVjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esb0NBQW9DLFFBQVE7QUFDNUM7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxtQ0FBbUMsUUFBUTtBQUMzQztBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0EsbUNBQW1DLFFBQVE7QUFDM0M7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxNQUFNO0FBQ047QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxNQUFNO0FBQ047QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0EsUUFBUSw4Q0FBUztBQUNqQjtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBLE1BQU0sOENBQVM7QUFDZjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVSw4Q0FBUztBQUNuQjtBQUNBLHFEQUFxRCxRQUFRO0FBQzdEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxXQUFXO0FBQ1g7QUFDQSxPQUFPO0FBQ1A7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpREFBaUQsUUFBUTtBQUN6RDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsT0FBTztBQUNQO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsaURBQWlELFFBQVE7QUFDekQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsT0FBTztBQUNQO0FBQ0E7QUFDQTtBQUNBLENBQUMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9MYXllcnMvRmVhdHVyZUxheWVyL0ZlYXR1cmVNYW5hZ2VyLmpzPzc5NTciXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVXRpbCB9IGZyb20gJ2xlYWZsZXQnO1xyXG5pbXBvcnQgZmVhdHVyZUxheWVyU2VydmljZSBmcm9tICcuLi8uLi9TZXJ2aWNlcy9GZWF0dXJlTGF5ZXJTZXJ2aWNlJztcclxuaW1wb3J0IHtcclxuICBnZXRVcmxQYXJhbXMsXHJcbiAgd2FybixcclxuICBzZXRFc3JpQXR0cmlidXRpb24sXHJcbiAgcmVtb3ZlRXNyaUF0dHJpYnV0aW9uXHJcbn0gZnJvbSAnLi4vLi4vVXRpbCc7XHJcbmltcG9ydCB7IEZlYXR1cmVHcmlkIH0gZnJvbSAnLi9GZWF0dXJlR3JpZCc7XHJcbmltcG9ydCBCaW5hcnlTZWFyY2hJbmRleCBmcm9tICd0aW55LWJpbmFyeS1zZWFyY2gnO1xyXG5cclxuZXhwb3J0IHZhciBGZWF0dXJlTWFuYWdlciA9IEZlYXR1cmVHcmlkLmV4dGVuZCh7XHJcbiAgLyoqXHJcbiAgICogT3B0aW9uc1xyXG4gICAqL1xyXG5cclxuICBvcHRpb25zOiB7XHJcbiAgICBhdHRyaWJ1dGlvbjogbnVsbCxcclxuICAgIHdoZXJlOiAnMT0xJyxcclxuICAgIGZpZWxkczogWycqJ10sXHJcbiAgICBmcm9tOiBmYWxzZSxcclxuICAgIHRvOiBmYWxzZSxcclxuICAgIHRpbWVGaWVsZDogZmFsc2UsXHJcbiAgICB0aW1lRmlsdGVyTW9kZTogJ3NlcnZlcicsXHJcbiAgICBzaW1wbGlmeUZhY3RvcjogMCxcclxuICAgIHByZWNpc2lvbjogNixcclxuICAgIGZldGNoQWxsRmVhdHVyZXM6IGZhbHNlXHJcbiAgfSxcclxuXHJcbiAgLyoqXHJcbiAgICogQ29uc3RydWN0b3JcclxuICAgKi9cclxuXHJcbiAgaW5pdGlhbGl6ZTogZnVuY3Rpb24gKG9wdGlvbnMpIHtcclxuICAgIEZlYXR1cmVHcmlkLnByb3RvdHlwZS5pbml0aWFsaXplLmNhbGwodGhpcywgb3B0aW9ucyk7XHJcblxyXG4gICAgb3B0aW9ucyA9IGdldFVybFBhcmFtcyhvcHRpb25zKTtcclxuICAgIG9wdGlvbnMgPSBVdGlsLnNldE9wdGlvbnModGhpcywgb3B0aW9ucyk7XHJcblxyXG4gICAgdGhpcy5zZXJ2aWNlID0gZmVhdHVyZUxheWVyU2VydmljZShvcHRpb25zKTtcclxuICAgIHRoaXMuc2VydmljZS5hZGRFdmVudFBhcmVudCh0aGlzKTtcclxuXHJcbiAgICAvLyB1c2UgY2FzZSBpbnNlbnNpdGl2ZSByZWdleCB0byBsb29rIGZvciBjb21tb24gZmllbGRuYW1lcyB1c2VkIGZvciBpbmRleGluZ1xyXG4gICAgaWYgKHRoaXMub3B0aW9ucy5maWVsZHNbMF0gIT09ICcqJykge1xyXG4gICAgICB2YXIgb2lkQ2hlY2sgPSBmYWxzZTtcclxuICAgICAgZm9yICh2YXIgaSA9IDA7IGkgPCB0aGlzLm9wdGlvbnMuZmllbGRzLmxlbmd0aDsgaSsrKSB7XHJcbiAgICAgICAgaWYgKHRoaXMub3B0aW9ucy5maWVsZHNbaV0ubWF0Y2goL14oT0JKRUNUSUR8RklEfE9JRHxJRCkkL2kpKSB7XHJcbiAgICAgICAgICBvaWRDaGVjayA9IHRydWU7XHJcbiAgICAgICAgfVxyXG4gICAgICB9XHJcbiAgICAgIGlmIChvaWRDaGVjayA9PT0gZmFsc2UpIHtcclxuICAgICAgICB3YXJuKFxyXG4gICAgICAgICAgJ25vIGtub3duIGVzcmlGaWVsZFR5cGVPSUQgZmllbGQgZGV0ZWN0ZWQgaW4gZmllbGRzIEFycmF5LiAgUGxlYXNlIGFkZCBhbiBhdHRyaWJ1dGUgZmllbGQgY29udGFpbmluZyB1bmlxdWUgSURzIHRvIGVuc3VyZSB0aGUgbGF5ZXIgY2FuIGJlIGRyYXduIGNvcnJlY3RseS4nXHJcbiAgICAgICAgKTtcclxuICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIGlmICh0aGlzLm9wdGlvbnMudGltZUZpZWxkLnN0YXJ0ICYmIHRoaXMub3B0aW9ucy50aW1lRmllbGQuZW5kKSB7XHJcbiAgICAgIHRoaXMuX3N0YXJ0VGltZUluZGV4ID0gbmV3IEJpbmFyeVNlYXJjaEluZGV4KCk7XHJcbiAgICAgIHRoaXMuX2VuZFRpbWVJbmRleCA9IG5ldyBCaW5hcnlTZWFyY2hJbmRleCgpO1xyXG4gICAgfSBlbHNlIGlmICh0aGlzLm9wdGlvbnMudGltZUZpZWxkKSB7XHJcbiAgICAgIHRoaXMuX3RpbWVJbmRleCA9IG5ldyBCaW5hcnlTZWFyY2hJbmRleCgpO1xyXG4gICAgfVxyXG5cclxuICAgIHRoaXMuX2NhY2hlID0ge307XHJcbiAgICB0aGlzLl9jdXJyZW50U25hcHNob3QgPSBbXTsgLy8gY2FjaGUgb2Ygd2hhdCBsYXllcnMgc2hvdWxkIGJlIGFjdGl2ZVxyXG4gICAgdGhpcy5fYWN0aXZlUmVxdWVzdHMgPSAwO1xyXG4gIH0sXHJcblxyXG4gIC8qKlxyXG4gICAqIExheWVyIEludGVyZmFjZVxyXG4gICAqL1xyXG5cclxuICBvbkFkZDogZnVuY3Rpb24gKG1hcCkge1xyXG4gICAgLy8gaW5jbHVkZSAnUG93ZXJlZCBieSBFc3JpJyBpbiBtYXAgYXR0cmlidXRpb25cclxuICAgIHNldEVzcmlBdHRyaWJ1dGlvbihtYXApO1xyXG5cclxuICAgIHRoaXMuc2VydmljZS5tZXRhZGF0YShmdW5jdGlvbiAoZXJyLCBtZXRhZGF0YSkge1xyXG4gICAgICBpZiAoIWVycikge1xyXG4gICAgICAgIHZhciBzdXBwb3J0ZWRGb3JtYXRzID0gbWV0YWRhdGEuc3VwcG9ydGVkUXVlcnlGb3JtYXRzO1xyXG5cclxuICAgICAgICAvLyBDaGVjayBpZiBzb21lb25lIGhhcyByZXF1ZXN0ZWQgdGhhdCB3ZSBkb24ndCB1c2UgZ2VvSlNPTiwgZXZlbiBpZiBpdCdzIGF2YWlsYWJsZVxyXG4gICAgICAgIHZhciBmb3JjZUpzb25Gb3JtYXQgPSBmYWxzZTtcclxuICAgICAgICBpZiAoXHJcbiAgICAgICAgICB0aGlzLnNlcnZpY2Uub3B0aW9ucy5pc01vZGVybiA9PT0gZmFsc2UgfHxcclxuICAgICAgICAgIHRoaXMub3B0aW9ucy5mZXRjaEFsbEZlYXR1cmVzXHJcbiAgICAgICAgKSB7XHJcbiAgICAgICAgICBmb3JjZUpzb25Gb3JtYXQgPSB0cnVlO1xyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgLy8gVW5sZXNzIHdlJ3ZlIGJlZW4gdG9sZCBvdGhlcndpc2UsIGNoZWNrIHRvIHNlZSB3aGV0aGVyIHNlcnZpY2UgY2FuIGVtaXQgR2VvSlNPTiBuYXRpdmVseVxyXG4gICAgICAgIGlmIChcclxuICAgICAgICAgICFmb3JjZUpzb25Gb3JtYXQgJiZcclxuICAgICAgICAgIHN1cHBvcnRlZEZvcm1hdHMgJiZcclxuICAgICAgICAgIHN1cHBvcnRlZEZvcm1hdHMuaW5kZXhPZignZ2VvSlNPTicpICE9PSAtMVxyXG4gICAgICAgICkge1xyXG4gICAgICAgICAgdGhpcy5zZXJ2aWNlLm9wdGlvbnMuaXNNb2Rlcm4gPSB0cnVlO1xyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgaWYgKG1ldGFkYXRhLm9iamVjdElkRmllbGQpIHtcclxuICAgICAgICAgIHRoaXMuc2VydmljZS5vcHRpb25zLmlkQXR0cmlidXRlID0gbWV0YWRhdGEub2JqZWN0SWRGaWVsZDtcclxuICAgICAgICB9XHJcblxyXG4gICAgICAgIC8vIGFkZCBjb3B5cmlnaHQgdGV4dCBsaXN0ZWQgaW4gc2VydmljZSBtZXRhZGF0YVxyXG4gICAgICAgIGlmIChcclxuICAgICAgICAgICF0aGlzLm9wdGlvbnMuYXR0cmlidXRpb24gJiZcclxuICAgICAgICAgIG1hcC5hdHRyaWJ1dGlvbkNvbnRyb2wgJiZcclxuICAgICAgICAgIG1ldGFkYXRhLmNvcHlyaWdodFRleHRcclxuICAgICAgICApIHtcclxuICAgICAgICAgIHRoaXMub3B0aW9ucy5hdHRyaWJ1dGlvbiA9IG1ldGFkYXRhLmNvcHlyaWdodFRleHQ7XHJcbiAgICAgICAgICBtYXAuYXR0cmlidXRpb25Db250cm9sLmFkZEF0dHJpYnV0aW9uKHRoaXMuZ2V0QXR0cmlidXRpb24oKSk7XHJcbiAgICAgICAgfVxyXG4gICAgICB9XHJcbiAgICB9LCB0aGlzKTtcclxuXHJcbiAgICBtYXAub24oJ3pvb21lbmQnLCB0aGlzLl9oYW5kbGVab29tQ2hhbmdlLCB0aGlzKTtcclxuXHJcbiAgICByZXR1cm4gRmVhdHVyZUdyaWQucHJvdG90eXBlLm9uQWRkLmNhbGwodGhpcywgbWFwKTtcclxuICB9LFxyXG5cclxuICBvblJlbW92ZTogZnVuY3Rpb24gKG1hcCkge1xyXG4gICAgcmVtb3ZlRXNyaUF0dHJpYnV0aW9uKG1hcCk7XHJcbiAgICBtYXAub2ZmKCd6b29tZW5kJywgdGhpcy5faGFuZGxlWm9vbUNoYW5nZSwgdGhpcyk7XHJcblxyXG4gICAgcmV0dXJuIEZlYXR1cmVHcmlkLnByb3RvdHlwZS5vblJlbW92ZS5jYWxsKHRoaXMsIG1hcCk7XHJcbiAgfSxcclxuXHJcbiAgZ2V0QXR0cmlidXRpb246IGZ1bmN0aW9uICgpIHtcclxuICAgIHJldHVybiB0aGlzLm9wdGlvbnMuYXR0cmlidXRpb247XHJcbiAgfSxcclxuXHJcbiAgLyoqXHJcbiAgICogRmVhdHVyZSBNYW5hZ2VtZW50XHJcbiAgICovXHJcblxyXG4gIGNyZWF0ZUNlbGw6IGZ1bmN0aW9uIChib3VuZHMsIGNvb3Jkcykge1xyXG4gICAgLy8gZG9udCBmZXRjaCBmZWF0dXJlcyBvdXRzaWRlIHRoZSBzY2FsZSByYW5nZSBkZWZpbmVkIGZvciB0aGUgbGF5ZXJcclxuICAgIGlmICh0aGlzLl92aXNpYmxlWm9vbSgpKSB7XHJcbiAgICAgIHRoaXMuX3JlcXVlc3RGZWF0dXJlcyhib3VuZHMsIGNvb3Jkcyk7XHJcbiAgICB9XHJcbiAgfSxcclxuXHJcbiAgX3JlcXVlc3RGZWF0dXJlczogZnVuY3Rpb24gKGJvdW5kcywgY29vcmRzLCBjYWxsYmFjaywgb2Zmc2V0KSB7XHJcbiAgICB0aGlzLl9hY3RpdmVSZXF1ZXN0cysrO1xyXG5cclxuICAgIC8vIGRlZmF1bHQgcGFyYW1cclxuICAgIG9mZnNldCA9IG9mZnNldCB8fCAwO1xyXG5cclxuICAgIHZhciBvcmlnaW5hbFdoZXJlID0gdGhpcy5vcHRpb25zLndoZXJlO1xyXG5cclxuICAgIC8vIG91ciBmaXJzdCBhY3RpdmUgcmVxdWVzdCBmaXJlcyBsb2FkaW5nXHJcbiAgICBpZiAodGhpcy5fYWN0aXZlUmVxdWVzdHMgPT09IDEpIHtcclxuICAgICAgdGhpcy5maXJlKFxyXG4gICAgICAgICdsb2FkaW5nJyxcclxuICAgICAgICB7XHJcbiAgICAgICAgICBib3VuZHM6IGJvdW5kc1xyXG4gICAgICAgIH0sXHJcbiAgICAgICAgdHJ1ZVxyXG4gICAgICApO1xyXG4gICAgfVxyXG5cclxuICAgIHJldHVybiB0aGlzLl9idWlsZFF1ZXJ5KGJvdW5kcywgb2Zmc2V0KS5ydW4oZnVuY3Rpb24gKFxyXG4gICAgICBlcnJvcixcclxuICAgICAgZmVhdHVyZUNvbGxlY3Rpb24sXHJcbiAgICAgIHJlc3BvbnNlXHJcbiAgICApIHtcclxuICAgICAgaWYgKHJlc3BvbnNlICYmIHJlc3BvbnNlLmV4Y2VlZGVkVHJhbnNmZXJMaW1pdCkge1xyXG4gICAgICAgIHRoaXMuZmlyZSgnZHJhd2xpbWl0ZXhjZWVkZWQnKTtcclxuICAgICAgfVxyXG5cclxuICAgICAgLy8gdGhlIHdoZXJlIGNoYW5nZWQgd2hpbGUgdGhpcyByZXF1ZXN0IHdhcyBiZWluZyBydW4gc28gZG9uJ3QgaXQuXHJcbiAgICAgIGlmICh0aGlzLm9wdGlvbnMud2hlcmUgIT09IG9yaWdpbmFsV2hlcmUpIHtcclxuICAgICAgICByZXR1cm47XHJcbiAgICAgIH1cclxuXHJcbiAgICAgIC8vIG5vIGVycm9yLCBmZWF0dXJlc1xyXG4gICAgICBpZiAoIWVycm9yICYmIGZlYXR1cmVDb2xsZWN0aW9uICYmIGZlYXR1cmVDb2xsZWN0aW9uLmZlYXR1cmVzLmxlbmd0aCkge1xyXG4gICAgICAgIC8vIHNjaGVkdWxlIGFkZGluZyBmZWF0dXJlcyB1bnRpbCB0aGUgbmV4dCBhbmltYXRpb24gZnJhbWVcclxuICAgICAgICBVdGlsLnJlcXVlc3RBbmltRnJhbWUoXHJcbiAgICAgICAgICBVdGlsLmJpbmQoZnVuY3Rpb24gKCkge1xyXG4gICAgICAgICAgICB0aGlzLl9hZGRGZWF0dXJlcyhmZWF0dXJlQ29sbGVjdGlvbi5mZWF0dXJlcywgY29vcmRzKTtcclxuICAgICAgICAgICAgdGhpcy5fcG9zdFByb2Nlc3NGZWF0dXJlcyhib3VuZHMpO1xyXG4gICAgICAgICAgfSwgdGhpcylcclxuICAgICAgICApO1xyXG4gICAgICB9XHJcblxyXG4gICAgICAvLyBubyBlcnJvciwgbm8gZmVhdHVyZXNcclxuICAgICAgaWYgKCFlcnJvciAmJiBmZWF0dXJlQ29sbGVjdGlvbiAmJiAhZmVhdHVyZUNvbGxlY3Rpb24uZmVhdHVyZXMubGVuZ3RoKSB7XHJcbiAgICAgICAgdGhpcy5fcG9zdFByb2Nlc3NGZWF0dXJlcyhib3VuZHMpO1xyXG4gICAgICB9XHJcblxyXG4gICAgICBpZiAoZXJyb3IpIHtcclxuICAgICAgICB0aGlzLl9wb3N0UHJvY2Vzc0ZlYXR1cmVzKGJvdW5kcyk7XHJcbiAgICAgIH1cclxuXHJcbiAgICAgIGlmIChjYWxsYmFjaykge1xyXG4gICAgICAgIGNhbGxiYWNrLmNhbGwodGhpcywgZXJyb3IsIGZlYXR1cmVDb2xsZWN0aW9uKTtcclxuICAgICAgfVxyXG4gICAgICBpZiAoXHJcbiAgICAgICAgcmVzcG9uc2UgJiZcclxuICAgICAgICAocmVzcG9uc2UuZXhjZWVkZWRUcmFuc2ZlckxpbWl0IHx8XHJcbiAgICAgICAgICAocmVzcG9uc2UucHJvcGVydGllcyAmJiByZXNwb25zZS5wcm9wZXJ0aWVzLmV4Y2VlZGVkVHJhbnNmZXJMaW1pdCkpICYmXHJcbiAgICAgICAgdGhpcy5vcHRpb25zLmZldGNoQWxsRmVhdHVyZXNcclxuICAgICAgKSB7XHJcbiAgICAgICAgdGhpcy5fcmVxdWVzdEZlYXR1cmVzKFxyXG4gICAgICAgICAgYm91bmRzLFxyXG4gICAgICAgICAgY29vcmRzLFxyXG4gICAgICAgICAgY2FsbGJhY2ssXHJcbiAgICAgICAgICBvZmZzZXQgKyBmZWF0dXJlQ29sbGVjdGlvbi5mZWF0dXJlcy5sZW5ndGhcclxuICAgICAgICApO1xyXG4gICAgICB9XHJcbiAgICB9LFxyXG4gICAgdGhpcyk7XHJcbiAgfSxcclxuXHJcbiAgX3Bvc3RQcm9jZXNzRmVhdHVyZXM6IGZ1bmN0aW9uIChib3VuZHMpIHtcclxuICAgIC8vIGRlaW5jcmVtZW50IHRoZSByZXF1ZXN0IGNvdW50ZXIgbm93IHRoYXQgd2UgaGF2ZSBwcm9jZXNzZWQgZmVhdHVyZXNcclxuICAgIHRoaXMuX2FjdGl2ZVJlcXVlc3RzLS07XHJcblxyXG4gICAgLy8gaWYgdGhlcmUgYXJlIG5vIG1vcmUgYWN0aXZlIHJlcXVlc3RzIGZpcmUgYSBsb2FkIGV2ZW50IGZvciB0aGlzIHZpZXdcclxuICAgIGlmICh0aGlzLl9hY3RpdmVSZXF1ZXN0cyA8PSAwKSB7XHJcbiAgICAgIHRoaXMuZmlyZSgnbG9hZCcsIHtcclxuICAgICAgICBib3VuZHM6IGJvdW5kc1xyXG4gICAgICB9KTtcclxuICAgIH1cclxuICB9LFxyXG5cclxuICBfY2FjaGVLZXk6IGZ1bmN0aW9uIChjb29yZHMpIHtcclxuICAgIHJldHVybiBjb29yZHMueiArICc6JyArIGNvb3Jkcy54ICsgJzonICsgY29vcmRzLnk7XHJcbiAgfSxcclxuXHJcbiAgX2FkZEZlYXR1cmVzOiBmdW5jdGlvbiAoZmVhdHVyZXMsIGNvb3Jkcykge1xyXG4gICAgLy8gY29vcmRzIGlzIG9wdGlvbmFsIC0gd2lsbCBiZSBmYWxzZSBpZiBjb21pbmcgZnJvbSBhZGRGZWF0dXJlcygpIGZ1bmN0aW9uXHJcbiAgICBpZiAoY29vcmRzKSB7XHJcbiAgICAgIHZhciBrZXkgPSB0aGlzLl9jYWNoZUtleShjb29yZHMpO1xyXG4gICAgICB0aGlzLl9jYWNoZVtrZXldID0gdGhpcy5fY2FjaGVba2V5XSB8fCBbXTtcclxuICAgIH1cclxuXHJcbiAgICBmb3IgKHZhciBpID0gZmVhdHVyZXMubGVuZ3RoIC0gMTsgaSA+PSAwOyBpLS0pIHtcclxuICAgICAgdmFyIGlkID0gZmVhdHVyZXNbaV0uaWQ7XHJcblxyXG4gICAgICBpZiAodGhpcy5fY3VycmVudFNuYXBzaG90LmluZGV4T2YoaWQpID09PSAtMSkge1xyXG4gICAgICAgIHRoaXMuX2N1cnJlbnRTbmFwc2hvdC5wdXNoKGlkKTtcclxuICAgICAgfVxyXG4gICAgICBpZiAodHlwZW9mIGtleSAhPT0gJ3VuZGVmaW5lZCcgJiYgdGhpcy5fY2FjaGVba2V5XS5pbmRleE9mKGlkKSA9PT0gLTEpIHtcclxuICAgICAgICB0aGlzLl9jYWNoZVtrZXldLnB1c2goaWQpO1xyXG4gICAgICB9XHJcbiAgICB9XHJcblxyXG4gICAgaWYgKHRoaXMub3B0aW9ucy50aW1lRmllbGQpIHtcclxuICAgICAgdGhpcy5fYnVpbGRUaW1lSW5kZXhlcyhmZWF0dXJlcyk7XHJcbiAgICB9XHJcblxyXG4gICAgdGhpcy5jcmVhdGVMYXllcnMoZmVhdHVyZXMpO1xyXG4gIH0sXHJcblxyXG4gIF9idWlsZFF1ZXJ5OiBmdW5jdGlvbiAoYm91bmRzLCBvZmZzZXQpIHtcclxuICAgIHZhciBxdWVyeSA9IHRoaXMuc2VydmljZVxyXG4gICAgICAucXVlcnkoKVxyXG4gICAgICAuaW50ZXJzZWN0cyhib3VuZHMpXHJcbiAgICAgIC53aGVyZSh0aGlzLm9wdGlvbnMud2hlcmUpXHJcbiAgICAgIC5maWVsZHModGhpcy5vcHRpb25zLmZpZWxkcylcclxuICAgICAgLnByZWNpc2lvbih0aGlzLm9wdGlvbnMucHJlY2lzaW9uKTtcclxuXHJcbiAgICBpZiAodGhpcy5vcHRpb25zLmZldGNoQWxsRmVhdHVyZXMgJiYgIWlzTmFOKHBhcnNlSW50KG9mZnNldCkpKSB7XHJcbiAgICAgIHF1ZXJ5ID0gcXVlcnkub2Zmc2V0KG9mZnNldCk7XHJcbiAgICB9XHJcblxyXG4gICAgcXVlcnkucGFyYW1zWydyZXN1bHRUeXBlJ10gPSAndGlsZSc7XHJcblxyXG4gICAgaWYgKHRoaXMub3B0aW9ucy5yZXF1ZXN0UGFyYW1zKSB7XHJcbiAgICAgIFV0aWwuZXh0ZW5kKHF1ZXJ5LnBhcmFtcywgdGhpcy5vcHRpb25zLnJlcXVlc3RQYXJhbXMpO1xyXG4gICAgfVxyXG5cclxuICAgIGlmICh0aGlzLm9wdGlvbnMuc2ltcGxpZnlGYWN0b3IpIHtcclxuICAgICAgcXVlcnkuc2ltcGxpZnkodGhpcy5fbWFwLCB0aGlzLm9wdGlvbnMuc2ltcGxpZnlGYWN0b3IpO1xyXG4gICAgfVxyXG5cclxuICAgIGlmIChcclxuICAgICAgdGhpcy5vcHRpb25zLnRpbWVGaWx0ZXJNb2RlID09PSAnc2VydmVyJyAmJlxyXG4gICAgICB0aGlzLm9wdGlvbnMuZnJvbSAmJlxyXG4gICAgICB0aGlzLm9wdGlvbnMudG9cclxuICAgICkge1xyXG4gICAgICBxdWVyeS5iZXR3ZWVuKHRoaXMub3B0aW9ucy5mcm9tLCB0aGlzLm9wdGlvbnMudG8pO1xyXG4gICAgfVxyXG5cclxuICAgIHJldHVybiBxdWVyeTtcclxuICB9LFxyXG5cclxuICAvKipcclxuICAgKiBXaGVyZSBNZXRob2RzXHJcbiAgICovXHJcblxyXG4gIHNldFdoZXJlOiBmdW5jdGlvbiAod2hlcmUsIGNhbGxiYWNrLCBjb250ZXh0KSB7XHJcbiAgICB0aGlzLm9wdGlvbnMud2hlcmUgPSB3aGVyZSAmJiB3aGVyZS5sZW5ndGggPyB3aGVyZSA6ICcxPTEnO1xyXG5cclxuICAgIHZhciBvbGRTbmFwc2hvdCA9IFtdO1xyXG4gICAgdmFyIG5ld1NuYXBzaG90ID0gW107XHJcbiAgICB2YXIgcGVuZGluZ1JlcXVlc3RzID0gMDtcclxuICAgIHZhciByZXF1ZXN0RXJyb3IgPSBudWxsO1xyXG4gICAgdmFyIHJlcXVlc3RDYWxsYmFjayA9IFV0aWwuYmluZChmdW5jdGlvbiAoZXJyb3IsIGZlYXR1cmVDb2xsZWN0aW9uKSB7XHJcbiAgICAgIGlmIChlcnJvcikge1xyXG4gICAgICAgIHJlcXVlc3RFcnJvciA9IGVycm9yO1xyXG4gICAgICB9XHJcblxyXG4gICAgICBpZiAoZmVhdHVyZUNvbGxlY3Rpb24pIHtcclxuICAgICAgICBmb3IgKHZhciBpID0gZmVhdHVyZUNvbGxlY3Rpb24uZmVhdHVyZXMubGVuZ3RoIC0gMTsgaSA+PSAwOyBpLS0pIHtcclxuICAgICAgICAgIG5ld1NuYXBzaG90LnB1c2goZmVhdHVyZUNvbGxlY3Rpb24uZmVhdHVyZXNbaV0uaWQpO1xyXG4gICAgICAgIH1cclxuICAgICAgfVxyXG5cclxuICAgICAgcGVuZGluZ1JlcXVlc3RzLS07XHJcblxyXG4gICAgICBpZiAoXHJcbiAgICAgICAgcGVuZGluZ1JlcXVlc3RzIDw9IDAgJiZcclxuICAgICAgICB0aGlzLl92aXNpYmxlWm9vbSgpICYmXHJcbiAgICAgICAgd2hlcmUgPT09IHRoaXMub3B0aW9ucy53aGVyZSAvLyB0aGUgd2hlcmUgaXMgc3RpbGwgdGhlIHNhbWUgc28gdXNlIHRoaXMgb25lXHJcbiAgICAgICkge1xyXG4gICAgICAgIHRoaXMuX2N1cnJlbnRTbmFwc2hvdCA9IG5ld1NuYXBzaG90O1xyXG4gICAgICAgIC8vIHNjaGVkdWxlIGFkZGluZyBmZWF0dXJlcyBmb3IgdGhlIG5leHQgYW5pbWF0aW9uIGZyYW1lXHJcbiAgICAgICAgVXRpbC5yZXF1ZXN0QW5pbUZyYW1lKFxyXG4gICAgICAgICAgVXRpbC5iaW5kKGZ1bmN0aW9uICgpIHtcclxuICAgICAgICAgICAgdGhpcy5yZW1vdmVMYXllcnMob2xkU25hcHNob3QpO1xyXG4gICAgICAgICAgICB0aGlzLmFkZExheWVycyhuZXdTbmFwc2hvdCk7XHJcbiAgICAgICAgICAgIGlmIChjYWxsYmFjaykge1xyXG4gICAgICAgICAgICAgIGNhbGxiYWNrLmNhbGwoY29udGV4dCwgcmVxdWVzdEVycm9yKTtcclxuICAgICAgICAgICAgfVxyXG4gICAgICAgICAgfSwgdGhpcylcclxuICAgICAgICApO1xyXG4gICAgICB9XHJcbiAgICB9LCB0aGlzKTtcclxuXHJcbiAgICBmb3IgKHZhciBpID0gdGhpcy5fY3VycmVudFNuYXBzaG90Lmxlbmd0aCAtIDE7IGkgPj0gMDsgaS0tKSB7XHJcbiAgICAgIG9sZFNuYXBzaG90LnB1c2godGhpcy5fY3VycmVudFNuYXBzaG90W2ldKTtcclxuICAgIH1cclxuXHJcbiAgICB0aGlzLl9jYWNoZSA9IHt9O1xyXG5cclxuICAgIGZvciAodmFyIGtleSBpbiB0aGlzLl9jZWxscykge1xyXG4gICAgICBwZW5kaW5nUmVxdWVzdHMrKztcclxuICAgICAgdmFyIGNvb3JkcyA9IHRoaXMuX2tleVRvQ2VsbENvb3JkcyhrZXkpO1xyXG4gICAgICB2YXIgYm91bmRzID0gdGhpcy5fY2VsbENvb3Jkc1RvQm91bmRzKGNvb3Jkcyk7XHJcbiAgICAgIHRoaXMuX3JlcXVlc3RGZWF0dXJlcyhib3VuZHMsIGNvb3JkcywgcmVxdWVzdENhbGxiYWNrKTtcclxuICAgIH1cclxuXHJcbiAgICByZXR1cm4gdGhpcztcclxuICB9LFxyXG5cclxuICBnZXRXaGVyZTogZnVuY3Rpb24gKCkge1xyXG4gICAgcmV0dXJuIHRoaXMub3B0aW9ucy53aGVyZTtcclxuICB9LFxyXG5cclxuICAvKipcclxuICAgKiBUaW1lIFJhbmdlIE1ldGhvZHNcclxuICAgKi9cclxuXHJcbiAgZ2V0VGltZVJhbmdlOiBmdW5jdGlvbiAoKSB7XHJcbiAgICByZXR1cm4gW3RoaXMub3B0aW9ucy5mcm9tLCB0aGlzLm9wdGlvbnMudG9dO1xyXG4gIH0sXHJcblxyXG4gIHNldFRpbWVSYW5nZTogZnVuY3Rpb24gKGZyb20sIHRvLCBjYWxsYmFjaywgY29udGV4dCkge1xyXG4gICAgdmFyIG9sZEZyb20gPSB0aGlzLm9wdGlvbnMuZnJvbTtcclxuICAgIHZhciBvbGRUbyA9IHRoaXMub3B0aW9ucy50bztcclxuICAgIHZhciBwZW5kaW5nUmVxdWVzdHMgPSAwO1xyXG4gICAgdmFyIHJlcXVlc3RFcnJvciA9IG51bGw7XHJcbiAgICB2YXIgcmVxdWVzdENhbGxiYWNrID0gVXRpbC5iaW5kKGZ1bmN0aW9uIChlcnJvcikge1xyXG4gICAgICBpZiAoZXJyb3IpIHtcclxuICAgICAgICByZXF1ZXN0RXJyb3IgPSBlcnJvcjtcclxuICAgICAgfVxyXG4gICAgICB0aGlzLl9maWx0ZXJFeGlzdGluZ0ZlYXR1cmVzKG9sZEZyb20sIG9sZFRvLCBmcm9tLCB0byk7XHJcblxyXG4gICAgICBwZW5kaW5nUmVxdWVzdHMtLTtcclxuXHJcbiAgICAgIGlmIChjYWxsYmFjayAmJiBwZW5kaW5nUmVxdWVzdHMgPD0gMCkge1xyXG4gICAgICAgIGNhbGxiYWNrLmNhbGwoY29udGV4dCwgcmVxdWVzdEVycm9yKTtcclxuICAgICAgfVxyXG4gICAgfSwgdGhpcyk7XHJcblxyXG4gICAgdGhpcy5vcHRpb25zLmZyb20gPSBmcm9tO1xyXG4gICAgdGhpcy5vcHRpb25zLnRvID0gdG87XHJcblxyXG4gICAgdGhpcy5fZmlsdGVyRXhpc3RpbmdGZWF0dXJlcyhvbGRGcm9tLCBvbGRUbywgZnJvbSwgdG8pO1xyXG5cclxuICAgIGlmICh0aGlzLm9wdGlvbnMudGltZUZpbHRlck1vZGUgPT09ICdzZXJ2ZXInKSB7XHJcbiAgICAgIGZvciAodmFyIGtleSBpbiB0aGlzLl9jZWxscykge1xyXG4gICAgICAgIHBlbmRpbmdSZXF1ZXN0cysrO1xyXG4gICAgICAgIHZhciBjb29yZHMgPSB0aGlzLl9rZXlUb0NlbGxDb29yZHMoa2V5KTtcclxuICAgICAgICB2YXIgYm91bmRzID0gdGhpcy5fY2VsbENvb3Jkc1RvQm91bmRzKGNvb3Jkcyk7XHJcbiAgICAgICAgdGhpcy5fcmVxdWVzdEZlYXR1cmVzKGJvdW5kcywgY29vcmRzLCByZXF1ZXN0Q2FsbGJhY2spO1xyXG4gICAgICB9XHJcbiAgICB9XHJcblxyXG4gICAgcmV0dXJuIHRoaXM7XHJcbiAgfSxcclxuXHJcbiAgcmVmcmVzaDogZnVuY3Rpb24gKCkge1xyXG4gICAgdGhpcy5zZXRXaGVyZSh0aGlzLm9wdGlvbnMud2hlcmUpO1xyXG4gIH0sXHJcblxyXG4gIF9maWx0ZXJFeGlzdGluZ0ZlYXR1cmVzOiBmdW5jdGlvbiAob2xkRnJvbSwgb2xkVG8sIG5ld0Zyb20sIG5ld1RvKSB7XHJcbiAgICB2YXIgbGF5ZXJzVG9SZW1vdmUgPVxyXG4gICAgICBvbGRGcm9tICYmIG9sZFRvXHJcbiAgICAgICAgPyB0aGlzLl9nZXRGZWF0dXJlc0luVGltZVJhbmdlKG9sZEZyb20sIG9sZFRvKVxyXG4gICAgICAgIDogdGhpcy5fY3VycmVudFNuYXBzaG90O1xyXG4gICAgdmFyIGxheWVyc1RvQWRkID0gdGhpcy5fZ2V0RmVhdHVyZXNJblRpbWVSYW5nZShuZXdGcm9tLCBuZXdUbyk7XHJcblxyXG4gICAgaWYgKGxheWVyc1RvQWRkLmluZGV4T2YpIHtcclxuICAgICAgZm9yICh2YXIgaSA9IDA7IGkgPCBsYXllcnNUb0FkZC5sZW5ndGg7IGkrKykge1xyXG4gICAgICAgIHZhciBzaG91bGRSZW1vdmVMYXllciA9IGxheWVyc1RvUmVtb3ZlLmluZGV4T2YobGF5ZXJzVG9BZGRbaV0pO1xyXG4gICAgICAgIGlmIChzaG91bGRSZW1vdmVMYXllciA+PSAwKSB7XHJcbiAgICAgICAgICBsYXllcnNUb1JlbW92ZS5zcGxpY2Uoc2hvdWxkUmVtb3ZlTGF5ZXIsIDEpO1xyXG4gICAgICAgIH1cclxuICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIC8vIHNjaGVkdWxlIGFkZGluZyBmZWF0dXJlcyB1bnRpbCB0aGUgbmV4dCBhbmltYXRpb24gZnJhbWVcclxuICAgIFV0aWwucmVxdWVzdEFuaW1GcmFtZShcclxuICAgICAgVXRpbC5iaW5kKGZ1bmN0aW9uICgpIHtcclxuICAgICAgICB0aGlzLnJlbW92ZUxheWVycyhsYXllcnNUb1JlbW92ZSk7XHJcbiAgICAgICAgdGhpcy5hZGRMYXllcnMobGF5ZXJzVG9BZGQpO1xyXG4gICAgICB9LCB0aGlzKVxyXG4gICAgKTtcclxuICB9LFxyXG5cclxuICBfZ2V0RmVhdHVyZXNJblRpbWVSYW5nZTogZnVuY3Rpb24gKHN0YXJ0LCBlbmQpIHtcclxuICAgIHZhciBpZHMgPSBbXTtcclxuICAgIHZhciBzZWFyY2g7XHJcblxyXG4gICAgaWYgKHRoaXMub3B0aW9ucy50aW1lRmllbGQuc3RhcnQgJiYgdGhpcy5vcHRpb25zLnRpbWVGaWVsZC5lbmQpIHtcclxuICAgICAgdmFyIHN0YXJ0VGltZXMgPSB0aGlzLl9zdGFydFRpbWVJbmRleC5iZXR3ZWVuKHN0YXJ0LCBlbmQpO1xyXG4gICAgICB2YXIgZW5kVGltZXMgPSB0aGlzLl9lbmRUaW1lSW5kZXguYmV0d2VlbihzdGFydCwgZW5kKTtcclxuICAgICAgc2VhcmNoID0gc3RhcnRUaW1lcy5jb25jYXQoZW5kVGltZXMpO1xyXG4gICAgfSBlbHNlIGlmICh0aGlzLl90aW1lSW5kZXgpIHtcclxuICAgICAgc2VhcmNoID0gdGhpcy5fdGltZUluZGV4LmJldHdlZW4oc3RhcnQsIGVuZCk7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICB3YXJuKFxyXG4gICAgICAgICdZb3UgbXVzdCBzZXQgdGltZUZpZWxkIGluIHRoZSBsYXllciBjb25zdHJ1Y3RvciBpbiBvcmRlciB0byBtYW5pcHVsYXRlIHRoZSBzdGFydCBhbmQgZW5kIHRpbWUgZmlsdGVyLidcclxuICAgICAgKTtcclxuICAgICAgcmV0dXJuIFtdO1xyXG4gICAgfVxyXG5cclxuICAgIGZvciAodmFyIGkgPSBzZWFyY2gubGVuZ3RoIC0gMTsgaSA+PSAwOyBpLS0pIHtcclxuICAgICAgaWRzLnB1c2goc2VhcmNoW2ldLmlkKTtcclxuICAgIH1cclxuXHJcbiAgICByZXR1cm4gaWRzO1xyXG4gIH0sXHJcblxyXG4gIF9idWlsZFRpbWVJbmRleGVzOiBmdW5jdGlvbiAoZ2VvanNvbikge1xyXG4gICAgdmFyIGk7XHJcbiAgICB2YXIgZmVhdHVyZTtcclxuICAgIGlmICh0aGlzLm9wdGlvbnMudGltZUZpZWxkLnN0YXJ0ICYmIHRoaXMub3B0aW9ucy50aW1lRmllbGQuZW5kKSB7XHJcbiAgICAgIHZhciBzdGFydFRpbWVFbnRyaWVzID0gW107XHJcbiAgICAgIHZhciBlbmRUaW1lRW50cmllcyA9IFtdO1xyXG4gICAgICBmb3IgKGkgPSBnZW9qc29uLmxlbmd0aCAtIDE7IGkgPj0gMDsgaS0tKSB7XHJcbiAgICAgICAgZmVhdHVyZSA9IGdlb2pzb25baV07XHJcbiAgICAgICAgc3RhcnRUaW1lRW50cmllcy5wdXNoKHtcclxuICAgICAgICAgIGlkOiBmZWF0dXJlLmlkLFxyXG4gICAgICAgICAgdmFsdWU6IG5ldyBEYXRlKGZlYXR1cmUucHJvcGVydGllc1t0aGlzLm9wdGlvbnMudGltZUZpZWxkLnN0YXJ0XSlcclxuICAgICAgICB9KTtcclxuICAgICAgICBlbmRUaW1lRW50cmllcy5wdXNoKHtcclxuICAgICAgICAgIGlkOiBmZWF0dXJlLmlkLFxyXG4gICAgICAgICAgdmFsdWU6IG5ldyBEYXRlKGZlYXR1cmUucHJvcGVydGllc1t0aGlzLm9wdGlvbnMudGltZUZpZWxkLmVuZF0pXHJcbiAgICAgICAgfSk7XHJcbiAgICAgIH1cclxuICAgICAgdGhpcy5fc3RhcnRUaW1lSW5kZXguYnVsa0FkZChzdGFydFRpbWVFbnRyaWVzKTtcclxuICAgICAgdGhpcy5fZW5kVGltZUluZGV4LmJ1bGtBZGQoZW5kVGltZUVudHJpZXMpO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgdmFyIHRpbWVFbnRyaWVzID0gW107XHJcbiAgICAgIGZvciAoaSA9IGdlb2pzb24ubGVuZ3RoIC0gMTsgaSA+PSAwOyBpLS0pIHtcclxuICAgICAgICBmZWF0dXJlID0gZ2VvanNvbltpXTtcclxuICAgICAgICB0aW1lRW50cmllcy5wdXNoKHtcclxuICAgICAgICAgIGlkOiBmZWF0dXJlLmlkLFxyXG4gICAgICAgICAgdmFsdWU6IG5ldyBEYXRlKGZlYXR1cmUucHJvcGVydGllc1t0aGlzLm9wdGlvbnMudGltZUZpZWxkXSlcclxuICAgICAgICB9KTtcclxuICAgICAgfVxyXG5cclxuICAgICAgdGhpcy5fdGltZUluZGV4LmJ1bGtBZGQodGltZUVudHJpZXMpO1xyXG4gICAgfVxyXG4gIH0sXHJcblxyXG4gIF9mZWF0dXJlV2l0aGluVGltZVJhbmdlOiBmdW5jdGlvbiAoZmVhdHVyZSkge1xyXG4gICAgaWYgKCF0aGlzLm9wdGlvbnMuZnJvbSB8fCAhdGhpcy5vcHRpb25zLnRvKSB7XHJcbiAgICAgIHJldHVybiB0cnVlO1xyXG4gICAgfVxyXG5cclxuICAgIHZhciBmcm9tID0gK3RoaXMub3B0aW9ucy5mcm9tLnZhbHVlT2YoKTtcclxuICAgIHZhciB0byA9ICt0aGlzLm9wdGlvbnMudG8udmFsdWVPZigpO1xyXG5cclxuICAgIGlmICh0eXBlb2YgdGhpcy5vcHRpb25zLnRpbWVGaWVsZCA9PT0gJ3N0cmluZycpIHtcclxuICAgICAgdmFyIGRhdGUgPSArZmVhdHVyZS5wcm9wZXJ0aWVzW3RoaXMub3B0aW9ucy50aW1lRmllbGRdO1xyXG4gICAgICByZXR1cm4gZGF0ZSA+PSBmcm9tICYmIGRhdGUgPD0gdG87XHJcbiAgICB9XHJcblxyXG4gICAgaWYgKHRoaXMub3B0aW9ucy50aW1lRmllbGQuc3RhcnQgJiYgdGhpcy5vcHRpb25zLnRpbWVGaWVsZC5lbmQpIHtcclxuICAgICAgdmFyIHN0YXJ0RGF0ZSA9ICtmZWF0dXJlLnByb3BlcnRpZXNbdGhpcy5vcHRpb25zLnRpbWVGaWVsZC5zdGFydF07XHJcbiAgICAgIHZhciBlbmREYXRlID0gK2ZlYXR1cmUucHJvcGVydGllc1t0aGlzLm9wdGlvbnMudGltZUZpZWxkLmVuZF07XHJcbiAgICAgIHJldHVybiAoXHJcbiAgICAgICAgKHN0YXJ0RGF0ZSA+PSBmcm9tICYmIHN0YXJ0RGF0ZSA8PSB0bykgfHxcclxuICAgICAgICAoZW5kRGF0ZSA+PSBmcm9tICYmIGVuZERhdGUgPD0gdG8pIHx8XHJcbiAgICAgICAgKHN0YXJ0RGF0ZSA8PSBmcm9tICYmIGVuZERhdGUgPj0gdG8pXHJcbiAgICAgICk7XHJcbiAgICB9XHJcbiAgfSxcclxuXHJcbiAgX3Zpc2libGVab29tOiBmdW5jdGlvbiAoKSB7XHJcbiAgICAvLyBjaGVjayB0byBzZWUgd2hldGhlciB0aGUgY3VycmVudCB6b29tIGxldmVsIG9mIHRoZSBtYXAgaXMgd2l0aGluIHRoZSBvcHRpb25hbCBsaW1pdCBkZWZpbmVkIGZvciB0aGUgRmVhdHVyZUxheWVyXHJcbiAgICBpZiAoIXRoaXMuX21hcCkge1xyXG4gICAgICByZXR1cm4gZmFsc2U7XHJcbiAgICB9XHJcbiAgICB2YXIgem9vbSA9IHRoaXMuX21hcC5nZXRab29tKCk7XHJcbiAgICBpZiAoem9vbSA+IHRoaXMub3B0aW9ucy5tYXhab29tIHx8IHpvb20gPCB0aGlzLm9wdGlvbnMubWluWm9vbSkge1xyXG4gICAgICByZXR1cm4gZmFsc2U7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICByZXR1cm4gdHJ1ZTtcclxuICAgIH1cclxuICB9LFxyXG5cclxuICBfaGFuZGxlWm9vbUNoYW5nZTogZnVuY3Rpb24gKCkge1xyXG4gICAgaWYgKCF0aGlzLl92aXNpYmxlWm9vbSgpKSB7XHJcbiAgICAgIC8vIGlmIHdlIGhhdmUgbW92ZWQgb3V0c2lkZSB0aGUgdmlzaWJsZSB6b29tIHJhbmdlIGNsZWFyIHRoZSBjdXJyZW50IHNuYXBzaG90LCBubyBsYXllcnMgc2hvdWxkIGJlIGFjdGl2ZVxyXG4gICAgICB0aGlzLnJlbW92ZUxheWVycyh0aGlzLl9jdXJyZW50U25hcHNob3QpO1xyXG4gICAgICB0aGlzLl9jdXJyZW50U25hcHNob3QgPSBbXTtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIC8qXHJcbiAgICAgIGZvciBldmVyeSBjZWxsIGluIHRoaXMuX2NlbGxzXHJcbiAgICAgICAgMS4gR2V0IHRoZSBjYWNoZSBrZXkgZm9yIHRoZSBjb29yZHMgb2YgdGhlIGNlbGxcclxuICAgICAgICAyLiBJZiB0aGlzLl9jYWNoZVtrZXldIGV4aXN0cyBpdCB3aWxsIGJlIGFuIGFycmF5IG9mIGZlYXR1cmUgSURzLlxyXG4gICAgICAgIDMuIENhbGwgdGhpcy5hZGRMYXllcnModGhpcy5fY2FjaGVba2V5XSkgdG8gaW5zdHJ1Y3QgdGhlIGZlYXR1cmUgbGF5ZXIgdG8gYWRkIHRoZSBsYXllcnMgYmFjay5cclxuICAgICAgKi9cclxuICAgICAgZm9yICh2YXIgaSBpbiB0aGlzLl9jZWxscykge1xyXG4gICAgICAgIHZhciBjb29yZHMgPSB0aGlzLl9jZWxsc1tpXS5jb29yZHM7XHJcbiAgICAgICAgdmFyIGtleSA9IHRoaXMuX2NhY2hlS2V5KGNvb3Jkcyk7XHJcbiAgICAgICAgaWYgKHRoaXMuX2NhY2hlW2tleV0pIHtcclxuICAgICAgICAgIHRoaXMuYWRkTGF5ZXJzKHRoaXMuX2NhY2hlW2tleV0pO1xyXG4gICAgICAgIH1cclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH0sXHJcblxyXG4gIC8qKlxyXG4gICAqIFNlcnZpY2UgTWV0aG9kc1xyXG4gICAqL1xyXG5cclxuICBhdXRoZW50aWNhdGU6IGZ1bmN0aW9uICh0b2tlbikge1xyXG4gICAgdGhpcy5zZXJ2aWNlLmF1dGhlbnRpY2F0ZSh0b2tlbik7XHJcbiAgICByZXR1cm4gdGhpcztcclxuICB9LFxyXG5cclxuICBtZXRhZGF0YTogZnVuY3Rpb24gKGNhbGxiYWNrLCBjb250ZXh0KSB7XHJcbiAgICB0aGlzLnNlcnZpY2UubWV0YWRhdGEoY2FsbGJhY2ssIGNvbnRleHQpO1xyXG4gICAgcmV0dXJuIHRoaXM7XHJcbiAgfSxcclxuXHJcbiAgcXVlcnk6IGZ1bmN0aW9uICgpIHtcclxuICAgIHJldHVybiB0aGlzLnNlcnZpY2UucXVlcnkoKTtcclxuICB9LFxyXG5cclxuICBfZ2V0TWV0YWRhdGE6IGZ1bmN0aW9uIChjYWxsYmFjaykge1xyXG4gICAgaWYgKHRoaXMuX21ldGFkYXRhKSB7XHJcbiAgICAgIHZhciBlcnJvcjtcclxuICAgICAgY2FsbGJhY2soZXJyb3IsIHRoaXMuX21ldGFkYXRhKTtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHRoaXMubWV0YWRhdGEoXHJcbiAgICAgICAgVXRpbC5iaW5kKGZ1bmN0aW9uIChlcnJvciwgcmVzcG9uc2UpIHtcclxuICAgICAgICAgIHRoaXMuX21ldGFkYXRhID0gcmVzcG9uc2U7XHJcbiAgICAgICAgICBjYWxsYmFjayhlcnJvciwgdGhpcy5fbWV0YWRhdGEpO1xyXG4gICAgICAgIH0sIHRoaXMpXHJcbiAgICAgICk7XHJcbiAgICB9XHJcbiAgfSxcclxuXHJcbiAgYWRkRmVhdHVyZTogZnVuY3Rpb24gKGZlYXR1cmUsIGNhbGxiYWNrLCBjb250ZXh0KSB7XHJcbiAgICB0aGlzLmFkZEZlYXR1cmVzKGZlYXR1cmUsIGNhbGxiYWNrLCBjb250ZXh0KTtcclxuICB9LFxyXG5cclxuICBhZGRGZWF0dXJlczogZnVuY3Rpb24gKGZlYXR1cmVzLCBjYWxsYmFjaywgY29udGV4dCkge1xyXG4gICAgdGhpcy5fZ2V0TWV0YWRhdGEoXHJcbiAgICAgIFV0aWwuYmluZChmdW5jdGlvbiAoZXJyb3IsIG1ldGFkYXRhKSB7XHJcbiAgICAgICAgaWYgKGVycm9yKSB7XHJcbiAgICAgICAgICBpZiAoY2FsbGJhY2spIHtcclxuICAgICAgICAgICAgY2FsbGJhY2suY2FsbCh0aGlzLCBlcnJvciwgbnVsbCk7XHJcbiAgICAgICAgICB9XHJcbiAgICAgICAgICByZXR1cm47XHJcbiAgICAgICAgfVxyXG4gICAgICAgIC8vIEdlb0pTT04gZmVhdHVyZUNvbGxlY3Rpb24gb3Igc2ltcGxlIGZlYXR1cmVcclxuICAgICAgICB2YXIgZmVhdHVyZXNBcnJheSA9IGZlYXR1cmVzLmZlYXR1cmVzID8gZmVhdHVyZXMuZmVhdHVyZXMgOiBbZmVhdHVyZXNdO1xyXG5cclxuICAgICAgICB0aGlzLnNlcnZpY2UuYWRkRmVhdHVyZXMoXHJcbiAgICAgICAgICBmZWF0dXJlcyxcclxuICAgICAgICAgIFV0aWwuYmluZChmdW5jdGlvbiAoZXJyb3IsIHJlc3BvbnNlKSB7XHJcbiAgICAgICAgICAgIGlmICghZXJyb3IpIHtcclxuICAgICAgICAgICAgICBmb3IgKHZhciBpID0gZmVhdHVyZXNBcnJheS5sZW5ndGggLSAxOyBpID49IDA7IGktLSkge1xyXG4gICAgICAgICAgICAgICAgLy8gYXNzaWduIElEIGZyb20gcmVzdWx0IHRvIGFwcHJvcHJpYXRlIG9iamVjdGlkIGZpZWxkIGZyb20gc2VydmljZSBtZXRhZGF0YVxyXG4gICAgICAgICAgICAgICAgZmVhdHVyZXNBcnJheVtpXS5wcm9wZXJ0aWVzW21ldGFkYXRhLm9iamVjdElkRmllbGRdID1cclxuICAgICAgICAgICAgICAgICAgZmVhdHVyZXNBcnJheS5sZW5ndGggPiAxXHJcbiAgICAgICAgICAgICAgICAgICAgPyByZXNwb25zZVtpXS5vYmplY3RJZFxyXG4gICAgICAgICAgICAgICAgICAgIDogcmVzcG9uc2Uub2JqZWN0SWQ7XHJcbiAgICAgICAgICAgICAgICAvLyB3ZSBhbHNvIG5lZWQgdG8gdXBkYXRlIHRoZSBnZW9qc29uIGlkIGZvciBjcmVhdGVMYXllcnMoKSB0byBmdW5jdGlvblxyXG4gICAgICAgICAgICAgICAgZmVhdHVyZXNBcnJheVtpXS5pZCA9XHJcbiAgICAgICAgICAgICAgICAgIGZlYXR1cmVzQXJyYXkubGVuZ3RoID4gMVxyXG4gICAgICAgICAgICAgICAgICAgID8gcmVzcG9uc2VbaV0ub2JqZWN0SWRcclxuICAgICAgICAgICAgICAgICAgICA6IHJlc3BvbnNlLm9iamVjdElkO1xyXG4gICAgICAgICAgICAgIH1cclxuICAgICAgICAgICAgICB0aGlzLl9hZGRGZWF0dXJlcyhmZWF0dXJlc0FycmF5KTtcclxuICAgICAgICAgICAgfVxyXG5cclxuICAgICAgICAgICAgaWYgKGNhbGxiYWNrKSB7XHJcbiAgICAgICAgICAgICAgY2FsbGJhY2suY2FsbChjb250ZXh0LCBlcnJvciwgcmVzcG9uc2UpO1xyXG4gICAgICAgICAgICB9XHJcbiAgICAgICAgICB9LCB0aGlzKVxyXG4gICAgICAgICk7XHJcbiAgICAgIH0sIHRoaXMpXHJcbiAgICApO1xyXG4gIH0sXHJcblxyXG4gIHVwZGF0ZUZlYXR1cmU6IGZ1bmN0aW9uIChmZWF0dXJlLCBjYWxsYmFjaywgY29udGV4dCkge1xyXG4gICAgdGhpcy51cGRhdGVGZWF0dXJlcyhmZWF0dXJlLCBjYWxsYmFjaywgY29udGV4dCk7XHJcbiAgfSxcclxuXHJcbiAgdXBkYXRlRmVhdHVyZXM6IGZ1bmN0aW9uIChmZWF0dXJlcywgY2FsbGJhY2ssIGNvbnRleHQpIHtcclxuICAgIC8vIEdlb0pTT04gZmVhdHVyZUNvbGxlY3Rpb24gb3Igc2ltcGxlIGZlYXR1cmVcclxuICAgIHZhciBmZWF0dXJlc0FycmF5ID0gZmVhdHVyZXMuZmVhdHVyZXMgPyBmZWF0dXJlcy5mZWF0dXJlcyA6IFtmZWF0dXJlc107XHJcbiAgICB0aGlzLnNlcnZpY2UudXBkYXRlRmVhdHVyZXMoXHJcbiAgICAgIGZlYXR1cmVzLFxyXG4gICAgICBmdW5jdGlvbiAoZXJyb3IsIHJlc3BvbnNlKSB7XHJcbiAgICAgICAgaWYgKCFlcnJvcikge1xyXG4gICAgICAgICAgZm9yICh2YXIgaSA9IGZlYXR1cmVzQXJyYXkubGVuZ3RoIC0gMTsgaSA+PSAwOyBpLS0pIHtcclxuICAgICAgICAgICAgdGhpcy5yZW1vdmVMYXllcnMoW2ZlYXR1cmVzQXJyYXlbaV0uaWRdLCB0cnVlKTtcclxuICAgICAgICAgIH1cclxuICAgICAgICAgIHRoaXMuX2FkZEZlYXR1cmVzKGZlYXR1cmVzQXJyYXkpO1xyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgaWYgKGNhbGxiYWNrKSB7XHJcbiAgICAgICAgICBjYWxsYmFjay5jYWxsKGNvbnRleHQsIGVycm9yLCByZXNwb25zZSk7XHJcbiAgICAgICAgfVxyXG4gICAgICB9LFxyXG4gICAgICB0aGlzXHJcbiAgICApO1xyXG4gIH0sXHJcblxyXG4gIGRlbGV0ZUZlYXR1cmU6IGZ1bmN0aW9uIChpZCwgY2FsbGJhY2ssIGNvbnRleHQpIHtcclxuICAgIHRoaXMuZGVsZXRlRmVhdHVyZXMoaWQsIGNhbGxiYWNrLCBjb250ZXh0KTtcclxuICB9LFxyXG5cclxuICBkZWxldGVGZWF0dXJlczogZnVuY3Rpb24gKGlkcywgY2FsbGJhY2ssIGNvbnRleHQpIHtcclxuICAgIHJldHVybiB0aGlzLnNlcnZpY2UuZGVsZXRlRmVhdHVyZXMoXHJcbiAgICAgIGlkcyxcclxuICAgICAgZnVuY3Rpb24gKGVycm9yLCByZXNwb25zZSkge1xyXG4gICAgICAgIHZhciByZXNwb25zZUFycmF5ID0gcmVzcG9uc2UubGVuZ3RoID8gcmVzcG9uc2UgOiBbcmVzcG9uc2VdO1xyXG4gICAgICAgIGlmICghZXJyb3IgJiYgcmVzcG9uc2VBcnJheS5sZW5ndGggPiAwKSB7XHJcbiAgICAgICAgICBmb3IgKHZhciBpID0gcmVzcG9uc2VBcnJheS5sZW5ndGggLSAxOyBpID49IDA7IGktLSkge1xyXG4gICAgICAgICAgICB0aGlzLnJlbW92ZUxheWVycyhbcmVzcG9uc2VBcnJheVtpXS5vYmplY3RJZF0sIHRydWUpO1xyXG4gICAgICAgICAgfVxyXG4gICAgICAgIH1cclxuICAgICAgICBpZiAoY2FsbGJhY2spIHtcclxuICAgICAgICAgIGNhbGxiYWNrLmNhbGwoY29udGV4dCwgZXJyb3IsIHJlc3BvbnNlKTtcclxuICAgICAgICB9XHJcbiAgICAgIH0sXHJcbiAgICAgIHRoaXNcclxuICAgICk7XHJcbiAgfVxyXG59KTtcclxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureManager.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/ImageMapLayer.js":
/*!***************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/ImageMapLayer.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ImageMapLayer\": () => (/* binding */ ImageMapLayer),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"imageMapLayer\": () => (/* binding */ imageMapLayer)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _RasterLayer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RasterLayer */ \"./node_modules/esri-leaflet/src/Layers/RasterLayer.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _Services_ImageService__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Services/ImageService */ \"./node_modules/esri-leaflet/src/Services/ImageService.js\");\n\r\n\r\n\r\n\r\n\r\nvar ImageMapLayer = _RasterLayer__WEBPACK_IMPORTED_MODULE_1__.RasterLayer.extend({\r\n\r\n  options: {\r\n    updateInterval: 150,\r\n    format: 'jpgpng',\r\n    transparent: true,\r\n    f: 'image'\r\n  },\r\n\r\n  query: function () {\r\n    return this.service.query();\r\n  },\r\n\r\n  identify: function () {\r\n    return this.service.identify();\r\n  },\r\n\r\n  initialize: function (options) {\r\n    options = (0,_Util__WEBPACK_IMPORTED_MODULE_2__.getUrlParams)(options);\r\n    this.service = (0,_Services_ImageService__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(options);\r\n    this.service.addEventParent(this);\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.setOptions(this, options);\r\n  },\r\n\r\n  setPixelType: function (pixelType) {\r\n    this.options.pixelType = pixelType;\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  getPixelType: function () {\r\n    return this.options.pixelType;\r\n  },\r\n\r\n  setBandIds: function (bandIds) {\r\n    if (leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.isArray(bandIds)) {\r\n      this.options.bandIds = bandIds.join(',');\r\n    } else {\r\n      this.options.bandIds = bandIds.toString();\r\n    }\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  getBandIds: function () {\r\n    return this.options.bandIds;\r\n  },\r\n\r\n  setNoData: function (noData, noDataInterpretation) {\r\n    if (leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.isArray(noData)) {\r\n      this.options.noData = noData.join(',');\r\n    } else {\r\n      this.options.noData = noData.toString();\r\n    }\r\n    if (noDataInterpretation) {\r\n      this.options.noDataInterpretation = noDataInterpretation;\r\n    }\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  getNoData: function () {\r\n    return this.options.noData;\r\n  },\r\n\r\n  getNoDataInterpretation: function () {\r\n    return this.options.noDataInterpretation;\r\n  },\r\n\r\n  setRenderingRule: function (renderingRule) {\r\n    this.options.renderingRule = renderingRule;\r\n    this._update();\r\n  },\r\n\r\n  getRenderingRule: function () {\r\n    return this.options.renderingRule;\r\n  },\r\n\r\n  setMosaicRule: function (mosaicRule) {\r\n    this.options.mosaicRule = mosaicRule;\r\n    this._update();\r\n  },\r\n\r\n  getMosaicRule: function () {\r\n    return this.options.mosaicRule;\r\n  },\r\n\r\n  _getPopupData: function (e) {\r\n    var callback = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function (error, results, response) {\r\n      if (error) { return; } // we really can't do anything here but authenticate or requesterror will fire\r\n      setTimeout(leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function () {\r\n        this._renderPopup(e.latlng, error, results, response);\r\n      }, this), 300);\r\n    }, this);\r\n\r\n    var identifyRequest = this.identify().at(e.latlng);\r\n\r\n    // set mosaic rule for identify task if it is set for layer\r\n    if (this.options.mosaicRule) {\r\n      identifyRequest.setMosaicRule(this.options.mosaicRule);\r\n      // @TODO: force return catalog items too?\r\n    }\r\n\r\n    // @TODO: set rendering rule? Not sure,\r\n    // sometimes you want raw pixel values\r\n    // if (this.options.renderingRule) {\r\n    //   identifyRequest.setRenderingRule(this.options.renderingRule);\r\n    // }\r\n\r\n    identifyRequest.run(callback);\r\n\r\n    // set the flags to show the popup\r\n    this._shouldRenderPopup = true;\r\n    this._lastClick = e.latlng;\r\n  },\r\n\r\n  _buildExportParams: function () {\r\n    var sr = parseInt(this._map.options.crs.code.split(':')[1], 10);\r\n\r\n    var params = {\r\n      bbox: this._calculateBbox(),\r\n      size: this._calculateImageSize(),\r\n      format: this.options.format,\r\n      transparent: this.options.transparent,\r\n      bboxSR: sr,\r\n      imageSR: sr\r\n    };\r\n\r\n    if (this.options.from && this.options.to) {\r\n      params.time = this.options.from.valueOf() + ',' + this.options.to.valueOf();\r\n    }\r\n\r\n    if (this.options.pixelType) {\r\n      params.pixelType = this.options.pixelType;\r\n    }\r\n\r\n    if (this.options.interpolation) {\r\n      params.interpolation = this.options.interpolation;\r\n    }\r\n\r\n    if (this.options.compressionQuality) {\r\n      params.compressionQuality = this.options.compressionQuality;\r\n    }\r\n\r\n    if (this.options.bandIds) {\r\n      params.bandIds = this.options.bandIds;\r\n    }\r\n\r\n    // 0 is falsy *and* a valid input parameter\r\n    if (this.options.noData === 0 || this.options.noData) {\r\n      params.noData = this.options.noData;\r\n    }\r\n\r\n    if (this.options.noDataInterpretation) {\r\n      params.noDataInterpretation = this.options.noDataInterpretation;\r\n    }\r\n\r\n    if (this.service.options.token) {\r\n      params.token = this.service.options.token;\r\n    }\r\n\r\n    if (this.options.renderingRule) {\r\n      params.renderingRule = JSON.stringify(this.options.renderingRule);\r\n    }\r\n\r\n    if (this.options.mosaicRule) {\r\n      params.mosaicRule = JSON.stringify(this.options.mosaicRule);\r\n    }\r\n\r\n    return params;\r\n  },\r\n\r\n  _requestExport: function (params, bounds) {\r\n    if (this.options.f === 'json') {\r\n      this.service.request('exportImage', params, function (error, response) {\r\n        if (error) { return; } // we really can't do anything here but authenticate or requesterror will fire\r\n        if (this.options.token) {\r\n          response.href += ('?token=' + this.options.token);\r\n        }\r\n        if (this.options.proxy) {\r\n          response.href = this.options.proxy + '?' + response.href;\r\n        }\r\n        this._renderImage(response.href, bounds);\r\n      }, this);\r\n    } else {\r\n      params.f = 'image';\r\n      var fullUrl = this.options.url + 'exportImage' + leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.getParamString(params);\r\n      if (this.options.proxy) {\r\n        fullUrl = this.options.proxy + '?' + fullUrl;\r\n      }\r\n      this._renderImage(fullUrl, bounds);\r\n    }\r\n  }\r\n});\r\n\r\nfunction imageMapLayer (url, options) {\r\n  return new ImageMapLayer(url, options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (imageMapLayer);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9MYXllcnMvSW1hZ2VNYXBMYXllci5qcy5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7OztBQUErQjtBQUNhO0FBQ0w7QUFDYTtBQUNwRDtBQUNPLG9CQUFvQiw0REFBa0I7QUFDN0M7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBLGNBQWMsbURBQVk7QUFDMUIsbUJBQW1CLGtFQUFZO0FBQy9CO0FBQ0E7QUFDQSxJQUFJLG9EQUFlO0FBQ25CLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0EsUUFBUSxpREFBWTtBQUNwQjtBQUNBLE1BQU07QUFDTjtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBLFFBQVEsaURBQVk7QUFDcEI7QUFDQSxNQUFNO0FBQ047QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQSxtQkFBbUIsOENBQVM7QUFDNUIsbUJBQW1CLFVBQVU7QUFDN0IsaUJBQWlCLDhDQUFTO0FBQzFCO0FBQ0EsT0FBTztBQUNQLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0EscUJBQXFCLFVBQVU7QUFDL0I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxPQUFPO0FBQ1AsTUFBTTtBQUNOO0FBQ0EsdURBQXVELHdEQUFtQjtBQUMxRTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxDQUFDO0FBQ0Q7QUFDTztBQUNQO0FBQ0E7QUFDQTtBQUNBLGlFQUFlLGFBQWEsRUFBQyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lc3JpLWxlYWZsZXQvc3JjL0xheWVycy9JbWFnZU1hcExheWVyLmpzPzQwNDUiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVXRpbCB9IGZyb20gJ2xlYWZsZXQnO1xyXG5pbXBvcnQgeyBSYXN0ZXJMYXllciB9IGZyb20gJy4vUmFzdGVyTGF5ZXInO1xyXG5pbXBvcnQgeyBnZXRVcmxQYXJhbXMgfSBmcm9tICcuLi9VdGlsJztcclxuaW1wb3J0IGltYWdlU2VydmljZSBmcm9tICcuLi9TZXJ2aWNlcy9JbWFnZVNlcnZpY2UnO1xyXG5cclxuZXhwb3J0IHZhciBJbWFnZU1hcExheWVyID0gUmFzdGVyTGF5ZXIuZXh0ZW5kKHtcclxuXHJcbiAgb3B0aW9uczoge1xyXG4gICAgdXBkYXRlSW50ZXJ2YWw6IDE1MCxcclxuICAgIGZvcm1hdDogJ2pwZ3BuZycsXHJcbiAgICB0cmFuc3BhcmVudDogdHJ1ZSxcclxuICAgIGY6ICdpbWFnZSdcclxuICB9LFxyXG5cclxuICBxdWVyeTogZnVuY3Rpb24gKCkge1xyXG4gICAgcmV0dXJuIHRoaXMuc2VydmljZS5xdWVyeSgpO1xyXG4gIH0sXHJcblxyXG4gIGlkZW50aWZ5OiBmdW5jdGlvbiAoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5zZXJ2aWNlLmlkZW50aWZ5KCk7XHJcbiAgfSxcclxuXHJcbiAgaW5pdGlhbGl6ZTogZnVuY3Rpb24gKG9wdGlvbnMpIHtcclxuICAgIG9wdGlvbnMgPSBnZXRVcmxQYXJhbXMob3B0aW9ucyk7XHJcbiAgICB0aGlzLnNlcnZpY2UgPSBpbWFnZVNlcnZpY2Uob3B0aW9ucyk7XHJcbiAgICB0aGlzLnNlcnZpY2UuYWRkRXZlbnRQYXJlbnQodGhpcyk7XHJcblxyXG4gICAgVXRpbC5zZXRPcHRpb25zKHRoaXMsIG9wdGlvbnMpO1xyXG4gIH0sXHJcblxyXG4gIHNldFBpeGVsVHlwZTogZnVuY3Rpb24gKHBpeGVsVHlwZSkge1xyXG4gICAgdGhpcy5vcHRpb25zLnBpeGVsVHlwZSA9IHBpeGVsVHlwZTtcclxuICAgIHRoaXMuX3VwZGF0ZSgpO1xyXG4gICAgcmV0dXJuIHRoaXM7XHJcbiAgfSxcclxuXHJcbiAgZ2V0UGl4ZWxUeXBlOiBmdW5jdGlvbiAoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5vcHRpb25zLnBpeGVsVHlwZTtcclxuICB9LFxyXG5cclxuICBzZXRCYW5kSWRzOiBmdW5jdGlvbiAoYmFuZElkcykge1xyXG4gICAgaWYgKFV0aWwuaXNBcnJheShiYW5kSWRzKSkge1xyXG4gICAgICB0aGlzLm9wdGlvbnMuYmFuZElkcyA9IGJhbmRJZHMuam9pbignLCcpO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgdGhpcy5vcHRpb25zLmJhbmRJZHMgPSBiYW5kSWRzLnRvU3RyaW5nKCk7XHJcbiAgICB9XHJcbiAgICB0aGlzLl91cGRhdGUoKTtcclxuICAgIHJldHVybiB0aGlzO1xyXG4gIH0sXHJcblxyXG4gIGdldEJhbmRJZHM6IGZ1bmN0aW9uICgpIHtcclxuICAgIHJldHVybiB0aGlzLm9wdGlvbnMuYmFuZElkcztcclxuICB9LFxyXG5cclxuICBzZXROb0RhdGE6IGZ1bmN0aW9uIChub0RhdGEsIG5vRGF0YUludGVycHJldGF0aW9uKSB7XHJcbiAgICBpZiAoVXRpbC5pc0FycmF5KG5vRGF0YSkpIHtcclxuICAgICAgdGhpcy5vcHRpb25zLm5vRGF0YSA9IG5vRGF0YS5qb2luKCcsJyk7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICB0aGlzLm9wdGlvbnMubm9EYXRhID0gbm9EYXRhLnRvU3RyaW5nKCk7XHJcbiAgICB9XHJcbiAgICBpZiAobm9EYXRhSW50ZXJwcmV0YXRpb24pIHtcclxuICAgICAgdGhpcy5vcHRpb25zLm5vRGF0YUludGVycHJldGF0aW9uID0gbm9EYXRhSW50ZXJwcmV0YXRpb247XHJcbiAgICB9XHJcbiAgICB0aGlzLl91cGRhdGUoKTtcclxuICAgIHJldHVybiB0aGlzO1xyXG4gIH0sXHJcblxyXG4gIGdldE5vRGF0YTogZnVuY3Rpb24gKCkge1xyXG4gICAgcmV0dXJuIHRoaXMub3B0aW9ucy5ub0RhdGE7XHJcbiAgfSxcclxuXHJcbiAgZ2V0Tm9EYXRhSW50ZXJwcmV0YXRpb246IGZ1bmN0aW9uICgpIHtcclxuICAgIHJldHVybiB0aGlzLm9wdGlvbnMubm9EYXRhSW50ZXJwcmV0YXRpb247XHJcbiAgfSxcclxuXHJcbiAgc2V0UmVuZGVyaW5nUnVsZTogZnVuY3Rpb24gKHJlbmRlcmluZ1J1bGUpIHtcclxuICAgIHRoaXMub3B0aW9ucy5yZW5kZXJpbmdSdWxlID0gcmVuZGVyaW5nUnVsZTtcclxuICAgIHRoaXMuX3VwZGF0ZSgpO1xyXG4gIH0sXHJcblxyXG4gIGdldFJlbmRlcmluZ1J1bGU6IGZ1bmN0aW9uICgpIHtcclxuICAgIHJldHVybiB0aGlzLm9wdGlvbnMucmVuZGVyaW5nUnVsZTtcclxuICB9LFxyXG5cclxuICBzZXRNb3NhaWNSdWxlOiBmdW5jdGlvbiAobW9zYWljUnVsZSkge1xyXG4gICAgdGhpcy5vcHRpb25zLm1vc2FpY1J1bGUgPSBtb3NhaWNSdWxlO1xyXG4gICAgdGhpcy5fdXBkYXRlKCk7XHJcbiAgfSxcclxuXHJcbiAgZ2V0TW9zYWljUnVsZTogZnVuY3Rpb24gKCkge1xyXG4gICAgcmV0dXJuIHRoaXMub3B0aW9ucy5tb3NhaWNSdWxlO1xyXG4gIH0sXHJcblxyXG4gIF9nZXRQb3B1cERhdGE6IGZ1bmN0aW9uIChlKSB7XHJcbiAgICB2YXIgY2FsbGJhY2sgPSBVdGlsLmJpbmQoZnVuY3Rpb24gKGVycm9yLCByZXN1bHRzLCByZXNwb25zZSkge1xyXG4gICAgICBpZiAoZXJyb3IpIHsgcmV0dXJuOyB9IC8vIHdlIHJlYWxseSBjYW4ndCBkbyBhbnl0aGluZyBoZXJlIGJ1dCBhdXRoZW50aWNhdGUgb3IgcmVxdWVzdGVycm9yIHdpbGwgZmlyZVxyXG4gICAgICBzZXRUaW1lb3V0KFV0aWwuYmluZChmdW5jdGlvbiAoKSB7XHJcbiAgICAgICAgdGhpcy5fcmVuZGVyUG9wdXAoZS5sYXRsbmcsIGVycm9yLCByZXN1bHRzLCByZXNwb25zZSk7XHJcbiAgICAgIH0sIHRoaXMpLCAzMDApO1xyXG4gICAgfSwgdGhpcyk7XHJcblxyXG4gICAgdmFyIGlkZW50aWZ5UmVxdWVzdCA9IHRoaXMuaWRlbnRpZnkoKS5hdChlLmxhdGxuZyk7XHJcblxyXG4gICAgLy8gc2V0IG1vc2FpYyBydWxlIGZvciBpZGVudGlmeSB0YXNrIGlmIGl0IGlzIHNldCBmb3IgbGF5ZXJcclxuICAgIGlmICh0aGlzLm9wdGlvbnMubW9zYWljUnVsZSkge1xyXG4gICAgICBpZGVudGlmeVJlcXVlc3Quc2V0TW9zYWljUnVsZSh0aGlzLm9wdGlvbnMubW9zYWljUnVsZSk7XHJcbiAgICAgIC8vIEBUT0RPOiBmb3JjZSByZXR1cm4gY2F0YWxvZyBpdGVtcyB0b28/XHJcbiAgICB9XHJcblxyXG4gICAgLy8gQFRPRE86IHNldCByZW5kZXJpbmcgcnVsZT8gTm90IHN1cmUsXHJcbiAgICAvLyBzb21ldGltZXMgeW91IHdhbnQgcmF3IHBpeGVsIHZhbHVlc1xyXG4gICAgLy8gaWYgKHRoaXMub3B0aW9ucy5yZW5kZXJpbmdSdWxlKSB7XHJcbiAgICAvLyAgIGlkZW50aWZ5UmVxdWVzdC5zZXRSZW5kZXJpbmdSdWxlKHRoaXMub3B0aW9ucy5yZW5kZXJpbmdSdWxlKTtcclxuICAgIC8vIH1cclxuXHJcbiAgICBpZGVudGlmeVJlcXVlc3QucnVuKGNhbGxiYWNrKTtcclxuXHJcbiAgICAvLyBzZXQgdGhlIGZsYWdzIHRvIHNob3cgdGhlIHBvcHVwXHJcbiAgICB0aGlzLl9zaG91bGRSZW5kZXJQb3B1cCA9IHRydWU7XHJcbiAgICB0aGlzLl9sYXN0Q2xpY2sgPSBlLmxhdGxuZztcclxuICB9LFxyXG5cclxuICBfYnVpbGRFeHBvcnRQYXJhbXM6IGZ1bmN0aW9uICgpIHtcclxuICAgIHZhciBzciA9IHBhcnNlSW50KHRoaXMuX21hcC5vcHRpb25zLmNycy5jb2RlLnNwbGl0KCc6JylbMV0sIDEwKTtcclxuXHJcbiAgICB2YXIgcGFyYW1zID0ge1xyXG4gICAgICBiYm94OiB0aGlzLl9jYWxjdWxhdGVCYm94KCksXHJcbiAgICAgIHNpemU6IHRoaXMuX2NhbGN1bGF0ZUltYWdlU2l6ZSgpLFxyXG4gICAgICBmb3JtYXQ6IHRoaXMub3B0aW9ucy5mb3JtYXQsXHJcbiAgICAgIHRyYW5zcGFyZW50OiB0aGlzLm9wdGlvbnMudHJhbnNwYXJlbnQsXHJcbiAgICAgIGJib3hTUjogc3IsXHJcbiAgICAgIGltYWdlU1I6IHNyXHJcbiAgICB9O1xyXG5cclxuICAgIGlmICh0aGlzLm9wdGlvbnMuZnJvbSAmJiB0aGlzLm9wdGlvbnMudG8pIHtcclxuICAgICAgcGFyYW1zLnRpbWUgPSB0aGlzLm9wdGlvbnMuZnJvbS52YWx1ZU9mKCkgKyAnLCcgKyB0aGlzLm9wdGlvbnMudG8udmFsdWVPZigpO1xyXG4gICAgfVxyXG5cclxuICAgIGlmICh0aGlzLm9wdGlvbnMucGl4ZWxUeXBlKSB7XHJcbiAgICAgIHBhcmFtcy5waXhlbFR5cGUgPSB0aGlzLm9wdGlvbnMucGl4ZWxUeXBlO1xyXG4gICAgfVxyXG5cclxuICAgIGlmICh0aGlzLm9wdGlvbnMuaW50ZXJwb2xhdGlvbikge1xyXG4gICAgICBwYXJhbXMuaW50ZXJwb2xhdGlvbiA9IHRoaXMub3B0aW9ucy5pbnRlcnBvbGF0aW9uO1xyXG4gICAgfVxyXG5cclxuICAgIGlmICh0aGlzLm9wdGlvbnMuY29tcHJlc3Npb25RdWFsaXR5KSB7XHJcbiAgICAgIHBhcmFtcy5jb21wcmVzc2lvblF1YWxpdHkgPSB0aGlzLm9wdGlvbnMuY29tcHJlc3Npb25RdWFsaXR5O1xyXG4gICAgfVxyXG5cclxuICAgIGlmICh0aGlzLm9wdGlvbnMuYmFuZElkcykge1xyXG4gICAgICBwYXJhbXMuYmFuZElkcyA9IHRoaXMub3B0aW9ucy5iYW5kSWRzO1xyXG4gICAgfVxyXG5cclxuICAgIC8vIDAgaXMgZmFsc3kgKmFuZCogYSB2YWxpZCBpbnB1dCBwYXJhbWV0ZXJcclxuICAgIGlmICh0aGlzLm9wdGlvbnMubm9EYXRhID09PSAwIHx8IHRoaXMub3B0aW9ucy5ub0RhdGEpIHtcclxuICAgICAgcGFyYW1zLm5vRGF0YSA9IHRoaXMub3B0aW9ucy5ub0RhdGE7XHJcbiAgICB9XHJcblxyXG4gICAgaWYgKHRoaXMub3B0aW9ucy5ub0RhdGFJbnRlcnByZXRhdGlvbikge1xyXG4gICAgICBwYXJhbXMubm9EYXRhSW50ZXJwcmV0YXRpb24gPSB0aGlzLm9wdGlvbnMubm9EYXRhSW50ZXJwcmV0YXRpb247XHJcbiAgICB9XHJcblxyXG4gICAgaWYgKHRoaXMuc2VydmljZS5vcHRpb25zLnRva2VuKSB7XHJcbiAgICAgIHBhcmFtcy50b2tlbiA9IHRoaXMuc2VydmljZS5vcHRpb25zLnRva2VuO1xyXG4gICAgfVxyXG5cclxuICAgIGlmICh0aGlzLm9wdGlvbnMucmVuZGVyaW5nUnVsZSkge1xyXG4gICAgICBwYXJhbXMucmVuZGVyaW5nUnVsZSA9IEpTT04uc3RyaW5naWZ5KHRoaXMub3B0aW9ucy5yZW5kZXJpbmdSdWxlKTtcclxuICAgIH1cclxuXHJcbiAgICBpZiAodGhpcy5vcHRpb25zLm1vc2FpY1J1bGUpIHtcclxuICAgICAgcGFyYW1zLm1vc2FpY1J1bGUgPSBKU09OLnN0cmluZ2lmeSh0aGlzLm9wdGlvbnMubW9zYWljUnVsZSk7XHJcbiAgICB9XHJcblxyXG4gICAgcmV0dXJuIHBhcmFtcztcclxuICB9LFxyXG5cclxuICBfcmVxdWVzdEV4cG9ydDogZnVuY3Rpb24gKHBhcmFtcywgYm91bmRzKSB7XHJcbiAgICBpZiAodGhpcy5vcHRpb25zLmYgPT09ICdqc29uJykge1xyXG4gICAgICB0aGlzLnNlcnZpY2UucmVxdWVzdCgnZXhwb3J0SW1hZ2UnLCBwYXJhbXMsIGZ1bmN0aW9uIChlcnJvciwgcmVzcG9uc2UpIHtcclxuICAgICAgICBpZiAoZXJyb3IpIHsgcmV0dXJuOyB9IC8vIHdlIHJlYWxseSBjYW4ndCBkbyBhbnl0aGluZyBoZXJlIGJ1dCBhdXRoZW50aWNhdGUgb3IgcmVxdWVzdGVycm9yIHdpbGwgZmlyZVxyXG4gICAgICAgIGlmICh0aGlzLm9wdGlvbnMudG9rZW4pIHtcclxuICAgICAgICAgIHJlc3BvbnNlLmhyZWYgKz0gKCc/dG9rZW49JyArIHRoaXMub3B0aW9ucy50b2tlbik7XHJcbiAgICAgICAgfVxyXG4gICAgICAgIGlmICh0aGlzLm9wdGlvbnMucHJveHkpIHtcclxuICAgICAgICAgIHJlc3BvbnNlLmhyZWYgPSB0aGlzLm9wdGlvbnMucHJveHkgKyAnPycgKyByZXNwb25zZS5ocmVmO1xyXG4gICAgICAgIH1cclxuICAgICAgICB0aGlzLl9yZW5kZXJJbWFnZShyZXNwb25zZS5ocmVmLCBib3VuZHMpO1xyXG4gICAgICB9LCB0aGlzKTtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHBhcmFtcy5mID0gJ2ltYWdlJztcclxuICAgICAgdmFyIGZ1bGxVcmwgPSB0aGlzLm9wdGlvbnMudXJsICsgJ2V4cG9ydEltYWdlJyArIFV0aWwuZ2V0UGFyYW1TdHJpbmcocGFyYW1zKTtcclxuICAgICAgaWYgKHRoaXMub3B0aW9ucy5wcm94eSkge1xyXG4gICAgICAgIGZ1bGxVcmwgPSB0aGlzLm9wdGlvbnMucHJveHkgKyAnPycgKyBmdWxsVXJsO1xyXG4gICAgICB9XHJcbiAgICAgIHRoaXMuX3JlbmRlckltYWdlKGZ1bGxVcmwsIGJvdW5kcyk7XHJcbiAgICB9XHJcbiAgfVxyXG59KTtcclxuXHJcbmV4cG9ydCBmdW5jdGlvbiBpbWFnZU1hcExheWVyICh1cmwsIG9wdGlvbnMpIHtcclxuICByZXR1cm4gbmV3IEltYWdlTWFwTGF5ZXIodXJsLCBvcHRpb25zKTtcclxufVxyXG5cclxuZXhwb3J0IGRlZmF1bHQgaW1hZ2VNYXBMYXllcjtcclxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/ImageMapLayer.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/RasterLayer.js":
/*!*************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/RasterLayer.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"RasterLayer\": () => (/* binding */ RasterLayer)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar Overlay = leaflet__WEBPACK_IMPORTED_MODULE_0__.ImageOverlay.extend({\r\n  onAdd: function (map) {\r\n    this._topLeft = map.getPixelBounds().min;\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.ImageOverlay.prototype.onAdd.call(this, map);\r\n  },\r\n  _reset: function () {\r\n    if (this._map.options.crs === leaflet__WEBPACK_IMPORTED_MODULE_0__.CRS.EPSG3857) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__.ImageOverlay.prototype._reset.call(this);\r\n    } else {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__.DomUtil.setPosition(this._image, this._topLeft.subtract(this._map.getPixelOrigin()));\r\n    }\r\n  }\r\n});\r\n\r\nvar RasterLayer = leaflet__WEBPACK_IMPORTED_MODULE_0__.Layer.extend({\r\n  options: {\r\n    opacity: 1,\r\n    position: 'front',\r\n    f: 'image',\r\n    useCors: _Support__WEBPACK_IMPORTED_MODULE_1__.cors,\r\n    attribution: null,\r\n    interactive: false,\r\n    alt: ''\r\n  },\r\n\r\n  onAdd: function (map) {\r\n    // include 'Powered by Esri' in map attribution\r\n    (0,_Util__WEBPACK_IMPORTED_MODULE_2__.setEsriAttribution)(map);\r\n\r\n    if (this.options.zIndex) {\r\n      this.options.position = null;\r\n    }\r\n\r\n    this._update = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.throttle(this._update, this.options.updateInterval, this);\r\n\r\n    map.on('moveend', this._update, this);\r\n\r\n    // if we had an image loaded and it matches the\r\n    // current bounds show the image otherwise remove it\r\n    if (this._currentImage && this._currentImage._bounds.equals(this._map.getBounds())) {\r\n      map.addLayer(this._currentImage);\r\n    } else if (this._currentImage) {\r\n      this._map.removeLayer(this._currentImage);\r\n      this._currentImage = null;\r\n    }\r\n\r\n    this._update();\r\n\r\n    if (this._popup) {\r\n      this._map.on('click', this._getPopupData, this);\r\n      this._map.on('dblclick', this._resetPopupState, this);\r\n    }\r\n\r\n    // add copyright text listed in service metadata\r\n    this.metadata(function (err, metadata) {\r\n      if (!err && !this.options.attribution && map.attributionControl && metadata.copyrightText) {\r\n        this.options.attribution = metadata.copyrightText;\r\n        map.attributionControl.addAttribution(this.getAttribution());\r\n      }\r\n    }, this);\r\n  },\r\n\r\n  onRemove: function (map) {\r\n    (0,_Util__WEBPACK_IMPORTED_MODULE_2__.removeEsriAttribution)(map);\r\n\r\n    if (this._currentImage) {\r\n      this._map.removeLayer(this._currentImage);\r\n    }\r\n\r\n    if (this._popup) {\r\n      this._map.off('click', this._getPopupData, this);\r\n      this._map.off('dblclick', this._resetPopupState, this);\r\n    }\r\n\r\n    this._map.off('moveend', this._update, this);\r\n  },\r\n\r\n  bindPopup: function (fn, popupOptions) {\r\n    this._shouldRenderPopup = false;\r\n    this._lastClick = false;\r\n    this._popup = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.popup)(popupOptions);\r\n    this._popupFunction = fn;\r\n    if (this._map) {\r\n      this._map.on('click', this._getPopupData, this);\r\n      this._map.on('dblclick', this._resetPopupState, this);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  unbindPopup: function () {\r\n    if (this._map) {\r\n      this._map.closePopup(this._popup);\r\n      this._map.off('click', this._getPopupData, this);\r\n      this._map.off('dblclick', this._resetPopupState, this);\r\n    }\r\n    this._popup = false;\r\n    return this;\r\n  },\r\n\r\n  bringToFront: function () {\r\n    this.options.position = 'front';\r\n    if (this._currentImage) {\r\n      this._currentImage.bringToFront();\r\n      this._setAutoZIndex(Math.max);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  bringToBack: function () {\r\n    this.options.position = 'back';\r\n    if (this._currentImage) {\r\n      this._currentImage.bringToBack();\r\n      this._setAutoZIndex(Math.min);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  setZIndex: function (value) {\r\n    this.options.zIndex = value;\r\n    if (this._currentImage) {\r\n      this._currentImage.setZIndex(value);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  _setAutoZIndex: function (compare) {\r\n    // go through all other layers of the same pane, set zIndex to max + 1 (front) or min - 1 (back)\r\n    if (!this._currentImage) {\r\n      return;\r\n    }\r\n    var layers = this._currentImage.getPane().children;\r\n    var edgeZIndex = -compare(-Infinity, Infinity); // -Infinity for max, Infinity for min\r\n    for (var i = 0, len = layers.length, zIndex; i < len; i++) {\r\n      zIndex = layers[i].style.zIndex;\r\n      if (layers[i] !== this._currentImage._image && zIndex) {\r\n        edgeZIndex = compare(edgeZIndex, +zIndex);\r\n      }\r\n    }\r\n\r\n    if (isFinite(edgeZIndex)) {\r\n      this.options.zIndex = edgeZIndex + compare(-1, 1);\r\n      this.setZIndex(this.options.zIndex);\r\n    }\r\n  },\r\n\r\n  getAttribution: function () {\r\n    return this.options.attribution;\r\n  },\r\n\r\n  getOpacity: function () {\r\n    return this.options.opacity;\r\n  },\r\n\r\n  setOpacity: function (opacity) {\r\n    this.options.opacity = opacity;\r\n    if (this._currentImage) {\r\n      this._currentImage.setOpacity(opacity);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  getTimeRange: function () {\r\n    return [this.options.from, this.options.to];\r\n  },\r\n\r\n  setTimeRange: function (from, to) {\r\n    this.options.from = from;\r\n    this.options.to = to;\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  metadata: function (callback, context) {\r\n    this.service.metadata(callback, context);\r\n    return this;\r\n  },\r\n\r\n  authenticate: function (token) {\r\n    this.service.authenticate(token);\r\n    return this;\r\n  },\r\n\r\n  redraw: function () {\r\n    this._update();\r\n  },\r\n\r\n  _renderImage: function (url, bounds, contentType) {\r\n    if (this._map) {\r\n      // if no output directory has been specified for a service, MIME data will be returned\r\n      if (contentType) {\r\n        url = 'data:' + contentType + ';base64,' + url;\r\n      }\r\n\r\n      // if server returns an inappropriate response, abort.\r\n      if (!url) return;\r\n\r\n      // create a new image overlay and add it to the map\r\n      // to start loading the image\r\n      // opacity is 0 while the image is loading\r\n      var image = new Overlay(url, bounds, {\r\n        opacity: 0,\r\n        crossOrigin: this.options.withCredentials ? 'use-credentials' : this.options.useCors,\r\n        alt: this.options.alt,\r\n        pane: this.options.pane || this.getPane(),\r\n        interactive: this.options.interactive\r\n      }).addTo(this._map);\r\n\r\n      var onOverlayError = function () {\r\n        this._map.removeLayer(image);\r\n        this.fire('error');\r\n        image.off('load', onOverlayLoad, this);\r\n      };\r\n\r\n      var onOverlayLoad = function (e) {\r\n        image.off('error', onOverlayError, this);\r\n        if (this._map) {\r\n          var newImage = e.target;\r\n          var oldImage = this._currentImage;\r\n\r\n          // if the bounds of this image matches the bounds that\r\n          // _renderImage was called with and we have a map with the same bounds\r\n          // hide the old image if there is one and set the opacity\r\n          // of the new image otherwise remove the new image\r\n          if (newImage._bounds.equals(bounds) && newImage._bounds.equals(this._map.getBounds())) {\r\n            this._currentImage = newImage;\r\n\r\n            if (this.options.position === 'front') {\r\n              this.bringToFront();\r\n            } else if (this.options.position === 'back') {\r\n              this.bringToBack();\r\n            }\r\n\r\n            if (this.options.zIndex) {\r\n              this.setZIndex(this.options.zIndex);\r\n            }\r\n\r\n            if (this._map && this._currentImage._map) {\r\n              this._currentImage.setOpacity(this.options.opacity);\r\n            } else {\r\n              this._currentImage._map.removeLayer(this._currentImage);\r\n            }\r\n\r\n            if (oldImage && this._map) {\r\n              this._map.removeLayer(oldImage);\r\n            }\r\n\r\n            if (oldImage && oldImage._map) {\r\n              oldImage._map.removeLayer(oldImage);\r\n            }\r\n          } else {\r\n            this._map.removeLayer(newImage);\r\n          }\r\n        }\r\n\r\n        this.fire('load', {\r\n          bounds: bounds\r\n        });\r\n      };\r\n\r\n      // If loading the image fails\r\n      image.once('error', onOverlayError, this);\r\n\r\n      // once the image loads\r\n      image.once('load', onOverlayLoad, this);\r\n    }\r\n  },\r\n\r\n  _update: function () {\r\n    if (!this._map) {\r\n      return;\r\n    }\r\n\r\n    var zoom = this._map.getZoom();\r\n    var bounds = this._map.getBounds();\r\n\r\n    if (this._animatingZoom) {\r\n      return;\r\n    }\r\n\r\n    if (this._map._panTransition && this._map._panTransition._inProgress) {\r\n      return;\r\n    }\r\n\r\n    if (zoom > this.options.maxZoom || zoom < this.options.minZoom) {\r\n      if (this._currentImage) {\r\n        this._currentImage._map.removeLayer(this._currentImage);\r\n        this._currentImage = null;\r\n      }\r\n      return;\r\n    }\r\n\r\n    var params = this._buildExportParams();\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.extend(params, this.options.requestParams);\r\n\r\n    if (params) {\r\n      this._requestExport(params, bounds);\r\n\r\n      this.fire('loading', {\r\n        bounds: bounds\r\n      });\r\n    } else if (this._currentImage) {\r\n      this._currentImage._map.removeLayer(this._currentImage);\r\n      this._currentImage = null;\r\n    }\r\n  },\r\n\r\n  _renderPopup: function (latlng, error, results, response) {\r\n    latlng = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLng)(latlng);\r\n    if (this._shouldRenderPopup && this._lastClick.equals(latlng)) {\r\n      // add the popup to the map where the mouse was clicked at\r\n      var content = this._popupFunction(error, results, response);\r\n      if (content) {\r\n        this._popup.setLatLng(latlng).setContent(content).openOn(this._map);\r\n      }\r\n    }\r\n  },\r\n\r\n  _resetPopupState: function (e) {\r\n    this._shouldRenderPopup = false;\r\n    this._lastClick = e.latlng;\r\n  },\r\n\r\n  _calculateBbox: function () {\r\n    var pixelBounds = this._map.getPixelBounds();\r\n\r\n    var sw = this._map.unproject(pixelBounds.getBottomLeft());\r\n    var ne = this._map.unproject(pixelBounds.getTopRight());\r\n\r\n    var neProjected = this._map.options.crs.project(ne);\r\n    var swProjected = this._map.options.crs.project(sw);\r\n\r\n    // this ensures ne/sw are switched in polar maps where north/top bottom/south is inverted\r\n    var boundsProjected = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.bounds)(neProjected, swProjected);\r\n\r\n    return [boundsProjected.getBottomLeft().x, boundsProjected.getBottomLeft().y, boundsProjected.getTopRight().x, boundsProjected.getTopRight().y].join(',');\r\n  },\r\n\r\n  _calculateImageSize: function () {\r\n    // ensure that we don't ask ArcGIS Server for a taller image than we have actual map displaying within the div\r\n    var bounds = this._map.getPixelBounds();\r\n    var size = this._map.getSize();\r\n\r\n    var sw = this._map.unproject(bounds.getBottomLeft());\r\n    var ne = this._map.unproject(bounds.getTopRight());\r\n\r\n    var top = this._map.latLngToLayerPoint(ne).y;\r\n    var bottom = this._map.latLngToLayerPoint(sw).y;\r\n\r\n    if (top > 0 || bottom < size.y) {\r\n      size.y = bottom - top;\r\n    }\r\n\r\n    return size.x + ',' + size.y;\r\n  }\r\n});\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/RasterLayer.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/TiledMapLayer.js":
/*!***************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/TiledMapLayer.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"TiledMapLayer\": () => (/* binding */ TiledMapLayer),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"tiledMapLayer\": () => (/* binding */ tiledMapLayer)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _Services_MapService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Services/MapService */ \"./node_modules/esri-leaflet/src/Services/MapService.js\");\n\r\n\r\n\r\n\r\nvar TiledMapLayer = leaflet__WEBPACK_IMPORTED_MODULE_0__.TileLayer.extend({\r\n  options: {\r\n    zoomOffsetAllowance: 0.1,\r\n    errorTileUrl: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAQAAAAEABAMAAACuXLVVAAAAA1BMVEUzNDVszlHHAAAAAXRSTlMAQObYZgAAAAlwSFlzAAAAAAAAAAAB6mUWpAAAADZJREFUeJztwQEBAAAAgiD/r25IQAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA7waBAAABw08RwAAAAABJRU5ErkJggg=='\r\n  },\r\n\r\n  statics: {\r\n    MercatorZoomLevels: {\r\n      0: 156543.03392799999,\r\n      1: 78271.516963999893,\r\n      2: 39135.758482000099,\r\n      3: 19567.879240999901,\r\n      4: 9783.9396204999593,\r\n      5: 4891.9698102499797,\r\n      6: 2445.9849051249898,\r\n      7: 1222.9924525624899,\r\n      8: 611.49622628138002,\r\n      9: 305.74811314055802,\r\n      10: 152.874056570411,\r\n      11: 76.437028285073197,\r\n      12: 38.218514142536598,\r\n      13: 19.109257071268299,\r\n      14: 9.5546285356341496,\r\n      15: 4.7773142679493699,\r\n      16: 2.38865713397468,\r\n      17: 1.1943285668550501,\r\n      18: 0.59716428355981699,\r\n      19: 0.29858214164761698,\r\n      20: 0.14929107082381,\r\n      21: 0.07464553541191,\r\n      22: 0.0373227677059525,\r\n      23: 0.0186613838529763\r\n    }\r\n  },\r\n\r\n  initialize: function (options) {\r\n    options = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.setOptions(this, options);\r\n\r\n    // set the urls\r\n    options = (0,_Util__WEBPACK_IMPORTED_MODULE_1__.getUrlParams)(options);\r\n    this.tileUrl = (options.proxy ? options.proxy + '?' : '') + options.url + 'tile/{z}/{y}/{x}' + (options.requestParams && Object.keys(options.requestParams).length > 0 ? leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.getParamString(options.requestParams) : '');\r\n    // Remove subdomain in url\r\n    // https://github.com/Esri/esri-leaflet/issues/991\r\n    if (options.url.indexOf('{s}') !== -1 && options.subdomains) {\r\n      options.url = options.url.replace('{s}', options.subdomains[0]);\r\n    }\r\n    this.service = (0,_Services_MapService__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(options);\r\n    this.service.addEventParent(this);\r\n\r\n    var arcgisonline = new RegExp(/tiles.arcgis(online)?\\.com/g);\r\n    if (arcgisonline.test(options.url)) {\r\n      this.tileUrl = this.tileUrl.replace('://tiles', '://tiles{s}');\r\n      options.subdomains = ['1', '2', '3', '4'];\r\n    }\r\n\r\n    if (this.options.token) {\r\n      this.tileUrl += ('?token=' + this.options.token);\r\n    }\r\n\r\n    // init layer by calling TileLayers initialize method\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.TileLayer.prototype.initialize.call(this, this.tileUrl, options);\r\n  },\r\n\r\n  getTileUrl: function (tilePoint) {\r\n    var zoom = this._getZoomForUrl();\r\n\r\n    return leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.template(this.tileUrl, leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.extend({\r\n      s: this._getSubdomain(tilePoint),\r\n      x: tilePoint.x,\r\n      y: tilePoint.y,\r\n      // try lod map first, then just default to zoom level\r\n      z: (this._lodMap && this._lodMap[zoom]) ? this._lodMap[zoom] : zoom\r\n    }, this.options));\r\n  },\r\n\r\n  createTile: function (coords, done) {\r\n    var tile = document.createElement('img');\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.DomEvent.on(tile, 'load', leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(this._tileOnLoad, this, done, tile));\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.DomEvent.on(tile, 'error', leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(this._tileOnError, this, done, tile));\r\n\r\n    if (this.options.crossOrigin) {\r\n      tile.crossOrigin = '';\r\n    }\r\n\r\n    /*\r\n     Alt tag is set to empty string to keep screen readers from reading URL and for compliance reasons\r\n     http://www.w3.org/TR/WCAG20-TECHS/H67\r\n    */\r\n    tile.alt = '';\r\n\r\n    // if there is no lod map or an lod map with a proper zoom load the tile\r\n    // otherwise wait for the lod map to become available\r\n    if (!this._lodMap || (this._lodMap && this._lodMap[this._getZoomForUrl()])) {\r\n      tile.src = this.getTileUrl(coords);\r\n    } else {\r\n      this.once('lodmap', function () {\r\n        tile.src = this.getTileUrl(coords);\r\n      }, this);\r\n    }\r\n\r\n    return tile;\r\n  },\r\n\r\n  onAdd: function (map) {\r\n    // include 'Powered by Esri' in map attribution\r\n    (0,_Util__WEBPACK_IMPORTED_MODULE_1__.setEsriAttribution)(map);\r\n\r\n    if (!this._lodMap) {\r\n      this.metadata(function (error, metadata) {\r\n        if (!error && metadata.spatialReference) {\r\n          var sr = metadata.spatialReference.latestWkid || metadata.spatialReference.wkid;\r\n          // display the copyright text from the service using leaflet's attribution control\r\n          if (!this.options.attribution && map.attributionControl && metadata.copyrightText) {\r\n            this.options.attribution = metadata.copyrightText;\r\n            map.attributionControl.addAttribution(this.getAttribution());\r\n          }\r\n\r\n          // if the service tiles were published in web mercator using conventional LODs but missing levels, we can try and remap them\r\n          if (map.options.crs === leaflet__WEBPACK_IMPORTED_MODULE_0__.CRS.EPSG3857 && (sr === 102100 || sr === 3857)) {\r\n            this._lodMap = {};\r\n            // create the zoom level data\r\n            var arcgisLODs = metadata.tileInfo.lods;\r\n            var correctResolutions = TiledMapLayer.MercatorZoomLevels;\r\n\r\n            for (var i = 0; i < arcgisLODs.length; i++) {\r\n              var arcgisLOD = arcgisLODs[i];\r\n              for (var ci in correctResolutions) {\r\n                var correctRes = correctResolutions[ci];\r\n\r\n                if (this._withinPercentage(arcgisLOD.resolution, correctRes, this.options.zoomOffsetAllowance)) {\r\n                  this._lodMap[ci] = arcgisLOD.level;\r\n                  break;\r\n                }\r\n              }\r\n            }\r\n\r\n            this.fire('lodmap');\r\n          } else if (map.options.crs && map.options.crs.code && (map.options.crs.code.indexOf(sr) > -1)) {\r\n            // if the projection is WGS84, or the developer is using Proj4 to define a custom CRS, no action is required\r\n          } else {\r\n            // if the service was cached in a custom projection and an appropriate LOD hasn't been defined in the map, guide the developer to our Proj4 sample\r\n            (0,_Util__WEBPACK_IMPORTED_MODULE_1__.warn)('L.esri.TiledMapLayer is using a non-mercator spatial reference. Support may be available through Proj4Leaflet https://developers.arcgis.com/esri-leaflet/samples/non-mercator-projection/');\r\n          }\r\n        }\r\n      }, this);\r\n    }\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.TileLayer.prototype.onAdd.call(this, map);\r\n  },\r\n\r\n  onRemove: function (map) {\r\n    (0,_Util__WEBPACK_IMPORTED_MODULE_1__.removeEsriAttribution)(map);\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.TileLayer.prototype.onRemove.call(this, map);\r\n  },\r\n\r\n  metadata: function (callback, context) {\r\n    this.service.metadata(callback, context);\r\n    return this;\r\n  },\r\n\r\n  identify: function () {\r\n    return this.service.identify();\r\n  },\r\n\r\n  find: function () {\r\n    return this.service.find();\r\n  },\r\n\r\n  query: function () {\r\n    return this.service.query();\r\n  },\r\n\r\n  authenticate: function (token) {\r\n    var tokenQs = '?token=' + token;\r\n    this.tileUrl = (this.options.token) ? this.tileUrl.replace(/\\?token=(.+)/g, tokenQs) : this.tileUrl + tokenQs;\r\n    this.options.token = token;\r\n    this.service.authenticate(token);\r\n    return this;\r\n  },\r\n\r\n  _withinPercentage: function (a, b, percentage) {\r\n    var diff = Math.abs((a / b) - 1);\r\n    return diff < percentage;\r\n  }\r\n});\r\n\r\nfunction tiledMapLayer (url, options) {\r\n  return new TiledMapLayer(url, options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (tiledMapLayer);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/TiledMapLayer.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Options.js":
/*!**************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Options.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"options\": () => (/* binding */ options)\n/* harmony export */ });\nvar options = {\r\n  attributionWidthOffset: 55\r\n};\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (options);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9PcHRpb25zLmpzLmpzIiwibWFwcGluZ3MiOiI7Ozs7O0FBQU87QUFDUDtBQUNBO0FBQ0E7QUFDQSxpRUFBZSxPQUFPLEVBQUMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9PcHRpb25zLmpzP2ZiMjAiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IHZhciBvcHRpb25zID0ge1xyXG4gIGF0dHJpYnV0aW9uV2lkdGhPZmZzZXQ6IDU1XHJcbn07XHJcblxyXG5leHBvcnQgZGVmYXVsdCBvcHRpb25zO1xyXG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Options.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Request.js":
/*!**************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Request.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Request\": () => (/* binding */ Request),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"get\": () => (/* binding */ get),\n/* harmony export */   \"jsonp\": () => (/* binding */ jsonp),\n/* harmony export */   \"post\": () => (/* binding */ xmlHttpPost),\n/* harmony export */   \"request\": () => (/* binding */ request),\n/* harmony export */   \"warn\": () => (/* binding */ warn)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n\r\n\r\n\r\nvar callbacks = 0;\r\n\r\nfunction serialize (params) {\r\n  var data = '';\r\n\r\n  params.f = params.f || 'json';\r\n\r\n  for (var key in params) {\r\n    if (Object.prototype.hasOwnProperty.call(params, key)) {\r\n      var param = params[key];\r\n      var type = Object.prototype.toString.call(param);\r\n      var value;\r\n\r\n      if (data.length) {\r\n        data += '&';\r\n      }\r\n\r\n      if (type === '[object Array]') {\r\n        value = (Object.prototype.toString.call(param[0]) === '[object Object]') ? JSON.stringify(param) : param.join(',');\r\n      } else if (type === '[object Object]') {\r\n        value = JSON.stringify(param);\r\n      } else if (type === '[object Date]') {\r\n        value = param.valueOf();\r\n      } else {\r\n        value = param;\r\n      }\r\n\r\n      data += encodeURIComponent(key) + '=' + encodeURIComponent(value);\r\n    }\r\n  }\r\n\r\n  return data;\r\n}\r\n\r\nfunction createRequest (callback, context) {\r\n  var httpRequest = new window.XMLHttpRequest();\r\n\r\n  httpRequest.onerror = function (e) {\r\n    httpRequest.onreadystatechange = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.falseFn;\r\n\r\n    callback.call(context, {\r\n      error: {\r\n        code: 500,\r\n        message: 'XMLHttpRequest error'\r\n      }\r\n    }, null);\r\n  };\r\n\r\n  httpRequest.onreadystatechange = function () {\r\n    var response;\r\n    var error;\r\n\r\n    if (httpRequest.readyState === 4) {\r\n      try {\r\n        response = JSON.parse(httpRequest.responseText);\r\n      } catch (e) {\r\n        response = null;\r\n        error = {\r\n          code: 500,\r\n          message: 'Could not parse response as JSON. This could also be caused by a CORS or XMLHttpRequest error.'\r\n        };\r\n      }\r\n\r\n      if (!error && response.error) {\r\n        error = response.error;\r\n        response = null;\r\n      }\r\n\r\n      httpRequest.onerror = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.falseFn;\r\n\r\n      callback.call(context, error, response);\r\n    }\r\n  };\r\n\r\n  httpRequest.ontimeout = function () {\r\n    this.onerror();\r\n  };\r\n\r\n  return httpRequest;\r\n}\r\n\r\nfunction xmlHttpPost (url, params, callback, context) {\r\n  var httpRequest = createRequest(callback, context);\r\n  httpRequest.open('POST', url);\r\n\r\n  if (typeof context !== 'undefined' && context !== null) {\r\n    if (typeof context.options !== 'undefined') {\r\n      httpRequest.timeout = context.options.timeout;\r\n    }\r\n  }\r\n  httpRequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');\r\n  httpRequest.send(serialize(params));\r\n\r\n  return httpRequest;\r\n}\r\n\r\nfunction xmlHttpGet (url, params, callback, context) {\r\n  var httpRequest = createRequest(callback, context);\r\n  httpRequest.open('GET', url + '?' + serialize(params), true);\r\n\r\n  if (typeof context !== 'undefined' && context !== null) {\r\n    if (typeof context.options !== 'undefined') {\r\n      httpRequest.timeout = context.options.timeout;\r\n      if (context.options.withCredentials) {\r\n        httpRequest.withCredentials = true;\r\n      }\r\n    }\r\n  }\r\n  httpRequest.send(null);\r\n\r\n  return httpRequest;\r\n}\r\n\r\n// AJAX handlers for CORS (modern browsers) or JSONP (older browsers)\r\nfunction request (url, params, callback, context) {\r\n  var paramString = serialize(params);\r\n  var httpRequest = createRequest(callback, context);\r\n  var requestLength = (url + '?' + paramString).length;\r\n\r\n  // ie10/11 require the request be opened before a timeout is applied\r\n  if (requestLength <= 2000 && _Support__WEBPACK_IMPORTED_MODULE_1__.Support.cors) {\r\n    httpRequest.open('GET', url + '?' + paramString);\r\n  } else if (requestLength > 2000 && _Support__WEBPACK_IMPORTED_MODULE_1__.Support.cors) {\r\n    httpRequest.open('POST', url);\r\n    httpRequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');\r\n  }\r\n\r\n  if (typeof context !== 'undefined' && context !== null) {\r\n    if (typeof context.options !== 'undefined') {\r\n      httpRequest.timeout = context.options.timeout;\r\n      if (context.options.withCredentials) {\r\n        httpRequest.withCredentials = true;\r\n      }\r\n    }\r\n  }\r\n\r\n  // request is less than 2000 characters and the browser supports CORS, make GET request with XMLHttpRequest\r\n  if (requestLength <= 2000 && _Support__WEBPACK_IMPORTED_MODULE_1__.Support.cors) {\r\n    httpRequest.send(null);\r\n\r\n  // request is more than 2000 characters and the browser supports CORS, make POST request with XMLHttpRequest\r\n  } else if (requestLength > 2000 && _Support__WEBPACK_IMPORTED_MODULE_1__.Support.cors) {\r\n    httpRequest.send(paramString);\r\n\r\n  // request is less  than 2000 characters and the browser does not support CORS, make a JSONP request\r\n  } else if (requestLength <= 2000 && !_Support__WEBPACK_IMPORTED_MODULE_1__.Support.cors) {\r\n    return jsonp(url, params, callback, context);\r\n\r\n  // request is longer then 2000 characters and the browser does not support CORS, log a warning\r\n  } else {\r\n    warn('a request to ' + url + ' was longer then 2000 characters and this browser cannot make a cross-domain post request. Please use a proxy https://developers.arcgis.com/esri-leaflet/api-reference/request/');\r\n    return;\r\n  }\r\n\r\n  return httpRequest;\r\n}\r\n\r\nfunction jsonp (url, params, callback, context) {\r\n  window._EsriLeafletCallbacks = window._EsriLeafletCallbacks || {};\r\n  var callbackId = 'c' + callbacks;\r\n  params.callback = 'window._EsriLeafletCallbacks.' + callbackId;\r\n\r\n  window._EsriLeafletCallbacks[callbackId] = function (response) {\r\n    if (window._EsriLeafletCallbacks[callbackId] !== true) {\r\n      var error;\r\n      var responseType = Object.prototype.toString.call(response);\r\n\r\n      if (!(responseType === '[object Object]' || responseType === '[object Array]')) {\r\n        error = {\r\n          error: {\r\n            code: 500,\r\n            message: 'Expected array or object as JSONP response'\r\n          }\r\n        };\r\n        response = null;\r\n      }\r\n\r\n      if (!error && response.error) {\r\n        error = response;\r\n        response = null;\r\n      }\r\n\r\n      callback.call(context, error, response);\r\n      window._EsriLeafletCallbacks[callbackId] = true;\r\n    }\r\n  };\r\n\r\n  var script = leaflet__WEBPACK_IMPORTED_MODULE_0__.DomUtil.create('script', null, document.body);\r\n  script.type = 'text/javascript';\r\n  script.src = url + '?' + serialize(params);\r\n  script.id = callbackId;\r\n  script.onerror = function (error) {\r\n    if (error && window._EsriLeafletCallbacks[callbackId] !== true) {\r\n      // Can't get true error code: it can be 404, or 401, or 500\r\n      var err = {\r\n        error: {\r\n          code: 500,\r\n          message: 'An unknown error occurred'\r\n        }\r\n      };\r\n\r\n      callback.call(context, err);\r\n      window._EsriLeafletCallbacks[callbackId] = true;\r\n    }\r\n  };\r\n  leaflet__WEBPACK_IMPORTED_MODULE_0__.DomUtil.addClass(script, 'esri-leaflet-jsonp');\r\n\r\n  callbacks++;\r\n\r\n  return {\r\n    id: callbackId,\r\n    url: script.src,\r\n    abort: function () {\r\n      window._EsriLeafletCallbacks._callback[callbackId]({\r\n        code: 0,\r\n        message: 'Request aborted.'\r\n      });\r\n    }\r\n  };\r\n}\r\n\r\nvar get = ((_Support__WEBPACK_IMPORTED_MODULE_1__.Support.cors) ? xmlHttpGet : jsonp);\r\nget.CORS = xmlHttpGet;\r\nget.JSONP = jsonp;\r\n\r\nfunction warn () {\r\n  if (console && console.warn) {\r\n    console.warn.apply(console, arguments);\r\n  }\r\n}\r\n\r\n// choose the correct AJAX handler depending on CORS support\r\n\r\n\r\n// always use XMLHttpRequest for posts\r\n\r\n\r\n// export the Request object to call the different handlers for debugging\r\nvar Request = {\r\n  request: request,\r\n  get: get,\r\n  post: xmlHttpPost\r\n};\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Request);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Request.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Services/FeatureLayerService.js":
/*!***********************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Services/FeatureLayerService.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FeatureLayerService\": () => (/* binding */ FeatureLayerService),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"featureLayerService\": () => (/* binding */ featureLayerService)\n/* harmony export */ });\n/* harmony import */ var _Service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Service */ \"./node_modules/esri-leaflet/src/Services/Service.js\");\n/* harmony import */ var _Tasks_Query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Tasks/Query */ \"./node_modules/esri-leaflet/src/Tasks/Query.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar FeatureLayerService = _Service__WEBPACK_IMPORTED_MODULE_0__.Service.extend({\r\n\r\n  options: {\r\n    idAttribute: 'OBJECTID'\r\n  },\r\n\r\n  query: function () {\r\n    return (0,_Tasks_Query__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(this);\r\n  },\r\n\r\n  addFeature: function (feature, callback, context) {\r\n    this.addFeatures(feature, callback, context);\r\n  },\r\n\r\n  addFeatures: function (features, callback, context) {\r\n    var featuresArray = features.features ? features.features : [features];\r\n    for (var i = featuresArray.length - 1; i >= 0; i--) {\r\n      delete featuresArray[i].id;\r\n    }\r\n    features = (0,_Util__WEBPACK_IMPORTED_MODULE_2__.geojsonToArcGIS)(features);\r\n    features = featuresArray.length > 1 ? features : [features];\r\n    return this.post('addFeatures', {\r\n      features: features\r\n    }, function (error, response) {\r\n      // For compatibility reason with former addFeature function,\r\n      // we return the object in the array and not the array itself\r\n      var result = (response && response.addResults) ? response.addResults.length > 1 ? response.addResults : response.addResults[0] : undefined;\r\n      if (callback) {\r\n        callback.call(context, error || response.addResults[0].error, result);\r\n      }\r\n    }, context);\r\n  },\r\n\r\n  updateFeature: function (feature, callback, context) {\r\n    this.updateFeatures(feature, callback, context);\r\n  },\r\n\r\n  updateFeatures: function (features, callback, context) {\r\n    var featuresArray = features.features ? features.features : [features];\r\n    features = (0,_Util__WEBPACK_IMPORTED_MODULE_2__.geojsonToArcGIS)(features, this.options.idAttribute);\r\n    features = featuresArray.length > 1 ? features : [features];\r\n\r\n    return this.post('updateFeatures', {\r\n      features: features\r\n    }, function (error, response) {\r\n      // For compatibility reason with former updateFeature function,\r\n      // we return the object in the array and not the array itself\r\n      var result = (response && response.updateResults) ? response.updateResults.length > 1 ? response.updateResults : response.updateResults[0] : undefined;\r\n      if (callback) {\r\n        callback.call(context, error || response.updateResults[0].error, result);\r\n      }\r\n    }, context);\r\n  },\r\n\r\n  deleteFeature: function (id, callback, context) {\r\n    this.deleteFeatures(id, callback, context);\r\n  },\r\n\r\n  deleteFeatures: function (ids, callback, context) {\r\n    return this.post('deleteFeatures', {\r\n      objectIds: ids\r\n    }, function (error, response) {\r\n      // For compatibility reason with former deleteFeature function,\r\n      // we return the object in the array and not the array itself\r\n      var result = (response && response.deleteResults) ? response.deleteResults.length > 1 ? response.deleteResults : response.deleteResults[0] : undefined;\r\n      if (callback) {\r\n        callback.call(context, error || response.deleteResults[0].error, result);\r\n      }\r\n    }, context);\r\n  }\r\n});\r\n\r\nfunction featureLayerService (options) {\r\n  return new FeatureLayerService(options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (featureLayerService);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Services/FeatureLayerService.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Services/ImageService.js":
/*!****************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Services/ImageService.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ImageService\": () => (/* binding */ ImageService),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"imageService\": () => (/* binding */ imageService)\n/* harmony export */ });\n/* harmony import */ var _Service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Service */ \"./node_modules/esri-leaflet/src/Services/Service.js\");\n/* harmony import */ var _Tasks_IdentifyImage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Tasks/IdentifyImage */ \"./node_modules/esri-leaflet/src/Tasks/IdentifyImage.js\");\n/* harmony import */ var _Tasks_Query__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Tasks/Query */ \"./node_modules/esri-leaflet/src/Tasks/Query.js\");\n\r\n\r\n\r\n\r\nvar ImageService = _Service__WEBPACK_IMPORTED_MODULE_0__.Service.extend({\r\n\r\n  query: function () {\r\n    return (0,_Tasks_Query__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(this);\r\n  },\r\n\r\n  identify: function () {\r\n    return (0,_Tasks_IdentifyImage__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(this);\r\n  }\r\n});\r\n\r\nfunction imageService (options) {\r\n  return new ImageService(options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (imageService);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9TZXJ2aWNlcy9JbWFnZVNlcnZpY2UuanMuanMiLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQW9DO0FBQ2U7QUFDaEI7QUFDbkM7QUFDTyxtQkFBbUIsb0RBQWM7QUFDeEM7QUFDQTtBQUNBLFdBQVcsd0RBQUs7QUFDaEIsR0FBRztBQUNIO0FBQ0E7QUFDQSxXQUFXLGdFQUFhO0FBQ3hCO0FBQ0EsQ0FBQztBQUNEO0FBQ087QUFDUDtBQUNBO0FBQ0E7QUFDQSxpRUFBZSxZQUFZLEVBQUMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9TZXJ2aWNlcy9JbWFnZVNlcnZpY2UuanM/YjFhYyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTZXJ2aWNlIH0gZnJvbSAnLi9TZXJ2aWNlJztcclxuaW1wb3J0IGlkZW50aWZ5SW1hZ2UgZnJvbSAnLi4vVGFza3MvSWRlbnRpZnlJbWFnZSc7XHJcbmltcG9ydCBxdWVyeSBmcm9tICcuLi9UYXNrcy9RdWVyeSc7XHJcblxyXG5leHBvcnQgdmFyIEltYWdlU2VydmljZSA9IFNlcnZpY2UuZXh0ZW5kKHtcclxuXHJcbiAgcXVlcnk6IGZ1bmN0aW9uICgpIHtcclxuICAgIHJldHVybiBxdWVyeSh0aGlzKTtcclxuICB9LFxyXG5cclxuICBpZGVudGlmeTogZnVuY3Rpb24gKCkge1xyXG4gICAgcmV0dXJuIGlkZW50aWZ5SW1hZ2UodGhpcyk7XHJcbiAgfVxyXG59KTtcclxuXHJcbmV4cG9ydCBmdW5jdGlvbiBpbWFnZVNlcnZpY2UgKG9wdGlvbnMpIHtcclxuICByZXR1cm4gbmV3IEltYWdlU2VydmljZShvcHRpb25zKTtcclxufVxyXG5cclxuZXhwb3J0IGRlZmF1bHQgaW1hZ2VTZXJ2aWNlO1xyXG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Services/ImageService.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Services/MapService.js":
/*!**************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Services/MapService.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"MapService\": () => (/* binding */ MapService),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"mapService\": () => (/* binding */ mapService)\n/* harmony export */ });\n/* harmony import */ var _Service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Service */ \"./node_modules/esri-leaflet/src/Services/Service.js\");\n/* harmony import */ var _Tasks_IdentifyFeatures__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Tasks/IdentifyFeatures */ \"./node_modules/esri-leaflet/src/Tasks/IdentifyFeatures.js\");\n/* harmony import */ var _Tasks_Query__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Tasks/Query */ \"./node_modules/esri-leaflet/src/Tasks/Query.js\");\n/* harmony import */ var _Tasks_Find__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Tasks/Find */ \"./node_modules/esri-leaflet/src/Tasks/Find.js\");\n\r\n\r\n\r\n\r\n\r\nvar MapService = _Service__WEBPACK_IMPORTED_MODULE_0__.Service.extend({\r\n\r\n  identify: function () {\r\n    return (0,_Tasks_IdentifyFeatures__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(this);\r\n  },\r\n\r\n  find: function () {\r\n    return (0,_Tasks_Find__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(this);\r\n  },\r\n\r\n  query: function () {\r\n    return (0,_Tasks_Query__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(this);\r\n  }\r\n\r\n});\r\n\r\nfunction mapService (options) {\r\n  return new MapService(options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mapService);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9TZXJ2aWNlcy9NYXBTZXJ2aWNlLmpzLmpzIiwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFBb0M7QUFDcUI7QUFDdEI7QUFDRjtBQUNqQztBQUNPLGlCQUFpQixvREFBYztBQUN0QztBQUNBO0FBQ0EsV0FBVyxtRUFBZ0I7QUFDM0IsR0FBRztBQUNIO0FBQ0E7QUFDQSxXQUFXLHVEQUFJO0FBQ2YsR0FBRztBQUNIO0FBQ0E7QUFDQSxXQUFXLHdEQUFLO0FBQ2hCO0FBQ0E7QUFDQSxDQUFDO0FBQ0Q7QUFDTztBQUNQO0FBQ0E7QUFDQTtBQUNBLGlFQUFlLFVBQVUsRUFBQyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lc3JpLWxlYWZsZXQvc3JjL1NlcnZpY2VzL01hcFNlcnZpY2UuanM/ODE4OSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTZXJ2aWNlIH0gZnJvbSAnLi9TZXJ2aWNlJztcclxuaW1wb3J0IGlkZW50aWZ5RmVhdHVyZXMgZnJvbSAnLi4vVGFza3MvSWRlbnRpZnlGZWF0dXJlcyc7XHJcbmltcG9ydCBxdWVyeSBmcm9tICcuLi9UYXNrcy9RdWVyeSc7XHJcbmltcG9ydCBmaW5kIGZyb20gJy4uL1Rhc2tzL0ZpbmQnO1xyXG5cclxuZXhwb3J0IHZhciBNYXBTZXJ2aWNlID0gU2VydmljZS5leHRlbmQoe1xyXG5cclxuICBpZGVudGlmeTogZnVuY3Rpb24gKCkge1xyXG4gICAgcmV0dXJuIGlkZW50aWZ5RmVhdHVyZXModGhpcyk7XHJcbiAgfSxcclxuXHJcbiAgZmluZDogZnVuY3Rpb24gKCkge1xyXG4gICAgcmV0dXJuIGZpbmQodGhpcyk7XHJcbiAgfSxcclxuXHJcbiAgcXVlcnk6IGZ1bmN0aW9uICgpIHtcclxuICAgIHJldHVybiBxdWVyeSh0aGlzKTtcclxuICB9XHJcblxyXG59KTtcclxuXHJcbmV4cG9ydCBmdW5jdGlvbiBtYXBTZXJ2aWNlIChvcHRpb25zKSB7XHJcbiAgcmV0dXJuIG5ldyBNYXBTZXJ2aWNlKG9wdGlvbnMpO1xyXG59XHJcblxyXG5leHBvcnQgZGVmYXVsdCBtYXBTZXJ2aWNlO1xyXG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Services/MapService.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Services/Service.js":
/*!***********************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Services/Service.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Service\": () => (/* binding */ Service),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"service\": () => (/* binding */ service)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _Request__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Request */ \"./node_modules/esri-leaflet/src/Request.js\");\n\r\n\r\n\r\n\r\n\r\nvar Service = leaflet__WEBPACK_IMPORTED_MODULE_0__.Evented.extend({\r\n\r\n  options: {\r\n    proxy: false,\r\n    useCors: _Support__WEBPACK_IMPORTED_MODULE_1__.cors,\r\n    timeout: 0\r\n  },\r\n\r\n  initialize: function (options) {\r\n    options = options || {};\r\n    this._requestQueue = [];\r\n    this._authenticating = false;\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.setOptions(this, options);\r\n    this.options.url = (0,_Util__WEBPACK_IMPORTED_MODULE_2__.cleanUrl)(this.options.url);\r\n  },\r\n\r\n  get: function (path, params, callback, context) {\r\n    return this._request('get', path, params, callback, context);\r\n  },\r\n\r\n  post: function (path, params, callback, context) {\r\n    return this._request('post', path, params, callback, context);\r\n  },\r\n\r\n  request: function (path, params, callback, context) {\r\n    return this._request('request', path, params, callback, context);\r\n  },\r\n\r\n  metadata: function (callback, context) {\r\n    return this._request('get', '', {}, callback, context);\r\n  },\r\n\r\n  authenticate: function (token) {\r\n    this._authenticating = false;\r\n    this.options.token = token;\r\n    this._runQueue();\r\n    return this;\r\n  },\r\n\r\n  getTimeout: function () {\r\n    return this.options.timeout;\r\n  },\r\n\r\n  setTimeout: function (timeout) {\r\n    this.options.timeout = timeout;\r\n  },\r\n\r\n  _request: function (method, path, params, callback, context) {\r\n    this.fire('requeststart', {\r\n      url: this.options.url + path,\r\n      params: params,\r\n      method: method\r\n    }, true);\r\n\r\n    var wrappedCallback = this._createServiceCallback(method, path, params, callback, context);\r\n\r\n    if (this.options.token) {\r\n      params.token = this.options.token;\r\n    }\r\n    if (this.options.requestParams) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.extend(params, this.options.requestParams);\r\n    }\r\n    if (this._authenticating) {\r\n      this._requestQueue.push([method, path, params, callback, context]);\r\n    } else {\r\n      var url = (this.options.proxy) ? this.options.proxy + '?' + this.options.url + path : this.options.url + path;\r\n\r\n      if ((method === 'get' || method === 'request') && !this.options.useCors) {\r\n        return _Request__WEBPACK_IMPORTED_MODULE_3__[\"default\"].get.JSONP(url, params, wrappedCallback, context);\r\n      } else {\r\n        return _Request__WEBPACK_IMPORTED_MODULE_3__[\"default\"][method](url, params, wrappedCallback, context);\r\n      }\r\n    }\r\n  },\r\n\r\n  _createServiceCallback: function (method, path, params, callback, context) {\r\n    return leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function (error, response) {\r\n      if (error && (error.code === 499 || error.code === 498)) {\r\n        this._authenticating = true;\r\n\r\n        this._requestQueue.push([method, path, params, callback, context]);\r\n\r\n        // fire an event for users to handle and re-authenticate\r\n        this.fire('authenticationrequired', {\r\n          authenticate: leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(this.authenticate, this)\r\n        }, true);\r\n\r\n        // if the user has access to a callback they can handle the auth error\r\n        error.authenticate = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(this.authenticate, this);\r\n      }\r\n\r\n      callback.call(context, error, response);\r\n\r\n      if (error) {\r\n        this.fire('requesterror', {\r\n          url: this.options.url + path,\r\n          params: params,\r\n          message: error.message,\r\n          code: error.code,\r\n          method: method\r\n        }, true);\r\n      } else {\r\n        this.fire('requestsuccess', {\r\n          url: this.options.url + path,\r\n          params: params,\r\n          response: response,\r\n          method: method\r\n        }, true);\r\n      }\r\n\r\n      this.fire('requestend', {\r\n        url: this.options.url + path,\r\n        params: params,\r\n        method: method\r\n      }, true);\r\n    }, this);\r\n  },\r\n\r\n  _runQueue: function () {\r\n    for (var i = this._requestQueue.length - 1; i >= 0; i--) {\r\n      var request = this._requestQueue[i];\r\n      var method = request.shift();\r\n      this[method].apply(this, request);\r\n    }\r\n    this._requestQueue = [];\r\n  }\r\n});\r\n\r\nfunction service (options) {\r\n  options = (0,_Util__WEBPACK_IMPORTED_MODULE_2__.getUrlParams)(options);\r\n  return new Service(options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (service);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Services/Service.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Support.js":
/*!**************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Support.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Support\": () => (/* binding */ Support),\n/* harmony export */   \"cors\": () => (/* binding */ cors),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"pointerEvents\": () => (/* binding */ pointerEvents)\n/* harmony export */ });\nvar cors = ((window.XMLHttpRequest && 'withCredentials' in new window.XMLHttpRequest()));\r\nvar pointerEvents = document.documentElement.style.pointerEvents === '';\r\n\r\nvar Support = {\r\n  cors: cors,\r\n  pointerEvents: pointerEvents\r\n};\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Support);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9TdXBwb3J0LmpzLmpzIiwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBTztBQUNBO0FBQ1A7QUFDTztBQUNQO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsaUVBQWUsT0FBTyxFQUFDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VzcmktbGVhZmxldC9zcmMvU3VwcG9ydC5qcz83YTJhIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCB2YXIgY29ycyA9ICgod2luZG93LlhNTEh0dHBSZXF1ZXN0ICYmICd3aXRoQ3JlZGVudGlhbHMnIGluIG5ldyB3aW5kb3cuWE1MSHR0cFJlcXVlc3QoKSkpO1xyXG5leHBvcnQgdmFyIHBvaW50ZXJFdmVudHMgPSBkb2N1bWVudC5kb2N1bWVudEVsZW1lbnQuc3R5bGUucG9pbnRlckV2ZW50cyA9PT0gJyc7XHJcblxyXG5leHBvcnQgdmFyIFN1cHBvcnQgPSB7XHJcbiAgY29yczogY29ycyxcclxuICBwb2ludGVyRXZlbnRzOiBwb2ludGVyRXZlbnRzXHJcbn07XHJcblxyXG5leHBvcnQgZGVmYXVsdCBTdXBwb3J0O1xyXG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Support.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Tasks/Find.js":
/*!*****************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Tasks/Find.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Find\": () => (/* binding */ Find),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"find\": () => (/* binding */ find)\n/* harmony export */ });\n/* harmony import */ var _Task__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Task */ \"./node_modules/esri-leaflet/src/Tasks/Task.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\nvar Find = _Task__WEBPACK_IMPORTED_MODULE_0__.Task.extend({\r\n  setters: {\r\n    // method name > param name\r\n    contains: 'contains',\r\n    text: 'searchText',\r\n    fields: 'searchFields', // denote an array or single string\r\n    spatialReference: 'sr',\r\n    sr: 'sr',\r\n    layers: 'layers',\r\n    returnGeometry: 'returnGeometry',\r\n    maxAllowableOffset: 'maxAllowableOffset',\r\n    precision: 'geometryPrecision',\r\n    dynamicLayers: 'dynamicLayers',\r\n    returnZ: 'returnZ',\r\n    returnM: 'returnM',\r\n    gdbVersion: 'gdbVersion',\r\n    // skipped implementing this (for now) because the REST service implementation isnt consistent between operations\r\n    // 'transform': 'datumTransformations',\r\n    token: 'token'\r\n  },\r\n\r\n  path: 'find',\r\n\r\n  params: {\r\n    sr: 4326,\r\n    contains: true,\r\n    returnGeometry: true,\r\n    returnZ: true,\r\n    returnM: false\r\n  },\r\n\r\n  layerDefs: function (id, where) {\r\n    this.params.layerDefs = (this.params.layerDefs) ? this.params.layerDefs + ';' : '';\r\n    this.params.layerDefs += ([id, where]).join(':');\r\n    return this;\r\n  },\r\n\r\n  simplify: function (map, factor) {\r\n    var mapWidth = Math.abs(map.getBounds().getWest() - map.getBounds().getEast());\r\n    this.params.maxAllowableOffset = (mapWidth / map.getSize().y) * factor;\r\n    return this;\r\n  },\r\n\r\n  run: function (callback, context) {\r\n    return this.request(function (error, response) {\r\n      callback.call(context, error, (response && (0,_Util__WEBPACK_IMPORTED_MODULE_1__.responseToFeatureCollection)(response)), response);\r\n    }, context);\r\n  }\r\n});\r\n\r\nfunction find (options) {\r\n  return new Find(options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (find);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Tasks/Find.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Tasks/Identify.js":
/*!*********************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Tasks/Identify.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Identify\": () => (/* binding */ Identify),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"identify\": () => (/* binding */ identify)\n/* harmony export */ });\n/* harmony import */ var _Task__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Task */ \"./node_modules/esri-leaflet/src/Tasks/Task.js\");\n\r\n\r\nvar Identify = _Task__WEBPACK_IMPORTED_MODULE_0__.Task.extend({\r\n  path: 'identify',\r\n\r\n  between: function (start, end) {\r\n    this.params.time = [start.valueOf(), end.valueOf()];\r\n    return this;\r\n  }\r\n});\r\n\r\nfunction identify (options) {\r\n  return new Identify(options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (identify);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9UYXNrcy9JZGVudGlmeS5qcy5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQThCO0FBQzlCO0FBQ08sZUFBZSw4Q0FBVztBQUNqQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxDQUFDO0FBQ0Q7QUFDTztBQUNQO0FBQ0E7QUFDQTtBQUNBLGlFQUFlLFFBQVEsRUFBQyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lc3JpLWxlYWZsZXQvc3JjL1Rhc2tzL0lkZW50aWZ5LmpzPzU0NDciXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVGFzayB9IGZyb20gJy4vVGFzayc7XHJcblxyXG5leHBvcnQgdmFyIElkZW50aWZ5ID0gVGFzay5leHRlbmQoe1xyXG4gIHBhdGg6ICdpZGVudGlmeScsXHJcblxyXG4gIGJldHdlZW46IGZ1bmN0aW9uIChzdGFydCwgZW5kKSB7XHJcbiAgICB0aGlzLnBhcmFtcy50aW1lID0gW3N0YXJ0LnZhbHVlT2YoKSwgZW5kLnZhbHVlT2YoKV07XHJcbiAgICByZXR1cm4gdGhpcztcclxuICB9XHJcbn0pO1xyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIGlkZW50aWZ5IChvcHRpb25zKSB7XHJcbiAgcmV0dXJuIG5ldyBJZGVudGlmeShvcHRpb25zKTtcclxufVxyXG5cclxuZXhwb3J0IGRlZmF1bHQgaWRlbnRpZnk7XHJcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Tasks/Identify.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Tasks/IdentifyFeatures.js":
/*!*****************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Tasks/IdentifyFeatures.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"IdentifyFeatures\": () => (/* binding */ IdentifyFeatures),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"identifyFeatures\": () => (/* binding */ identifyFeatures)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Identify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Identify */ \"./node_modules/esri-leaflet/src/Tasks/Identify.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar IdentifyFeatures = _Identify__WEBPACK_IMPORTED_MODULE_1__.Identify.extend({\r\n  setters: {\r\n    layers: 'layers',\r\n    precision: 'geometryPrecision',\r\n    tolerance: 'tolerance',\r\n    // skipped implementing this (for now) because the REST service implementation isnt consistent between operations.\r\n    // 'transform': 'datumTransformations'\r\n    returnGeometry: 'returnGeometry'\r\n  },\r\n\r\n  params: {\r\n    sr: 4326,\r\n    layers: 'all',\r\n    tolerance: 3,\r\n    returnGeometry: true\r\n  },\r\n\r\n  on: function (map) {\r\n    var extent = (0,_Util__WEBPACK_IMPORTED_MODULE_2__.boundsToExtent)(map.getBounds());\r\n    var size = map.getSize();\r\n    this.params.imageDisplay = [size.x, size.y, 96];\r\n    this.params.mapExtent = [extent.xmin, extent.ymin, extent.xmax, extent.ymax];\r\n    return this;\r\n  },\r\n\r\n  at: function (geometry) {\r\n    // cast lat, long pairs in raw array form manually\r\n    if (geometry.length === 2) {\r\n      geometry = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLng)(geometry);\r\n    }\r\n    this._setGeometryParams(geometry);\r\n    return this;\r\n  },\r\n\r\n  layerDef: function (id, where) {\r\n    this.params.layerDefs = (this.params.layerDefs) ? this.params.layerDefs + ';' : '';\r\n    this.params.layerDefs += ([id, where]).join(':');\r\n    return this;\r\n  },\r\n\r\n  simplify: function (map, factor) {\r\n    var mapWidth = Math.abs(map.getBounds().getWest() - map.getBounds().getEast());\r\n    this.params.maxAllowableOffset = (mapWidth / map.getSize().y) * factor;\r\n    return this;\r\n  },\r\n\r\n  run: function (callback, context) {\r\n    return this.request(function (error, response) {\r\n      // immediately invoke with an error\r\n      if (error) {\r\n        callback.call(context, error, undefined, response);\r\n\r\n      // ok no error lets just assume we have features...\r\n      } else {\r\n        var featureCollection = (0,_Util__WEBPACK_IMPORTED_MODULE_2__.responseToFeatureCollection)(response);\r\n        response.results = response.results.reverse();\r\n        for (var i = 0; i < featureCollection.features.length; i++) {\r\n          var feature = featureCollection.features[i];\r\n          feature.layerId = response.results[i].layerId;\r\n        }\r\n        callback.call(context, undefined, featureCollection, response);\r\n      }\r\n    });\r\n  },\r\n\r\n  _setGeometryParams: function (geometry) {\r\n    var converted = (0,_Util__WEBPACK_IMPORTED_MODULE_2__._setGeometry)(geometry);\r\n    this.params.geometry = converted.geometry;\r\n    this.params.geometryType = converted.geometryType;\r\n  }\r\n});\r\n\r\nfunction identifyFeatures (options) {\r\n  return new IdentifyFeatures(options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (identifyFeatures);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Tasks/IdentifyFeatures.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Tasks/IdentifyImage.js":
/*!**************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Tasks/IdentifyImage.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"IdentifyImage\": () => (/* binding */ IdentifyImage),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"identifyImage\": () => (/* binding */ identifyImage)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Identify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Identify */ \"./node_modules/esri-leaflet/src/Tasks/Identify.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar IdentifyImage = _Identify__WEBPACK_IMPORTED_MODULE_1__.Identify.extend({\r\n  setters: {\r\n    setMosaicRule: 'mosaicRule',\r\n    setRenderingRule: 'renderingRule',\r\n    setPixelSize: 'pixelSize',\r\n    returnCatalogItems: 'returnCatalogItems',\r\n    returnGeometry: 'returnGeometry'\r\n  },\r\n\r\n  params: {\r\n    returnGeometry: false\r\n  },\r\n\r\n  at: function (latlng) {\r\n    latlng = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLng)(latlng);\r\n    this.params.geometry = JSON.stringify({\r\n      x: latlng.lng,\r\n      y: latlng.lat,\r\n      spatialReference: {\r\n        wkid: 4326\r\n      }\r\n    });\r\n    this.params.geometryType = 'esriGeometryPoint';\r\n    return this;\r\n  },\r\n\r\n  getMosaicRule: function () {\r\n    return this.params.mosaicRule;\r\n  },\r\n\r\n  getRenderingRule: function () {\r\n    return this.params.renderingRule;\r\n  },\r\n\r\n  getPixelSize: function () {\r\n    return this.params.pixelSize;\r\n  },\r\n\r\n  run: function (callback, context) {\r\n    return this.request(function (error, response) {\r\n      callback.call(context, error, (response && this._responseToGeoJSON(response)), response);\r\n    }, this);\r\n  },\r\n\r\n  // get pixel data and return as geoJSON point\r\n  // populate catalog items (if any)\r\n  // merging in any catalogItemVisibilities as a propery of each feature\r\n  _responseToGeoJSON: function (response) {\r\n    var location = response.location;\r\n    var catalogItems = response.catalogItems;\r\n    var catalogItemVisibilities = response.catalogItemVisibilities;\r\n    var geoJSON = {\r\n      pixel: {\r\n        type: 'Feature',\r\n        geometry: {\r\n          type: 'Point',\r\n          coordinates: [location.x, location.y]\r\n        },\r\n        crs: {\r\n          type: 'EPSG',\r\n          properties: {\r\n            code: location.spatialReference.wkid\r\n          }\r\n        },\r\n        properties: {\r\n          OBJECTID: response.objectId,\r\n          name: response.name,\r\n          value: response.value\r\n        },\r\n        id: response.objectId\r\n      }\r\n    };\r\n\r\n    if (response.properties && response.properties.Values) {\r\n      geoJSON.pixel.properties.values = response.properties.Values;\r\n    }\r\n\r\n    if (catalogItems && catalogItems.features) {\r\n      geoJSON.catalogItems = (0,_Util__WEBPACK_IMPORTED_MODULE_2__.responseToFeatureCollection)(catalogItems);\r\n      if (catalogItemVisibilities && catalogItemVisibilities.length === geoJSON.catalogItems.features.length) {\r\n        for (var i = catalogItemVisibilities.length - 1; i >= 0; i--) {\r\n          geoJSON.catalogItems.features[i].properties.catalogItemVisibility = catalogItemVisibilities[i];\r\n        }\r\n      }\r\n    }\r\n    return geoJSON;\r\n  }\r\n\r\n});\r\n\r\nfunction identifyImage (params) {\r\n  return new IdentifyImage(params);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (identifyImage);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Tasks/IdentifyImage.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Tasks/Query.js":
/*!******************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Tasks/Query.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Query\": () => (/* binding */ Query),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"query\": () => (/* binding */ query)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Task__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Task */ \"./node_modules/esri-leaflet/src/Tasks/Task.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar Query = _Task__WEBPACK_IMPORTED_MODULE_1__.Task.extend({\r\n  setters: {\r\n    offset: 'resultOffset',\r\n    limit: 'resultRecordCount',\r\n    fields: 'outFields',\r\n    precision: 'geometryPrecision',\r\n    featureIds: 'objectIds',\r\n    returnGeometry: 'returnGeometry',\r\n    returnM: 'returnM',\r\n    transform: 'datumTransformation',\r\n    token: 'token'\r\n  },\r\n\r\n  path: 'query',\r\n\r\n  params: {\r\n    returnGeometry: true,\r\n    where: '1=1',\r\n    outSR: 4326,\r\n    outFields: '*'\r\n  },\r\n\r\n  // Returns a feature if its shape is wholly contained within the search geometry. Valid for all shape type combinations.\r\n  within: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelContains'; // to the REST api this reads geometry **contains** layer\r\n    return this;\r\n  },\r\n\r\n  // Returns a feature if any spatial relationship is found. Applies to all shape type combinations.\r\n  intersects: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelIntersects';\r\n    return this;\r\n  },\r\n\r\n  // Returns a feature if its shape wholly contains the search geometry. Valid for all shape type combinations.\r\n  contains: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelWithin'; // to the REST api this reads geometry **within** layer\r\n    return this;\r\n  },\r\n\r\n  // Returns a feature if the intersection of the interiors of the two shapes is not empty and has a lower dimension than the maximum dimension of the two shapes. Two lines that share an endpoint in common do not cross. Valid for Line/Line, Line/Area, Multi-point/Area, and Multi-point/Line shape type combinations.\r\n  crosses: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelCrosses';\r\n    return this;\r\n  },\r\n\r\n  // Returns a feature if the two shapes share a common boundary. However, the intersection of the interiors of the two shapes must be empty. In the Point/Line case, the point may touch an endpoint only of the line. Applies to all combinations except Point/Point.\r\n  touches: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelTouches';\r\n    return this;\r\n  },\r\n\r\n  // Returns a feature if the intersection of the two shapes results in an object of the same dimension, but different from both of the shapes. Applies to Area/Area, Line/Line, and Multi-point/Multi-point shape type combinations.\r\n  overlaps: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelOverlaps';\r\n    return this;\r\n  },\r\n\r\n  // Returns a feature if the envelope of the two shapes intersects.\r\n  bboxIntersects: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelEnvelopeIntersects';\r\n    return this;\r\n  },\r\n\r\n  // if someone can help decipher the ArcObjects explanation and translate to plain speak, we should mention this method in the doc\r\n  indexIntersects: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelIndexIntersects'; // Returns a feature if the envelope of the query geometry intersects the index entry for the target geometry\r\n    return this;\r\n  },\r\n\r\n  // only valid for Feature Services running on ArcGIS Server 10.3+ or ArcGIS Online\r\n  nearby: function (latlng, radius) {\r\n    latlng = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLng)(latlng);\r\n    this.params.geometry = [latlng.lng, latlng.lat];\r\n    this.params.geometryType = 'esriGeometryPoint';\r\n    this.params.spatialRel = 'esriSpatialRelIntersects';\r\n    this.params.units = 'esriSRUnit_Meter';\r\n    this.params.distance = radius;\r\n    this.params.inSR = 4326;\r\n    return this;\r\n  },\r\n\r\n  where: function (string) {\r\n    // instead of converting double-quotes to single quotes, pass as is, and provide a more informative message if a 400 is encountered\r\n    this.params.where = string;\r\n    return this;\r\n  },\r\n\r\n  between: function (start, end) {\r\n    this.params.time = [start.valueOf(), end.valueOf()];\r\n    return this;\r\n  },\r\n\r\n  simplify: function (map, factor) {\r\n    var mapWidth = Math.abs(map.getBounds().getWest() - map.getBounds().getEast());\r\n    this.params.maxAllowableOffset = (mapWidth / map.getSize().y) * factor;\r\n    return this;\r\n  },\r\n\r\n  orderBy: function (fieldName, order) {\r\n    order = order || 'ASC';\r\n    this.params.orderByFields = (this.params.orderByFields) ? this.params.orderByFields + ',' : '';\r\n    this.params.orderByFields += ([fieldName, order]).join(' ');\r\n    return this;\r\n  },\r\n\r\n  run: function (callback, context) {\r\n    this._cleanParams();\r\n\r\n    // services hosted on ArcGIS Online and ArcGIS Server 10.3.1+ support requesting geojson directly\r\n    if (this.options.isModern || ((0,_Util__WEBPACK_IMPORTED_MODULE_2__.isArcgisOnline)(this.options.url) && this.options.isModern === undefined)) {\r\n      this.params.f = 'geojson';\r\n\r\n      return this.request(function (error, response) {\r\n        this._trapSQLerrors(error);\r\n        callback.call(context, error, response, response);\r\n      }, this);\r\n\r\n      // otherwise convert it in the callback then pass it on\r\n    } else {\r\n      return this.request(function (error, response) {\r\n        this._trapSQLerrors(error);\r\n        callback.call(context, error, (response && (0,_Util__WEBPACK_IMPORTED_MODULE_2__.responseToFeatureCollection)(response)), response);\r\n      }, this);\r\n    }\r\n  },\r\n\r\n  count: function (callback, context) {\r\n    this._cleanParams();\r\n    this.params.returnCountOnly = true;\r\n    return this.request(function (error, response) {\r\n      callback.call(this, error, (response && response.count), response);\r\n    }, context);\r\n  },\r\n\r\n  ids: function (callback, context) {\r\n    this._cleanParams();\r\n    this.params.returnIdsOnly = true;\r\n    return this.request(function (error, response) {\r\n      callback.call(this, error, (response && response.objectIds), response);\r\n    }, context);\r\n  },\r\n\r\n  // only valid for Feature Services running on ArcGIS Server 10.3+ or ArcGIS Online\r\n  bounds: function (callback, context) {\r\n    this._cleanParams();\r\n    this.params.returnExtentOnly = true;\r\n    return this.request(function (error, response) {\r\n      if (response && response.extent && (0,_Util__WEBPACK_IMPORTED_MODULE_2__.extentToBounds)(response.extent)) {\r\n        callback.call(context, error, (0,_Util__WEBPACK_IMPORTED_MODULE_2__.extentToBounds)(response.extent), response);\r\n      } else {\r\n        error = {\r\n          message: 'Invalid Bounds'\r\n        };\r\n        callback.call(context, error, null, response);\r\n      }\r\n    }, context);\r\n  },\r\n\r\n  distinct: function () {\r\n    // geometry must be omitted for queries requesting distinct values\r\n    this.params.returnGeometry = false;\r\n    this.params.returnDistinctValues = true;\r\n    return this;\r\n  },\r\n\r\n  // only valid for image services\r\n  pixelSize: function (rawPoint) {\r\n    var castPoint = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.point)(rawPoint);\r\n    this.params.pixelSize = [castPoint.x, castPoint.y];\r\n    return this;\r\n  },\r\n\r\n  // only valid for map services\r\n  layer: function (layer) {\r\n    this.path = layer + '/query';\r\n    return this;\r\n  },\r\n\r\n  _trapSQLerrors: function (error) {\r\n    if (error) {\r\n      if (error.code === '400') {\r\n        (0,_Util__WEBPACK_IMPORTED_MODULE_2__.warn)('one common syntax error in query requests is encasing string values in double quotes instead of single quotes');\r\n      }\r\n    }\r\n  },\r\n\r\n  _cleanParams: function () {\r\n    delete this.params.returnIdsOnly;\r\n    delete this.params.returnExtentOnly;\r\n    delete this.params.returnCountOnly;\r\n  },\r\n\r\n  _setGeometryParams: function (geometry) {\r\n    this.params.inSR = 4326;\r\n    var converted = (0,_Util__WEBPACK_IMPORTED_MODULE_2__._setGeometry)(geometry);\r\n    this.params.geometry = converted.geometry;\r\n    this.params.geometryType = converted.geometryType;\r\n  }\r\n\r\n});\r\n\r\nfunction query (options) {\r\n  return new Query(options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (query);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Tasks/Query.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Tasks/Task.js":
/*!*****************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Tasks/Task.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Task\": () => (/* binding */ Task),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"task\": () => (/* binding */ task)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _Request__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Request */ \"./node_modules/esri-leaflet/src/Request.js\");\n\r\n\r\n\r\n\r\n\r\nvar Task = leaflet__WEBPACK_IMPORTED_MODULE_0__.Class.extend({\r\n\r\n  options: {\r\n    proxy: false,\r\n    useCors: _Support__WEBPACK_IMPORTED_MODULE_1__.cors\r\n  },\r\n\r\n  // Generate a method for each methodName:paramName in the setters for this task.\r\n  generateSetter: function (param, context) {\r\n    return leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function (value) {\r\n      this.params[param] = value;\r\n      return this;\r\n    }, context);\r\n  },\r\n\r\n  initialize: function (endpoint) {\r\n    // endpoint can be either a url (and options) for an ArcGIS Rest Service or an instance of EsriLeaflet.Service\r\n    if (endpoint.request && endpoint.options) {\r\n      this._service = endpoint;\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.setOptions(this, endpoint.options);\r\n    } else {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.setOptions(this, endpoint);\r\n      this.options.url = (0,_Util__WEBPACK_IMPORTED_MODULE_2__.cleanUrl)(endpoint.url);\r\n    }\r\n\r\n    // clone default params into this object\r\n    this.params = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.extend({}, this.params || {});\r\n\r\n    // generate setter methods based on the setters object implimented a child class\r\n    if (this.setters) {\r\n      for (var setter in this.setters) {\r\n        var param = this.setters[setter];\r\n        this[setter] = this.generateSetter(param, this);\r\n      }\r\n    }\r\n  },\r\n\r\n  token: function (token) {\r\n    if (this._service) {\r\n      this._service.authenticate(token);\r\n    } else {\r\n      this.params.token = token;\r\n    }\r\n    return this;\r\n  },\r\n\r\n  apikey: function (apikey) {\r\n    return this.token(apikey);\r\n  },\r\n\r\n  // ArcGIS Server Find/Identify 10.5+\r\n  format: function (boolean) {\r\n    // use double negative to expose a more intuitive positive method name\r\n    this.params.returnUnformattedValues = !boolean;\r\n    return this;\r\n  },\r\n\r\n  request: function (callback, context) {\r\n    if (this.options.requestParams) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.extend(this.params, this.options.requestParams);\r\n    }\r\n    if (this._service) {\r\n      return this._service.request(this.path, this.params, callback, context);\r\n    }\r\n\r\n    return this._request('request', this.path, this.params, callback, context);\r\n  },\r\n\r\n  _request: function (method, path, params, callback, context) {\r\n    var url = (this.options.proxy) ? this.options.proxy + '?' + this.options.url + path : this.options.url + path;\r\n\r\n    if ((method === 'get' || method === 'request') && !this.options.useCors) {\r\n      return _Request__WEBPACK_IMPORTED_MODULE_3__[\"default\"].get.JSONP(url, params, callback, context);\r\n    }\r\n\r\n    return _Request__WEBPACK_IMPORTED_MODULE_3__[\"default\"][method](url, params, callback, context);\r\n  }\r\n});\r\n\r\nfunction task (options) {\r\n  options = (0,_Util__WEBPACK_IMPORTED_MODULE_2__.getUrlParams)(options);\r\n  return new Task(options);\r\n}\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (task);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Tasks/Task.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Util.js":
/*!***********************************************!*\
  !*** ./node_modules/esri-leaflet/src/Util.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"EsriUtil\": () => (/* binding */ EsriUtil),\n/* harmony export */   \"_findIdAttributeFromFeature\": () => (/* binding */ _findIdAttributeFromFeature),\n/* harmony export */   \"_findIdAttributeFromResponse\": () => (/* binding */ _findIdAttributeFromResponse),\n/* harmony export */   \"_getAttributionData\": () => (/* binding */ _getAttributionData),\n/* harmony export */   \"_setGeometry\": () => (/* binding */ _setGeometry),\n/* harmony export */   \"_updateMapAttribution\": () => (/* binding */ _updateMapAttribution),\n/* harmony export */   \"arcgisToGeoJSON\": () => (/* binding */ arcgisToGeoJSON),\n/* harmony export */   \"boundsToExtent\": () => (/* binding */ boundsToExtent),\n/* harmony export */   \"calcAttributionWidth\": () => (/* binding */ calcAttributionWidth),\n/* harmony export */   \"cleanUrl\": () => (/* binding */ cleanUrl),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"extentToBounds\": () => (/* binding */ extentToBounds),\n/* harmony export */   \"geojsonToArcGIS\": () => (/* binding */ geojsonToArcGIS),\n/* harmony export */   \"geojsonTypeToArcGIS\": () => (/* binding */ geojsonTypeToArcGIS),\n/* harmony export */   \"getUrlParams\": () => (/* binding */ getUrlParams),\n/* harmony export */   \"isArcgisOnline\": () => (/* binding */ isArcgisOnline),\n/* harmony export */   \"removeEsriAttribution\": () => (/* binding */ removeEsriAttribution),\n/* harmony export */   \"responseToFeatureCollection\": () => (/* binding */ responseToFeatureCollection),\n/* harmony export */   \"setEsriAttribution\": () => (/* binding */ setEsriAttribution),\n/* harmony export */   \"warn\": () => (/* reexport safe */ _Request__WEBPACK_IMPORTED_MODULE_1__.warn)\n/* harmony export */ });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Request__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Request */ \"./node_modules/esri-leaflet/src/Request.js\");\n/* harmony import */ var _Options__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options */ \"./node_modules/esri-leaflet/src/Options.js\");\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n/* harmony import */ var _terraformer_arcgis__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @terraformer/arcgis */ \"./node_modules/@terraformer/arcgis/dist/t-arcgis.esm.js\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nvar BASE_LEAFLET_ATTRIBUTION_STRING = '<a href=\"http://leafletjs.com\" title=\"A JS library for interactive maps\">Leaflet</a>';\r\nvar POWERED_BY_ESRI_ATTRIBUTION_STRING = 'Powered by <a href=\"https://www.esri.com\">Esri</a>';\r\n\r\nfunction geojsonToArcGIS (geojson, idAttr) {\r\n  return (0,_terraformer_arcgis__WEBPACK_IMPORTED_MODULE_4__.geojsonToArcGIS)(geojson, idAttr);\r\n}\r\n\r\nfunction arcgisToGeoJSON (arcgis, idAttr) {\r\n  return (0,_terraformer_arcgis__WEBPACK_IMPORTED_MODULE_4__.arcgisToGeoJSON)(arcgis, idAttr);\r\n}\r\n\r\n// convert an extent (ArcGIS) to LatLngBounds (Leaflet)\r\nfunction extentToBounds (extent) {\r\n  // \"NaN\" coordinates from ArcGIS Server indicate a null geometry\r\n  if (extent.xmin !== 'NaN' && extent.ymin !== 'NaN' && extent.xmax !== 'NaN' && extent.ymax !== 'NaN') {\r\n    var sw = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLng)(extent.ymin, extent.xmin);\r\n    var ne = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLng)(extent.ymax, extent.xmax);\r\n    return (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLngBounds)(sw, ne);\r\n  } else {\r\n    return null;\r\n  }\r\n}\r\n\r\n// convert an LatLngBounds (Leaflet) to extent (ArcGIS)\r\nfunction boundsToExtent (bounds) {\r\n  bounds = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLngBounds)(bounds);\r\n  return {\r\n    xmin: bounds.getSouthWest().lng,\r\n    ymin: bounds.getSouthWest().lat,\r\n    xmax: bounds.getNorthEast().lng,\r\n    ymax: bounds.getNorthEast().lat,\r\n    spatialReference: {\r\n      wkid: 4326\r\n    }\r\n  };\r\n}\r\n\r\nvar knownFieldNames = /^(OBJECTID|FID|OID|ID)$/i;\r\n\r\n// Attempts to find the ID Field from response\r\nfunction _findIdAttributeFromResponse (response) {\r\n  var result;\r\n\r\n  if (response.objectIdFieldName) {\r\n    // Find Id Field directly\r\n    result = response.objectIdFieldName;\r\n  } else if (response.fields) {\r\n    // Find ID Field based on field type\r\n    for (var j = 0; j <= response.fields.length - 1; j++) {\r\n      if (response.fields[j].type === 'esriFieldTypeOID') {\r\n        result = response.fields[j].name;\r\n        break;\r\n      }\r\n    }\r\n    if (!result) {\r\n      // If no field was marked as being the esriFieldTypeOID try well known field names\r\n      for (j = 0; j <= response.fields.length - 1; j++) {\r\n        if (response.fields[j].name.match(knownFieldNames)) {\r\n          result = response.fields[j].name;\r\n          break;\r\n        }\r\n      }\r\n    }\r\n  }\r\n  return result;\r\n}\r\n\r\n// This is the 'last' resort, find the Id field from the specified feature\r\nfunction _findIdAttributeFromFeature (feature) {\r\n  for (var key in feature.attributes) {\r\n    if (key.match(knownFieldNames)) {\r\n      return key;\r\n    }\r\n  }\r\n}\r\n\r\nfunction responseToFeatureCollection (response, idAttribute) {\r\n  var objectIdField;\r\n  var features = response.features || response.results;\r\n  var count = features && features.length;\r\n\r\n  if (idAttribute) {\r\n    objectIdField = idAttribute;\r\n  } else {\r\n    objectIdField = _findIdAttributeFromResponse(response);\r\n  }\r\n\r\n  var featureCollection = {\r\n    type: 'FeatureCollection',\r\n    features: []\r\n  };\r\n\r\n  if (count) {\r\n    for (var i = features.length - 1; i >= 0; i--) {\r\n      var feature = arcgisToGeoJSON(features[i], objectIdField || _findIdAttributeFromFeature(features[i]));\r\n      featureCollection.features.push(feature);\r\n    }\r\n  }\r\n\r\n  return featureCollection;\r\n}\r\n\r\n// trim url whitespace and add a trailing slash if needed\r\nfunction cleanUrl (url) {\r\n  // trim leading and trailing spaces, but not spaces inside the url\r\n  url = leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.trim(url);\r\n\r\n  // add a trailing slash to the url if the user omitted it\r\n  if (url[url.length - 1] !== '/') {\r\n    url += '/';\r\n  }\r\n\r\n  return url;\r\n}\r\n\r\n/* Extract url params if any and store them in requestParams attribute.\r\n   Return the options params updated */\r\nfunction getUrlParams (options) {\r\n  if (options.url.indexOf('?') !== -1) {\r\n    options.requestParams = options.requestParams || {};\r\n    var queryString = options.url.substring(options.url.indexOf('?') + 1);\r\n    options.url = options.url.split('?')[0];\r\n    options.requestParams = JSON.parse('{\"' + decodeURI(queryString).replace(/\"/g, '\\\\\"').replace(/&/g, '\",\"').replace(/=/g, '\":\"') + '\"}');\r\n  }\r\n  options.url = cleanUrl(options.url.split('?')[0]);\r\n  return options;\r\n}\r\n\r\nfunction isArcgisOnline (url) {\r\n  /* hosted feature services support geojson as an output format\r\n  utility.arcgis.com services are proxied from a variety of ArcGIS Server vintages, and may not */\r\n  return (/^(?!.*utility\\.arcgis\\.com).*\\.arcgis\\.com.*FeatureServer/i).test(url);\r\n}\r\n\r\nfunction geojsonTypeToArcGIS (geoJsonType) {\r\n  var arcgisGeometryType;\r\n  switch (geoJsonType) {\r\n    case 'Point':\r\n      arcgisGeometryType = 'esriGeometryPoint';\r\n      break;\r\n    case 'MultiPoint':\r\n      arcgisGeometryType = 'esriGeometryMultipoint';\r\n      break;\r\n    case 'LineString':\r\n      arcgisGeometryType = 'esriGeometryPolyline';\r\n      break;\r\n    case 'MultiLineString':\r\n      arcgisGeometryType = 'esriGeometryPolyline';\r\n      break;\r\n    case 'Polygon':\r\n      arcgisGeometryType = 'esriGeometryPolygon';\r\n      break;\r\n    case 'MultiPolygon':\r\n      arcgisGeometryType = 'esriGeometryPolygon';\r\n      break;\r\n  }\r\n\r\n  return arcgisGeometryType;\r\n}\r\n\r\nfunction calcAttributionWidth (map) {\r\n  // either crop at 55px or user defined buffer\r\n  return (map.getSize().x - _Options__WEBPACK_IMPORTED_MODULE_2__.options.attributionWidthOffset) + 'px';\r\n}\r\n\r\nfunction setEsriAttribution (map) {\r\n  if (!map.attributionControl) {\r\n    return;\r\n  }\r\n\r\n  if (!map.attributionControl._esriAttributionLayerCount) {\r\n    map.attributionControl._esriAttributionLayerCount = 0;\r\n  }\r\n\r\n  if (map.attributionControl._esriAttributionLayerCount === 0) {\r\n    // Dynamically creating the CSS rules, only run this once per page load:\r\n    if (!map.attributionControl._esriAttributionAddedOnce) {\r\n      var hoverAttributionStyle = document.createElement('style');\r\n      hoverAttributionStyle.type = 'text/css';\r\n      hoverAttributionStyle.innerHTML = '.esri-truncated-attribution:hover {' +\r\n        'white-space: normal;' +\r\n      '}';\r\n      document.getElementsByTagName('head')[0].appendChild(hoverAttributionStyle);\r\n\r\n      // define a new css class in JS to trim attribution into a single line\r\n      var attributionStyle = document.createElement('style');\r\n      attributionStyle.type = 'text/css';\r\n      attributionStyle.innerHTML = '.esri-truncated-attribution {' +\r\n        'vertical-align: -3px;' +\r\n        'white-space: nowrap;' +\r\n        'overflow: hidden;' +\r\n        'text-overflow: ellipsis;' +\r\n        'display: inline-block;' +\r\n        'transition: 0s white-space;' +\r\n        'transition-delay: 1s;' +\r\n        'max-width: ' + calcAttributionWidth(map) + ';' +\r\n      '}';\r\n      document.getElementsByTagName('head')[0].appendChild(attributionStyle);\r\n\r\n      // update the width used to truncate when the map itself is resized\r\n      map.on('resize', function (e) {\r\n        if (map.attributionControl) {\r\n          map.attributionControl._container.style.maxWidth = calcAttributionWidth(e.target);\r\n        }\r\n      });\r\n\r\n      map.attributionControl._esriAttributionAddedOnce = true;\r\n    }\r\n\r\n    map.attributionControl.setPrefix(BASE_LEAFLET_ATTRIBUTION_STRING + ' | ' + POWERED_BY_ESRI_ATTRIBUTION_STRING);\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.DomUtil.addClass(map.attributionControl._container, 'esri-truncated-attribution:hover');\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.DomUtil.addClass(map.attributionControl._container, 'esri-truncated-attribution');\r\n  }\r\n\r\n  // Track the number of esri-leaflet layers that are on the map so we can know when we can remove the attribution (below in removeEsriAttribution)\r\n  map.attributionControl._esriAttributionLayerCount = map.attributionControl._esriAttributionLayerCount + 1;\r\n}\r\n\r\nfunction removeEsriAttribution (map) {\r\n  if (!map.attributionControl) {\r\n    return;\r\n  }\r\n\r\n  // Only remove the attribution if we're about to remove the LAST esri-leaflet layer (_esriAttributionLayerCount)\r\n  if (map.attributionControl._esriAttributionLayerCount && map.attributionControl._esriAttributionLayerCount === 1) {\r\n    map.attributionControl.setPrefix(BASE_LEAFLET_ATTRIBUTION_STRING);\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.DomUtil.removeClass(map.attributionControl._container, 'esri-truncated-attribution:hover');\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__.DomUtil.removeClass(map.attributionControl._container, 'esri-truncated-attribution');\r\n  }\r\n  map.attributionControl._esriAttributionLayerCount = map.attributionControl._esriAttributionLayerCount - 1;\r\n}\r\n\r\nfunction _setGeometry (geometry) {\r\n  var params = {\r\n    geometry: null,\r\n    geometryType: null\r\n  };\r\n\r\n  // convert bounds to extent and finish\r\n  if (geometry instanceof leaflet__WEBPACK_IMPORTED_MODULE_0__.LatLngBounds) {\r\n    // set geometry + geometryType\r\n    params.geometry = boundsToExtent(geometry);\r\n    params.geometryType = 'esriGeometryEnvelope';\r\n    return params;\r\n  }\r\n\r\n  // convert L.Marker > L.LatLng\r\n  if (geometry.getLatLng) {\r\n    geometry = geometry.getLatLng();\r\n  }\r\n\r\n  // convert L.LatLng to a geojson point and continue;\r\n  if (geometry instanceof leaflet__WEBPACK_IMPORTED_MODULE_0__.LatLng) {\r\n    geometry = {\r\n      type: 'Point',\r\n      coordinates: [geometry.lng, geometry.lat]\r\n    };\r\n  }\r\n\r\n  // handle L.GeoJSON, pull out the first geometry\r\n  if (geometry instanceof leaflet__WEBPACK_IMPORTED_MODULE_0__.GeoJSON) {\r\n    // reassign geometry to the GeoJSON value  (we are assuming that only one feature is present)\r\n    geometry = geometry.getLayers()[0].feature.geometry;\r\n    params.geometry = geojsonToArcGIS(geometry);\r\n    params.geometryType = geojsonTypeToArcGIS(geometry.type);\r\n  }\r\n\r\n  // Handle L.Polyline and L.Polygon\r\n  if (geometry.toGeoJSON) {\r\n    geometry = geometry.toGeoJSON();\r\n  }\r\n\r\n  // handle GeoJSON feature by pulling out the geometry\r\n  if (geometry.type === 'Feature') {\r\n    // get the geometry of the geojson feature\r\n    geometry = geometry.geometry;\r\n  }\r\n\r\n  // confirm that our GeoJSON is a point, line or polygon\r\n  if (geometry.type === 'Point' || geometry.type === 'LineString' || geometry.type === 'Polygon' || geometry.type === 'MultiPolygon') {\r\n    params.geometry = geojsonToArcGIS(geometry);\r\n    params.geometryType = geojsonTypeToArcGIS(geometry.type);\r\n    return params;\r\n  }\r\n\r\n  // warn the user if we havn't found an appropriate object\r\n  (0,_Request__WEBPACK_IMPORTED_MODULE_1__.warn)('invalid geometry passed to spatial query. Should be L.LatLng, L.LatLngBounds, L.Marker or a GeoJSON Point, Line, Polygon or MultiPolygon object');\r\n}\r\n\r\nfunction _getAttributionData (url, map) {\r\n  if (_Support__WEBPACK_IMPORTED_MODULE_3__.Support.cors) {\r\n    (0,_Request__WEBPACK_IMPORTED_MODULE_1__.request)(url, {}, leaflet__WEBPACK_IMPORTED_MODULE_0__.Util.bind(function (error, attributions) {\r\n      if (error) { return; }\r\n      map._esriAttributions = [];\r\n      for (var c = 0; c < attributions.contributors.length; c++) {\r\n        var contributor = attributions.contributors[c];\r\n\r\n        for (var i = 0; i < contributor.coverageAreas.length; i++) {\r\n          var coverageArea = contributor.coverageAreas[i];\r\n          var southWest = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLng)(coverageArea.bbox[0], coverageArea.bbox[1]);\r\n          var northEast = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLng)(coverageArea.bbox[2], coverageArea.bbox[3]);\r\n          map._esriAttributions.push({\r\n            attribution: contributor.attribution,\r\n            score: coverageArea.score,\r\n            bounds: (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLngBounds)(southWest, northEast),\r\n            minZoom: coverageArea.zoomMin,\r\n            maxZoom: coverageArea.zoomMax\r\n          });\r\n        }\r\n      }\r\n\r\n      map._esriAttributions.sort(function (a, b) {\r\n        return b.score - a.score;\r\n      });\r\n\r\n      // pass the same argument as the map's 'moveend' event\r\n      var obj = { target: map };\r\n      _updateMapAttribution(obj);\r\n    }, this));\r\n  }\r\n}\r\n\r\nfunction _updateMapAttribution (evt) {\r\n  var map = evt.target;\r\n  var oldAttributions = map._esriAttributions;\r\n\r\n  if (!map || !map.attributionControl) return;\r\n\r\n  var attributionElement = map.attributionControl._container.querySelector('.esri-dynamic-attribution');\r\n\r\n  if (attributionElement && oldAttributions) {\r\n    var newAttributions = '';\r\n    var bounds = map.getBounds();\r\n    var wrappedBounds = (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.latLngBounds)(\r\n      bounds.getSouthWest().wrap(),\r\n      bounds.getNorthEast().wrap()\r\n    );\r\n    var zoom = map.getZoom();\r\n\r\n    for (var i = 0; i < oldAttributions.length; i++) {\r\n      var attribution = oldAttributions[i];\r\n      var text = attribution.attribution;\r\n\r\n      if (!newAttributions.match(text) && attribution.bounds.intersects(wrappedBounds) && zoom >= attribution.minZoom && zoom <= attribution.maxZoom) {\r\n        newAttributions += (', ' + text);\r\n      }\r\n    }\r\n\r\n    newAttributions = newAttributions.substr(2);\r\n    attributionElement.innerHTML = newAttributions;\r\n    attributionElement.style.maxWidth = calcAttributionWidth(map);\r\n\r\n    map.fire('attributionupdated', {\r\n      attribution: newAttributions\r\n    });\r\n  }\r\n}\r\n\r\n// for backwards compatibility\r\n\r\n\r\nvar EsriUtil = {\r\n  warn: _Request__WEBPACK_IMPORTED_MODULE_1__.warn,\r\n  cleanUrl: cleanUrl,\r\n  getUrlParams: getUrlParams,\r\n  isArcgisOnline: isArcgisOnline,\r\n  geojsonTypeToArcGIS: geojsonTypeToArcGIS,\r\n  responseToFeatureCollection: responseToFeatureCollection,\r\n  geojsonToArcGIS: geojsonToArcGIS,\r\n  arcgisToGeoJSON: arcgisToGeoJSON,\r\n  boundsToExtent: boundsToExtent,\r\n  extentToBounds: extentToBounds,\r\n  calcAttributionWidth: calcAttributionWidth,\r\n  setEsriAttribution: setEsriAttribution,\r\n  _setGeometry: _setGeometry,\r\n  _getAttributionData: _getAttributionData,\r\n  _updateMapAttribution: _updateMapAttribution,\r\n  _findIdAttributeFromFeature: _findIdAttributeFromFeature,\r\n  _findIdAttributeFromResponse: _findIdAttributeFromResponse\r\n};\r\n\r\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EsriUtil);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Util.js\n");

/***/ }),

/***/ "./node_modules/leaflet/dist/leaflet-src.js":
/*!**************************************************!*\
  !*** ./node_modules/leaflet/dist/leaflet-src.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, exports) {

eval("/* @preserve\n * Leaflet 1.9.3, a JS library for interactive maps. https://leafletjs.com\n * (c) 2010-2022 Vladimir Agafonkin, (c) 2010-2011 CloudMade\n */\n\n(function (global, factory) {\n   true ? factory(exports) :\n  0;\n})(this, (function (exports) { 'use strict';\n\n  var version = \"1.9.3\";\n\n  /*\r\n   * @namespace Util\r\n   *\r\n   * Various utility functions, used by Leaflet internally.\r\n   */\r\n\r\n  // @function extend(dest: Object, src?: Object): Object\r\n  // Merges the properties of the `src` object (or multiple objects) into `dest` object and returns the latter. Has an `L.extend` shortcut.\r\n  function extend(dest) {\r\n  \tvar i, j, len, src;\r\n\r\n  \tfor (j = 1, len = arguments.length; j < len; j++) {\r\n  \t\tsrc = arguments[j];\r\n  \t\tfor (i in src) {\r\n  \t\t\tdest[i] = src[i];\r\n  \t\t}\r\n  \t}\r\n  \treturn dest;\r\n  }\r\n\r\n  // @function create(proto: Object, properties?: Object): Object\r\n  // Compatibility polyfill for [Object.create](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/create)\r\n  var create$2 = Object.create || (function () {\r\n  \tfunction F() {}\r\n  \treturn function (proto) {\r\n  \t\tF.prototype = proto;\r\n  \t\treturn new F();\r\n  \t};\r\n  })();\r\n\r\n  // @function bind(fn: Function, …): Function\r\n  // Returns a new function bound to the arguments passed, like [Function.prototype.bind](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Function/bind).\r\n  // Has a `L.bind()` shortcut.\r\n  function bind(fn, obj) {\r\n  \tvar slice = Array.prototype.slice;\r\n\r\n  \tif (fn.bind) {\r\n  \t\treturn fn.bind.apply(fn, slice.call(arguments, 1));\r\n  \t}\r\n\r\n  \tvar args = slice.call(arguments, 2);\r\n\r\n  \treturn function () {\r\n  \t\treturn fn.apply(obj, args.length ? args.concat(slice.call(arguments)) : arguments);\r\n  \t};\r\n  }\r\n\r\n  // @property lastId: Number\r\n  // Last unique ID used by [`stamp()`](#util-stamp)\r\n  var lastId = 0;\r\n\r\n  // @function stamp(obj: Object): Number\r\n  // Returns the unique ID of an object, assigning it one if it doesn't have it.\r\n  function stamp(obj) {\r\n  \tif (!('_leaflet_id' in obj)) {\r\n  \t\tobj['_leaflet_id'] = ++lastId;\r\n  \t}\r\n  \treturn obj._leaflet_id;\r\n  }\r\n\r\n  // @function throttle(fn: Function, time: Number, context: Object): Function\r\n  // Returns a function which executes function `fn` with the given scope `context`\r\n  // (so that the `this` keyword refers to `context` inside `fn`'s code). The function\r\n  // `fn` will be called no more than one time per given amount of `time`. The arguments\r\n  // received by the bound function will be any arguments passed when binding the\r\n  // function, followed by any arguments passed when invoking the bound function.\r\n  // Has an `L.throttle` shortcut.\r\n  function throttle(fn, time, context) {\r\n  \tvar lock, args, wrapperFn, later;\r\n\r\n  \tlater = function () {\r\n  \t\t// reset lock and call if queued\r\n  \t\tlock = false;\r\n  \t\tif (args) {\r\n  \t\t\twrapperFn.apply(context, args);\r\n  \t\t\targs = false;\r\n  \t\t}\r\n  \t};\r\n\r\n  \twrapperFn = function () {\r\n  \t\tif (lock) {\r\n  \t\t\t// called too soon, queue to call later\r\n  \t\t\targs = arguments;\r\n\r\n  \t\t} else {\r\n  \t\t\t// call and lock until later\r\n  \t\t\tfn.apply(context, arguments);\r\n  \t\t\tsetTimeout(later, time);\r\n  \t\t\tlock = true;\r\n  \t\t}\r\n  \t};\r\n\r\n  \treturn wrapperFn;\r\n  }\r\n\r\n  // @function wrapNum(num: Number, range: Number[], includeMax?: Boolean): Number\r\n  // Returns the number `num` modulo `range` in such a way so it lies within\r\n  // `range[0]` and `range[1]`. The returned value will be always smaller than\r\n  // `range[1]` unless `includeMax` is set to `true`.\r\n  function wrapNum(x, range, includeMax) {\r\n  \tvar max = range[1],\r\n  \t    min = range[0],\r\n  \t    d = max - min;\r\n  \treturn x === max && includeMax ? x : ((x - min) % d + d) % d + min;\r\n  }\r\n\r\n  // @function falseFn(): Function\r\n  // Returns a function which always returns `false`.\r\n  function falseFn() { return false; }\r\n\r\n  // @function formatNum(num: Number, precision?: Number|false): Number\r\n  // Returns the number `num` rounded with specified `precision`.\r\n  // The default `precision` value is 6 decimal places.\r\n  // `false` can be passed to skip any processing (can be useful to avoid round-off errors).\r\n  function formatNum(num, precision) {\r\n  \tif (precision === false) { return num; }\r\n  \tvar pow = Math.pow(10, precision === undefined ? 6 : precision);\r\n  \treturn Math.round(num * pow) / pow;\r\n  }\r\n\r\n  // @function trim(str: String): String\r\n  // Compatibility polyfill for [String.prototype.trim](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String/Trim)\r\n  function trim(str) {\r\n  \treturn str.trim ? str.trim() : str.replace(/^\\s+|\\s+$/g, '');\r\n  }\r\n\r\n  // @function splitWords(str: String): String[]\r\n  // Trims and splits the string on whitespace and returns the array of parts.\r\n  function splitWords(str) {\r\n  \treturn trim(str).split(/\\s+/);\r\n  }\r\n\r\n  // @function setOptions(obj: Object, options: Object): Object\r\n  // Merges the given properties to the `options` of the `obj` object, returning the resulting options. See `Class options`. Has an `L.setOptions` shortcut.\r\n  function setOptions(obj, options) {\r\n  \tif (!Object.prototype.hasOwnProperty.call(obj, 'options')) {\r\n  \t\tobj.options = obj.options ? create$2(obj.options) : {};\r\n  \t}\r\n  \tfor (var i in options) {\r\n  \t\tobj.options[i] = options[i];\r\n  \t}\r\n  \treturn obj.options;\r\n  }\r\n\r\n  // @function getParamString(obj: Object, existingUrl?: String, uppercase?: Boolean): String\r\n  // Converts an object into a parameter URL string, e.g. `{a: \"foo\", b: \"bar\"}`\r\n  // translates to `'?a=foo&b=bar'`. If `existingUrl` is set, the parameters will\r\n  // be appended at the end. If `uppercase` is `true`, the parameter names will\r\n  // be uppercased (e.g. `'?A=foo&B=bar'`)\r\n  function getParamString(obj, existingUrl, uppercase) {\r\n  \tvar params = [];\r\n  \tfor (var i in obj) {\r\n  \t\tparams.push(encodeURIComponent(uppercase ? i.toUpperCase() : i) + '=' + encodeURIComponent(obj[i]));\r\n  \t}\r\n  \treturn ((!existingUrl || existingUrl.indexOf('?') === -1) ? '?' : '&') + params.join('&');\r\n  }\r\n\r\n  var templateRe = /\\{ *([\\w_ -]+) *\\}/g;\r\n\r\n  // @function template(str: String, data: Object): String\r\n  // Simple templating facility, accepts a template string of the form `'Hello {a}, {b}'`\r\n  // and a data object like `{a: 'foo', b: 'bar'}`, returns evaluated string\r\n  // `('Hello foo, bar')`. You can also specify functions instead of strings for\r\n  // data values — they will be evaluated passing `data` as an argument.\r\n  function template(str, data) {\r\n  \treturn str.replace(templateRe, function (str, key) {\r\n  \t\tvar value = data[key];\r\n\r\n  \t\tif (value === undefined) {\r\n  \t\t\tthrow new Error('No value provided for variable ' + str);\r\n\r\n  \t\t} else if (typeof value === 'function') {\r\n  \t\t\tvalue = value(data);\r\n  \t\t}\r\n  \t\treturn value;\r\n  \t});\r\n  }\r\n\r\n  // @function isArray(obj): Boolean\r\n  // Compatibility polyfill for [Array.isArray](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array/isArray)\r\n  var isArray = Array.isArray || function (obj) {\r\n  \treturn (Object.prototype.toString.call(obj) === '[object Array]');\r\n  };\r\n\r\n  // @function indexOf(array: Array, el: Object): Number\r\n  // Compatibility polyfill for [Array.prototype.indexOf](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf)\r\n  function indexOf(array, el) {\r\n  \tfor (var i = 0; i < array.length; i++) {\r\n  \t\tif (array[i] === el) { return i; }\r\n  \t}\r\n  \treturn -1;\r\n  }\r\n\r\n  // @property emptyImageUrl: String\r\n  // Data URI string containing a base64-encoded empty GIF image.\r\n  // Used as a hack to free memory from unused images on WebKit-powered\r\n  // mobile devices (by setting image `src` to this string).\r\n  var emptyImageUrl = 'data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=';\r\n\r\n  // inspired by https://paulirish.com/2011/requestanimationframe-for-smart-animating/\r\n\r\n  function getPrefixed(name) {\r\n  \treturn window['webkit' + name] || window['moz' + name] || window['ms' + name];\r\n  }\r\n\r\n  var lastTime = 0;\r\n\r\n  // fallback for IE 7-8\r\n  function timeoutDefer(fn) {\r\n  \tvar time = +new Date(),\r\n  \t    timeToCall = Math.max(0, 16 - (time - lastTime));\r\n\r\n  \tlastTime = time + timeToCall;\r\n  \treturn window.setTimeout(fn, timeToCall);\r\n  }\r\n\r\n  var requestFn = window.requestAnimationFrame || getPrefixed('RequestAnimationFrame') || timeoutDefer;\r\n  var cancelFn = window.cancelAnimationFrame || getPrefixed('CancelAnimationFrame') ||\r\n  \t\tgetPrefixed('CancelRequestAnimationFrame') || function (id) { window.clearTimeout(id); };\r\n\r\n  // @function requestAnimFrame(fn: Function, context?: Object, immediate?: Boolean): Number\r\n  // Schedules `fn` to be executed when the browser repaints. `fn` is bound to\r\n  // `context` if given. When `immediate` is set, `fn` is called immediately if\r\n  // the browser doesn't have native support for\r\n  // [`window.requestAnimationFrame`](https://developer.mozilla.org/docs/Web/API/window/requestAnimationFrame),\r\n  // otherwise it's delayed. Returns a request ID that can be used to cancel the request.\r\n  function requestAnimFrame(fn, context, immediate) {\r\n  \tif (immediate && requestFn === timeoutDefer) {\r\n  \t\tfn.call(context);\r\n  \t} else {\r\n  \t\treturn requestFn.call(window, bind(fn, context));\r\n  \t}\r\n  }\r\n\r\n  // @function cancelAnimFrame(id: Number): undefined\r\n  // Cancels a previous `requestAnimFrame`. See also [window.cancelAnimationFrame](https://developer.mozilla.org/docs/Web/API/window/cancelAnimationFrame).\r\n  function cancelAnimFrame(id) {\r\n  \tif (id) {\r\n  \t\tcancelFn.call(window, id);\r\n  \t}\r\n  }\n\n  var Util = {\n    __proto__: null,\n    extend: extend,\n    create: create$2,\n    bind: bind,\n    get lastId () { return lastId; },\n    stamp: stamp,\n    throttle: throttle,\n    wrapNum: wrapNum,\n    falseFn: falseFn,\n    formatNum: formatNum,\n    trim: trim,\n    splitWords: splitWords,\n    setOptions: setOptions,\n    getParamString: getParamString,\n    template: template,\n    isArray: isArray,\n    indexOf: indexOf,\n    emptyImageUrl: emptyImageUrl,\n    requestFn: requestFn,\n    cancelFn: cancelFn,\n    requestAnimFrame: requestAnimFrame,\n    cancelAnimFrame: cancelAnimFrame\n  };\n\n  // @class Class\r\n  // @aka L.Class\r\n\r\n  // @section\r\n  // @uninheritable\r\n\r\n  // Thanks to John Resig and Dean Edwards for inspiration!\r\n\r\n  function Class() {}\r\n\r\n  Class.extend = function (props) {\r\n\r\n  \t// @function extend(props: Object): Function\r\n  \t// [Extends the current class](#class-inheritance) given the properties to be included.\r\n  \t// Returns a Javascript function that is a class constructor (to be called with `new`).\r\n  \tvar NewClass = function () {\r\n\r\n  \t\tsetOptions(this);\r\n\r\n  \t\t// call the constructor\r\n  \t\tif (this.initialize) {\r\n  \t\t\tthis.initialize.apply(this, arguments);\r\n  \t\t}\r\n\r\n  \t\t// call all constructor hooks\r\n  \t\tthis.callInitHooks();\r\n  \t};\r\n\r\n  \tvar parentProto = NewClass.__super__ = this.prototype;\r\n\r\n  \tvar proto = create$2(parentProto);\r\n  \tproto.constructor = NewClass;\r\n\r\n  \tNewClass.prototype = proto;\r\n\r\n  \t// inherit parent's statics\r\n  \tfor (var i in this) {\r\n  \t\tif (Object.prototype.hasOwnProperty.call(this, i) && i !== 'prototype' && i !== '__super__') {\r\n  \t\t\tNewClass[i] = this[i];\r\n  \t\t}\r\n  \t}\r\n\r\n  \t// mix static properties into the class\r\n  \tif (props.statics) {\r\n  \t\textend(NewClass, props.statics);\r\n  \t}\r\n\r\n  \t// mix includes into the prototype\r\n  \tif (props.includes) {\r\n  \t\tcheckDeprecatedMixinEvents(props.includes);\r\n  \t\textend.apply(null, [proto].concat(props.includes));\r\n  \t}\r\n\r\n  \t// mix given properties into the prototype\r\n  \textend(proto, props);\r\n  \tdelete proto.statics;\r\n  \tdelete proto.includes;\r\n\r\n  \t// merge options\r\n  \tif (proto.options) {\r\n  \t\tproto.options = parentProto.options ? create$2(parentProto.options) : {};\r\n  \t\textend(proto.options, props.options);\r\n  \t}\r\n\r\n  \tproto._initHooks = [];\r\n\r\n  \t// add method for calling all hooks\r\n  \tproto.callInitHooks = function () {\r\n\r\n  \t\tif (this._initHooksCalled) { return; }\r\n\r\n  \t\tif (parentProto.callInitHooks) {\r\n  \t\t\tparentProto.callInitHooks.call(this);\r\n  \t\t}\r\n\r\n  \t\tthis._initHooksCalled = true;\r\n\r\n  \t\tfor (var i = 0, len = proto._initHooks.length; i < len; i++) {\r\n  \t\t\tproto._initHooks[i].call(this);\r\n  \t\t}\r\n  \t};\r\n\r\n  \treturn NewClass;\r\n  };\r\n\r\n\r\n  // @function include(properties: Object): this\r\n  // [Includes a mixin](#class-includes) into the current class.\r\n  Class.include = function (props) {\r\n  \tvar parentOptions = this.prototype.options;\r\n  \textend(this.prototype, props);\r\n  \tif (props.options) {\r\n  \t\tthis.prototype.options = parentOptions;\r\n  \t\tthis.mergeOptions(props.options);\r\n  \t}\r\n  \treturn this;\r\n  };\r\n\r\n  // @function mergeOptions(options: Object): this\r\n  // [Merges `options`](#class-options) into the defaults of the class.\r\n  Class.mergeOptions = function (options) {\r\n  \textend(this.prototype.options, options);\r\n  \treturn this;\r\n  };\r\n\r\n  // @function addInitHook(fn: Function): this\r\n  // Adds a [constructor hook](#class-constructor-hooks) to the class.\r\n  Class.addInitHook = function (fn) { // (Function) || (String, args...)\r\n  \tvar args = Array.prototype.slice.call(arguments, 1);\r\n\r\n  \tvar init = typeof fn === 'function' ? fn : function () {\r\n  \t\tthis[fn].apply(this, args);\r\n  \t};\r\n\r\n  \tthis.prototype._initHooks = this.prototype._initHooks || [];\r\n  \tthis.prototype._initHooks.push(init);\r\n  \treturn this;\r\n  };\r\n\r\n  function checkDeprecatedMixinEvents(includes) {\r\n  \t/* global L: true */\r\n  \tif (typeof L === 'undefined' || !L || !L.Mixin) { return; }\r\n\r\n  \tincludes = isArray(includes) ? includes : [includes];\r\n\r\n  \tfor (var i = 0; i < includes.length; i++) {\r\n  \t\tif (includes[i] === L.Mixin.Events) {\r\n  \t\t\tconsole.warn('Deprecated include of L.Mixin.Events: ' +\r\n  \t\t\t\t'this property will be removed in future releases, ' +\r\n  \t\t\t\t'please inherit from L.Evented instead.', new Error().stack);\r\n  \t\t}\r\n  \t}\r\n  }\n\n  /*\r\n   * @class Evented\r\n   * @aka L.Evented\r\n   * @inherits Class\r\n   *\r\n   * A set of methods shared between event-powered classes (like `Map` and `Marker`). Generally, events allow you to execute some function when something happens with an object (e.g. the user clicks on the map, causing the map to fire `'click'` event).\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * map.on('click', function(e) {\r\n   * \talert(e.latlng);\r\n   * } );\r\n   * ```\r\n   *\r\n   * Leaflet deals with event listeners by reference, so if you want to add a listener and then remove it, define it as a function:\r\n   *\r\n   * ```js\r\n   * function onClick(e) { ... }\r\n   *\r\n   * map.on('click', onClick);\r\n   * map.off('click', onClick);\r\n   * ```\r\n   */\r\n\r\n  var Events = {\r\n  \t/* @method on(type: String, fn: Function, context?: Object): this\r\n  \t * Adds a listener function (`fn`) to a particular event type of the object. You can optionally specify the context of the listener (object the this keyword will point to). You can also pass several space-separated types (e.g. `'click dblclick'`).\r\n  \t *\r\n  \t * @alternative\r\n  \t * @method on(eventMap: Object): this\r\n  \t * Adds a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`\r\n  \t */\r\n  \ton: function (types, fn, context) {\r\n\r\n  \t\t// types can be a map of types/handlers\r\n  \t\tif (typeof types === 'object') {\r\n  \t\t\tfor (var type in types) {\r\n  \t\t\t\t// we don't process space-separated events here for performance;\r\n  \t\t\t\t// it's a hot path since Layer uses the on(obj) syntax\r\n  \t\t\t\tthis._on(type, types[type], fn);\r\n  \t\t\t}\r\n\r\n  \t\t} else {\r\n  \t\t\t// types can be a string of space-separated words\r\n  \t\t\ttypes = splitWords(types);\r\n\r\n  \t\t\tfor (var i = 0, len = types.length; i < len; i++) {\r\n  \t\t\t\tthis._on(types[i], fn, context);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t/* @method off(type: String, fn?: Function, context?: Object): this\r\n  \t * Removes a previously added listener function. If no function is specified, it will remove all the listeners of that particular event from the object. Note that if you passed a custom context to `on`, you must pass the same context to `off` in order to remove the listener.\r\n  \t *\r\n  \t * @alternative\r\n  \t * @method off(eventMap: Object): this\r\n  \t * Removes a set of type/listener pairs.\r\n  \t *\r\n  \t * @alternative\r\n  \t * @method off: this\r\n  \t * Removes all listeners to all events on the object. This includes implicitly attached events.\r\n  \t */\r\n  \toff: function (types, fn, context) {\r\n\r\n  \t\tif (!arguments.length) {\r\n  \t\t\t// clear all listeners if called without arguments\r\n  \t\t\tdelete this._events;\r\n\r\n  \t\t} else if (typeof types === 'object') {\r\n  \t\t\tfor (var type in types) {\r\n  \t\t\t\tthis._off(type, types[type], fn);\r\n  \t\t\t}\r\n\r\n  \t\t} else {\r\n  \t\t\ttypes = splitWords(types);\r\n\r\n  \t\t\tvar removeAll = arguments.length === 1;\r\n  \t\t\tfor (var i = 0, len = types.length; i < len; i++) {\r\n  \t\t\t\tif (removeAll) {\r\n  \t\t\t\t\tthis._off(types[i]);\r\n  \t\t\t\t} else {\r\n  \t\t\t\t\tthis._off(types[i], fn, context);\r\n  \t\t\t\t}\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// attach listener (without syntactic sugar now)\r\n  \t_on: function (type, fn, context, _once) {\r\n  \t\tif (typeof fn !== 'function') {\r\n  \t\t\tconsole.warn('wrong listener type: ' + typeof fn);\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\t// check if fn already there\r\n  \t\tif (this._listens(type, fn, context) !== false) {\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tif (context === this) {\r\n  \t\t\t// Less memory footprint.\r\n  \t\t\tcontext = undefined;\r\n  \t\t}\r\n\r\n  \t\tvar newListener = {fn: fn, ctx: context};\r\n  \t\tif (_once) {\r\n  \t\t\tnewListener.once = true;\r\n  \t\t}\r\n\r\n  \t\tthis._events = this._events || {};\r\n  \t\tthis._events[type] = this._events[type] || [];\r\n  \t\tthis._events[type].push(newListener);\r\n  \t},\r\n\r\n  \t_off: function (type, fn, context) {\r\n  \t\tvar listeners,\r\n  \t\t    i,\r\n  \t\t    len;\r\n\r\n  \t\tif (!this._events) {\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tlisteners = this._events[type];\r\n  \t\tif (!listeners) {\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tif (arguments.length === 1) { // remove all\r\n  \t\t\tif (this._firingCount) {\r\n  \t\t\t\t// Set all removed listeners to noop\r\n  \t\t\t\t// so they are not called if remove happens in fire\r\n  \t\t\t\tfor (i = 0, len = listeners.length; i < len; i++) {\r\n  \t\t\t\t\tlisteners[i].fn = falseFn;\r\n  \t\t\t\t}\r\n  \t\t\t}\r\n  \t\t\t// clear all listeners for a type if function isn't specified\r\n  \t\t\tdelete this._events[type];\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tif (typeof fn !== 'function') {\r\n  \t\t\tconsole.warn('wrong listener type: ' + typeof fn);\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\t// find fn and remove it\r\n  \t\tvar index = this._listens(type, fn, context);\r\n  \t\tif (index !== false) {\r\n  \t\t\tvar listener = listeners[index];\r\n  \t\t\tif (this._firingCount) {\r\n  \t\t\t\t// set the removed listener to noop so that's not called if remove happens in fire\r\n  \t\t\t\tlistener.fn = falseFn;\r\n\r\n  \t\t\t\t/* copy array in case events are being fired */\r\n  \t\t\t\tthis._events[type] = listeners = listeners.slice();\r\n  \t\t\t}\r\n  \t\t\tlisteners.splice(index, 1);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method fire(type: String, data?: Object, propagate?: Boolean): this\r\n  \t// Fires an event of the specified type. You can optionally provide a data\r\n  \t// object — the first argument of the listener function will contain its\r\n  \t// properties. The event can optionally be propagated to event parents.\r\n  \tfire: function (type, data, propagate) {\r\n  \t\tif (!this.listens(type, propagate)) { return this; }\r\n\r\n  \t\tvar event = extend({}, data, {\r\n  \t\t\ttype: type,\r\n  \t\t\ttarget: this,\r\n  \t\t\tsourceTarget: data && data.sourceTarget || this\r\n  \t\t});\r\n\r\n  \t\tif (this._events) {\r\n  \t\t\tvar listeners = this._events[type];\r\n  \t\t\tif (listeners) {\r\n  \t\t\t\tthis._firingCount = (this._firingCount + 1) || 1;\r\n  \t\t\t\tfor (var i = 0, len = listeners.length; i < len; i++) {\r\n  \t\t\t\t\tvar l = listeners[i];\r\n  \t\t\t\t\t// off overwrites l.fn, so we need to copy fn to a var\r\n  \t\t\t\t\tvar fn = l.fn;\r\n  \t\t\t\t\tif (l.once) {\r\n  \t\t\t\t\t\tthis.off(type, fn, l.ctx);\r\n  \t\t\t\t\t}\r\n  \t\t\t\t\tfn.call(l.ctx || this, event);\r\n  \t\t\t\t}\r\n\r\n  \t\t\t\tthis._firingCount--;\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tif (propagate) {\r\n  \t\t\t// propagate the event to parents (set with addEventParent)\r\n  \t\t\tthis._propagateEvent(event);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method listens(type: String, propagate?: Boolean): Boolean\r\n  \t// @method listens(type: String, fn: Function, context?: Object, propagate?: Boolean): Boolean\r\n  \t// Returns `true` if a particular event type has any listeners attached to it.\r\n  \t// The verification can optionally be propagated, it will return `true` if parents have the listener attached to it.\r\n  \tlistens: function (type, fn, context, propagate) {\r\n  \t\tif (typeof type !== 'string') {\r\n  \t\t\tconsole.warn('\"string\" type argument expected');\r\n  \t\t}\r\n\r\n  \t\t// we don't overwrite the input `fn` value, because we need to use it for propagation\r\n  \t\tvar _fn = fn;\r\n  \t\tif (typeof fn !== 'function') {\r\n  \t\t\tpropagate = !!fn;\r\n  \t\t\t_fn = undefined;\r\n  \t\t\tcontext = undefined;\r\n  \t\t}\r\n\r\n  \t\tvar listeners = this._events && this._events[type];\r\n  \t\tif (listeners && listeners.length) {\r\n  \t\t\tif (this._listens(type, _fn, context) !== false) {\r\n  \t\t\t\treturn true;\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tif (propagate) {\r\n  \t\t\t// also check parents for listeners if event propagates\r\n  \t\t\tfor (var id in this._eventParents) {\r\n  \t\t\t\tif (this._eventParents[id].listens(type, fn, context, propagate)) { return true; }\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\treturn false;\r\n  \t},\r\n\r\n  \t// returns the index (number) or false\r\n  \t_listens: function (type, fn, context) {\r\n  \t\tif (!this._events) {\r\n  \t\t\treturn false;\r\n  \t\t}\r\n\r\n  \t\tvar listeners = this._events[type] || [];\r\n  \t\tif (!fn) {\r\n  \t\t\treturn !!listeners.length;\r\n  \t\t}\r\n\r\n  \t\tif (context === this) {\r\n  \t\t\t// Less memory footprint.\r\n  \t\t\tcontext = undefined;\r\n  \t\t}\r\n\r\n  \t\tfor (var i = 0, len = listeners.length; i < len; i++) {\r\n  \t\t\tif (listeners[i].fn === fn && listeners[i].ctx === context) {\r\n  \t\t\t\treturn i;\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\treturn false;\r\n\r\n  \t},\r\n\r\n  \t// @method once(…): this\r\n  \t// Behaves as [`on(…)`](#evented-on), except the listener will only get fired once and then removed.\r\n  \tonce: function (types, fn, context) {\r\n\r\n  \t\t// types can be a map of types/handlers\r\n  \t\tif (typeof types === 'object') {\r\n  \t\t\tfor (var type in types) {\r\n  \t\t\t\t// we don't process space-separated events here for performance;\r\n  \t\t\t\t// it's a hot path since Layer uses the on(obj) syntax\r\n  \t\t\t\tthis._on(type, types[type], fn, true);\r\n  \t\t\t}\r\n\r\n  \t\t} else {\r\n  \t\t\t// types can be a string of space-separated words\r\n  \t\t\ttypes = splitWords(types);\r\n\r\n  \t\t\tfor (var i = 0, len = types.length; i < len; i++) {\r\n  \t\t\t\tthis._on(types[i], fn, context, true);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method addEventParent(obj: Evented): this\r\n  \t// Adds an event parent - an `Evented` that will receive propagated events\r\n  \taddEventParent: function (obj) {\r\n  \t\tthis._eventParents = this._eventParents || {};\r\n  \t\tthis._eventParents[stamp(obj)] = obj;\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method removeEventParent(obj: Evented): this\r\n  \t// Removes an event parent, so it will stop receiving propagated events\r\n  \tremoveEventParent: function (obj) {\r\n  \t\tif (this._eventParents) {\r\n  \t\t\tdelete this._eventParents[stamp(obj)];\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_propagateEvent: function (e) {\r\n  \t\tfor (var id in this._eventParents) {\r\n  \t\t\tthis._eventParents[id].fire(e.type, extend({\r\n  \t\t\t\tlayer: e.target,\r\n  \t\t\t\tpropagatedFrom: e.target\r\n  \t\t\t}, e), true);\r\n  \t\t}\r\n  \t}\r\n  };\r\n\r\n  // aliases; we should ditch those eventually\r\n\r\n  // @method addEventListener(…): this\r\n  // Alias to [`on(…)`](#evented-on)\r\n  Events.addEventListener = Events.on;\r\n\r\n  // @method removeEventListener(…): this\r\n  // Alias to [`off(…)`](#evented-off)\r\n\r\n  // @method clearAllEventListeners(…): this\r\n  // Alias to [`off()`](#evented-off)\r\n  Events.removeEventListener = Events.clearAllEventListeners = Events.off;\r\n\r\n  // @method addOneTimeEventListener(…): this\r\n  // Alias to [`once(…)`](#evented-once)\r\n  Events.addOneTimeEventListener = Events.once;\r\n\r\n  // @method fireEvent(…): this\r\n  // Alias to [`fire(…)`](#evented-fire)\r\n  Events.fireEvent = Events.fire;\r\n\r\n  // @method hasEventListeners(…): Boolean\r\n  // Alias to [`listens(…)`](#evented-listens)\r\n  Events.hasEventListeners = Events.listens;\r\n\r\n  var Evented = Class.extend(Events);\n\n  /*\r\n   * @class Point\r\n   * @aka L.Point\r\n   *\r\n   * Represents a point with `x` and `y` coordinates in pixels.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var point = L.point(200, 300);\r\n   * ```\r\n   *\r\n   * All Leaflet methods and options that accept `Point` objects also accept them in a simple Array form (unless noted otherwise), so these lines are equivalent:\r\n   *\r\n   * ```js\r\n   * map.panBy([200, 300]);\r\n   * map.panBy(L.point(200, 300));\r\n   * ```\r\n   *\r\n   * Note that `Point` does not inherit from Leaflet's `Class` object,\r\n   * which means new classes can't inherit from it, and new methods\r\n   * can't be added to it with the `include` function.\r\n   */\r\n\r\n  function Point(x, y, round) {\r\n  \t// @property x: Number; The `x` coordinate of the point\r\n  \tthis.x = (round ? Math.round(x) : x);\r\n  \t// @property y: Number; The `y` coordinate of the point\r\n  \tthis.y = (round ? Math.round(y) : y);\r\n  }\r\n\r\n  var trunc = Math.trunc || function (v) {\r\n  \treturn v > 0 ? Math.floor(v) : Math.ceil(v);\r\n  };\r\n\r\n  Point.prototype = {\r\n\r\n  \t// @method clone(): Point\r\n  \t// Returns a copy of the current point.\r\n  \tclone: function () {\r\n  \t\treturn new Point(this.x, this.y);\r\n  \t},\r\n\r\n  \t// @method add(otherPoint: Point): Point\r\n  \t// Returns the result of addition of the current and the given points.\r\n  \tadd: function (point) {\r\n  \t\t// non-destructive, returns a new point\r\n  \t\treturn this.clone()._add(toPoint(point));\r\n  \t},\r\n\r\n  \t_add: function (point) {\r\n  \t\t// destructive, used directly for performance in situations where it's safe to modify existing point\r\n  \t\tthis.x += point.x;\r\n  \t\tthis.y += point.y;\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method subtract(otherPoint: Point): Point\r\n  \t// Returns the result of subtraction of the given point from the current.\r\n  \tsubtract: function (point) {\r\n  \t\treturn this.clone()._subtract(toPoint(point));\r\n  \t},\r\n\r\n  \t_subtract: function (point) {\r\n  \t\tthis.x -= point.x;\r\n  \t\tthis.y -= point.y;\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method divideBy(num: Number): Point\r\n  \t// Returns the result of division of the current point by the given number.\r\n  \tdivideBy: function (num) {\r\n  \t\treturn this.clone()._divideBy(num);\r\n  \t},\r\n\r\n  \t_divideBy: function (num) {\r\n  \t\tthis.x /= num;\r\n  \t\tthis.y /= num;\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method multiplyBy(num: Number): Point\r\n  \t// Returns the result of multiplication of the current point by the given number.\r\n  \tmultiplyBy: function (num) {\r\n  \t\treturn this.clone()._multiplyBy(num);\r\n  \t},\r\n\r\n  \t_multiplyBy: function (num) {\r\n  \t\tthis.x *= num;\r\n  \t\tthis.y *= num;\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method scaleBy(scale: Point): Point\r\n  \t// Multiply each coordinate of the current point by each coordinate of\r\n  \t// `scale`. In linear algebra terms, multiply the point by the\r\n  \t// [scaling matrix](https://en.wikipedia.org/wiki/Scaling_%28geometry%29#Matrix_representation)\r\n  \t// defined by `scale`.\r\n  \tscaleBy: function (point) {\r\n  \t\treturn new Point(this.x * point.x, this.y * point.y);\r\n  \t},\r\n\r\n  \t// @method unscaleBy(scale: Point): Point\r\n  \t// Inverse of `scaleBy`. Divide each coordinate of the current point by\r\n  \t// each coordinate of `scale`.\r\n  \tunscaleBy: function (point) {\r\n  \t\treturn new Point(this.x / point.x, this.y / point.y);\r\n  \t},\r\n\r\n  \t// @method round(): Point\r\n  \t// Returns a copy of the current point with rounded coordinates.\r\n  \tround: function () {\r\n  \t\treturn this.clone()._round();\r\n  \t},\r\n\r\n  \t_round: function () {\r\n  \t\tthis.x = Math.round(this.x);\r\n  \t\tthis.y = Math.round(this.y);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method floor(): Point\r\n  \t// Returns a copy of the current point with floored coordinates (rounded down).\r\n  \tfloor: function () {\r\n  \t\treturn this.clone()._floor();\r\n  \t},\r\n\r\n  \t_floor: function () {\r\n  \t\tthis.x = Math.floor(this.x);\r\n  \t\tthis.y = Math.floor(this.y);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method ceil(): Point\r\n  \t// Returns a copy of the current point with ceiled coordinates (rounded up).\r\n  \tceil: function () {\r\n  \t\treturn this.clone()._ceil();\r\n  \t},\r\n\r\n  \t_ceil: function () {\r\n  \t\tthis.x = Math.ceil(this.x);\r\n  \t\tthis.y = Math.ceil(this.y);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method trunc(): Point\r\n  \t// Returns a copy of the current point with truncated coordinates (rounded towards zero).\r\n  \ttrunc: function () {\r\n  \t\treturn this.clone()._trunc();\r\n  \t},\r\n\r\n  \t_trunc: function () {\r\n  \t\tthis.x = trunc(this.x);\r\n  \t\tthis.y = trunc(this.y);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method distanceTo(otherPoint: Point): Number\r\n  \t// Returns the cartesian distance between the current and the given points.\r\n  \tdistanceTo: function (point) {\r\n  \t\tpoint = toPoint(point);\r\n\r\n  \t\tvar x = point.x - this.x,\r\n  \t\t    y = point.y - this.y;\r\n\r\n  \t\treturn Math.sqrt(x * x + y * y);\r\n  \t},\r\n\r\n  \t// @method equals(otherPoint: Point): Boolean\r\n  \t// Returns `true` if the given point has the same coordinates.\r\n  \tequals: function (point) {\r\n  \t\tpoint = toPoint(point);\r\n\r\n  \t\treturn point.x === this.x &&\r\n  \t\t       point.y === this.y;\r\n  \t},\r\n\r\n  \t// @method contains(otherPoint: Point): Boolean\r\n  \t// Returns `true` if both coordinates of the given point are less than the corresponding current point coordinates (in absolute values).\r\n  \tcontains: function (point) {\r\n  \t\tpoint = toPoint(point);\r\n\r\n  \t\treturn Math.abs(point.x) <= Math.abs(this.x) &&\r\n  \t\t       Math.abs(point.y) <= Math.abs(this.y);\r\n  \t},\r\n\r\n  \t// @method toString(): String\r\n  \t// Returns a string representation of the point for debugging purposes.\r\n  \ttoString: function () {\r\n  \t\treturn 'Point(' +\r\n  \t\t        formatNum(this.x) + ', ' +\r\n  \t\t        formatNum(this.y) + ')';\r\n  \t}\r\n  };\r\n\r\n  // @factory L.point(x: Number, y: Number, round?: Boolean)\r\n  // Creates a Point object with the given `x` and `y` coordinates. If optional `round` is set to true, rounds the `x` and `y` values.\r\n\r\n  // @alternative\r\n  // @factory L.point(coords: Number[])\r\n  // Expects an array of the form `[x, y]` instead.\r\n\r\n  // @alternative\r\n  // @factory L.point(coords: Object)\r\n  // Expects a plain object of the form `{x: Number, y: Number}` instead.\r\n  function toPoint(x, y, round) {\r\n  \tif (x instanceof Point) {\r\n  \t\treturn x;\r\n  \t}\r\n  \tif (isArray(x)) {\r\n  \t\treturn new Point(x[0], x[1]);\r\n  \t}\r\n  \tif (x === undefined || x === null) {\r\n  \t\treturn x;\r\n  \t}\r\n  \tif (typeof x === 'object' && 'x' in x && 'y' in x) {\r\n  \t\treturn new Point(x.x, x.y);\r\n  \t}\r\n  \treturn new Point(x, y, round);\r\n  }\n\n  /*\r\n   * @class Bounds\r\n   * @aka L.Bounds\r\n   *\r\n   * Represents a rectangular area in pixel coordinates.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var p1 = L.point(10, 10),\r\n   * p2 = L.point(40, 60),\r\n   * bounds = L.bounds(p1, p2);\r\n   * ```\r\n   *\r\n   * All Leaflet methods that accept `Bounds` objects also accept them in a simple Array form (unless noted otherwise), so the bounds example above can be passed like this:\r\n   *\r\n   * ```js\r\n   * otherBounds.intersects([[10, 10], [40, 60]]);\r\n   * ```\r\n   *\r\n   * Note that `Bounds` does not inherit from Leaflet's `Class` object,\r\n   * which means new classes can't inherit from it, and new methods\r\n   * can't be added to it with the `include` function.\r\n   */\r\n\r\n  function Bounds(a, b) {\r\n  \tif (!a) { return; }\r\n\r\n  \tvar points = b ? [a, b] : a;\r\n\r\n  \tfor (var i = 0, len = points.length; i < len; i++) {\r\n  \t\tthis.extend(points[i]);\r\n  \t}\r\n  }\r\n\r\n  Bounds.prototype = {\r\n  \t// @method extend(point: Point): this\r\n  \t// Extends the bounds to contain the given point.\r\n\r\n  \t// @alternative\r\n  \t// @method extend(otherBounds: Bounds): this\r\n  \t// Extend the bounds to contain the given bounds\r\n  \textend: function (obj) {\r\n  \t\tvar min2, max2;\r\n  \t\tif (!obj) { return this; }\r\n\r\n  \t\tif (obj instanceof Point || typeof obj[0] === 'number' || 'x' in obj) {\r\n  \t\t\tmin2 = max2 = toPoint(obj);\r\n  \t\t} else {\r\n  \t\t\tobj = toBounds(obj);\r\n  \t\t\tmin2 = obj.min;\r\n  \t\t\tmax2 = obj.max;\r\n\r\n  \t\t\tif (!min2 || !max2) { return this; }\r\n  \t\t}\r\n\r\n  \t\t// @property min: Point\r\n  \t\t// The top left corner of the rectangle.\r\n  \t\t// @property max: Point\r\n  \t\t// The bottom right corner of the rectangle.\r\n  \t\tif (!this.min && !this.max) {\r\n  \t\t\tthis.min = min2.clone();\r\n  \t\t\tthis.max = max2.clone();\r\n  \t\t} else {\r\n  \t\t\tthis.min.x = Math.min(min2.x, this.min.x);\r\n  \t\t\tthis.max.x = Math.max(max2.x, this.max.x);\r\n  \t\t\tthis.min.y = Math.min(min2.y, this.min.y);\r\n  \t\t\tthis.max.y = Math.max(max2.y, this.max.y);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getCenter(round?: Boolean): Point\r\n  \t// Returns the center point of the bounds.\r\n  \tgetCenter: function (round) {\r\n  \t\treturn toPoint(\r\n  \t\t        (this.min.x + this.max.x) / 2,\r\n  \t\t        (this.min.y + this.max.y) / 2, round);\r\n  \t},\r\n\r\n  \t// @method getBottomLeft(): Point\r\n  \t// Returns the bottom-left point of the bounds.\r\n  \tgetBottomLeft: function () {\r\n  \t\treturn toPoint(this.min.x, this.max.y);\r\n  \t},\r\n\r\n  \t// @method getTopRight(): Point\r\n  \t// Returns the top-right point of the bounds.\r\n  \tgetTopRight: function () { // -> Point\r\n  \t\treturn toPoint(this.max.x, this.min.y);\r\n  \t},\r\n\r\n  \t// @method getTopLeft(): Point\r\n  \t// Returns the top-left point of the bounds (i.e. [`this.min`](#bounds-min)).\r\n  \tgetTopLeft: function () {\r\n  \t\treturn this.min; // left, top\r\n  \t},\r\n\r\n  \t// @method getBottomRight(): Point\r\n  \t// Returns the bottom-right point of the bounds (i.e. [`this.max`](#bounds-max)).\r\n  \tgetBottomRight: function () {\r\n  \t\treturn this.max; // right, bottom\r\n  \t},\r\n\r\n  \t// @method getSize(): Point\r\n  \t// Returns the size of the given bounds\r\n  \tgetSize: function () {\r\n  \t\treturn this.max.subtract(this.min);\r\n  \t},\r\n\r\n  \t// @method contains(otherBounds: Bounds): Boolean\r\n  \t// Returns `true` if the rectangle contains the given one.\r\n  \t// @alternative\r\n  \t// @method contains(point: Point): Boolean\r\n  \t// Returns `true` if the rectangle contains the given point.\r\n  \tcontains: function (obj) {\r\n  \t\tvar min, max;\r\n\r\n  \t\tif (typeof obj[0] === 'number' || obj instanceof Point) {\r\n  \t\t\tobj = toPoint(obj);\r\n  \t\t} else {\r\n  \t\t\tobj = toBounds(obj);\r\n  \t\t}\r\n\r\n  \t\tif (obj instanceof Bounds) {\r\n  \t\t\tmin = obj.min;\r\n  \t\t\tmax = obj.max;\r\n  \t\t} else {\r\n  \t\t\tmin = max = obj;\r\n  \t\t}\r\n\r\n  \t\treturn (min.x >= this.min.x) &&\r\n  \t\t       (max.x <= this.max.x) &&\r\n  \t\t       (min.y >= this.min.y) &&\r\n  \t\t       (max.y <= this.max.y);\r\n  \t},\r\n\r\n  \t// @method intersects(otherBounds: Bounds): Boolean\r\n  \t// Returns `true` if the rectangle intersects the given bounds. Two bounds\r\n  \t// intersect if they have at least one point in common.\r\n  \tintersects: function (bounds) { // (Bounds) -> Boolean\r\n  \t\tbounds = toBounds(bounds);\r\n\r\n  \t\tvar min = this.min,\r\n  \t\t    max = this.max,\r\n  \t\t    min2 = bounds.min,\r\n  \t\t    max2 = bounds.max,\r\n  \t\t    xIntersects = (max2.x >= min.x) && (min2.x <= max.x),\r\n  \t\t    yIntersects = (max2.y >= min.y) && (min2.y <= max.y);\r\n\r\n  \t\treturn xIntersects && yIntersects;\r\n  \t},\r\n\r\n  \t// @method overlaps(otherBounds: Bounds): Boolean\r\n  \t// Returns `true` if the rectangle overlaps the given bounds. Two bounds\r\n  \t// overlap if their intersection is an area.\r\n  \toverlaps: function (bounds) { // (Bounds) -> Boolean\r\n  \t\tbounds = toBounds(bounds);\r\n\r\n  \t\tvar min = this.min,\r\n  \t\t    max = this.max,\r\n  \t\t    min2 = bounds.min,\r\n  \t\t    max2 = bounds.max,\r\n  \t\t    xOverlaps = (max2.x > min.x) && (min2.x < max.x),\r\n  \t\t    yOverlaps = (max2.y > min.y) && (min2.y < max.y);\r\n\r\n  \t\treturn xOverlaps && yOverlaps;\r\n  \t},\r\n\r\n  \t// @method isValid(): Boolean\r\n  \t// Returns `true` if the bounds are properly initialized.\r\n  \tisValid: function () {\r\n  \t\treturn !!(this.min && this.max);\r\n  \t},\r\n\r\n\r\n  \t// @method pad(bufferRatio: Number): Bounds\r\n  \t// Returns bounds created by extending or retracting the current bounds by a given ratio in each direction.\r\n  \t// For example, a ratio of 0.5 extends the bounds by 50% in each direction.\r\n  \t// Negative values will retract the bounds.\r\n  \tpad: function (bufferRatio) {\r\n  \t\tvar min = this.min,\r\n  \t\tmax = this.max,\r\n  \t\theightBuffer = Math.abs(min.x - max.x) * bufferRatio,\r\n  \t\twidthBuffer = Math.abs(min.y - max.y) * bufferRatio;\r\n\r\n\r\n  \t\treturn toBounds(\r\n  \t\t\ttoPoint(min.x - heightBuffer, min.y - widthBuffer),\r\n  \t\t\ttoPoint(max.x + heightBuffer, max.y + widthBuffer));\r\n  \t},\r\n\r\n\r\n  \t// @method equals(otherBounds: Bounds): Boolean\r\n  \t// Returns `true` if the rectangle is equivalent to the given bounds.\r\n  \tequals: function (bounds) {\r\n  \t\tif (!bounds) { return false; }\r\n\r\n  \t\tbounds = toBounds(bounds);\r\n\r\n  \t\treturn this.min.equals(bounds.getTopLeft()) &&\r\n  \t\t\tthis.max.equals(bounds.getBottomRight());\r\n  \t},\r\n  };\r\n\r\n\r\n  // @factory L.bounds(corner1: Point, corner2: Point)\r\n  // Creates a Bounds object from two corners coordinate pairs.\r\n  // @alternative\r\n  // @factory L.bounds(points: Point[])\r\n  // Creates a Bounds object from the given array of points.\r\n  function toBounds(a, b) {\r\n  \tif (!a || a instanceof Bounds) {\r\n  \t\treturn a;\r\n  \t}\r\n  \treturn new Bounds(a, b);\r\n  }\n\n  /*\r\n   * @class LatLngBounds\r\n   * @aka L.LatLngBounds\r\n   *\r\n   * Represents a rectangular geographical area on a map.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var corner1 = L.latLng(40.712, -74.227),\r\n   * corner2 = L.latLng(40.774, -74.125),\r\n   * bounds = L.latLngBounds(corner1, corner2);\r\n   * ```\r\n   *\r\n   * All Leaflet methods that accept LatLngBounds objects also accept them in a simple Array form (unless noted otherwise), so the bounds example above can be passed like this:\r\n   *\r\n   * ```js\r\n   * map.fitBounds([\r\n   * \t[40.712, -74.227],\r\n   * \t[40.774, -74.125]\r\n   * ]);\r\n   * ```\r\n   *\r\n   * Caution: if the area crosses the antimeridian (often confused with the International Date Line), you must specify corners _outside_ the [-180, 180] degrees longitude range.\r\n   *\r\n   * Note that `LatLngBounds` does not inherit from Leaflet's `Class` object,\r\n   * which means new classes can't inherit from it, and new methods\r\n   * can't be added to it with the `include` function.\r\n   */\r\n\r\n  function LatLngBounds(corner1, corner2) { // (LatLng, LatLng) or (LatLng[])\r\n  \tif (!corner1) { return; }\r\n\r\n  \tvar latlngs = corner2 ? [corner1, corner2] : corner1;\r\n\r\n  \tfor (var i = 0, len = latlngs.length; i < len; i++) {\r\n  \t\tthis.extend(latlngs[i]);\r\n  \t}\r\n  }\r\n\r\n  LatLngBounds.prototype = {\r\n\r\n  \t// @method extend(latlng: LatLng): this\r\n  \t// Extend the bounds to contain the given point\r\n\r\n  \t// @alternative\r\n  \t// @method extend(otherBounds: LatLngBounds): this\r\n  \t// Extend the bounds to contain the given bounds\r\n  \textend: function (obj) {\r\n  \t\tvar sw = this._southWest,\r\n  \t\t    ne = this._northEast,\r\n  \t\t    sw2, ne2;\r\n\r\n  \t\tif (obj instanceof LatLng) {\r\n  \t\t\tsw2 = obj;\r\n  \t\t\tne2 = obj;\r\n\r\n  \t\t} else if (obj instanceof LatLngBounds) {\r\n  \t\t\tsw2 = obj._southWest;\r\n  \t\t\tne2 = obj._northEast;\r\n\r\n  \t\t\tif (!sw2 || !ne2) { return this; }\r\n\r\n  \t\t} else {\r\n  \t\t\treturn obj ? this.extend(toLatLng(obj) || toLatLngBounds(obj)) : this;\r\n  \t\t}\r\n\r\n  \t\tif (!sw && !ne) {\r\n  \t\t\tthis._southWest = new LatLng(sw2.lat, sw2.lng);\r\n  \t\t\tthis._northEast = new LatLng(ne2.lat, ne2.lng);\r\n  \t\t} else {\r\n  \t\t\tsw.lat = Math.min(sw2.lat, sw.lat);\r\n  \t\t\tsw.lng = Math.min(sw2.lng, sw.lng);\r\n  \t\t\tne.lat = Math.max(ne2.lat, ne.lat);\r\n  \t\t\tne.lng = Math.max(ne2.lng, ne.lng);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method pad(bufferRatio: Number): LatLngBounds\r\n  \t// Returns bounds created by extending or retracting the current bounds by a given ratio in each direction.\r\n  \t// For example, a ratio of 0.5 extends the bounds by 50% in each direction.\r\n  \t// Negative values will retract the bounds.\r\n  \tpad: function (bufferRatio) {\r\n  \t\tvar sw = this._southWest,\r\n  \t\t    ne = this._northEast,\r\n  \t\t    heightBuffer = Math.abs(sw.lat - ne.lat) * bufferRatio,\r\n  \t\t    widthBuffer = Math.abs(sw.lng - ne.lng) * bufferRatio;\r\n\r\n  \t\treturn new LatLngBounds(\r\n  \t\t        new LatLng(sw.lat - heightBuffer, sw.lng - widthBuffer),\r\n  \t\t        new LatLng(ne.lat + heightBuffer, ne.lng + widthBuffer));\r\n  \t},\r\n\r\n  \t// @method getCenter(): LatLng\r\n  \t// Returns the center point of the bounds.\r\n  \tgetCenter: function () {\r\n  \t\treturn new LatLng(\r\n  \t\t        (this._southWest.lat + this._northEast.lat) / 2,\r\n  \t\t        (this._southWest.lng + this._northEast.lng) / 2);\r\n  \t},\r\n\r\n  \t// @method getSouthWest(): LatLng\r\n  \t// Returns the south-west point of the bounds.\r\n  \tgetSouthWest: function () {\r\n  \t\treturn this._southWest;\r\n  \t},\r\n\r\n  \t// @method getNorthEast(): LatLng\r\n  \t// Returns the north-east point of the bounds.\r\n  \tgetNorthEast: function () {\r\n  \t\treturn this._northEast;\r\n  \t},\r\n\r\n  \t// @method getNorthWest(): LatLng\r\n  \t// Returns the north-west point of the bounds.\r\n  \tgetNorthWest: function () {\r\n  \t\treturn new LatLng(this.getNorth(), this.getWest());\r\n  \t},\r\n\r\n  \t// @method getSouthEast(): LatLng\r\n  \t// Returns the south-east point of the bounds.\r\n  \tgetSouthEast: function () {\r\n  \t\treturn new LatLng(this.getSouth(), this.getEast());\r\n  \t},\r\n\r\n  \t// @method getWest(): Number\r\n  \t// Returns the west longitude of the bounds\r\n  \tgetWest: function () {\r\n  \t\treturn this._southWest.lng;\r\n  \t},\r\n\r\n  \t// @method getSouth(): Number\r\n  \t// Returns the south latitude of the bounds\r\n  \tgetSouth: function () {\r\n  \t\treturn this._southWest.lat;\r\n  \t},\r\n\r\n  \t// @method getEast(): Number\r\n  \t// Returns the east longitude of the bounds\r\n  \tgetEast: function () {\r\n  \t\treturn this._northEast.lng;\r\n  \t},\r\n\r\n  \t// @method getNorth(): Number\r\n  \t// Returns the north latitude of the bounds\r\n  \tgetNorth: function () {\r\n  \t\treturn this._northEast.lat;\r\n  \t},\r\n\r\n  \t// @method contains(otherBounds: LatLngBounds): Boolean\r\n  \t// Returns `true` if the rectangle contains the given one.\r\n\r\n  \t// @alternative\r\n  \t// @method contains (latlng: LatLng): Boolean\r\n  \t// Returns `true` if the rectangle contains the given point.\r\n  \tcontains: function (obj) { // (LatLngBounds) or (LatLng) -> Boolean\r\n  \t\tif (typeof obj[0] === 'number' || obj instanceof LatLng || 'lat' in obj) {\r\n  \t\t\tobj = toLatLng(obj);\r\n  \t\t} else {\r\n  \t\t\tobj = toLatLngBounds(obj);\r\n  \t\t}\r\n\r\n  \t\tvar sw = this._southWest,\r\n  \t\t    ne = this._northEast,\r\n  \t\t    sw2, ne2;\r\n\r\n  \t\tif (obj instanceof LatLngBounds) {\r\n  \t\t\tsw2 = obj.getSouthWest();\r\n  \t\t\tne2 = obj.getNorthEast();\r\n  \t\t} else {\r\n  \t\t\tsw2 = ne2 = obj;\r\n  \t\t}\r\n\r\n  \t\treturn (sw2.lat >= sw.lat) && (ne2.lat <= ne.lat) &&\r\n  \t\t       (sw2.lng >= sw.lng) && (ne2.lng <= ne.lng);\r\n  \t},\r\n\r\n  \t// @method intersects(otherBounds: LatLngBounds): Boolean\r\n  \t// Returns `true` if the rectangle intersects the given bounds. Two bounds intersect if they have at least one point in common.\r\n  \tintersects: function (bounds) {\r\n  \t\tbounds = toLatLngBounds(bounds);\r\n\r\n  \t\tvar sw = this._southWest,\r\n  \t\t    ne = this._northEast,\r\n  \t\t    sw2 = bounds.getSouthWest(),\r\n  \t\t    ne2 = bounds.getNorthEast(),\r\n\r\n  \t\t    latIntersects = (ne2.lat >= sw.lat) && (sw2.lat <= ne.lat),\r\n  \t\t    lngIntersects = (ne2.lng >= sw.lng) && (sw2.lng <= ne.lng);\r\n\r\n  \t\treturn latIntersects && lngIntersects;\r\n  \t},\r\n\r\n  \t// @method overlaps(otherBounds: LatLngBounds): Boolean\r\n  \t// Returns `true` if the rectangle overlaps the given bounds. Two bounds overlap if their intersection is an area.\r\n  \toverlaps: function (bounds) {\r\n  \t\tbounds = toLatLngBounds(bounds);\r\n\r\n  \t\tvar sw = this._southWest,\r\n  \t\t    ne = this._northEast,\r\n  \t\t    sw2 = bounds.getSouthWest(),\r\n  \t\t    ne2 = bounds.getNorthEast(),\r\n\r\n  \t\t    latOverlaps = (ne2.lat > sw.lat) && (sw2.lat < ne.lat),\r\n  \t\t    lngOverlaps = (ne2.lng > sw.lng) && (sw2.lng < ne.lng);\r\n\r\n  \t\treturn latOverlaps && lngOverlaps;\r\n  \t},\r\n\r\n  \t// @method toBBoxString(): String\r\n  \t// Returns a string with bounding box coordinates in a 'southwest_lng,southwest_lat,northeast_lng,northeast_lat' format. Useful for sending requests to web services that return geo data.\r\n  \ttoBBoxString: function () {\r\n  \t\treturn [this.getWest(), this.getSouth(), this.getEast(), this.getNorth()].join(',');\r\n  \t},\r\n\r\n  \t// @method equals(otherBounds: LatLngBounds, maxMargin?: Number): Boolean\r\n  \t// Returns `true` if the rectangle is equivalent (within a small margin of error) to the given bounds. The margin of error can be overridden by setting `maxMargin` to a small number.\r\n  \tequals: function (bounds, maxMargin) {\r\n  \t\tif (!bounds) { return false; }\r\n\r\n  \t\tbounds = toLatLngBounds(bounds);\r\n\r\n  \t\treturn this._southWest.equals(bounds.getSouthWest(), maxMargin) &&\r\n  \t\t       this._northEast.equals(bounds.getNorthEast(), maxMargin);\r\n  \t},\r\n\r\n  \t// @method isValid(): Boolean\r\n  \t// Returns `true` if the bounds are properly initialized.\r\n  \tisValid: function () {\r\n  \t\treturn !!(this._southWest && this._northEast);\r\n  \t}\r\n  };\r\n\r\n  // TODO International date line?\r\n\r\n  // @factory L.latLngBounds(corner1: LatLng, corner2: LatLng)\r\n  // Creates a `LatLngBounds` object by defining two diagonally opposite corners of the rectangle.\r\n\r\n  // @alternative\r\n  // @factory L.latLngBounds(latlngs: LatLng[])\r\n  // Creates a `LatLngBounds` object defined by the geographical points it contains. Very useful for zooming the map to fit a particular set of locations with [`fitBounds`](#map-fitbounds).\r\n  function toLatLngBounds(a, b) {\r\n  \tif (a instanceof LatLngBounds) {\r\n  \t\treturn a;\r\n  \t}\r\n  \treturn new LatLngBounds(a, b);\r\n  }\n\n  /* @class LatLng\r\n   * @aka L.LatLng\r\n   *\r\n   * Represents a geographical point with a certain latitude and longitude.\r\n   *\r\n   * @example\r\n   *\r\n   * ```\r\n   * var latlng = L.latLng(50.5, 30.5);\r\n   * ```\r\n   *\r\n   * All Leaflet methods that accept LatLng objects also accept them in a simple Array form and simple object form (unless noted otherwise), so these lines are equivalent:\r\n   *\r\n   * ```\r\n   * map.panTo([50, 30]);\r\n   * map.panTo({lon: 30, lat: 50});\r\n   * map.panTo({lat: 50, lng: 30});\r\n   * map.panTo(L.latLng(50, 30));\r\n   * ```\r\n   *\r\n   * Note that `LatLng` does not inherit from Leaflet's `Class` object,\r\n   * which means new classes can't inherit from it, and new methods\r\n   * can't be added to it with the `include` function.\r\n   */\r\n\r\n  function LatLng(lat, lng, alt) {\r\n  \tif (isNaN(lat) || isNaN(lng)) {\r\n  \t\tthrow new Error('Invalid LatLng object: (' + lat + ', ' + lng + ')');\r\n  \t}\r\n\r\n  \t// @property lat: Number\r\n  \t// Latitude in degrees\r\n  \tthis.lat = +lat;\r\n\r\n  \t// @property lng: Number\r\n  \t// Longitude in degrees\r\n  \tthis.lng = +lng;\r\n\r\n  \t// @property alt: Number\r\n  \t// Altitude in meters (optional)\r\n  \tif (alt !== undefined) {\r\n  \t\tthis.alt = +alt;\r\n  \t}\r\n  }\r\n\r\n  LatLng.prototype = {\r\n  \t// @method equals(otherLatLng: LatLng, maxMargin?: Number): Boolean\r\n  \t// Returns `true` if the given `LatLng` point is at the same position (within a small margin of error). The margin of error can be overridden by setting `maxMargin` to a small number.\r\n  \tequals: function (obj, maxMargin) {\r\n  \t\tif (!obj) { return false; }\r\n\r\n  \t\tobj = toLatLng(obj);\r\n\r\n  \t\tvar margin = Math.max(\r\n  \t\t        Math.abs(this.lat - obj.lat),\r\n  \t\t        Math.abs(this.lng - obj.lng));\r\n\r\n  \t\treturn margin <= (maxMargin === undefined ? 1.0E-9 : maxMargin);\r\n  \t},\r\n\r\n  \t// @method toString(): String\r\n  \t// Returns a string representation of the point (for debugging purposes).\r\n  \ttoString: function (precision) {\r\n  \t\treturn 'LatLng(' +\r\n  \t\t        formatNum(this.lat, precision) + ', ' +\r\n  \t\t        formatNum(this.lng, precision) + ')';\r\n  \t},\r\n\r\n  \t// @method distanceTo(otherLatLng: LatLng): Number\r\n  \t// Returns the distance (in meters) to the given `LatLng` calculated using the [Spherical Law of Cosines](https://en.wikipedia.org/wiki/Spherical_law_of_cosines).\r\n  \tdistanceTo: function (other) {\r\n  \t\treturn Earth.distance(this, toLatLng(other));\r\n  \t},\r\n\r\n  \t// @method wrap(): LatLng\r\n  \t// Returns a new `LatLng` object with the longitude wrapped so it's always between -180 and +180 degrees.\r\n  \twrap: function () {\r\n  \t\treturn Earth.wrapLatLng(this);\r\n  \t},\r\n\r\n  \t// @method toBounds(sizeInMeters: Number): LatLngBounds\r\n  \t// Returns a new `LatLngBounds` object in which each boundary is `sizeInMeters/2` meters apart from the `LatLng`.\r\n  \ttoBounds: function (sizeInMeters) {\r\n  \t\tvar latAccuracy = 180 * sizeInMeters / 40075017,\r\n  \t\t    lngAccuracy = latAccuracy / Math.cos((Math.PI / 180) * this.lat);\r\n\r\n  \t\treturn toLatLngBounds(\r\n  \t\t        [this.lat - latAccuracy, this.lng - lngAccuracy],\r\n  \t\t        [this.lat + latAccuracy, this.lng + lngAccuracy]);\r\n  \t},\r\n\r\n  \tclone: function () {\r\n  \t\treturn new LatLng(this.lat, this.lng, this.alt);\r\n  \t}\r\n  };\r\n\r\n\r\n\r\n  // @factory L.latLng(latitude: Number, longitude: Number, altitude?: Number): LatLng\r\n  // Creates an object representing a geographical point with the given latitude and longitude (and optionally altitude).\r\n\r\n  // @alternative\r\n  // @factory L.latLng(coords: Array): LatLng\r\n  // Expects an array of the form `[Number, Number]` or `[Number, Number, Number]` instead.\r\n\r\n  // @alternative\r\n  // @factory L.latLng(coords: Object): LatLng\r\n  // Expects an plain object of the form `{lat: Number, lng: Number}` or `{lat: Number, lng: Number, alt: Number}` instead.\r\n\r\n  function toLatLng(a, b, c) {\r\n  \tif (a instanceof LatLng) {\r\n  \t\treturn a;\r\n  \t}\r\n  \tif (isArray(a) && typeof a[0] !== 'object') {\r\n  \t\tif (a.length === 3) {\r\n  \t\t\treturn new LatLng(a[0], a[1], a[2]);\r\n  \t\t}\r\n  \t\tif (a.length === 2) {\r\n  \t\t\treturn new LatLng(a[0], a[1]);\r\n  \t\t}\r\n  \t\treturn null;\r\n  \t}\r\n  \tif (a === undefined || a === null) {\r\n  \t\treturn a;\r\n  \t}\r\n  \tif (typeof a === 'object' && 'lat' in a) {\r\n  \t\treturn new LatLng(a.lat, 'lng' in a ? a.lng : a.lon, a.alt);\r\n  \t}\r\n  \tif (b === undefined) {\r\n  \t\treturn null;\r\n  \t}\r\n  \treturn new LatLng(a, b, c);\r\n  }\n\n  /*\r\n   * @namespace CRS\r\n   * @crs L.CRS.Base\r\n   * Object that defines coordinate reference systems for projecting\r\n   * geographical points into pixel (screen) coordinates and back (and to\r\n   * coordinates in other units for [WMS](https://en.wikipedia.org/wiki/Web_Map_Service) services). See\r\n   * [spatial reference system](https://en.wikipedia.org/wiki/Spatial_reference_system).\r\n   *\r\n   * Leaflet defines the most usual CRSs by default. If you want to use a\r\n   * CRS not defined by default, take a look at the\r\n   * [Proj4Leaflet](https://github.com/kartena/Proj4Leaflet) plugin.\r\n   *\r\n   * Note that the CRS instances do not inherit from Leaflet's `Class` object,\r\n   * and can't be instantiated. Also, new classes can't inherit from them,\r\n   * and methods can't be added to them with the `include` function.\r\n   */\r\n\r\n  var CRS = {\r\n  \t// @method latLngToPoint(latlng: LatLng, zoom: Number): Point\r\n  \t// Projects geographical coordinates into pixel coordinates for a given zoom.\r\n  \tlatLngToPoint: function (latlng, zoom) {\r\n  \t\tvar projectedPoint = this.projection.project(latlng),\r\n  \t\t    scale = this.scale(zoom);\r\n\r\n  \t\treturn this.transformation._transform(projectedPoint, scale);\r\n  \t},\r\n\r\n  \t// @method pointToLatLng(point: Point, zoom: Number): LatLng\r\n  \t// The inverse of `latLngToPoint`. Projects pixel coordinates on a given\r\n  \t// zoom into geographical coordinates.\r\n  \tpointToLatLng: function (point, zoom) {\r\n  \t\tvar scale = this.scale(zoom),\r\n  \t\t    untransformedPoint = this.transformation.untransform(point, scale);\r\n\r\n  \t\treturn this.projection.unproject(untransformedPoint);\r\n  \t},\r\n\r\n  \t// @method project(latlng: LatLng): Point\r\n  \t// Projects geographical coordinates into coordinates in units accepted for\r\n  \t// this CRS (e.g. meters for EPSG:3857, for passing it to WMS services).\r\n  \tproject: function (latlng) {\r\n  \t\treturn this.projection.project(latlng);\r\n  \t},\r\n\r\n  \t// @method unproject(point: Point): LatLng\r\n  \t// Given a projected coordinate returns the corresponding LatLng.\r\n  \t// The inverse of `project`.\r\n  \tunproject: function (point) {\r\n  \t\treturn this.projection.unproject(point);\r\n  \t},\r\n\r\n  \t// @method scale(zoom: Number): Number\r\n  \t// Returns the scale used when transforming projected coordinates into\r\n  \t// pixel coordinates for a particular zoom. For example, it returns\r\n  \t// `256 * 2^zoom` for Mercator-based CRS.\r\n  \tscale: function (zoom) {\r\n  \t\treturn 256 * Math.pow(2, zoom);\r\n  \t},\r\n\r\n  \t// @method zoom(scale: Number): Number\r\n  \t// Inverse of `scale()`, returns the zoom level corresponding to a scale\r\n  \t// factor of `scale`.\r\n  \tzoom: function (scale) {\r\n  \t\treturn Math.log(scale / 256) / Math.LN2;\r\n  \t},\r\n\r\n  \t// @method getProjectedBounds(zoom: Number): Bounds\r\n  \t// Returns the projection's bounds scaled and transformed for the provided `zoom`.\r\n  \tgetProjectedBounds: function (zoom) {\r\n  \t\tif (this.infinite) { return null; }\r\n\r\n  \t\tvar b = this.projection.bounds,\r\n  \t\t    s = this.scale(zoom),\r\n  \t\t    min = this.transformation.transform(b.min, s),\r\n  \t\t    max = this.transformation.transform(b.max, s);\r\n\r\n  \t\treturn new Bounds(min, max);\r\n  \t},\r\n\r\n  \t// @method distance(latlng1: LatLng, latlng2: LatLng): Number\r\n  \t// Returns the distance between two geographical coordinates.\r\n\r\n  \t// @property code: String\r\n  \t// Standard code name of the CRS passed into WMS services (e.g. `'EPSG:3857'`)\r\n  \t//\r\n  \t// @property wrapLng: Number[]\r\n  \t// An array of two numbers defining whether the longitude (horizontal) coordinate\r\n  \t// axis wraps around a given range and how. Defaults to `[-180, 180]` in most\r\n  \t// geographical CRSs. If `undefined`, the longitude axis does not wrap around.\r\n  \t//\r\n  \t// @property wrapLat: Number[]\r\n  \t// Like `wrapLng`, but for the latitude (vertical) axis.\r\n\r\n  \t// wrapLng: [min, max],\r\n  \t// wrapLat: [min, max],\r\n\r\n  \t// @property infinite: Boolean\r\n  \t// If true, the coordinate space will be unbounded (infinite in both axes)\r\n  \tinfinite: false,\r\n\r\n  \t// @method wrapLatLng(latlng: LatLng): LatLng\r\n  \t// Returns a `LatLng` where lat and lng has been wrapped according to the\r\n  \t// CRS's `wrapLat` and `wrapLng` properties, if they are outside the CRS's bounds.\r\n  \twrapLatLng: function (latlng) {\r\n  \t\tvar lng = this.wrapLng ? wrapNum(latlng.lng, this.wrapLng, true) : latlng.lng,\r\n  \t\t    lat = this.wrapLat ? wrapNum(latlng.lat, this.wrapLat, true) : latlng.lat,\r\n  \t\t    alt = latlng.alt;\r\n\r\n  \t\treturn new LatLng(lat, lng, alt);\r\n  \t},\r\n\r\n  \t// @method wrapLatLngBounds(bounds: LatLngBounds): LatLngBounds\r\n  \t// Returns a `LatLngBounds` with the same size as the given one, ensuring\r\n  \t// that its center is within the CRS's bounds.\r\n  \t// Only accepts actual `L.LatLngBounds` instances, not arrays.\r\n  \twrapLatLngBounds: function (bounds) {\r\n  \t\tvar center = bounds.getCenter(),\r\n  \t\t    newCenter = this.wrapLatLng(center),\r\n  \t\t    latShift = center.lat - newCenter.lat,\r\n  \t\t    lngShift = center.lng - newCenter.lng;\r\n\r\n  \t\tif (latShift === 0 && lngShift === 0) {\r\n  \t\t\treturn bounds;\r\n  \t\t}\r\n\r\n  \t\tvar sw = bounds.getSouthWest(),\r\n  \t\t    ne = bounds.getNorthEast(),\r\n  \t\t    newSw = new LatLng(sw.lat - latShift, sw.lng - lngShift),\r\n  \t\t    newNe = new LatLng(ne.lat - latShift, ne.lng - lngShift);\r\n\r\n  \t\treturn new LatLngBounds(newSw, newNe);\r\n  \t}\r\n  };\n\n  /*\n   * @namespace CRS\n   * @crs L.CRS.Earth\n   *\n   * Serves as the base for CRS that are global such that they cover the earth.\n   * Can only be used as the base for other CRS and cannot be used directly,\n   * since it does not have a `code`, `projection` or `transformation`. `distance()` returns\n   * meters.\n   */\n\n  var Earth = extend({}, CRS, {\n  \twrapLng: [-180, 180],\n\n  \t// Mean Earth Radius, as recommended for use by\n  \t// the International Union of Geodesy and Geophysics,\n  \t// see https://rosettacode.org/wiki/Haversine_formula\n  \tR: 6371000,\n\n  \t// distance between two geographical points using spherical law of cosines approximation\n  \tdistance: function (latlng1, latlng2) {\n  \t\tvar rad = Math.PI / 180,\n  \t\t    lat1 = latlng1.lat * rad,\n  \t\t    lat2 = latlng2.lat * rad,\n  \t\t    sinDLat = Math.sin((latlng2.lat - latlng1.lat) * rad / 2),\n  \t\t    sinDLon = Math.sin((latlng2.lng - latlng1.lng) * rad / 2),\n  \t\t    a = sinDLat * sinDLat + Math.cos(lat1) * Math.cos(lat2) * sinDLon * sinDLon,\n  \t\t    c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));\n  \t\treturn this.R * c;\n  \t}\n  });\n\n  /*\r\n   * @namespace Projection\r\n   * @projection L.Projection.SphericalMercator\r\n   *\r\n   * Spherical Mercator projection — the most common projection for online maps,\r\n   * used by almost all free and commercial tile providers. Assumes that Earth is\r\n   * a sphere. Used by the `EPSG:3857` CRS.\r\n   */\r\n\r\n  var earthRadius = 6378137;\r\n\r\n  var SphericalMercator = {\r\n\r\n  \tR: earthRadius,\r\n  \tMAX_LATITUDE: 85.0511287798,\r\n\r\n  \tproject: function (latlng) {\r\n  \t\tvar d = Math.PI / 180,\r\n  \t\t    max = this.MAX_LATITUDE,\r\n  \t\t    lat = Math.max(Math.min(max, latlng.lat), -max),\r\n  \t\t    sin = Math.sin(lat * d);\r\n\r\n  \t\treturn new Point(\r\n  \t\t\tthis.R * latlng.lng * d,\r\n  \t\t\tthis.R * Math.log((1 + sin) / (1 - sin)) / 2);\r\n  \t},\r\n\r\n  \tunproject: function (point) {\r\n  \t\tvar d = 180 / Math.PI;\r\n\r\n  \t\treturn new LatLng(\r\n  \t\t\t(2 * Math.atan(Math.exp(point.y / this.R)) - (Math.PI / 2)) * d,\r\n  \t\t\tpoint.x * d / this.R);\r\n  \t},\r\n\r\n  \tbounds: (function () {\r\n  \t\tvar d = earthRadius * Math.PI;\r\n  \t\treturn new Bounds([-d, -d], [d, d]);\r\n  \t})()\r\n  };\n\n  /*\r\n   * @class Transformation\r\n   * @aka L.Transformation\r\n   *\r\n   * Represents an affine transformation: a set of coefficients `a`, `b`, `c`, `d`\r\n   * for transforming a point of a form `(x, y)` into `(a*x + b, c*y + d)` and doing\r\n   * the reverse. Used by Leaflet in its projections code.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var transformation = L.transformation(2, 5, -1, 10),\r\n   * \tp = L.point(1, 2),\r\n   * \tp2 = transformation.transform(p), //  L.point(7, 8)\r\n   * \tp3 = transformation.untransform(p2); //  L.point(1, 2)\r\n   * ```\r\n   */\r\n\r\n\r\n  // factory new L.Transformation(a: Number, b: Number, c: Number, d: Number)\r\n  // Creates a `Transformation` object with the given coefficients.\r\n  function Transformation(a, b, c, d) {\r\n  \tif (isArray(a)) {\r\n  \t\t// use array properties\r\n  \t\tthis._a = a[0];\r\n  \t\tthis._b = a[1];\r\n  \t\tthis._c = a[2];\r\n  \t\tthis._d = a[3];\r\n  \t\treturn;\r\n  \t}\r\n  \tthis._a = a;\r\n  \tthis._b = b;\r\n  \tthis._c = c;\r\n  \tthis._d = d;\r\n  }\r\n\r\n  Transformation.prototype = {\r\n  \t// @method transform(point: Point, scale?: Number): Point\r\n  \t// Returns a transformed point, optionally multiplied by the given scale.\r\n  \t// Only accepts actual `L.Point` instances, not arrays.\r\n  \ttransform: function (point, scale) { // (Point, Number) -> Point\r\n  \t\treturn this._transform(point.clone(), scale);\r\n  \t},\r\n\r\n  \t// destructive transform (faster)\r\n  \t_transform: function (point, scale) {\r\n  \t\tscale = scale || 1;\r\n  \t\tpoint.x = scale * (this._a * point.x + this._b);\r\n  \t\tpoint.y = scale * (this._c * point.y + this._d);\r\n  \t\treturn point;\r\n  \t},\r\n\r\n  \t// @method untransform(point: Point, scale?: Number): Point\r\n  \t// Returns the reverse transformation of the given point, optionally divided\r\n  \t// by the given scale. Only accepts actual `L.Point` instances, not arrays.\r\n  \tuntransform: function (point, scale) {\r\n  \t\tscale = scale || 1;\r\n  \t\treturn new Point(\r\n  \t\t        (point.x / scale - this._b) / this._a,\r\n  \t\t        (point.y / scale - this._d) / this._c);\r\n  \t}\r\n  };\r\n\r\n  // factory L.transformation(a: Number, b: Number, c: Number, d: Number)\r\n\r\n  // @factory L.transformation(a: Number, b: Number, c: Number, d: Number)\r\n  // Instantiates a Transformation object with the given coefficients.\r\n\r\n  // @alternative\r\n  // @factory L.transformation(coefficients: Array): Transformation\r\n  // Expects an coefficients array of the form\r\n  // `[a: Number, b: Number, c: Number, d: Number]`.\r\n\r\n  function toTransformation(a, b, c, d) {\r\n  \treturn new Transformation(a, b, c, d);\r\n  }\n\n  /*\r\n   * @namespace CRS\r\n   * @crs L.CRS.EPSG3857\r\n   *\r\n   * The most common CRS for online maps, used by almost all free and commercial\r\n   * tile providers. Uses Spherical Mercator projection. Set in by default in\r\n   * Map's `crs` option.\r\n   */\r\n\r\n  var EPSG3857 = extend({}, Earth, {\r\n  \tcode: 'EPSG:3857',\r\n  \tprojection: SphericalMercator,\r\n\r\n  \ttransformation: (function () {\r\n  \t\tvar scale = 0.5 / (Math.PI * SphericalMercator.R);\r\n  \t\treturn toTransformation(scale, 0.5, -scale, 0.5);\r\n  \t}())\r\n  });\r\n\r\n  var EPSG900913 = extend({}, EPSG3857, {\r\n  \tcode: 'EPSG:900913'\r\n  });\n\n  // @namespace SVG; @section\n  // There are several static functions which can be called without instantiating L.SVG:\n\n  // @function create(name: String): SVGElement\n  // Returns a instance of [SVGElement](https://developer.mozilla.org/docs/Web/API/SVGElement),\n  // corresponding to the class name passed. For example, using 'line' will return\n  // an instance of [SVGLineElement](https://developer.mozilla.org/docs/Web/API/SVGLineElement).\n  function svgCreate(name) {\n  \treturn document.createElementNS('http://www.w3.org/2000/svg', name);\n  }\n\n  // @function pointsToPath(rings: Point[], closed: Boolean): String\n  // Generates a SVG path string for multiple rings, with each ring turning\n  // into \"M..L..L..\" instructions\n  function pointsToPath(rings, closed) {\n  \tvar str = '',\n  \ti, j, len, len2, points, p;\n\n  \tfor (i = 0, len = rings.length; i < len; i++) {\n  \t\tpoints = rings[i];\n\n  \t\tfor (j = 0, len2 = points.length; j < len2; j++) {\n  \t\t\tp = points[j];\n  \t\t\tstr += (j ? 'L' : 'M') + p.x + ' ' + p.y;\n  \t\t}\n\n  \t\t// closes the ring for polygons; \"x\" is VML syntax\n  \t\tstr += closed ? (Browser.svg ? 'z' : 'x') : '';\n  \t}\n\n  \t// SVG complains about empty path strings\n  \treturn str || 'M0 0';\n  }\n\n  /*\r\n   * @namespace Browser\r\n   * @aka L.Browser\r\n   *\r\n   * A namespace with static properties for browser/feature detection used by Leaflet internally.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * if (L.Browser.ielt9) {\r\n   *   alert('Upgrade your browser, dude!');\r\n   * }\r\n   * ```\r\n   */\r\n\r\n  var style = document.documentElement.style;\r\n\r\n  // @property ie: Boolean; `true` for all Internet Explorer versions (not Edge).\r\n  var ie = 'ActiveXObject' in window;\r\n\r\n  // @property ielt9: Boolean; `true` for Internet Explorer versions less than 9.\r\n  var ielt9 = ie && !document.addEventListener;\r\n\r\n  // @property edge: Boolean; `true` for the Edge web browser.\r\n  var edge = 'msLaunchUri' in navigator && !('documentMode' in document);\r\n\r\n  // @property webkit: Boolean;\r\n  // `true` for webkit-based browsers like Chrome and Safari (including mobile versions).\r\n  var webkit = userAgentContains('webkit');\r\n\r\n  // @property android: Boolean\r\n  // **Deprecated.** `true` for any browser running on an Android platform.\r\n  var android = userAgentContains('android');\r\n\r\n  // @property android23: Boolean; **Deprecated.** `true` for browsers running on Android 2 or Android 3.\r\n  var android23 = userAgentContains('android 2') || userAgentContains('android 3');\r\n\r\n  /* See https://stackoverflow.com/a/17961266 for details on detecting stock Android */\r\n  var webkitVer = parseInt(/WebKit\\/([0-9]+)|$/.exec(navigator.userAgent)[1], 10); // also matches AppleWebKit\r\n  // @property androidStock: Boolean; **Deprecated.** `true` for the Android stock browser (i.e. not Chrome)\r\n  var androidStock = android && userAgentContains('Google') && webkitVer < 537 && !('AudioNode' in window);\r\n\r\n  // @property opera: Boolean; `true` for the Opera browser\r\n  var opera = !!window.opera;\r\n\r\n  // @property chrome: Boolean; `true` for the Chrome browser.\r\n  var chrome = !edge && userAgentContains('chrome');\r\n\r\n  // @property gecko: Boolean; `true` for gecko-based browsers like Firefox.\r\n  var gecko = userAgentContains('gecko') && !webkit && !opera && !ie;\r\n\r\n  // @property safari: Boolean; `true` for the Safari browser.\r\n  var safari = !chrome && userAgentContains('safari');\r\n\r\n  var phantom = userAgentContains('phantom');\r\n\r\n  // @property opera12: Boolean\r\n  // `true` for the Opera browser supporting CSS transforms (version 12 or later).\r\n  var opera12 = 'OTransition' in style;\r\n\r\n  // @property win: Boolean; `true` when the browser is running in a Windows platform\r\n  var win = navigator.platform.indexOf('Win') === 0;\r\n\r\n  // @property ie3d: Boolean; `true` for all Internet Explorer versions supporting CSS transforms.\r\n  var ie3d = ie && ('transition' in style);\r\n\r\n  // @property webkit3d: Boolean; `true` for webkit-based browsers supporting CSS transforms.\r\n  var webkit3d = ('WebKitCSSMatrix' in window) && ('m11' in new window.WebKitCSSMatrix()) && !android23;\r\n\r\n  // @property gecko3d: Boolean; `true` for gecko-based browsers supporting CSS transforms.\r\n  var gecko3d = 'MozPerspective' in style;\r\n\r\n  // @property any3d: Boolean\r\n  // `true` for all browsers supporting CSS transforms.\r\n  var any3d = !window.L_DISABLE_3D && (ie3d || webkit3d || gecko3d) && !opera12 && !phantom;\r\n\r\n  // @property mobile: Boolean; `true` for all browsers running in a mobile device.\r\n  var mobile = typeof orientation !== 'undefined' || userAgentContains('mobile');\r\n\r\n  // @property mobileWebkit: Boolean; `true` for all webkit-based browsers in a mobile device.\r\n  var mobileWebkit = mobile && webkit;\r\n\r\n  // @property mobileWebkit3d: Boolean\r\n  // `true` for all webkit-based browsers in a mobile device supporting CSS transforms.\r\n  var mobileWebkit3d = mobile && webkit3d;\r\n\r\n  // @property msPointer: Boolean\r\n  // `true` for browsers implementing the Microsoft touch events model (notably IE10).\r\n  var msPointer = !window.PointerEvent && window.MSPointerEvent;\r\n\r\n  // @property pointer: Boolean\r\n  // `true` for all browsers supporting [pointer events](https://msdn.microsoft.com/en-us/library/dn433244%28v=vs.85%29.aspx).\r\n  var pointer = !!(window.PointerEvent || msPointer);\r\n\r\n  // @property touchNative: Boolean\r\n  // `true` for all browsers supporting [touch events](https://developer.mozilla.org/docs/Web/API/Touch_events).\r\n  // **This does not necessarily mean** that the browser is running in a computer with\r\n  // a touchscreen, it only means that the browser is capable of understanding\r\n  // touch events.\r\n  var touchNative = 'ontouchstart' in window || !!window.TouchEvent;\r\n\r\n  // @property touch: Boolean\r\n  // `true` for all browsers supporting either [touch](#browser-touch) or [pointer](#browser-pointer) events.\r\n  // Note: pointer events will be preferred (if available), and processed for all `touch*` listeners.\r\n  var touch = !window.L_NO_TOUCH && (touchNative || pointer);\r\n\r\n  // @property mobileOpera: Boolean; `true` for the Opera browser in a mobile device.\r\n  var mobileOpera = mobile && opera;\r\n\r\n  // @property mobileGecko: Boolean\r\n  // `true` for gecko-based browsers running in a mobile device.\r\n  var mobileGecko = mobile && gecko;\r\n\r\n  // @property retina: Boolean\r\n  // `true` for browsers on a high-resolution \"retina\" screen or on any screen when browser's display zoom is more than 100%.\r\n  var retina = (window.devicePixelRatio || (window.screen.deviceXDPI / window.screen.logicalXDPI)) > 1;\r\n\r\n  // @property passiveEvents: Boolean\r\n  // `true` for browsers that support passive events.\r\n  var passiveEvents = (function () {\r\n  \tvar supportsPassiveOption = false;\r\n  \ttry {\r\n  \t\tvar opts = Object.defineProperty({}, 'passive', {\r\n  \t\t\tget: function () { // eslint-disable-line getter-return\r\n  \t\t\t\tsupportsPassiveOption = true;\r\n  \t\t\t}\r\n  \t\t});\r\n  \t\twindow.addEventListener('testPassiveEventSupport', falseFn, opts);\r\n  \t\twindow.removeEventListener('testPassiveEventSupport', falseFn, opts);\r\n  \t} catch (e) {\r\n  \t\t// Errors can safely be ignored since this is only a browser support test.\r\n  \t}\r\n  \treturn supportsPassiveOption;\r\n  }());\r\n\r\n  // @property canvas: Boolean\r\n  // `true` when the browser supports [`<canvas>`](https://developer.mozilla.org/docs/Web/API/Canvas_API).\r\n  var canvas$1 = (function () {\r\n  \treturn !!document.createElement('canvas').getContext;\r\n  }());\r\n\r\n  // @property svg: Boolean\r\n  // `true` when the browser supports [SVG](https://developer.mozilla.org/docs/Web/SVG).\r\n  var svg$1 = !!(document.createElementNS && svgCreate('svg').createSVGRect);\r\n\r\n  var inlineSvg = !!svg$1 && (function () {\r\n  \tvar div = document.createElement('div');\r\n  \tdiv.innerHTML = '<svg/>';\r\n  \treturn (div.firstChild && div.firstChild.namespaceURI) === 'http://www.w3.org/2000/svg';\r\n  })();\r\n\r\n  // @property vml: Boolean\r\n  // `true` if the browser supports [VML](https://en.wikipedia.org/wiki/Vector_Markup_Language).\r\n  var vml = !svg$1 && (function () {\r\n  \ttry {\r\n  \t\tvar div = document.createElement('div');\r\n  \t\tdiv.innerHTML = '<v:shape adj=\"1\"/>';\r\n\r\n  \t\tvar shape = div.firstChild;\r\n  \t\tshape.style.behavior = 'url(#default#VML)';\r\n\r\n  \t\treturn shape && (typeof shape.adj === 'object');\r\n\r\n  \t} catch (e) {\r\n  \t\treturn false;\r\n  \t}\r\n  }());\r\n\r\n\r\n  // @property mac: Boolean; `true` when the browser is running in a Mac platform\r\n  var mac = navigator.platform.indexOf('Mac') === 0;\r\n\r\n  // @property mac: Boolean; `true` when the browser is running in a Linux platform\r\n  var linux = navigator.platform.indexOf('Linux') === 0;\r\n\r\n  function userAgentContains(str) {\r\n  \treturn navigator.userAgent.toLowerCase().indexOf(str) >= 0;\r\n  }\r\n\r\n\r\n  var Browser = {\r\n  \tie: ie,\r\n  \tielt9: ielt9,\r\n  \tedge: edge,\r\n  \twebkit: webkit,\r\n  \tandroid: android,\r\n  \tandroid23: android23,\r\n  \tandroidStock: androidStock,\r\n  \topera: opera,\r\n  \tchrome: chrome,\r\n  \tgecko: gecko,\r\n  \tsafari: safari,\r\n  \tphantom: phantom,\r\n  \topera12: opera12,\r\n  \twin: win,\r\n  \tie3d: ie3d,\r\n  \twebkit3d: webkit3d,\r\n  \tgecko3d: gecko3d,\r\n  \tany3d: any3d,\r\n  \tmobile: mobile,\r\n  \tmobileWebkit: mobileWebkit,\r\n  \tmobileWebkit3d: mobileWebkit3d,\r\n  \tmsPointer: msPointer,\r\n  \tpointer: pointer,\r\n  \ttouch: touch,\r\n  \ttouchNative: touchNative,\r\n  \tmobileOpera: mobileOpera,\r\n  \tmobileGecko: mobileGecko,\r\n  \tretina: retina,\r\n  \tpassiveEvents: passiveEvents,\r\n  \tcanvas: canvas$1,\r\n  \tsvg: svg$1,\r\n  \tvml: vml,\r\n  \tinlineSvg: inlineSvg,\r\n  \tmac: mac,\r\n  \tlinux: linux\r\n  };\n\n  /*\n   * Extends L.DomEvent to provide touch support for Internet Explorer and Windows-based devices.\n   */\n\n  var POINTER_DOWN =   Browser.msPointer ? 'MSPointerDown'   : 'pointerdown';\n  var POINTER_MOVE =   Browser.msPointer ? 'MSPointerMove'   : 'pointermove';\n  var POINTER_UP =     Browser.msPointer ? 'MSPointerUp'     : 'pointerup';\n  var POINTER_CANCEL = Browser.msPointer ? 'MSPointerCancel' : 'pointercancel';\n  var pEvent = {\n  \ttouchstart  : POINTER_DOWN,\n  \ttouchmove   : POINTER_MOVE,\n  \ttouchend    : POINTER_UP,\n  \ttouchcancel : POINTER_CANCEL\n  };\n  var handle = {\n  \ttouchstart  : _onPointerStart,\n  \ttouchmove   : _handlePointer,\n  \ttouchend    : _handlePointer,\n  \ttouchcancel : _handlePointer\n  };\n  var _pointers = {};\n  var _pointerDocListener = false;\n\n  // Provides a touch events wrapper for (ms)pointer events.\n  // ref https://www.w3.org/TR/pointerevents/ https://www.w3.org/Bugs/Public/show_bug.cgi?id=22890\n\n  function addPointerListener(obj, type, handler) {\n  \tif (type === 'touchstart') {\n  \t\t_addPointerDocListener();\n  \t}\n  \tif (!handle[type]) {\n  \t\tconsole.warn('wrong event specified:', type);\n  \t\treturn falseFn;\n  \t}\n  \thandler = handle[type].bind(this, handler);\n  \tobj.addEventListener(pEvent[type], handler, false);\n  \treturn handler;\n  }\n\n  function removePointerListener(obj, type, handler) {\n  \tif (!pEvent[type]) {\n  \t\tconsole.warn('wrong event specified:', type);\n  \t\treturn;\n  \t}\n  \tobj.removeEventListener(pEvent[type], handler, false);\n  }\n\n  function _globalPointerDown(e) {\n  \t_pointers[e.pointerId] = e;\n  }\n\n  function _globalPointerMove(e) {\n  \tif (_pointers[e.pointerId]) {\n  \t\t_pointers[e.pointerId] = e;\n  \t}\n  }\n\n  function _globalPointerUp(e) {\n  \tdelete _pointers[e.pointerId];\n  }\n\n  function _addPointerDocListener() {\n  \t// need to keep track of what pointers and how many are active to provide e.touches emulation\n  \tif (!_pointerDocListener) {\n  \t\t// we listen document as any drags that end by moving the touch off the screen get fired there\n  \t\tdocument.addEventListener(POINTER_DOWN, _globalPointerDown, true);\n  \t\tdocument.addEventListener(POINTER_MOVE, _globalPointerMove, true);\n  \t\tdocument.addEventListener(POINTER_UP, _globalPointerUp, true);\n  \t\tdocument.addEventListener(POINTER_CANCEL, _globalPointerUp, true);\n\n  \t\t_pointerDocListener = true;\n  \t}\n  }\n\n  function _handlePointer(handler, e) {\n  \tif (e.pointerType === (e.MSPOINTER_TYPE_MOUSE || 'mouse')) { return; }\n\n  \te.touches = [];\n  \tfor (var i in _pointers) {\n  \t\te.touches.push(_pointers[i]);\n  \t}\n  \te.changedTouches = [e];\n\n  \thandler(e);\n  }\n\n  function _onPointerStart(handler, e) {\n  \t// IE10 specific: MsTouch needs preventDefault. See #2000\n  \tif (e.MSPOINTER_TYPE_TOUCH && e.pointerType === e.MSPOINTER_TYPE_TOUCH) {\n  \t\tpreventDefault(e);\n  \t}\n  \t_handlePointer(handler, e);\n  }\n\n  /*\r\n   * Extends the event handling code with double tap support for mobile browsers.\r\n   *\r\n   * Note: currently most browsers fire native dblclick, with only a few exceptions\r\n   * (see https://github.com/Leaflet/Leaflet/issues/7012#issuecomment-595087386)\r\n   */\r\n\r\n  function makeDblclick(event) {\r\n  \t// in modern browsers `type` cannot be just overridden:\r\n  \t// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Getter_only\r\n  \tvar newEvent = {},\r\n  \t    prop, i;\r\n  \tfor (i in event) {\r\n  \t\tprop = event[i];\r\n  \t\tnewEvent[i] = prop && prop.bind ? prop.bind(event) : prop;\r\n  \t}\r\n  \tevent = newEvent;\r\n  \tnewEvent.type = 'dblclick';\r\n  \tnewEvent.detail = 2;\r\n  \tnewEvent.isTrusted = false;\r\n  \tnewEvent._simulated = true; // for debug purposes\r\n  \treturn newEvent;\r\n  }\r\n\r\n  var delay = 200;\r\n  function addDoubleTapListener(obj, handler) {\r\n  \t// Most browsers handle double tap natively\r\n  \tobj.addEventListener('dblclick', handler);\r\n\r\n  \t// On some platforms the browser doesn't fire native dblclicks for touch events.\r\n  \t// It seems that in all such cases `detail` property of `click` event is always `1`.\r\n  \t// So here we rely on that fact to avoid excessive 'dblclick' simulation when not needed.\r\n  \tvar last = 0,\r\n  \t    detail;\r\n  \tfunction simDblclick(e) {\r\n  \t\tif (e.detail !== 1) {\r\n  \t\t\tdetail = e.detail; // keep in sync to avoid false dblclick in some cases\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tif (e.pointerType === 'mouse' ||\r\n  \t\t\t(e.sourceCapabilities && !e.sourceCapabilities.firesTouchEvents)) {\r\n\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\t// When clicking on an <input>, the browser generates a click on its\r\n  \t\t// <label> (and vice versa) triggering two clicks in quick succession.\r\n  \t\t// This ignores clicks on elements which are a label with a 'for'\r\n  \t\t// attribute (or children of such a label), but not children of\r\n  \t\t// a <input>.\r\n  \t\tvar path = getPropagationPath(e);\r\n  \t\tif (path.some(function (el) {\r\n  \t\t\treturn el instanceof HTMLLabelElement && el.attributes.for;\r\n  \t\t}) &&\r\n  \t\t\t!path.some(function (el) {\r\n  \t\t\t\treturn (\r\n  \t\t\t\t\tel instanceof HTMLInputElement ||\r\n  \t\t\t\t\tel instanceof HTMLSelectElement\r\n  \t\t\t\t);\r\n  \t\t\t})\r\n  \t\t) {\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tvar now = Date.now();\r\n  \t\tif (now - last <= delay) {\r\n  \t\t\tdetail++;\r\n  \t\t\tif (detail === 2) {\r\n  \t\t\t\thandler(makeDblclick(e));\r\n  \t\t\t}\r\n  \t\t} else {\r\n  \t\t\tdetail = 1;\r\n  \t\t}\r\n  \t\tlast = now;\r\n  \t}\r\n\r\n  \tobj.addEventListener('click', simDblclick);\r\n\r\n  \treturn {\r\n  \t\tdblclick: handler,\r\n  \t\tsimDblclick: simDblclick\r\n  \t};\r\n  }\r\n\r\n  function removeDoubleTapListener(obj, handlers) {\r\n  \tobj.removeEventListener('dblclick', handlers.dblclick);\r\n  \tobj.removeEventListener('click', handlers.simDblclick);\r\n  }\n\n  /*\r\n   * @namespace DomUtil\r\n   *\r\n   * Utility functions to work with the [DOM](https://developer.mozilla.org/docs/Web/API/Document_Object_Model)\r\n   * tree, used by Leaflet internally.\r\n   *\r\n   * Most functions expecting or returning a `HTMLElement` also work for\r\n   * SVG elements. The only difference is that classes refer to CSS classes\r\n   * in HTML and SVG classes in SVG.\r\n   */\r\n\r\n\r\n  // @property TRANSFORM: String\r\n  // Vendor-prefixed transform style name (e.g. `'webkitTransform'` for WebKit).\r\n  var TRANSFORM = testProp(\r\n  \t['transform', 'webkitTransform', 'OTransform', 'MozTransform', 'msTransform']);\r\n\r\n  // webkitTransition comes first because some browser versions that drop vendor prefix don't do\r\n  // the same for the transitionend event, in particular the Android 4.1 stock browser\r\n\r\n  // @property TRANSITION: String\r\n  // Vendor-prefixed transition style name.\r\n  var TRANSITION = testProp(\r\n  \t['webkitTransition', 'transition', 'OTransition', 'MozTransition', 'msTransition']);\r\n\r\n  // @property TRANSITION_END: String\r\n  // Vendor-prefixed transitionend event name.\r\n  var TRANSITION_END =\r\n  \tTRANSITION === 'webkitTransition' || TRANSITION === 'OTransition' ? TRANSITION + 'End' : 'transitionend';\r\n\r\n\r\n  // @function get(id: String|HTMLElement): HTMLElement\r\n  // Returns an element given its DOM id, or returns the element itself\r\n  // if it was passed directly.\r\n  function get(id) {\r\n  \treturn typeof id === 'string' ? document.getElementById(id) : id;\r\n  }\r\n\r\n  // @function getStyle(el: HTMLElement, styleAttrib: String): String\r\n  // Returns the value for a certain style attribute on an element,\r\n  // including computed values or values set through CSS.\r\n  function getStyle(el, style) {\r\n  \tvar value = el.style[style] || (el.currentStyle && el.currentStyle[style]);\r\n\r\n  \tif ((!value || value === 'auto') && document.defaultView) {\r\n  \t\tvar css = document.defaultView.getComputedStyle(el, null);\r\n  \t\tvalue = css ? css[style] : null;\r\n  \t}\r\n  \treturn value === 'auto' ? null : value;\r\n  }\r\n\r\n  // @function create(tagName: String, className?: String, container?: HTMLElement): HTMLElement\r\n  // Creates an HTML element with `tagName`, sets its class to `className`, and optionally appends it to `container` element.\r\n  function create$1(tagName, className, container) {\r\n  \tvar el = document.createElement(tagName);\r\n  \tel.className = className || '';\r\n\r\n  \tif (container) {\r\n  \t\tcontainer.appendChild(el);\r\n  \t}\r\n  \treturn el;\r\n  }\r\n\r\n  // @function remove(el: HTMLElement)\r\n  // Removes `el` from its parent element\r\n  function remove(el) {\r\n  \tvar parent = el.parentNode;\r\n  \tif (parent) {\r\n  \t\tparent.removeChild(el);\r\n  \t}\r\n  }\r\n\r\n  // @function empty(el: HTMLElement)\r\n  // Removes all of `el`'s children elements from `el`\r\n  function empty(el) {\r\n  \twhile (el.firstChild) {\r\n  \t\tel.removeChild(el.firstChild);\r\n  \t}\r\n  }\r\n\r\n  // @function toFront(el: HTMLElement)\r\n  // Makes `el` the last child of its parent, so it renders in front of the other children.\r\n  function toFront(el) {\r\n  \tvar parent = el.parentNode;\r\n  \tif (parent && parent.lastChild !== el) {\r\n  \t\tparent.appendChild(el);\r\n  \t}\r\n  }\r\n\r\n  // @function toBack(el: HTMLElement)\r\n  // Makes `el` the first child of its parent, so it renders behind the other children.\r\n  function toBack(el) {\r\n  \tvar parent = el.parentNode;\r\n  \tif (parent && parent.firstChild !== el) {\r\n  \t\tparent.insertBefore(el, parent.firstChild);\r\n  \t}\r\n  }\r\n\r\n  // @function hasClass(el: HTMLElement, name: String): Boolean\r\n  // Returns `true` if the element's class attribute contains `name`.\r\n  function hasClass(el, name) {\r\n  \tif (el.classList !== undefined) {\r\n  \t\treturn el.classList.contains(name);\r\n  \t}\r\n  \tvar className = getClass(el);\r\n  \treturn className.length > 0 && new RegExp('(^|\\\\s)' + name + '(\\\\s|$)').test(className);\r\n  }\r\n\r\n  // @function addClass(el: HTMLElement, name: String)\r\n  // Adds `name` to the element's class attribute.\r\n  function addClass(el, name) {\r\n  \tif (el.classList !== undefined) {\r\n  \t\tvar classes = splitWords(name);\r\n  \t\tfor (var i = 0, len = classes.length; i < len; i++) {\r\n  \t\t\tel.classList.add(classes[i]);\r\n  \t\t}\r\n  \t} else if (!hasClass(el, name)) {\r\n  \t\tvar className = getClass(el);\r\n  \t\tsetClass(el, (className ? className + ' ' : '') + name);\r\n  \t}\r\n  }\r\n\r\n  // @function removeClass(el: HTMLElement, name: String)\r\n  // Removes `name` from the element's class attribute.\r\n  function removeClass(el, name) {\r\n  \tif (el.classList !== undefined) {\r\n  \t\tel.classList.remove(name);\r\n  \t} else {\r\n  \t\tsetClass(el, trim((' ' + getClass(el) + ' ').replace(' ' + name + ' ', ' ')));\r\n  \t}\r\n  }\r\n\r\n  // @function setClass(el: HTMLElement, name: String)\r\n  // Sets the element's class.\r\n  function setClass(el, name) {\r\n  \tif (el.className.baseVal === undefined) {\r\n  \t\tel.className = name;\r\n  \t} else {\r\n  \t\t// in case of SVG element\r\n  \t\tel.className.baseVal = name;\r\n  \t}\r\n  }\r\n\r\n  // @function getClass(el: HTMLElement): String\r\n  // Returns the element's class.\r\n  function getClass(el) {\r\n  \t// Check if the element is an SVGElementInstance and use the correspondingElement instead\r\n  \t// (Required for linked SVG elements in IE11.)\r\n  \tif (el.correspondingElement) {\r\n  \t\tel = el.correspondingElement;\r\n  \t}\r\n  \treturn el.className.baseVal === undefined ? el.className : el.className.baseVal;\r\n  }\r\n\r\n  // @function setOpacity(el: HTMLElement, opacity: Number)\r\n  // Set the opacity of an element (including old IE support).\r\n  // `opacity` must be a number from `0` to `1`.\r\n  function setOpacity(el, value) {\r\n  \tif ('opacity' in el.style) {\r\n  \t\tel.style.opacity = value;\r\n  \t} else if ('filter' in el.style) {\r\n  \t\t_setOpacityIE(el, value);\r\n  \t}\r\n  }\r\n\r\n  function _setOpacityIE(el, value) {\r\n  \tvar filter = false,\r\n  \t    filterName = 'DXImageTransform.Microsoft.Alpha';\r\n\r\n  \t// filters collection throws an error if we try to retrieve a filter that doesn't exist\r\n  \ttry {\r\n  \t\tfilter = el.filters.item(filterName);\r\n  \t} catch (e) {\r\n  \t\t// don't set opacity to 1 if we haven't already set an opacity,\r\n  \t\t// it isn't needed and breaks transparent pngs.\r\n  \t\tif (value === 1) { return; }\r\n  \t}\r\n\r\n  \tvalue = Math.round(value * 100);\r\n\r\n  \tif (filter) {\r\n  \t\tfilter.Enabled = (value !== 100);\r\n  \t\tfilter.Opacity = value;\r\n  \t} else {\r\n  \t\tel.style.filter += ' progid:' + filterName + '(opacity=' + value + ')';\r\n  \t}\r\n  }\r\n\r\n  // @function testProp(props: String[]): String|false\r\n  // Goes through the array of style names and returns the first name\r\n  // that is a valid style name for an element. If no such name is found,\r\n  // it returns false. Useful for vendor-prefixed styles like `transform`.\r\n  function testProp(props) {\r\n  \tvar style = document.documentElement.style;\r\n\r\n  \tfor (var i = 0; i < props.length; i++) {\r\n  \t\tif (props[i] in style) {\r\n  \t\t\treturn props[i];\r\n  \t\t}\r\n  \t}\r\n  \treturn false;\r\n  }\r\n\r\n  // @function setTransform(el: HTMLElement, offset: Point, scale?: Number)\r\n  // Resets the 3D CSS transform of `el` so it is translated by `offset` pixels\r\n  // and optionally scaled by `scale`. Does not have an effect if the\r\n  // browser doesn't support 3D CSS transforms.\r\n  function setTransform(el, offset, scale) {\r\n  \tvar pos = offset || new Point(0, 0);\r\n\r\n  \tel.style[TRANSFORM] =\r\n  \t\t(Browser.ie3d ?\r\n  \t\t\t'translate(' + pos.x + 'px,' + pos.y + 'px)' :\r\n  \t\t\t'translate3d(' + pos.x + 'px,' + pos.y + 'px,0)') +\r\n  \t\t(scale ? ' scale(' + scale + ')' : '');\r\n  }\r\n\r\n  // @function setPosition(el: HTMLElement, position: Point)\r\n  // Sets the position of `el` to coordinates specified by `position`,\r\n  // using CSS translate or top/left positioning depending on the browser\r\n  // (used by Leaflet internally to position its layers).\r\n  function setPosition(el, point) {\r\n\r\n  \t/*eslint-disable */\r\n  \tel._leaflet_pos = point;\r\n  \t/* eslint-enable */\r\n\r\n  \tif (Browser.any3d) {\r\n  \t\tsetTransform(el, point);\r\n  \t} else {\r\n  \t\tel.style.left = point.x + 'px';\r\n  \t\tel.style.top = point.y + 'px';\r\n  \t}\r\n  }\r\n\r\n  // @function getPosition(el: HTMLElement): Point\r\n  // Returns the coordinates of an element previously positioned with setPosition.\r\n  function getPosition(el) {\r\n  \t// this method is only used for elements previously positioned using setPosition,\r\n  \t// so it's safe to cache the position for performance\r\n\r\n  \treturn el._leaflet_pos || new Point(0, 0);\r\n  }\r\n\r\n  // @function disableTextSelection()\r\n  // Prevents the user from generating `selectstart` DOM events, usually generated\r\n  // when the user drags the mouse through a page with text. Used internally\r\n  // by Leaflet to override the behaviour of any click-and-drag interaction on\r\n  // the map. Affects drag interactions on the whole document.\r\n\r\n  // @function enableTextSelection()\r\n  // Cancels the effects of a previous [`L.DomUtil.disableTextSelection`](#domutil-disabletextselection).\r\n  var disableTextSelection;\r\n  var enableTextSelection;\r\n  var _userSelect;\r\n  if ('onselectstart' in document) {\r\n  \tdisableTextSelection = function () {\r\n  \t\ton(window, 'selectstart', preventDefault);\r\n  \t};\r\n  \tenableTextSelection = function () {\r\n  \t\toff(window, 'selectstart', preventDefault);\r\n  \t};\r\n  } else {\r\n  \tvar userSelectProperty = testProp(\r\n  \t\t['userSelect', 'WebkitUserSelect', 'OUserSelect', 'MozUserSelect', 'msUserSelect']);\r\n\r\n  \tdisableTextSelection = function () {\r\n  \t\tif (userSelectProperty) {\r\n  \t\t\tvar style = document.documentElement.style;\r\n  \t\t\t_userSelect = style[userSelectProperty];\r\n  \t\t\tstyle[userSelectProperty] = 'none';\r\n  \t\t}\r\n  \t};\r\n  \tenableTextSelection = function () {\r\n  \t\tif (userSelectProperty) {\r\n  \t\t\tdocument.documentElement.style[userSelectProperty] = _userSelect;\r\n  \t\t\t_userSelect = undefined;\r\n  \t\t}\r\n  \t};\r\n  }\r\n\r\n  // @function disableImageDrag()\r\n  // As [`L.DomUtil.disableTextSelection`](#domutil-disabletextselection), but\r\n  // for `dragstart` DOM events, usually generated when the user drags an image.\r\n  function disableImageDrag() {\r\n  \ton(window, 'dragstart', preventDefault);\r\n  }\r\n\r\n  // @function enableImageDrag()\r\n  // Cancels the effects of a previous [`L.DomUtil.disableImageDrag`](#domutil-disabletextselection).\r\n  function enableImageDrag() {\r\n  \toff(window, 'dragstart', preventDefault);\r\n  }\r\n\r\n  var _outlineElement, _outlineStyle;\r\n  // @function preventOutline(el: HTMLElement)\r\n  // Makes the [outline](https://developer.mozilla.org/docs/Web/CSS/outline)\r\n  // of the element `el` invisible. Used internally by Leaflet to prevent\r\n  // focusable elements from displaying an outline when the user performs a\r\n  // drag interaction on them.\r\n  function preventOutline(element) {\r\n  \twhile (element.tabIndex === -1) {\r\n  \t\telement = element.parentNode;\r\n  \t}\r\n  \tif (!element.style) { return; }\r\n  \trestoreOutline();\r\n  \t_outlineElement = element;\r\n  \t_outlineStyle = element.style.outline;\r\n  \telement.style.outline = 'none';\r\n  \ton(window, 'keydown', restoreOutline);\r\n  }\r\n\r\n  // @function restoreOutline()\r\n  // Cancels the effects of a previous [`L.DomUtil.preventOutline`]().\r\n  function restoreOutline() {\r\n  \tif (!_outlineElement) { return; }\r\n  \t_outlineElement.style.outline = _outlineStyle;\r\n  \t_outlineElement = undefined;\r\n  \t_outlineStyle = undefined;\r\n  \toff(window, 'keydown', restoreOutline);\r\n  }\r\n\r\n  // @function getSizedParentNode(el: HTMLElement): HTMLElement\r\n  // Finds the closest parent node which size (width and height) is not null.\r\n  function getSizedParentNode(element) {\r\n  \tdo {\r\n  \t\telement = element.parentNode;\r\n  \t} while ((!element.offsetWidth || !element.offsetHeight) && element !== document.body);\r\n  \treturn element;\r\n  }\r\n\r\n  // @function getScale(el: HTMLElement): Object\r\n  // Computes the CSS scale currently applied on the element.\r\n  // Returns an object with `x` and `y` members as horizontal and vertical scales respectively,\r\n  // and `boundingClientRect` as the result of [`getBoundingClientRect()`](https://developer.mozilla.org/en-US/docs/Web/API/Element/getBoundingClientRect).\r\n  function getScale(element) {\r\n  \tvar rect = element.getBoundingClientRect(); // Read-only in old browsers.\r\n\r\n  \treturn {\r\n  \t\tx: rect.width / element.offsetWidth || 1,\r\n  \t\ty: rect.height / element.offsetHeight || 1,\r\n  \t\tboundingClientRect: rect\r\n  \t};\r\n  }\n\n  var DomUtil = {\n    __proto__: null,\n    TRANSFORM: TRANSFORM,\n    TRANSITION: TRANSITION,\n    TRANSITION_END: TRANSITION_END,\n    get: get,\n    getStyle: getStyle,\n    create: create$1,\n    remove: remove,\n    empty: empty,\n    toFront: toFront,\n    toBack: toBack,\n    hasClass: hasClass,\n    addClass: addClass,\n    removeClass: removeClass,\n    setClass: setClass,\n    getClass: getClass,\n    setOpacity: setOpacity,\n    testProp: testProp,\n    setTransform: setTransform,\n    setPosition: setPosition,\n    getPosition: getPosition,\n    get disableTextSelection () { return disableTextSelection; },\n    get enableTextSelection () { return enableTextSelection; },\n    disableImageDrag: disableImageDrag,\n    enableImageDrag: enableImageDrag,\n    preventOutline: preventOutline,\n    restoreOutline: restoreOutline,\n    getSizedParentNode: getSizedParentNode,\n    getScale: getScale\n  };\n\n  /*\r\n   * @namespace DomEvent\r\n   * Utility functions to work with the [DOM events](https://developer.mozilla.org/docs/Web/API/Event), used by Leaflet internally.\r\n   */\r\n\r\n  // Inspired by John Resig, Dean Edwards and YUI addEvent implementations.\r\n\r\n  // @function on(el: HTMLElement, types: String, fn: Function, context?: Object): this\r\n  // Adds a listener function (`fn`) to a particular DOM event type of the\r\n  // element `el`. You can optionally specify the context of the listener\r\n  // (object the `this` keyword will point to). You can also pass several\r\n  // space-separated types (e.g. `'click dblclick'`).\r\n\r\n  // @alternative\r\n  // @function on(el: HTMLElement, eventMap: Object, context?: Object): this\r\n  // Adds a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`\r\n  function on(obj, types, fn, context) {\r\n\r\n  \tif (types && typeof types === 'object') {\r\n  \t\tfor (var type in types) {\r\n  \t\t\taddOne(obj, type, types[type], fn);\r\n  \t\t}\r\n  \t} else {\r\n  \t\ttypes = splitWords(types);\r\n\r\n  \t\tfor (var i = 0, len = types.length; i < len; i++) {\r\n  \t\t\taddOne(obj, types[i], fn, context);\r\n  \t\t}\r\n  \t}\r\n\r\n  \treturn this;\r\n  }\r\n\r\n  var eventsKey = '_leaflet_events';\r\n\r\n  // @function off(el: HTMLElement, types: String, fn: Function, context?: Object): this\r\n  // Removes a previously added listener function.\r\n  // Note that if you passed a custom context to on, you must pass the same\r\n  // context to `off` in order to remove the listener.\r\n\r\n  // @alternative\r\n  // @function off(el: HTMLElement, eventMap: Object, context?: Object): this\r\n  // Removes a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`\r\n\r\n  // @alternative\r\n  // @function off(el: HTMLElement, types: String): this\r\n  // Removes all previously added listeners of given types.\r\n\r\n  // @alternative\r\n  // @function off(el: HTMLElement): this\r\n  // Removes all previously added listeners from given HTMLElement\r\n  function off(obj, types, fn, context) {\r\n\r\n  \tif (arguments.length === 1) {\r\n  \t\tbatchRemove(obj);\r\n  \t\tdelete obj[eventsKey];\r\n\r\n  \t} else if (types && typeof types === 'object') {\r\n  \t\tfor (var type in types) {\r\n  \t\t\tremoveOne(obj, type, types[type], fn);\r\n  \t\t}\r\n\r\n  \t} else {\r\n  \t\ttypes = splitWords(types);\r\n\r\n  \t\tif (arguments.length === 2) {\r\n  \t\t\tbatchRemove(obj, function (type) {\r\n  \t\t\t\treturn indexOf(types, type) !== -1;\r\n  \t\t\t});\r\n  \t\t} else {\r\n  \t\t\tfor (var i = 0, len = types.length; i < len; i++) {\r\n  \t\t\t\tremoveOne(obj, types[i], fn, context);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t}\r\n\r\n  \treturn this;\r\n  }\r\n\r\n  function batchRemove(obj, filterFn) {\r\n  \tfor (var id in obj[eventsKey]) {\r\n  \t\tvar type = id.split(/\\d/)[0];\r\n  \t\tif (!filterFn || filterFn(type)) {\r\n  \t\t\tremoveOne(obj, type, null, null, id);\r\n  \t\t}\r\n  \t}\r\n  }\r\n\r\n  var mouseSubst = {\r\n  \tmouseenter: 'mouseover',\r\n  \tmouseleave: 'mouseout',\r\n  \twheel: !('onwheel' in window) && 'mousewheel'\r\n  };\r\n\r\n  function addOne(obj, type, fn, context) {\r\n  \tvar id = type + stamp(fn) + (context ? '_' + stamp(context) : '');\r\n\r\n  \tif (obj[eventsKey] && obj[eventsKey][id]) { return this; }\r\n\r\n  \tvar handler = function (e) {\r\n  \t\treturn fn.call(context || obj, e || window.event);\r\n  \t};\r\n\r\n  \tvar originalHandler = handler;\r\n\r\n  \tif (!Browser.touchNative && Browser.pointer && type.indexOf('touch') === 0) {\r\n  \t\t// Needs DomEvent.Pointer.js\r\n  \t\thandler = addPointerListener(obj, type, handler);\r\n\r\n  \t} else if (Browser.touch && (type === 'dblclick')) {\r\n  \t\thandler = addDoubleTapListener(obj, handler);\r\n\r\n  \t} else if ('addEventListener' in obj) {\r\n\r\n  \t\tif (type === 'touchstart' || type === 'touchmove' || type === 'wheel' ||  type === 'mousewheel') {\r\n  \t\t\tobj.addEventListener(mouseSubst[type] || type, handler, Browser.passiveEvents ? {passive: false} : false);\r\n\r\n  \t\t} else if (type === 'mouseenter' || type === 'mouseleave') {\r\n  \t\t\thandler = function (e) {\r\n  \t\t\t\te = e || window.event;\r\n  \t\t\t\tif (isExternalTarget(obj, e)) {\r\n  \t\t\t\t\toriginalHandler(e);\r\n  \t\t\t\t}\r\n  \t\t\t};\r\n  \t\t\tobj.addEventListener(mouseSubst[type], handler, false);\r\n\r\n  \t\t} else {\r\n  \t\t\tobj.addEventListener(type, originalHandler, false);\r\n  \t\t}\r\n\r\n  \t} else {\r\n  \t\tobj.attachEvent('on' + type, handler);\r\n  \t}\r\n\r\n  \tobj[eventsKey] = obj[eventsKey] || {};\r\n  \tobj[eventsKey][id] = handler;\r\n  }\r\n\r\n  function removeOne(obj, type, fn, context, id) {\r\n  \tid = id || type + stamp(fn) + (context ? '_' + stamp(context) : '');\r\n  \tvar handler = obj[eventsKey] && obj[eventsKey][id];\r\n\r\n  \tif (!handler) { return this; }\r\n\r\n  \tif (!Browser.touchNative && Browser.pointer && type.indexOf('touch') === 0) {\r\n  \t\tremovePointerListener(obj, type, handler);\r\n\r\n  \t} else if (Browser.touch && (type === 'dblclick')) {\r\n  \t\tremoveDoubleTapListener(obj, handler);\r\n\r\n  \t} else if ('removeEventListener' in obj) {\r\n\r\n  \t\tobj.removeEventListener(mouseSubst[type] || type, handler, false);\r\n\r\n  \t} else {\r\n  \t\tobj.detachEvent('on' + type, handler);\r\n  \t}\r\n\r\n  \tobj[eventsKey][id] = null;\r\n  }\r\n\r\n  // @function stopPropagation(ev: DOMEvent): this\r\n  // Stop the given event from propagation to parent elements. Used inside the listener functions:\r\n  // ```js\r\n  // L.DomEvent.on(div, 'click', function (ev) {\r\n  // \tL.DomEvent.stopPropagation(ev);\r\n  // });\r\n  // ```\r\n  function stopPropagation(e) {\r\n\r\n  \tif (e.stopPropagation) {\r\n  \t\te.stopPropagation();\r\n  \t} else if (e.originalEvent) {  // In case of Leaflet event.\r\n  \t\te.originalEvent._stopped = true;\r\n  \t} else {\r\n  \t\te.cancelBubble = true;\r\n  \t}\r\n\r\n  \treturn this;\r\n  }\r\n\r\n  // @function disableScrollPropagation(el: HTMLElement): this\r\n  // Adds `stopPropagation` to the element's `'wheel'` events (plus browser variants).\r\n  function disableScrollPropagation(el) {\r\n  \taddOne(el, 'wheel', stopPropagation);\r\n  \treturn this;\r\n  }\r\n\r\n  // @function disableClickPropagation(el: HTMLElement): this\r\n  // Adds `stopPropagation` to the element's `'click'`, `'dblclick'`, `'contextmenu'`,\r\n  // `'mousedown'` and `'touchstart'` events (plus browser variants).\r\n  function disableClickPropagation(el) {\r\n  \ton(el, 'mousedown touchstart dblclick contextmenu', stopPropagation);\r\n  \tel['_leaflet_disable_click'] = true;\r\n  \treturn this;\r\n  }\r\n\r\n  // @function preventDefault(ev: DOMEvent): this\r\n  // Prevents the default action of the DOM Event `ev` from happening (such as\r\n  // following a link in the href of the a element, or doing a POST request\r\n  // with page reload when a `<form>` is submitted).\r\n  // Use it inside listener functions.\r\n  function preventDefault(e) {\r\n  \tif (e.preventDefault) {\r\n  \t\te.preventDefault();\r\n  \t} else {\r\n  \t\te.returnValue = false;\r\n  \t}\r\n  \treturn this;\r\n  }\r\n\r\n  // @function stop(ev: DOMEvent): this\r\n  // Does `stopPropagation` and `preventDefault` at the same time.\r\n  function stop(e) {\r\n  \tpreventDefault(e);\r\n  \tstopPropagation(e);\r\n  \treturn this;\r\n  }\r\n\r\n  // @function getPropagationPath(ev: DOMEvent): Array\r\n  // Compatibility polyfill for [`Event.composedPath()`](https://developer.mozilla.org/en-US/docs/Web/API/Event/composedPath).\r\n  // Returns an array containing the `HTMLElement`s that the given DOM event\r\n  // should propagate to (if not stopped).\r\n  function getPropagationPath(ev) {\r\n  \tif (ev.composedPath) {\r\n  \t\treturn ev.composedPath();\r\n  \t}\r\n\r\n  \tvar path = [];\r\n  \tvar el = ev.target;\r\n\r\n  \twhile (el) {\r\n  \t\tpath.push(el);\r\n  \t\tel = el.parentNode;\r\n  \t}\r\n  \treturn path;\r\n  }\r\n\r\n\r\n  // @function getMousePosition(ev: DOMEvent, container?: HTMLElement): Point\r\n  // Gets normalized mouse position from a DOM event relative to the\r\n  // `container` (border excluded) or to the whole page if not specified.\r\n  function getMousePosition(e, container) {\r\n  \tif (!container) {\r\n  \t\treturn new Point(e.clientX, e.clientY);\r\n  \t}\r\n\r\n  \tvar scale = getScale(container),\r\n  \t    offset = scale.boundingClientRect; // left and top  values are in page scale (like the event clientX/Y)\r\n\r\n  \treturn new Point(\r\n  \t\t// offset.left/top values are in page scale (like clientX/Y),\r\n  \t\t// whereas clientLeft/Top (border width) values are the original values (before CSS scale applies).\r\n  \t\t(e.clientX - offset.left) / scale.x - container.clientLeft,\r\n  \t\t(e.clientY - offset.top) / scale.y - container.clientTop\r\n  \t);\r\n  }\r\n\r\n\r\n  //  except , Safari and\r\n  // We need double the scroll pixels (see #7403 and #4538) for all Browsers\r\n  // except OSX (Mac) -> 3x, Chrome running on Linux 1x\r\n\r\n  var wheelPxFactor =\r\n  \t(Browser.linux && Browser.chrome) ? window.devicePixelRatio :\r\n  \tBrowser.mac ? window.devicePixelRatio * 3 :\r\n  \twindow.devicePixelRatio > 0 ? 2 * window.devicePixelRatio : 1;\r\n  // @function getWheelDelta(ev: DOMEvent): Number\r\n  // Gets normalized wheel delta from a wheel DOM event, in vertical\r\n  // pixels scrolled (negative if scrolling down).\r\n  // Events from pointing devices without precise scrolling are mapped to\r\n  // a best guess of 60 pixels.\r\n  function getWheelDelta(e) {\r\n  \treturn (Browser.edge) ? e.wheelDeltaY / 2 : // Don't trust window-geometry-based delta\r\n  \t       (e.deltaY && e.deltaMode === 0) ? -e.deltaY / wheelPxFactor : // Pixels\r\n  \t       (e.deltaY && e.deltaMode === 1) ? -e.deltaY * 20 : // Lines\r\n  \t       (e.deltaY && e.deltaMode === 2) ? -e.deltaY * 60 : // Pages\r\n  \t       (e.deltaX || e.deltaZ) ? 0 :\t// Skip horizontal/depth wheel events\r\n  \t       e.wheelDelta ? (e.wheelDeltaY || e.wheelDelta) / 2 : // Legacy IE pixels\r\n  \t       (e.detail && Math.abs(e.detail) < 32765) ? -e.detail * 20 : // Legacy Moz lines\r\n  \t       e.detail ? e.detail / -32765 * 60 : // Legacy Moz pages\r\n  \t       0;\r\n  }\r\n\r\n  // check if element really left/entered the event target (for mouseenter/mouseleave)\r\n  function isExternalTarget(el, e) {\r\n\r\n  \tvar related = e.relatedTarget;\r\n\r\n  \tif (!related) { return true; }\r\n\r\n  \ttry {\r\n  \t\twhile (related && (related !== el)) {\r\n  \t\t\trelated = related.parentNode;\r\n  \t\t}\r\n  \t} catch (err) {\r\n  \t\treturn false;\r\n  \t}\r\n  \treturn (related !== el);\r\n  }\n\n  var DomEvent = {\n    __proto__: null,\n    on: on,\n    off: off,\n    stopPropagation: stopPropagation,\n    disableScrollPropagation: disableScrollPropagation,\n    disableClickPropagation: disableClickPropagation,\n    preventDefault: preventDefault,\n    stop: stop,\n    getPropagationPath: getPropagationPath,\n    getMousePosition: getMousePosition,\n    getWheelDelta: getWheelDelta,\n    isExternalTarget: isExternalTarget,\n    addListener: on,\n    removeListener: off\n  };\n\n  /*\n   * @class PosAnimation\n   * @aka L.PosAnimation\n   * @inherits Evented\n   * Used internally for panning animations, utilizing CSS3 Transitions for modern browsers and a timer fallback for IE6-9.\n   *\n   * @example\n   * ```js\n   * var myPositionMarker = L.marker([48.864716, 2.294694]).addTo(map);\n   *\n   * myPositionMarker.on(\"click\", function() {\n   * \tvar pos = map.latLngToLayerPoint(myPositionMarker.getLatLng());\n   * \tpos.y -= 25;\n   * \tvar fx = new L.PosAnimation();\n   *\n   * \tfx.once('end',function() {\n   * \t\tpos.y += 25;\n   * \t\tfx.run(myPositionMarker._icon, pos, 0.8);\n   * \t});\n   *\n   * \tfx.run(myPositionMarker._icon, pos, 0.3);\n   * });\n   *\n   * ```\n   *\n   * @constructor L.PosAnimation()\n   * Creates a `PosAnimation` object.\n   *\n   */\n\n  var PosAnimation = Evented.extend({\n\n  \t// @method run(el: HTMLElement, newPos: Point, duration?: Number, easeLinearity?: Number)\n  \t// Run an animation of a given element to a new position, optionally setting\n  \t// duration in seconds (`0.25` by default) and easing linearity factor (3rd\n  \t// argument of the [cubic bezier curve](https://cubic-bezier.com/#0,0,.5,1),\n  \t// `0.5` by default).\n  \trun: function (el, newPos, duration, easeLinearity) {\n  \t\tthis.stop();\n\n  \t\tthis._el = el;\n  \t\tthis._inProgress = true;\n  \t\tthis._duration = duration || 0.25;\n  \t\tthis._easeOutPower = 1 / Math.max(easeLinearity || 0.5, 0.2);\n\n  \t\tthis._startPos = getPosition(el);\n  \t\tthis._offset = newPos.subtract(this._startPos);\n  \t\tthis._startTime = +new Date();\n\n  \t\t// @event start: Event\n  \t\t// Fired when the animation starts\n  \t\tthis.fire('start');\n\n  \t\tthis._animate();\n  \t},\n\n  \t// @method stop()\n  \t// Stops the animation (if currently running).\n  \tstop: function () {\n  \t\tif (!this._inProgress) { return; }\n\n  \t\tthis._step(true);\n  \t\tthis._complete();\n  \t},\n\n  \t_animate: function () {\n  \t\t// animation loop\n  \t\tthis._animId = requestAnimFrame(this._animate, this);\n  \t\tthis._step();\n  \t},\n\n  \t_step: function (round) {\n  \t\tvar elapsed = (+new Date()) - this._startTime,\n  \t\t    duration = this._duration * 1000;\n\n  \t\tif (elapsed < duration) {\n  \t\t\tthis._runFrame(this._easeOut(elapsed / duration), round);\n  \t\t} else {\n  \t\t\tthis._runFrame(1);\n  \t\t\tthis._complete();\n  \t\t}\n  \t},\n\n  \t_runFrame: function (progress, round) {\n  \t\tvar pos = this._startPos.add(this._offset.multiplyBy(progress));\n  \t\tif (round) {\n  \t\t\tpos._round();\n  \t\t}\n  \t\tsetPosition(this._el, pos);\n\n  \t\t// @event step: Event\n  \t\t// Fired continuously during the animation.\n  \t\tthis.fire('step');\n  \t},\n\n  \t_complete: function () {\n  \t\tcancelAnimFrame(this._animId);\n\n  \t\tthis._inProgress = false;\n  \t\t// @event end: Event\n  \t\t// Fired when the animation ends.\n  \t\tthis.fire('end');\n  \t},\n\n  \t_easeOut: function (t) {\n  \t\treturn 1 - Math.pow(1 - t, this._easeOutPower);\n  \t}\n  });\n\n  /*\r\n   * @class Map\r\n   * @aka L.Map\r\n   * @inherits Evented\r\n   *\r\n   * The central class of the API — it is used to create a map on a page and manipulate it.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * // initialize the map on the \"map\" div with a given center and zoom\r\n   * var map = L.map('map', {\r\n   * \tcenter: [51.505, -0.09],\r\n   * \tzoom: 13\r\n   * });\r\n   * ```\r\n   *\r\n   */\r\n\r\n  var Map = Evented.extend({\r\n\r\n  \toptions: {\r\n  \t\t// @section Map State Options\r\n  \t\t// @option crs: CRS = L.CRS.EPSG3857\r\n  \t\t// The [Coordinate Reference System](#crs) to use. Don't change this if you're not\r\n  \t\t// sure what it means.\r\n  \t\tcrs: EPSG3857,\r\n\r\n  \t\t// @option center: LatLng = undefined\r\n  \t\t// Initial geographic center of the map\r\n  \t\tcenter: undefined,\r\n\r\n  \t\t// @option zoom: Number = undefined\r\n  \t\t// Initial map zoom level\r\n  \t\tzoom: undefined,\r\n\r\n  \t\t// @option minZoom: Number = *\r\n  \t\t// Minimum zoom level of the map.\r\n  \t\t// If not specified and at least one `GridLayer` or `TileLayer` is in the map,\r\n  \t\t// the lowest of their `minZoom` options will be used instead.\r\n  \t\tminZoom: undefined,\r\n\r\n  \t\t// @option maxZoom: Number = *\r\n  \t\t// Maximum zoom level of the map.\r\n  \t\t// If not specified and at least one `GridLayer` or `TileLayer` is in the map,\r\n  \t\t// the highest of their `maxZoom` options will be used instead.\r\n  \t\tmaxZoom: undefined,\r\n\r\n  \t\t// @option layers: Layer[] = []\r\n  \t\t// Array of layers that will be added to the map initially\r\n  \t\tlayers: [],\r\n\r\n  \t\t// @option maxBounds: LatLngBounds = null\r\n  \t\t// When this option is set, the map restricts the view to the given\r\n  \t\t// geographical bounds, bouncing the user back if the user tries to pan\r\n  \t\t// outside the view. To set the restriction dynamically, use\r\n  \t\t// [`setMaxBounds`](#map-setmaxbounds) method.\r\n  \t\tmaxBounds: undefined,\r\n\r\n  \t\t// @option renderer: Renderer = *\r\n  \t\t// The default method for drawing vector layers on the map. `L.SVG`\r\n  \t\t// or `L.Canvas` by default depending on browser support.\r\n  \t\trenderer: undefined,\r\n\r\n\r\n  \t\t// @section Animation Options\r\n  \t\t// @option zoomAnimation: Boolean = true\r\n  \t\t// Whether the map zoom animation is enabled. By default it's enabled\r\n  \t\t// in all browsers that support CSS3 Transitions except Android.\r\n  \t\tzoomAnimation: true,\r\n\r\n  \t\t// @option zoomAnimationThreshold: Number = 4\r\n  \t\t// Won't animate zoom if the zoom difference exceeds this value.\r\n  \t\tzoomAnimationThreshold: 4,\r\n\r\n  \t\t// @option fadeAnimation: Boolean = true\r\n  \t\t// Whether the tile fade animation is enabled. By default it's enabled\r\n  \t\t// in all browsers that support CSS3 Transitions except Android.\r\n  \t\tfadeAnimation: true,\r\n\r\n  \t\t// @option markerZoomAnimation: Boolean = true\r\n  \t\t// Whether markers animate their zoom with the zoom animation, if disabled\r\n  \t\t// they will disappear for the length of the animation. By default it's\r\n  \t\t// enabled in all browsers that support CSS3 Transitions except Android.\r\n  \t\tmarkerZoomAnimation: true,\r\n\r\n  \t\t// @option transform3DLimit: Number = 2^23\r\n  \t\t// Defines the maximum size of a CSS translation transform. The default\r\n  \t\t// value should not be changed unless a web browser positions layers in\r\n  \t\t// the wrong place after doing a large `panBy`.\r\n  \t\ttransform3DLimit: 8388608, // Precision limit of a 32-bit float\r\n\r\n  \t\t// @section Interaction Options\r\n  \t\t// @option zoomSnap: Number = 1\r\n  \t\t// Forces the map's zoom level to always be a multiple of this, particularly\r\n  \t\t// right after a [`fitBounds()`](#map-fitbounds) or a pinch-zoom.\r\n  \t\t// By default, the zoom level snaps to the nearest integer; lower values\r\n  \t\t// (e.g. `0.5` or `0.1`) allow for greater granularity. A value of `0`\r\n  \t\t// means the zoom level will not be snapped after `fitBounds` or a pinch-zoom.\r\n  \t\tzoomSnap: 1,\r\n\r\n  \t\t// @option zoomDelta: Number = 1\r\n  \t\t// Controls how much the map's zoom level will change after a\r\n  \t\t// [`zoomIn()`](#map-zoomin), [`zoomOut()`](#map-zoomout), pressing `+`\r\n  \t\t// or `-` on the keyboard, or using the [zoom controls](#control-zoom).\r\n  \t\t// Values smaller than `1` (e.g. `0.5`) allow for greater granularity.\r\n  \t\tzoomDelta: 1,\r\n\r\n  \t\t// @option trackResize: Boolean = true\r\n  \t\t// Whether the map automatically handles browser window resize to update itself.\r\n  \t\ttrackResize: true\r\n  \t},\r\n\r\n  \tinitialize: function (id, options) { // (HTMLElement or String, Object)\r\n  \t\toptions = setOptions(this, options);\r\n\r\n  \t\t// Make sure to assign internal flags at the beginning,\r\n  \t\t// to avoid inconsistent state in some edge cases.\r\n  \t\tthis._handlers = [];\r\n  \t\tthis._layers = {};\r\n  \t\tthis._zoomBoundLayers = {};\r\n  \t\tthis._sizeChanged = true;\r\n\r\n  \t\tthis._initContainer(id);\r\n  \t\tthis._initLayout();\r\n\r\n  \t\t// hack for https://github.com/Leaflet/Leaflet/issues/1980\r\n  \t\tthis._onResize = bind(this._onResize, this);\r\n\r\n  \t\tthis._initEvents();\r\n\r\n  \t\tif (options.maxBounds) {\r\n  \t\t\tthis.setMaxBounds(options.maxBounds);\r\n  \t\t}\r\n\r\n  \t\tif (options.zoom !== undefined) {\r\n  \t\t\tthis._zoom = this._limitZoom(options.zoom);\r\n  \t\t}\r\n\r\n  \t\tif (options.center && options.zoom !== undefined) {\r\n  \t\t\tthis.setView(toLatLng(options.center), options.zoom, {reset: true});\r\n  \t\t}\r\n\r\n  \t\tthis.callInitHooks();\r\n\r\n  \t\t// don't animate on browsers without hardware-accelerated transitions or old Android/Opera\r\n  \t\tthis._zoomAnimated = TRANSITION && Browser.any3d && !Browser.mobileOpera &&\r\n  \t\t\t\tthis.options.zoomAnimation;\r\n\r\n  \t\t// zoom transitions run with the same duration for all layers, so if one of transitionend events\r\n  \t\t// happens after starting zoom animation (propagating to the map pane), we know that it ended globally\r\n  \t\tif (this._zoomAnimated) {\r\n  \t\t\tthis._createAnimProxy();\r\n  \t\t\ton(this._proxy, TRANSITION_END, this._catchTransitionEnd, this);\r\n  \t\t}\r\n\r\n  \t\tthis._addLayers(this.options.layers);\r\n  \t},\r\n\r\n\r\n  \t// @section Methods for modifying map state\r\n\r\n  \t// @method setView(center: LatLng, zoom: Number, options?: Zoom/pan options): this\r\n  \t// Sets the view of the map (geographical center and zoom) with the given\r\n  \t// animation options.\r\n  \tsetView: function (center, zoom, options) {\r\n\r\n  \t\tzoom = zoom === undefined ? this._zoom : this._limitZoom(zoom);\r\n  \t\tcenter = this._limitCenter(toLatLng(center), zoom, this.options.maxBounds);\r\n  \t\toptions = options || {};\r\n\r\n  \t\tthis._stop();\r\n\r\n  \t\tif (this._loaded && !options.reset && options !== true) {\r\n\r\n  \t\t\tif (options.animate !== undefined) {\r\n  \t\t\t\toptions.zoom = extend({animate: options.animate}, options.zoom);\r\n  \t\t\t\toptions.pan = extend({animate: options.animate, duration: options.duration}, options.pan);\r\n  \t\t\t}\r\n\r\n  \t\t\t// try animating pan or zoom\r\n  \t\t\tvar moved = (this._zoom !== zoom) ?\r\n  \t\t\t\tthis._tryAnimatedZoom && this._tryAnimatedZoom(center, zoom, options.zoom) :\r\n  \t\t\t\tthis._tryAnimatedPan(center, options.pan);\r\n\r\n  \t\t\tif (moved) {\r\n  \t\t\t\t// prevent resize handler call, the view will refresh after animation anyway\r\n  \t\t\t\tclearTimeout(this._sizeTimer);\r\n  \t\t\t\treturn this;\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\t// animation didn't start, just reset the map view\r\n  \t\tthis._resetView(center, zoom, options.pan && options.pan.noMoveStart);\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method setZoom(zoom: Number, options?: Zoom/pan options): this\r\n  \t// Sets the zoom of the map.\r\n  \tsetZoom: function (zoom, options) {\r\n  \t\tif (!this._loaded) {\r\n  \t\t\tthis._zoom = zoom;\r\n  \t\t\treturn this;\r\n  \t\t}\r\n  \t\treturn this.setView(this.getCenter(), zoom, {zoom: options});\r\n  \t},\r\n\r\n  \t// @method zoomIn(delta?: Number, options?: Zoom options): this\r\n  \t// Increases the zoom of the map by `delta` ([`zoomDelta`](#map-zoomdelta) by default).\r\n  \tzoomIn: function (delta, options) {\r\n  \t\tdelta = delta || (Browser.any3d ? this.options.zoomDelta : 1);\r\n  \t\treturn this.setZoom(this._zoom + delta, options);\r\n  \t},\r\n\r\n  \t// @method zoomOut(delta?: Number, options?: Zoom options): this\r\n  \t// Decreases the zoom of the map by `delta` ([`zoomDelta`](#map-zoomdelta) by default).\r\n  \tzoomOut: function (delta, options) {\r\n  \t\tdelta = delta || (Browser.any3d ? this.options.zoomDelta : 1);\r\n  \t\treturn this.setZoom(this._zoom - delta, options);\r\n  \t},\r\n\r\n  \t// @method setZoomAround(latlng: LatLng, zoom: Number, options: Zoom options): this\r\n  \t// Zooms the map while keeping a specified geographical point on the map\r\n  \t// stationary (e.g. used internally for scroll zoom and double-click zoom).\r\n  \t// @alternative\r\n  \t// @method setZoomAround(offset: Point, zoom: Number, options: Zoom options): this\r\n  \t// Zooms the map while keeping a specified pixel on the map (relative to the top-left corner) stationary.\r\n  \tsetZoomAround: function (latlng, zoom, options) {\r\n  \t\tvar scale = this.getZoomScale(zoom),\r\n  \t\t    viewHalf = this.getSize().divideBy(2),\r\n  \t\t    containerPoint = latlng instanceof Point ? latlng : this.latLngToContainerPoint(latlng),\r\n\r\n  \t\t    centerOffset = containerPoint.subtract(viewHalf).multiplyBy(1 - 1 / scale),\r\n  \t\t    newCenter = this.containerPointToLatLng(viewHalf.add(centerOffset));\r\n\r\n  \t\treturn this.setView(newCenter, zoom, {zoom: options});\r\n  \t},\r\n\r\n  \t_getBoundsCenterZoom: function (bounds, options) {\r\n\r\n  \t\toptions = options || {};\r\n  \t\tbounds = bounds.getBounds ? bounds.getBounds() : toLatLngBounds(bounds);\r\n\r\n  \t\tvar paddingTL = toPoint(options.paddingTopLeft || options.padding || [0, 0]),\r\n  \t\t    paddingBR = toPoint(options.paddingBottomRight || options.padding || [0, 0]),\r\n\r\n  \t\t    zoom = this.getBoundsZoom(bounds, false, paddingTL.add(paddingBR));\r\n\r\n  \t\tzoom = (typeof options.maxZoom === 'number') ? Math.min(options.maxZoom, zoom) : zoom;\r\n\r\n  \t\tif (zoom === Infinity) {\r\n  \t\t\treturn {\r\n  \t\t\t\tcenter: bounds.getCenter(),\r\n  \t\t\t\tzoom: zoom\r\n  \t\t\t};\r\n  \t\t}\r\n\r\n  \t\tvar paddingOffset = paddingBR.subtract(paddingTL).divideBy(2),\r\n\r\n  \t\t    swPoint = this.project(bounds.getSouthWest(), zoom),\r\n  \t\t    nePoint = this.project(bounds.getNorthEast(), zoom),\r\n  \t\t    center = this.unproject(swPoint.add(nePoint).divideBy(2).add(paddingOffset), zoom);\r\n\r\n  \t\treturn {\r\n  \t\t\tcenter: center,\r\n  \t\t\tzoom: zoom\r\n  \t\t};\r\n  \t},\r\n\r\n  \t// @method fitBounds(bounds: LatLngBounds, options?: fitBounds options): this\r\n  \t// Sets a map view that contains the given geographical bounds with the\r\n  \t// maximum zoom level possible.\r\n  \tfitBounds: function (bounds, options) {\r\n\r\n  \t\tbounds = toLatLngBounds(bounds);\r\n\r\n  \t\tif (!bounds.isValid()) {\r\n  \t\t\tthrow new Error('Bounds are not valid.');\r\n  \t\t}\r\n\r\n  \t\tvar target = this._getBoundsCenterZoom(bounds, options);\r\n  \t\treturn this.setView(target.center, target.zoom, options);\r\n  \t},\r\n\r\n  \t// @method fitWorld(options?: fitBounds options): this\r\n  \t// Sets a map view that mostly contains the whole world with the maximum\r\n  \t// zoom level possible.\r\n  \tfitWorld: function (options) {\r\n  \t\treturn this.fitBounds([[-90, -180], [90, 180]], options);\r\n  \t},\r\n\r\n  \t// @method panTo(latlng: LatLng, options?: Pan options): this\r\n  \t// Pans the map to a given center.\r\n  \tpanTo: function (center, options) { // (LatLng)\r\n  \t\treturn this.setView(center, this._zoom, {pan: options});\r\n  \t},\r\n\r\n  \t// @method panBy(offset: Point, options?: Pan options): this\r\n  \t// Pans the map by a given number of pixels (animated).\r\n  \tpanBy: function (offset, options) {\r\n  \t\toffset = toPoint(offset).round();\r\n  \t\toptions = options || {};\r\n\r\n  \t\tif (!offset.x && !offset.y) {\r\n  \t\t\treturn this.fire('moveend');\r\n  \t\t}\r\n  \t\t// If we pan too far, Chrome gets issues with tiles\r\n  \t\t// and makes them disappear or appear in the wrong place (slightly offset) #2602\r\n  \t\tif (options.animate !== true && !this.getSize().contains(offset)) {\r\n  \t\t\tthis._resetView(this.unproject(this.project(this.getCenter()).add(offset)), this.getZoom());\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tif (!this._panAnim) {\r\n  \t\t\tthis._panAnim = new PosAnimation();\r\n\r\n  \t\t\tthis._panAnim.on({\r\n  \t\t\t\t'step': this._onPanTransitionStep,\r\n  \t\t\t\t'end': this._onPanTransitionEnd\r\n  \t\t\t}, this);\r\n  \t\t}\r\n\r\n  \t\t// don't fire movestart if animating inertia\r\n  \t\tif (!options.noMoveStart) {\r\n  \t\t\tthis.fire('movestart');\r\n  \t\t}\r\n\r\n  \t\t// animate pan unless animate: false specified\r\n  \t\tif (options.animate !== false) {\r\n  \t\t\taddClass(this._mapPane, 'leaflet-pan-anim');\r\n\r\n  \t\t\tvar newPos = this._getMapPanePos().subtract(offset).round();\r\n  \t\t\tthis._panAnim.run(this._mapPane, newPos, options.duration || 0.25, options.easeLinearity);\r\n  \t\t} else {\r\n  \t\t\tthis._rawPanBy(offset);\r\n  \t\t\tthis.fire('move').fire('moveend');\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method flyTo(latlng: LatLng, zoom?: Number, options?: Zoom/pan options): this\r\n  \t// Sets the view of the map (geographical center and zoom) performing a smooth\r\n  \t// pan-zoom animation.\r\n  \tflyTo: function (targetCenter, targetZoom, options) {\r\n\r\n  \t\toptions = options || {};\r\n  \t\tif (options.animate === false || !Browser.any3d) {\r\n  \t\t\treturn this.setView(targetCenter, targetZoom, options);\r\n  \t\t}\r\n\r\n  \t\tthis._stop();\r\n\r\n  \t\tvar from = this.project(this.getCenter()),\r\n  \t\t    to = this.project(targetCenter),\r\n  \t\t    size = this.getSize(),\r\n  \t\t    startZoom = this._zoom;\r\n\r\n  \t\ttargetCenter = toLatLng(targetCenter);\r\n  \t\ttargetZoom = targetZoom === undefined ? startZoom : targetZoom;\r\n\r\n  \t\tvar w0 = Math.max(size.x, size.y),\r\n  \t\t    w1 = w0 * this.getZoomScale(startZoom, targetZoom),\r\n  \t\t    u1 = (to.distanceTo(from)) || 1,\r\n  \t\t    rho = 1.42,\r\n  \t\t    rho2 = rho * rho;\r\n\r\n  \t\tfunction r(i) {\r\n  \t\t\tvar s1 = i ? -1 : 1,\r\n  \t\t\t    s2 = i ? w1 : w0,\r\n  \t\t\t    t1 = w1 * w1 - w0 * w0 + s1 * rho2 * rho2 * u1 * u1,\r\n  \t\t\t    b1 = 2 * s2 * rho2 * u1,\r\n  \t\t\t    b = t1 / b1,\r\n  \t\t\t    sq = Math.sqrt(b * b + 1) - b;\r\n\r\n  \t\t\t    // workaround for floating point precision bug when sq = 0, log = -Infinite,\r\n  \t\t\t    // thus triggering an infinite loop in flyTo\r\n  \t\t\t    var log = sq < 0.000000001 ? -18 : Math.log(sq);\r\n\r\n  \t\t\treturn log;\r\n  \t\t}\r\n\r\n  \t\tfunction sinh(n) { return (Math.exp(n) - Math.exp(-n)) / 2; }\r\n  \t\tfunction cosh(n) { return (Math.exp(n) + Math.exp(-n)) / 2; }\r\n  \t\tfunction tanh(n) { return sinh(n) / cosh(n); }\r\n\r\n  \t\tvar r0 = r(0);\r\n\r\n  \t\tfunction w(s) { return w0 * (cosh(r0) / cosh(r0 + rho * s)); }\r\n  \t\tfunction u(s) { return w0 * (cosh(r0) * tanh(r0 + rho * s) - sinh(r0)) / rho2; }\r\n\r\n  \t\tfunction easeOut(t) { return 1 - Math.pow(1 - t, 1.5); }\r\n\r\n  \t\tvar start = Date.now(),\r\n  \t\t    S = (r(1) - r0) / rho,\r\n  \t\t    duration = options.duration ? 1000 * options.duration : 1000 * S * 0.8;\r\n\r\n  \t\tfunction frame() {\r\n  \t\t\tvar t = (Date.now() - start) / duration,\r\n  \t\t\t    s = easeOut(t) * S;\r\n\r\n  \t\t\tif (t <= 1) {\r\n  \t\t\t\tthis._flyToFrame = requestAnimFrame(frame, this);\r\n\r\n  \t\t\t\tthis._move(\r\n  \t\t\t\t\tthis.unproject(from.add(to.subtract(from).multiplyBy(u(s) / u1)), startZoom),\r\n  \t\t\t\t\tthis.getScaleZoom(w0 / w(s), startZoom),\r\n  \t\t\t\t\t{flyTo: true});\r\n\r\n  \t\t\t} else {\r\n  \t\t\t\tthis\r\n  \t\t\t\t\t._move(targetCenter, targetZoom)\r\n  \t\t\t\t\t._moveEnd(true);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tthis._moveStart(true, options.noMoveStart);\r\n\r\n  \t\tframe.call(this);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method flyToBounds(bounds: LatLngBounds, options?: fitBounds options): this\r\n  \t// Sets the view of the map with a smooth animation like [`flyTo`](#map-flyto),\r\n  \t// but takes a bounds parameter like [`fitBounds`](#map-fitbounds).\r\n  \tflyToBounds: function (bounds, options) {\r\n  \t\tvar target = this._getBoundsCenterZoom(bounds, options);\r\n  \t\treturn this.flyTo(target.center, target.zoom, options);\r\n  \t},\r\n\r\n  \t// @method setMaxBounds(bounds: LatLngBounds): this\r\n  \t// Restricts the map view to the given bounds (see the [maxBounds](#map-maxbounds) option).\r\n  \tsetMaxBounds: function (bounds) {\r\n  \t\tbounds = toLatLngBounds(bounds);\r\n\r\n  \t\tif (this.listens('moveend', this._panInsideMaxBounds)) {\r\n  \t\t\tthis.off('moveend', this._panInsideMaxBounds);\r\n  \t\t}\r\n\r\n  \t\tif (!bounds.isValid()) {\r\n  \t\t\tthis.options.maxBounds = null;\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tthis.options.maxBounds = bounds;\r\n\r\n  \t\tif (this._loaded) {\r\n  \t\t\tthis._panInsideMaxBounds();\r\n  \t\t}\r\n\r\n  \t\treturn this.on('moveend', this._panInsideMaxBounds);\r\n  \t},\r\n\r\n  \t// @method setMinZoom(zoom: Number): this\r\n  \t// Sets the lower limit for the available zoom levels (see the [minZoom](#map-minzoom) option).\r\n  \tsetMinZoom: function (zoom) {\r\n  \t\tvar oldZoom = this.options.minZoom;\r\n  \t\tthis.options.minZoom = zoom;\r\n\r\n  \t\tif (this._loaded && oldZoom !== zoom) {\r\n  \t\t\tthis.fire('zoomlevelschange');\r\n\r\n  \t\t\tif (this.getZoom() < this.options.minZoom) {\r\n  \t\t\t\treturn this.setZoom(zoom);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method setMaxZoom(zoom: Number): this\r\n  \t// Sets the upper limit for the available zoom levels (see the [maxZoom](#map-maxzoom) option).\r\n  \tsetMaxZoom: function (zoom) {\r\n  \t\tvar oldZoom = this.options.maxZoom;\r\n  \t\tthis.options.maxZoom = zoom;\r\n\r\n  \t\tif (this._loaded && oldZoom !== zoom) {\r\n  \t\t\tthis.fire('zoomlevelschange');\r\n\r\n  \t\t\tif (this.getZoom() > this.options.maxZoom) {\r\n  \t\t\t\treturn this.setZoom(zoom);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method panInsideBounds(bounds: LatLngBounds, options?: Pan options): this\r\n  \t// Pans the map to the closest view that would lie inside the given bounds (if it's not already), controlling the animation using the options specific, if any.\r\n  \tpanInsideBounds: function (bounds, options) {\r\n  \t\tthis._enforcingBounds = true;\r\n  \t\tvar center = this.getCenter(),\r\n  \t\t    newCenter = this._limitCenter(center, this._zoom, toLatLngBounds(bounds));\r\n\r\n  \t\tif (!center.equals(newCenter)) {\r\n  \t\t\tthis.panTo(newCenter, options);\r\n  \t\t}\r\n\r\n  \t\tthis._enforcingBounds = false;\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method panInside(latlng: LatLng, options?: padding options): this\r\n  \t// Pans the map the minimum amount to make the `latlng` visible. Use\r\n  \t// padding options to fit the display to more restricted bounds.\r\n  \t// If `latlng` is already within the (optionally padded) display bounds,\r\n  \t// the map will not be panned.\r\n  \tpanInside: function (latlng, options) {\r\n  \t\toptions = options || {};\r\n\r\n  \t\tvar paddingTL = toPoint(options.paddingTopLeft || options.padding || [0, 0]),\r\n  \t\t    paddingBR = toPoint(options.paddingBottomRight || options.padding || [0, 0]),\r\n  \t\t    pixelCenter = this.project(this.getCenter()),\r\n  \t\t    pixelPoint = this.project(latlng),\r\n  \t\t    pixelBounds = this.getPixelBounds(),\r\n  \t\t    paddedBounds = toBounds([pixelBounds.min.add(paddingTL), pixelBounds.max.subtract(paddingBR)]),\r\n  \t\t    paddedSize = paddedBounds.getSize();\r\n\r\n  \t\tif (!paddedBounds.contains(pixelPoint)) {\r\n  \t\t\tthis._enforcingBounds = true;\r\n  \t\t\tvar centerOffset = pixelPoint.subtract(paddedBounds.getCenter());\r\n  \t\t\tvar offset = paddedBounds.extend(pixelPoint).getSize().subtract(paddedSize);\r\n  \t\t\tpixelCenter.x += centerOffset.x < 0 ? -offset.x : offset.x;\r\n  \t\t\tpixelCenter.y += centerOffset.y < 0 ? -offset.y : offset.y;\r\n  \t\t\tthis.panTo(this.unproject(pixelCenter), options);\r\n  \t\t\tthis._enforcingBounds = false;\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method invalidateSize(options: Zoom/pan options): this\r\n  \t// Checks if the map container size changed and updates the map if so —\r\n  \t// call it after you've changed the map size dynamically, also animating\r\n  \t// pan by default. If `options.pan` is `false`, panning will not occur.\r\n  \t// If `options.debounceMoveend` is `true`, it will delay `moveend` event so\r\n  \t// that it doesn't happen often even if the method is called many\r\n  \t// times in a row.\r\n\r\n  \t// @alternative\r\n  \t// @method invalidateSize(animate: Boolean): this\r\n  \t// Checks if the map container size changed and updates the map if so —\r\n  \t// call it after you've changed the map size dynamically, also animating\r\n  \t// pan by default.\r\n  \tinvalidateSize: function (options) {\r\n  \t\tif (!this._loaded) { return this; }\r\n\r\n  \t\toptions = extend({\r\n  \t\t\tanimate: false,\r\n  \t\t\tpan: true\r\n  \t\t}, options === true ? {animate: true} : options);\r\n\r\n  \t\tvar oldSize = this.getSize();\r\n  \t\tthis._sizeChanged = true;\r\n  \t\tthis._lastCenter = null;\r\n\r\n  \t\tvar newSize = this.getSize(),\r\n  \t\t    oldCenter = oldSize.divideBy(2).round(),\r\n  \t\t    newCenter = newSize.divideBy(2).round(),\r\n  \t\t    offset = oldCenter.subtract(newCenter);\r\n\r\n  \t\tif (!offset.x && !offset.y) { return this; }\r\n\r\n  \t\tif (options.animate && options.pan) {\r\n  \t\t\tthis.panBy(offset);\r\n\r\n  \t\t} else {\r\n  \t\t\tif (options.pan) {\r\n  \t\t\t\tthis._rawPanBy(offset);\r\n  \t\t\t}\r\n\r\n  \t\t\tthis.fire('move');\r\n\r\n  \t\t\tif (options.debounceMoveend) {\r\n  \t\t\t\tclearTimeout(this._sizeTimer);\r\n  \t\t\t\tthis._sizeTimer = setTimeout(bind(this.fire, this, 'moveend'), 200);\r\n  \t\t\t} else {\r\n  \t\t\t\tthis.fire('moveend');\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\t// @section Map state change events\r\n  \t\t// @event resize: ResizeEvent\r\n  \t\t// Fired when the map is resized.\r\n  \t\treturn this.fire('resize', {\r\n  \t\t\toldSize: oldSize,\r\n  \t\t\tnewSize: newSize\r\n  \t\t});\r\n  \t},\r\n\r\n  \t// @section Methods for modifying map state\r\n  \t// @method stop(): this\r\n  \t// Stops the currently running `panTo` or `flyTo` animation, if any.\r\n  \tstop: function () {\r\n  \t\tthis.setZoom(this._limitZoom(this._zoom));\r\n  \t\tif (!this.options.zoomSnap) {\r\n  \t\t\tthis.fire('viewreset');\r\n  \t\t}\r\n  \t\treturn this._stop();\r\n  \t},\r\n\r\n  \t// @section Geolocation methods\r\n  \t// @method locate(options?: Locate options): this\r\n  \t// Tries to locate the user using the Geolocation API, firing a [`locationfound`](#map-locationfound)\r\n  \t// event with location data on success or a [`locationerror`](#map-locationerror) event on failure,\r\n  \t// and optionally sets the map view to the user's location with respect to\r\n  \t// detection accuracy (or to the world view if geolocation failed).\r\n  \t// Note that, if your page doesn't use HTTPS, this method will fail in\r\n  \t// modern browsers ([Chrome 50 and newer](https://sites.google.com/a/chromium.org/dev/Home/chromium-security/deprecating-powerful-features-on-insecure-origins))\r\n  \t// See `Locate options` for more details.\r\n  \tlocate: function (options) {\r\n\r\n  \t\toptions = this._locateOptions = extend({\r\n  \t\t\ttimeout: 10000,\r\n  \t\t\twatch: false\r\n  \t\t\t// setView: false\r\n  \t\t\t// maxZoom: <Number>\r\n  \t\t\t// maximumAge: 0\r\n  \t\t\t// enableHighAccuracy: false\r\n  \t\t}, options);\r\n\r\n  \t\tif (!('geolocation' in navigator)) {\r\n  \t\t\tthis._handleGeolocationError({\r\n  \t\t\t\tcode: 0,\r\n  \t\t\t\tmessage: 'Geolocation not supported.'\r\n  \t\t\t});\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tvar onResponse = bind(this._handleGeolocationResponse, this),\r\n  \t\t    onError = bind(this._handleGeolocationError, this);\r\n\r\n  \t\tif (options.watch) {\r\n  \t\t\tthis._locationWatchId =\r\n  \t\t\t        navigator.geolocation.watchPosition(onResponse, onError, options);\r\n  \t\t} else {\r\n  \t\t\tnavigator.geolocation.getCurrentPosition(onResponse, onError, options);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method stopLocate(): this\r\n  \t// Stops watching location previously initiated by `map.locate({watch: true})`\r\n  \t// and aborts resetting the map view if map.locate was called with\r\n  \t// `{setView: true}`.\r\n  \tstopLocate: function () {\r\n  \t\tif (navigator.geolocation && navigator.geolocation.clearWatch) {\r\n  \t\t\tnavigator.geolocation.clearWatch(this._locationWatchId);\r\n  \t\t}\r\n  \t\tif (this._locateOptions) {\r\n  \t\t\tthis._locateOptions.setView = false;\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_handleGeolocationError: function (error) {\r\n  \t\tif (!this._container._leaflet_id) { return; }\r\n\r\n  \t\tvar c = error.code,\r\n  \t\t    message = error.message ||\r\n  \t\t            (c === 1 ? 'permission denied' :\r\n  \t\t            (c === 2 ? 'position unavailable' : 'timeout'));\r\n\r\n  \t\tif (this._locateOptions.setView && !this._loaded) {\r\n  \t\t\tthis.fitWorld();\r\n  \t\t}\r\n\r\n  \t\t// @section Location events\r\n  \t\t// @event locationerror: ErrorEvent\r\n  \t\t// Fired when geolocation (using the [`locate`](#map-locate) method) failed.\r\n  \t\tthis.fire('locationerror', {\r\n  \t\t\tcode: c,\r\n  \t\t\tmessage: 'Geolocation error: ' + message + '.'\r\n  \t\t});\r\n  \t},\r\n\r\n  \t_handleGeolocationResponse: function (pos) {\r\n  \t\tif (!this._container._leaflet_id) { return; }\r\n\r\n  \t\tvar lat = pos.coords.latitude,\r\n  \t\t    lng = pos.coords.longitude,\r\n  \t\t    latlng = new LatLng(lat, lng),\r\n  \t\t    bounds = latlng.toBounds(pos.coords.accuracy * 2),\r\n  \t\t    options = this._locateOptions;\r\n\r\n  \t\tif (options.setView) {\r\n  \t\t\tvar zoom = this.getBoundsZoom(bounds);\r\n  \t\t\tthis.setView(latlng, options.maxZoom ? Math.min(zoom, options.maxZoom) : zoom);\r\n  \t\t}\r\n\r\n  \t\tvar data = {\r\n  \t\t\tlatlng: latlng,\r\n  \t\t\tbounds: bounds,\r\n  \t\t\ttimestamp: pos.timestamp\r\n  \t\t};\r\n\r\n  \t\tfor (var i in pos.coords) {\r\n  \t\t\tif (typeof pos.coords[i] === 'number') {\r\n  \t\t\t\tdata[i] = pos.coords[i];\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\t// @event locationfound: LocationEvent\r\n  \t\t// Fired when geolocation (using the [`locate`](#map-locate) method)\r\n  \t\t// went successfully.\r\n  \t\tthis.fire('locationfound', data);\r\n  \t},\r\n\r\n  \t// TODO Appropriate docs section?\r\n  \t// @section Other Methods\r\n  \t// @method addHandler(name: String, HandlerClass: Function): this\r\n  \t// Adds a new `Handler` to the map, given its name and constructor function.\r\n  \taddHandler: function (name, HandlerClass) {\r\n  \t\tif (!HandlerClass) { return this; }\r\n\r\n  \t\tvar handler = this[name] = new HandlerClass(this);\r\n\r\n  \t\tthis._handlers.push(handler);\r\n\r\n  \t\tif (this.options[name]) {\r\n  \t\t\thandler.enable();\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method remove(): this\r\n  \t// Destroys the map and clears all related event listeners.\r\n  \tremove: function () {\r\n\r\n  \t\tthis._initEvents(true);\r\n  \t\tif (this.options.maxBounds) { this.off('moveend', this._panInsideMaxBounds); }\r\n\r\n  \t\tif (this._containerId !== this._container._leaflet_id) {\r\n  \t\t\tthrow new Error('Map container is being reused by another instance');\r\n  \t\t}\r\n\r\n  \t\ttry {\r\n  \t\t\t// throws error in IE6-8\r\n  \t\t\tdelete this._container._leaflet_id;\r\n  \t\t\tdelete this._containerId;\r\n  \t\t} catch (e) {\r\n  \t\t\t/*eslint-disable */\r\n  \t\t\tthis._container._leaflet_id = undefined;\r\n  \t\t\t/* eslint-enable */\r\n  \t\t\tthis._containerId = undefined;\r\n  \t\t}\r\n\r\n  \t\tif (this._locationWatchId !== undefined) {\r\n  \t\t\tthis.stopLocate();\r\n  \t\t}\r\n\r\n  \t\tthis._stop();\r\n\r\n  \t\tremove(this._mapPane);\r\n\r\n  \t\tif (this._clearControlPos) {\r\n  \t\t\tthis._clearControlPos();\r\n  \t\t}\r\n  \t\tif (this._resizeRequest) {\r\n  \t\t\tcancelAnimFrame(this._resizeRequest);\r\n  \t\t\tthis._resizeRequest = null;\r\n  \t\t}\r\n\r\n  \t\tthis._clearHandlers();\r\n\r\n  \t\tif (this._loaded) {\r\n  \t\t\t// @section Map state change events\r\n  \t\t\t// @event unload: Event\r\n  \t\t\t// Fired when the map is destroyed with [remove](#map-remove) method.\r\n  \t\t\tthis.fire('unload');\r\n  \t\t}\r\n\r\n  \t\tvar i;\r\n  \t\tfor (i in this._layers) {\r\n  \t\t\tthis._layers[i].remove();\r\n  \t\t}\r\n  \t\tfor (i in this._panes) {\r\n  \t\t\tremove(this._panes[i]);\r\n  \t\t}\r\n\r\n  \t\tthis._layers = [];\r\n  \t\tthis._panes = [];\r\n  \t\tdelete this._mapPane;\r\n  \t\tdelete this._renderer;\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @section Other Methods\r\n  \t// @method createPane(name: String, container?: HTMLElement): HTMLElement\r\n  \t// Creates a new [map pane](#map-pane) with the given name if it doesn't exist already,\r\n  \t// then returns it. The pane is created as a child of `container`, or\r\n  \t// as a child of the main map pane if not set.\r\n  \tcreatePane: function (name, container) {\r\n  \t\tvar className = 'leaflet-pane' + (name ? ' leaflet-' + name.replace('Pane', '') + '-pane' : ''),\r\n  \t\t    pane = create$1('div', className, container || this._mapPane);\r\n\r\n  \t\tif (name) {\r\n  \t\t\tthis._panes[name] = pane;\r\n  \t\t}\r\n  \t\treturn pane;\r\n  \t},\r\n\r\n  \t// @section Methods for Getting Map State\r\n\r\n  \t// @method getCenter(): LatLng\r\n  \t// Returns the geographical center of the map view\r\n  \tgetCenter: function () {\r\n  \t\tthis._checkIfLoaded();\r\n\r\n  \t\tif (this._lastCenter && !this._moved()) {\r\n  \t\t\treturn this._lastCenter.clone();\r\n  \t\t}\r\n  \t\treturn this.layerPointToLatLng(this._getCenterLayerPoint());\r\n  \t},\r\n\r\n  \t// @method getZoom(): Number\r\n  \t// Returns the current zoom level of the map view\r\n  \tgetZoom: function () {\r\n  \t\treturn this._zoom;\r\n  \t},\r\n\r\n  \t// @method getBounds(): LatLngBounds\r\n  \t// Returns the geographical bounds visible in the current map view\r\n  \tgetBounds: function () {\r\n  \t\tvar bounds = this.getPixelBounds(),\r\n  \t\t    sw = this.unproject(bounds.getBottomLeft()),\r\n  \t\t    ne = this.unproject(bounds.getTopRight());\r\n\r\n  \t\treturn new LatLngBounds(sw, ne);\r\n  \t},\r\n\r\n  \t// @method getMinZoom(): Number\r\n  \t// Returns the minimum zoom level of the map (if set in the `minZoom` option of the map or of any layers), or `0` by default.\r\n  \tgetMinZoom: function () {\r\n  \t\treturn this.options.minZoom === undefined ? this._layersMinZoom || 0 : this.options.minZoom;\r\n  \t},\r\n\r\n  \t// @method getMaxZoom(): Number\r\n  \t// Returns the maximum zoom level of the map (if set in the `maxZoom` option of the map or of any layers).\r\n  \tgetMaxZoom: function () {\r\n  \t\treturn this.options.maxZoom === undefined ?\r\n  \t\t\t(this._layersMaxZoom === undefined ? Infinity : this._layersMaxZoom) :\r\n  \t\t\tthis.options.maxZoom;\r\n  \t},\r\n\r\n  \t// @method getBoundsZoom(bounds: LatLngBounds, inside?: Boolean, padding?: Point): Number\r\n  \t// Returns the maximum zoom level on which the given bounds fit to the map\r\n  \t// view in its entirety. If `inside` (optional) is set to `true`, the method\r\n  \t// instead returns the minimum zoom level on which the map view fits into\r\n  \t// the given bounds in its entirety.\r\n  \tgetBoundsZoom: function (bounds, inside, padding) { // (LatLngBounds[, Boolean, Point]) -> Number\r\n  \t\tbounds = toLatLngBounds(bounds);\r\n  \t\tpadding = toPoint(padding || [0, 0]);\r\n\r\n  \t\tvar zoom = this.getZoom() || 0,\r\n  \t\t    min = this.getMinZoom(),\r\n  \t\t    max = this.getMaxZoom(),\r\n  \t\t    nw = bounds.getNorthWest(),\r\n  \t\t    se = bounds.getSouthEast(),\r\n  \t\t    size = this.getSize().subtract(padding),\r\n  \t\t    boundsSize = toBounds(this.project(se, zoom), this.project(nw, zoom)).getSize(),\r\n  \t\t    snap = Browser.any3d ? this.options.zoomSnap : 1,\r\n  \t\t    scalex = size.x / boundsSize.x,\r\n  \t\t    scaley = size.y / boundsSize.y,\r\n  \t\t    scale = inside ? Math.max(scalex, scaley) : Math.min(scalex, scaley);\r\n\r\n  \t\tzoom = this.getScaleZoom(scale, zoom);\r\n\r\n  \t\tif (snap) {\r\n  \t\t\tzoom = Math.round(zoom / (snap / 100)) * (snap / 100); // don't jump if within 1% of a snap level\r\n  \t\t\tzoom = inside ? Math.ceil(zoom / snap) * snap : Math.floor(zoom / snap) * snap;\r\n  \t\t}\r\n\r\n  \t\treturn Math.max(min, Math.min(max, zoom));\r\n  \t},\r\n\r\n  \t// @method getSize(): Point\r\n  \t// Returns the current size of the map container (in pixels).\r\n  \tgetSize: function () {\r\n  \t\tif (!this._size || this._sizeChanged) {\r\n  \t\t\tthis._size = new Point(\r\n  \t\t\t\tthis._container.clientWidth || 0,\r\n  \t\t\t\tthis._container.clientHeight || 0);\r\n\r\n  \t\t\tthis._sizeChanged = false;\r\n  \t\t}\r\n  \t\treturn this._size.clone();\r\n  \t},\r\n\r\n  \t// @method getPixelBounds(): Bounds\r\n  \t// Returns the bounds of the current map view in projected pixel\r\n  \t// coordinates (sometimes useful in layer and overlay implementations).\r\n  \tgetPixelBounds: function (center, zoom) {\r\n  \t\tvar topLeftPoint = this._getTopLeftPoint(center, zoom);\r\n  \t\treturn new Bounds(topLeftPoint, topLeftPoint.add(this.getSize()));\r\n  \t},\r\n\r\n  \t// TODO: Check semantics - isn't the pixel origin the 0,0 coord relative to\r\n  \t// the map pane? \"left point of the map layer\" can be confusing, specially\r\n  \t// since there can be negative offsets.\r\n  \t// @method getPixelOrigin(): Point\r\n  \t// Returns the projected pixel coordinates of the top left point of\r\n  \t// the map layer (useful in custom layer and overlay implementations).\r\n  \tgetPixelOrigin: function () {\r\n  \t\tthis._checkIfLoaded();\r\n  \t\treturn this._pixelOrigin;\r\n  \t},\r\n\r\n  \t// @method getPixelWorldBounds(zoom?: Number): Bounds\r\n  \t// Returns the world's bounds in pixel coordinates for zoom level `zoom`.\r\n  \t// If `zoom` is omitted, the map's current zoom level is used.\r\n  \tgetPixelWorldBounds: function (zoom) {\r\n  \t\treturn this.options.crs.getProjectedBounds(zoom === undefined ? this.getZoom() : zoom);\r\n  \t},\r\n\r\n  \t// @section Other Methods\r\n\r\n  \t// @method getPane(pane: String|HTMLElement): HTMLElement\r\n  \t// Returns a [map pane](#map-pane), given its name or its HTML element (its identity).\r\n  \tgetPane: function (pane) {\r\n  \t\treturn typeof pane === 'string' ? this._panes[pane] : pane;\r\n  \t},\r\n\r\n  \t// @method getPanes(): Object\r\n  \t// Returns a plain object containing the names of all [panes](#map-pane) as keys and\r\n  \t// the panes as values.\r\n  \tgetPanes: function () {\r\n  \t\treturn this._panes;\r\n  \t},\r\n\r\n  \t// @method getContainer: HTMLElement\r\n  \t// Returns the HTML element that contains the map.\r\n  \tgetContainer: function () {\r\n  \t\treturn this._container;\r\n  \t},\r\n\r\n\r\n  \t// @section Conversion Methods\r\n\r\n  \t// @method getZoomScale(toZoom: Number, fromZoom: Number): Number\r\n  \t// Returns the scale factor to be applied to a map transition from zoom level\r\n  \t// `fromZoom` to `toZoom`. Used internally to help with zoom animations.\r\n  \tgetZoomScale: function (toZoom, fromZoom) {\r\n  \t\t// TODO replace with universal implementation after refactoring projections\r\n  \t\tvar crs = this.options.crs;\r\n  \t\tfromZoom = fromZoom === undefined ? this._zoom : fromZoom;\r\n  \t\treturn crs.scale(toZoom) / crs.scale(fromZoom);\r\n  \t},\r\n\r\n  \t// @method getScaleZoom(scale: Number, fromZoom: Number): Number\r\n  \t// Returns the zoom level that the map would end up at, if it is at `fromZoom`\r\n  \t// level and everything is scaled by a factor of `scale`. Inverse of\r\n  \t// [`getZoomScale`](#map-getZoomScale).\r\n  \tgetScaleZoom: function (scale, fromZoom) {\r\n  \t\tvar crs = this.options.crs;\r\n  \t\tfromZoom = fromZoom === undefined ? this._zoom : fromZoom;\r\n  \t\tvar zoom = crs.zoom(scale * crs.scale(fromZoom));\r\n  \t\treturn isNaN(zoom) ? Infinity : zoom;\r\n  \t},\r\n\r\n  \t// @method project(latlng: LatLng, zoom: Number): Point\r\n  \t// Projects a geographical coordinate `LatLng` according to the projection\r\n  \t// of the map's CRS, then scales it according to `zoom` and the CRS's\r\n  \t// `Transformation`. The result is pixel coordinate relative to\r\n  \t// the CRS origin.\r\n  \tproject: function (latlng, zoom) {\r\n  \t\tzoom = zoom === undefined ? this._zoom : zoom;\r\n  \t\treturn this.options.crs.latLngToPoint(toLatLng(latlng), zoom);\r\n  \t},\r\n\r\n  \t// @method unproject(point: Point, zoom: Number): LatLng\r\n  \t// Inverse of [`project`](#map-project).\r\n  \tunproject: function (point, zoom) {\r\n  \t\tzoom = zoom === undefined ? this._zoom : zoom;\r\n  \t\treturn this.options.crs.pointToLatLng(toPoint(point), zoom);\r\n  \t},\r\n\r\n  \t// @method layerPointToLatLng(point: Point): LatLng\r\n  \t// Given a pixel coordinate relative to the [origin pixel](#map-getpixelorigin),\r\n  \t// returns the corresponding geographical coordinate (for the current zoom level).\r\n  \tlayerPointToLatLng: function (point) {\r\n  \t\tvar projectedPoint = toPoint(point).add(this.getPixelOrigin());\r\n  \t\treturn this.unproject(projectedPoint);\r\n  \t},\r\n\r\n  \t// @method latLngToLayerPoint(latlng: LatLng): Point\r\n  \t// Given a geographical coordinate, returns the corresponding pixel coordinate\r\n  \t// relative to the [origin pixel](#map-getpixelorigin).\r\n  \tlatLngToLayerPoint: function (latlng) {\r\n  \t\tvar projectedPoint = this.project(toLatLng(latlng))._round();\r\n  \t\treturn projectedPoint._subtract(this.getPixelOrigin());\r\n  \t},\r\n\r\n  \t// @method wrapLatLng(latlng: LatLng): LatLng\r\n  \t// Returns a `LatLng` where `lat` and `lng` has been wrapped according to the\r\n  \t// map's CRS's `wrapLat` and `wrapLng` properties, if they are outside the\r\n  \t// CRS's bounds.\r\n  \t// By default this means longitude is wrapped around the dateline so its\r\n  \t// value is between -180 and +180 degrees.\r\n  \twrapLatLng: function (latlng) {\r\n  \t\treturn this.options.crs.wrapLatLng(toLatLng(latlng));\r\n  \t},\r\n\r\n  \t// @method wrapLatLngBounds(bounds: LatLngBounds): LatLngBounds\r\n  \t// Returns a `LatLngBounds` with the same size as the given one, ensuring that\r\n  \t// its center is within the CRS's bounds.\r\n  \t// By default this means the center longitude is wrapped around the dateline so its\r\n  \t// value is between -180 and +180 degrees, and the majority of the bounds\r\n  \t// overlaps the CRS's bounds.\r\n  \twrapLatLngBounds: function (latlng) {\r\n  \t\treturn this.options.crs.wrapLatLngBounds(toLatLngBounds(latlng));\r\n  \t},\r\n\r\n  \t// @method distance(latlng1: LatLng, latlng2: LatLng): Number\r\n  \t// Returns the distance between two geographical coordinates according to\r\n  \t// the map's CRS. By default this measures distance in meters.\r\n  \tdistance: function (latlng1, latlng2) {\r\n  \t\treturn this.options.crs.distance(toLatLng(latlng1), toLatLng(latlng2));\r\n  \t},\r\n\r\n  \t// @method containerPointToLayerPoint(point: Point): Point\r\n  \t// Given a pixel coordinate relative to the map container, returns the corresponding\r\n  \t// pixel coordinate relative to the [origin pixel](#map-getpixelorigin).\r\n  \tcontainerPointToLayerPoint: function (point) { // (Point)\r\n  \t\treturn toPoint(point).subtract(this._getMapPanePos());\r\n  \t},\r\n\r\n  \t// @method layerPointToContainerPoint(point: Point): Point\r\n  \t// Given a pixel coordinate relative to the [origin pixel](#map-getpixelorigin),\r\n  \t// returns the corresponding pixel coordinate relative to the map container.\r\n  \tlayerPointToContainerPoint: function (point) { // (Point)\r\n  \t\treturn toPoint(point).add(this._getMapPanePos());\r\n  \t},\r\n\r\n  \t// @method containerPointToLatLng(point: Point): LatLng\r\n  \t// Given a pixel coordinate relative to the map container, returns\r\n  \t// the corresponding geographical coordinate (for the current zoom level).\r\n  \tcontainerPointToLatLng: function (point) {\r\n  \t\tvar layerPoint = this.containerPointToLayerPoint(toPoint(point));\r\n  \t\treturn this.layerPointToLatLng(layerPoint);\r\n  \t},\r\n\r\n  \t// @method latLngToContainerPoint(latlng: LatLng): Point\r\n  \t// Given a geographical coordinate, returns the corresponding pixel coordinate\r\n  \t// relative to the map container.\r\n  \tlatLngToContainerPoint: function (latlng) {\r\n  \t\treturn this.layerPointToContainerPoint(this.latLngToLayerPoint(toLatLng(latlng)));\r\n  \t},\r\n\r\n  \t// @method mouseEventToContainerPoint(ev: MouseEvent): Point\r\n  \t// Given a MouseEvent object, returns the pixel coordinate relative to the\r\n  \t// map container where the event took place.\r\n  \tmouseEventToContainerPoint: function (e) {\r\n  \t\treturn getMousePosition(e, this._container);\r\n  \t},\r\n\r\n  \t// @method mouseEventToLayerPoint(ev: MouseEvent): Point\r\n  \t// Given a MouseEvent object, returns the pixel coordinate relative to\r\n  \t// the [origin pixel](#map-getpixelorigin) where the event took place.\r\n  \tmouseEventToLayerPoint: function (e) {\r\n  \t\treturn this.containerPointToLayerPoint(this.mouseEventToContainerPoint(e));\r\n  \t},\r\n\r\n  \t// @method mouseEventToLatLng(ev: MouseEvent): LatLng\r\n  \t// Given a MouseEvent object, returns geographical coordinate where the\r\n  \t// event took place.\r\n  \tmouseEventToLatLng: function (e) { // (MouseEvent)\r\n  \t\treturn this.layerPointToLatLng(this.mouseEventToLayerPoint(e));\r\n  \t},\r\n\r\n\r\n  \t// map initialization methods\r\n\r\n  \t_initContainer: function (id) {\r\n  \t\tvar container = this._container = get(id);\r\n\r\n  \t\tif (!container) {\r\n  \t\t\tthrow new Error('Map container not found.');\r\n  \t\t} else if (container._leaflet_id) {\r\n  \t\t\tthrow new Error('Map container is already initialized.');\r\n  \t\t}\r\n\r\n  \t\ton(container, 'scroll', this._onScroll, this);\r\n  \t\tthis._containerId = stamp(container);\r\n  \t},\r\n\r\n  \t_initLayout: function () {\r\n  \t\tvar container = this._container;\r\n\r\n  \t\tthis._fadeAnimated = this.options.fadeAnimation && Browser.any3d;\r\n\r\n  \t\taddClass(container, 'leaflet-container' +\r\n  \t\t\t(Browser.touch ? ' leaflet-touch' : '') +\r\n  \t\t\t(Browser.retina ? ' leaflet-retina' : '') +\r\n  \t\t\t(Browser.ielt9 ? ' leaflet-oldie' : '') +\r\n  \t\t\t(Browser.safari ? ' leaflet-safari' : '') +\r\n  \t\t\t(this._fadeAnimated ? ' leaflet-fade-anim' : ''));\r\n\r\n  \t\tvar position = getStyle(container, 'position');\r\n\r\n  \t\tif (position !== 'absolute' && position !== 'relative' && position !== 'fixed' && position !== 'sticky') {\r\n  \t\t\tcontainer.style.position = 'relative';\r\n  \t\t}\r\n\r\n  \t\tthis._initPanes();\r\n\r\n  \t\tif (this._initControlPos) {\r\n  \t\t\tthis._initControlPos();\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_initPanes: function () {\r\n  \t\tvar panes = this._panes = {};\r\n  \t\tthis._paneRenderers = {};\r\n\r\n  \t\t// @section\r\n  \t\t//\r\n  \t\t// Panes are DOM elements used to control the ordering of layers on the map. You\r\n  \t\t// can access panes with [`map.getPane`](#map-getpane) or\r\n  \t\t// [`map.getPanes`](#map-getpanes) methods. New panes can be created with the\r\n  \t\t// [`map.createPane`](#map-createpane) method.\r\n  \t\t//\r\n  \t\t// Every map has the following default panes that differ only in zIndex.\r\n  \t\t//\r\n  \t\t// @pane mapPane: HTMLElement = 'auto'\r\n  \t\t// Pane that contains all other map panes\r\n\r\n  \t\tthis._mapPane = this.createPane('mapPane', this._container);\r\n  \t\tsetPosition(this._mapPane, new Point(0, 0));\r\n\r\n  \t\t// @pane tilePane: HTMLElement = 200\r\n  \t\t// Pane for `GridLayer`s and `TileLayer`s\r\n  \t\tthis.createPane('tilePane');\r\n  \t\t// @pane overlayPane: HTMLElement = 400\r\n  \t\t// Pane for vectors (`Path`s, like `Polyline`s and `Polygon`s), `ImageOverlay`s and `VideoOverlay`s\r\n  \t\tthis.createPane('overlayPane');\r\n  \t\t// @pane shadowPane: HTMLElement = 500\r\n  \t\t// Pane for overlay shadows (e.g. `Marker` shadows)\r\n  \t\tthis.createPane('shadowPane');\r\n  \t\t// @pane markerPane: HTMLElement = 600\r\n  \t\t// Pane for `Icon`s of `Marker`s\r\n  \t\tthis.createPane('markerPane');\r\n  \t\t// @pane tooltipPane: HTMLElement = 650\r\n  \t\t// Pane for `Tooltip`s.\r\n  \t\tthis.createPane('tooltipPane');\r\n  \t\t// @pane popupPane: HTMLElement = 700\r\n  \t\t// Pane for `Popup`s.\r\n  \t\tthis.createPane('popupPane');\r\n\r\n  \t\tif (!this.options.markerZoomAnimation) {\r\n  \t\t\taddClass(panes.markerPane, 'leaflet-zoom-hide');\r\n  \t\t\taddClass(panes.shadowPane, 'leaflet-zoom-hide');\r\n  \t\t}\r\n  \t},\r\n\r\n\r\n  \t// private methods that modify map state\r\n\r\n  \t// @section Map state change events\r\n  \t_resetView: function (center, zoom, noMoveStart) {\r\n  \t\tsetPosition(this._mapPane, new Point(0, 0));\r\n\r\n  \t\tvar loading = !this._loaded;\r\n  \t\tthis._loaded = true;\r\n  \t\tzoom = this._limitZoom(zoom);\r\n\r\n  \t\tthis.fire('viewprereset');\r\n\r\n  \t\tvar zoomChanged = this._zoom !== zoom;\r\n  \t\tthis\r\n  \t\t\t._moveStart(zoomChanged, noMoveStart)\r\n  \t\t\t._move(center, zoom)\r\n  \t\t\t._moveEnd(zoomChanged);\r\n\r\n  \t\t// @event viewreset: Event\r\n  \t\t// Fired when the map needs to redraw its content (this usually happens\r\n  \t\t// on map zoom or load). Very useful for creating custom overlays.\r\n  \t\tthis.fire('viewreset');\r\n\r\n  \t\t// @event load: Event\r\n  \t\t// Fired when the map is initialized (when its center and zoom are set\r\n  \t\t// for the first time).\r\n  \t\tif (loading) {\r\n  \t\t\tthis.fire('load');\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_moveStart: function (zoomChanged, noMoveStart) {\r\n  \t\t// @event zoomstart: Event\r\n  \t\t// Fired when the map zoom is about to change (e.g. before zoom animation).\r\n  \t\t// @event movestart: Event\r\n  \t\t// Fired when the view of the map starts changing (e.g. user starts dragging the map).\r\n  \t\tif (zoomChanged) {\r\n  \t\t\tthis.fire('zoomstart');\r\n  \t\t}\r\n  \t\tif (!noMoveStart) {\r\n  \t\t\tthis.fire('movestart');\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_move: function (center, zoom, data, supressEvent) {\r\n  \t\tif (zoom === undefined) {\r\n  \t\t\tzoom = this._zoom;\r\n  \t\t}\r\n  \t\tvar zoomChanged = this._zoom !== zoom;\r\n\r\n  \t\tthis._zoom = zoom;\r\n  \t\tthis._lastCenter = center;\r\n  \t\tthis._pixelOrigin = this._getNewPixelOrigin(center);\r\n\r\n  \t\tif (!supressEvent) {\r\n  \t\t\t// @event zoom: Event\r\n  \t\t\t// Fired repeatedly during any change in zoom level,\r\n  \t\t\t// including zoom and fly animations.\r\n  \t\t\tif (zoomChanged || (data && data.pinch)) {\t// Always fire 'zoom' if pinching because #3530\r\n  \t\t\t\tthis.fire('zoom', data);\r\n  \t\t\t}\r\n\r\n  \t\t\t// @event move: Event\r\n  \t\t\t// Fired repeatedly during any movement of the map,\r\n  \t\t\t// including pan and fly animations.\r\n  \t\t\tthis.fire('move', data);\r\n  \t\t} else if (data && data.pinch) {\t// Always fire 'zoom' if pinching because #3530\r\n  \t\t\tthis.fire('zoom', data);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_moveEnd: function (zoomChanged) {\r\n  \t\t// @event zoomend: Event\r\n  \t\t// Fired when the map zoom changed, after any animations.\r\n  \t\tif (zoomChanged) {\r\n  \t\t\tthis.fire('zoomend');\r\n  \t\t}\r\n\r\n  \t\t// @event moveend: Event\r\n  \t\t// Fired when the center of the map stops changing\r\n  \t\t// (e.g. user stopped dragging the map or after non-centered zoom).\r\n  \t\treturn this.fire('moveend');\r\n  \t},\r\n\r\n  \t_stop: function () {\r\n  \t\tcancelAnimFrame(this._flyToFrame);\r\n  \t\tif (this._panAnim) {\r\n  \t\t\tthis._panAnim.stop();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_rawPanBy: function (offset) {\r\n  \t\tsetPosition(this._mapPane, this._getMapPanePos().subtract(offset));\r\n  \t},\r\n\r\n  \t_getZoomSpan: function () {\r\n  \t\treturn this.getMaxZoom() - this.getMinZoom();\r\n  \t},\r\n\r\n  \t_panInsideMaxBounds: function () {\r\n  \t\tif (!this._enforcingBounds) {\r\n  \t\t\tthis.panInsideBounds(this.options.maxBounds);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_checkIfLoaded: function () {\r\n  \t\tif (!this._loaded) {\r\n  \t\t\tthrow new Error('Set map center and zoom first.');\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// DOM event handling\r\n\r\n  \t// @section Interaction events\r\n  \t_initEvents: function (remove) {\r\n  \t\tthis._targets = {};\r\n  \t\tthis._targets[stamp(this._container)] = this;\r\n\r\n  \t\tvar onOff = remove ? off : on;\r\n\r\n  \t\t// @event click: MouseEvent\r\n  \t\t// Fired when the user clicks (or taps) the map.\r\n  \t\t// @event dblclick: MouseEvent\r\n  \t\t// Fired when the user double-clicks (or double-taps) the map.\r\n  \t\t// @event mousedown: MouseEvent\r\n  \t\t// Fired when the user pushes the mouse button on the map.\r\n  \t\t// @event mouseup: MouseEvent\r\n  \t\t// Fired when the user releases the mouse button on the map.\r\n  \t\t// @event mouseover: MouseEvent\r\n  \t\t// Fired when the mouse enters the map.\r\n  \t\t// @event mouseout: MouseEvent\r\n  \t\t// Fired when the mouse leaves the map.\r\n  \t\t// @event mousemove: MouseEvent\r\n  \t\t// Fired while the mouse moves over the map.\r\n  \t\t// @event contextmenu: MouseEvent\r\n  \t\t// Fired when the user pushes the right mouse button on the map, prevents\r\n  \t\t// default browser context menu from showing if there are listeners on\r\n  \t\t// this event. Also fired on mobile when the user holds a single touch\r\n  \t\t// for a second (also called long press).\r\n  \t\t// @event keypress: KeyboardEvent\r\n  \t\t// Fired when the user presses a key from the keyboard that produces a character value while the map is focused.\r\n  \t\t// @event keydown: KeyboardEvent\r\n  \t\t// Fired when the user presses a key from the keyboard while the map is focused. Unlike the `keypress` event,\r\n  \t\t// the `keydown` event is fired for keys that produce a character value and for keys\r\n  \t\t// that do not produce a character value.\r\n  \t\t// @event keyup: KeyboardEvent\r\n  \t\t// Fired when the user releases a key from the keyboard while the map is focused.\r\n  \t\tonOff(this._container, 'click dblclick mousedown mouseup ' +\r\n  \t\t\t'mouseover mouseout mousemove contextmenu keypress keydown keyup', this._handleDOMEvent, this);\r\n\r\n  \t\tif (this.options.trackResize) {\r\n  \t\t\tonOff(window, 'resize', this._onResize, this);\r\n  \t\t}\r\n\r\n  \t\tif (Browser.any3d && this.options.transform3DLimit) {\r\n  \t\t\t(remove ? this.off : this.on).call(this, 'moveend', this._onMoveEnd);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_onResize: function () {\r\n  \t\tcancelAnimFrame(this._resizeRequest);\r\n  \t\tthis._resizeRequest = requestAnimFrame(\r\n  \t\t        function () { this.invalidateSize({debounceMoveend: true}); }, this);\r\n  \t},\r\n\r\n  \t_onScroll: function () {\r\n  \t\tthis._container.scrollTop  = 0;\r\n  \t\tthis._container.scrollLeft = 0;\r\n  \t},\r\n\r\n  \t_onMoveEnd: function () {\r\n  \t\tvar pos = this._getMapPanePos();\r\n  \t\tif (Math.max(Math.abs(pos.x), Math.abs(pos.y)) >= this.options.transform3DLimit) {\r\n  \t\t\t// https://bugzilla.mozilla.org/show_bug.cgi?id=1203873 but Webkit also have\r\n  \t\t\t// a pixel offset on very high values, see: https://jsfiddle.net/dg6r5hhb/\r\n  \t\t\tthis._resetView(this.getCenter(), this.getZoom());\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_findEventTargets: function (e, type) {\r\n  \t\tvar targets = [],\r\n  \t\t    target,\r\n  \t\t    isHover = type === 'mouseout' || type === 'mouseover',\r\n  \t\t    src = e.target || e.srcElement,\r\n  \t\t    dragging = false;\r\n\r\n  \t\twhile (src) {\r\n  \t\t\ttarget = this._targets[stamp(src)];\r\n  \t\t\tif (target && (type === 'click' || type === 'preclick') && this._draggableMoved(target)) {\r\n  \t\t\t\t// Prevent firing click after you just dragged an object.\r\n  \t\t\t\tdragging = true;\r\n  \t\t\t\tbreak;\r\n  \t\t\t}\r\n  \t\t\tif (target && target.listens(type, true)) {\r\n  \t\t\t\tif (isHover && !isExternalTarget(src, e)) { break; }\r\n  \t\t\t\ttargets.push(target);\r\n  \t\t\t\tif (isHover) { break; }\r\n  \t\t\t}\r\n  \t\t\tif (src === this._container) { break; }\r\n  \t\t\tsrc = src.parentNode;\r\n  \t\t}\r\n  \t\tif (!targets.length && !dragging && !isHover && this.listens(type, true)) {\r\n  \t\t\ttargets = [this];\r\n  \t\t}\r\n  \t\treturn targets;\r\n  \t},\r\n\r\n  \t_isClickDisabled: function (el) {\r\n  \t\twhile (el && el !== this._container) {\r\n  \t\t\tif (el['_leaflet_disable_click']) { return true; }\r\n  \t\t\tel = el.parentNode;\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_handleDOMEvent: function (e) {\r\n  \t\tvar el = (e.target || e.srcElement);\r\n  \t\tif (!this._loaded || el['_leaflet_disable_events'] || e.type === 'click' && this._isClickDisabled(el)) {\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tvar type = e.type;\r\n\r\n  \t\tif (type === 'mousedown') {\r\n  \t\t\t// prevents outline when clicking on keyboard-focusable element\r\n  \t\t\tpreventOutline(el);\r\n  \t\t}\r\n\r\n  \t\tthis._fireDOMEvent(e, type);\r\n  \t},\r\n\r\n  \t_mouseEvents: ['click', 'dblclick', 'mouseover', 'mouseout', 'contextmenu'],\r\n\r\n  \t_fireDOMEvent: function (e, type, canvasTargets) {\r\n\r\n  \t\tif (e.type === 'click') {\r\n  \t\t\t// Fire a synthetic 'preclick' event which propagates up (mainly for closing popups).\r\n  \t\t\t// @event preclick: MouseEvent\r\n  \t\t\t// Fired before mouse click on the map (sometimes useful when you\r\n  \t\t\t// want something to happen on click before any existing click\r\n  \t\t\t// handlers start running).\r\n  \t\t\tvar synth = extend({}, e);\r\n  \t\t\tsynth.type = 'preclick';\r\n  \t\t\tthis._fireDOMEvent(synth, synth.type, canvasTargets);\r\n  \t\t}\r\n\r\n  \t\t// Find the layer the event is propagating from and its parents.\r\n  \t\tvar targets = this._findEventTargets(e, type);\r\n\r\n  \t\tif (canvasTargets) {\r\n  \t\t\tvar filtered = []; // pick only targets with listeners\r\n  \t\t\tfor (var i = 0; i < canvasTargets.length; i++) {\r\n  \t\t\t\tif (canvasTargets[i].listens(type, true)) {\r\n  \t\t\t\t\tfiltered.push(canvasTargets[i]);\r\n  \t\t\t\t}\r\n  \t\t\t}\r\n  \t\t\ttargets = filtered.concat(targets);\r\n  \t\t}\r\n\r\n  \t\tif (!targets.length) { return; }\r\n\r\n  \t\tif (type === 'contextmenu') {\r\n  \t\t\tpreventDefault(e);\r\n  \t\t}\r\n\r\n  \t\tvar target = targets[0];\r\n  \t\tvar data = {\r\n  \t\t\toriginalEvent: e\r\n  \t\t};\r\n\r\n  \t\tif (e.type !== 'keypress' && e.type !== 'keydown' && e.type !== 'keyup') {\r\n  \t\t\tvar isMarker = target.getLatLng && (!target._radius || target._radius <= 10);\r\n  \t\t\tdata.containerPoint = isMarker ?\r\n  \t\t\t\tthis.latLngToContainerPoint(target.getLatLng()) : this.mouseEventToContainerPoint(e);\r\n  \t\t\tdata.layerPoint = this.containerPointToLayerPoint(data.containerPoint);\r\n  \t\t\tdata.latlng = isMarker ? target.getLatLng() : this.layerPointToLatLng(data.layerPoint);\r\n  \t\t}\r\n\r\n  \t\tfor (i = 0; i < targets.length; i++) {\r\n  \t\t\ttargets[i].fire(type, data, true);\r\n  \t\t\tif (data.originalEvent._stopped ||\r\n  \t\t\t\t(targets[i].options.bubblingMouseEvents === false && indexOf(this._mouseEvents, type) !== -1)) { return; }\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_draggableMoved: function (obj) {\r\n  \t\tobj = obj.dragging && obj.dragging.enabled() ? obj : this;\r\n  \t\treturn (obj.dragging && obj.dragging.moved()) || (this.boxZoom && this.boxZoom.moved());\r\n  \t},\r\n\r\n  \t_clearHandlers: function () {\r\n  \t\tfor (var i = 0, len = this._handlers.length; i < len; i++) {\r\n  \t\t\tthis._handlers[i].disable();\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @section Other Methods\r\n\r\n  \t// @method whenReady(fn: Function, context?: Object): this\r\n  \t// Runs the given function `fn` when the map gets initialized with\r\n  \t// a view (center and zoom) and at least one layer, or immediately\r\n  \t// if it's already initialized, optionally passing a function context.\r\n  \twhenReady: function (callback, context) {\r\n  \t\tif (this._loaded) {\r\n  \t\t\tcallback.call(context || this, {target: this});\r\n  \t\t} else {\r\n  \t\t\tthis.on('load', callback, context);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n\r\n  \t// private methods for getting map state\r\n\r\n  \t_getMapPanePos: function () {\r\n  \t\treturn getPosition(this._mapPane) || new Point(0, 0);\r\n  \t},\r\n\r\n  \t_moved: function () {\r\n  \t\tvar pos = this._getMapPanePos();\r\n  \t\treturn pos && !pos.equals([0, 0]);\r\n  \t},\r\n\r\n  \t_getTopLeftPoint: function (center, zoom) {\r\n  \t\tvar pixelOrigin = center && zoom !== undefined ?\r\n  \t\t\tthis._getNewPixelOrigin(center, zoom) :\r\n  \t\t\tthis.getPixelOrigin();\r\n  \t\treturn pixelOrigin.subtract(this._getMapPanePos());\r\n  \t},\r\n\r\n  \t_getNewPixelOrigin: function (center, zoom) {\r\n  \t\tvar viewHalf = this.getSize()._divideBy(2);\r\n  \t\treturn this.project(center, zoom)._subtract(viewHalf)._add(this._getMapPanePos())._round();\r\n  \t},\r\n\r\n  \t_latLngToNewLayerPoint: function (latlng, zoom, center) {\r\n  \t\tvar topLeft = this._getNewPixelOrigin(center, zoom);\r\n  \t\treturn this.project(latlng, zoom)._subtract(topLeft);\r\n  \t},\r\n\r\n  \t_latLngBoundsToNewLayerBounds: function (latLngBounds, zoom, center) {\r\n  \t\tvar topLeft = this._getNewPixelOrigin(center, zoom);\r\n  \t\treturn toBounds([\r\n  \t\t\tthis.project(latLngBounds.getSouthWest(), zoom)._subtract(topLeft),\r\n  \t\t\tthis.project(latLngBounds.getNorthWest(), zoom)._subtract(topLeft),\r\n  \t\t\tthis.project(latLngBounds.getSouthEast(), zoom)._subtract(topLeft),\r\n  \t\t\tthis.project(latLngBounds.getNorthEast(), zoom)._subtract(topLeft)\r\n  \t\t]);\r\n  \t},\r\n\r\n  \t// layer point of the current center\r\n  \t_getCenterLayerPoint: function () {\r\n  \t\treturn this.containerPointToLayerPoint(this.getSize()._divideBy(2));\r\n  \t},\r\n\r\n  \t// offset of the specified place to the current center in pixels\r\n  \t_getCenterOffset: function (latlng) {\r\n  \t\treturn this.latLngToLayerPoint(latlng).subtract(this._getCenterLayerPoint());\r\n  \t},\r\n\r\n  \t// adjust center for view to get inside bounds\r\n  \t_limitCenter: function (center, zoom, bounds) {\r\n\r\n  \t\tif (!bounds) { return center; }\r\n\r\n  \t\tvar centerPoint = this.project(center, zoom),\r\n  \t\t    viewHalf = this.getSize().divideBy(2),\r\n  \t\t    viewBounds = new Bounds(centerPoint.subtract(viewHalf), centerPoint.add(viewHalf)),\r\n  \t\t    offset = this._getBoundsOffset(viewBounds, bounds, zoom);\r\n\r\n  \t\t// If offset is less than a pixel, ignore.\r\n  \t\t// This prevents unstable projections from getting into\r\n  \t\t// an infinite loop of tiny offsets.\r\n  \t\tif (Math.abs(offset.x) <= 1 && Math.abs(offset.y) <= 1) {\r\n  \t\t\treturn center;\r\n  \t\t}\r\n\r\n  \t\treturn this.unproject(centerPoint.add(offset), zoom);\r\n  \t},\r\n\r\n  \t// adjust offset for view to get inside bounds\r\n  \t_limitOffset: function (offset, bounds) {\r\n  \t\tif (!bounds) { return offset; }\r\n\r\n  \t\tvar viewBounds = this.getPixelBounds(),\r\n  \t\t    newBounds = new Bounds(viewBounds.min.add(offset), viewBounds.max.add(offset));\r\n\r\n  \t\treturn offset.add(this._getBoundsOffset(newBounds, bounds));\r\n  \t},\r\n\r\n  \t// returns offset needed for pxBounds to get inside maxBounds at a specified zoom\r\n  \t_getBoundsOffset: function (pxBounds, maxBounds, zoom) {\r\n  \t\tvar projectedMaxBounds = toBounds(\r\n  \t\t        this.project(maxBounds.getNorthEast(), zoom),\r\n  \t\t        this.project(maxBounds.getSouthWest(), zoom)\r\n  \t\t    ),\r\n  \t\t    minOffset = projectedMaxBounds.min.subtract(pxBounds.min),\r\n  \t\t    maxOffset = projectedMaxBounds.max.subtract(pxBounds.max),\r\n\r\n  \t\t    dx = this._rebound(minOffset.x, -maxOffset.x),\r\n  \t\t    dy = this._rebound(minOffset.y, -maxOffset.y);\r\n\r\n  \t\treturn new Point(dx, dy);\r\n  \t},\r\n\r\n  \t_rebound: function (left, right) {\r\n  \t\treturn left + right > 0 ?\r\n  \t\t\tMath.round(left - right) / 2 :\r\n  \t\t\tMath.max(0, Math.ceil(left)) - Math.max(0, Math.floor(right));\r\n  \t},\r\n\r\n  \t_limitZoom: function (zoom) {\r\n  \t\tvar min = this.getMinZoom(),\r\n  \t\t    max = this.getMaxZoom(),\r\n  \t\t    snap = Browser.any3d ? this.options.zoomSnap : 1;\r\n  \t\tif (snap) {\r\n  \t\t\tzoom = Math.round(zoom / snap) * snap;\r\n  \t\t}\r\n  \t\treturn Math.max(min, Math.min(max, zoom));\r\n  \t},\r\n\r\n  \t_onPanTransitionStep: function () {\r\n  \t\tthis.fire('move');\r\n  \t},\r\n\r\n  \t_onPanTransitionEnd: function () {\r\n  \t\tremoveClass(this._mapPane, 'leaflet-pan-anim');\r\n  \t\tthis.fire('moveend');\r\n  \t},\r\n\r\n  \t_tryAnimatedPan: function (center, options) {\r\n  \t\t// difference between the new and current centers in pixels\r\n  \t\tvar offset = this._getCenterOffset(center)._trunc();\r\n\r\n  \t\t// don't animate too far unless animate: true specified in options\r\n  \t\tif ((options && options.animate) !== true && !this.getSize().contains(offset)) { return false; }\r\n\r\n  \t\tthis.panBy(offset, options);\r\n\r\n  \t\treturn true;\r\n  \t},\r\n\r\n  \t_createAnimProxy: function () {\r\n\r\n  \t\tvar proxy = this._proxy = create$1('div', 'leaflet-proxy leaflet-zoom-animated');\r\n  \t\tthis._panes.mapPane.appendChild(proxy);\r\n\r\n  \t\tthis.on('zoomanim', function (e) {\r\n  \t\t\tvar prop = TRANSFORM,\r\n  \t\t\t    transform = this._proxy.style[prop];\r\n\r\n  \t\t\tsetTransform(this._proxy, this.project(e.center, e.zoom), this.getZoomScale(e.zoom, 1));\r\n\r\n  \t\t\t// workaround for case when transform is the same and so transitionend event is not fired\r\n  \t\t\tif (transform === this._proxy.style[prop] && this._animatingZoom) {\r\n  \t\t\t\tthis._onZoomTransitionEnd();\r\n  \t\t\t}\r\n  \t\t}, this);\r\n\r\n  \t\tthis.on('load moveend', this._animMoveEnd, this);\r\n\r\n  \t\tthis._on('unload', this._destroyAnimProxy, this);\r\n  \t},\r\n\r\n  \t_destroyAnimProxy: function () {\r\n  \t\tremove(this._proxy);\r\n  \t\tthis.off('load moveend', this._animMoveEnd, this);\r\n  \t\tdelete this._proxy;\r\n  \t},\r\n\r\n  \t_animMoveEnd: function () {\r\n  \t\tvar c = this.getCenter(),\r\n  \t\t    z = this.getZoom();\r\n  \t\tsetTransform(this._proxy, this.project(c, z), this.getZoomScale(z, 1));\r\n  \t},\r\n\r\n  \t_catchTransitionEnd: function (e) {\r\n  \t\tif (this._animatingZoom && e.propertyName.indexOf('transform') >= 0) {\r\n  \t\t\tthis._onZoomTransitionEnd();\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_nothingToAnimate: function () {\r\n  \t\treturn !this._container.getElementsByClassName('leaflet-zoom-animated').length;\r\n  \t},\r\n\r\n  \t_tryAnimatedZoom: function (center, zoom, options) {\r\n\r\n  \t\tif (this._animatingZoom) { return true; }\r\n\r\n  \t\toptions = options || {};\r\n\r\n  \t\t// don't animate if disabled, not supported or zoom difference is too large\r\n  \t\tif (!this._zoomAnimated || options.animate === false || this._nothingToAnimate() ||\r\n  \t\t        Math.abs(zoom - this._zoom) > this.options.zoomAnimationThreshold) { return false; }\r\n\r\n  \t\t// offset is the pixel coords of the zoom origin relative to the current center\r\n  \t\tvar scale = this.getZoomScale(zoom),\r\n  \t\t    offset = this._getCenterOffset(center)._divideBy(1 - 1 / scale);\r\n\r\n  \t\t// don't animate if the zoom origin isn't within one screen from the current center, unless forced\r\n  \t\tif (options.animate !== true && !this.getSize().contains(offset)) { return false; }\r\n\r\n  \t\trequestAnimFrame(function () {\r\n  \t\t\tthis\r\n  \t\t\t    ._moveStart(true, false)\r\n  \t\t\t    ._animateZoom(center, zoom, true);\r\n  \t\t}, this);\r\n\r\n  \t\treturn true;\r\n  \t},\r\n\r\n  \t_animateZoom: function (center, zoom, startAnim, noUpdate) {\r\n  \t\tif (!this._mapPane) { return; }\r\n\r\n  \t\tif (startAnim) {\r\n  \t\t\tthis._animatingZoom = true;\r\n\r\n  \t\t\t// remember what center/zoom to set after animation\r\n  \t\t\tthis._animateToCenter = center;\r\n  \t\t\tthis._animateToZoom = zoom;\r\n\r\n  \t\t\taddClass(this._mapPane, 'leaflet-zoom-anim');\r\n  \t\t}\r\n\r\n  \t\t// @section Other Events\r\n  \t\t// @event zoomanim: ZoomAnimEvent\r\n  \t\t// Fired at least once per zoom animation. For continuous zoom, like pinch zooming, fired once per frame during zoom.\r\n  \t\tthis.fire('zoomanim', {\r\n  \t\t\tcenter: center,\r\n  \t\t\tzoom: zoom,\r\n  \t\t\tnoUpdate: noUpdate\r\n  \t\t});\r\n\r\n  \t\tif (!this._tempFireZoomEvent) {\r\n  \t\t\tthis._tempFireZoomEvent = this._zoom !== this._animateToZoom;\r\n  \t\t}\r\n\r\n  \t\tthis._move(this._animateToCenter, this._animateToZoom, undefined, true);\r\n\r\n  \t\t// Work around webkit not firing 'transitionend', see https://github.com/Leaflet/Leaflet/issues/3689, 2693\r\n  \t\tsetTimeout(bind(this._onZoomTransitionEnd, this), 250);\r\n  \t},\r\n\r\n  \t_onZoomTransitionEnd: function () {\r\n  \t\tif (!this._animatingZoom) { return; }\r\n\r\n  \t\tif (this._mapPane) {\r\n  \t\t\tremoveClass(this._mapPane, 'leaflet-zoom-anim');\r\n  \t\t}\r\n\r\n  \t\tthis._animatingZoom = false;\r\n\r\n  \t\tthis._move(this._animateToCenter, this._animateToZoom, undefined, true);\r\n\r\n  \t\tif (this._tempFireZoomEvent) {\r\n  \t\t\tthis.fire('zoom');\r\n  \t\t}\r\n  \t\tdelete this._tempFireZoomEvent;\r\n\r\n  \t\tthis.fire('move');\r\n\r\n  \t\tthis._moveEnd(true);\r\n  \t}\r\n  });\r\n\r\n  // @section\r\n\r\n  // @factory L.map(id: String, options?: Map options)\r\n  // Instantiates a map object given the DOM ID of a `<div>` element\r\n  // and optionally an object literal with `Map options`.\r\n  //\r\n  // @alternative\r\n  // @factory L.map(el: HTMLElement, options?: Map options)\r\n  // Instantiates a map object given an instance of a `<div>` HTML element\r\n  // and optionally an object literal with `Map options`.\r\n  function createMap(id, options) {\r\n  \treturn new Map(id, options);\r\n  }\n\n  /*\r\n   * @class Control\r\n   * @aka L.Control\r\n   * @inherits Class\r\n   *\r\n   * L.Control is a base class for implementing map controls. Handles positioning.\r\n   * All other controls extend from this class.\r\n   */\r\n\r\n  var Control = Class.extend({\r\n  \t// @section\r\n  \t// @aka Control Options\r\n  \toptions: {\r\n  \t\t// @option position: String = 'topright'\r\n  \t\t// The position of the control (one of the map corners). Possible values are `'topleft'`,\r\n  \t\t// `'topright'`, `'bottomleft'` or `'bottomright'`\r\n  \t\tposition: 'topright'\r\n  \t},\r\n\r\n  \tinitialize: function (options) {\r\n  \t\tsetOptions(this, options);\r\n  \t},\r\n\r\n  \t/* @section\r\n  \t * Classes extending L.Control will inherit the following methods:\r\n  \t *\r\n  \t * @method getPosition: string\r\n  \t * Returns the position of the control.\r\n  \t */\r\n  \tgetPosition: function () {\r\n  \t\treturn this.options.position;\r\n  \t},\r\n\r\n  \t// @method setPosition(position: string): this\r\n  \t// Sets the position of the control.\r\n  \tsetPosition: function (position) {\r\n  \t\tvar map = this._map;\r\n\r\n  \t\tif (map) {\r\n  \t\t\tmap.removeControl(this);\r\n  \t\t}\r\n\r\n  \t\tthis.options.position = position;\r\n\r\n  \t\tif (map) {\r\n  \t\t\tmap.addControl(this);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getContainer: HTMLElement\r\n  \t// Returns the HTMLElement that contains the control.\r\n  \tgetContainer: function () {\r\n  \t\treturn this._container;\r\n  \t},\r\n\r\n  \t// @method addTo(map: Map): this\r\n  \t// Adds the control to the given map.\r\n  \taddTo: function (map) {\r\n  \t\tthis.remove();\r\n  \t\tthis._map = map;\r\n\r\n  \t\tvar container = this._container = this.onAdd(map),\r\n  \t\t    pos = this.getPosition(),\r\n  \t\t    corner = map._controlCorners[pos];\r\n\r\n  \t\taddClass(container, 'leaflet-control');\r\n\r\n  \t\tif (pos.indexOf('bottom') !== -1) {\r\n  \t\t\tcorner.insertBefore(container, corner.firstChild);\r\n  \t\t} else {\r\n  \t\t\tcorner.appendChild(container);\r\n  \t\t}\r\n\r\n  \t\tthis._map.on('unload', this.remove, this);\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method remove: this\r\n  \t// Removes the control from the map it is currently active on.\r\n  \tremove: function () {\r\n  \t\tif (!this._map) {\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tremove(this._container);\r\n\r\n  \t\tif (this.onRemove) {\r\n  \t\t\tthis.onRemove(this._map);\r\n  \t\t}\r\n\r\n  \t\tthis._map.off('unload', this.remove, this);\r\n  \t\tthis._map = null;\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_refocusOnMap: function (e) {\r\n  \t\t// if map exists and event is not a keyboard event\r\n  \t\tif (this._map && e && e.screenX > 0 && e.screenY > 0) {\r\n  \t\t\tthis._map.getContainer().focus();\r\n  \t\t}\r\n  \t}\r\n  });\r\n\r\n  var control = function (options) {\r\n  \treturn new Control(options);\r\n  };\r\n\r\n  /* @section Extension methods\r\n   * @uninheritable\r\n   *\r\n   * Every control should extend from `L.Control` and (re-)implement the following methods.\r\n   *\r\n   * @method onAdd(map: Map): HTMLElement\r\n   * Should return the container DOM element for the control and add listeners on relevant map events. Called on [`control.addTo(map)`](#control-addTo).\r\n   *\r\n   * @method onRemove(map: Map)\r\n   * Optional method. Should contain all clean up code that removes the listeners previously added in [`onAdd`](#control-onadd). Called on [`control.remove()`](#control-remove).\r\n   */\r\n\r\n  /* @namespace Map\r\n   * @section Methods for Layers and Controls\r\n   */\r\n  Map.include({\r\n  \t// @method addControl(control: Control): this\r\n  \t// Adds the given control to the map\r\n  \taddControl: function (control) {\r\n  \t\tcontrol.addTo(this);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method removeControl(control: Control): this\r\n  \t// Removes the given control from the map\r\n  \tremoveControl: function (control) {\r\n  \t\tcontrol.remove();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_initControlPos: function () {\r\n  \t\tvar corners = this._controlCorners = {},\r\n  \t\t    l = 'leaflet-',\r\n  \t\t    container = this._controlContainer =\r\n  \t\t            create$1('div', l + 'control-container', this._container);\r\n\r\n  \t\tfunction createCorner(vSide, hSide) {\r\n  \t\t\tvar className = l + vSide + ' ' + l + hSide;\r\n\r\n  \t\t\tcorners[vSide + hSide] = create$1('div', className, container);\r\n  \t\t}\r\n\r\n  \t\tcreateCorner('top', 'left');\r\n  \t\tcreateCorner('top', 'right');\r\n  \t\tcreateCorner('bottom', 'left');\r\n  \t\tcreateCorner('bottom', 'right');\r\n  \t},\r\n\r\n  \t_clearControlPos: function () {\r\n  \t\tfor (var i in this._controlCorners) {\r\n  \t\t\tremove(this._controlCorners[i]);\r\n  \t\t}\r\n  \t\tremove(this._controlContainer);\r\n  \t\tdelete this._controlCorners;\r\n  \t\tdelete this._controlContainer;\r\n  \t}\r\n  });\n\n  /*\r\n   * @class Control.Layers\r\n   * @aka L.Control.Layers\r\n   * @inherits Control\r\n   *\r\n   * The layers control gives users the ability to switch between different base layers and switch overlays on/off (check out the [detailed example](https://leafletjs.com/examples/layers-control/)). Extends `Control`.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var baseLayers = {\r\n   * \t\"Mapbox\": mapbox,\r\n   * \t\"OpenStreetMap\": osm\r\n   * };\r\n   *\r\n   * var overlays = {\r\n   * \t\"Marker\": marker,\r\n   * \t\"Roads\": roadsLayer\r\n   * };\r\n   *\r\n   * L.control.layers(baseLayers, overlays).addTo(map);\r\n   * ```\r\n   *\r\n   * The `baseLayers` and `overlays` parameters are object literals with layer names as keys and `Layer` objects as values:\r\n   *\r\n   * ```js\r\n   * {\r\n   *     \"<someName1>\": layer1,\r\n   *     \"<someName2>\": layer2\r\n   * }\r\n   * ```\r\n   *\r\n   * The layer names can contain HTML, which allows you to add additional styling to the items:\r\n   *\r\n   * ```js\r\n   * {\"<img src='my-layer-icon' /> <span class='my-layer-item'>My Layer</span>\": myLayer}\r\n   * ```\r\n   */\r\n\r\n  var Layers = Control.extend({\r\n  \t// @section\r\n  \t// @aka Control.Layers options\r\n  \toptions: {\r\n  \t\t// @option collapsed: Boolean = true\r\n  \t\t// If `true`, the control will be collapsed into an icon and expanded on mouse hover, touch, or keyboard activation.\r\n  \t\tcollapsed: true,\r\n  \t\tposition: 'topright',\r\n\r\n  \t\t// @option autoZIndex: Boolean = true\r\n  \t\t// If `true`, the control will assign zIndexes in increasing order to all of its layers so that the order is preserved when switching them on/off.\r\n  \t\tautoZIndex: true,\r\n\r\n  \t\t// @option hideSingleBase: Boolean = false\r\n  \t\t// If `true`, the base layers in the control will be hidden when there is only one.\r\n  \t\thideSingleBase: false,\r\n\r\n  \t\t// @option sortLayers: Boolean = false\r\n  \t\t// Whether to sort the layers. When `false`, layers will keep the order\r\n  \t\t// in which they were added to the control.\r\n  \t\tsortLayers: false,\r\n\r\n  \t\t// @option sortFunction: Function = *\r\n  \t\t// A [compare function](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array/sort)\r\n  \t\t// that will be used for sorting the layers, when `sortLayers` is `true`.\r\n  \t\t// The function receives both the `L.Layer` instances and their names, as in\r\n  \t\t// `sortFunction(layerA, layerB, nameA, nameB)`.\r\n  \t\t// By default, it sorts layers alphabetically by their name.\r\n  \t\tsortFunction: function (layerA, layerB, nameA, nameB) {\r\n  \t\t\treturn nameA < nameB ? -1 : (nameB < nameA ? 1 : 0);\r\n  \t\t}\r\n  \t},\r\n\r\n  \tinitialize: function (baseLayers, overlays, options) {\r\n  \t\tsetOptions(this, options);\r\n\r\n  \t\tthis._layerControlInputs = [];\r\n  \t\tthis._layers = [];\r\n  \t\tthis._lastZIndex = 0;\r\n  \t\tthis._handlingClick = false;\r\n\r\n  \t\tfor (var i in baseLayers) {\r\n  \t\t\tthis._addLayer(baseLayers[i], i);\r\n  \t\t}\r\n\r\n  \t\tfor (i in overlays) {\r\n  \t\t\tthis._addLayer(overlays[i], i, true);\r\n  \t\t}\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tthis._initLayout();\r\n  \t\tthis._update();\r\n\r\n  \t\tthis._map = map;\r\n  \t\tmap.on('zoomend', this._checkDisabledLayers, this);\r\n\r\n  \t\tfor (var i = 0; i < this._layers.length; i++) {\r\n  \t\t\tthis._layers[i].layer.on('add remove', this._onLayerChange, this);\r\n  \t\t}\r\n\r\n  \t\treturn this._container;\r\n  \t},\r\n\r\n  \taddTo: function (map) {\r\n  \t\tControl.prototype.addTo.call(this, map);\r\n  \t\t// Trigger expand after Layers Control has been inserted into DOM so that is now has an actual height.\r\n  \t\treturn this._expandIfNotCollapsed();\r\n  \t},\r\n\r\n  \tonRemove: function () {\r\n  \t\tthis._map.off('zoomend', this._checkDisabledLayers, this);\r\n\r\n  \t\tfor (var i = 0; i < this._layers.length; i++) {\r\n  \t\t\tthis._layers[i].layer.off('add remove', this._onLayerChange, this);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method addBaseLayer(layer: Layer, name: String): this\r\n  \t// Adds a base layer (radio button entry) with the given name to the control.\r\n  \taddBaseLayer: function (layer, name) {\r\n  \t\tthis._addLayer(layer, name);\r\n  \t\treturn (this._map) ? this._update() : this;\r\n  \t},\r\n\r\n  \t// @method addOverlay(layer: Layer, name: String): this\r\n  \t// Adds an overlay (checkbox entry) with the given name to the control.\r\n  \taddOverlay: function (layer, name) {\r\n  \t\tthis._addLayer(layer, name, true);\r\n  \t\treturn (this._map) ? this._update() : this;\r\n  \t},\r\n\r\n  \t// @method removeLayer(layer: Layer): this\r\n  \t// Remove the given layer from the control.\r\n  \tremoveLayer: function (layer) {\r\n  \t\tlayer.off('add remove', this._onLayerChange, this);\r\n\r\n  \t\tvar obj = this._getLayer(stamp(layer));\r\n  \t\tif (obj) {\r\n  \t\t\tthis._layers.splice(this._layers.indexOf(obj), 1);\r\n  \t\t}\r\n  \t\treturn (this._map) ? this._update() : this;\r\n  \t},\r\n\r\n  \t// @method expand(): this\r\n  \t// Expand the control container if collapsed.\r\n  \texpand: function () {\r\n  \t\taddClass(this._container, 'leaflet-control-layers-expanded');\r\n  \t\tthis._section.style.height = null;\r\n  \t\tvar acceptableHeight = this._map.getSize().y - (this._container.offsetTop + 50);\r\n  \t\tif (acceptableHeight < this._section.clientHeight) {\r\n  \t\t\taddClass(this._section, 'leaflet-control-layers-scrollbar');\r\n  \t\t\tthis._section.style.height = acceptableHeight + 'px';\r\n  \t\t} else {\r\n  \t\t\tremoveClass(this._section, 'leaflet-control-layers-scrollbar');\r\n  \t\t}\r\n  \t\tthis._checkDisabledLayers();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method collapse(): this\r\n  \t// Collapse the control container if expanded.\r\n  \tcollapse: function () {\r\n  \t\tremoveClass(this._container, 'leaflet-control-layers-expanded');\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_initLayout: function () {\r\n  \t\tvar className = 'leaflet-control-layers',\r\n  \t\t    container = this._container = create$1('div', className),\r\n  \t\t    collapsed = this.options.collapsed;\r\n\r\n  \t\t// makes this work on IE touch devices by stopping it from firing a mouseout event when the touch is released\r\n  \t\tcontainer.setAttribute('aria-haspopup', true);\r\n\r\n  \t\tdisableClickPropagation(container);\r\n  \t\tdisableScrollPropagation(container);\r\n\r\n  \t\tvar section = this._section = create$1('section', className + '-list');\r\n\r\n  \t\tif (collapsed) {\r\n  \t\t\tthis._map.on('click', this.collapse, this);\r\n\r\n  \t\t\ton(container, {\r\n  \t\t\t\tmouseenter: this._expandSafely,\r\n  \t\t\t\tmouseleave: this.collapse\r\n  \t\t\t}, this);\r\n  \t\t}\r\n\r\n  \t\tvar link = this._layersLink = create$1('a', className + '-toggle', container);\r\n  \t\tlink.href = '#';\r\n  \t\tlink.title = 'Layers';\r\n  \t\tlink.setAttribute('role', 'button');\r\n\r\n  \t\ton(link, {\r\n  \t\t\tkeydown: function (e) {\r\n  \t\t\t\tif (e.keyCode === 13) {\r\n  \t\t\t\t\tthis._expandSafely();\r\n  \t\t\t\t}\r\n  \t\t\t},\r\n  \t\t\t// Certain screen readers intercept the key event and instead send a click event\r\n  \t\t\tclick: function (e) {\r\n  \t\t\t\tpreventDefault(e);\r\n  \t\t\t\tthis._expandSafely();\r\n  \t\t\t}\r\n  \t\t}, this);\r\n\r\n  \t\tif (!collapsed) {\r\n  \t\t\tthis.expand();\r\n  \t\t}\r\n\r\n  \t\tthis._baseLayersList = create$1('div', className + '-base', section);\r\n  \t\tthis._separator = create$1('div', className + '-separator', section);\r\n  \t\tthis._overlaysList = create$1('div', className + '-overlays', section);\r\n\r\n  \t\tcontainer.appendChild(section);\r\n  \t},\r\n\r\n  \t_getLayer: function (id) {\r\n  \t\tfor (var i = 0; i < this._layers.length; i++) {\r\n\r\n  \t\t\tif (this._layers[i] && stamp(this._layers[i].layer) === id) {\r\n  \t\t\t\treturn this._layers[i];\r\n  \t\t\t}\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_addLayer: function (layer, name, overlay) {\r\n  \t\tif (this._map) {\r\n  \t\t\tlayer.on('add remove', this._onLayerChange, this);\r\n  \t\t}\r\n\r\n  \t\tthis._layers.push({\r\n  \t\t\tlayer: layer,\r\n  \t\t\tname: name,\r\n  \t\t\toverlay: overlay\r\n  \t\t});\r\n\r\n  \t\tif (this.options.sortLayers) {\r\n  \t\t\tthis._layers.sort(bind(function (a, b) {\r\n  \t\t\t\treturn this.options.sortFunction(a.layer, b.layer, a.name, b.name);\r\n  \t\t\t}, this));\r\n  \t\t}\r\n\r\n  \t\tif (this.options.autoZIndex && layer.setZIndex) {\r\n  \t\t\tthis._lastZIndex++;\r\n  \t\t\tlayer.setZIndex(this._lastZIndex);\r\n  \t\t}\r\n\r\n  \t\tthis._expandIfNotCollapsed();\r\n  \t},\r\n\r\n  \t_update: function () {\r\n  \t\tif (!this._container) { return this; }\r\n\r\n  \t\tempty(this._baseLayersList);\r\n  \t\tempty(this._overlaysList);\r\n\r\n  \t\tthis._layerControlInputs = [];\r\n  \t\tvar baseLayersPresent, overlaysPresent, i, obj, baseLayersCount = 0;\r\n\r\n  \t\tfor (i = 0; i < this._layers.length; i++) {\r\n  \t\t\tobj = this._layers[i];\r\n  \t\t\tthis._addItem(obj);\r\n  \t\t\toverlaysPresent = overlaysPresent || obj.overlay;\r\n  \t\t\tbaseLayersPresent = baseLayersPresent || !obj.overlay;\r\n  \t\t\tbaseLayersCount += !obj.overlay ? 1 : 0;\r\n  \t\t}\r\n\r\n  \t\t// Hide base layers section if there's only one layer.\r\n  \t\tif (this.options.hideSingleBase) {\r\n  \t\t\tbaseLayersPresent = baseLayersPresent && baseLayersCount > 1;\r\n  \t\t\tthis._baseLayersList.style.display = baseLayersPresent ? '' : 'none';\r\n  \t\t}\r\n\r\n  \t\tthis._separator.style.display = overlaysPresent && baseLayersPresent ? '' : 'none';\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_onLayerChange: function (e) {\r\n  \t\tif (!this._handlingClick) {\r\n  \t\t\tthis._update();\r\n  \t\t}\r\n\r\n  \t\tvar obj = this._getLayer(stamp(e.target));\r\n\r\n  \t\t// @namespace Map\r\n  \t\t// @section Layer events\r\n  \t\t// @event baselayerchange: LayersControlEvent\r\n  \t\t// Fired when the base layer is changed through the [layers control](#control-layers).\r\n  \t\t// @event overlayadd: LayersControlEvent\r\n  \t\t// Fired when an overlay is selected through the [layers control](#control-layers).\r\n  \t\t// @event overlayremove: LayersControlEvent\r\n  \t\t// Fired when an overlay is deselected through the [layers control](#control-layers).\r\n  \t\t// @namespace Control.Layers\r\n  \t\tvar type = obj.overlay ?\r\n  \t\t\t(e.type === 'add' ? 'overlayadd' : 'overlayremove') :\r\n  \t\t\t(e.type === 'add' ? 'baselayerchange' : null);\r\n\r\n  \t\tif (type) {\r\n  \t\t\tthis._map.fire(type, obj);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// IE7 bugs out if you create a radio dynamically, so you have to do it this hacky way (see https://stackoverflow.com/a/119079)\r\n  \t_createRadioElement: function (name, checked) {\r\n\r\n  \t\tvar radioHtml = '<input type=\"radio\" class=\"leaflet-control-layers-selector\" name=\"' +\r\n  \t\t\t\tname + '\"' + (checked ? ' checked=\"checked\"' : '') + '/>';\r\n\r\n  \t\tvar radioFragment = document.createElement('div');\r\n  \t\tradioFragment.innerHTML = radioHtml;\r\n\r\n  \t\treturn radioFragment.firstChild;\r\n  \t},\r\n\r\n  \t_addItem: function (obj) {\r\n  \t\tvar label = document.createElement('label'),\r\n  \t\t    checked = this._map.hasLayer(obj.layer),\r\n  \t\t    input;\r\n\r\n  \t\tif (obj.overlay) {\r\n  \t\t\tinput = document.createElement('input');\r\n  \t\t\tinput.type = 'checkbox';\r\n  \t\t\tinput.className = 'leaflet-control-layers-selector';\r\n  \t\t\tinput.defaultChecked = checked;\r\n  \t\t} else {\r\n  \t\t\tinput = this._createRadioElement('leaflet-base-layers_' + stamp(this), checked);\r\n  \t\t}\r\n\r\n  \t\tthis._layerControlInputs.push(input);\r\n  \t\tinput.layerId = stamp(obj.layer);\r\n\r\n  \t\ton(input, 'click', this._onInputClick, this);\r\n\r\n  \t\tvar name = document.createElement('span');\r\n  \t\tname.innerHTML = ' ' + obj.name;\r\n\r\n  \t\t// Helps from preventing layer control flicker when checkboxes are disabled\r\n  \t\t// https://github.com/Leaflet/Leaflet/issues/2771\r\n  \t\tvar holder = document.createElement('span');\r\n\r\n  \t\tlabel.appendChild(holder);\r\n  \t\tholder.appendChild(input);\r\n  \t\tholder.appendChild(name);\r\n\r\n  \t\tvar container = obj.overlay ? this._overlaysList : this._baseLayersList;\r\n  \t\tcontainer.appendChild(label);\r\n\r\n  \t\tthis._checkDisabledLayers();\r\n  \t\treturn label;\r\n  \t},\r\n\r\n  \t_onInputClick: function () {\r\n  \t\tvar inputs = this._layerControlInputs,\r\n  \t\t    input, layer;\r\n  \t\tvar addedLayers = [],\r\n  \t\t    removedLayers = [];\r\n\r\n  \t\tthis._handlingClick = true;\r\n\r\n  \t\tfor (var i = inputs.length - 1; i >= 0; i--) {\r\n  \t\t\tinput = inputs[i];\r\n  \t\t\tlayer = this._getLayer(input.layerId).layer;\r\n\r\n  \t\t\tif (input.checked) {\r\n  \t\t\t\taddedLayers.push(layer);\r\n  \t\t\t} else if (!input.checked) {\r\n  \t\t\t\tremovedLayers.push(layer);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\t// Bugfix issue 2318: Should remove all old layers before readding new ones\r\n  \t\tfor (i = 0; i < removedLayers.length; i++) {\r\n  \t\t\tif (this._map.hasLayer(removedLayers[i])) {\r\n  \t\t\t\tthis._map.removeLayer(removedLayers[i]);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\tfor (i = 0; i < addedLayers.length; i++) {\r\n  \t\t\tif (!this._map.hasLayer(addedLayers[i])) {\r\n  \t\t\t\tthis._map.addLayer(addedLayers[i]);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tthis._handlingClick = false;\r\n\r\n  \t\tthis._refocusOnMap();\r\n  \t},\r\n\r\n  \t_checkDisabledLayers: function () {\r\n  \t\tvar inputs = this._layerControlInputs,\r\n  \t\t    input,\r\n  \t\t    layer,\r\n  \t\t    zoom = this._map.getZoom();\r\n\r\n  \t\tfor (var i = inputs.length - 1; i >= 0; i--) {\r\n  \t\t\tinput = inputs[i];\r\n  \t\t\tlayer = this._getLayer(input.layerId).layer;\r\n  \t\t\tinput.disabled = (layer.options.minZoom !== undefined && zoom < layer.options.minZoom) ||\r\n  \t\t\t                 (layer.options.maxZoom !== undefined && zoom > layer.options.maxZoom);\r\n\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_expandIfNotCollapsed: function () {\r\n  \t\tif (this._map && !this.options.collapsed) {\r\n  \t\t\tthis.expand();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_expandSafely: function () {\r\n  \t\tvar section = this._section;\r\n  \t\ton(section, 'click', preventDefault);\r\n  \t\tthis.expand();\r\n  \t\tsetTimeout(function () {\r\n  \t\t\toff(section, 'click', preventDefault);\r\n  \t\t});\r\n  \t}\r\n\r\n  });\r\n\r\n\r\n  // @factory L.control.layers(baselayers?: Object, overlays?: Object, options?: Control.Layers options)\r\n  // Creates a layers control with the given layers. Base layers will be switched with radio buttons, while overlays will be switched with checkboxes. Note that all base layers should be passed in the base layers object, but only one should be added to the map during map instantiation.\r\n  var layers = function (baseLayers, overlays, options) {\r\n  \treturn new Layers(baseLayers, overlays, options);\r\n  };\n\n  /*\r\n   * @class Control.Zoom\r\n   * @aka L.Control.Zoom\r\n   * @inherits Control\r\n   *\r\n   * A basic zoom control with two buttons (zoom in and zoom out). It is put on the map by default unless you set its [`zoomControl` option](#map-zoomcontrol) to `false`. Extends `Control`.\r\n   */\r\n\r\n  var Zoom = Control.extend({\r\n  \t// @section\r\n  \t// @aka Control.Zoom options\r\n  \toptions: {\r\n  \t\tposition: 'topleft',\r\n\r\n  \t\t// @option zoomInText: String = '<span aria-hidden=\"true\">+</span>'\r\n  \t\t// The text set on the 'zoom in' button.\r\n  \t\tzoomInText: '<span aria-hidden=\"true\">+</span>',\r\n\r\n  \t\t// @option zoomInTitle: String = 'Zoom in'\r\n  \t\t// The title set on the 'zoom in' button.\r\n  \t\tzoomInTitle: 'Zoom in',\r\n\r\n  \t\t// @option zoomOutText: String = '<span aria-hidden=\"true\">&#x2212;</span>'\r\n  \t\t// The text set on the 'zoom out' button.\r\n  \t\tzoomOutText: '<span aria-hidden=\"true\">&#x2212;</span>',\r\n\r\n  \t\t// @option zoomOutTitle: String = 'Zoom out'\r\n  \t\t// The title set on the 'zoom out' button.\r\n  \t\tzoomOutTitle: 'Zoom out'\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tvar zoomName = 'leaflet-control-zoom',\r\n  \t\t    container = create$1('div', zoomName + ' leaflet-bar'),\r\n  \t\t    options = this.options;\r\n\r\n  \t\tthis._zoomInButton  = this._createButton(options.zoomInText, options.zoomInTitle,\r\n  \t\t        zoomName + '-in',  container, this._zoomIn);\r\n  \t\tthis._zoomOutButton = this._createButton(options.zoomOutText, options.zoomOutTitle,\r\n  \t\t        zoomName + '-out', container, this._zoomOut);\r\n\r\n  \t\tthis._updateDisabled();\r\n  \t\tmap.on('zoomend zoomlevelschange', this._updateDisabled, this);\r\n\r\n  \t\treturn container;\r\n  \t},\r\n\r\n  \tonRemove: function (map) {\r\n  \t\tmap.off('zoomend zoomlevelschange', this._updateDisabled, this);\r\n  \t},\r\n\r\n  \tdisable: function () {\r\n  \t\tthis._disabled = true;\r\n  \t\tthis._updateDisabled();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \tenable: function () {\r\n  \t\tthis._disabled = false;\r\n  \t\tthis._updateDisabled();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_zoomIn: function (e) {\r\n  \t\tif (!this._disabled && this._map._zoom < this._map.getMaxZoom()) {\r\n  \t\t\tthis._map.zoomIn(this._map.options.zoomDelta * (e.shiftKey ? 3 : 1));\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_zoomOut: function (e) {\r\n  \t\tif (!this._disabled && this._map._zoom > this._map.getMinZoom()) {\r\n  \t\t\tthis._map.zoomOut(this._map.options.zoomDelta * (e.shiftKey ? 3 : 1));\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_createButton: function (html, title, className, container, fn) {\r\n  \t\tvar link = create$1('a', className, container);\r\n  \t\tlink.innerHTML = html;\r\n  \t\tlink.href = '#';\r\n  \t\tlink.title = title;\r\n\r\n  \t\t/*\r\n  \t\t * Will force screen readers like VoiceOver to read this as \"Zoom in - button\"\r\n  \t\t */\r\n  \t\tlink.setAttribute('role', 'button');\r\n  \t\tlink.setAttribute('aria-label', title);\r\n\r\n  \t\tdisableClickPropagation(link);\r\n  \t\ton(link, 'click', stop);\r\n  \t\ton(link, 'click', fn, this);\r\n  \t\ton(link, 'click', this._refocusOnMap, this);\r\n\r\n  \t\treturn link;\r\n  \t},\r\n\r\n  \t_updateDisabled: function () {\r\n  \t\tvar map = this._map,\r\n  \t\t    className = 'leaflet-disabled';\r\n\r\n  \t\tremoveClass(this._zoomInButton, className);\r\n  \t\tremoveClass(this._zoomOutButton, className);\r\n  \t\tthis._zoomInButton.setAttribute('aria-disabled', 'false');\r\n  \t\tthis._zoomOutButton.setAttribute('aria-disabled', 'false');\r\n\r\n  \t\tif (this._disabled || map._zoom === map.getMinZoom()) {\r\n  \t\t\taddClass(this._zoomOutButton, className);\r\n  \t\t\tthis._zoomOutButton.setAttribute('aria-disabled', 'true');\r\n  \t\t}\r\n  \t\tif (this._disabled || map._zoom === map.getMaxZoom()) {\r\n  \t\t\taddClass(this._zoomInButton, className);\r\n  \t\t\tthis._zoomInButton.setAttribute('aria-disabled', 'true');\r\n  \t\t}\r\n  \t}\r\n  });\r\n\r\n  // @namespace Map\r\n  // @section Control options\r\n  // @option zoomControl: Boolean = true\r\n  // Whether a [zoom control](#control-zoom) is added to the map by default.\r\n  Map.mergeOptions({\r\n  \tzoomControl: true\r\n  });\r\n\r\n  Map.addInitHook(function () {\r\n  \tif (this.options.zoomControl) {\r\n  \t\t// @section Controls\r\n  \t\t// @property zoomControl: Control.Zoom\r\n  \t\t// The default zoom control (only available if the\r\n  \t\t// [`zoomControl` option](#map-zoomcontrol) was `true` when creating the map).\r\n  \t\tthis.zoomControl = new Zoom();\r\n  \t\tthis.addControl(this.zoomControl);\r\n  \t}\r\n  });\r\n\r\n  // @namespace Control.Zoom\r\n  // @factory L.control.zoom(options: Control.Zoom options)\r\n  // Creates a zoom control\r\n  var zoom = function (options) {\r\n  \treturn new Zoom(options);\r\n  };\n\n  /*\n   * @class Control.Scale\n   * @aka L.Control.Scale\n   * @inherits Control\n   *\n   * A simple scale control that shows the scale of the current center of screen in metric (m/km) and imperial (mi/ft) systems. Extends `Control`.\n   *\n   * @example\n   *\n   * ```js\n   * L.control.scale().addTo(map);\n   * ```\n   */\n\n  var Scale = Control.extend({\n  \t// @section\n  \t// @aka Control.Scale options\n  \toptions: {\n  \t\tposition: 'bottomleft',\n\n  \t\t// @option maxWidth: Number = 100\n  \t\t// Maximum width of the control in pixels. The width is set dynamically to show round values (e.g. 100, 200, 500).\n  \t\tmaxWidth: 100,\n\n  \t\t// @option metric: Boolean = True\n  \t\t// Whether to show the metric scale line (m/km).\n  \t\tmetric: true,\n\n  \t\t// @option imperial: Boolean = True\n  \t\t// Whether to show the imperial scale line (mi/ft).\n  \t\timperial: true\n\n  \t\t// @option updateWhenIdle: Boolean = false\n  \t\t// If `true`, the control is updated on [`moveend`](#map-moveend), otherwise it's always up-to-date (updated on [`move`](#map-move)).\n  \t},\n\n  \tonAdd: function (map) {\n  \t\tvar className = 'leaflet-control-scale',\n  \t\t    container = create$1('div', className),\n  \t\t    options = this.options;\n\n  \t\tthis._addScales(options, className + '-line', container);\n\n  \t\tmap.on(options.updateWhenIdle ? 'moveend' : 'move', this._update, this);\n  \t\tmap.whenReady(this._update, this);\n\n  \t\treturn container;\n  \t},\n\n  \tonRemove: function (map) {\n  \t\tmap.off(this.options.updateWhenIdle ? 'moveend' : 'move', this._update, this);\n  \t},\n\n  \t_addScales: function (options, className, container) {\n  \t\tif (options.metric) {\n  \t\t\tthis._mScale = create$1('div', className, container);\n  \t\t}\n  \t\tif (options.imperial) {\n  \t\t\tthis._iScale = create$1('div', className, container);\n  \t\t}\n  \t},\n\n  \t_update: function () {\n  \t\tvar map = this._map,\n  \t\t    y = map.getSize().y / 2;\n\n  \t\tvar maxMeters = map.distance(\n  \t\t\tmap.containerPointToLatLng([0, y]),\n  \t\t\tmap.containerPointToLatLng([this.options.maxWidth, y]));\n\n  \t\tthis._updateScales(maxMeters);\n  \t},\n\n  \t_updateScales: function (maxMeters) {\n  \t\tif (this.options.metric && maxMeters) {\n  \t\t\tthis._updateMetric(maxMeters);\n  \t\t}\n  \t\tif (this.options.imperial && maxMeters) {\n  \t\t\tthis._updateImperial(maxMeters);\n  \t\t}\n  \t},\n\n  \t_updateMetric: function (maxMeters) {\n  \t\tvar meters = this._getRoundNum(maxMeters),\n  \t\t    label = meters < 1000 ? meters + ' m' : (meters / 1000) + ' km';\n\n  \t\tthis._updateScale(this._mScale, label, meters / maxMeters);\n  \t},\n\n  \t_updateImperial: function (maxMeters) {\n  \t\tvar maxFeet = maxMeters * 3.2808399,\n  \t\t    maxMiles, miles, feet;\n\n  \t\tif (maxFeet > 5280) {\n  \t\t\tmaxMiles = maxFeet / 5280;\n  \t\t\tmiles = this._getRoundNum(maxMiles);\n  \t\t\tthis._updateScale(this._iScale, miles + ' mi', miles / maxMiles);\n\n  \t\t} else {\n  \t\t\tfeet = this._getRoundNum(maxFeet);\n  \t\t\tthis._updateScale(this._iScale, feet + ' ft', feet / maxFeet);\n  \t\t}\n  \t},\n\n  \t_updateScale: function (scale, text, ratio) {\n  \t\tscale.style.width = Math.round(this.options.maxWidth * ratio) + 'px';\n  \t\tscale.innerHTML = text;\n  \t},\n\n  \t_getRoundNum: function (num) {\n  \t\tvar pow10 = Math.pow(10, (Math.floor(num) + '').length - 1),\n  \t\t    d = num / pow10;\n\n  \t\td = d >= 10 ? 10 :\n  \t\t    d >= 5 ? 5 :\n  \t\t    d >= 3 ? 3 :\n  \t\t    d >= 2 ? 2 : 1;\n\n  \t\treturn pow10 * d;\n  \t}\n  });\n\n\n  // @factory L.control.scale(options?: Control.Scale options)\n  // Creates an scale control with the given options.\n  var scale = function (options) {\n  \treturn new Scale(options);\n  };\n\n  var ukrainianFlag = '<svg aria-hidden=\"true\" xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"8\" viewBox=\"0 0 12 8\" class=\"leaflet-attribution-flag\"><path fill=\"#4C7BE1\" d=\"M0 0h12v4H0z\"/><path fill=\"#FFD500\" d=\"M0 4h12v3H0z\"/><path fill=\"#E0BC00\" d=\"M0 7h12v1H0z\"/></svg>';\r\n\r\n\r\n  /*\r\n   * @class Control.Attribution\r\n   * @aka L.Control.Attribution\r\n   * @inherits Control\r\n   *\r\n   * The attribution control allows you to display attribution data in a small text box on a map. It is put on the map by default unless you set its [`attributionControl` option](#map-attributioncontrol) to `false`, and it fetches attribution texts from layers with the [`getAttribution` method](#layer-getattribution) automatically. Extends Control.\r\n   */\r\n\r\n  var Attribution = Control.extend({\r\n  \t// @section\r\n  \t// @aka Control.Attribution options\r\n  \toptions: {\r\n  \t\tposition: 'bottomright',\r\n\r\n  \t\t// @option prefix: String|false = 'Leaflet'\r\n  \t\t// The HTML text shown before the attributions. Pass `false` to disable.\r\n  \t\tprefix: '<a href=\"https://leafletjs.com\" title=\"A JavaScript library for interactive maps\">' + (Browser.inlineSvg ? ukrainianFlag + ' ' : '') + 'Leaflet</a>'\r\n  \t},\r\n\r\n  \tinitialize: function (options) {\r\n  \t\tsetOptions(this, options);\r\n\r\n  \t\tthis._attributions = {};\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tmap.attributionControl = this;\r\n  \t\tthis._container = create$1('div', 'leaflet-control-attribution');\r\n  \t\tdisableClickPropagation(this._container);\r\n\r\n  \t\t// TODO ugly, refactor\r\n  \t\tfor (var i in map._layers) {\r\n  \t\t\tif (map._layers[i].getAttribution) {\r\n  \t\t\t\tthis.addAttribution(map._layers[i].getAttribution());\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tthis._update();\r\n\r\n  \t\tmap.on('layeradd', this._addAttribution, this);\r\n\r\n  \t\treturn this._container;\r\n  \t},\r\n\r\n  \tonRemove: function (map) {\r\n  \t\tmap.off('layeradd', this._addAttribution, this);\r\n  \t},\r\n\r\n  \t_addAttribution: function (ev) {\r\n  \t\tif (ev.layer.getAttribution) {\r\n  \t\t\tthis.addAttribution(ev.layer.getAttribution());\r\n  \t\t\tev.layer.once('remove', function () {\r\n  \t\t\t\tthis.removeAttribution(ev.layer.getAttribution());\r\n  \t\t\t}, this);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method setPrefix(prefix: String|false): this\r\n  \t// The HTML text shown before the attributions. Pass `false` to disable.\r\n  \tsetPrefix: function (prefix) {\r\n  \t\tthis.options.prefix = prefix;\r\n  \t\tthis._update();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method addAttribution(text: String): this\r\n  \t// Adds an attribution text (e.g. `'&copy; OpenStreetMap contributors'`).\r\n  \taddAttribution: function (text) {\r\n  \t\tif (!text) { return this; }\r\n\r\n  \t\tif (!this._attributions[text]) {\r\n  \t\t\tthis._attributions[text] = 0;\r\n  \t\t}\r\n  \t\tthis._attributions[text]++;\r\n\r\n  \t\tthis._update();\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method removeAttribution(text: String): this\r\n  \t// Removes an attribution text.\r\n  \tremoveAttribution: function (text) {\r\n  \t\tif (!text) { return this; }\r\n\r\n  \t\tif (this._attributions[text]) {\r\n  \t\t\tthis._attributions[text]--;\r\n  \t\t\tthis._update();\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_update: function () {\r\n  \t\tif (!this._map) { return; }\r\n\r\n  \t\tvar attribs = [];\r\n\r\n  \t\tfor (var i in this._attributions) {\r\n  \t\t\tif (this._attributions[i]) {\r\n  \t\t\t\tattribs.push(i);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tvar prefixAndAttribs = [];\r\n\r\n  \t\tif (this.options.prefix) {\r\n  \t\t\tprefixAndAttribs.push(this.options.prefix);\r\n  \t\t}\r\n  \t\tif (attribs.length) {\r\n  \t\t\tprefixAndAttribs.push(attribs.join(', '));\r\n  \t\t}\r\n\r\n  \t\tthis._container.innerHTML = prefixAndAttribs.join(' <span aria-hidden=\"true\">|</span> ');\r\n  \t}\r\n  });\r\n\r\n  // @namespace Map\r\n  // @section Control options\r\n  // @option attributionControl: Boolean = true\r\n  // Whether a [attribution control](#control-attribution) is added to the map by default.\r\n  Map.mergeOptions({\r\n  \tattributionControl: true\r\n  });\r\n\r\n  Map.addInitHook(function () {\r\n  \tif (this.options.attributionControl) {\r\n  \t\tnew Attribution().addTo(this);\r\n  \t}\r\n  });\r\n\r\n  // @namespace Control.Attribution\r\n  // @factory L.control.attribution(options: Control.Attribution options)\r\n  // Creates an attribution control.\r\n  var attribution = function (options) {\r\n  \treturn new Attribution(options);\r\n  };\n\n  Control.Layers = Layers;\n  Control.Zoom = Zoom;\n  Control.Scale = Scale;\n  Control.Attribution = Attribution;\n\n  control.layers = layers;\n  control.zoom = zoom;\n  control.scale = scale;\n  control.attribution = attribution;\n\n  /*\n  \tL.Handler is a base class for handler classes that are used internally to inject\n  \tinteraction features like dragging to classes like Map and Marker.\n  */\n\n  // @class Handler\n  // @aka L.Handler\n  // Abstract class for map interaction handlers\n\n  var Handler = Class.extend({\n  \tinitialize: function (map) {\n  \t\tthis._map = map;\n  \t},\n\n  \t// @method enable(): this\n  \t// Enables the handler\n  \tenable: function () {\n  \t\tif (this._enabled) { return this; }\n\n  \t\tthis._enabled = true;\n  \t\tthis.addHooks();\n  \t\treturn this;\n  \t},\n\n  \t// @method disable(): this\n  \t// Disables the handler\n  \tdisable: function () {\n  \t\tif (!this._enabled) { return this; }\n\n  \t\tthis._enabled = false;\n  \t\tthis.removeHooks();\n  \t\treturn this;\n  \t},\n\n  \t// @method enabled(): Boolean\n  \t// Returns `true` if the handler is enabled\n  \tenabled: function () {\n  \t\treturn !!this._enabled;\n  \t}\n\n  \t// @section Extension methods\n  \t// Classes inheriting from `Handler` must implement the two following methods:\n  \t// @method addHooks()\n  \t// Called when the handler is enabled, should add event hooks.\n  \t// @method removeHooks()\n  \t// Called when the handler is disabled, should remove the event hooks added previously.\n  });\n\n  // @section There is static function which can be called without instantiating L.Handler:\n  // @function addTo(map: Map, name: String): this\n  // Adds a new Handler to the given map with the given name.\n  Handler.addTo = function (map, name) {\n  \tmap.addHandler(name, this);\n  \treturn this;\n  };\n\n  var Mixin = {Events: Events};\n\n  /*\r\n   * @class Draggable\r\n   * @aka L.Draggable\r\n   * @inherits Evented\r\n   *\r\n   * A class for making DOM elements draggable (including touch support).\r\n   * Used internally for map and marker dragging. Only works for elements\r\n   * that were positioned with [`L.DomUtil.setPosition`](#domutil-setposition).\r\n   *\r\n   * @example\r\n   * ```js\r\n   * var draggable = new L.Draggable(elementToDrag);\r\n   * draggable.enable();\r\n   * ```\r\n   */\r\n\r\n  var START = Browser.touch ? 'touchstart mousedown' : 'mousedown';\r\n\r\n  var Draggable = Evented.extend({\r\n\r\n  \toptions: {\r\n  \t\t// @section\r\n  \t\t// @aka Draggable options\r\n  \t\t// @option clickTolerance: Number = 3\r\n  \t\t// The max number of pixels a user can shift the mouse pointer during a click\r\n  \t\t// for it to be considered a valid click (as opposed to a mouse drag).\r\n  \t\tclickTolerance: 3\r\n  \t},\r\n\r\n  \t// @constructor L.Draggable(el: HTMLElement, dragHandle?: HTMLElement, preventOutline?: Boolean, options?: Draggable options)\r\n  \t// Creates a `Draggable` object for moving `el` when you start dragging the `dragHandle` element (equals `el` itself by default).\r\n  \tinitialize: function (element, dragStartTarget, preventOutline, options) {\r\n  \t\tsetOptions(this, options);\r\n\r\n  \t\tthis._element = element;\r\n  \t\tthis._dragStartTarget = dragStartTarget || element;\r\n  \t\tthis._preventOutline = preventOutline;\r\n  \t},\r\n\r\n  \t// @method enable()\r\n  \t// Enables the dragging ability\r\n  \tenable: function () {\r\n  \t\tif (this._enabled) { return; }\r\n\r\n  \t\ton(this._dragStartTarget, START, this._onDown, this);\r\n\r\n  \t\tthis._enabled = true;\r\n  \t},\r\n\r\n  \t// @method disable()\r\n  \t// Disables the dragging ability\r\n  \tdisable: function () {\r\n  \t\tif (!this._enabled) { return; }\r\n\r\n  \t\t// If we're currently dragging this draggable,\r\n  \t\t// disabling it counts as first ending the drag.\r\n  \t\tif (Draggable._dragging === this) {\r\n  \t\t\tthis.finishDrag(true);\r\n  \t\t}\r\n\r\n  \t\toff(this._dragStartTarget, START, this._onDown, this);\r\n\r\n  \t\tthis._enabled = false;\r\n  \t\tthis._moved = false;\r\n  \t},\r\n\r\n  \t_onDown: function (e) {\r\n  \t\t// Ignore the event if disabled; this happens in IE11\r\n  \t\t// under some circumstances, see #3666.\r\n  \t\tif (!this._enabled) { return; }\r\n\r\n  \t\tthis._moved = false;\r\n\r\n  \t\tif (hasClass(this._element, 'leaflet-zoom-anim')) { return; }\r\n\r\n  \t\tif (e.touches && e.touches.length !== 1) {\r\n  \t\t\t// Finish dragging to avoid conflict with touchZoom\r\n  \t\t\tif (Draggable._dragging === this) {\r\n  \t\t\t\tthis.finishDrag();\r\n  \t\t\t}\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tif (Draggable._dragging || e.shiftKey || ((e.which !== 1) && (e.button !== 1) && !e.touches)) { return; }\r\n  \t\tDraggable._dragging = this;  // Prevent dragging multiple objects at once.\r\n\r\n  \t\tif (this._preventOutline) {\r\n  \t\t\tpreventOutline(this._element);\r\n  \t\t}\r\n\r\n  \t\tdisableImageDrag();\r\n  \t\tdisableTextSelection();\r\n\r\n  \t\tif (this._moving) { return; }\r\n\r\n  \t\t// @event down: Event\r\n  \t\t// Fired when a drag is about to start.\r\n  \t\tthis.fire('down');\r\n\r\n  \t\tvar first = e.touches ? e.touches[0] : e,\r\n  \t\t    sizedParent = getSizedParentNode(this._element);\r\n\r\n  \t\tthis._startPoint = new Point(first.clientX, first.clientY);\r\n  \t\tthis._startPos = getPosition(this._element);\r\n\r\n  \t\t// Cache the scale, so that we can continuously compensate for it during drag (_onMove).\r\n  \t\tthis._parentScale = getScale(sizedParent);\r\n\r\n  \t\tvar mouseevent = e.type === 'mousedown';\r\n  \t\ton(document, mouseevent ? 'mousemove' : 'touchmove', this._onMove, this);\r\n  \t\ton(document, mouseevent ? 'mouseup' : 'touchend touchcancel', this._onUp, this);\r\n  \t},\r\n\r\n  \t_onMove: function (e) {\r\n  \t\t// Ignore the event if disabled; this happens in IE11\r\n  \t\t// under some circumstances, see #3666.\r\n  \t\tif (!this._enabled) { return; }\r\n\r\n  \t\tif (e.touches && e.touches.length > 1) {\r\n  \t\t\tthis._moved = true;\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tvar first = (e.touches && e.touches.length === 1 ? e.touches[0] : e),\r\n  \t\t    offset = new Point(first.clientX, first.clientY)._subtract(this._startPoint);\r\n\r\n  \t\tif (!offset.x && !offset.y) { return; }\r\n  \t\tif (Math.abs(offset.x) + Math.abs(offset.y) < this.options.clickTolerance) { return; }\r\n\r\n  \t\t// We assume that the parent container's position, border and scale do not change for the duration of the drag.\r\n  \t\t// Therefore there is no need to account for the position and border (they are eliminated by the subtraction)\r\n  \t\t// and we can use the cached value for the scale.\r\n  \t\toffset.x /= this._parentScale.x;\r\n  \t\toffset.y /= this._parentScale.y;\r\n\r\n  \t\tpreventDefault(e);\r\n\r\n  \t\tif (!this._moved) {\r\n  \t\t\t// @event dragstart: Event\r\n  \t\t\t// Fired when a drag starts\r\n  \t\t\tthis.fire('dragstart');\r\n\r\n  \t\t\tthis._moved = true;\r\n\r\n  \t\t\taddClass(document.body, 'leaflet-dragging');\r\n\r\n  \t\t\tthis._lastTarget = e.target || e.srcElement;\r\n  \t\t\t// IE and Edge do not give the <use> element, so fetch it\r\n  \t\t\t// if necessary\r\n  \t\t\tif (window.SVGElementInstance && this._lastTarget instanceof window.SVGElementInstance) {\r\n  \t\t\t\tthis._lastTarget = this._lastTarget.correspondingUseElement;\r\n  \t\t\t}\r\n  \t\t\taddClass(this._lastTarget, 'leaflet-drag-target');\r\n  \t\t}\r\n\r\n  \t\tthis._newPos = this._startPos.add(offset);\r\n  \t\tthis._moving = true;\r\n\r\n  \t\tthis._lastEvent = e;\r\n  \t\tthis._updatePosition();\r\n  \t},\r\n\r\n  \t_updatePosition: function () {\r\n  \t\tvar e = {originalEvent: this._lastEvent};\r\n\r\n  \t\t// @event predrag: Event\r\n  \t\t// Fired continuously during dragging *before* each corresponding\r\n  \t\t// update of the element's position.\r\n  \t\tthis.fire('predrag', e);\r\n  \t\tsetPosition(this._element, this._newPos);\r\n\r\n  \t\t// @event drag: Event\r\n  \t\t// Fired continuously during dragging.\r\n  \t\tthis.fire('drag', e);\r\n  \t},\r\n\r\n  \t_onUp: function () {\r\n  \t\t// Ignore the event if disabled; this happens in IE11\r\n  \t\t// under some circumstances, see #3666.\r\n  \t\tif (!this._enabled) { return; }\r\n  \t\tthis.finishDrag();\r\n  \t},\r\n\r\n  \tfinishDrag: function (noInertia) {\r\n  \t\tremoveClass(document.body, 'leaflet-dragging');\r\n\r\n  \t\tif (this._lastTarget) {\r\n  \t\t\tremoveClass(this._lastTarget, 'leaflet-drag-target');\r\n  \t\t\tthis._lastTarget = null;\r\n  \t\t}\r\n\r\n  \t\toff(document, 'mousemove touchmove', this._onMove, this);\r\n  \t\toff(document, 'mouseup touchend touchcancel', this._onUp, this);\r\n\r\n  \t\tenableImageDrag();\r\n  \t\tenableTextSelection();\r\n\r\n  \t\tif (this._moved && this._moving) {\r\n\r\n  \t\t\t// @event dragend: DragEndEvent\r\n  \t\t\t// Fired when the drag ends.\r\n  \t\t\tthis.fire('dragend', {\r\n  \t\t\t\tnoInertia: noInertia,\r\n  \t\t\t\tdistance: this._newPos.distanceTo(this._startPos)\r\n  \t\t\t});\r\n  \t\t}\r\n\r\n  \t\tthis._moving = false;\r\n  \t\tDraggable._dragging = false;\r\n  \t}\r\n\r\n  });\n\n  /*\r\n   * @namespace LineUtil\r\n   *\r\n   * Various utility functions for polyline points processing, used by Leaflet internally to make polylines lightning-fast.\r\n   */\r\n\r\n  // Simplify polyline with vertex reduction and Douglas-Peucker simplification.\r\n  // Improves rendering performance dramatically by lessening the number of points to draw.\r\n\r\n  // @function simplify(points: Point[], tolerance: Number): Point[]\r\n  // Dramatically reduces the number of points in a polyline while retaining\r\n  // its shape and returns a new array of simplified points, using the\r\n  // [Ramer-Douglas-Peucker algorithm](https://en.wikipedia.org/wiki/Ramer-Douglas-Peucker_algorithm).\r\n  // Used for a huge performance boost when processing/displaying Leaflet polylines for\r\n  // each zoom level and also reducing visual noise. tolerance affects the amount of\r\n  // simplification (lesser value means higher quality but slower and with more points).\r\n  // Also released as a separated micro-library [Simplify.js](https://mourner.github.io/simplify-js/).\r\n  function simplify(points, tolerance) {\r\n  \tif (!tolerance || !points.length) {\r\n  \t\treturn points.slice();\r\n  \t}\r\n\r\n  \tvar sqTolerance = tolerance * tolerance;\r\n\r\n  \t    // stage 1: vertex reduction\r\n  \t    points = _reducePoints(points, sqTolerance);\r\n\r\n  \t    // stage 2: Douglas-Peucker simplification\r\n  \t    points = _simplifyDP(points, sqTolerance);\r\n\r\n  \treturn points;\r\n  }\r\n\r\n  // @function pointToSegmentDistance(p: Point, p1: Point, p2: Point): Number\r\n  // Returns the distance between point `p` and segment `p1` to `p2`.\r\n  function pointToSegmentDistance(p, p1, p2) {\r\n  \treturn Math.sqrt(_sqClosestPointOnSegment(p, p1, p2, true));\r\n  }\r\n\r\n  // @function closestPointOnSegment(p: Point, p1: Point, p2: Point): Number\r\n  // Returns the closest point from a point `p` on a segment `p1` to `p2`.\r\n  function closestPointOnSegment(p, p1, p2) {\r\n  \treturn _sqClosestPointOnSegment(p, p1, p2);\r\n  }\r\n\r\n  // Ramer-Douglas-Peucker simplification, see https://en.wikipedia.org/wiki/Ramer-Douglas-Peucker_algorithm\r\n  function _simplifyDP(points, sqTolerance) {\r\n\r\n  \tvar len = points.length,\r\n  \t    ArrayConstructor = typeof Uint8Array !== undefined + '' ? Uint8Array : Array,\r\n  \t    markers = new ArrayConstructor(len);\r\n\r\n  \t    markers[0] = markers[len - 1] = 1;\r\n\r\n  \t_simplifyDPStep(points, markers, sqTolerance, 0, len - 1);\r\n\r\n  \tvar i,\r\n  \t    newPoints = [];\r\n\r\n  \tfor (i = 0; i < len; i++) {\r\n  \t\tif (markers[i]) {\r\n  \t\t\tnewPoints.push(points[i]);\r\n  \t\t}\r\n  \t}\r\n\r\n  \treturn newPoints;\r\n  }\r\n\r\n  function _simplifyDPStep(points, markers, sqTolerance, first, last) {\r\n\r\n  \tvar maxSqDist = 0,\r\n  \tindex, i, sqDist;\r\n\r\n  \tfor (i = first + 1; i <= last - 1; i++) {\r\n  \t\tsqDist = _sqClosestPointOnSegment(points[i], points[first], points[last], true);\r\n\r\n  \t\tif (sqDist > maxSqDist) {\r\n  \t\t\tindex = i;\r\n  \t\t\tmaxSqDist = sqDist;\r\n  \t\t}\r\n  \t}\r\n\r\n  \tif (maxSqDist > sqTolerance) {\r\n  \t\tmarkers[index] = 1;\r\n\r\n  \t\t_simplifyDPStep(points, markers, sqTolerance, first, index);\r\n  \t\t_simplifyDPStep(points, markers, sqTolerance, index, last);\r\n  \t}\r\n  }\r\n\r\n  // reduce points that are too close to each other to a single point\r\n  function _reducePoints(points, sqTolerance) {\r\n  \tvar reducedPoints = [points[0]];\r\n\r\n  \tfor (var i = 1, prev = 0, len = points.length; i < len; i++) {\r\n  \t\tif (_sqDist(points[i], points[prev]) > sqTolerance) {\r\n  \t\t\treducedPoints.push(points[i]);\r\n  \t\t\tprev = i;\r\n  \t\t}\r\n  \t}\r\n  \tif (prev < len - 1) {\r\n  \t\treducedPoints.push(points[len - 1]);\r\n  \t}\r\n  \treturn reducedPoints;\r\n  }\r\n\r\n  var _lastCode;\r\n\r\n  // @function clipSegment(a: Point, b: Point, bounds: Bounds, useLastCode?: Boolean, round?: Boolean): Point[]|Boolean\r\n  // Clips the segment a to b by rectangular bounds with the\r\n  // [Cohen-Sutherland algorithm](https://en.wikipedia.org/wiki/Cohen%E2%80%93Sutherland_algorithm)\r\n  // (modifying the segment points directly!). Used by Leaflet to only show polyline\r\n  // points that are on the screen or near, increasing performance.\r\n  function clipSegment(a, b, bounds, useLastCode, round) {\r\n  \tvar codeA = useLastCode ? _lastCode : _getBitCode(a, bounds),\r\n  \t    codeB = _getBitCode(b, bounds),\r\n\r\n  \t    codeOut, p, newCode;\r\n\r\n  \t    // save 2nd code to avoid calculating it on the next segment\r\n  \t    _lastCode = codeB;\r\n\r\n  \twhile (true) {\r\n  \t\t// if a,b is inside the clip window (trivial accept)\r\n  \t\tif (!(codeA | codeB)) {\r\n  \t\t\treturn [a, b];\r\n  \t\t}\r\n\r\n  \t\t// if a,b is outside the clip window (trivial reject)\r\n  \t\tif (codeA & codeB) {\r\n  \t\t\treturn false;\r\n  \t\t}\r\n\r\n  \t\t// other cases\r\n  \t\tcodeOut = codeA || codeB;\r\n  \t\tp = _getEdgeIntersection(a, b, codeOut, bounds, round);\r\n  \t\tnewCode = _getBitCode(p, bounds);\r\n\r\n  \t\tif (codeOut === codeA) {\r\n  \t\t\ta = p;\r\n  \t\t\tcodeA = newCode;\r\n  \t\t} else {\r\n  \t\t\tb = p;\r\n  \t\t\tcodeB = newCode;\r\n  \t\t}\r\n  \t}\r\n  }\r\n\r\n  function _getEdgeIntersection(a, b, code, bounds, round) {\r\n  \tvar dx = b.x - a.x,\r\n  \t    dy = b.y - a.y,\r\n  \t    min = bounds.min,\r\n  \t    max = bounds.max,\r\n  \t    x, y;\r\n\r\n  \tif (code & 8) { // top\r\n  \t\tx = a.x + dx * (max.y - a.y) / dy;\r\n  \t\ty = max.y;\r\n\r\n  \t} else if (code & 4) { // bottom\r\n  \t\tx = a.x + dx * (min.y - a.y) / dy;\r\n  \t\ty = min.y;\r\n\r\n  \t} else if (code & 2) { // right\r\n  \t\tx = max.x;\r\n  \t\ty = a.y + dy * (max.x - a.x) / dx;\r\n\r\n  \t} else if (code & 1) { // left\r\n  \t\tx = min.x;\r\n  \t\ty = a.y + dy * (min.x - a.x) / dx;\r\n  \t}\r\n\r\n  \treturn new Point(x, y, round);\r\n  }\r\n\r\n  function _getBitCode(p, bounds) {\r\n  \tvar code = 0;\r\n\r\n  \tif (p.x < bounds.min.x) { // left\r\n  \t\tcode |= 1;\r\n  \t} else if (p.x > bounds.max.x) { // right\r\n  \t\tcode |= 2;\r\n  \t}\r\n\r\n  \tif (p.y < bounds.min.y) { // bottom\r\n  \t\tcode |= 4;\r\n  \t} else if (p.y > bounds.max.y) { // top\r\n  \t\tcode |= 8;\r\n  \t}\r\n\r\n  \treturn code;\r\n  }\r\n\r\n  // square distance (to avoid unnecessary Math.sqrt calls)\r\n  function _sqDist(p1, p2) {\r\n  \tvar dx = p2.x - p1.x,\r\n  \t    dy = p2.y - p1.y;\r\n  \treturn dx * dx + dy * dy;\r\n  }\r\n\r\n  // return closest point on segment or distance to that point\r\n  function _sqClosestPointOnSegment(p, p1, p2, sqDist) {\r\n  \tvar x = p1.x,\r\n  \t    y = p1.y,\r\n  \t    dx = p2.x - x,\r\n  \t    dy = p2.y - y,\r\n  \t    dot = dx * dx + dy * dy,\r\n  \t    t;\r\n\r\n  \tif (dot > 0) {\r\n  \t\tt = ((p.x - x) * dx + (p.y - y) * dy) / dot;\r\n\r\n  \t\tif (t > 1) {\r\n  \t\t\tx = p2.x;\r\n  \t\t\ty = p2.y;\r\n  \t\t} else if (t > 0) {\r\n  \t\t\tx += dx * t;\r\n  \t\t\ty += dy * t;\r\n  \t\t}\r\n  \t}\r\n\r\n  \tdx = p.x - x;\r\n  \tdy = p.y - y;\r\n\r\n  \treturn sqDist ? dx * dx + dy * dy : new Point(x, y);\r\n  }\r\n\r\n\r\n  // @function isFlat(latlngs: LatLng[]): Boolean\r\n  // Returns true if `latlngs` is a flat array, false is nested.\r\n  function isFlat(latlngs) {\r\n  \treturn !isArray(latlngs[0]) || (typeof latlngs[0][0] !== 'object' && typeof latlngs[0][0] !== 'undefined');\r\n  }\r\n\r\n  function _flat(latlngs) {\r\n  \tconsole.warn('Deprecated use of _flat, please use L.LineUtil.isFlat instead.');\r\n  \treturn isFlat(latlngs);\r\n  }\r\n\r\n  /* @function polylineCenter(latlngs: LatLng[], crs: CRS): LatLng\r\n   * Returns the center ([centroid](http://en.wikipedia.org/wiki/Centroid)) of the passed LatLngs (first ring) from a polyline.\r\n   */\r\n  function polylineCenter(latlngs, crs) {\r\n  \tvar i, halfDist, segDist, dist, p1, p2, ratio, center;\r\n\r\n  \tif (!latlngs || latlngs.length === 0) {\r\n  \t\tthrow new Error('latlngs not passed');\r\n  \t}\r\n\r\n  \tif (!isFlat(latlngs)) {\r\n  \t\tconsole.warn('latlngs are not flat! Only the first ring will be used');\r\n  \t\tlatlngs = latlngs[0];\r\n  \t}\r\n\r\n  \tvar points = [];\r\n  \tfor (var j in latlngs) {\r\n  \t\tpoints.push(crs.project(toLatLng(latlngs[j])));\r\n  \t}\r\n\r\n  \tvar len = points.length;\r\n\r\n  \tfor (i = 0, halfDist = 0; i < len - 1; i++) {\r\n  \t\thalfDist += points[i].distanceTo(points[i + 1]) / 2;\r\n  \t}\r\n\r\n  \t// The line is so small in the current view that all points are on the same pixel.\r\n  \tif (halfDist === 0) {\r\n  \t\tcenter = points[0];\r\n  \t} else {\r\n  \t\tfor (i = 0, dist = 0; i < len - 1; i++) {\r\n  \t\t\tp1 = points[i];\r\n  \t\t\tp2 = points[i + 1];\r\n  \t\t\tsegDist = p1.distanceTo(p2);\r\n  \t\t\tdist += segDist;\r\n\r\n  \t\t\tif (dist > halfDist) {\r\n  \t\t\t\tratio = (dist - halfDist) / segDist;\r\n  \t\t\t\tcenter = [\r\n  \t\t\t\t\tp2.x - ratio * (p2.x - p1.x),\r\n  \t\t\t\t\tp2.y - ratio * (p2.y - p1.y)\r\n  \t\t\t\t];\r\n  \t\t\t\tbreak;\r\n  \t\t\t}\r\n  \t\t}\r\n  \t}\r\n  \treturn crs.unproject(toPoint(center));\r\n  }\n\n  var LineUtil = {\n    __proto__: null,\n    simplify: simplify,\n    pointToSegmentDistance: pointToSegmentDistance,\n    closestPointOnSegment: closestPointOnSegment,\n    clipSegment: clipSegment,\n    _getEdgeIntersection: _getEdgeIntersection,\n    _getBitCode: _getBitCode,\n    _sqClosestPointOnSegment: _sqClosestPointOnSegment,\n    isFlat: isFlat,\n    _flat: _flat,\n    polylineCenter: polylineCenter\n  };\n\n  /*\r\n   * @namespace PolyUtil\r\n   * Various utility functions for polygon geometries.\r\n   */\r\n\r\n  /* @function clipPolygon(points: Point[], bounds: Bounds, round?: Boolean): Point[]\r\n   * Clips the polygon geometry defined by the given `points` by the given bounds (using the [Sutherland-Hodgman algorithm](https://en.wikipedia.org/wiki/Sutherland%E2%80%93Hodgman_algorithm)).\r\n   * Used by Leaflet to only show polygon points that are on the screen or near, increasing\r\n   * performance. Note that polygon points needs different algorithm for clipping\r\n   * than polyline, so there's a separate method for it.\r\n   */\r\n  function clipPolygon(points, bounds, round) {\r\n  \tvar clippedPoints,\r\n  \t    edges = [1, 4, 2, 8],\r\n  \t    i, j, k,\r\n  \t    a, b,\r\n  \t    len, edge, p;\r\n\r\n  \tfor (i = 0, len = points.length; i < len; i++) {\r\n  \t\tpoints[i]._code = _getBitCode(points[i], bounds);\r\n  \t}\r\n\r\n  \t// for each edge (left, bottom, right, top)\r\n  \tfor (k = 0; k < 4; k++) {\r\n  \t\tedge = edges[k];\r\n  \t\tclippedPoints = [];\r\n\r\n  \t\tfor (i = 0, len = points.length, j = len - 1; i < len; j = i++) {\r\n  \t\t\ta = points[i];\r\n  \t\t\tb = points[j];\r\n\r\n  \t\t\t// if a is inside the clip window\r\n  \t\t\tif (!(a._code & edge)) {\r\n  \t\t\t\t// if b is outside the clip window (a->b goes out of screen)\r\n  \t\t\t\tif (b._code & edge) {\r\n  \t\t\t\t\tp = _getEdgeIntersection(b, a, edge, bounds, round);\r\n  \t\t\t\t\tp._code = _getBitCode(p, bounds);\r\n  \t\t\t\t\tclippedPoints.push(p);\r\n  \t\t\t\t}\r\n  \t\t\t\tclippedPoints.push(a);\r\n\r\n  \t\t\t// else if b is inside the clip window (a->b enters the screen)\r\n  \t\t\t} else if (!(b._code & edge)) {\r\n  \t\t\t\tp = _getEdgeIntersection(b, a, edge, bounds, round);\r\n  \t\t\t\tp._code = _getBitCode(p, bounds);\r\n  \t\t\t\tclippedPoints.push(p);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\tpoints = clippedPoints;\r\n  \t}\r\n\r\n  \treturn points;\r\n  }\r\n\r\n  /* @function polygonCenter(latlngs: LatLng[] crs: CRS): LatLng\r\n   * Returns the center ([centroid](http://en.wikipedia.org/wiki/Centroid)) of the passed LatLngs (first ring) from a polygon.\r\n   */\r\n  function polygonCenter(latlngs, crs) {\r\n  \tvar i, j, p1, p2, f, area, x, y, center;\r\n\r\n  \tif (!latlngs || latlngs.length === 0) {\r\n  \t\tthrow new Error('latlngs not passed');\r\n  \t}\r\n\r\n  \tif (!isFlat(latlngs)) {\r\n  \t\tconsole.warn('latlngs are not flat! Only the first ring will be used');\r\n  \t\tlatlngs = latlngs[0];\r\n  \t}\r\n\r\n  \tvar points = [];\r\n  \tfor (var k in latlngs) {\r\n  \t\tpoints.push(crs.project(toLatLng(latlngs[k])));\r\n  \t}\r\n\r\n  \tvar len = points.length;\r\n  \tarea = x = y = 0;\r\n\r\n  \t// polygon centroid algorithm;\r\n  \tfor (i = 0, j = len - 1; i < len; j = i++) {\r\n  \t\tp1 = points[i];\r\n  \t\tp2 = points[j];\r\n\r\n  \t\tf = p1.y * p2.x - p2.y * p1.x;\r\n  \t\tx += (p1.x + p2.x) * f;\r\n  \t\ty += (p1.y + p2.y) * f;\r\n  \t\tarea += f * 3;\r\n  \t}\r\n\r\n  \tif (area === 0) {\r\n  \t\t// Polygon is so small that all points are on same pixel.\r\n  \t\tcenter = points[0];\r\n  \t} else {\r\n  \t\tcenter = [x / area, y / area];\r\n  \t}\r\n  \treturn crs.unproject(toPoint(center));\r\n  }\n\n  var PolyUtil = {\n    __proto__: null,\n    clipPolygon: clipPolygon,\n    polygonCenter: polygonCenter\n  };\n\n  /*\r\n   * @namespace Projection\r\n   * @section\r\n   * Leaflet comes with a set of already defined Projections out of the box:\r\n   *\r\n   * @projection L.Projection.LonLat\r\n   *\r\n   * Equirectangular, or Plate Carree projection — the most simple projection,\r\n   * mostly used by GIS enthusiasts. Directly maps `x` as longitude, and `y` as\r\n   * latitude. Also suitable for flat worlds, e.g. game maps. Used by the\r\n   * `EPSG:4326` and `Simple` CRS.\r\n   */\r\n\r\n  var LonLat = {\r\n  \tproject: function (latlng) {\r\n  \t\treturn new Point(latlng.lng, latlng.lat);\r\n  \t},\r\n\r\n  \tunproject: function (point) {\r\n  \t\treturn new LatLng(point.y, point.x);\r\n  \t},\r\n\r\n  \tbounds: new Bounds([-180, -90], [180, 90])\r\n  };\n\n  /*\r\n   * @namespace Projection\r\n   * @projection L.Projection.Mercator\r\n   *\r\n   * Elliptical Mercator projection — more complex than Spherical Mercator. Assumes that Earth is an ellipsoid. Used by the EPSG:3395 CRS.\r\n   */\r\n\r\n  var Mercator = {\r\n  \tR: 6378137,\r\n  \tR_MINOR: 6356752.314245179,\r\n\r\n  \tbounds: new Bounds([-20037508.34279, -15496570.73972], [20037508.34279, 18764656.23138]),\r\n\r\n  \tproject: function (latlng) {\r\n  \t\tvar d = Math.PI / 180,\r\n  \t\t    r = this.R,\r\n  \t\t    y = latlng.lat * d,\r\n  \t\t    tmp = this.R_MINOR / r,\r\n  \t\t    e = Math.sqrt(1 - tmp * tmp),\r\n  \t\t    con = e * Math.sin(y);\r\n\r\n  \t\tvar ts = Math.tan(Math.PI / 4 - y / 2) / Math.pow((1 - con) / (1 + con), e / 2);\r\n  \t\ty = -r * Math.log(Math.max(ts, 1E-10));\r\n\r\n  \t\treturn new Point(latlng.lng * d * r, y);\r\n  \t},\r\n\r\n  \tunproject: function (point) {\r\n  \t\tvar d = 180 / Math.PI,\r\n  \t\t    r = this.R,\r\n  \t\t    tmp = this.R_MINOR / r,\r\n  \t\t    e = Math.sqrt(1 - tmp * tmp),\r\n  \t\t    ts = Math.exp(-point.y / r),\r\n  \t\t    phi = Math.PI / 2 - 2 * Math.atan(ts);\r\n\r\n  \t\tfor (var i = 0, dphi = 0.1, con; i < 15 && Math.abs(dphi) > 1e-7; i++) {\r\n  \t\t\tcon = e * Math.sin(phi);\r\n  \t\t\tcon = Math.pow((1 - con) / (1 + con), e / 2);\r\n  \t\t\tdphi = Math.PI / 2 - 2 * Math.atan(ts * con) - phi;\r\n  \t\t\tphi += dphi;\r\n  \t\t}\r\n\r\n  \t\treturn new LatLng(phi * d, point.x * d / r);\r\n  \t}\r\n  };\n\n  /*\n   * @class Projection\n\n   * An object with methods for projecting geographical coordinates of the world onto\n   * a flat surface (and back). See [Map projection](https://en.wikipedia.org/wiki/Map_projection).\n\n   * @property bounds: Bounds\n   * The bounds (specified in CRS units) where the projection is valid\n\n   * @method project(latlng: LatLng): Point\n   * Projects geographical coordinates into a 2D point.\n   * Only accepts actual `L.LatLng` instances, not arrays.\n\n   * @method unproject(point: Point): LatLng\n   * The inverse of `project`. Projects a 2D point into a geographical location.\n   * Only accepts actual `L.Point` instances, not arrays.\n\n   * Note that the projection instances do not inherit from Leaflet's `Class` object,\n   * and can't be instantiated. Also, new classes can't inherit from them,\n   * and methods can't be added to them with the `include` function.\n\n   */\n\n  var index = {\n    __proto__: null,\n    LonLat: LonLat,\n    Mercator: Mercator,\n    SphericalMercator: SphericalMercator\n  };\n\n  /*\r\n   * @namespace CRS\r\n   * @crs L.CRS.EPSG3395\r\n   *\r\n   * Rarely used by some commercial tile providers. Uses Elliptical Mercator projection.\r\n   */\r\n  var EPSG3395 = extend({}, Earth, {\r\n  \tcode: 'EPSG:3395',\r\n  \tprojection: Mercator,\r\n\r\n  \ttransformation: (function () {\r\n  \t\tvar scale = 0.5 / (Math.PI * Mercator.R);\r\n  \t\treturn toTransformation(scale, 0.5, -scale, 0.5);\r\n  \t}())\r\n  });\n\n  /*\r\n   * @namespace CRS\r\n   * @crs L.CRS.EPSG4326\r\n   *\r\n   * A common CRS among GIS enthusiasts. Uses simple Equirectangular projection.\r\n   *\r\n   * Leaflet 1.0.x complies with the [TMS coordinate scheme for EPSG:4326](https://wiki.osgeo.org/wiki/Tile_Map_Service_Specification#global-geodetic),\r\n   * which is a breaking change from 0.7.x behaviour.  If you are using a `TileLayer`\r\n   * with this CRS, ensure that there are two 256x256 pixel tiles covering the\r\n   * whole earth at zoom level zero, and that the tile coordinate origin is (-180,+90),\r\n   * or (-180,-90) for `TileLayer`s with [the `tms` option](#tilelayer-tms) set.\r\n   */\r\n\r\n  var EPSG4326 = extend({}, Earth, {\r\n  \tcode: 'EPSG:4326',\r\n  \tprojection: LonLat,\r\n  \ttransformation: toTransformation(1 / 180, 1, -1 / 180, 0.5)\r\n  });\n\n  /*\n   * @namespace CRS\n   * @crs L.CRS.Simple\n   *\n   * A simple CRS that maps longitude and latitude into `x` and `y` directly.\n   * May be used for maps of flat surfaces (e.g. game maps). Note that the `y`\n   * axis should still be inverted (going from bottom to top). `distance()` returns\n   * simple euclidean distance.\n   */\n\n  var Simple = extend({}, CRS, {\n  \tprojection: LonLat,\n  \ttransformation: toTransformation(1, 0, -1, 0),\n\n  \tscale: function (zoom) {\n  \t\treturn Math.pow(2, zoom);\n  \t},\n\n  \tzoom: function (scale) {\n  \t\treturn Math.log(scale) / Math.LN2;\n  \t},\n\n  \tdistance: function (latlng1, latlng2) {\n  \t\tvar dx = latlng2.lng - latlng1.lng,\n  \t\t    dy = latlng2.lat - latlng1.lat;\n\n  \t\treturn Math.sqrt(dx * dx + dy * dy);\n  \t},\n\n  \tinfinite: true\n  });\n\n  CRS.Earth = Earth;\n  CRS.EPSG3395 = EPSG3395;\n  CRS.EPSG3857 = EPSG3857;\n  CRS.EPSG900913 = EPSG900913;\n  CRS.EPSG4326 = EPSG4326;\n  CRS.Simple = Simple;\n\n  /*\n   * @class Layer\n   * @inherits Evented\n   * @aka L.Layer\n   * @aka ILayer\n   *\n   * A set of methods from the Layer base class that all Leaflet layers use.\n   * Inherits all methods, options and events from `L.Evented`.\n   *\n   * @example\n   *\n   * ```js\n   * var layer = L.marker(latlng).addTo(map);\n   * layer.addTo(map);\n   * layer.remove();\n   * ```\n   *\n   * @event add: Event\n   * Fired after the layer is added to a map\n   *\n   * @event remove: Event\n   * Fired after the layer is removed from a map\n   */\n\n\n  var Layer = Evented.extend({\n\n  \t// Classes extending `L.Layer` will inherit the following options:\n  \toptions: {\n  \t\t// @option pane: String = 'overlayPane'\n  \t\t// By default the layer will be added to the map's [overlay pane](#map-overlaypane). Overriding this option will cause the layer to be placed on another pane by default.\n  \t\tpane: 'overlayPane',\n\n  \t\t// @option attribution: String = null\n  \t\t// String to be shown in the attribution control, e.g. \"© OpenStreetMap contributors\". It describes the layer data and is often a legal obligation towards copyright holders and tile providers.\n  \t\tattribution: null,\n\n  \t\tbubblingMouseEvents: true\n  \t},\n\n  \t/* @section\n  \t * Classes extending `L.Layer` will inherit the following methods:\n  \t *\n  \t * @method addTo(map: Map|LayerGroup): this\n  \t * Adds the layer to the given map or layer group.\n  \t */\n  \taddTo: function (map) {\n  \t\tmap.addLayer(this);\n  \t\treturn this;\n  \t},\n\n  \t// @method remove: this\n  \t// Removes the layer from the map it is currently active on.\n  \tremove: function () {\n  \t\treturn this.removeFrom(this._map || this._mapToAdd);\n  \t},\n\n  \t// @method removeFrom(map: Map): this\n  \t// Removes the layer from the given map\n  \t//\n  \t// @alternative\n  \t// @method removeFrom(group: LayerGroup): this\n  \t// Removes the layer from the given `LayerGroup`\n  \tremoveFrom: function (obj) {\n  \t\tif (obj) {\n  \t\t\tobj.removeLayer(this);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method getPane(name? : String): HTMLElement\n  \t// Returns the `HTMLElement` representing the named pane on the map. If `name` is omitted, returns the pane for this layer.\n  \tgetPane: function (name) {\n  \t\treturn this._map.getPane(name ? (this.options[name] || name) : this.options.pane);\n  \t},\n\n  \taddInteractiveTarget: function (targetEl) {\n  \t\tthis._map._targets[stamp(targetEl)] = this;\n  \t\treturn this;\n  \t},\n\n  \tremoveInteractiveTarget: function (targetEl) {\n  \t\tdelete this._map._targets[stamp(targetEl)];\n  \t\treturn this;\n  \t},\n\n  \t// @method getAttribution: String\n  \t// Used by the `attribution control`, returns the [attribution option](#gridlayer-attribution).\n  \tgetAttribution: function () {\n  \t\treturn this.options.attribution;\n  \t},\n\n  \t_layerAdd: function (e) {\n  \t\tvar map = e.target;\n\n  \t\t// check in case layer gets added and then removed before the map is ready\n  \t\tif (!map.hasLayer(this)) { return; }\n\n  \t\tthis._map = map;\n  \t\tthis._zoomAnimated = map._zoomAnimated;\n\n  \t\tif (this.getEvents) {\n  \t\t\tvar events = this.getEvents();\n  \t\t\tmap.on(events, this);\n  \t\t\tthis.once('remove', function () {\n  \t\t\t\tmap.off(events, this);\n  \t\t\t}, this);\n  \t\t}\n\n  \t\tthis.onAdd(map);\n\n  \t\tthis.fire('add');\n  \t\tmap.fire('layeradd', {layer: this});\n  \t}\n  });\n\n  /* @section Extension methods\n   * @uninheritable\n   *\n   * Every layer should extend from `L.Layer` and (re-)implement the following methods.\n   *\n   * @method onAdd(map: Map): this\n   * Should contain code that creates DOM elements for the layer, adds them to `map panes` where they should belong and puts listeners on relevant map events. Called on [`map.addLayer(layer)`](#map-addlayer).\n   *\n   * @method onRemove(map: Map): this\n   * Should contain all clean up code that removes the layer's elements from the DOM and removes listeners previously added in [`onAdd`](#layer-onadd). Called on [`map.removeLayer(layer)`](#map-removelayer).\n   *\n   * @method getEvents(): Object\n   * This optional method should return an object like `{ viewreset: this._reset }` for [`addEventListener`](#evented-addeventlistener). The event handlers in this object will be automatically added and removed from the map with your layer.\n   *\n   * @method getAttribution(): String\n   * This optional method should return a string containing HTML to be shown on the `Attribution control` whenever the layer is visible.\n   *\n   * @method beforeAdd(map: Map): this\n   * Optional method. Called on [`map.addLayer(layer)`](#map-addlayer), before the layer is added to the map, before events are initialized, without waiting until the map is in a usable state. Use for early initialization only.\n   */\n\n\n  /* @namespace Map\n   * @section Layer events\n   *\n   * @event layeradd: LayerEvent\n   * Fired when a new layer is added to the map.\n   *\n   * @event layerremove: LayerEvent\n   * Fired when some layer is removed from the map\n   *\n   * @section Methods for Layers and Controls\n   */\n  Map.include({\n  \t// @method addLayer(layer: Layer): this\n  \t// Adds the given layer to the map\n  \taddLayer: function (layer) {\n  \t\tif (!layer._layerAdd) {\n  \t\t\tthrow new Error('The provided object is not a Layer.');\n  \t\t}\n\n  \t\tvar id = stamp(layer);\n  \t\tif (this._layers[id]) { return this; }\n  \t\tthis._layers[id] = layer;\n\n  \t\tlayer._mapToAdd = this;\n\n  \t\tif (layer.beforeAdd) {\n  \t\t\tlayer.beforeAdd(this);\n  \t\t}\n\n  \t\tthis.whenReady(layer._layerAdd, layer);\n\n  \t\treturn this;\n  \t},\n\n  \t// @method removeLayer(layer: Layer): this\n  \t// Removes the given layer from the map.\n  \tremoveLayer: function (layer) {\n  \t\tvar id = stamp(layer);\n\n  \t\tif (!this._layers[id]) { return this; }\n\n  \t\tif (this._loaded) {\n  \t\t\tlayer.onRemove(this);\n  \t\t}\n\n  \t\tdelete this._layers[id];\n\n  \t\tif (this._loaded) {\n  \t\t\tthis.fire('layerremove', {layer: layer});\n  \t\t\tlayer.fire('remove');\n  \t\t}\n\n  \t\tlayer._map = layer._mapToAdd = null;\n\n  \t\treturn this;\n  \t},\n\n  \t// @method hasLayer(layer: Layer): Boolean\n  \t// Returns `true` if the given layer is currently added to the map\n  \thasLayer: function (layer) {\n  \t\treturn stamp(layer) in this._layers;\n  \t},\n\n  \t/* @method eachLayer(fn: Function, context?: Object): this\n  \t * Iterates over the layers of the map, optionally specifying context of the iterator function.\n  \t * ```\n  \t * map.eachLayer(function(layer){\n  \t *     layer.bindPopup('Hello');\n  \t * });\n  \t * ```\n  \t */\n  \teachLayer: function (method, context) {\n  \t\tfor (var i in this._layers) {\n  \t\t\tmethod.call(context, this._layers[i]);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t_addLayers: function (layers) {\n  \t\tlayers = layers ? (isArray(layers) ? layers : [layers]) : [];\n\n  \t\tfor (var i = 0, len = layers.length; i < len; i++) {\n  \t\t\tthis.addLayer(layers[i]);\n  \t\t}\n  \t},\n\n  \t_addZoomLimit: function (layer) {\n  \t\tif (!isNaN(layer.options.maxZoom) || !isNaN(layer.options.minZoom)) {\n  \t\t\tthis._zoomBoundLayers[stamp(layer)] = layer;\n  \t\t\tthis._updateZoomLevels();\n  \t\t}\n  \t},\n\n  \t_removeZoomLimit: function (layer) {\n  \t\tvar id = stamp(layer);\n\n  \t\tif (this._zoomBoundLayers[id]) {\n  \t\t\tdelete this._zoomBoundLayers[id];\n  \t\t\tthis._updateZoomLevels();\n  \t\t}\n  \t},\n\n  \t_updateZoomLevels: function () {\n  \t\tvar minZoom = Infinity,\n  \t\t    maxZoom = -Infinity,\n  \t\t    oldZoomSpan = this._getZoomSpan();\n\n  \t\tfor (var i in this._zoomBoundLayers) {\n  \t\t\tvar options = this._zoomBoundLayers[i].options;\n\n  \t\t\tminZoom = options.minZoom === undefined ? minZoom : Math.min(minZoom, options.minZoom);\n  \t\t\tmaxZoom = options.maxZoom === undefined ? maxZoom : Math.max(maxZoom, options.maxZoom);\n  \t\t}\n\n  \t\tthis._layersMaxZoom = maxZoom === -Infinity ? undefined : maxZoom;\n  \t\tthis._layersMinZoom = minZoom === Infinity ? undefined : minZoom;\n\n  \t\t// @section Map state change events\n  \t\t// @event zoomlevelschange: Event\n  \t\t// Fired when the number of zoomlevels on the map is changed due\n  \t\t// to adding or removing a layer.\n  \t\tif (oldZoomSpan !== this._getZoomSpan()) {\n  \t\t\tthis.fire('zoomlevelschange');\n  \t\t}\n\n  \t\tif (this.options.maxZoom === undefined && this._layersMaxZoom && this.getZoom() > this._layersMaxZoom) {\n  \t\t\tthis.setZoom(this._layersMaxZoom);\n  \t\t}\n  \t\tif (this.options.minZoom === undefined && this._layersMinZoom && this.getZoom() < this._layersMinZoom) {\n  \t\t\tthis.setZoom(this._layersMinZoom);\n  \t\t}\n  \t}\n  });\n\n  /*\r\n   * @class LayerGroup\r\n   * @aka L.LayerGroup\r\n   * @inherits Interactive layer\r\n   *\r\n   * Used to group several layers and handle them as one. If you add it to the map,\r\n   * any layers added or removed from the group will be added/removed on the map as\r\n   * well. Extends `Layer`.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * L.layerGroup([marker1, marker2])\r\n   * \t.addLayer(polyline)\r\n   * \t.addTo(map);\r\n   * ```\r\n   */\r\n\r\n  var LayerGroup = Layer.extend({\r\n\r\n  \tinitialize: function (layers, options) {\r\n  \t\tsetOptions(this, options);\r\n\r\n  \t\tthis._layers = {};\r\n\r\n  \t\tvar i, len;\r\n\r\n  \t\tif (layers) {\r\n  \t\t\tfor (i = 0, len = layers.length; i < len; i++) {\r\n  \t\t\t\tthis.addLayer(layers[i]);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method addLayer(layer: Layer): this\r\n  \t// Adds the given layer to the group.\r\n  \taddLayer: function (layer) {\r\n  \t\tvar id = this.getLayerId(layer);\r\n\r\n  \t\tthis._layers[id] = layer;\r\n\r\n  \t\tif (this._map) {\r\n  \t\t\tthis._map.addLayer(layer);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method removeLayer(layer: Layer): this\r\n  \t// Removes the given layer from the group.\r\n  \t// @alternative\r\n  \t// @method removeLayer(id: Number): this\r\n  \t// Removes the layer with the given internal ID from the group.\r\n  \tremoveLayer: function (layer) {\r\n  \t\tvar id = layer in this._layers ? layer : this.getLayerId(layer);\r\n\r\n  \t\tif (this._map && this._layers[id]) {\r\n  \t\t\tthis._map.removeLayer(this._layers[id]);\r\n  \t\t}\r\n\r\n  \t\tdelete this._layers[id];\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method hasLayer(layer: Layer): Boolean\r\n  \t// Returns `true` if the given layer is currently added to the group.\r\n  \t// @alternative\r\n  \t// @method hasLayer(id: Number): Boolean\r\n  \t// Returns `true` if the given internal ID is currently added to the group.\r\n  \thasLayer: function (layer) {\r\n  \t\tvar layerId = typeof layer === 'number' ? layer : this.getLayerId(layer);\r\n  \t\treturn layerId in this._layers;\r\n  \t},\r\n\r\n  \t// @method clearLayers(): this\r\n  \t// Removes all the layers from the group.\r\n  \tclearLayers: function () {\r\n  \t\treturn this.eachLayer(this.removeLayer, this);\r\n  \t},\r\n\r\n  \t// @method invoke(methodName: String, …): this\r\n  \t// Calls `methodName` on every layer contained in this group, passing any\r\n  \t// additional parameters. Has no effect if the layers contained do not\r\n  \t// implement `methodName`.\r\n  \tinvoke: function (methodName) {\r\n  \t\tvar args = Array.prototype.slice.call(arguments, 1),\r\n  \t\t    i, layer;\r\n\r\n  \t\tfor (i in this._layers) {\r\n  \t\t\tlayer = this._layers[i];\r\n\r\n  \t\t\tif (layer[methodName]) {\r\n  \t\t\t\tlayer[methodName].apply(layer, args);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tthis.eachLayer(map.addLayer, map);\r\n  \t},\r\n\r\n  \tonRemove: function (map) {\r\n  \t\tthis.eachLayer(map.removeLayer, map);\r\n  \t},\r\n\r\n  \t// @method eachLayer(fn: Function, context?: Object): this\r\n  \t// Iterates over the layers of the group, optionally specifying context of the iterator function.\r\n  \t// ```js\r\n  \t// group.eachLayer(function (layer) {\r\n  \t// \tlayer.bindPopup('Hello');\r\n  \t// });\r\n  \t// ```\r\n  \teachLayer: function (method, context) {\r\n  \t\tfor (var i in this._layers) {\r\n  \t\t\tmethod.call(context, this._layers[i]);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getLayer(id: Number): Layer\r\n  \t// Returns the layer with the given internal ID.\r\n  \tgetLayer: function (id) {\r\n  \t\treturn this._layers[id];\r\n  \t},\r\n\r\n  \t// @method getLayers(): Layer[]\r\n  \t// Returns an array of all the layers added to the group.\r\n  \tgetLayers: function () {\r\n  \t\tvar layers = [];\r\n  \t\tthis.eachLayer(layers.push, layers);\r\n  \t\treturn layers;\r\n  \t},\r\n\r\n  \t// @method setZIndex(zIndex: Number): this\r\n  \t// Calls `setZIndex` on every layer contained in this group, passing the z-index.\r\n  \tsetZIndex: function (zIndex) {\r\n  \t\treturn this.invoke('setZIndex', zIndex);\r\n  \t},\r\n\r\n  \t// @method getLayerId(layer: Layer): Number\r\n  \t// Returns the internal ID for a layer\r\n  \tgetLayerId: function (layer) {\r\n  \t\treturn stamp(layer);\r\n  \t}\r\n  });\r\n\r\n\r\n  // @factory L.layerGroup(layers?: Layer[], options?: Object)\r\n  // Create a layer group, optionally given an initial set of layers and an `options` object.\r\n  var layerGroup = function (layers, options) {\r\n  \treturn new LayerGroup(layers, options);\r\n  };\n\n  /*\r\n   * @class FeatureGroup\r\n   * @aka L.FeatureGroup\r\n   * @inherits LayerGroup\r\n   *\r\n   * Extended `LayerGroup` that makes it easier to do the same thing to all its member layers:\r\n   *  * [`bindPopup`](#layer-bindpopup) binds a popup to all of the layers at once (likewise with [`bindTooltip`](#layer-bindtooltip))\r\n   *  * Events are propagated to the `FeatureGroup`, so if the group has an event\r\n   * handler, it will handle events from any of the layers. This includes mouse events\r\n   * and custom events.\r\n   *  * Has `layeradd` and `layerremove` events\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * L.featureGroup([marker1, marker2, polyline])\r\n   * \t.bindPopup('Hello world!')\r\n   * \t.on('click', function() { alert('Clicked on a member of the group!'); })\r\n   * \t.addTo(map);\r\n   * ```\r\n   */\r\n\r\n  var FeatureGroup = LayerGroup.extend({\r\n\r\n  \taddLayer: function (layer) {\r\n  \t\tif (this.hasLayer(layer)) {\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tlayer.addEventParent(this);\r\n\r\n  \t\tLayerGroup.prototype.addLayer.call(this, layer);\r\n\r\n  \t\t// @event layeradd: LayerEvent\r\n  \t\t// Fired when a layer is added to this `FeatureGroup`\r\n  \t\treturn this.fire('layeradd', {layer: layer});\r\n  \t},\r\n\r\n  \tremoveLayer: function (layer) {\r\n  \t\tif (!this.hasLayer(layer)) {\r\n  \t\t\treturn this;\r\n  \t\t}\r\n  \t\tif (layer in this._layers) {\r\n  \t\t\tlayer = this._layers[layer];\r\n  \t\t}\r\n\r\n  \t\tlayer.removeEventParent(this);\r\n\r\n  \t\tLayerGroup.prototype.removeLayer.call(this, layer);\r\n\r\n  \t\t// @event layerremove: LayerEvent\r\n  \t\t// Fired when a layer is removed from this `FeatureGroup`\r\n  \t\treturn this.fire('layerremove', {layer: layer});\r\n  \t},\r\n\r\n  \t// @method setStyle(style: Path options): this\r\n  \t// Sets the given path options to each layer of the group that has a `setStyle` method.\r\n  \tsetStyle: function (style) {\r\n  \t\treturn this.invoke('setStyle', style);\r\n  \t},\r\n\r\n  \t// @method bringToFront(): this\r\n  \t// Brings the layer group to the top of all other layers\r\n  \tbringToFront: function () {\r\n  \t\treturn this.invoke('bringToFront');\r\n  \t},\r\n\r\n  \t// @method bringToBack(): this\r\n  \t// Brings the layer group to the back of all other layers\r\n  \tbringToBack: function () {\r\n  \t\treturn this.invoke('bringToBack');\r\n  \t},\r\n\r\n  \t// @method getBounds(): LatLngBounds\r\n  \t// Returns the LatLngBounds of the Feature Group (created from bounds and coordinates of its children).\r\n  \tgetBounds: function () {\r\n  \t\tvar bounds = new LatLngBounds();\r\n\r\n  \t\tfor (var id in this._layers) {\r\n  \t\t\tvar layer = this._layers[id];\r\n  \t\t\tbounds.extend(layer.getBounds ? layer.getBounds() : layer.getLatLng());\r\n  \t\t}\r\n  \t\treturn bounds;\r\n  \t}\r\n  });\r\n\r\n  // @factory L.featureGroup(layers?: Layer[], options?: Object)\r\n  // Create a feature group, optionally given an initial set of layers and an `options` object.\r\n  var featureGroup = function (layers, options) {\r\n  \treturn new FeatureGroup(layers, options);\r\n  };\n\n  /*\r\n   * @class Icon\r\n   * @aka L.Icon\r\n   *\r\n   * Represents an icon to provide when creating a marker.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var myIcon = L.icon({\r\n   *     iconUrl: 'my-icon.png',\r\n   *     iconRetinaUrl: 'my-icon@2x.png',\r\n   *     iconSize: [38, 95],\r\n   *     iconAnchor: [22, 94],\r\n   *     popupAnchor: [-3, -76],\r\n   *     shadowUrl: 'my-icon-shadow.png',\r\n   *     shadowRetinaUrl: 'my-icon-shadow@2x.png',\r\n   *     shadowSize: [68, 95],\r\n   *     shadowAnchor: [22, 94]\r\n   * });\r\n   *\r\n   * L.marker([50.505, 30.57], {icon: myIcon}).addTo(map);\r\n   * ```\r\n   *\r\n   * `L.Icon.Default` extends `L.Icon` and is the blue icon Leaflet uses for markers by default.\r\n   *\r\n   */\r\n\r\n  var Icon = Class.extend({\r\n\r\n  \t/* @section\r\n  \t * @aka Icon options\r\n  \t *\r\n  \t * @option iconUrl: String = null\r\n  \t * **(required)** The URL to the icon image (absolute or relative to your script path).\r\n  \t *\r\n  \t * @option iconRetinaUrl: String = null\r\n  \t * The URL to a retina sized version of the icon image (absolute or relative to your\r\n  \t * script path). Used for Retina screen devices.\r\n  \t *\r\n  \t * @option iconSize: Point = null\r\n  \t * Size of the icon image in pixels.\r\n  \t *\r\n  \t * @option iconAnchor: Point = null\r\n  \t * The coordinates of the \"tip\" of the icon (relative to its top left corner). The icon\r\n  \t * will be aligned so that this point is at the marker's geographical location. Centered\r\n  \t * by default if size is specified, also can be set in CSS with negative margins.\r\n  \t *\r\n  \t * @option popupAnchor: Point = [0, 0]\r\n  \t * The coordinates of the point from which popups will \"open\", relative to the icon anchor.\r\n  \t *\r\n  \t * @option tooltipAnchor: Point = [0, 0]\r\n  \t * The coordinates of the point from which tooltips will \"open\", relative to the icon anchor.\r\n  \t *\r\n  \t * @option shadowUrl: String = null\r\n  \t * The URL to the icon shadow image. If not specified, no shadow image will be created.\r\n  \t *\r\n  \t * @option shadowRetinaUrl: String = null\r\n  \t *\r\n  \t * @option shadowSize: Point = null\r\n  \t * Size of the shadow image in pixels.\r\n  \t *\r\n  \t * @option shadowAnchor: Point = null\r\n  \t * The coordinates of the \"tip\" of the shadow (relative to its top left corner) (the same\r\n  \t * as iconAnchor if not specified).\r\n  \t *\r\n  \t * @option className: String = ''\r\n  \t * A custom class name to assign to both icon and shadow images. Empty by default.\r\n  \t */\r\n\r\n  \toptions: {\r\n  \t\tpopupAnchor: [0, 0],\r\n  \t\ttooltipAnchor: [0, 0],\r\n\r\n  \t\t// @option crossOrigin: Boolean|String = false\r\n  \t\t// Whether the crossOrigin attribute will be added to the tiles.\r\n  \t\t// If a String is provided, all tiles will have their crossOrigin attribute set to the String provided. This is needed if you want to access tile pixel data.\r\n  \t\t// Refer to [CORS Settings](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes) for valid String values.\r\n  \t\tcrossOrigin: false\r\n  \t},\r\n\r\n  \tinitialize: function (options) {\r\n  \t\tsetOptions(this, options);\r\n  \t},\r\n\r\n  \t// @method createIcon(oldIcon?: HTMLElement): HTMLElement\r\n  \t// Called internally when the icon has to be shown, returns a `<img>` HTML element\r\n  \t// styled according to the options.\r\n  \tcreateIcon: function (oldIcon) {\r\n  \t\treturn this._createIcon('icon', oldIcon);\r\n  \t},\r\n\r\n  \t// @method createShadow(oldIcon?: HTMLElement): HTMLElement\r\n  \t// As `createIcon`, but for the shadow beneath it.\r\n  \tcreateShadow: function (oldIcon) {\r\n  \t\treturn this._createIcon('shadow', oldIcon);\r\n  \t},\r\n\r\n  \t_createIcon: function (name, oldIcon) {\r\n  \t\tvar src = this._getIconUrl(name);\r\n\r\n  \t\tif (!src) {\r\n  \t\t\tif (name === 'icon') {\r\n  \t\t\t\tthrow new Error('iconUrl not set in Icon options (see the docs).');\r\n  \t\t\t}\r\n  \t\t\treturn null;\r\n  \t\t}\r\n\r\n  \t\tvar img = this._createImg(src, oldIcon && oldIcon.tagName === 'IMG' ? oldIcon : null);\r\n  \t\tthis._setIconStyles(img, name);\r\n\r\n  \t\tif (this.options.crossOrigin || this.options.crossOrigin === '') {\r\n  \t\t\timg.crossOrigin = this.options.crossOrigin === true ? '' : this.options.crossOrigin;\r\n  \t\t}\r\n\r\n  \t\treturn img;\r\n  \t},\r\n\r\n  \t_setIconStyles: function (img, name) {\r\n  \t\tvar options = this.options;\r\n  \t\tvar sizeOption = options[name + 'Size'];\r\n\r\n  \t\tif (typeof sizeOption === 'number') {\r\n  \t\t\tsizeOption = [sizeOption, sizeOption];\r\n  \t\t}\r\n\r\n  \t\tvar size = toPoint(sizeOption),\r\n  \t\t    anchor = toPoint(name === 'shadow' && options.shadowAnchor || options.iconAnchor ||\r\n  \t\t            size && size.divideBy(2, true));\r\n\r\n  \t\timg.className = 'leaflet-marker-' + name + ' ' + (options.className || '');\r\n\r\n  \t\tif (anchor) {\r\n  \t\t\timg.style.marginLeft = (-anchor.x) + 'px';\r\n  \t\t\timg.style.marginTop  = (-anchor.y) + 'px';\r\n  \t\t}\r\n\r\n  \t\tif (size) {\r\n  \t\t\timg.style.width  = size.x + 'px';\r\n  \t\t\timg.style.height = size.y + 'px';\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_createImg: function (src, el) {\r\n  \t\tel = el || document.createElement('img');\r\n  \t\tel.src = src;\r\n  \t\treturn el;\r\n  \t},\r\n\r\n  \t_getIconUrl: function (name) {\r\n  \t\treturn Browser.retina && this.options[name + 'RetinaUrl'] || this.options[name + 'Url'];\r\n  \t}\r\n  });\r\n\r\n\r\n  // @factory L.icon(options: Icon options)\r\n  // Creates an icon instance with the given options.\r\n  function icon(options) {\r\n  \treturn new Icon(options);\r\n  }\n\n  /*\n   * @miniclass Icon.Default (Icon)\n   * @aka L.Icon.Default\n   * @section\n   *\n   * A trivial subclass of `Icon`, represents the icon to use in `Marker`s when\n   * no icon is specified. Points to the blue marker image distributed with Leaflet\n   * releases.\n   *\n   * In order to customize the default icon, just change the properties of `L.Icon.Default.prototype.options`\n   * (which is a set of `Icon options`).\n   *\n   * If you want to _completely_ replace the default icon, override the\n   * `L.Marker.prototype.options.icon` with your own icon instead.\n   */\n\n  var IconDefault = Icon.extend({\n\n  \toptions: {\n  \t\ticonUrl:       'marker-icon.png',\n  \t\ticonRetinaUrl: 'marker-icon-2x.png',\n  \t\tshadowUrl:     'marker-shadow.png',\n  \t\ticonSize:    [25, 41],\n  \t\ticonAnchor:  [12, 41],\n  \t\tpopupAnchor: [1, -34],\n  \t\ttooltipAnchor: [16, -28],\n  \t\tshadowSize:  [41, 41]\n  \t},\n\n  \t_getIconUrl: function (name) {\n  \t\tif (typeof IconDefault.imagePath !== 'string') {\t// Deprecated, backwards-compatibility only\n  \t\t\tIconDefault.imagePath = this._detectIconPath();\n  \t\t}\n\n  \t\t// @option imagePath: String\n  \t\t// `Icon.Default` will try to auto-detect the location of the\n  \t\t// blue icon images. If you are placing these images in a non-standard\n  \t\t// way, set this option to point to the right path.\n  \t\treturn (this.options.imagePath || IconDefault.imagePath) + Icon.prototype._getIconUrl.call(this, name);\n  \t},\n\n  \t_stripUrl: function (path) {\t// separate function to use in tests\n  \t\tvar strip = function (str, re, idx) {\n  \t\t\tvar match = re.exec(str);\n  \t\t\treturn match && match[idx];\n  \t\t};\n  \t\tpath = strip(path, /^url\\((['\"])?(.+)\\1\\)$/, 2);\n  \t\treturn path && strip(path, /^(.*)marker-icon\\.png$/, 1);\n  \t},\n\n  \t_detectIconPath: function () {\n  \t\tvar el = create$1('div',  'leaflet-default-icon-path', document.body);\n  \t\tvar path = getStyle(el, 'background-image') ||\n  \t\t           getStyle(el, 'backgroundImage');\t// IE8\n\n  \t\tdocument.body.removeChild(el);\n  \t\tpath = this._stripUrl(path);\n  \t\tif (path) { return path; }\n  \t\tvar link = document.querySelector('link[href$=\"leaflet.css\"]');\n  \t\tif (!link) { return ''; }\n  \t\treturn link.href.substring(0, link.href.length - 'leaflet.css'.length - 1);\n  \t}\n  });\n\n  /*\n   * L.Handler.MarkerDrag is used internally by L.Marker to make the markers draggable.\n   */\n\n\n  /* @namespace Marker\n   * @section Interaction handlers\n   *\n   * Interaction handlers are properties of a marker instance that allow you to control interaction behavior in runtime, enabling or disabling certain features such as dragging (see `Handler` methods). Example:\n   *\n   * ```js\n   * marker.dragging.disable();\n   * ```\n   *\n   * @property dragging: Handler\n   * Marker dragging handler (by both mouse and touch). Only valid when the marker is on the map (Otherwise set [`marker.options.draggable`](#marker-draggable)).\n   */\n\n  var MarkerDrag = Handler.extend({\n  \tinitialize: function (marker) {\n  \t\tthis._marker = marker;\n  \t},\n\n  \taddHooks: function () {\n  \t\tvar icon = this._marker._icon;\n\n  \t\tif (!this._draggable) {\n  \t\t\tthis._draggable = new Draggable(icon, icon, true);\n  \t\t}\n\n  \t\tthis._draggable.on({\n  \t\t\tdragstart: this._onDragStart,\n  \t\t\tpredrag: this._onPreDrag,\n  \t\t\tdrag: this._onDrag,\n  \t\t\tdragend: this._onDragEnd\n  \t\t}, this).enable();\n\n  \t\taddClass(icon, 'leaflet-marker-draggable');\n  \t},\n\n  \tremoveHooks: function () {\n  \t\tthis._draggable.off({\n  \t\t\tdragstart: this._onDragStart,\n  \t\t\tpredrag: this._onPreDrag,\n  \t\t\tdrag: this._onDrag,\n  \t\t\tdragend: this._onDragEnd\n  \t\t}, this).disable();\n\n  \t\tif (this._marker._icon) {\n  \t\t\tremoveClass(this._marker._icon, 'leaflet-marker-draggable');\n  \t\t}\n  \t},\n\n  \tmoved: function () {\n  \t\treturn this._draggable && this._draggable._moved;\n  \t},\n\n  \t_adjustPan: function (e) {\n  \t\tvar marker = this._marker,\n  \t\t    map = marker._map,\n  \t\t    speed = this._marker.options.autoPanSpeed,\n  \t\t    padding = this._marker.options.autoPanPadding,\n  \t\t    iconPos = getPosition(marker._icon),\n  \t\t    bounds = map.getPixelBounds(),\n  \t\t    origin = map.getPixelOrigin();\n\n  \t\tvar panBounds = toBounds(\n  \t\t\tbounds.min._subtract(origin).add(padding),\n  \t\t\tbounds.max._subtract(origin).subtract(padding)\n  \t\t);\n\n  \t\tif (!panBounds.contains(iconPos)) {\n  \t\t\t// Compute incremental movement\n  \t\t\tvar movement = toPoint(\n  \t\t\t\t(Math.max(panBounds.max.x, iconPos.x) - panBounds.max.x) / (bounds.max.x - panBounds.max.x) -\n  \t\t\t\t(Math.min(panBounds.min.x, iconPos.x) - panBounds.min.x) / (bounds.min.x - panBounds.min.x),\n\n  \t\t\t\t(Math.max(panBounds.max.y, iconPos.y) - panBounds.max.y) / (bounds.max.y - panBounds.max.y) -\n  \t\t\t\t(Math.min(panBounds.min.y, iconPos.y) - panBounds.min.y) / (bounds.min.y - panBounds.min.y)\n  \t\t\t).multiplyBy(speed);\n\n  \t\t\tmap.panBy(movement, {animate: false});\n\n  \t\t\tthis._draggable._newPos._add(movement);\n  \t\t\tthis._draggable._startPos._add(movement);\n\n  \t\t\tsetPosition(marker._icon, this._draggable._newPos);\n  \t\t\tthis._onDrag(e);\n\n  \t\t\tthis._panRequest = requestAnimFrame(this._adjustPan.bind(this, e));\n  \t\t}\n  \t},\n\n  \t_onDragStart: function () {\n  \t\t// @section Dragging events\n  \t\t// @event dragstart: Event\n  \t\t// Fired when the user starts dragging the marker.\n\n  \t\t// @event movestart: Event\n  \t\t// Fired when the marker starts moving (because of dragging).\n\n  \t\tthis._oldLatLng = this._marker.getLatLng();\n\n  \t\t// When using ES6 imports it could not be set when `Popup` was not imported as well\n  \t\tthis._marker.closePopup && this._marker.closePopup();\n\n  \t\tthis._marker\n  \t\t\t.fire('movestart')\n  \t\t\t.fire('dragstart');\n  \t},\n\n  \t_onPreDrag: function (e) {\n  \t\tif (this._marker.options.autoPan) {\n  \t\t\tcancelAnimFrame(this._panRequest);\n  \t\t\tthis._panRequest = requestAnimFrame(this._adjustPan.bind(this, e));\n  \t\t}\n  \t},\n\n  \t_onDrag: function (e) {\n  \t\tvar marker = this._marker,\n  \t\t    shadow = marker._shadow,\n  \t\t    iconPos = getPosition(marker._icon),\n  \t\t    latlng = marker._map.layerPointToLatLng(iconPos);\n\n  \t\t// update shadow position\n  \t\tif (shadow) {\n  \t\t\tsetPosition(shadow, iconPos);\n  \t\t}\n\n  \t\tmarker._latlng = latlng;\n  \t\te.latlng = latlng;\n  \t\te.oldLatLng = this._oldLatLng;\n\n  \t\t// @event drag: Event\n  \t\t// Fired repeatedly while the user drags the marker.\n  \t\tmarker\n  \t\t    .fire('move', e)\n  \t\t    .fire('drag', e);\n  \t},\n\n  \t_onDragEnd: function (e) {\n  \t\t// @event dragend: DragEndEvent\n  \t\t// Fired when the user stops dragging the marker.\n\n  \t\t cancelAnimFrame(this._panRequest);\n\n  \t\t// @event moveend: Event\n  \t\t// Fired when the marker stops moving (because of dragging).\n  \t\tdelete this._oldLatLng;\n  \t\tthis._marker\n  \t\t    .fire('moveend')\n  \t\t    .fire('dragend', e);\n  \t}\n  });\n\n  /*\r\n   * @class Marker\r\n   * @inherits Interactive layer\r\n   * @aka L.Marker\r\n   * L.Marker is used to display clickable/draggable icons on the map. Extends `Layer`.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * L.marker([50.5, 30.5]).addTo(map);\r\n   * ```\r\n   */\r\n\r\n  var Marker = Layer.extend({\r\n\r\n  \t// @section\r\n  \t// @aka Marker options\r\n  \toptions: {\r\n  \t\t// @option icon: Icon = *\r\n  \t\t// Icon instance to use for rendering the marker.\r\n  \t\t// See [Icon documentation](#L.Icon) for details on how to customize the marker icon.\r\n  \t\t// If not specified, a common instance of `L.Icon.Default` is used.\r\n  \t\ticon: new IconDefault(),\r\n\r\n  \t\t// Option inherited from \"Interactive layer\" abstract class\r\n  \t\tinteractive: true,\r\n\r\n  \t\t// @option keyboard: Boolean = true\r\n  \t\t// Whether the marker can be tabbed to with a keyboard and clicked by pressing enter.\r\n  \t\tkeyboard: true,\r\n\r\n  \t\t// @option title: String = ''\r\n  \t\t// Text for the browser tooltip that appear on marker hover (no tooltip by default).\r\n  \t\t// [Useful for accessibility](https://leafletjs.com/examples/accessibility/#markers-must-be-labelled).\r\n  \t\ttitle: '',\r\n\r\n  \t\t// @option alt: String = 'Marker'\r\n  \t\t// Text for the `alt` attribute of the icon image.\r\n  \t\t// [Useful for accessibility](https://leafletjs.com/examples/accessibility/#markers-must-be-labelled).\r\n  \t\talt: 'Marker',\r\n\r\n  \t\t// @option zIndexOffset: Number = 0\r\n  \t\t// By default, marker images zIndex is set automatically based on its latitude. Use this option if you want to put the marker on top of all others (or below), specifying a high value like `1000` (or high negative value, respectively).\r\n  \t\tzIndexOffset: 0,\r\n\r\n  \t\t// @option opacity: Number = 1.0\r\n  \t\t// The opacity of the marker.\r\n  \t\topacity: 1,\r\n\r\n  \t\t// @option riseOnHover: Boolean = false\r\n  \t\t// If `true`, the marker will get on top of others when you hover the mouse over it.\r\n  \t\triseOnHover: false,\r\n\r\n  \t\t// @option riseOffset: Number = 250\r\n  \t\t// The z-index offset used for the `riseOnHover` feature.\r\n  \t\triseOffset: 250,\r\n\r\n  \t\t// @option pane: String = 'markerPane'\r\n  \t\t// `Map pane` where the markers icon will be added.\r\n  \t\tpane: 'markerPane',\r\n\r\n  \t\t// @option shadowPane: String = 'shadowPane'\r\n  \t\t// `Map pane` where the markers shadow will be added.\r\n  \t\tshadowPane: 'shadowPane',\r\n\r\n  \t\t// @option bubblingMouseEvents: Boolean = false\r\n  \t\t// When `true`, a mouse event on this marker will trigger the same event on the map\r\n  \t\t// (unless [`L.DomEvent.stopPropagation`](#domevent-stoppropagation) is used).\r\n  \t\tbubblingMouseEvents: false,\r\n\r\n  \t\t// @option autoPanOnFocus: Boolean = true\r\n  \t\t// When `true`, the map will pan whenever the marker is focused (via\r\n  \t\t// e.g. pressing `tab` on the keyboard) to ensure the marker is\r\n  \t\t// visible within the map's bounds\r\n  \t\tautoPanOnFocus: true,\r\n\r\n  \t\t// @section Draggable marker options\r\n  \t\t// @option draggable: Boolean = false\r\n  \t\t// Whether the marker is draggable with mouse/touch or not.\r\n  \t\tdraggable: false,\r\n\r\n  \t\t// @option autoPan: Boolean = false\r\n  \t\t// Whether to pan the map when dragging this marker near its edge or not.\r\n  \t\tautoPan: false,\r\n\r\n  \t\t// @option autoPanPadding: Point = Point(50, 50)\r\n  \t\t// Distance (in pixels to the left/right and to the top/bottom) of the\r\n  \t\t// map edge to start panning the map.\r\n  \t\tautoPanPadding: [50, 50],\r\n\r\n  \t\t// @option autoPanSpeed: Number = 10\r\n  \t\t// Number of pixels the map should pan by.\r\n  \t\tautoPanSpeed: 10\r\n  \t},\r\n\r\n  \t/* @section\r\n  \t *\r\n  \t * In addition to [shared layer methods](#Layer) like `addTo()` and `remove()` and [popup methods](#Popup) like bindPopup() you can also use the following methods:\r\n  \t */\r\n\r\n  \tinitialize: function (latlng, options) {\r\n  \t\tsetOptions(this, options);\r\n  \t\tthis._latlng = toLatLng(latlng);\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tthis._zoomAnimated = this._zoomAnimated && map.options.markerZoomAnimation;\r\n\r\n  \t\tif (this._zoomAnimated) {\r\n  \t\t\tmap.on('zoomanim', this._animateZoom, this);\r\n  \t\t}\r\n\r\n  \t\tthis._initIcon();\r\n  \t\tthis.update();\r\n  \t},\r\n\r\n  \tonRemove: function (map) {\r\n  \t\tif (this.dragging && this.dragging.enabled()) {\r\n  \t\t\tthis.options.draggable = true;\r\n  \t\t\tthis.dragging.removeHooks();\r\n  \t\t}\r\n  \t\tdelete this.dragging;\r\n\r\n  \t\tif (this._zoomAnimated) {\r\n  \t\t\tmap.off('zoomanim', this._animateZoom, this);\r\n  \t\t}\r\n\r\n  \t\tthis._removeIcon();\r\n  \t\tthis._removeShadow();\r\n  \t},\r\n\r\n  \tgetEvents: function () {\r\n  \t\treturn {\r\n  \t\t\tzoom: this.update,\r\n  \t\t\tviewreset: this.update\r\n  \t\t};\r\n  \t},\r\n\r\n  \t// @method getLatLng: LatLng\r\n  \t// Returns the current geographical position of the marker.\r\n  \tgetLatLng: function () {\r\n  \t\treturn this._latlng;\r\n  \t},\r\n\r\n  \t// @method setLatLng(latlng: LatLng): this\r\n  \t// Changes the marker position to the given point.\r\n  \tsetLatLng: function (latlng) {\r\n  \t\tvar oldLatLng = this._latlng;\r\n  \t\tthis._latlng = toLatLng(latlng);\r\n  \t\tthis.update();\r\n\r\n  \t\t// @event move: Event\r\n  \t\t// Fired when the marker is moved via [`setLatLng`](#marker-setlatlng) or by [dragging](#marker-dragging). Old and new coordinates are included in event arguments as `oldLatLng`, `latlng`.\r\n  \t\treturn this.fire('move', {oldLatLng: oldLatLng, latlng: this._latlng});\r\n  \t},\r\n\r\n  \t// @method setZIndexOffset(offset: Number): this\r\n  \t// Changes the [zIndex offset](#marker-zindexoffset) of the marker.\r\n  \tsetZIndexOffset: function (offset) {\r\n  \t\tthis.options.zIndexOffset = offset;\r\n  \t\treturn this.update();\r\n  \t},\r\n\r\n  \t// @method getIcon: Icon\r\n  \t// Returns the current icon used by the marker\r\n  \tgetIcon: function () {\r\n  \t\treturn this.options.icon;\r\n  \t},\r\n\r\n  \t// @method setIcon(icon: Icon): this\r\n  \t// Changes the marker icon.\r\n  \tsetIcon: function (icon) {\r\n\r\n  \t\tthis.options.icon = icon;\r\n\r\n  \t\tif (this._map) {\r\n  \t\t\tthis._initIcon();\r\n  \t\t\tthis.update();\r\n  \t\t}\r\n\r\n  \t\tif (this._popup) {\r\n  \t\t\tthis.bindPopup(this._popup, this._popup.options);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \tgetElement: function () {\r\n  \t\treturn this._icon;\r\n  \t},\r\n\r\n  \tupdate: function () {\r\n\r\n  \t\tif (this._icon && this._map) {\r\n  \t\t\tvar pos = this._map.latLngToLayerPoint(this._latlng).round();\r\n  \t\t\tthis._setPos(pos);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_initIcon: function () {\r\n  \t\tvar options = this.options,\r\n  \t\t    classToAdd = 'leaflet-zoom-' + (this._zoomAnimated ? 'animated' : 'hide');\r\n\r\n  \t\tvar icon = options.icon.createIcon(this._icon),\r\n  \t\t    addIcon = false;\r\n\r\n  \t\t// if we're not reusing the icon, remove the old one and init new one\r\n  \t\tif (icon !== this._icon) {\r\n  \t\t\tif (this._icon) {\r\n  \t\t\t\tthis._removeIcon();\r\n  \t\t\t}\r\n  \t\t\taddIcon = true;\r\n\r\n  \t\t\tif (options.title) {\r\n  \t\t\t\ticon.title = options.title;\r\n  \t\t\t}\r\n\r\n  \t\t\tif (icon.tagName === 'IMG') {\r\n  \t\t\t\ticon.alt = options.alt || '';\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\taddClass(icon, classToAdd);\r\n\r\n  \t\tif (options.keyboard) {\r\n  \t\t\ticon.tabIndex = '0';\r\n  \t\t\ticon.setAttribute('role', 'button');\r\n  \t\t}\r\n\r\n  \t\tthis._icon = icon;\r\n\r\n  \t\tif (options.riseOnHover) {\r\n  \t\t\tthis.on({\r\n  \t\t\t\tmouseover: this._bringToFront,\r\n  \t\t\t\tmouseout: this._resetZIndex\r\n  \t\t\t});\r\n  \t\t}\r\n\r\n  \t\tif (this.options.autoPanOnFocus) {\r\n  \t\t\ton(icon, 'focus', this._panOnFocus, this);\r\n  \t\t}\r\n\r\n  \t\tvar newShadow = options.icon.createShadow(this._shadow),\r\n  \t\t    addShadow = false;\r\n\r\n  \t\tif (newShadow !== this._shadow) {\r\n  \t\t\tthis._removeShadow();\r\n  \t\t\taddShadow = true;\r\n  \t\t}\r\n\r\n  \t\tif (newShadow) {\r\n  \t\t\taddClass(newShadow, classToAdd);\r\n  \t\t\tnewShadow.alt = '';\r\n  \t\t}\r\n  \t\tthis._shadow = newShadow;\r\n\r\n\r\n  \t\tif (options.opacity < 1) {\r\n  \t\t\tthis._updateOpacity();\r\n  \t\t}\r\n\r\n\r\n  \t\tif (addIcon) {\r\n  \t\t\tthis.getPane().appendChild(this._icon);\r\n  \t\t}\r\n  \t\tthis._initInteraction();\r\n  \t\tif (newShadow && addShadow) {\r\n  \t\t\tthis.getPane(options.shadowPane).appendChild(this._shadow);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_removeIcon: function () {\r\n  \t\tif (this.options.riseOnHover) {\r\n  \t\t\tthis.off({\r\n  \t\t\t\tmouseover: this._bringToFront,\r\n  \t\t\t\tmouseout: this._resetZIndex\r\n  \t\t\t});\r\n  \t\t}\r\n\r\n  \t\tif (this.options.autoPanOnFocus) {\r\n  \t\t\toff(this._icon, 'focus', this._panOnFocus, this);\r\n  \t\t}\r\n\r\n  \t\tremove(this._icon);\r\n  \t\tthis.removeInteractiveTarget(this._icon);\r\n\r\n  \t\tthis._icon = null;\r\n  \t},\r\n\r\n  \t_removeShadow: function () {\r\n  \t\tif (this._shadow) {\r\n  \t\t\tremove(this._shadow);\r\n  \t\t}\r\n  \t\tthis._shadow = null;\r\n  \t},\r\n\r\n  \t_setPos: function (pos) {\r\n\r\n  \t\tif (this._icon) {\r\n  \t\t\tsetPosition(this._icon, pos);\r\n  \t\t}\r\n\r\n  \t\tif (this._shadow) {\r\n  \t\t\tsetPosition(this._shadow, pos);\r\n  \t\t}\r\n\r\n  \t\tthis._zIndex = pos.y + this.options.zIndexOffset;\r\n\r\n  \t\tthis._resetZIndex();\r\n  \t},\r\n\r\n  \t_updateZIndex: function (offset) {\r\n  \t\tif (this._icon) {\r\n  \t\t\tthis._icon.style.zIndex = this._zIndex + offset;\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_animateZoom: function (opt) {\r\n  \t\tvar pos = this._map._latLngToNewLayerPoint(this._latlng, opt.zoom, opt.center).round();\r\n\r\n  \t\tthis._setPos(pos);\r\n  \t},\r\n\r\n  \t_initInteraction: function () {\r\n\r\n  \t\tif (!this.options.interactive) { return; }\r\n\r\n  \t\taddClass(this._icon, 'leaflet-interactive');\r\n\r\n  \t\tthis.addInteractiveTarget(this._icon);\r\n\r\n  \t\tif (MarkerDrag) {\r\n  \t\t\tvar draggable = this.options.draggable;\r\n  \t\t\tif (this.dragging) {\r\n  \t\t\t\tdraggable = this.dragging.enabled();\r\n  \t\t\t\tthis.dragging.disable();\r\n  \t\t\t}\r\n\r\n  \t\t\tthis.dragging = new MarkerDrag(this);\r\n\r\n  \t\t\tif (draggable) {\r\n  \t\t\t\tthis.dragging.enable();\r\n  \t\t\t}\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method setOpacity(opacity: Number): this\r\n  \t// Changes the opacity of the marker.\r\n  \tsetOpacity: function (opacity) {\r\n  \t\tthis.options.opacity = opacity;\r\n  \t\tif (this._map) {\r\n  \t\t\tthis._updateOpacity();\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_updateOpacity: function () {\r\n  \t\tvar opacity = this.options.opacity;\r\n\r\n  \t\tif (this._icon) {\r\n  \t\t\tsetOpacity(this._icon, opacity);\r\n  \t\t}\r\n\r\n  \t\tif (this._shadow) {\r\n  \t\t\tsetOpacity(this._shadow, opacity);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_bringToFront: function () {\r\n  \t\tthis._updateZIndex(this.options.riseOffset);\r\n  \t},\r\n\r\n  \t_resetZIndex: function () {\r\n  \t\tthis._updateZIndex(0);\r\n  \t},\r\n\r\n  \t_panOnFocus: function () {\r\n  \t\tvar map = this._map;\r\n  \t\tif (!map) { return; }\r\n\r\n  \t\tvar iconOpts = this.options.icon.options;\r\n  \t\tvar size = iconOpts.iconSize ? toPoint(iconOpts.iconSize) : toPoint(0, 0);\r\n  \t\tvar anchor = iconOpts.iconAnchor ? toPoint(iconOpts.iconAnchor) : toPoint(0, 0);\r\n\r\n  \t\tmap.panInside(this._latlng, {\r\n  \t\t\tpaddingTopLeft: anchor,\r\n  \t\t\tpaddingBottomRight: size.subtract(anchor)\r\n  \t\t});\r\n  \t},\r\n\r\n  \t_getPopupAnchor: function () {\r\n  \t\treturn this.options.icon.options.popupAnchor;\r\n  \t},\r\n\r\n  \t_getTooltipAnchor: function () {\r\n  \t\treturn this.options.icon.options.tooltipAnchor;\r\n  \t}\r\n  });\r\n\r\n\r\n  // factory L.marker(latlng: LatLng, options? : Marker options)\r\n\r\n  // @factory L.marker(latlng: LatLng, options? : Marker options)\r\n  // Instantiates a Marker object given a geographical point and optionally an options object.\r\n  function marker(latlng, options) {\r\n  \treturn new Marker(latlng, options);\r\n  }\n\n  /*\n   * @class Path\n   * @aka L.Path\n   * @inherits Interactive layer\n   *\n   * An abstract class that contains options and constants shared between vector\n   * overlays (Polygon, Polyline, Circle). Do not use it directly. Extends `Layer`.\n   */\n\n  var Path = Layer.extend({\n\n  \t// @section\n  \t// @aka Path options\n  \toptions: {\n  \t\t// @option stroke: Boolean = true\n  \t\t// Whether to draw stroke along the path. Set it to `false` to disable borders on polygons or circles.\n  \t\tstroke: true,\n\n  \t\t// @option color: String = '#3388ff'\n  \t\t// Stroke color\n  \t\tcolor: '#3388ff',\n\n  \t\t// @option weight: Number = 3\n  \t\t// Stroke width in pixels\n  \t\tweight: 3,\n\n  \t\t// @option opacity: Number = 1.0\n  \t\t// Stroke opacity\n  \t\topacity: 1,\n\n  \t\t// @option lineCap: String= 'round'\n  \t\t// A string that defines [shape to be used at the end](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-linecap) of the stroke.\n  \t\tlineCap: 'round',\n\n  \t\t// @option lineJoin: String = 'round'\n  \t\t// A string that defines [shape to be used at the corners](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-linejoin) of the stroke.\n  \t\tlineJoin: 'round',\n\n  \t\t// @option dashArray: String = null\n  \t\t// A string that defines the stroke [dash pattern](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-dasharray). Doesn't work on `Canvas`-powered layers in [some old browsers](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/setLineDash#Browser_compatibility).\n  \t\tdashArray: null,\n\n  \t\t// @option dashOffset: String = null\n  \t\t// A string that defines the [distance into the dash pattern to start the dash](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-dashoffset). Doesn't work on `Canvas`-powered layers in [some old browsers](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/setLineDash#Browser_compatibility).\n  \t\tdashOffset: null,\n\n  \t\t// @option fill: Boolean = depends\n  \t\t// Whether to fill the path with color. Set it to `false` to disable filling on polygons or circles.\n  \t\tfill: false,\n\n  \t\t// @option fillColor: String = *\n  \t\t// Fill color. Defaults to the value of the [`color`](#path-color) option\n  \t\tfillColor: null,\n\n  \t\t// @option fillOpacity: Number = 0.2\n  \t\t// Fill opacity.\n  \t\tfillOpacity: 0.2,\n\n  \t\t// @option fillRule: String = 'evenodd'\n  \t\t// A string that defines [how the inside of a shape](https://developer.mozilla.org/docs/Web/SVG/Attribute/fill-rule) is determined.\n  \t\tfillRule: 'evenodd',\n\n  \t\t// className: '',\n\n  \t\t// Option inherited from \"Interactive layer\" abstract class\n  \t\tinteractive: true,\n\n  \t\t// @option bubblingMouseEvents: Boolean = true\n  \t\t// When `true`, a mouse event on this path will trigger the same event on the map\n  \t\t// (unless [`L.DomEvent.stopPropagation`](#domevent-stoppropagation) is used).\n  \t\tbubblingMouseEvents: true\n  \t},\n\n  \tbeforeAdd: function (map) {\n  \t\t// Renderer is set here because we need to call renderer.getEvents\n  \t\t// before this.getEvents.\n  \t\tthis._renderer = map.getRenderer(this);\n  \t},\n\n  \tonAdd: function () {\n  \t\tthis._renderer._initPath(this);\n  \t\tthis._reset();\n  \t\tthis._renderer._addPath(this);\n  \t},\n\n  \tonRemove: function () {\n  \t\tthis._renderer._removePath(this);\n  \t},\n\n  \t// @method redraw(): this\n  \t// Redraws the layer. Sometimes useful after you changed the coordinates that the path uses.\n  \tredraw: function () {\n  \t\tif (this._map) {\n  \t\t\tthis._renderer._updatePath(this);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method setStyle(style: Path options): this\n  \t// Changes the appearance of a Path based on the options in the `Path options` object.\n  \tsetStyle: function (style) {\n  \t\tsetOptions(this, style);\n  \t\tif (this._renderer) {\n  \t\t\tthis._renderer._updateStyle(this);\n  \t\t\tif (this.options.stroke && style && Object.prototype.hasOwnProperty.call(style, 'weight')) {\n  \t\t\t\tthis._updateBounds();\n  \t\t\t}\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method bringToFront(): this\n  \t// Brings the layer to the top of all path layers.\n  \tbringToFront: function () {\n  \t\tif (this._renderer) {\n  \t\t\tthis._renderer._bringToFront(this);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method bringToBack(): this\n  \t// Brings the layer to the bottom of all path layers.\n  \tbringToBack: function () {\n  \t\tif (this._renderer) {\n  \t\t\tthis._renderer._bringToBack(this);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \tgetElement: function () {\n  \t\treturn this._path;\n  \t},\n\n  \t_reset: function () {\n  \t\t// defined in child classes\n  \t\tthis._project();\n  \t\tthis._update();\n  \t},\n\n  \t_clickTolerance: function () {\n  \t\t// used when doing hit detection for Canvas layers\n  \t\treturn (this.options.stroke ? this.options.weight / 2 : 0) +\n  \t\t  (this._renderer.options.tolerance || 0);\n  \t}\n  });\n\n  /*\n   * @class CircleMarker\n   * @aka L.CircleMarker\n   * @inherits Path\n   *\n   * A circle of a fixed size with radius specified in pixels. Extends `Path`.\n   */\n\n  var CircleMarker = Path.extend({\n\n  \t// @section\n  \t// @aka CircleMarker options\n  \toptions: {\n  \t\tfill: true,\n\n  \t\t// @option radius: Number = 10\n  \t\t// Radius of the circle marker, in pixels\n  \t\tradius: 10\n  \t},\n\n  \tinitialize: function (latlng, options) {\n  \t\tsetOptions(this, options);\n  \t\tthis._latlng = toLatLng(latlng);\n  \t\tthis._radius = this.options.radius;\n  \t},\n\n  \t// @method setLatLng(latLng: LatLng): this\n  \t// Sets the position of a circle marker to a new location.\n  \tsetLatLng: function (latlng) {\n  \t\tvar oldLatLng = this._latlng;\n  \t\tthis._latlng = toLatLng(latlng);\n  \t\tthis.redraw();\n\n  \t\t// @event move: Event\n  \t\t// Fired when the marker is moved via [`setLatLng`](#circlemarker-setlatlng). Old and new coordinates are included in event arguments as `oldLatLng`, `latlng`.\n  \t\treturn this.fire('move', {oldLatLng: oldLatLng, latlng: this._latlng});\n  \t},\n\n  \t// @method getLatLng(): LatLng\n  \t// Returns the current geographical position of the circle marker\n  \tgetLatLng: function () {\n  \t\treturn this._latlng;\n  \t},\n\n  \t// @method setRadius(radius: Number): this\n  \t// Sets the radius of a circle marker. Units are in pixels.\n  \tsetRadius: function (radius) {\n  \t\tthis.options.radius = this._radius = radius;\n  \t\treturn this.redraw();\n  \t},\n\n  \t// @method getRadius(): Number\n  \t// Returns the current radius of the circle\n  \tgetRadius: function () {\n  \t\treturn this._radius;\n  \t},\n\n  \tsetStyle : function (options) {\n  \t\tvar radius = options && options.radius || this._radius;\n  \t\tPath.prototype.setStyle.call(this, options);\n  \t\tthis.setRadius(radius);\n  \t\treturn this;\n  \t},\n\n  \t_project: function () {\n  \t\tthis._point = this._map.latLngToLayerPoint(this._latlng);\n  \t\tthis._updateBounds();\n  \t},\n\n  \t_updateBounds: function () {\n  \t\tvar r = this._radius,\n  \t\t    r2 = this._radiusY || r,\n  \t\t    w = this._clickTolerance(),\n  \t\t    p = [r + w, r2 + w];\n  \t\tthis._pxBounds = new Bounds(this._point.subtract(p), this._point.add(p));\n  \t},\n\n  \t_update: function () {\n  \t\tif (this._map) {\n  \t\t\tthis._updatePath();\n  \t\t}\n  \t},\n\n  \t_updatePath: function () {\n  \t\tthis._renderer._updateCircle(this);\n  \t},\n\n  \t_empty: function () {\n  \t\treturn this._radius && !this._renderer._bounds.intersects(this._pxBounds);\n  \t},\n\n  \t// Needed by the `Canvas` renderer for interactivity\n  \t_containsPoint: function (p) {\n  \t\treturn p.distanceTo(this._point) <= this._radius + this._clickTolerance();\n  \t}\n  });\n\n\n  // @factory L.circleMarker(latlng: LatLng, options?: CircleMarker options)\n  // Instantiates a circle marker object given a geographical point, and an optional options object.\n  function circleMarker(latlng, options) {\n  \treturn new CircleMarker(latlng, options);\n  }\n\n  /*\n   * @class Circle\n   * @aka L.Circle\n   * @inherits CircleMarker\n   *\n   * A class for drawing circle overlays on a map. Extends `CircleMarker`.\n   *\n   * It's an approximation and starts to diverge from a real circle closer to poles (due to projection distortion).\n   *\n   * @example\n   *\n   * ```js\n   * L.circle([50.5, 30.5], {radius: 200}).addTo(map);\n   * ```\n   */\n\n  var Circle = CircleMarker.extend({\n\n  \tinitialize: function (latlng, options, legacyOptions) {\n  \t\tif (typeof options === 'number') {\n  \t\t\t// Backwards compatibility with 0.7.x factory (latlng, radius, options?)\n  \t\t\toptions = extend({}, legacyOptions, {radius: options});\n  \t\t}\n  \t\tsetOptions(this, options);\n  \t\tthis._latlng = toLatLng(latlng);\n\n  \t\tif (isNaN(this.options.radius)) { throw new Error('Circle radius cannot be NaN'); }\n\n  \t\t// @section\n  \t\t// @aka Circle options\n  \t\t// @option radius: Number; Radius of the circle, in meters.\n  \t\tthis._mRadius = this.options.radius;\n  \t},\n\n  \t// @method setRadius(radius: Number): this\n  \t// Sets the radius of a circle. Units are in meters.\n  \tsetRadius: function (radius) {\n  \t\tthis._mRadius = radius;\n  \t\treturn this.redraw();\n  \t},\n\n  \t// @method getRadius(): Number\n  \t// Returns the current radius of a circle. Units are in meters.\n  \tgetRadius: function () {\n  \t\treturn this._mRadius;\n  \t},\n\n  \t// @method getBounds(): LatLngBounds\n  \t// Returns the `LatLngBounds` of the path.\n  \tgetBounds: function () {\n  \t\tvar half = [this._radius, this._radiusY || this._radius];\n\n  \t\treturn new LatLngBounds(\n  \t\t\tthis._map.layerPointToLatLng(this._point.subtract(half)),\n  \t\t\tthis._map.layerPointToLatLng(this._point.add(half)));\n  \t},\n\n  \tsetStyle: Path.prototype.setStyle,\n\n  \t_project: function () {\n\n  \t\tvar lng = this._latlng.lng,\n  \t\t    lat = this._latlng.lat,\n  \t\t    map = this._map,\n  \t\t    crs = map.options.crs;\n\n  \t\tif (crs.distance === Earth.distance) {\n  \t\t\tvar d = Math.PI / 180,\n  \t\t\t    latR = (this._mRadius / Earth.R) / d,\n  \t\t\t    top = map.project([lat + latR, lng]),\n  \t\t\t    bottom = map.project([lat - latR, lng]),\n  \t\t\t    p = top.add(bottom).divideBy(2),\n  \t\t\t    lat2 = map.unproject(p).lat,\n  \t\t\t    lngR = Math.acos((Math.cos(latR * d) - Math.sin(lat * d) * Math.sin(lat2 * d)) /\n  \t\t\t            (Math.cos(lat * d) * Math.cos(lat2 * d))) / d;\n\n  \t\t\tif (isNaN(lngR) || lngR === 0) {\n  \t\t\t\tlngR = latR / Math.cos(Math.PI / 180 * lat); // Fallback for edge case, #2425\n  \t\t\t}\n\n  \t\t\tthis._point = p.subtract(map.getPixelOrigin());\n  \t\t\tthis._radius = isNaN(lngR) ? 0 : p.x - map.project([lat2, lng - lngR]).x;\n  \t\t\tthis._radiusY = p.y - top.y;\n\n  \t\t} else {\n  \t\t\tvar latlng2 = crs.unproject(crs.project(this._latlng).subtract([this._mRadius, 0]));\n\n  \t\t\tthis._point = map.latLngToLayerPoint(this._latlng);\n  \t\t\tthis._radius = this._point.x - map.latLngToLayerPoint(latlng2).x;\n  \t\t}\n\n  \t\tthis._updateBounds();\n  \t}\n  });\n\n  // @factory L.circle(latlng: LatLng, options?: Circle options)\n  // Instantiates a circle object given a geographical point, and an options object\n  // which contains the circle radius.\n  // @alternative\n  // @factory L.circle(latlng: LatLng, radius: Number, options?: Circle options)\n  // Obsolete way of instantiating a circle, for compatibility with 0.7.x code.\n  // Do not use in new applications or plugins.\n  function circle(latlng, options, legacyOptions) {\n  \treturn new Circle(latlng, options, legacyOptions);\n  }\n\n  /*\n   * @class Polyline\n   * @aka L.Polyline\n   * @inherits Path\n   *\n   * A class for drawing polyline overlays on a map. Extends `Path`.\n   *\n   * @example\n   *\n   * ```js\n   * // create a red polyline from an array of LatLng points\n   * var latlngs = [\n   * \t[45.51, -122.68],\n   * \t[37.77, -122.43],\n   * \t[34.04, -118.2]\n   * ];\n   *\n   * var polyline = L.polyline(latlngs, {color: 'red'}).addTo(map);\n   *\n   * // zoom the map to the polyline\n   * map.fitBounds(polyline.getBounds());\n   * ```\n   *\n   * You can also pass a multi-dimensional array to represent a `MultiPolyline` shape:\n   *\n   * ```js\n   * // create a red polyline from an array of arrays of LatLng points\n   * var latlngs = [\n   * \t[[45.51, -122.68],\n   * \t [37.77, -122.43],\n   * \t [34.04, -118.2]],\n   * \t[[40.78, -73.91],\n   * \t [41.83, -87.62],\n   * \t [32.76, -96.72]]\n   * ];\n   * ```\n   */\n\n\n  var Polyline = Path.extend({\n\n  \t// @section\n  \t// @aka Polyline options\n  \toptions: {\n  \t\t// @option smoothFactor: Number = 1.0\n  \t\t// How much to simplify the polyline on each zoom level. More means\n  \t\t// better performance and smoother look, and less means more accurate representation.\n  \t\tsmoothFactor: 1.0,\n\n  \t\t// @option noClip: Boolean = false\n  \t\t// Disable polyline clipping.\n  \t\tnoClip: false\n  \t},\n\n  \tinitialize: function (latlngs, options) {\n  \t\tsetOptions(this, options);\n  \t\tthis._setLatLngs(latlngs);\n  \t},\n\n  \t// @method getLatLngs(): LatLng[]\n  \t// Returns an array of the points in the path, or nested arrays of points in case of multi-polyline.\n  \tgetLatLngs: function () {\n  \t\treturn this._latlngs;\n  \t},\n\n  \t// @method setLatLngs(latlngs: LatLng[]): this\n  \t// Replaces all the points in the polyline with the given array of geographical points.\n  \tsetLatLngs: function (latlngs) {\n  \t\tthis._setLatLngs(latlngs);\n  \t\treturn this.redraw();\n  \t},\n\n  \t// @method isEmpty(): Boolean\n  \t// Returns `true` if the Polyline has no LatLngs.\n  \tisEmpty: function () {\n  \t\treturn !this._latlngs.length;\n  \t},\n\n  \t// @method closestLayerPoint(p: Point): Point\n  \t// Returns the point closest to `p` on the Polyline.\n  \tclosestLayerPoint: function (p) {\n  \t\tvar minDistance = Infinity,\n  \t\t    minPoint = null,\n  \t\t    closest = _sqClosestPointOnSegment,\n  \t\t    p1, p2;\n\n  \t\tfor (var j = 0, jLen = this._parts.length; j < jLen; j++) {\n  \t\t\tvar points = this._parts[j];\n\n  \t\t\tfor (var i = 1, len = points.length; i < len; i++) {\n  \t\t\t\tp1 = points[i - 1];\n  \t\t\t\tp2 = points[i];\n\n  \t\t\t\tvar sqDist = closest(p, p1, p2, true);\n\n  \t\t\t\tif (sqDist < minDistance) {\n  \t\t\t\t\tminDistance = sqDist;\n  \t\t\t\t\tminPoint = closest(p, p1, p2);\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n  \t\tif (minPoint) {\n  \t\t\tminPoint.distance = Math.sqrt(minDistance);\n  \t\t}\n  \t\treturn minPoint;\n  \t},\n\n  \t// @method getCenter(): LatLng\n  \t// Returns the center ([centroid](https://en.wikipedia.org/wiki/Centroid)) of the polyline.\n  \tgetCenter: function () {\n  \t\t// throws error when not yet added to map as this center calculation requires projected coordinates\n  \t\tif (!this._map) {\n  \t\t\tthrow new Error('Must add layer to map before using getCenter()');\n  \t\t}\n  \t\treturn polylineCenter(this._defaultShape(), this._map.options.crs);\n  \t},\n\n  \t// @method getBounds(): LatLngBounds\n  \t// Returns the `LatLngBounds` of the path.\n  \tgetBounds: function () {\n  \t\treturn this._bounds;\n  \t},\n\n  \t// @method addLatLng(latlng: LatLng, latlngs?: LatLng[]): this\n  \t// Adds a given point to the polyline. By default, adds to the first ring of\n  \t// the polyline in case of a multi-polyline, but can be overridden by passing\n  \t// a specific ring as a LatLng array (that you can earlier access with [`getLatLngs`](#polyline-getlatlngs)).\n  \taddLatLng: function (latlng, latlngs) {\n  \t\tlatlngs = latlngs || this._defaultShape();\n  \t\tlatlng = toLatLng(latlng);\n  \t\tlatlngs.push(latlng);\n  \t\tthis._bounds.extend(latlng);\n  \t\treturn this.redraw();\n  \t},\n\n  \t_setLatLngs: function (latlngs) {\n  \t\tthis._bounds = new LatLngBounds();\n  \t\tthis._latlngs = this._convertLatLngs(latlngs);\n  \t},\n\n  \t_defaultShape: function () {\n  \t\treturn isFlat(this._latlngs) ? this._latlngs : this._latlngs[0];\n  \t},\n\n  \t// recursively convert latlngs input into actual LatLng instances; calculate bounds along the way\n  \t_convertLatLngs: function (latlngs) {\n  \t\tvar result = [],\n  \t\t    flat = isFlat(latlngs);\n\n  \t\tfor (var i = 0, len = latlngs.length; i < len; i++) {\n  \t\t\tif (flat) {\n  \t\t\t\tresult[i] = toLatLng(latlngs[i]);\n  \t\t\t\tthis._bounds.extend(result[i]);\n  \t\t\t} else {\n  \t\t\t\tresult[i] = this._convertLatLngs(latlngs[i]);\n  \t\t\t}\n  \t\t}\n\n  \t\treturn result;\n  \t},\n\n  \t_project: function () {\n  \t\tvar pxBounds = new Bounds();\n  \t\tthis._rings = [];\n  \t\tthis._projectLatlngs(this._latlngs, this._rings, pxBounds);\n\n  \t\tif (this._bounds.isValid() && pxBounds.isValid()) {\n  \t\t\tthis._rawPxBounds = pxBounds;\n  \t\t\tthis._updateBounds();\n  \t\t}\n  \t},\n\n  \t_updateBounds: function () {\n  \t\tvar w = this._clickTolerance(),\n  \t\t    p = new Point(w, w);\n\n  \t\tif (!this._rawPxBounds) {\n  \t\t\treturn;\n  \t\t}\n\n  \t\tthis._pxBounds = new Bounds([\n  \t\t\tthis._rawPxBounds.min.subtract(p),\n  \t\t\tthis._rawPxBounds.max.add(p)\n  \t\t]);\n  \t},\n\n  \t// recursively turns latlngs into a set of rings with projected coordinates\n  \t_projectLatlngs: function (latlngs, result, projectedBounds) {\n  \t\tvar flat = latlngs[0] instanceof LatLng,\n  \t\t    len = latlngs.length,\n  \t\t    i, ring;\n\n  \t\tif (flat) {\n  \t\t\tring = [];\n  \t\t\tfor (i = 0; i < len; i++) {\n  \t\t\t\tring[i] = this._map.latLngToLayerPoint(latlngs[i]);\n  \t\t\t\tprojectedBounds.extend(ring[i]);\n  \t\t\t}\n  \t\t\tresult.push(ring);\n  \t\t} else {\n  \t\t\tfor (i = 0; i < len; i++) {\n  \t\t\t\tthis._projectLatlngs(latlngs[i], result, projectedBounds);\n  \t\t\t}\n  \t\t}\n  \t},\n\n  \t// clip polyline by renderer bounds so that we have less to render for performance\n  \t_clipPoints: function () {\n  \t\tvar bounds = this._renderer._bounds;\n\n  \t\tthis._parts = [];\n  \t\tif (!this._pxBounds || !this._pxBounds.intersects(bounds)) {\n  \t\t\treturn;\n  \t\t}\n\n  \t\tif (this.options.noClip) {\n  \t\t\tthis._parts = this._rings;\n  \t\t\treturn;\n  \t\t}\n\n  \t\tvar parts = this._parts,\n  \t\t    i, j, k, len, len2, segment, points;\n\n  \t\tfor (i = 0, k = 0, len = this._rings.length; i < len; i++) {\n  \t\t\tpoints = this._rings[i];\n\n  \t\t\tfor (j = 0, len2 = points.length; j < len2 - 1; j++) {\n  \t\t\t\tsegment = clipSegment(points[j], points[j + 1], bounds, j, true);\n\n  \t\t\t\tif (!segment) { continue; }\n\n  \t\t\t\tparts[k] = parts[k] || [];\n  \t\t\t\tparts[k].push(segment[0]);\n\n  \t\t\t\t// if segment goes out of screen, or it's the last one, it's the end of the line part\n  \t\t\t\tif ((segment[1] !== points[j + 1]) || (j === len2 - 2)) {\n  \t\t\t\t\tparts[k].push(segment[1]);\n  \t\t\t\t\tk++;\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n  \t},\n\n  \t// simplify each clipped part of the polyline for performance\n  \t_simplifyPoints: function () {\n  \t\tvar parts = this._parts,\n  \t\t    tolerance = this.options.smoothFactor;\n\n  \t\tfor (var i = 0, len = parts.length; i < len; i++) {\n  \t\t\tparts[i] = simplify(parts[i], tolerance);\n  \t\t}\n  \t},\n\n  \t_update: function () {\n  \t\tif (!this._map) { return; }\n\n  \t\tthis._clipPoints();\n  \t\tthis._simplifyPoints();\n  \t\tthis._updatePath();\n  \t},\n\n  \t_updatePath: function () {\n  \t\tthis._renderer._updatePoly(this);\n  \t},\n\n  \t// Needed by the `Canvas` renderer for interactivity\n  \t_containsPoint: function (p, closed) {\n  \t\tvar i, j, k, len, len2, part,\n  \t\t    w = this._clickTolerance();\n\n  \t\tif (!this._pxBounds || !this._pxBounds.contains(p)) { return false; }\n\n  \t\t// hit detection for polylines\n  \t\tfor (i = 0, len = this._parts.length; i < len; i++) {\n  \t\t\tpart = this._parts[i];\n\n  \t\t\tfor (j = 0, len2 = part.length, k = len2 - 1; j < len2; k = j++) {\n  \t\t\t\tif (!closed && (j === 0)) { continue; }\n\n  \t\t\t\tif (pointToSegmentDistance(p, part[k], part[j]) <= w) {\n  \t\t\t\t\treturn true;\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n  \t\treturn false;\n  \t}\n  });\n\n  // @factory L.polyline(latlngs: LatLng[], options?: Polyline options)\n  // Instantiates a polyline object given an array of geographical points and\n  // optionally an options object. You can create a `Polyline` object with\n  // multiple separate lines (`MultiPolyline`) by passing an array of arrays\n  // of geographic points.\n  function polyline(latlngs, options) {\n  \treturn new Polyline(latlngs, options);\n  }\n\n  // Retrocompat. Allow plugins to support Leaflet versions before and after 1.1.\n  Polyline._flat = _flat;\n\n  /*\n   * @class Polygon\n   * @aka L.Polygon\n   * @inherits Polyline\n   *\n   * A class for drawing polygon overlays on a map. Extends `Polyline`.\n   *\n   * Note that points you pass when creating a polygon shouldn't have an additional last point equal to the first one — it's better to filter out such points.\n   *\n   *\n   * @example\n   *\n   * ```js\n   * // create a red polygon from an array of LatLng points\n   * var latlngs = [[37, -109.05],[41, -109.03],[41, -102.05],[37, -102.04]];\n   *\n   * var polygon = L.polygon(latlngs, {color: 'red'}).addTo(map);\n   *\n   * // zoom the map to the polygon\n   * map.fitBounds(polygon.getBounds());\n   * ```\n   *\n   * You can also pass an array of arrays of latlngs, with the first array representing the outer shape and the other arrays representing holes in the outer shape:\n   *\n   * ```js\n   * var latlngs = [\n   *   [[37, -109.05],[41, -109.03],[41, -102.05],[37, -102.04]], // outer ring\n   *   [[37.29, -108.58],[40.71, -108.58],[40.71, -102.50],[37.29, -102.50]] // hole\n   * ];\n   * ```\n   *\n   * Additionally, you can pass a multi-dimensional array to represent a MultiPolygon shape.\n   *\n   * ```js\n   * var latlngs = [\n   *   [ // first polygon\n   *     [[37, -109.05],[41, -109.03],[41, -102.05],[37, -102.04]], // outer ring\n   *     [[37.29, -108.58],[40.71, -108.58],[40.71, -102.50],[37.29, -102.50]] // hole\n   *   ],\n   *   [ // second polygon\n   *     [[41, -111.03],[45, -111.04],[45, -104.05],[41, -104.05]]\n   *   ]\n   * ];\n   * ```\n   */\n\n  var Polygon = Polyline.extend({\n\n  \toptions: {\n  \t\tfill: true\n  \t},\n\n  \tisEmpty: function () {\n  \t\treturn !this._latlngs.length || !this._latlngs[0].length;\n  \t},\n\n  \t// @method getCenter(): LatLng\n  \t// Returns the center ([centroid](http://en.wikipedia.org/wiki/Centroid)) of the Polygon.\n  \tgetCenter: function () {\n  \t\t// throws error when not yet added to map as this center calculation requires projected coordinates\n  \t\tif (!this._map) {\n  \t\t\tthrow new Error('Must add layer to map before using getCenter()');\n  \t\t}\n  \t\treturn polygonCenter(this._defaultShape(), this._map.options.crs);\n  \t},\n\n  \t_convertLatLngs: function (latlngs) {\n  \t\tvar result = Polyline.prototype._convertLatLngs.call(this, latlngs),\n  \t\t    len = result.length;\n\n  \t\t// remove last point if it equals first one\n  \t\tif (len >= 2 && result[0] instanceof LatLng && result[0].equals(result[len - 1])) {\n  \t\t\tresult.pop();\n  \t\t}\n  \t\treturn result;\n  \t},\n\n  \t_setLatLngs: function (latlngs) {\n  \t\tPolyline.prototype._setLatLngs.call(this, latlngs);\n  \t\tif (isFlat(this._latlngs)) {\n  \t\t\tthis._latlngs = [this._latlngs];\n  \t\t}\n  \t},\n\n  \t_defaultShape: function () {\n  \t\treturn isFlat(this._latlngs[0]) ? this._latlngs[0] : this._latlngs[0][0];\n  \t},\n\n  \t_clipPoints: function () {\n  \t\t// polygons need a different clipping algorithm so we redefine that\n\n  \t\tvar bounds = this._renderer._bounds,\n  \t\t    w = this.options.weight,\n  \t\t    p = new Point(w, w);\n\n  \t\t// increase clip padding by stroke width to avoid stroke on clip edges\n  \t\tbounds = new Bounds(bounds.min.subtract(p), bounds.max.add(p));\n\n  \t\tthis._parts = [];\n  \t\tif (!this._pxBounds || !this._pxBounds.intersects(bounds)) {\n  \t\t\treturn;\n  \t\t}\n\n  \t\tif (this.options.noClip) {\n  \t\t\tthis._parts = this._rings;\n  \t\t\treturn;\n  \t\t}\n\n  \t\tfor (var i = 0, len = this._rings.length, clipped; i < len; i++) {\n  \t\t\tclipped = clipPolygon(this._rings[i], bounds, true);\n  \t\t\tif (clipped.length) {\n  \t\t\t\tthis._parts.push(clipped);\n  \t\t\t}\n  \t\t}\n  \t},\n\n  \t_updatePath: function () {\n  \t\tthis._renderer._updatePoly(this, true);\n  \t},\n\n  \t// Needed by the `Canvas` renderer for interactivity\n  \t_containsPoint: function (p) {\n  \t\tvar inside = false,\n  \t\t    part, p1, p2, i, j, k, len, len2;\n\n  \t\tif (!this._pxBounds || !this._pxBounds.contains(p)) { return false; }\n\n  \t\t// ray casting algorithm for detecting if point is in polygon\n  \t\tfor (i = 0, len = this._parts.length; i < len; i++) {\n  \t\t\tpart = this._parts[i];\n\n  \t\t\tfor (j = 0, len2 = part.length, k = len2 - 1; j < len2; k = j++) {\n  \t\t\t\tp1 = part[j];\n  \t\t\t\tp2 = part[k];\n\n  \t\t\t\tif (((p1.y > p.y) !== (p2.y > p.y)) && (p.x < (p2.x - p1.x) * (p.y - p1.y) / (p2.y - p1.y) + p1.x)) {\n  \t\t\t\t\tinside = !inside;\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n\n  \t\t// also check if it's on polygon stroke\n  \t\treturn inside || Polyline.prototype._containsPoint.call(this, p, true);\n  \t}\n\n  });\n\n\n  // @factory L.polygon(latlngs: LatLng[], options?: Polyline options)\n  function polygon(latlngs, options) {\n  \treturn new Polygon(latlngs, options);\n  }\n\n  /*\r\n   * @class GeoJSON\r\n   * @aka L.GeoJSON\r\n   * @inherits FeatureGroup\r\n   *\r\n   * Represents a GeoJSON object or an array of GeoJSON objects. Allows you to parse\r\n   * GeoJSON data and display it on the map. Extends `FeatureGroup`.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * L.geoJSON(data, {\r\n   * \tstyle: function (feature) {\r\n   * \t\treturn {color: feature.properties.color};\r\n   * \t}\r\n   * }).bindPopup(function (layer) {\r\n   * \treturn layer.feature.properties.description;\r\n   * }).addTo(map);\r\n   * ```\r\n   */\r\n\r\n  var GeoJSON = FeatureGroup.extend({\r\n\r\n  \t/* @section\r\n  \t * @aka GeoJSON options\r\n  \t *\r\n  \t * @option pointToLayer: Function = *\r\n  \t * A `Function` defining how GeoJSON points spawn Leaflet layers. It is internally\r\n  \t * called when data is added, passing the GeoJSON point feature and its `LatLng`.\r\n  \t * The default is to spawn a default `Marker`:\r\n  \t * ```js\r\n  \t * function(geoJsonPoint, latlng) {\r\n  \t * \treturn L.marker(latlng);\r\n  \t * }\r\n  \t * ```\r\n  \t *\r\n  \t * @option style: Function = *\r\n  \t * A `Function` defining the `Path options` for styling GeoJSON lines and polygons,\r\n  \t * called internally when data is added.\r\n  \t * The default value is to not override any defaults:\r\n  \t * ```js\r\n  \t * function (geoJsonFeature) {\r\n  \t * \treturn {}\r\n  \t * }\r\n  \t * ```\r\n  \t *\r\n  \t * @option onEachFeature: Function = *\r\n  \t * A `Function` that will be called once for each created `Feature`, after it has\r\n  \t * been created and styled. Useful for attaching events and popups to features.\r\n  \t * The default is to do nothing with the newly created layers:\r\n  \t * ```js\r\n  \t * function (feature, layer) {}\r\n  \t * ```\r\n  \t *\r\n  \t * @option filter: Function = *\r\n  \t * A `Function` that will be used to decide whether to include a feature or not.\r\n  \t * The default is to include all features:\r\n  \t * ```js\r\n  \t * function (geoJsonFeature) {\r\n  \t * \treturn true;\r\n  \t * }\r\n  \t * ```\r\n  \t * Note: dynamically changing the `filter` option will have effect only on newly\r\n  \t * added data. It will _not_ re-evaluate already included features.\r\n  \t *\r\n  \t * @option coordsToLatLng: Function = *\r\n  \t * A `Function` that will be used for converting GeoJSON coordinates to `LatLng`s.\r\n  \t * The default is the `coordsToLatLng` static method.\r\n  \t *\r\n  \t * @option markersInheritOptions: Boolean = false\r\n  \t * Whether default Markers for \"Point\" type Features inherit from group options.\r\n  \t */\r\n\r\n  \tinitialize: function (geojson, options) {\r\n  \t\tsetOptions(this, options);\r\n\r\n  \t\tthis._layers = {};\r\n\r\n  \t\tif (geojson) {\r\n  \t\t\tthis.addData(geojson);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method addData( <GeoJSON> data ): this\r\n  \t// Adds a GeoJSON object to the layer.\r\n  \taddData: function (geojson) {\r\n  \t\tvar features = isArray(geojson) ? geojson : geojson.features,\r\n  \t\t    i, len, feature;\r\n\r\n  \t\tif (features) {\r\n  \t\t\tfor (i = 0, len = features.length; i < len; i++) {\r\n  \t\t\t\t// only add this if geometry or geometries are set and not null\r\n  \t\t\t\tfeature = features[i];\r\n  \t\t\t\tif (feature.geometries || feature.geometry || feature.features || feature.coordinates) {\r\n  \t\t\t\t\tthis.addData(feature);\r\n  \t\t\t\t}\r\n  \t\t\t}\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tvar options = this.options;\r\n\r\n  \t\tif (options.filter && !options.filter(geojson)) { return this; }\r\n\r\n  \t\tvar layer = geometryToLayer(geojson, options);\r\n  \t\tif (!layer) {\r\n  \t\t\treturn this;\r\n  \t\t}\r\n  \t\tlayer.feature = asFeature(geojson);\r\n\r\n  \t\tlayer.defaultOptions = layer.options;\r\n  \t\tthis.resetStyle(layer);\r\n\r\n  \t\tif (options.onEachFeature) {\r\n  \t\t\toptions.onEachFeature(geojson, layer);\r\n  \t\t}\r\n\r\n  \t\treturn this.addLayer(layer);\r\n  \t},\r\n\r\n  \t// @method resetStyle( <Path> layer? ): this\r\n  \t// Resets the given vector layer's style to the original GeoJSON style, useful for resetting style after hover events.\r\n  \t// If `layer` is omitted, the style of all features in the current layer is reset.\r\n  \tresetStyle: function (layer) {\r\n  \t\tif (layer === undefined) {\r\n  \t\t\treturn this.eachLayer(this.resetStyle, this);\r\n  \t\t}\r\n  \t\t// reset any custom styles\r\n  \t\tlayer.options = extend({}, layer.defaultOptions);\r\n  \t\tthis._setLayerStyle(layer, this.options.style);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method setStyle( <Function> style ): this\r\n  \t// Changes styles of GeoJSON vector layers with the given style function.\r\n  \tsetStyle: function (style) {\r\n  \t\treturn this.eachLayer(function (layer) {\r\n  \t\t\tthis._setLayerStyle(layer, style);\r\n  \t\t}, this);\r\n  \t},\r\n\r\n  \t_setLayerStyle: function (layer, style) {\r\n  \t\tif (layer.setStyle) {\r\n  \t\t\tif (typeof style === 'function') {\r\n  \t\t\t\tstyle = style(layer.feature);\r\n  \t\t\t}\r\n  \t\t\tlayer.setStyle(style);\r\n  \t\t}\r\n  \t}\r\n  });\r\n\r\n  // @section\r\n  // There are several static functions which can be called without instantiating L.GeoJSON:\r\n\r\n  // @function geometryToLayer(featureData: Object, options?: GeoJSON options): Layer\r\n  // Creates a `Layer` from a given GeoJSON feature. Can use a custom\r\n  // [`pointToLayer`](#geojson-pointtolayer) and/or [`coordsToLatLng`](#geojson-coordstolatlng)\r\n  // functions if provided as options.\r\n  function geometryToLayer(geojson, options) {\r\n\r\n  \tvar geometry = geojson.type === 'Feature' ? geojson.geometry : geojson,\r\n  \t    coords = geometry ? geometry.coordinates : null,\r\n  \t    layers = [],\r\n  \t    pointToLayer = options && options.pointToLayer,\r\n  \t    _coordsToLatLng = options && options.coordsToLatLng || coordsToLatLng,\r\n  \t    latlng, latlngs, i, len;\r\n\r\n  \tif (!coords && !geometry) {\r\n  \t\treturn null;\r\n  \t}\r\n\r\n  \tswitch (geometry.type) {\r\n  \tcase 'Point':\r\n  \t\tlatlng = _coordsToLatLng(coords);\r\n  \t\treturn _pointToLayer(pointToLayer, geojson, latlng, options);\r\n\r\n  \tcase 'MultiPoint':\r\n  \t\tfor (i = 0, len = coords.length; i < len; i++) {\r\n  \t\t\tlatlng = _coordsToLatLng(coords[i]);\r\n  \t\t\tlayers.push(_pointToLayer(pointToLayer, geojson, latlng, options));\r\n  \t\t}\r\n  \t\treturn new FeatureGroup(layers);\r\n\r\n  \tcase 'LineString':\r\n  \tcase 'MultiLineString':\r\n  \t\tlatlngs = coordsToLatLngs(coords, geometry.type === 'LineString' ? 0 : 1, _coordsToLatLng);\r\n  \t\treturn new Polyline(latlngs, options);\r\n\r\n  \tcase 'Polygon':\r\n  \tcase 'MultiPolygon':\r\n  \t\tlatlngs = coordsToLatLngs(coords, geometry.type === 'Polygon' ? 1 : 2, _coordsToLatLng);\r\n  \t\treturn new Polygon(latlngs, options);\r\n\r\n  \tcase 'GeometryCollection':\r\n  \t\tfor (i = 0, len = geometry.geometries.length; i < len; i++) {\r\n  \t\t\tvar geoLayer = geometryToLayer({\r\n  \t\t\t\tgeometry: geometry.geometries[i],\r\n  \t\t\t\ttype: 'Feature',\r\n  \t\t\t\tproperties: geojson.properties\r\n  \t\t\t}, options);\r\n\r\n  \t\t\tif (geoLayer) {\r\n  \t\t\t\tlayers.push(geoLayer);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\treturn new FeatureGroup(layers);\r\n\r\n  \tcase 'FeatureCollection':\r\n  \t\tfor (i = 0, len = geometry.features.length; i < len; i++) {\r\n  \t\t\tvar featureLayer = geometryToLayer(geometry.features[i], options);\r\n\r\n  \t\t\tif (featureLayer) {\r\n  \t\t\t\tlayers.push(featureLayer);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\treturn new FeatureGroup(layers);\r\n\r\n  \tdefault:\r\n  \t\tthrow new Error('Invalid GeoJSON object.');\r\n  \t}\r\n  }\r\n\r\n  function _pointToLayer(pointToLayerFn, geojson, latlng, options) {\r\n  \treturn pointToLayerFn ?\r\n  \t\tpointToLayerFn(geojson, latlng) :\r\n  \t\tnew Marker(latlng, options && options.markersInheritOptions && options);\r\n  }\r\n\r\n  // @function coordsToLatLng(coords: Array): LatLng\r\n  // Creates a `LatLng` object from an array of 2 numbers (longitude, latitude)\r\n  // or 3 numbers (longitude, latitude, altitude) used in GeoJSON for points.\r\n  function coordsToLatLng(coords) {\r\n  \treturn new LatLng(coords[1], coords[0], coords[2]);\r\n  }\r\n\r\n  // @function coordsToLatLngs(coords: Array, levelsDeep?: Number, coordsToLatLng?: Function): Array\r\n  // Creates a multidimensional array of `LatLng`s from a GeoJSON coordinates array.\r\n  // `levelsDeep` specifies the nesting level (0 is for an array of points, 1 for an array of arrays of points, etc., 0 by default).\r\n  // Can use a custom [`coordsToLatLng`](#geojson-coordstolatlng) function.\r\n  function coordsToLatLngs(coords, levelsDeep, _coordsToLatLng) {\r\n  \tvar latlngs = [];\r\n\r\n  \tfor (var i = 0, len = coords.length, latlng; i < len; i++) {\r\n  \t\tlatlng = levelsDeep ?\r\n  \t\t\tcoordsToLatLngs(coords[i], levelsDeep - 1, _coordsToLatLng) :\r\n  \t\t\t(_coordsToLatLng || coordsToLatLng)(coords[i]);\r\n\r\n  \t\tlatlngs.push(latlng);\r\n  \t}\r\n\r\n  \treturn latlngs;\r\n  }\r\n\r\n  // @function latLngToCoords(latlng: LatLng, precision?: Number|false): Array\r\n  // Reverse of [`coordsToLatLng`](#geojson-coordstolatlng)\r\n  // Coordinates values are rounded with [`formatNum`](#util-formatnum) function.\r\n  function latLngToCoords(latlng, precision) {\r\n  \tlatlng = toLatLng(latlng);\r\n  \treturn latlng.alt !== undefined ?\r\n  \t\t[formatNum(latlng.lng, precision), formatNum(latlng.lat, precision), formatNum(latlng.alt, precision)] :\r\n  \t\t[formatNum(latlng.lng, precision), formatNum(latlng.lat, precision)];\r\n  }\r\n\r\n  // @function latLngsToCoords(latlngs: Array, levelsDeep?: Number, closed?: Boolean, precision?: Number|false): Array\r\n  // Reverse of [`coordsToLatLngs`](#geojson-coordstolatlngs)\r\n  // `closed` determines whether the first point should be appended to the end of the array to close the feature, only used when `levelsDeep` is 0. False by default.\r\n  // Coordinates values are rounded with [`formatNum`](#util-formatnum) function.\r\n  function latLngsToCoords(latlngs, levelsDeep, closed, precision) {\r\n  \tvar coords = [];\r\n\r\n  \tfor (var i = 0, len = latlngs.length; i < len; i++) {\r\n  \t\t// Check for flat arrays required to ensure unbalanced arrays are correctly converted in recursion\r\n  \t\tcoords.push(levelsDeep ?\r\n  \t\t\tlatLngsToCoords(latlngs[i], isFlat(latlngs[i]) ? 0 : levelsDeep - 1, closed, precision) :\r\n  \t\t\tlatLngToCoords(latlngs[i], precision));\r\n  \t}\r\n\r\n  \tif (!levelsDeep && closed) {\r\n  \t\tcoords.push(coords[0].slice());\r\n  \t}\r\n\r\n  \treturn coords;\r\n  }\r\n\r\n  function getFeature(layer, newGeometry) {\r\n  \treturn layer.feature ?\r\n  \t\textend({}, layer.feature, {geometry: newGeometry}) :\r\n  \t\tasFeature(newGeometry);\r\n  }\r\n\r\n  // @function asFeature(geojson: Object): Object\r\n  // Normalize GeoJSON geometries/features into GeoJSON features.\r\n  function asFeature(geojson) {\r\n  \tif (geojson.type === 'Feature' || geojson.type === 'FeatureCollection') {\r\n  \t\treturn geojson;\r\n  \t}\r\n\r\n  \treturn {\r\n  \t\ttype: 'Feature',\r\n  \t\tproperties: {},\r\n  \t\tgeometry: geojson\r\n  \t};\r\n  }\r\n\r\n  var PointToGeoJSON = {\r\n  \ttoGeoJSON: function (precision) {\r\n  \t\treturn getFeature(this, {\r\n  \t\t\ttype: 'Point',\r\n  \t\t\tcoordinates: latLngToCoords(this.getLatLng(), precision)\r\n  \t\t});\r\n  \t}\r\n  };\r\n\r\n  // @namespace Marker\r\n  // @section Other methods\r\n  // @method toGeoJSON(precision?: Number|false): Object\r\n  // Coordinates values are rounded with [`formatNum`](#util-formatnum) function with given `precision`.\r\n  // Returns a [`GeoJSON`](https://en.wikipedia.org/wiki/GeoJSON) representation of the marker (as a GeoJSON `Point` Feature).\r\n  Marker.include(PointToGeoJSON);\r\n\r\n  // @namespace CircleMarker\r\n  // @method toGeoJSON(precision?: Number|false): Object\r\n  // Coordinates values are rounded with [`formatNum`](#util-formatnum) function with given `precision`.\r\n  // Returns a [`GeoJSON`](https://en.wikipedia.org/wiki/GeoJSON) representation of the circle marker (as a GeoJSON `Point` Feature).\r\n  Circle.include(PointToGeoJSON);\r\n  CircleMarker.include(PointToGeoJSON);\r\n\r\n\r\n  // @namespace Polyline\r\n  // @method toGeoJSON(precision?: Number|false): Object\r\n  // Coordinates values are rounded with [`formatNum`](#util-formatnum) function with given `precision`.\r\n  // Returns a [`GeoJSON`](https://en.wikipedia.org/wiki/GeoJSON) representation of the polyline (as a GeoJSON `LineString` or `MultiLineString` Feature).\r\n  Polyline.include({\r\n  \ttoGeoJSON: function (precision) {\r\n  \t\tvar multi = !isFlat(this._latlngs);\r\n\r\n  \t\tvar coords = latLngsToCoords(this._latlngs, multi ? 1 : 0, false, precision);\r\n\r\n  \t\treturn getFeature(this, {\r\n  \t\t\ttype: (multi ? 'Multi' : '') + 'LineString',\r\n  \t\t\tcoordinates: coords\r\n  \t\t});\r\n  \t}\r\n  });\r\n\r\n  // @namespace Polygon\r\n  // @method toGeoJSON(precision?: Number|false): Object\r\n  // Coordinates values are rounded with [`formatNum`](#util-formatnum) function with given `precision`.\r\n  // Returns a [`GeoJSON`](https://en.wikipedia.org/wiki/GeoJSON) representation of the polygon (as a GeoJSON `Polygon` or `MultiPolygon` Feature).\r\n  Polygon.include({\r\n  \ttoGeoJSON: function (precision) {\r\n  \t\tvar holes = !isFlat(this._latlngs),\r\n  \t\t    multi = holes && !isFlat(this._latlngs[0]);\r\n\r\n  \t\tvar coords = latLngsToCoords(this._latlngs, multi ? 2 : holes ? 1 : 0, true, precision);\r\n\r\n  \t\tif (!holes) {\r\n  \t\t\tcoords = [coords];\r\n  \t\t}\r\n\r\n  \t\treturn getFeature(this, {\r\n  \t\t\ttype: (multi ? 'Multi' : '') + 'Polygon',\r\n  \t\t\tcoordinates: coords\r\n  \t\t});\r\n  \t}\r\n  });\r\n\r\n\r\n  // @namespace LayerGroup\r\n  LayerGroup.include({\r\n  \ttoMultiPoint: function (precision) {\r\n  \t\tvar coords = [];\r\n\r\n  \t\tthis.eachLayer(function (layer) {\r\n  \t\t\tcoords.push(layer.toGeoJSON(precision).geometry.coordinates);\r\n  \t\t});\r\n\r\n  \t\treturn getFeature(this, {\r\n  \t\t\ttype: 'MultiPoint',\r\n  \t\t\tcoordinates: coords\r\n  \t\t});\r\n  \t},\r\n\r\n  \t// @method toGeoJSON(precision?: Number|false): Object\r\n  \t// Coordinates values are rounded with [`formatNum`](#util-formatnum) function with given `precision`.\r\n  \t// Returns a [`GeoJSON`](https://en.wikipedia.org/wiki/GeoJSON) representation of the layer group (as a GeoJSON `FeatureCollection`, `GeometryCollection`, or `MultiPoint`).\r\n  \ttoGeoJSON: function (precision) {\r\n\r\n  \t\tvar type = this.feature && this.feature.geometry && this.feature.geometry.type;\r\n\r\n  \t\tif (type === 'MultiPoint') {\r\n  \t\t\treturn this.toMultiPoint(precision);\r\n  \t\t}\r\n\r\n  \t\tvar isGeometryCollection = type === 'GeometryCollection',\r\n  \t\t    jsons = [];\r\n\r\n  \t\tthis.eachLayer(function (layer) {\r\n  \t\t\tif (layer.toGeoJSON) {\r\n  \t\t\t\tvar json = layer.toGeoJSON(precision);\r\n  \t\t\t\tif (isGeometryCollection) {\r\n  \t\t\t\t\tjsons.push(json.geometry);\r\n  \t\t\t\t} else {\r\n  \t\t\t\t\tvar feature = asFeature(json);\r\n  \t\t\t\t\t// Squash nested feature collections\r\n  \t\t\t\t\tif (feature.type === 'FeatureCollection') {\r\n  \t\t\t\t\t\tjsons.push.apply(jsons, feature.features);\r\n  \t\t\t\t\t} else {\r\n  \t\t\t\t\t\tjsons.push(feature);\r\n  \t\t\t\t\t}\r\n  \t\t\t\t}\r\n  \t\t\t}\r\n  \t\t});\r\n\r\n  \t\tif (isGeometryCollection) {\r\n  \t\t\treturn getFeature(this, {\r\n  \t\t\t\tgeometries: jsons,\r\n  \t\t\t\ttype: 'GeometryCollection'\r\n  \t\t\t});\r\n  \t\t}\r\n\r\n  \t\treturn {\r\n  \t\t\ttype: 'FeatureCollection',\r\n  \t\t\tfeatures: jsons\r\n  \t\t};\r\n  \t}\r\n  });\r\n\r\n  // @namespace GeoJSON\r\n  // @factory L.geoJSON(geojson?: Object, options?: GeoJSON options)\r\n  // Creates a GeoJSON layer. Optionally accepts an object in\r\n  // [GeoJSON format](https://tools.ietf.org/html/rfc7946) to display on the map\r\n  // (you can alternatively add it later with `addData` method) and an `options` object.\r\n  function geoJSON(geojson, options) {\r\n  \treturn new GeoJSON(geojson, options);\r\n  }\r\n\r\n  // Backward compatibility.\r\n  var geoJson = geoJSON;\n\n  /*\r\n   * @class ImageOverlay\r\n   * @aka L.ImageOverlay\r\n   * @inherits Interactive layer\r\n   *\r\n   * Used to load and display a single image over specific bounds of the map. Extends `Layer`.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var imageUrl = 'https://maps.lib.utexas.edu/maps/historical/newark_nj_1922.jpg',\r\n   * \timageBounds = [[40.712216, -74.22655], [40.773941, -74.12544]];\r\n   * L.imageOverlay(imageUrl, imageBounds).addTo(map);\r\n   * ```\r\n   */\r\n\r\n  var ImageOverlay = Layer.extend({\r\n\r\n  \t// @section\r\n  \t// @aka ImageOverlay options\r\n  \toptions: {\r\n  \t\t// @option opacity: Number = 1.0\r\n  \t\t// The opacity of the image overlay.\r\n  \t\topacity: 1,\r\n\r\n  \t\t// @option alt: String = ''\r\n  \t\t// Text for the `alt` attribute of the image (useful for accessibility).\r\n  \t\talt: '',\r\n\r\n  \t\t// @option interactive: Boolean = false\r\n  \t\t// If `true`, the image overlay will emit [mouse events](#interactive-layer) when clicked or hovered.\r\n  \t\tinteractive: false,\r\n\r\n  \t\t// @option crossOrigin: Boolean|String = false\r\n  \t\t// Whether the crossOrigin attribute will be added to the image.\r\n  \t\t// If a String is provided, the image will have its crossOrigin attribute set to the String provided. This is needed if you want to access image pixel data.\r\n  \t\t// Refer to [CORS Settings](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes) for valid String values.\r\n  \t\tcrossOrigin: false,\r\n\r\n  \t\t// @option errorOverlayUrl: String = ''\r\n  \t\t// URL to the overlay image to show in place of the overlay that failed to load.\r\n  \t\terrorOverlayUrl: '',\r\n\r\n  \t\t// @option zIndex: Number = 1\r\n  \t\t// The explicit [zIndex](https://developer.mozilla.org/docs/Web/CSS/CSS_Positioning/Understanding_z_index) of the overlay layer.\r\n  \t\tzIndex: 1,\r\n\r\n  \t\t// @option className: String = ''\r\n  \t\t// A custom class name to assign to the image. Empty by default.\r\n  \t\tclassName: ''\r\n  \t},\r\n\r\n  \tinitialize: function (url, bounds, options) { // (String, LatLngBounds, Object)\r\n  \t\tthis._url = url;\r\n  \t\tthis._bounds = toLatLngBounds(bounds);\r\n\r\n  \t\tsetOptions(this, options);\r\n  \t},\r\n\r\n  \tonAdd: function () {\r\n  \t\tif (!this._image) {\r\n  \t\t\tthis._initImage();\r\n\r\n  \t\t\tif (this.options.opacity < 1) {\r\n  \t\t\t\tthis._updateOpacity();\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tif (this.options.interactive) {\r\n  \t\t\taddClass(this._image, 'leaflet-interactive');\r\n  \t\t\tthis.addInteractiveTarget(this._image);\r\n  \t\t}\r\n\r\n  \t\tthis.getPane().appendChild(this._image);\r\n  \t\tthis._reset();\r\n  \t},\r\n\r\n  \tonRemove: function () {\r\n  \t\tremove(this._image);\r\n  \t\tif (this.options.interactive) {\r\n  \t\t\tthis.removeInteractiveTarget(this._image);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method setOpacity(opacity: Number): this\r\n  \t// Sets the opacity of the overlay.\r\n  \tsetOpacity: function (opacity) {\r\n  \t\tthis.options.opacity = opacity;\r\n\r\n  \t\tif (this._image) {\r\n  \t\t\tthis._updateOpacity();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \tsetStyle: function (styleOpts) {\r\n  \t\tif (styleOpts.opacity) {\r\n  \t\t\tthis.setOpacity(styleOpts.opacity);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method bringToFront(): this\r\n  \t// Brings the layer to the top of all overlays.\r\n  \tbringToFront: function () {\r\n  \t\tif (this._map) {\r\n  \t\t\ttoFront(this._image);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method bringToBack(): this\r\n  \t// Brings the layer to the bottom of all overlays.\r\n  \tbringToBack: function () {\r\n  \t\tif (this._map) {\r\n  \t\t\ttoBack(this._image);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method setUrl(url: String): this\r\n  \t// Changes the URL of the image.\r\n  \tsetUrl: function (url) {\r\n  \t\tthis._url = url;\r\n\r\n  \t\tif (this._image) {\r\n  \t\t\tthis._image.src = url;\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method setBounds(bounds: LatLngBounds): this\r\n  \t// Update the bounds that this ImageOverlay covers\r\n  \tsetBounds: function (bounds) {\r\n  \t\tthis._bounds = toLatLngBounds(bounds);\r\n\r\n  \t\tif (this._map) {\r\n  \t\t\tthis._reset();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \tgetEvents: function () {\r\n  \t\tvar events = {\r\n  \t\t\tzoom: this._reset,\r\n  \t\t\tviewreset: this._reset\r\n  \t\t};\r\n\r\n  \t\tif (this._zoomAnimated) {\r\n  \t\t\tevents.zoomanim = this._animateZoom;\r\n  \t\t}\r\n\r\n  \t\treturn events;\r\n  \t},\r\n\r\n  \t// @method setZIndex(value: Number): this\r\n  \t// Changes the [zIndex](#imageoverlay-zindex) of the image overlay.\r\n  \tsetZIndex: function (value) {\r\n  \t\tthis.options.zIndex = value;\r\n  \t\tthis._updateZIndex();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getBounds(): LatLngBounds\r\n  \t// Get the bounds that this ImageOverlay covers\r\n  \tgetBounds: function () {\r\n  \t\treturn this._bounds;\r\n  \t},\r\n\r\n  \t// @method getElement(): HTMLElement\r\n  \t// Returns the instance of [`HTMLImageElement`](https://developer.mozilla.org/docs/Web/API/HTMLImageElement)\r\n  \t// used by this overlay.\r\n  \tgetElement: function () {\r\n  \t\treturn this._image;\r\n  \t},\r\n\r\n  \t_initImage: function () {\r\n  \t\tvar wasElementSupplied = this._url.tagName === 'IMG';\r\n  \t\tvar img = this._image = wasElementSupplied ? this._url : create$1('img');\r\n\r\n  \t\taddClass(img, 'leaflet-image-layer');\r\n  \t\tif (this._zoomAnimated) { addClass(img, 'leaflet-zoom-animated'); }\r\n  \t\tif (this.options.className) { addClass(img, this.options.className); }\r\n\r\n  \t\timg.onselectstart = falseFn;\r\n  \t\timg.onmousemove = falseFn;\r\n\r\n  \t\t// @event load: Event\r\n  \t\t// Fired when the ImageOverlay layer has loaded its image\r\n  \t\timg.onload = bind(this.fire, this, 'load');\r\n  \t\timg.onerror = bind(this._overlayOnError, this, 'error');\r\n\r\n  \t\tif (this.options.crossOrigin || this.options.crossOrigin === '') {\r\n  \t\t\timg.crossOrigin = this.options.crossOrigin === true ? '' : this.options.crossOrigin;\r\n  \t\t}\r\n\r\n  \t\tif (this.options.zIndex) {\r\n  \t\t\tthis._updateZIndex();\r\n  \t\t}\r\n\r\n  \t\tif (wasElementSupplied) {\r\n  \t\t\tthis._url = img.src;\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\timg.src = this._url;\r\n  \t\timg.alt = this.options.alt;\r\n  \t},\r\n\r\n  \t_animateZoom: function (e) {\r\n  \t\tvar scale = this._map.getZoomScale(e.zoom),\r\n  \t\t    offset = this._map._latLngBoundsToNewLayerBounds(this._bounds, e.zoom, e.center).min;\r\n\r\n  \t\tsetTransform(this._image, offset, scale);\r\n  \t},\r\n\r\n  \t_reset: function () {\r\n  \t\tvar image = this._image,\r\n  \t\t    bounds = new Bounds(\r\n  \t\t        this._map.latLngToLayerPoint(this._bounds.getNorthWest()),\r\n  \t\t        this._map.latLngToLayerPoint(this._bounds.getSouthEast())),\r\n  \t\t    size = bounds.getSize();\r\n\r\n  \t\tsetPosition(image, bounds.min);\r\n\r\n  \t\timage.style.width  = size.x + 'px';\r\n  \t\timage.style.height = size.y + 'px';\r\n  \t},\r\n\r\n  \t_updateOpacity: function () {\r\n  \t\tsetOpacity(this._image, this.options.opacity);\r\n  \t},\r\n\r\n  \t_updateZIndex: function () {\r\n  \t\tif (this._image && this.options.zIndex !== undefined && this.options.zIndex !== null) {\r\n  \t\t\tthis._image.style.zIndex = this.options.zIndex;\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_overlayOnError: function () {\r\n  \t\t// @event error: Event\r\n  \t\t// Fired when the ImageOverlay layer fails to load its image\r\n  \t\tthis.fire('error');\r\n\r\n  \t\tvar errorUrl = this.options.errorOverlayUrl;\r\n  \t\tif (errorUrl && this._url !== errorUrl) {\r\n  \t\t\tthis._url = errorUrl;\r\n  \t\t\tthis._image.src = errorUrl;\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method getCenter(): LatLng\r\n  \t// Returns the center of the ImageOverlay.\r\n  \tgetCenter: function () {\r\n  \t\treturn this._bounds.getCenter();\r\n  \t}\r\n  });\r\n\r\n  // @factory L.imageOverlay(imageUrl: String, bounds: LatLngBounds, options?: ImageOverlay options)\r\n  // Instantiates an image overlay object given the URL of the image and the\r\n  // geographical bounds it is tied to.\r\n  var imageOverlay = function (url, bounds, options) {\r\n  \treturn new ImageOverlay(url, bounds, options);\r\n  };\n\n  /*\r\n   * @class VideoOverlay\r\n   * @aka L.VideoOverlay\r\n   * @inherits ImageOverlay\r\n   *\r\n   * Used to load and display a video player over specific bounds of the map. Extends `ImageOverlay`.\r\n   *\r\n   * A video overlay uses the [`<video>`](https://developer.mozilla.org/docs/Web/HTML/Element/video)\r\n   * HTML5 element.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var videoUrl = 'https://www.mapbox.com/bites/00188/patricia_nasa.webm',\r\n   * \tvideoBounds = [[ 32, -130], [ 13, -100]];\r\n   * L.videoOverlay(videoUrl, videoBounds ).addTo(map);\r\n   * ```\r\n   */\r\n\r\n  var VideoOverlay = ImageOverlay.extend({\r\n\r\n  \t// @section\r\n  \t// @aka VideoOverlay options\r\n  \toptions: {\r\n  \t\t// @option autoplay: Boolean = true\r\n  \t\t// Whether the video starts playing automatically when loaded.\r\n  \t\t// On some browsers autoplay will only work with `muted: true`\r\n  \t\tautoplay: true,\r\n\r\n  \t\t// @option loop: Boolean = true\r\n  \t\t// Whether the video will loop back to the beginning when played.\r\n  \t\tloop: true,\r\n\r\n  \t\t// @option keepAspectRatio: Boolean = true\r\n  \t\t// Whether the video will save aspect ratio after the projection.\r\n  \t\t// Relevant for supported browsers. See [browser compatibility](https://developer.mozilla.org/en-US/docs/Web/CSS/object-fit)\r\n  \t\tkeepAspectRatio: true,\r\n\r\n  \t\t// @option muted: Boolean = false\r\n  \t\t// Whether the video starts on mute when loaded.\r\n  \t\tmuted: false,\r\n\r\n  \t\t// @option playsInline: Boolean = true\r\n  \t\t// Mobile browsers will play the video right where it is instead of open it up in fullscreen mode.\r\n  \t\tplaysInline: true\r\n  \t},\r\n\r\n  \t_initImage: function () {\r\n  \t\tvar wasElementSupplied = this._url.tagName === 'VIDEO';\r\n  \t\tvar vid = this._image = wasElementSupplied ? this._url : create$1('video');\r\n\r\n  \t\taddClass(vid, 'leaflet-image-layer');\r\n  \t\tif (this._zoomAnimated) { addClass(vid, 'leaflet-zoom-animated'); }\r\n  \t\tif (this.options.className) { addClass(vid, this.options.className); }\r\n\r\n  \t\tvid.onselectstart = falseFn;\r\n  \t\tvid.onmousemove = falseFn;\r\n\r\n  \t\t// @event load: Event\r\n  \t\t// Fired when the video has finished loading the first frame\r\n  \t\tvid.onloadeddata = bind(this.fire, this, 'load');\r\n\r\n  \t\tif (wasElementSupplied) {\r\n  \t\t\tvar sourceElements = vid.getElementsByTagName('source');\r\n  \t\t\tvar sources = [];\r\n  \t\t\tfor (var j = 0; j < sourceElements.length; j++) {\r\n  \t\t\t\tsources.push(sourceElements[j].src);\r\n  \t\t\t}\r\n\r\n  \t\t\tthis._url = (sourceElements.length > 0) ? sources : [vid.src];\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tif (!isArray(this._url)) { this._url = [this._url]; }\r\n\r\n  \t\tif (!this.options.keepAspectRatio && Object.prototype.hasOwnProperty.call(vid.style, 'objectFit')) {\r\n  \t\t\tvid.style['objectFit'] = 'fill';\r\n  \t\t}\r\n  \t\tvid.autoplay = !!this.options.autoplay;\r\n  \t\tvid.loop = !!this.options.loop;\r\n  \t\tvid.muted = !!this.options.muted;\r\n  \t\tvid.playsInline = !!this.options.playsInline;\r\n  \t\tfor (var i = 0; i < this._url.length; i++) {\r\n  \t\t\tvar source = create$1('source');\r\n  \t\t\tsource.src = this._url[i];\r\n  \t\t\tvid.appendChild(source);\r\n  \t\t}\r\n  \t}\r\n\r\n  \t// @method getElement(): HTMLVideoElement\r\n  \t// Returns the instance of [`HTMLVideoElement`](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement)\r\n  \t// used by this overlay.\r\n  });\r\n\r\n\r\n  // @factory L.videoOverlay(video: String|Array|HTMLVideoElement, bounds: LatLngBounds, options?: VideoOverlay options)\r\n  // Instantiates an image overlay object given the URL of the video (or array of URLs, or even a video element) and the\r\n  // geographical bounds it is tied to.\r\n\r\n  function videoOverlay(video, bounds, options) {\r\n  \treturn new VideoOverlay(video, bounds, options);\r\n  }\n\n  /*\n   * @class SVGOverlay\n   * @aka L.SVGOverlay\n   * @inherits ImageOverlay\n   *\n   * Used to load, display and provide DOM access to an SVG file over specific bounds of the map. Extends `ImageOverlay`.\n   *\n   * An SVG overlay uses the [`<svg>`](https://developer.mozilla.org/docs/Web/SVG/Element/svg) element.\n   *\n   * @example\n   *\n   * ```js\n   * var svgElement = document.createElementNS(\"http://www.w3.org/2000/svg\", \"svg\");\n   * svgElement.setAttribute('xmlns', \"http://www.w3.org/2000/svg\");\n   * svgElement.setAttribute('viewBox', \"0 0 200 200\");\n   * svgElement.innerHTML = '<rect width=\"200\" height=\"200\"/><rect x=\"75\" y=\"23\" width=\"50\" height=\"50\" style=\"fill:red\"/><rect x=\"75\" y=\"123\" width=\"50\" height=\"50\" style=\"fill:#0013ff\"/>';\n   * var svgElementBounds = [ [ 32, -130 ], [ 13, -100 ] ];\n   * L.svgOverlay(svgElement, svgElementBounds).addTo(map);\n   * ```\n   */\n\n  var SVGOverlay = ImageOverlay.extend({\n  \t_initImage: function () {\n  \t\tvar el = this._image = this._url;\n\n  \t\taddClass(el, 'leaflet-image-layer');\n  \t\tif (this._zoomAnimated) { addClass(el, 'leaflet-zoom-animated'); }\n  \t\tif (this.options.className) { addClass(el, this.options.className); }\n\n  \t\tel.onselectstart = falseFn;\n  \t\tel.onmousemove = falseFn;\n  \t}\n\n  \t// @method getElement(): SVGElement\n  \t// Returns the instance of [`SVGElement`](https://developer.mozilla.org/docs/Web/API/SVGElement)\n  \t// used by this overlay.\n  });\n\n\n  // @factory L.svgOverlay(svg: String|SVGElement, bounds: LatLngBounds, options?: SVGOverlay options)\n  // Instantiates an image overlay object given an SVG element and the geographical bounds it is tied to.\n  // A viewBox attribute is required on the SVG element to zoom in and out properly.\n\n  function svgOverlay(el, bounds, options) {\n  \treturn new SVGOverlay(el, bounds, options);\n  }\n\n  /*\r\n   * @class DivOverlay\r\n   * @inherits Interactive layer\r\n   * @aka L.DivOverlay\r\n   * Base model for L.Popup and L.Tooltip. Inherit from it for custom overlays like plugins.\r\n   */\r\n\r\n  // @namespace DivOverlay\r\n  var DivOverlay = Layer.extend({\r\n\r\n  \t// @section\r\n  \t// @aka DivOverlay options\r\n  \toptions: {\r\n  \t\t// @option interactive: Boolean = false\r\n  \t\t// If true, the popup/tooltip will listen to the mouse events.\r\n  \t\tinteractive: false,\r\n\r\n  \t\t// @option offset: Point = Point(0, 0)\r\n  \t\t// The offset of the overlay position.\r\n  \t\toffset: [0, 0],\r\n\r\n  \t\t// @option className: String = ''\r\n  \t\t// A custom CSS class name to assign to the overlay.\r\n  \t\tclassName: '',\r\n\r\n  \t\t// @option pane: String = undefined\r\n  \t\t// `Map pane` where the overlay will be added.\r\n  \t\tpane: undefined,\r\n\r\n  \t\t// @option content: String|HTMLElement|Function = ''\r\n  \t\t// Sets the HTML content of the overlay while initializing. If a function is passed the source layer will be\r\n  \t\t// passed to the function. The function should return a `String` or `HTMLElement` to be used in the overlay.\r\n  \t\tcontent: ''\r\n  \t},\r\n\r\n  \tinitialize: function (options, source) {\r\n  \t\tif (options && (options instanceof LatLng || isArray(options))) {\r\n  \t\t\tthis._latlng = toLatLng(options);\r\n  \t\t\tsetOptions(this, source);\r\n  \t\t} else {\r\n  \t\t\tsetOptions(this, options);\r\n  \t\t\tthis._source = source;\r\n  \t\t}\r\n  \t\tif (this.options.content) {\r\n  \t\t\tthis._content = this.options.content;\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method openOn(map: Map): this\r\n  \t// Adds the overlay to the map.\r\n  \t// Alternative to `map.openPopup(popup)`/`.openTooltip(tooltip)`.\r\n  \topenOn: function (map) {\r\n  \t\tmap = arguments.length ? map : this._source._map; // experimental, not the part of public api\r\n  \t\tif (!map.hasLayer(this)) {\r\n  \t\t\tmap.addLayer(this);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method close(): this\r\n  \t// Closes the overlay.\r\n  \t// Alternative to `map.closePopup(popup)`/`.closeTooltip(tooltip)`\r\n  \t// and `layer.closePopup()`/`.closeTooltip()`.\r\n  \tclose: function () {\r\n  \t\tif (this._map) {\r\n  \t\t\tthis._map.removeLayer(this);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method toggle(layer?: Layer): this\r\n  \t// Opens or closes the overlay bound to layer depending on its current state.\r\n  \t// Argument may be omitted only for overlay bound to layer.\r\n  \t// Alternative to `layer.togglePopup()`/`.toggleTooltip()`.\r\n  \ttoggle: function (layer) {\r\n  \t\tif (this._map) {\r\n  \t\t\tthis.close();\r\n  \t\t} else {\r\n  \t\t\tif (arguments.length) {\r\n  \t\t\t\tthis._source = layer;\r\n  \t\t\t} else {\r\n  \t\t\t\tlayer = this._source;\r\n  \t\t\t}\r\n  \t\t\tthis._prepareOpen();\r\n\r\n  \t\t\t// open the overlay on the map\r\n  \t\t\tthis.openOn(layer._map);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tthis._zoomAnimated = map._zoomAnimated;\r\n\r\n  \t\tif (!this._container) {\r\n  \t\t\tthis._initLayout();\r\n  \t\t}\r\n\r\n  \t\tif (map._fadeAnimated) {\r\n  \t\t\tsetOpacity(this._container, 0);\r\n  \t\t}\r\n\r\n  \t\tclearTimeout(this._removeTimeout);\r\n  \t\tthis.getPane().appendChild(this._container);\r\n  \t\tthis.update();\r\n\r\n  \t\tif (map._fadeAnimated) {\r\n  \t\t\tsetOpacity(this._container, 1);\r\n  \t\t}\r\n\r\n  \t\tthis.bringToFront();\r\n\r\n  \t\tif (this.options.interactive) {\r\n  \t\t\taddClass(this._container, 'leaflet-interactive');\r\n  \t\t\tthis.addInteractiveTarget(this._container);\r\n  \t\t}\r\n  \t},\r\n\r\n  \tonRemove: function (map) {\r\n  \t\tif (map._fadeAnimated) {\r\n  \t\t\tsetOpacity(this._container, 0);\r\n  \t\t\tthis._removeTimeout = setTimeout(bind(remove, undefined, this._container), 200);\r\n  \t\t} else {\r\n  \t\t\tremove(this._container);\r\n  \t\t}\r\n\r\n  \t\tif (this.options.interactive) {\r\n  \t\t\tremoveClass(this._container, 'leaflet-interactive');\r\n  \t\t\tthis.removeInteractiveTarget(this._container);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @namespace DivOverlay\r\n  \t// @method getLatLng: LatLng\r\n  \t// Returns the geographical point of the overlay.\r\n  \tgetLatLng: function () {\r\n  \t\treturn this._latlng;\r\n  \t},\r\n\r\n  \t// @method setLatLng(latlng: LatLng): this\r\n  \t// Sets the geographical point where the overlay will open.\r\n  \tsetLatLng: function (latlng) {\r\n  \t\tthis._latlng = toLatLng(latlng);\r\n  \t\tif (this._map) {\r\n  \t\t\tthis._updatePosition();\r\n  \t\t\tthis._adjustPan();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getContent: String|HTMLElement\r\n  \t// Returns the content of the overlay.\r\n  \tgetContent: function () {\r\n  \t\treturn this._content;\r\n  \t},\r\n\r\n  \t// @method setContent(htmlContent: String|HTMLElement|Function): this\r\n  \t// Sets the HTML content of the overlay. If a function is passed the source layer will be passed to the function.\r\n  \t// The function should return a `String` or `HTMLElement` to be used in the overlay.\r\n  \tsetContent: function (content) {\r\n  \t\tthis._content = content;\r\n  \t\tthis.update();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getElement: String|HTMLElement\r\n  \t// Returns the HTML container of the overlay.\r\n  \tgetElement: function () {\r\n  \t\treturn this._container;\r\n  \t},\r\n\r\n  \t// @method update: null\r\n  \t// Updates the overlay content, layout and position. Useful for updating the overlay after something inside changed, e.g. image loaded.\r\n  \tupdate: function () {\r\n  \t\tif (!this._map) { return; }\r\n\r\n  \t\tthis._container.style.visibility = 'hidden';\r\n\r\n  \t\tthis._updateContent();\r\n  \t\tthis._updateLayout();\r\n  \t\tthis._updatePosition();\r\n\r\n  \t\tthis._container.style.visibility = '';\r\n\r\n  \t\tthis._adjustPan();\r\n  \t},\r\n\r\n  \tgetEvents: function () {\r\n  \t\tvar events = {\r\n  \t\t\tzoom: this._updatePosition,\r\n  \t\t\tviewreset: this._updatePosition\r\n  \t\t};\r\n\r\n  \t\tif (this._zoomAnimated) {\r\n  \t\t\tevents.zoomanim = this._animateZoom;\r\n  \t\t}\r\n  \t\treturn events;\r\n  \t},\r\n\r\n  \t// @method isOpen: Boolean\r\n  \t// Returns `true` when the overlay is visible on the map.\r\n  \tisOpen: function () {\r\n  \t\treturn !!this._map && this._map.hasLayer(this);\r\n  \t},\r\n\r\n  \t// @method bringToFront: this\r\n  \t// Brings this overlay in front of other overlays (in the same map pane).\r\n  \tbringToFront: function () {\r\n  \t\tif (this._map) {\r\n  \t\t\ttoFront(this._container);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method bringToBack: this\r\n  \t// Brings this overlay to the back of other overlays (in the same map pane).\r\n  \tbringToBack: function () {\r\n  \t\tif (this._map) {\r\n  \t\t\ttoBack(this._container);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// prepare bound overlay to open: update latlng pos / content source (for FeatureGroup)\r\n  \t_prepareOpen: function (latlng) {\r\n  \t\tvar source = this._source;\r\n  \t\tif (!source._map) { return false; }\r\n\r\n  \t\tif (source instanceof FeatureGroup) {\r\n  \t\t\tsource = null;\r\n  \t\t\tvar layers = this._source._layers;\r\n  \t\t\tfor (var id in layers) {\r\n  \t\t\t\tif (layers[id]._map) {\r\n  \t\t\t\t\tsource = layers[id];\r\n  \t\t\t\t\tbreak;\r\n  \t\t\t\t}\r\n  \t\t\t}\r\n  \t\t\tif (!source) { return false; } // Unable to get source layer.\r\n\r\n  \t\t\t// set overlay source to this layer\r\n  \t\t\tthis._source = source;\r\n  \t\t}\r\n\r\n  \t\tif (!latlng) {\r\n  \t\t\tif (source.getCenter) {\r\n  \t\t\t\tlatlng = source.getCenter();\r\n  \t\t\t} else if (source.getLatLng) {\r\n  \t\t\t\tlatlng = source.getLatLng();\r\n  \t\t\t} else if (source.getBounds) {\r\n  \t\t\t\tlatlng = source.getBounds().getCenter();\r\n  \t\t\t} else {\r\n  \t\t\t\tthrow new Error('Unable to get source layer LatLng.');\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\tthis.setLatLng(latlng);\r\n\r\n  \t\tif (this._map) {\r\n  \t\t\t// update the overlay (content, layout, etc...)\r\n  \t\t\tthis.update();\r\n  \t\t}\r\n\r\n  \t\treturn true;\r\n  \t},\r\n\r\n  \t_updateContent: function () {\r\n  \t\tif (!this._content) { return; }\r\n\r\n  \t\tvar node = this._contentNode;\r\n  \t\tvar content = (typeof this._content === 'function') ? this._content(this._source || this) : this._content;\r\n\r\n  \t\tif (typeof content === 'string') {\r\n  \t\t\tnode.innerHTML = content;\r\n  \t\t} else {\r\n  \t\t\twhile (node.hasChildNodes()) {\r\n  \t\t\t\tnode.removeChild(node.firstChild);\r\n  \t\t\t}\r\n  \t\t\tnode.appendChild(content);\r\n  \t\t}\r\n\r\n  \t\t// @namespace DivOverlay\r\n  \t\t// @section DivOverlay events\r\n  \t\t// @event contentupdate: Event\r\n  \t\t// Fired when the content of the overlay is updated\r\n  \t\tthis.fire('contentupdate');\r\n  \t},\r\n\r\n  \t_updatePosition: function () {\r\n  \t\tif (!this._map) { return; }\r\n\r\n  \t\tvar pos = this._map.latLngToLayerPoint(this._latlng),\r\n  \t\t    offset = toPoint(this.options.offset),\r\n  \t\t    anchor = this._getAnchor();\r\n\r\n  \t\tif (this._zoomAnimated) {\r\n  \t\t\tsetPosition(this._container, pos.add(anchor));\r\n  \t\t} else {\r\n  \t\t\toffset = offset.add(pos).add(anchor);\r\n  \t\t}\r\n\r\n  \t\tvar bottom = this._containerBottom = -offset.y,\r\n  \t\t    left = this._containerLeft = -Math.round(this._containerWidth / 2) + offset.x;\r\n\r\n  \t\t// bottom position the overlay in case the height of the overlay changes (images loading etc)\r\n  \t\tthis._container.style.bottom = bottom + 'px';\r\n  \t\tthis._container.style.left = left + 'px';\r\n  \t},\r\n\r\n  \t_getAnchor: function () {\r\n  \t\treturn [0, 0];\r\n  \t}\r\n\r\n  });\r\n\r\n  Map.include({\r\n  \t_initOverlay: function (OverlayClass, content, latlng, options) {\r\n  \t\tvar overlay = content;\r\n  \t\tif (!(overlay instanceof OverlayClass)) {\r\n  \t\t\toverlay = new OverlayClass(options).setContent(content);\r\n  \t\t}\r\n  \t\tif (latlng) {\r\n  \t\t\toverlay.setLatLng(latlng);\r\n  \t\t}\r\n  \t\treturn overlay;\r\n  \t}\r\n  });\r\n\r\n\r\n  Layer.include({\r\n  \t_initOverlay: function (OverlayClass, old, content, options) {\r\n  \t\tvar overlay = content;\r\n  \t\tif (overlay instanceof OverlayClass) {\r\n  \t\t\tsetOptions(overlay, options);\r\n  \t\t\toverlay._source = this;\r\n  \t\t} else {\r\n  \t\t\toverlay = (old && !options) ? old : new OverlayClass(options, this);\r\n  \t\t\toverlay.setContent(content);\r\n  \t\t}\r\n  \t\treturn overlay;\r\n  \t}\r\n  });\n\n  /*\r\n   * @class Popup\r\n   * @inherits DivOverlay\r\n   * @aka L.Popup\r\n   * Used to open popups in certain places of the map. Use [Map.openPopup](#map-openpopup) to\r\n   * open popups while making sure that only one popup is open at one time\r\n   * (recommended for usability), or use [Map.addLayer](#map-addlayer) to open as many as you want.\r\n   *\r\n   * @example\r\n   *\r\n   * If you want to just bind a popup to marker click and then open it, it's really easy:\r\n   *\r\n   * ```js\r\n   * marker.bindPopup(popupContent).openPopup();\r\n   * ```\r\n   * Path overlays like polylines also have a `bindPopup` method.\r\n   *\r\n   * A popup can be also standalone:\r\n   *\r\n   * ```js\r\n   * var popup = L.popup()\r\n   * \t.setLatLng(latlng)\r\n   * \t.setContent('<p>Hello world!<br />This is a nice popup.</p>')\r\n   * \t.openOn(map);\r\n   * ```\r\n   * or\r\n   * ```js\r\n   * var popup = L.popup(latlng, {content: '<p>Hello world!<br />This is a nice popup.</p>')\r\n   * \t.openOn(map);\r\n   * ```\r\n   */\r\n\r\n\r\n  // @namespace Popup\r\n  var Popup = DivOverlay.extend({\r\n\r\n  \t// @section\r\n  \t// @aka Popup options\r\n  \toptions: {\r\n  \t\t// @option pane: String = 'popupPane'\r\n  \t\t// `Map pane` where the popup will be added.\r\n  \t\tpane: 'popupPane',\r\n\r\n  \t\t// @option offset: Point = Point(0, 7)\r\n  \t\t// The offset of the popup position.\r\n  \t\toffset: [0, 7],\r\n\r\n  \t\t// @option maxWidth: Number = 300\r\n  \t\t// Max width of the popup, in pixels.\r\n  \t\tmaxWidth: 300,\r\n\r\n  \t\t// @option minWidth: Number = 50\r\n  \t\t// Min width of the popup, in pixels.\r\n  \t\tminWidth: 50,\r\n\r\n  \t\t// @option maxHeight: Number = null\r\n  \t\t// If set, creates a scrollable container of the given height\r\n  \t\t// inside a popup if its content exceeds it.\r\n  \t\t// The scrollable container can be styled using the\r\n  \t\t// `leaflet-popup-scrolled` CSS class selector.\r\n  \t\tmaxHeight: null,\r\n\r\n  \t\t// @option autoPan: Boolean = true\r\n  \t\t// Set it to `false` if you don't want the map to do panning animation\r\n  \t\t// to fit the opened popup.\r\n  \t\tautoPan: true,\r\n\r\n  \t\t// @option autoPanPaddingTopLeft: Point = null\r\n  \t\t// The margin between the popup and the top left corner of the map\r\n  \t\t// view after autopanning was performed.\r\n  \t\tautoPanPaddingTopLeft: null,\r\n\r\n  \t\t// @option autoPanPaddingBottomRight: Point = null\r\n  \t\t// The margin between the popup and the bottom right corner of the map\r\n  \t\t// view after autopanning was performed.\r\n  \t\tautoPanPaddingBottomRight: null,\r\n\r\n  \t\t// @option autoPanPadding: Point = Point(5, 5)\r\n  \t\t// Equivalent of setting both top left and bottom right autopan padding to the same value.\r\n  \t\tautoPanPadding: [5, 5],\r\n\r\n  \t\t// @option keepInView: Boolean = false\r\n  \t\t// Set it to `true` if you want to prevent users from panning the popup\r\n  \t\t// off of the screen while it is open.\r\n  \t\tkeepInView: false,\r\n\r\n  \t\t// @option closeButton: Boolean = true\r\n  \t\t// Controls the presence of a close button in the popup.\r\n  \t\tcloseButton: true,\r\n\r\n  \t\t// @option autoClose: Boolean = true\r\n  \t\t// Set it to `false` if you want to override the default behavior of\r\n  \t\t// the popup closing when another popup is opened.\r\n  \t\tautoClose: true,\r\n\r\n  \t\t// @option closeOnEscapeKey: Boolean = true\r\n  \t\t// Set it to `false` if you want to override the default behavior of\r\n  \t\t// the ESC key for closing of the popup.\r\n  \t\tcloseOnEscapeKey: true,\r\n\r\n  \t\t// @option closeOnClick: Boolean = *\r\n  \t\t// Set it if you want to override the default behavior of the popup closing when user clicks\r\n  \t\t// on the map. Defaults to the map's [`closePopupOnClick`](#map-closepopuponclick) option.\r\n\r\n  \t\t// @option className: String = ''\r\n  \t\t// A custom CSS class name to assign to the popup.\r\n  \t\tclassName: ''\r\n  \t},\r\n\r\n  \t// @namespace Popup\r\n  \t// @method openOn(map: Map): this\r\n  \t// Alternative to `map.openPopup(popup)`.\r\n  \t// Adds the popup to the map and closes the previous one.\r\n  \topenOn: function (map) {\r\n  \t\tmap = arguments.length ? map : this._source._map; // experimental, not the part of public api\r\n\r\n  \t\tif (!map.hasLayer(this) && map._popup && map._popup.options.autoClose) {\r\n  \t\t\tmap.removeLayer(map._popup);\r\n  \t\t}\r\n  \t\tmap._popup = this;\r\n\r\n  \t\treturn DivOverlay.prototype.openOn.call(this, map);\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tDivOverlay.prototype.onAdd.call(this, map);\r\n\r\n  \t\t// @namespace Map\r\n  \t\t// @section Popup events\r\n  \t\t// @event popupopen: PopupEvent\r\n  \t\t// Fired when a popup is opened in the map\r\n  \t\tmap.fire('popupopen', {popup: this});\r\n\r\n  \t\tif (this._source) {\r\n  \t\t\t// @namespace Layer\r\n  \t\t\t// @section Popup events\r\n  \t\t\t// @event popupopen: PopupEvent\r\n  \t\t\t// Fired when a popup bound to this layer is opened\r\n  \t\t\tthis._source.fire('popupopen', {popup: this}, true);\r\n  \t\t\t// For non-path layers, we toggle the popup when clicking\r\n  \t\t\t// again the layer, so prevent the map to reopen it.\r\n  \t\t\tif (!(this._source instanceof Path)) {\r\n  \t\t\t\tthis._source.on('preclick', stopPropagation);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t},\r\n\r\n  \tonRemove: function (map) {\r\n  \t\tDivOverlay.prototype.onRemove.call(this, map);\r\n\r\n  \t\t// @namespace Map\r\n  \t\t// @section Popup events\r\n  \t\t// @event popupclose: PopupEvent\r\n  \t\t// Fired when a popup in the map is closed\r\n  \t\tmap.fire('popupclose', {popup: this});\r\n\r\n  \t\tif (this._source) {\r\n  \t\t\t// @namespace Layer\r\n  \t\t\t// @section Popup events\r\n  \t\t\t// @event popupclose: PopupEvent\r\n  \t\t\t// Fired when a popup bound to this layer is closed\r\n  \t\t\tthis._source.fire('popupclose', {popup: this}, true);\r\n  \t\t\tif (!(this._source instanceof Path)) {\r\n  \t\t\t\tthis._source.off('preclick', stopPropagation);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t},\r\n\r\n  \tgetEvents: function () {\r\n  \t\tvar events = DivOverlay.prototype.getEvents.call(this);\r\n\r\n  \t\tif (this.options.closeOnClick !== undefined ? this.options.closeOnClick : this._map.options.closePopupOnClick) {\r\n  \t\t\tevents.preclick = this.close;\r\n  \t\t}\r\n\r\n  \t\tif (this.options.keepInView) {\r\n  \t\t\tevents.moveend = this._adjustPan;\r\n  \t\t}\r\n\r\n  \t\treturn events;\r\n  \t},\r\n\r\n  \t_initLayout: function () {\r\n  \t\tvar prefix = 'leaflet-popup',\r\n  \t\t    container = this._container = create$1('div',\r\n  \t\t\tprefix + ' ' + (this.options.className || '') +\r\n  \t\t\t' leaflet-zoom-animated');\r\n\r\n  \t\tvar wrapper = this._wrapper = create$1('div', prefix + '-content-wrapper', container);\r\n  \t\tthis._contentNode = create$1('div', prefix + '-content', wrapper);\r\n\r\n  \t\tdisableClickPropagation(container);\r\n  \t\tdisableScrollPropagation(this._contentNode);\r\n  \t\ton(container, 'contextmenu', stopPropagation);\r\n\r\n  \t\tthis._tipContainer = create$1('div', prefix + '-tip-container', container);\r\n  \t\tthis._tip = create$1('div', prefix + '-tip', this._tipContainer);\r\n\r\n  \t\tif (this.options.closeButton) {\r\n  \t\t\tvar closeButton = this._closeButton = create$1('a', prefix + '-close-button', container);\r\n  \t\t\tcloseButton.setAttribute('role', 'button'); // overrides the implicit role=link of <a> elements #7399\r\n  \t\t\tcloseButton.setAttribute('aria-label', 'Close popup');\r\n  \t\t\tcloseButton.href = '#close';\r\n  \t\t\tcloseButton.innerHTML = '<span aria-hidden=\"true\">&#215;</span>';\r\n\r\n  \t\t\ton(closeButton, 'click', function (ev) {\r\n  \t\t\t\tpreventDefault(ev);\r\n  \t\t\t\tthis.close();\r\n  \t\t\t}, this);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_updateLayout: function () {\r\n  \t\tvar container = this._contentNode,\r\n  \t\t    style = container.style;\r\n\r\n  \t\tstyle.width = '';\r\n  \t\tstyle.whiteSpace = 'nowrap';\r\n\r\n  \t\tvar width = container.offsetWidth;\r\n  \t\twidth = Math.min(width, this.options.maxWidth);\r\n  \t\twidth = Math.max(width, this.options.minWidth);\r\n\r\n  \t\tstyle.width = (width + 1) + 'px';\r\n  \t\tstyle.whiteSpace = '';\r\n\r\n  \t\tstyle.height = '';\r\n\r\n  \t\tvar height = container.offsetHeight,\r\n  \t\t    maxHeight = this.options.maxHeight,\r\n  \t\t    scrolledClass = 'leaflet-popup-scrolled';\r\n\r\n  \t\tif (maxHeight && height > maxHeight) {\r\n  \t\t\tstyle.height = maxHeight + 'px';\r\n  \t\t\taddClass(container, scrolledClass);\r\n  \t\t} else {\r\n  \t\t\tremoveClass(container, scrolledClass);\r\n  \t\t}\r\n\r\n  \t\tthis._containerWidth = this._container.offsetWidth;\r\n  \t},\r\n\r\n  \t_animateZoom: function (e) {\r\n  \t\tvar pos = this._map._latLngToNewLayerPoint(this._latlng, e.zoom, e.center),\r\n  \t\t    anchor = this._getAnchor();\r\n  \t\tsetPosition(this._container, pos.add(anchor));\r\n  \t},\r\n\r\n  \t_adjustPan: function () {\r\n  \t\tif (!this.options.autoPan) { return; }\r\n  \t\tif (this._map._panAnim) { this._map._panAnim.stop(); }\r\n\r\n  \t\t// We can endlessly recurse if keepInView is set and the view resets.\r\n  \t\t// Let's guard against that by exiting early if we're responding to our own autopan.\r\n  \t\tif (this._autopanning) {\r\n  \t\t\tthis._autopanning = false;\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tvar map = this._map,\r\n  \t\t    marginBottom = parseInt(getStyle(this._container, 'marginBottom'), 10) || 0,\r\n  \t\t    containerHeight = this._container.offsetHeight + marginBottom,\r\n  \t\t    containerWidth = this._containerWidth,\r\n  \t\t    layerPos = new Point(this._containerLeft, -containerHeight - this._containerBottom);\r\n\r\n  \t\tlayerPos._add(getPosition(this._container));\r\n\r\n  \t\tvar containerPos = map.layerPointToContainerPoint(layerPos),\r\n  \t\t    padding = toPoint(this.options.autoPanPadding),\r\n  \t\t    paddingTL = toPoint(this.options.autoPanPaddingTopLeft || padding),\r\n  \t\t    paddingBR = toPoint(this.options.autoPanPaddingBottomRight || padding),\r\n  \t\t    size = map.getSize(),\r\n  \t\t    dx = 0,\r\n  \t\t    dy = 0;\r\n\r\n  \t\tif (containerPos.x + containerWidth + paddingBR.x > size.x) { // right\r\n  \t\t\tdx = containerPos.x + containerWidth - size.x + paddingBR.x;\r\n  \t\t}\r\n  \t\tif (containerPos.x - dx - paddingTL.x < 0) { // left\r\n  \t\t\tdx = containerPos.x - paddingTL.x;\r\n  \t\t}\r\n  \t\tif (containerPos.y + containerHeight + paddingBR.y > size.y) { // bottom\r\n  \t\t\tdy = containerPos.y + containerHeight - size.y + paddingBR.y;\r\n  \t\t}\r\n  \t\tif (containerPos.y - dy - paddingTL.y < 0) { // top\r\n  \t\t\tdy = containerPos.y - paddingTL.y;\r\n  \t\t}\r\n\r\n  \t\t// @namespace Map\r\n  \t\t// @section Popup events\r\n  \t\t// @event autopanstart: Event\r\n  \t\t// Fired when the map starts autopanning when opening a popup.\r\n  \t\tif (dx || dy) {\r\n  \t\t\t// Track that we're autopanning, as this function will be re-ran on moveend\r\n  \t\t\tif (this.options.keepInView) {\r\n  \t\t\t\tthis._autopanning = true;\r\n  \t\t\t}\r\n\r\n  \t\t\tmap\r\n  \t\t\t    .fire('autopanstart')\r\n  \t\t\t    .panBy([dx, dy]);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_getAnchor: function () {\r\n  \t\t// Where should we anchor the popup on the source layer?\r\n  \t\treturn toPoint(this._source && this._source._getPopupAnchor ? this._source._getPopupAnchor() : [0, 0]);\r\n  \t}\r\n\r\n  });\r\n\r\n  // @namespace Popup\r\n  // @factory L.popup(options?: Popup options, source?: Layer)\r\n  // Instantiates a `Popup` object given an optional `options` object that describes its appearance and location and an optional `source` object that is used to tag the popup with a reference to the Layer to which it refers.\r\n  // @alternative\r\n  // @factory L.popup(latlng: LatLng, options?: Popup options)\r\n  // Instantiates a `Popup` object given `latlng` where the popup will open and an optional `options` object that describes its appearance and location.\r\n  var popup = function (options, source) {\r\n  \treturn new Popup(options, source);\r\n  };\r\n\r\n\r\n  /* @namespace Map\r\n   * @section Interaction Options\r\n   * @option closePopupOnClick: Boolean = true\r\n   * Set it to `false` if you don't want popups to close when user clicks the map.\r\n   */\r\n  Map.mergeOptions({\r\n  \tclosePopupOnClick: true\r\n  });\r\n\r\n\r\n  // @namespace Map\r\n  // @section Methods for Layers and Controls\r\n  Map.include({\r\n  \t// @method openPopup(popup: Popup): this\r\n  \t// Opens the specified popup while closing the previously opened (to make sure only one is opened at one time for usability).\r\n  \t// @alternative\r\n  \t// @method openPopup(content: String|HTMLElement, latlng: LatLng, options?: Popup options): this\r\n  \t// Creates a popup with the specified content and options and opens it in the given point on a map.\r\n  \topenPopup: function (popup, latlng, options) {\r\n  \t\tthis._initOverlay(Popup, popup, latlng, options)\r\n  \t\t  .openOn(this);\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method closePopup(popup?: Popup): this\r\n  \t// Closes the popup previously opened with [openPopup](#map-openpopup) (or the given one).\r\n  \tclosePopup: function (popup) {\r\n  \t\tpopup = arguments.length ? popup : this._popup;\r\n  \t\tif (popup) {\r\n  \t\t\tpopup.close();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t}\r\n  });\r\n\r\n  /*\r\n   * @namespace Layer\r\n   * @section Popup methods example\r\n   *\r\n   * All layers share a set of methods convenient for binding popups to it.\r\n   *\r\n   * ```js\r\n   * var layer = L.Polygon(latlngs).bindPopup('Hi There!').addTo(map);\r\n   * layer.openPopup();\r\n   * layer.closePopup();\r\n   * ```\r\n   *\r\n   * Popups will also be automatically opened when the layer is clicked on and closed when the layer is removed from the map or another popup is opened.\r\n   */\r\n\r\n  // @section Popup methods\r\n  Layer.include({\r\n\r\n  \t// @method bindPopup(content: String|HTMLElement|Function|Popup, options?: Popup options): this\r\n  \t// Binds a popup to the layer with the passed `content` and sets up the\r\n  \t// necessary event listeners. If a `Function` is passed it will receive\r\n  \t// the layer as the first argument and should return a `String` or `HTMLElement`.\r\n  \tbindPopup: function (content, options) {\r\n  \t\tthis._popup = this._initOverlay(Popup, this._popup, content, options);\r\n  \t\tif (!this._popupHandlersAdded) {\r\n  \t\t\tthis.on({\r\n  \t\t\t\tclick: this._openPopup,\r\n  \t\t\t\tkeypress: this._onKeyPress,\r\n  \t\t\t\tremove: this.closePopup,\r\n  \t\t\t\tmove: this._movePopup\r\n  \t\t\t});\r\n  \t\t\tthis._popupHandlersAdded = true;\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method unbindPopup(): this\r\n  \t// Removes the popup previously bound with `bindPopup`.\r\n  \tunbindPopup: function () {\r\n  \t\tif (this._popup) {\r\n  \t\t\tthis.off({\r\n  \t\t\t\tclick: this._openPopup,\r\n  \t\t\t\tkeypress: this._onKeyPress,\r\n  \t\t\t\tremove: this.closePopup,\r\n  \t\t\t\tmove: this._movePopup\r\n  \t\t\t});\r\n  \t\t\tthis._popupHandlersAdded = false;\r\n  \t\t\tthis._popup = null;\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method openPopup(latlng?: LatLng): this\r\n  \t// Opens the bound popup at the specified `latlng` or at the default popup anchor if no `latlng` is passed.\r\n  \topenPopup: function (latlng) {\r\n  \t\tif (this._popup) {\r\n  \t\t\tif (!(this instanceof FeatureGroup)) {\r\n  \t\t\t\tthis._popup._source = this;\r\n  \t\t\t}\r\n  \t\t\tif (this._popup._prepareOpen(latlng || this._latlng)) {\r\n  \t\t\t\t// open the popup on the map\r\n  \t\t\t\tthis._popup.openOn(this._map);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method closePopup(): this\r\n  \t// Closes the popup bound to this layer if it is open.\r\n  \tclosePopup: function () {\r\n  \t\tif (this._popup) {\r\n  \t\t\tthis._popup.close();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method togglePopup(): this\r\n  \t// Opens or closes the popup bound to this layer depending on its current state.\r\n  \ttogglePopup: function () {\r\n  \t\tif (this._popup) {\r\n  \t\t\tthis._popup.toggle(this);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method isPopupOpen(): boolean\r\n  \t// Returns `true` if the popup bound to this layer is currently open.\r\n  \tisPopupOpen: function () {\r\n  \t\treturn (this._popup ? this._popup.isOpen() : false);\r\n  \t},\r\n\r\n  \t// @method setPopupContent(content: String|HTMLElement|Popup): this\r\n  \t// Sets the content of the popup bound to this layer.\r\n  \tsetPopupContent: function (content) {\r\n  \t\tif (this._popup) {\r\n  \t\t\tthis._popup.setContent(content);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getPopup(): Popup\r\n  \t// Returns the popup bound to this layer.\r\n  \tgetPopup: function () {\r\n  \t\treturn this._popup;\r\n  \t},\r\n\r\n  \t_openPopup: function (e) {\r\n  \t\tif (!this._popup || !this._map) {\r\n  \t\t\treturn;\r\n  \t\t}\r\n  \t\t// prevent map click\r\n  \t\tstop(e);\r\n\r\n  \t\tvar target = e.layer || e.target;\r\n  \t\tif (this._popup._source === target && !(target instanceof Path)) {\r\n  \t\t\t// treat it like a marker and figure out\r\n  \t\t\t// if we should toggle it open/closed\r\n  \t\t\tif (this._map.hasLayer(this._popup)) {\r\n  \t\t\t\tthis.closePopup();\r\n  \t\t\t} else {\r\n  \t\t\t\tthis.openPopup(e.latlng);\r\n  \t\t\t}\r\n  \t\t\treturn;\r\n  \t\t}\r\n  \t\tthis._popup._source = target;\r\n  \t\tthis.openPopup(e.latlng);\r\n  \t},\r\n\r\n  \t_movePopup: function (e) {\r\n  \t\tthis._popup.setLatLng(e.latlng);\r\n  \t},\r\n\r\n  \t_onKeyPress: function (e) {\r\n  \t\tif (e.originalEvent.keyCode === 13) {\r\n  \t\t\tthis._openPopup(e);\r\n  \t\t}\r\n  \t}\r\n  });\n\n  /*\n   * @class Tooltip\n   * @inherits DivOverlay\n   * @aka L.Tooltip\n   * Used to display small texts on top of map layers.\n   *\n   * @example\n   * If you want to just bind a tooltip to marker:\n   *\n   * ```js\n   * marker.bindTooltip(\"my tooltip text\").openTooltip();\n   * ```\n   * Path overlays like polylines also have a `bindTooltip` method.\n   *\n   * A tooltip can be also standalone:\n   *\n   * ```js\n   * var tooltip = L.tooltip()\n   * \t.setLatLng(latlng)\n   * \t.setContent('Hello world!<br />This is a nice tooltip.')\n   * \t.addTo(map);\n   * ```\n   * or\n   * ```js\n   * var tooltip = L.tooltip(latlng, {content: 'Hello world!<br />This is a nice tooltip.'})\n   * \t.addTo(map);\n   * ```\n   *\n   *\n   * Note about tooltip offset. Leaflet takes two options in consideration\n   * for computing tooltip offsetting:\n   * - the `offset` Tooltip option: it defaults to [0, 0], and it's specific to one tooltip.\n   *   Add a positive x offset to move the tooltip to the right, and a positive y offset to\n   *   move it to the bottom. Negatives will move to the left and top.\n   * - the `tooltipAnchor` Icon option: this will only be considered for Marker. You\n   *   should adapt this value if you use a custom icon.\n   */\n\n\n  // @namespace Tooltip\n  var Tooltip = DivOverlay.extend({\n\n  \t// @section\n  \t// @aka Tooltip options\n  \toptions: {\n  \t\t// @option pane: String = 'tooltipPane'\n  \t\t// `Map pane` where the tooltip will be added.\n  \t\tpane: 'tooltipPane',\n\n  \t\t// @option offset: Point = Point(0, 0)\n  \t\t// Optional offset of the tooltip position.\n  \t\toffset: [0, 0],\n\n  \t\t// @option direction: String = 'auto'\n  \t\t// Direction where to open the tooltip. Possible values are: `right`, `left`,\n  \t\t// `top`, `bottom`, `center`, `auto`.\n  \t\t// `auto` will dynamically switch between `right` and `left` according to the tooltip\n  \t\t// position on the map.\n  \t\tdirection: 'auto',\n\n  \t\t// @option permanent: Boolean = false\n  \t\t// Whether to open the tooltip permanently or only on mouseover.\n  \t\tpermanent: false,\n\n  \t\t// @option sticky: Boolean = false\n  \t\t// If true, the tooltip will follow the mouse instead of being fixed at the feature center.\n  \t\tsticky: false,\n\n  \t\t// @option opacity: Number = 0.9\n  \t\t// Tooltip container opacity.\n  \t\topacity: 0.9\n  \t},\n\n  \tonAdd: function (map) {\n  \t\tDivOverlay.prototype.onAdd.call(this, map);\n  \t\tthis.setOpacity(this.options.opacity);\n\n  \t\t// @namespace Map\n  \t\t// @section Tooltip events\n  \t\t// @event tooltipopen: TooltipEvent\n  \t\t// Fired when a tooltip is opened in the map.\n  \t\tmap.fire('tooltipopen', {tooltip: this});\n\n  \t\tif (this._source) {\n  \t\t\tthis.addEventParent(this._source);\n\n  \t\t\t// @namespace Layer\n  \t\t\t// @section Tooltip events\n  \t\t\t// @event tooltipopen: TooltipEvent\n  \t\t\t// Fired when a tooltip bound to this layer is opened.\n  \t\t\tthis._source.fire('tooltipopen', {tooltip: this}, true);\n  \t\t}\n  \t},\n\n  \tonRemove: function (map) {\n  \t\tDivOverlay.prototype.onRemove.call(this, map);\n\n  \t\t// @namespace Map\n  \t\t// @section Tooltip events\n  \t\t// @event tooltipclose: TooltipEvent\n  \t\t// Fired when a tooltip in the map is closed.\n  \t\tmap.fire('tooltipclose', {tooltip: this});\n\n  \t\tif (this._source) {\n  \t\t\tthis.removeEventParent(this._source);\n\n  \t\t\t// @namespace Layer\n  \t\t\t// @section Tooltip events\n  \t\t\t// @event tooltipclose: TooltipEvent\n  \t\t\t// Fired when a tooltip bound to this layer is closed.\n  \t\t\tthis._source.fire('tooltipclose', {tooltip: this}, true);\n  \t\t}\n  \t},\n\n  \tgetEvents: function () {\n  \t\tvar events = DivOverlay.prototype.getEvents.call(this);\n\n  \t\tif (!this.options.permanent) {\n  \t\t\tevents.preclick = this.close;\n  \t\t}\n\n  \t\treturn events;\n  \t},\n\n  \t_initLayout: function () {\n  \t\tvar prefix = 'leaflet-tooltip',\n  \t\t    className = prefix + ' ' + (this.options.className || '') + ' leaflet-zoom-' + (this._zoomAnimated ? 'animated' : 'hide');\n\n  \t\tthis._contentNode = this._container = create$1('div', className);\n\n  \t\tthis._container.setAttribute('role', 'tooltip');\n  \t\tthis._container.setAttribute('id', 'leaflet-tooltip-' + stamp(this));\n  \t},\n\n  \t_updateLayout: function () {},\n\n  \t_adjustPan: function () {},\n\n  \t_setPosition: function (pos) {\n  \t\tvar subX, subY,\n  \t\t    map = this._map,\n  \t\t    container = this._container,\n  \t\t    centerPoint = map.latLngToContainerPoint(map.getCenter()),\n  \t\t    tooltipPoint = map.layerPointToContainerPoint(pos),\n  \t\t    direction = this.options.direction,\n  \t\t    tooltipWidth = container.offsetWidth,\n  \t\t    tooltipHeight = container.offsetHeight,\n  \t\t    offset = toPoint(this.options.offset),\n  \t\t    anchor = this._getAnchor();\n\n  \t\tif (direction === 'top') {\n  \t\t\tsubX = tooltipWidth / 2;\n  \t\t\tsubY = tooltipHeight;\n  \t\t} else if (direction === 'bottom') {\n  \t\t\tsubX = tooltipWidth / 2;\n  \t\t\tsubY = 0;\n  \t\t} else if (direction === 'center') {\n  \t\t\tsubX = tooltipWidth / 2;\n  \t\t\tsubY = tooltipHeight / 2;\n  \t\t} else if (direction === 'right') {\n  \t\t\tsubX = 0;\n  \t\t\tsubY = tooltipHeight / 2;\n  \t\t} else if (direction === 'left') {\n  \t\t\tsubX = tooltipWidth;\n  \t\t\tsubY = tooltipHeight / 2;\n  \t\t} else if (tooltipPoint.x < centerPoint.x) {\n  \t\t\tdirection = 'right';\n  \t\t\tsubX = 0;\n  \t\t\tsubY = tooltipHeight / 2;\n  \t\t} else {\n  \t\t\tdirection = 'left';\n  \t\t\tsubX = tooltipWidth + (offset.x + anchor.x) * 2;\n  \t\t\tsubY = tooltipHeight / 2;\n  \t\t}\n\n  \t\tpos = pos.subtract(toPoint(subX, subY, true)).add(offset).add(anchor);\n\n  \t\tremoveClass(container, 'leaflet-tooltip-right');\n  \t\tremoveClass(container, 'leaflet-tooltip-left');\n  \t\tremoveClass(container, 'leaflet-tooltip-top');\n  \t\tremoveClass(container, 'leaflet-tooltip-bottom');\n  \t\taddClass(container, 'leaflet-tooltip-' + direction);\n  \t\tsetPosition(container, pos);\n  \t},\n\n  \t_updatePosition: function () {\n  \t\tvar pos = this._map.latLngToLayerPoint(this._latlng);\n  \t\tthis._setPosition(pos);\n  \t},\n\n  \tsetOpacity: function (opacity) {\n  \t\tthis.options.opacity = opacity;\n\n  \t\tif (this._container) {\n  \t\t\tsetOpacity(this._container, opacity);\n  \t\t}\n  \t},\n\n  \t_animateZoom: function (e) {\n  \t\tvar pos = this._map._latLngToNewLayerPoint(this._latlng, e.zoom, e.center);\n  \t\tthis._setPosition(pos);\n  \t},\n\n  \t_getAnchor: function () {\n  \t\t// Where should we anchor the tooltip on the source layer?\n  \t\treturn toPoint(this._source && this._source._getTooltipAnchor && !this.options.sticky ? this._source._getTooltipAnchor() : [0, 0]);\n  \t}\n\n  });\n\n  // @namespace Tooltip\n  // @factory L.tooltip(options?: Tooltip options, source?: Layer)\n  // Instantiates a `Tooltip` object given an optional `options` object that describes its appearance and location and an optional `source` object that is used to tag the tooltip with a reference to the Layer to which it refers.\n  // @alternative\n  // @factory L.tooltip(latlng: LatLng, options?: Tooltip options)\n  // Instantiates a `Tooltip` object given `latlng` where the tooltip will open and an optional `options` object that describes its appearance and location.\n  var tooltip = function (options, source) {\n  \treturn new Tooltip(options, source);\n  };\n\n  // @namespace Map\n  // @section Methods for Layers and Controls\n  Map.include({\n\n  \t// @method openTooltip(tooltip: Tooltip): this\n  \t// Opens the specified tooltip.\n  \t// @alternative\n  \t// @method openTooltip(content: String|HTMLElement, latlng: LatLng, options?: Tooltip options): this\n  \t// Creates a tooltip with the specified content and options and open it.\n  \topenTooltip: function (tooltip, latlng, options) {\n  \t\tthis._initOverlay(Tooltip, tooltip, latlng, options)\n  \t\t  .openOn(this);\n\n  \t\treturn this;\n  \t},\n\n  \t// @method closeTooltip(tooltip: Tooltip): this\n  \t// Closes the tooltip given as parameter.\n  \tcloseTooltip: function (tooltip) {\n  \t\ttooltip.close();\n  \t\treturn this;\n  \t}\n\n  });\n\n  /*\n   * @namespace Layer\n   * @section Tooltip methods example\n   *\n   * All layers share a set of methods convenient for binding tooltips to it.\n   *\n   * ```js\n   * var layer = L.Polygon(latlngs).bindTooltip('Hi There!').addTo(map);\n   * layer.openTooltip();\n   * layer.closeTooltip();\n   * ```\n   */\n\n  // @section Tooltip methods\n  Layer.include({\n\n  \t// @method bindTooltip(content: String|HTMLElement|Function|Tooltip, options?: Tooltip options): this\n  \t// Binds a tooltip to the layer with the passed `content` and sets up the\n  \t// necessary event listeners. If a `Function` is passed it will receive\n  \t// the layer as the first argument and should return a `String` or `HTMLElement`.\n  \tbindTooltip: function (content, options) {\n\n  \t\tif (this._tooltip && this.isTooltipOpen()) {\n  \t\t\tthis.unbindTooltip();\n  \t\t}\n\n  \t\tthis._tooltip = this._initOverlay(Tooltip, this._tooltip, content, options);\n  \t\tthis._initTooltipInteractions();\n\n  \t\tif (this._tooltip.options.permanent && this._map && this._map.hasLayer(this)) {\n  \t\t\tthis.openTooltip();\n  \t\t}\n\n  \t\treturn this;\n  \t},\n\n  \t// @method unbindTooltip(): this\n  \t// Removes the tooltip previously bound with `bindTooltip`.\n  \tunbindTooltip: function () {\n  \t\tif (this._tooltip) {\n  \t\t\tthis._initTooltipInteractions(true);\n  \t\t\tthis.closeTooltip();\n  \t\t\tthis._tooltip = null;\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t_initTooltipInteractions: function (remove) {\n  \t\tif (!remove && this._tooltipHandlersAdded) { return; }\n  \t\tvar onOff = remove ? 'off' : 'on',\n  \t\t    events = {\n  \t\t\tremove: this.closeTooltip,\n  \t\t\tmove: this._moveTooltip\n  \t\t    };\n  \t\tif (!this._tooltip.options.permanent) {\n  \t\t\tevents.mouseover = this._openTooltip;\n  \t\t\tevents.mouseout = this.closeTooltip;\n  \t\t\tevents.click = this._openTooltip;\n  \t\t\tif (this._map) {\n  \t\t\t\tthis._addFocusListeners();\n  \t\t\t} else {\n  \t\t\t\tevents.add = this._addFocusListeners;\n  \t\t\t}\n  \t\t} else {\n  \t\t\tevents.add = this._openTooltip;\n  \t\t}\n  \t\tif (this._tooltip.options.sticky) {\n  \t\t\tevents.mousemove = this._moveTooltip;\n  \t\t}\n  \t\tthis[onOff](events);\n  \t\tthis._tooltipHandlersAdded = !remove;\n  \t},\n\n  \t// @method openTooltip(latlng?: LatLng): this\n  \t// Opens the bound tooltip at the specified `latlng` or at the default tooltip anchor if no `latlng` is passed.\n  \topenTooltip: function (latlng) {\n  \t\tif (this._tooltip) {\n  \t\t\tif (!(this instanceof FeatureGroup)) {\n  \t\t\t\tthis._tooltip._source = this;\n  \t\t\t}\n  \t\t\tif (this._tooltip._prepareOpen(latlng)) {\n  \t\t\t\t// open the tooltip on the map\n  \t\t\t\tthis._tooltip.openOn(this._map);\n\n  \t\t\t\tif (this.getElement) {\n  \t\t\t\t\tthis._setAriaDescribedByOnLayer(this);\n  \t\t\t\t} else if (this.eachLayer) {\n  \t\t\t\t\tthis.eachLayer(this._setAriaDescribedByOnLayer, this);\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method closeTooltip(): this\n  \t// Closes the tooltip bound to this layer if it is open.\n  \tcloseTooltip: function () {\n  \t\tif (this._tooltip) {\n  \t\t\treturn this._tooltip.close();\n  \t\t}\n  \t},\n\n  \t// @method toggleTooltip(): this\n  \t// Opens or closes the tooltip bound to this layer depending on its current state.\n  \ttoggleTooltip: function () {\n  \t\tif (this._tooltip) {\n  \t\t\tthis._tooltip.toggle(this);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method isTooltipOpen(): boolean\n  \t// Returns `true` if the tooltip bound to this layer is currently open.\n  \tisTooltipOpen: function () {\n  \t\treturn this._tooltip.isOpen();\n  \t},\n\n  \t// @method setTooltipContent(content: String|HTMLElement|Tooltip): this\n  \t// Sets the content of the tooltip bound to this layer.\n  \tsetTooltipContent: function (content) {\n  \t\tif (this._tooltip) {\n  \t\t\tthis._tooltip.setContent(content);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method getTooltip(): Tooltip\n  \t// Returns the tooltip bound to this layer.\n  \tgetTooltip: function () {\n  \t\treturn this._tooltip;\n  \t},\n\n  \t_addFocusListeners: function () {\n  \t\tif (this.getElement) {\n  \t\t\tthis._addFocusListenersOnLayer(this);\n  \t\t} else if (this.eachLayer) {\n  \t\t\tthis.eachLayer(this._addFocusListenersOnLayer, this);\n  \t\t}\n  \t},\n\n  \t_addFocusListenersOnLayer: function (layer) {\n  \t\tvar el = layer.getElement();\n  \t\tif (el) {\n  \t\t\ton(el, 'focus', function () {\n  \t\t\t\tthis._tooltip._source = layer;\n  \t\t\t\tthis.openTooltip();\n  \t\t\t}, this);\n  \t\t\ton(el, 'blur', this.closeTooltip, this);\n  \t\t}\n  \t},\n\n  \t_setAriaDescribedByOnLayer: function (layer) {\n  \t\tvar el = layer.getElement();\n  \t\tif (el) {\n  \t\t\tel.setAttribute('aria-describedby', this._tooltip._container.id);\n  \t\t}\n  \t},\n\n\n  \t_openTooltip: function (e) {\n  \t\tif (!this._tooltip || !this._map || (this._map.dragging && this._map.dragging.moving())) {\n  \t\t\treturn;\n  \t\t}\n  \t\tthis._tooltip._source = e.layer || e.target;\n\n  \t\tthis.openTooltip(this._tooltip.options.sticky ? e.latlng : undefined);\n  \t},\n\n  \t_moveTooltip: function (e) {\n  \t\tvar latlng = e.latlng, containerPoint, layerPoint;\n  \t\tif (this._tooltip.options.sticky && e.originalEvent) {\n  \t\t\tcontainerPoint = this._map.mouseEventToContainerPoint(e.originalEvent);\n  \t\t\tlayerPoint = this._map.containerPointToLayerPoint(containerPoint);\n  \t\t\tlatlng = this._map.layerPointToLatLng(layerPoint);\n  \t\t}\n  \t\tthis._tooltip.setLatLng(latlng);\n  \t}\n  });\n\n  /*\n   * @class DivIcon\n   * @aka L.DivIcon\n   * @inherits Icon\n   *\n   * Represents a lightweight icon for markers that uses a simple `<div>`\n   * element instead of an image. Inherits from `Icon` but ignores the `iconUrl` and shadow options.\n   *\n   * @example\n   * ```js\n   * var myIcon = L.divIcon({className: 'my-div-icon'});\n   * // you can set .my-div-icon styles in CSS\n   *\n   * L.marker([50.505, 30.57], {icon: myIcon}).addTo(map);\n   * ```\n   *\n   * By default, it has a 'leaflet-div-icon' CSS class and is styled as a little white square with a shadow.\n   */\n\n  var DivIcon = Icon.extend({\n  \toptions: {\n  \t\t// @section\n  \t\t// @aka DivIcon options\n  \t\ticonSize: [12, 12], // also can be set through CSS\n\n  \t\t// iconAnchor: (Point),\n  \t\t// popupAnchor: (Point),\n\n  \t\t// @option html: String|HTMLElement = ''\n  \t\t// Custom HTML code to put inside the div element, empty by default. Alternatively,\n  \t\t// an instance of `HTMLElement`.\n  \t\thtml: false,\n\n  \t\t// @option bgPos: Point = [0, 0]\n  \t\t// Optional relative position of the background, in pixels\n  \t\tbgPos: null,\n\n  \t\tclassName: 'leaflet-div-icon'\n  \t},\n\n  \tcreateIcon: function (oldIcon) {\n  \t\tvar div = (oldIcon && oldIcon.tagName === 'DIV') ? oldIcon : document.createElement('div'),\n  \t\t    options = this.options;\n\n  \t\tif (options.html instanceof Element) {\n  \t\t\tempty(div);\n  \t\t\tdiv.appendChild(options.html);\n  \t\t} else {\n  \t\t\tdiv.innerHTML = options.html !== false ? options.html : '';\n  \t\t}\n\n  \t\tif (options.bgPos) {\n  \t\t\tvar bgPos = toPoint(options.bgPos);\n  \t\t\tdiv.style.backgroundPosition = (-bgPos.x) + 'px ' + (-bgPos.y) + 'px';\n  \t\t}\n  \t\tthis._setIconStyles(div, 'icon');\n\n  \t\treturn div;\n  \t},\n\n  \tcreateShadow: function () {\n  \t\treturn null;\n  \t}\n  });\n\n  // @factory L.divIcon(options: DivIcon options)\n  // Creates a `DivIcon` instance with the given options.\n  function divIcon(options) {\n  \treturn new DivIcon(options);\n  }\n\n  Icon.Default = IconDefault;\n\n  /*\n   * @class GridLayer\n   * @inherits Layer\n   * @aka L.GridLayer\n   *\n   * Generic class for handling a tiled grid of HTML elements. This is the base class for all tile layers and replaces `TileLayer.Canvas`.\n   * GridLayer can be extended to create a tiled grid of HTML elements like `<canvas>`, `<img>` or `<div>`. GridLayer will handle creating and animating these DOM elements for you.\n   *\n   *\n   * @section Synchronous usage\n   * @example\n   *\n   * To create a custom layer, extend GridLayer and implement the `createTile()` method, which will be passed a `Point` object with the `x`, `y`, and `z` (zoom level) coordinates to draw your tile.\n   *\n   * ```js\n   * var CanvasLayer = L.GridLayer.extend({\n   *     createTile: function(coords){\n   *         // create a <canvas> element for drawing\n   *         var tile = L.DomUtil.create('canvas', 'leaflet-tile');\n   *\n   *         // setup tile width and height according to the options\n   *         var size = this.getTileSize();\n   *         tile.width = size.x;\n   *         tile.height = size.y;\n   *\n   *         // get a canvas context and draw something on it using coords.x, coords.y and coords.z\n   *         var ctx = tile.getContext('2d');\n   *\n   *         // return the tile so it can be rendered on screen\n   *         return tile;\n   *     }\n   * });\n   * ```\n   *\n   * @section Asynchronous usage\n   * @example\n   *\n   * Tile creation can also be asynchronous, this is useful when using a third-party drawing library. Once the tile is finished drawing it can be passed to the `done()` callback.\n   *\n   * ```js\n   * var CanvasLayer = L.GridLayer.extend({\n   *     createTile: function(coords, done){\n   *         var error;\n   *\n   *         // create a <canvas> element for drawing\n   *         var tile = L.DomUtil.create('canvas', 'leaflet-tile');\n   *\n   *         // setup tile width and height according to the options\n   *         var size = this.getTileSize();\n   *         tile.width = size.x;\n   *         tile.height = size.y;\n   *\n   *         // draw something asynchronously and pass the tile to the done() callback\n   *         setTimeout(function() {\n   *             done(error, tile);\n   *         }, 1000);\n   *\n   *         return tile;\n   *     }\n   * });\n   * ```\n   *\n   * @section\n   */\n\n\n  var GridLayer = Layer.extend({\n\n  \t// @section\n  \t// @aka GridLayer options\n  \toptions: {\n  \t\t// @option tileSize: Number|Point = 256\n  \t\t// Width and height of tiles in the grid. Use a number if width and height are equal, or `L.point(width, height)` otherwise.\n  \t\ttileSize: 256,\n\n  \t\t// @option opacity: Number = 1.0\n  \t\t// Opacity of the tiles. Can be used in the `createTile()` function.\n  \t\topacity: 1,\n\n  \t\t// @option updateWhenIdle: Boolean = (depends)\n  \t\t// Load new tiles only when panning ends.\n  \t\t// `true` by default on mobile browsers, in order to avoid too many requests and keep smooth navigation.\n  \t\t// `false` otherwise in order to display new tiles _during_ panning, since it is easy to pan outside the\n  \t\t// [`keepBuffer`](#gridlayer-keepbuffer) option in desktop browsers.\n  \t\tupdateWhenIdle: Browser.mobile,\n\n  \t\t// @option updateWhenZooming: Boolean = true\n  \t\t// By default, a smooth zoom animation (during a [touch zoom](#map-touchzoom) or a [`flyTo()`](#map-flyto)) will update grid layers every integer zoom level. Setting this option to `false` will update the grid layer only when the smooth animation ends.\n  \t\tupdateWhenZooming: true,\n\n  \t\t// @option updateInterval: Number = 200\n  \t\t// Tiles will not update more than once every `updateInterval` milliseconds when panning.\n  \t\tupdateInterval: 200,\n\n  \t\t// @option zIndex: Number = 1\n  \t\t// The explicit zIndex of the tile layer.\n  \t\tzIndex: 1,\n\n  \t\t// @option bounds: LatLngBounds = undefined\n  \t\t// If set, tiles will only be loaded inside the set `LatLngBounds`.\n  \t\tbounds: null,\n\n  \t\t// @option minZoom: Number = 0\n  \t\t// The minimum zoom level down to which this layer will be displayed (inclusive).\n  \t\tminZoom: 0,\n\n  \t\t// @option maxZoom: Number = undefined\n  \t\t// The maximum zoom level up to which this layer will be displayed (inclusive).\n  \t\tmaxZoom: undefined,\n\n  \t\t// @option maxNativeZoom: Number = undefined\n  \t\t// Maximum zoom number the tile source has available. If it is specified,\n  \t\t// the tiles on all zoom levels higher than `maxNativeZoom` will be loaded\n  \t\t// from `maxNativeZoom` level and auto-scaled.\n  \t\tmaxNativeZoom: undefined,\n\n  \t\t// @option minNativeZoom: Number = undefined\n  \t\t// Minimum zoom number the tile source has available. If it is specified,\n  \t\t// the tiles on all zoom levels lower than `minNativeZoom` will be loaded\n  \t\t// from `minNativeZoom` level and auto-scaled.\n  \t\tminNativeZoom: undefined,\n\n  \t\t// @option noWrap: Boolean = false\n  \t\t// Whether the layer is wrapped around the antimeridian. If `true`, the\n  \t\t// GridLayer will only be displayed once at low zoom levels. Has no\n  \t\t// effect when the [map CRS](#map-crs) doesn't wrap around. Can be used\n  \t\t// in combination with [`bounds`](#gridlayer-bounds) to prevent requesting\n  \t\t// tiles outside the CRS limits.\n  \t\tnoWrap: false,\n\n  \t\t// @option pane: String = 'tilePane'\n  \t\t// `Map pane` where the grid layer will be added.\n  \t\tpane: 'tilePane',\n\n  \t\t// @option className: String = ''\n  \t\t// A custom class name to assign to the tile layer. Empty by default.\n  \t\tclassName: '',\n\n  \t\t// @option keepBuffer: Number = 2\n  \t\t// When panning the map, keep this many rows and columns of tiles before unloading them.\n  \t\tkeepBuffer: 2\n  \t},\n\n  \tinitialize: function (options) {\n  \t\tsetOptions(this, options);\n  \t},\n\n  \tonAdd: function () {\n  \t\tthis._initContainer();\n\n  \t\tthis._levels = {};\n  \t\tthis._tiles = {};\n\n  \t\tthis._resetView(); // implicit _update() call\n  \t},\n\n  \tbeforeAdd: function (map) {\n  \t\tmap._addZoomLimit(this);\n  \t},\n\n  \tonRemove: function (map) {\n  \t\tthis._removeAllTiles();\n  \t\tremove(this._container);\n  \t\tmap._removeZoomLimit(this);\n  \t\tthis._container = null;\n  \t\tthis._tileZoom = undefined;\n  \t},\n\n  \t// @method bringToFront: this\n  \t// Brings the tile layer to the top of all tile layers.\n  \tbringToFront: function () {\n  \t\tif (this._map) {\n  \t\t\ttoFront(this._container);\n  \t\t\tthis._setAutoZIndex(Math.max);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method bringToBack: this\n  \t// Brings the tile layer to the bottom of all tile layers.\n  \tbringToBack: function () {\n  \t\tif (this._map) {\n  \t\t\ttoBack(this._container);\n  \t\t\tthis._setAutoZIndex(Math.min);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method getContainer: HTMLElement\n  \t// Returns the HTML element that contains the tiles for this layer.\n  \tgetContainer: function () {\n  \t\treturn this._container;\n  \t},\n\n  \t// @method setOpacity(opacity: Number): this\n  \t// Changes the [opacity](#gridlayer-opacity) of the grid layer.\n  \tsetOpacity: function (opacity) {\n  \t\tthis.options.opacity = opacity;\n  \t\tthis._updateOpacity();\n  \t\treturn this;\n  \t},\n\n  \t// @method setZIndex(zIndex: Number): this\n  \t// Changes the [zIndex](#gridlayer-zindex) of the grid layer.\n  \tsetZIndex: function (zIndex) {\n  \t\tthis.options.zIndex = zIndex;\n  \t\tthis._updateZIndex();\n\n  \t\treturn this;\n  \t},\n\n  \t// @method isLoading: Boolean\n  \t// Returns `true` if any tile in the grid layer has not finished loading.\n  \tisLoading: function () {\n  \t\treturn this._loading;\n  \t},\n\n  \t// @method redraw: this\n  \t// Causes the layer to clear all the tiles and request them again.\n  \tredraw: function () {\n  \t\tif (this._map) {\n  \t\t\tthis._removeAllTiles();\n  \t\t\tvar tileZoom = this._clampZoom(this._map.getZoom());\n  \t\t\tif (tileZoom !== this._tileZoom) {\n  \t\t\t\tthis._tileZoom = tileZoom;\n  \t\t\t\tthis._updateLevels();\n  \t\t\t}\n  \t\t\tthis._update();\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \tgetEvents: function () {\n  \t\tvar events = {\n  \t\t\tviewprereset: this._invalidateAll,\n  \t\t\tviewreset: this._resetView,\n  \t\t\tzoom: this._resetView,\n  \t\t\tmoveend: this._onMoveEnd\n  \t\t};\n\n  \t\tif (!this.options.updateWhenIdle) {\n  \t\t\t// update tiles on move, but not more often than once per given interval\n  \t\t\tif (!this._onMove) {\n  \t\t\t\tthis._onMove = throttle(this._onMoveEnd, this.options.updateInterval, this);\n  \t\t\t}\n\n  \t\t\tevents.move = this._onMove;\n  \t\t}\n\n  \t\tif (this._zoomAnimated) {\n  \t\t\tevents.zoomanim = this._animateZoom;\n  \t\t}\n\n  \t\treturn events;\n  \t},\n\n  \t// @section Extension methods\n  \t// Layers extending `GridLayer` shall reimplement the following method.\n  \t// @method createTile(coords: Object, done?: Function): HTMLElement\n  \t// Called only internally, must be overridden by classes extending `GridLayer`.\n  \t// Returns the `HTMLElement` corresponding to the given `coords`. If the `done` callback\n  \t// is specified, it must be called when the tile has finished loading and drawing.\n  \tcreateTile: function () {\n  \t\treturn document.createElement('div');\n  \t},\n\n  \t// @section\n  \t// @method getTileSize: Point\n  \t// Normalizes the [tileSize option](#gridlayer-tilesize) into a point. Used by the `createTile()` method.\n  \tgetTileSize: function () {\n  \t\tvar s = this.options.tileSize;\n  \t\treturn s instanceof Point ? s : new Point(s, s);\n  \t},\n\n  \t_updateZIndex: function () {\n  \t\tif (this._container && this.options.zIndex !== undefined && this.options.zIndex !== null) {\n  \t\t\tthis._container.style.zIndex = this.options.zIndex;\n  \t\t}\n  \t},\n\n  \t_setAutoZIndex: function (compare) {\n  \t\t// go through all other layers of the same pane, set zIndex to max + 1 (front) or min - 1 (back)\n\n  \t\tvar layers = this.getPane().children,\n  \t\t    edgeZIndex = -compare(-Infinity, Infinity); // -Infinity for max, Infinity for min\n\n  \t\tfor (var i = 0, len = layers.length, zIndex; i < len; i++) {\n\n  \t\t\tzIndex = layers[i].style.zIndex;\n\n  \t\t\tif (layers[i] !== this._container && zIndex) {\n  \t\t\t\tedgeZIndex = compare(edgeZIndex, +zIndex);\n  \t\t\t}\n  \t\t}\n\n  \t\tif (isFinite(edgeZIndex)) {\n  \t\t\tthis.options.zIndex = edgeZIndex + compare(-1, 1);\n  \t\t\tthis._updateZIndex();\n  \t\t}\n  \t},\n\n  \t_updateOpacity: function () {\n  \t\tif (!this._map) { return; }\n\n  \t\t// IE doesn't inherit filter opacity properly, so we're forced to set it on tiles\n  \t\tif (Browser.ielt9) { return; }\n\n  \t\tsetOpacity(this._container, this.options.opacity);\n\n  \t\tvar now = +new Date(),\n  \t\t    nextFrame = false,\n  \t\t    willPrune = false;\n\n  \t\tfor (var key in this._tiles) {\n  \t\t\tvar tile = this._tiles[key];\n  \t\t\tif (!tile.current || !tile.loaded) { continue; }\n\n  \t\t\tvar fade = Math.min(1, (now - tile.loaded) / 200);\n\n  \t\t\tsetOpacity(tile.el, fade);\n  \t\t\tif (fade < 1) {\n  \t\t\t\tnextFrame = true;\n  \t\t\t} else {\n  \t\t\t\tif (tile.active) {\n  \t\t\t\t\twillPrune = true;\n  \t\t\t\t} else {\n  \t\t\t\t\tthis._onOpaqueTile(tile);\n  \t\t\t\t}\n  \t\t\t\ttile.active = true;\n  \t\t\t}\n  \t\t}\n\n  \t\tif (willPrune && !this._noPrune) { this._pruneTiles(); }\n\n  \t\tif (nextFrame) {\n  \t\t\tcancelAnimFrame(this._fadeFrame);\n  \t\t\tthis._fadeFrame = requestAnimFrame(this._updateOpacity, this);\n  \t\t}\n  \t},\n\n  \t_onOpaqueTile: falseFn,\n\n  \t_initContainer: function () {\n  \t\tif (this._container) { return; }\n\n  \t\tthis._container = create$1('div', 'leaflet-layer ' + (this.options.className || ''));\n  \t\tthis._updateZIndex();\n\n  \t\tif (this.options.opacity < 1) {\n  \t\t\tthis._updateOpacity();\n  \t\t}\n\n  \t\tthis.getPane().appendChild(this._container);\n  \t},\n\n  \t_updateLevels: function () {\n\n  \t\tvar zoom = this._tileZoom,\n  \t\t    maxZoom = this.options.maxZoom;\n\n  \t\tif (zoom === undefined) { return undefined; }\n\n  \t\tfor (var z in this._levels) {\n  \t\t\tz = Number(z);\n  \t\t\tif (this._levels[z].el.children.length || z === zoom) {\n  \t\t\t\tthis._levels[z].el.style.zIndex = maxZoom - Math.abs(zoom - z);\n  \t\t\t\tthis._onUpdateLevel(z);\n  \t\t\t} else {\n  \t\t\t\tremove(this._levels[z].el);\n  \t\t\t\tthis._removeTilesAtZoom(z);\n  \t\t\t\tthis._onRemoveLevel(z);\n  \t\t\t\tdelete this._levels[z];\n  \t\t\t}\n  \t\t}\n\n  \t\tvar level = this._levels[zoom],\n  \t\t    map = this._map;\n\n  \t\tif (!level) {\n  \t\t\tlevel = this._levels[zoom] = {};\n\n  \t\t\tlevel.el = create$1('div', 'leaflet-tile-container leaflet-zoom-animated', this._container);\n  \t\t\tlevel.el.style.zIndex = maxZoom;\n\n  \t\t\tlevel.origin = map.project(map.unproject(map.getPixelOrigin()), zoom).round();\n  \t\t\tlevel.zoom = zoom;\n\n  \t\t\tthis._setZoomTransform(level, map.getCenter(), map.getZoom());\n\n  \t\t\t// force the browser to consider the newly added element for transition\n  \t\t\tfalseFn(level.el.offsetWidth);\n\n  \t\t\tthis._onCreateLevel(level);\n  \t\t}\n\n  \t\tthis._level = level;\n\n  \t\treturn level;\n  \t},\n\n  \t_onUpdateLevel: falseFn,\n\n  \t_onRemoveLevel: falseFn,\n\n  \t_onCreateLevel: falseFn,\n\n  \t_pruneTiles: function () {\n  \t\tif (!this._map) {\n  \t\t\treturn;\n  \t\t}\n\n  \t\tvar key, tile;\n\n  \t\tvar zoom = this._map.getZoom();\n  \t\tif (zoom > this.options.maxZoom ||\n  \t\t\tzoom < this.options.minZoom) {\n  \t\t\tthis._removeAllTiles();\n  \t\t\treturn;\n  \t\t}\n\n  \t\tfor (key in this._tiles) {\n  \t\t\ttile = this._tiles[key];\n  \t\t\ttile.retain = tile.current;\n  \t\t}\n\n  \t\tfor (key in this._tiles) {\n  \t\t\ttile = this._tiles[key];\n  \t\t\tif (tile.current && !tile.active) {\n  \t\t\t\tvar coords = tile.coords;\n  \t\t\t\tif (!this._retainParent(coords.x, coords.y, coords.z, coords.z - 5)) {\n  \t\t\t\t\tthis._retainChildren(coords.x, coords.y, coords.z, coords.z + 2);\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n\n  \t\tfor (key in this._tiles) {\n  \t\t\tif (!this._tiles[key].retain) {\n  \t\t\t\tthis._removeTile(key);\n  \t\t\t}\n  \t\t}\n  \t},\n\n  \t_removeTilesAtZoom: function (zoom) {\n  \t\tfor (var key in this._tiles) {\n  \t\t\tif (this._tiles[key].coords.z !== zoom) {\n  \t\t\t\tcontinue;\n  \t\t\t}\n  \t\t\tthis._removeTile(key);\n  \t\t}\n  \t},\n\n  \t_removeAllTiles: function () {\n  \t\tfor (var key in this._tiles) {\n  \t\t\tthis._removeTile(key);\n  \t\t}\n  \t},\n\n  \t_invalidateAll: function () {\n  \t\tfor (var z in this._levels) {\n  \t\t\tremove(this._levels[z].el);\n  \t\t\tthis._onRemoveLevel(Number(z));\n  \t\t\tdelete this._levels[z];\n  \t\t}\n  \t\tthis._removeAllTiles();\n\n  \t\tthis._tileZoom = undefined;\n  \t},\n\n  \t_retainParent: function (x, y, z, minZoom) {\n  \t\tvar x2 = Math.floor(x / 2),\n  \t\t    y2 = Math.floor(y / 2),\n  \t\t    z2 = z - 1,\n  \t\t    coords2 = new Point(+x2, +y2);\n  \t\tcoords2.z = +z2;\n\n  \t\tvar key = this._tileCoordsToKey(coords2),\n  \t\t    tile = this._tiles[key];\n\n  \t\tif (tile && tile.active) {\n  \t\t\ttile.retain = true;\n  \t\t\treturn true;\n\n  \t\t} else if (tile && tile.loaded) {\n  \t\t\ttile.retain = true;\n  \t\t}\n\n  \t\tif (z2 > minZoom) {\n  \t\t\treturn this._retainParent(x2, y2, z2, minZoom);\n  \t\t}\n\n  \t\treturn false;\n  \t},\n\n  \t_retainChildren: function (x, y, z, maxZoom) {\n\n  \t\tfor (var i = 2 * x; i < 2 * x + 2; i++) {\n  \t\t\tfor (var j = 2 * y; j < 2 * y + 2; j++) {\n\n  \t\t\t\tvar coords = new Point(i, j);\n  \t\t\t\tcoords.z = z + 1;\n\n  \t\t\t\tvar key = this._tileCoordsToKey(coords),\n  \t\t\t\t    tile = this._tiles[key];\n\n  \t\t\t\tif (tile && tile.active) {\n  \t\t\t\t\ttile.retain = true;\n  \t\t\t\t\tcontinue;\n\n  \t\t\t\t} else if (tile && tile.loaded) {\n  \t\t\t\t\ttile.retain = true;\n  \t\t\t\t}\n\n  \t\t\t\tif (z + 1 < maxZoom) {\n  \t\t\t\t\tthis._retainChildren(i, j, z + 1, maxZoom);\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n  \t},\n\n  \t_resetView: function (e) {\n  \t\tvar animating = e && (e.pinch || e.flyTo);\n  \t\tthis._setView(this._map.getCenter(), this._map.getZoom(), animating, animating);\n  \t},\n\n  \t_animateZoom: function (e) {\n  \t\tthis._setView(e.center, e.zoom, true, e.noUpdate);\n  \t},\n\n  \t_clampZoom: function (zoom) {\n  \t\tvar options = this.options;\n\n  \t\tif (undefined !== options.minNativeZoom && zoom < options.minNativeZoom) {\n  \t\t\treturn options.minNativeZoom;\n  \t\t}\n\n  \t\tif (undefined !== options.maxNativeZoom && options.maxNativeZoom < zoom) {\n  \t\t\treturn options.maxNativeZoom;\n  \t\t}\n\n  \t\treturn zoom;\n  \t},\n\n  \t_setView: function (center, zoom, noPrune, noUpdate) {\n  \t\tvar tileZoom = Math.round(zoom);\n  \t\tif ((this.options.maxZoom !== undefined && tileZoom > this.options.maxZoom) ||\n  \t\t    (this.options.minZoom !== undefined && tileZoom < this.options.minZoom)) {\n  \t\t\ttileZoom = undefined;\n  \t\t} else {\n  \t\t\ttileZoom = this._clampZoom(tileZoom);\n  \t\t}\n\n  \t\tvar tileZoomChanged = this.options.updateWhenZooming && (tileZoom !== this._tileZoom);\n\n  \t\tif (!noUpdate || tileZoomChanged) {\n\n  \t\t\tthis._tileZoom = tileZoom;\n\n  \t\t\tif (this._abortLoading) {\n  \t\t\t\tthis._abortLoading();\n  \t\t\t}\n\n  \t\t\tthis._updateLevels();\n  \t\t\tthis._resetGrid();\n\n  \t\t\tif (tileZoom !== undefined) {\n  \t\t\t\tthis._update(center);\n  \t\t\t}\n\n  \t\t\tif (!noPrune) {\n  \t\t\t\tthis._pruneTiles();\n  \t\t\t}\n\n  \t\t\t// Flag to prevent _updateOpacity from pruning tiles during\n  \t\t\t// a zoom anim or a pinch gesture\n  \t\t\tthis._noPrune = !!noPrune;\n  \t\t}\n\n  \t\tthis._setZoomTransforms(center, zoom);\n  \t},\n\n  \t_setZoomTransforms: function (center, zoom) {\n  \t\tfor (var i in this._levels) {\n  \t\t\tthis._setZoomTransform(this._levels[i], center, zoom);\n  \t\t}\n  \t},\n\n  \t_setZoomTransform: function (level, center, zoom) {\n  \t\tvar scale = this._map.getZoomScale(zoom, level.zoom),\n  \t\t    translate = level.origin.multiplyBy(scale)\n  \t\t        .subtract(this._map._getNewPixelOrigin(center, zoom)).round();\n\n  \t\tif (Browser.any3d) {\n  \t\t\tsetTransform(level.el, translate, scale);\n  \t\t} else {\n  \t\t\tsetPosition(level.el, translate);\n  \t\t}\n  \t},\n\n  \t_resetGrid: function () {\n  \t\tvar map = this._map,\n  \t\t    crs = map.options.crs,\n  \t\t    tileSize = this._tileSize = this.getTileSize(),\n  \t\t    tileZoom = this._tileZoom;\n\n  \t\tvar bounds = this._map.getPixelWorldBounds(this._tileZoom);\n  \t\tif (bounds) {\n  \t\t\tthis._globalTileRange = this._pxBoundsToTileRange(bounds);\n  \t\t}\n\n  \t\tthis._wrapX = crs.wrapLng && !this.options.noWrap && [\n  \t\t\tMath.floor(map.project([0, crs.wrapLng[0]], tileZoom).x / tileSize.x),\n  \t\t\tMath.ceil(map.project([0, crs.wrapLng[1]], tileZoom).x / tileSize.y)\n  \t\t];\n  \t\tthis._wrapY = crs.wrapLat && !this.options.noWrap && [\n  \t\t\tMath.floor(map.project([crs.wrapLat[0], 0], tileZoom).y / tileSize.x),\n  \t\t\tMath.ceil(map.project([crs.wrapLat[1], 0], tileZoom).y / tileSize.y)\n  \t\t];\n  \t},\n\n  \t_onMoveEnd: function () {\n  \t\tif (!this._map || this._map._animatingZoom) { return; }\n\n  \t\tthis._update();\n  \t},\n\n  \t_getTiledPixelBounds: function (center) {\n  \t\tvar map = this._map,\n  \t\t    mapZoom = map._animatingZoom ? Math.max(map._animateToZoom, map.getZoom()) : map.getZoom(),\n  \t\t    scale = map.getZoomScale(mapZoom, this._tileZoom),\n  \t\t    pixelCenter = map.project(center, this._tileZoom).floor(),\n  \t\t    halfSize = map.getSize().divideBy(scale * 2);\n\n  \t\treturn new Bounds(pixelCenter.subtract(halfSize), pixelCenter.add(halfSize));\n  \t},\n\n  \t// Private method to load tiles in the grid's active zoom level according to map bounds\n  \t_update: function (center) {\n  \t\tvar map = this._map;\n  \t\tif (!map) { return; }\n  \t\tvar zoom = this._clampZoom(map.getZoom());\n\n  \t\tif (center === undefined) { center = map.getCenter(); }\n  \t\tif (this._tileZoom === undefined) { return; }\t// if out of minzoom/maxzoom\n\n  \t\tvar pixelBounds = this._getTiledPixelBounds(center),\n  \t\t    tileRange = this._pxBoundsToTileRange(pixelBounds),\n  \t\t    tileCenter = tileRange.getCenter(),\n  \t\t    queue = [],\n  \t\t    margin = this.options.keepBuffer,\n  \t\t    noPruneRange = new Bounds(tileRange.getBottomLeft().subtract([margin, -margin]),\n  \t\t                              tileRange.getTopRight().add([margin, -margin]));\n\n  \t\t// Sanity check: panic if the tile range contains Infinity somewhere.\n  \t\tif (!(isFinite(tileRange.min.x) &&\n  \t\t      isFinite(tileRange.min.y) &&\n  \t\t      isFinite(tileRange.max.x) &&\n  \t\t      isFinite(tileRange.max.y))) { throw new Error('Attempted to load an infinite number of tiles'); }\n\n  \t\tfor (var key in this._tiles) {\n  \t\t\tvar c = this._tiles[key].coords;\n  \t\t\tif (c.z !== this._tileZoom || !noPruneRange.contains(new Point(c.x, c.y))) {\n  \t\t\t\tthis._tiles[key].current = false;\n  \t\t\t}\n  \t\t}\n\n  \t\t// _update just loads more tiles. If the tile zoom level differs too much\n  \t\t// from the map's, let _setView reset levels and prune old tiles.\n  \t\tif (Math.abs(zoom - this._tileZoom) > 1) { this._setView(center, zoom); return; }\n\n  \t\t// create a queue of coordinates to load tiles from\n  \t\tfor (var j = tileRange.min.y; j <= tileRange.max.y; j++) {\n  \t\t\tfor (var i = tileRange.min.x; i <= tileRange.max.x; i++) {\n  \t\t\t\tvar coords = new Point(i, j);\n  \t\t\t\tcoords.z = this._tileZoom;\n\n  \t\t\t\tif (!this._isValidTile(coords)) { continue; }\n\n  \t\t\t\tvar tile = this._tiles[this._tileCoordsToKey(coords)];\n  \t\t\t\tif (tile) {\n  \t\t\t\t\ttile.current = true;\n  \t\t\t\t} else {\n  \t\t\t\t\tqueue.push(coords);\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n\n  \t\t// sort tile queue to load tiles in order of their distance to center\n  \t\tqueue.sort(function (a, b) {\n  \t\t\treturn a.distanceTo(tileCenter) - b.distanceTo(tileCenter);\n  \t\t});\n\n  \t\tif (queue.length !== 0) {\n  \t\t\t// if it's the first batch of tiles to load\n  \t\t\tif (!this._loading) {\n  \t\t\t\tthis._loading = true;\n  \t\t\t\t// @event loading: Event\n  \t\t\t\t// Fired when the grid layer starts loading tiles.\n  \t\t\t\tthis.fire('loading');\n  \t\t\t}\n\n  \t\t\t// create DOM fragment to append tiles in one batch\n  \t\t\tvar fragment = document.createDocumentFragment();\n\n  \t\t\tfor (i = 0; i < queue.length; i++) {\n  \t\t\t\tthis._addTile(queue[i], fragment);\n  \t\t\t}\n\n  \t\t\tthis._level.el.appendChild(fragment);\n  \t\t}\n  \t},\n\n  \t_isValidTile: function (coords) {\n  \t\tvar crs = this._map.options.crs;\n\n  \t\tif (!crs.infinite) {\n  \t\t\t// don't load tile if it's out of bounds and not wrapped\n  \t\t\tvar bounds = this._globalTileRange;\n  \t\t\tif ((!crs.wrapLng && (coords.x < bounds.min.x || coords.x > bounds.max.x)) ||\n  \t\t\t    (!crs.wrapLat && (coords.y < bounds.min.y || coords.y > bounds.max.y))) { return false; }\n  \t\t}\n\n  \t\tif (!this.options.bounds) { return true; }\n\n  \t\t// don't load tile if it doesn't intersect the bounds in options\n  \t\tvar tileBounds = this._tileCoordsToBounds(coords);\n  \t\treturn toLatLngBounds(this.options.bounds).overlaps(tileBounds);\n  \t},\n\n  \t_keyToBounds: function (key) {\n  \t\treturn this._tileCoordsToBounds(this._keyToTileCoords(key));\n  \t},\n\n  \t_tileCoordsToNwSe: function (coords) {\n  \t\tvar map = this._map,\n  \t\t    tileSize = this.getTileSize(),\n  \t\t    nwPoint = coords.scaleBy(tileSize),\n  \t\t    sePoint = nwPoint.add(tileSize),\n  \t\t    nw = map.unproject(nwPoint, coords.z),\n  \t\t    se = map.unproject(sePoint, coords.z);\n  \t\treturn [nw, se];\n  \t},\n\n  \t// converts tile coordinates to its geographical bounds\n  \t_tileCoordsToBounds: function (coords) {\n  \t\tvar bp = this._tileCoordsToNwSe(coords),\n  \t\t    bounds = new LatLngBounds(bp[0], bp[1]);\n\n  \t\tif (!this.options.noWrap) {\n  \t\t\tbounds = this._map.wrapLatLngBounds(bounds);\n  \t\t}\n  \t\treturn bounds;\n  \t},\n  \t// converts tile coordinates to key for the tile cache\n  \t_tileCoordsToKey: function (coords) {\n  \t\treturn coords.x + ':' + coords.y + ':' + coords.z;\n  \t},\n\n  \t// converts tile cache key to coordinates\n  \t_keyToTileCoords: function (key) {\n  \t\tvar k = key.split(':'),\n  \t\t    coords = new Point(+k[0], +k[1]);\n  \t\tcoords.z = +k[2];\n  \t\treturn coords;\n  \t},\n\n  \t_removeTile: function (key) {\n  \t\tvar tile = this._tiles[key];\n  \t\tif (!tile) { return; }\n\n  \t\tremove(tile.el);\n\n  \t\tdelete this._tiles[key];\n\n  \t\t// @event tileunload: TileEvent\n  \t\t// Fired when a tile is removed (e.g. when a tile goes off the screen).\n  \t\tthis.fire('tileunload', {\n  \t\t\ttile: tile.el,\n  \t\t\tcoords: this._keyToTileCoords(key)\n  \t\t});\n  \t},\n\n  \t_initTile: function (tile) {\n  \t\taddClass(tile, 'leaflet-tile');\n\n  \t\tvar tileSize = this.getTileSize();\n  \t\ttile.style.width = tileSize.x + 'px';\n  \t\ttile.style.height = tileSize.y + 'px';\n\n  \t\ttile.onselectstart = falseFn;\n  \t\ttile.onmousemove = falseFn;\n\n  \t\t// update opacity on tiles in IE7-8 because of filter inheritance problems\n  \t\tif (Browser.ielt9 && this.options.opacity < 1) {\n  \t\t\tsetOpacity(tile, this.options.opacity);\n  \t\t}\n  \t},\n\n  \t_addTile: function (coords, container) {\n  \t\tvar tilePos = this._getTilePos(coords),\n  \t\t    key = this._tileCoordsToKey(coords);\n\n  \t\tvar tile = this.createTile(this._wrapCoords(coords), bind(this._tileReady, this, coords));\n\n  \t\tthis._initTile(tile);\n\n  \t\t// if createTile is defined with a second argument (\"done\" callback),\n  \t\t// we know that tile is async and will be ready later; otherwise\n  \t\tif (this.createTile.length < 2) {\n  \t\t\t// mark tile as ready, but delay one frame for opacity animation to happen\n  \t\t\trequestAnimFrame(bind(this._tileReady, this, coords, null, tile));\n  \t\t}\n\n  \t\tsetPosition(tile, tilePos);\n\n  \t\t// save tile in cache\n  \t\tthis._tiles[key] = {\n  \t\t\tel: tile,\n  \t\t\tcoords: coords,\n  \t\t\tcurrent: true\n  \t\t};\n\n  \t\tcontainer.appendChild(tile);\n  \t\t// @event tileloadstart: TileEvent\n  \t\t// Fired when a tile is requested and starts loading.\n  \t\tthis.fire('tileloadstart', {\n  \t\t\ttile: tile,\n  \t\t\tcoords: coords\n  \t\t});\n  \t},\n\n  \t_tileReady: function (coords, err, tile) {\n  \t\tif (err) {\n  \t\t\t// @event tileerror: TileErrorEvent\n  \t\t\t// Fired when there is an error loading a tile.\n  \t\t\tthis.fire('tileerror', {\n  \t\t\t\terror: err,\n  \t\t\t\ttile: tile,\n  \t\t\t\tcoords: coords\n  \t\t\t});\n  \t\t}\n\n  \t\tvar key = this._tileCoordsToKey