@extends('layouts.auth')
@section('content')
<form class="form w-100" method="POST" novalidate="novalidate" id="kt_sign_in_form1" action="{{ route('login') }}">
    @csrf
    <div class="text-center mb-11">
        <img src="{{ asset('assets/media/img/elevate.png') }}" class="mb-3 logoadmins" style="max-width: 25%;"/>
        <h1 class="text-dark fw-bolder mb-3">Sign In</h1>
    </div>
    <div class="fv-row mb-8 fv-plugins-icon-container fv-plugins-bootstrap5-row-valid">
        <input type="text" placeholder="Email" name="email" autocomplete="off" class="form-control bg-transparent @error('email') is-invalid @enderror" value="{{ old('email','superadmin@example.com') }}" required autofocus>
        @error('email')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
        @enderror
    </div>
    <div class="fv-row mb-3 fv-plugins-icon-container fv-plugins-bootstrap5-row-valid">
        <div class="position-relative mb-3">
            <input id="password" type="password" placeholder="Password" name="password" autocomplete="off" class="form-control bg-transparent @error('password') is-invalid @enderror" value="123456789">
            <span class="btn btn-sm btn-icon position-absolute translate-middle top-50 end-0 me-n2">
                <i class="bi bi-eye-slash show-password fs-2"></i>
                <i class="bi bi-eye fs-2 hide-password" style="display:none;"></i>
            </span>
            @error('password')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
            @enderror
        </div>
    </div>
    <div class="d-flex flex-stack flex-wrap gap-3 fs-base fw-semibold mb-8">
        <div></div>
        @if (Route::has('password.request') && get_setting('enable_email'))
            <a href="{{ route('password.request') }}" class="link-primary">Forgot Password ?</a>
        @endif
    </div>
    <div class="d-grid mb-10">
        <button type="submit" id="kt_sign_in_submit" class="btn btn-primary" style="background-color: #002850;">
        <span class="indicator-label">
            {{ __('Login') }}
        </span>
        </button>
    </div>
    <div class="text-gray-500 text-center fw-semibold fs-6">Not a Member yet?
        <a href="{{ route('register') }}" class="link-primary" style="color: #002850 !important;">Sign up</a></div>
    <div></div>
</form>
@endsection
@push('java-script')
<script>
    $(document).ready(function()
    {
        $(".show-password, .hide-password").on('click', function() {
            var passwordId = $(this).parent().parent().find('input').attr('id');
            if ($(this).hasClass('show-password')) {
                $("#" + passwordId).attr("type", "text");
                $(this).parent().find(".show-password").hide();
                $(this).parent().find(".hide-password").show();
            } else {
                $("#" + passwordId).attr("type", "password");
                $(this).parent().find(".hide-password").hide();
                $(this).parent().find(".show-password").show();
            }
        });
    });
</script>
@endpush
