@extends('layouts.dashboard')
@section('toolbar-heading','Hero Section')
@section('breadcrumb','Home')
@section('breadcrumb1','Hero Section')
@section('action-btn')
@can('create_hero_section')
    <a href="{{ route('hero-section.create') }}" class="btn btn-sm btn-primary">Create</a>
@endcan
@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">Image</th>
                    <th class="min-w-125px">Title</th>
                    @can('edit_hero_section')
                        <th class="min-w-125px">Status</th>
                    @endcan
                    @canany(['edit_hero_section','delete_hero_section'])
                        <th class="text-end min-w-70px">Actions</th>
                    @endcanany
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600 cursor-move" id="sortable">
                @foreach($heroSections as $key => $heroSection)
                    <tr data-index-no="{{ $heroSection->id }}">
                        <td><img src="{{ get_file('hero-section',$heroSection->image) }}" width="60px" height="60px" alt="Image"></td>
                        <td>{{ $heroSection->title }}</td>
                        @can('edit_hero_section')
                            <td>
                                <div class="form-check form-switch">
                                    <input class="form-check-input status" type="checkbox" role="switch" value="{{ $heroSection->id }}" {{ $heroSection->status ? 'checked' : '' }}>
                                </div>
                            </td>
                        @endcan
                        @canany(['edit_hero_section','delete_hero_section'])
                            <td class="text-end">
                                @can('edit_hero_section')
                                    <a href="{{ route('hero-section.edit',$heroSection->id) }}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-pencil-fill fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                                @can('delete_hero_section')
                                    <a href="#" onclick="delete_this('{{route('hero-section.destroy',$heroSection->id)}}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-trash3 fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                            </td>
                        @endcanany
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.3/jquery-ui.min.js"></script>
    <script>
        //$('#sortable').dataTable();
        $(document).on('click', '.status', function ()
        {
            var status = $(this).is(":checked") ? 1 : 0;
            var id = $(this).val();
            $.ajax({
                url: '{{ route('hero-status') }}',
                type: "GET",
                data: {
                    'id' : id,
                    'status' : status,
                },
                dataType: "json",
                success:function(response) {
                    createToast(response.status,response.message);
                }, error: function (response){
                    createToast('error','{{ __('Something went wrong') }}');
                }
            });
        });

        $('#sortable').sortable({
            axis: 'y',
            stop: function (event, ui) {
                var order = [];
                $('tr').each(function() {
                    if($(this).data('index-no') != undefined) {
                        order.push($(this).data('index-no'));
                    }
                });
                $.ajax({
                    url: "{{route('sort-hero-section')}}",
                    data: {
                        _token: '{{ csrf_token() }}',
                        order: order,
                    },
                    type: 'POST',
                    error: function (data) {
                        createToast('error', 'Something went wrong!');
                    }
                });
            }
        });
    </script>
@endpush
