@extends('layouts.dashboard')
@section('toolbar-heading','Blog Category')
@section('breadcrumb','Home')
@section('breadcrumb1','Blog Category')
@section('action-btn')
@can('create_blog_category')
    <button onclick="modal('{{route('blog-category.create')}}')" class="btn btn-sm btn-primary">Create</button>
@endcan
@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-4">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th>Name</th>
                    @can('edit_blog_category')
                        <th>Status</th>
                    @endcan
                    @canany(['edit_blog_category','delete_blog_category'])
                        <th class="text-end min-w-70px">Actions</th>
                    @endcanany
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($blogCategories as $blogCategory)
                    <tr>
                        <td>{{ $blogCategory->name }}</td>
                        @can('edit_blog_category')
                            <td>
                                <div class="form-check form-switch">
                                    <input class="form-check-input status" type="checkbox" role="switch" value="{{ $blogCategory->id }}" {{ $blogCategory->status ? 'checked' : '' }}>
                                </div>
                            </td>
                        @endcan
                        @canany(['edit_blog_category','delete_blog_category'])
                            <td class="text-end">
                                @can('edit_blog_category')
                                    <button type="button" onclick="modal('{{route('blog-category.edit',$blogCategory->id)}}')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-pencil-fill fs-7"></i>
                                        </span>
                                    </button>
                                @endcan
                                @can('delete_blog_category')
                                    <button type="button" onclick="delete_this('{{ route('blog-category.destroy',$blogCategory->id) }}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-trash3 fs-7"></i>
                                        </span>
                                    </button>
                                @endcan
                            </td>
                        @endcanany
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection

