@extends('layouts.dashboard')
@section('toolbar-heading','Blogs')
@section('breadcrumb','Home')
@section('breadcrumb1','Blogs')
@section('action-btn')
@can('create_blog')
    <a href="{{ route('blog.create') }}" class="btn btn-sm btn-primary">Create</a>
@endcan
@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">#</th>
                    <th class="min-w-125px">Title</th>
                    @can('edit_blog')
                        <th class="min-w-125px">Status</th>
                    @endcan
                    <th class="min-w-125px">Created At</th>
                    @canany(['edit_blog','delete_blog'])
                        <th class="text-end min-w-70px">Actions</th>
                    @endcanany
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($blogs as $key => $blog)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $blog->title }}</td>
                        @can('edit_blog')
                            <td>
                                <div class="form-check form-switch">
                                    <input class="form-check-input status" type="checkbox" role="switch" value="{{ $blog->id }}" {{ $blog->status ? 'checked' : '' }}>
                                </div>
                            </td>
                        @endcan
                        <td>
                            {{ $blog->created_at->format('d M, Y') }}
                        </td>
                        @canany(['edit_blog','delete_blog'])
                            <td class="text-end">
                                @can('edit_blog')
                                    <a href="{{ route('blog.edit',$blog->id) }}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-pencil-fill fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                                @can('view_blog')
                                    <a href="{{ route('blog.show',$blog->id) }}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-eye fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                                @can('delete_blog')
                                    <a href="#" onclick="delete_this('{{route('blog.destroy',$blog->id)}}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-trash3 fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                            </td>
                        @endcanany
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script>
        $('#kt_users_table').dataTable();
        $(document).on('click', '.status', function ()
        {
            var status = $(this).is(":checked") ? 1 : 0;
            var id = $(this).val();
            $.ajax({
                url: '{{ route('blog-status') }}',
                type: "GET",
                data: {
                    'id' : id,
                    'status' : status,
                },
                dataType: "json",
                success:function(response) {
                    createToast(response.status,response.message);
                }, error: function (response){
                    createToast('error','{{ __('Something went wrong') }}');
                }
            });
        });
    </script>
@endpush
