@extends('layouts.dashboard')
@section('toolbar-heading','FAQ')
@section('breadcrumb','Home')
@section('breadcrumb1','FAQ')
@section('content')
@can('create_faq')
<div class="card p-5">
    <form method="POST" action="{{ route('faq.store') }}" enctype="multipart/form-data"
      class="needs-validation">
        @csrf
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Title</label>
                </div>
                <div class="col-lg-9">
                    <input type="hidden" class="form-control form-control-solid" name="category" value="{{$fc_id}}">
                    <input type="text" class="form-control form-control-solid" name="title" placeholder="Enter Title">
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Description</label>
                </div>
                <div class="col-lg-9">
                    <textarea type="text" class="form-control form-control-solid" name="description" placeholder="Enter Description"></textarea>
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Status</label>
                </div>
                <div class="col-lg-9">
                     <div class="form-check form-switch form-check-custom form-check-solid">
                    <input class="form-check-input" type="checkbox" id="status" name="status">
                    <label class="form-check-label fw-semibold text-gray-400 ms-3" for="status"></label>
                </div>
            </div>
        </div>
        <div class="card-footer d-flex justify-content-end py-6 px-9">
            <button type="submit" class="btn btn-primary">Save</button>
        </div>
    </form>
</div>
@endcan
<div class="card mt-2">
    
    <div class="card-body pt-4">
        <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
            <thead>
            <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                <th>Title</th>
                @can('edit_faq')
                    <th>Status</th>
                @endcan
                @canany(['edit_faq','delete_faq'])
                    <th class="text-end min-w-70px">Actions</th>
                @endcanany
            </tr>
            </thead>
            <tbody class="fw-semibold text-gray-600">
            @foreach($faqs as $faq)
                <tr>
                    <td>{{ $faq->title }}</td>
                    @can('edit_faq')
                        <td>
                            <div class="form-check form-switch">
                                <input class="form-check-input status" type="checkbox" role="switch" value="{{ $faq->id }}" {{ $faq->status ? 'checked' : '' }}>
                            </div>
                        </td>
                    @endcan
                    @canany(['edit_faq','delete_faq'])
                        <td class="text-end">
                            @can('edit_faq')
                                <button type="button" onclick="modal('{{route('faq.edit',$faq->id)}}','lg')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-pencil-fill fs-7"></i>
                                    </span>
                                </button>
                            @endcan
                            @can('delete_faq')
                                <button type="button" onclick="delete_this('{{ route('faq.destroy',$faq->id) }}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-trash3 fs-7"></i>
                                    </span>
                                </button>
                            @endcan
                        </td>
                    @endcanany
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
@push('java-script')
<script>
    $('#kt_users_table').dataTable();

    $(document).on('click', '.status', function ()
    {
        var status = $(this).is(":checked") ? 1 : 0;
        var id = $(this).val();
        $.ajax({
            url: '{{ route('faq-status') }}',
            type: "GET",
            data: {
                'id' : id,
                'status' : status,
            },
            dataType: "json",
            success:function(response) {
                createToast(response.status,response.message);
            }, error: function (response){
                createToast('error','{{ __('Something went wrong') }}');
            }
        });
    });
</script>
@endpush
