@extends('layouts.dashboard')
@section('toolbar-heading','Page Section')
@section('breadcrumb','Home')
@section('breadcrumb1','Page Section')

@section('content')
    <div class="card">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">#</th>
                    <th class="min-w-125px">COMPANY NAME</th>
                    <th class="min-w-125px">NAME</th>
                    <th class="min-w-125px">EMAIL</th>
                    <th class="min-w-125px">MOBILE No.</th>
                    <th class="min-w-125px">COUNTRY</th>
                    <th class="min-w-125px">ENQUIRY TYPE</th>
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($gettouch as $key => $pageSection)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $pageSection->company_name }}</td>
                        <td>{{ $pageSection->full_name }}</td>
                        <td>{{ $pageSection->email }}</td>
                        <td>{{ $pageSection->mobile }}</td>
                        <td>{{ $pageSection->country }}</td>
                        <td>{{ $pageSection->enquiry_type }}</td>

                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script>
        $('#kt_users_table').dataTable();
        $(document).on('click', '.status', function ()
        {
            var status = $(this).is(":checked") ? 1 : 0;
            var id = $(this).val();
            $.ajax({
                url: '{{ route('page-section-status') }}',
                type: "GET",
                data: {
                    'id' : id,
                    'status' : status,
                },
                dataType: "json",
                success:function(response) {
                    createToast(response.status,response.message);
                }, error: function (response){
                    createToast('error','{{ __('Something went wrong') }}');
                }
            });
        });
    </script>
@endpush
