@extends('layouts.dashboard')
@section('toolbar-heading','Global Rech Section')
@section('breadcrumb','Home')
@section('breadcrumb1','Global Rech Section')
@section('action-btn')
@can('create_hero_section')
    <a href="{{ route('global-reach.add') }}" class="btn btn-sm btn-primary">Create</a>
@endcan
@endsection
@section('content')
<div class="card">
    <form action="{{ route('global-reach.list') }}" class="form" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="card-body p-9">
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">The Global Title</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="the_global_title" value="{{ $settings['the_global_title'] ?? '' }}" />
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">The Global Subtitle</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="the_global_subtitle" value="{{ $settings['the_global_subtitle'] ?? '' }}" />
                </div>
            </div>
        </div>
        <div class="card-footer d-flex justify-content-end py-6 px-9">
            <button type="submit" class="btn btn-primary">Save</button>
        </div>
    </form>
</div>

    <div class="card mt-5">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">#</th>
                    <th class="min-w-125px">Title</th>
                        <th class="min-w-125px">Description</th>
                    <th class="min-w-125px">Image</th>
                        <th class="text-end min-w-70px">Actions</th>
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600 cursor-move" id="sortable">
                @foreach($global_reach as $key => $list)
                    <tr>
                        <td>{{$key+1}}</td>
                        <td>{{ $list->title }}</td>
                        <td>{!! Str::limit($list->description, 100, '...') !!}</td>
                        <td><img src="{{ get_file('global-reach',$list->image) }}" width="60px" height="60px" alt="Image"></td>
                        
                        <td class="text-end">
                                <a href="{{ route('global-reach.edit',$list->id) }}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-pencil-fill fs-7"></i>
                                    </span>
                                </a>
                                <a href="#" onclick="delete_this('{{route('global-reach.delete',$list->id)}}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-trash3 fs-7"></i>
                                    </span>
                                </a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.3/jquery-ui.min.js"></script>
    <script>
      $('#kt_users_table').dataTable();
    </script>
@endpush
