@extends('layouts.dashboard')
@section('toolbar-heading','Menu Management')
@section('breadcrumb','Home')
@section('breadcrumb1','Menu Management')
@section('content')
    <div class="card">
        <div class="card-header">
            <div class="card-title fs-3 fw-bold">Create Menu</div>
        </div>
        <form action="{{ route('menu.store') }}" class="form" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="card-body p-9">
                <div class="row g-9 mb-8">
                    <div class="col-md-12 fv-row">
                        <label class="required fs-6 fw-semibold mb-2">Name</label>
                        <input type="text" class="form-control form-control-solid" name="name">
                    </div>
                </div>
                <div class="separator my-8"></div>
                <div class="g-9 mb-8">
                    <div class="row">
                        <div class="col-12" id="submenu-col">
                            <div class="row submnu-row" data-id="0">
                                <div class="col-md-12 fv-row">
                                    <div class="row">
                                        <div class="col-11">
                                            <label class="fs-6 fw-semibold mb-2">Submenu</label>
                                            <input type="text" class="form-control form-control-solid" name="submenu[]">
                                        </div>
                                        <div class="col-1 pt-10">
                                            <button type="button" class="btn btn-light-danger me-auto btn-sm remove-submenu">Remove</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="row">
                                        <div class="col-12 submenu-2-col">
                                            <div class="row submenu-2-row">
                                                <div class="col-12 mt-4">
                                                    <div class="row">
                                                        <div class="col-2"></div>
                                                        <div class="col-6">
                                                            <label class="fs-6 fw-semibold mb-2">Submenu 2</label>
                                                            <input type="text" class="form-control form-control-solid" name="submenu_2[0][0][]">
                                                        </div>
                                                        <div class="col-4 pt-10">
                                                            <button type="button" class="btn btn-light-success me-auto btn-sm add-submenu-3" data-id="0">Add Submenu 3</button>
                                                            <button type="button" class="btn btn-light-danger ms-4 btn-sm remove-submenu-2">Remove</button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-12 pt-10 submenu-3-col">
                                                    <div class="row mb-4">
                                                        <div class="col-4"></div>
                                                        <div class="col-4">
                                                            <label class="fs-6 fw-semibold mb-2">Submenu 3</label>
                                                            <input type="text" class="form-control form-control-solid" name="submenu_3[0][0][]">
                                                        </div>
                                                        <div class="col-4 pt-10">
                                                            <button type="button" class="btn btn-light-danger me-auto btn-sm remove-submenu-3">Remove</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 pt-10 text-center">
                                            <button type="button" class="btn btn-light-primary btn-sm me-auto add-submenu-2">Add Submenu 2</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <button type="button" class="btn btn-primary btn-sm me-auto" id="add-submenu">Add Submenu</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex justify-content-end py-6 px-9">
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
        </form>
    </div>
@endsection
@push('java-script')
    <script>
        $(document).ready(function()
        {
            $(document).on('click', '.remove-submenu', function()
            {
                $(this).parent().parent().parent().remove()
            });

            $(document).on('click', '.remove-submenu-2', function()
            {
                $(this).parent().parent().parent().parent().remove()
            });

            $(document).on('click', '.remove-submenu-3', function()
            {
                $(this).parent().parent().remove();
            });

            $(document).on('click', '.add-submenu-2', function()
            {
                //var submenuCount = $(this).parent().parent().parent().parent().data('id');
                var submenuCount = $('.submnu-row').length - 1;

                /*var submenu2Count = $(this).parent().parent().parent().parent().find('.add-submenu-3').last().data('id');
                submenu2Count++;*/

                var submenu2Count = $(this).parent().parent().parent().parent().find('.add-submenu-3').length;
                var html = '<div class="row">'+
                    '<div class="my-8"></div>'+
                    '<div class="col-12">'+
                    '    <div class="row">'+
                    '        <div class="col-2"></div>'+
                    '        <div class="col-6">'+
                    '            <label class="fs-6 fw-semibold mb-2">Submenu 2</label>'+
                    '            <input type="text" class="form-control form-control-solid" name="submenu_2['+submenuCount+']['+submenu2Count+'][]">'+
                    '        </div>'+
                    '        <div class="col-4 pt-10">'+
                    '            <button type="button" class="btn btn-light-success me-auto btn-sm add-submenu-3" data-id="'+submenu2Count+'">Add Submenu 3</button>'+
                    '            <button type="button" class="btn btn-light-danger ms-4 btn-sm remove-submenu-2">Remove</button>'+
                    '        </div>'+
                    '    </div>'+
                    '</div>'+
                    '<div class="col-12 pt-10 submenu-3-col">'+
                    '        <div class="row mb-4">'+
                    '            <div class="col-4"></div>'+
                    '            <div class="col-4">'+
                    '                <label class="fs-6 fw-semibold mb-2">Submenu 3</label>'+
                    '                <input type="text" class="form-control form-control-solid" name="submenu_3['+submenuCount+']['+submenu2Count+'][]">'+
                    '            </div>'+
                    '            <div class="col-4 pt-10">'+
                    '                <button type="button" class="btn btn-light-danger me-auto btn-sm remove-submenu-3">Remove</button>'+
                    '            </div>'+
                    '        </div>'+
                    '</div>'+
                    '</div>';

                var appendTo = $(this).parent().parent().find('.submenu-2-col').first();
                console.log(appendTo);
                appendTo.append(html);
                //$('.submenu-2-col').append(html);
            });

            $(document).on('click', '.add-submenu-3', function()
            {
                var $this = $(this);
                //var submenuCount = $(this).parent().parent().parent().parent().parent().parent().parent().parent().data('id');
                var submenuCount = $('.submnu-row').length - 1;
                var submenu2Count = $this.data('id');
                var subcol = $this.parent().parent().parent().siblings('.submenu-3-col');

                var html = '<div class="row mb-4">'+
                    '<div class="col-4"></div>'+
                    '<div class="col-4">'+
                    '<label class="fs-6 fw-semibold mb-2">Submenu 3</label>'+
                    '<input type="text" class="form-control form-control-solid" name="submenu_3['+submenuCount+']['+submenu2Count+'][]">'+
                    '</div>'+
                    '<div class="col-4 pt-10">'+
                    '<button type="button" class="btn btn-light-danger me-auto btn-sm remove-submenu-3">Remove</button>'+
                    '</div>'+
                    '</div>';
                subcol.append(html);
            });

            $(document).on('click', '#add-submenu', function()
            {
                var submenuCount = $('.submnu-row').length;

                var html = '<div class="row submnu-row" data-id="'+submenuCount+'">'+
                '<div class="col-md-12 fv-row">'+
                '<div class="separator my-8"></div>'+
                '<div class="row">'+
                '<div class="col-11">'+
                '<label class="fs-6 fw-semibold mb-2">Submenu</label>'+
                '<input type="text" class="form-control form-control-solid" name="submenu[]">'+
                '</div>'+
                '<div class="col-1 pt-10">'+
                '<button type="button" class="btn btn-light-danger me-auto btn-sm remove-submenu">Remove</button>'+
                '</div>'+
                '</div>'+
                '</div>'+
                '<div class="col-12">'+
                '<div class="row">'+
                '<div class="col-12 submenu-2-col">'+
                '<div class="row submenu-2-row">'+
                '<div class="col-12 mt-4">'+
                '<div class="row">'+
                '<div class="col-2"></div>'+
                '<div class="col-6">'+
                '<label class="fs-6 fw-semibold mb-2">Submenu 2</label>'+
                '<input type="text" class="form-control form-control-solid" name="submenu_2['+submenuCount+'][0][]">'+
                '</div>'+
                '<div class="col-4 pt-10">'+
                '<button type="button" class="btn btn-light-success me-auto btn-sm add-submenu-3" data-id="0">Add Submenu 3</button>'+
                '<button type="button" class="btn btn-light-danger ms-4 btn-sm remove-submenu-2">Remove</button>'+
                '</div>'+
                '</div>'+
                '</div>'+
                '<div class="col-12 pt-10 submenu-3-col">'+
                '<div class="row mb-4">'+
                '<div class="col-4"></div>'+
                '<div class="col-4">'+
                '<label class="fs-6 fw-semibold mb-2">Submenu 3</label>'+
                '<input type="text" class="form-control form-control-solid" name="submenu_3['+submenuCount+'][0][]">'+
                '</div>'+
                '<div class="col-4 pt-10">'+
                '<button type="button" class="btn btn-light-danger me-auto btn-sm remove-submenu-3">Remove</button>'+
                '</div>'+
                '</div>'+
                '</div>'+
                '</div>'+
                '</div>'+
                '<div class="col-12 pt-10 text-center">'+
                '<button type="button" class="btn btn-light-primary btn-sm me-auto add-submenu-2">Add Submenu 2</button>'+
                '</div>'+
                '</div>'+
                '</div>'+
                '</div>';

                $('#submenu-col').append(html);
            });
        });
    </script>
@endpush
