@extends('layouts.dashboard')
@section('toolbar-heading','Menu Management')
@section('breadcrumb','Home')
@section('breadcrumb1','Menu Management')
@section('action-btn')
@can('create_menu')
    <a href="{{ route('menu.create') }}" class="btn btn-sm btn-primary">Create</a>
@endcan
@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">#</th>
                    <th class="min-w-125px">Name</th>
                    @canany(['edit_menu','delete_menu'])
                        <th class="text-end min-w-70px">Actions</th>
                    @endcanany
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($menus as $key => $menu)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $menu->name }}</td>
                        @canany(['edit_menu','delete_menu'])
                            <td class="text-end">
                                @can('edit_menu')
                                    <a href="{{ route('menu.edit',$menu->id) }}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-pencil-fill fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                                @can('delete_menu')
                                    <a href="#" onclick="delete_this('{{route('menu.destroy',$menu->id)}}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-trash3 fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                            </td>
                        @endcanany
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script>
        $('#kt_users_table').dataTable();
    </script>
@endpush
