@extends('layouts.dashboard')
@section('toolbar-heading','Offices')
@section('breadcrumb','Home')
@section('breadcrumb1','Offices')
@section('content')
    <div class="card">
        <div class="card-header">
            <div class="card-title fs-3 fw-bold">Edit Office</div>
        </div>
        <form id="kt_project_settings_form" action="{{ route('office.update',$office->id) }}" class="form" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="card-body p-9">
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Country</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" value="{{ $office->country }}" name="country" id="country" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Company Name</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" value="{{ $office->company_name }}" name="company_name" id="company_name" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">Trade ID</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" value="{{ $office->trade_id }}" name="trade_id" id="trade_id" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Address</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" value="{{ $office->address }}" name="address" id="address" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">Phone</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" value="{{ $office->phone }}" name="phone" id="phone" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">Mobile</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" value="{{ $office->mobile }}" name="mobile" id="mobile" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">What's App</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" value="{{ $office->whatsapp }}" name="whatsapp" id="whatsapp" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">E-Mail</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="email" class="form-control form-control-solid" value="{{ $office->email }}" name="email" id="email" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Web URL</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" value="{{ $office->web_url }}" name="web_url" id="web_url" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Image</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="file" class="form-control form-control-solid" value="{{ old('image') }}" name="image" id="image" />
                        <div>
                            <img src="{{ get_file('office', $office->image) }}" width="150px" height="150px" alt="Image" id="currentImage">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Status</div>
                    </div>
                    <div class="col-xl-9">
                        <div class="form-check form-switch form-check-custom form-check-solid">
                            <input class="form-check-input" type="checkbox" id="status" name="status" {{ $office->status ? 'checked' : ''  }} />
                            <label class="form-check-label fw-semibold text-gray-400 ms-3" for="status"></label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex justify-content-end py-6 px-9">
                <button type="submit" class="btn btn-primary" id="kt_project_settings_submit">Save</button>
            </div>
        </form>
    </div>
@endsection
