@extends('layouts.dashboard')
@section('toolbar-heading','Permissions')
@section('breadcrumb','Home')
@section('breadcrumb1','Permissions')
@section('action-btn')
    <button onclick="modal('{{route('permission.create')}}')" class="btn btn-sm btn-primary">Create</button>
@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-4">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Group</th>
                    <th class="text-end min-w-70px">Actions</th>
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($permissions as $permission)
                    <tr>
                        <td>{{ ucwords(str_replace('_',' ',$permission->name)) }}</td>
                        <td>{{ $permission->name }}</td>
                        <td>{{ $permission->group }}</td>
                        <td class="text-end">
                            <button type="button" onclick="modal('{{route('permission.edit',$permission->id)}}')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                    <i class="bi bi-pencil-fill fs-7"></i>
                                </span>
                            </button>
                            <button type="button" onclick="delete_this('{{ route('permission.destroy',$permission->id) }}','Delete Permission')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                    <i class="bi bi-trash3 fs-7"></i>
                                </span>
                            </button>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script>
        $('#kt_users_table').dataTable();
    </script>
@endpush
