@extends('layouts.dashboard')
@section('toolbar-heading','Roles')
@section('breadcrumb','Home')
@section('breadcrumb1','Roles')
@section('action-btn')
    @can('create_role')
        <a href="{{route('role.create')}}" class="btn btn-sm btn-primary">Create</a>
    @endcan
@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-4">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th>Name</th>
                    <th>Users</th>
                    <th>Permissions</th>
                    @canany(['edit_role','delete_role'])
                        <th class="text-end min-w-70px">Actions</th>
                    @endcanany
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($roles as $role)
                    <tr>
                        <td>{{ $role->name }}</td>
                        <td>{{ $role->users->count() }}</td>
                        <td>{{ $role->permissions->count() }}</td>
                        @canany(['edit_role','delete_role'])
                            <td class="text-end">
                                <div class="ms-2">
                                    <button type="button" class="btn btn-sm btn-icon btn-light btn-active-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                <span class="svg-icon svg-icon-5 m-0">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect x="10" y="10" width="4" height="4" rx="2" fill="currentColor"></rect>
                                        <rect x="17" y="10" width="4" height="4" rx="2" fill="currentColor"></rect>
                                        <rect x="3" y="10" width="4" height="4" rx="2" fill="currentColor"></rect>
                                    </svg>
                                </span>
                                    </button>
                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-150px py-4" data-kt-menu="true" style="">
                                        @can('edit_role')
                                            <div class="menu-item px-3">
                                                <a href="{{route('role.edit',$role->id)}}" class="menu-link px-3">Edit</a>
                                            </div>
                                        @endcan
                                        @can('delete_role')
                                            <div class="menu-item px-3">
                                                <a href="#" class="menu-link px-3" onclick="delete_this('{{ route('role.destroy',$role->id) }}','Delete Role')">Delete</a>
                                            </div>
                                        @endcan
                                    </div>
                                </div>
                            </td>
                        @endcanany
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script>
        $('#kt_users_table').dataTable();
    </script>
@endpush
