@extends('layouts.dashboard')
@section('toolbar-heading','Settings')
@section('breadcrumb','Home')
@section('breadcrumb1','Settings')
@section('content')
@include('backend.settings.header')
<div class="card">
    <form action="{{ route('settings.index') }}" class="form" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="card-body p-9">
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="fs-6 fw-semibold mb-2">Sidebar Logo (Light)</label>
                </div>
                <div class="col-lg-9">
                    <input type="file" class="form-control" name="logo_light" />
                </div>
            </div>
            <div>
                <img src="{{ asset('assets/media/img/'. $settings['logo_light']) }}" style="width:100px; hegiht:50px">
                </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="fs-6 fw-semibold mb-2">Logo</label>
                </div>
                <div class="col-lg-9">
                    <input type="file" class="form-control" name="logo" />
                </div>
            </div>
            <div>
                <img src="{{ asset('assets/media/img/' . $settings['logo']) }}" style="width:100px; hegiht:50px">
                </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="fs-6 fw-semibold mb-2">Favicon</label>
                </div>
                <div class="col-lg-9">
                    <input type="file" class="form-control" name="favicon" />
                </div>
            </div>
            <div>
                <img src="{{ asset('assets/media/img/' . $settings['favicon']) }}" style="width:100px; hegiht:50px">
                </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <div class="fs-6 fw-semibold mt-2 mb-3 required">Timezone</div>
                </div>
                <div class="col-xl-8 fv-row">
                    <select name="timezone" data-control="select2" data-hide-search="false" class="form-select form-select-solid">
                        @foreach($timezones as $keyVal => $timezone)
                            <option value="{{ $timezone->name }}" {{ $timezone->name == env('APP_TIMEZONE') ? 'selected' : '' }}>{{ $timezone->name }} ({{ $timezone->time }})</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">App Name</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="app_name" value="{{ $settings['app_name'] }}" />
                </div>
            </div>
            
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="fs-6 fw-semibold mb-2">Footer (Admin Panel)</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="footer_text_admin" value="{{ $settings['footer_text_admin'] }}" />
                </div>
            </div>
        </div>
        <div class="card-footer d-flex justify-content-end py-6 px-9">
            <button type="submit" class="btn btn-primary">Save</button>
        </div>
    </form>
</div>
@endsection
