<li class="p-2">
    <div class="d-flex justify-content-between align-items-center">
        <a>{{ $menuItem->title }}</a>
        <div class="btn-group">
            <a href="{{ route('settings.menuEdit', $menuItem->id) }}" class="btn btn-sm btn-outline-primary"><i class="fas fa-pencil-alt"></i></a>
            <a href="{{ route('settings.menuDelete', $menuItem->id) }}" onclick="return confirm('Are you sure?');" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></a>
            @if ($menuItem->children->isNotEmpty())
                <button class="btn btn-sm btn-outline-secondary" data-toggle="collapse" data-target="#collapse-{{ $menuItem->id }}" aria-expanded="false" aria-controls="collapse-{{ $menuItem->id }}"><i class="fas fa-chevron-down" id="icon-{{ $menuItem->id }}"></i></button>
            @endif
        </div>
    </div>
    
    @if ($menuItem->children->isNotEmpty())
        <ul class="collapse ml-3 mt-2" id="collapse-{{ $menuItem->id }}">
            @foreach ($menuItem->children as $child)
                @include('backend.settings.menu.menu-item', ['menuItem' => $child])
            @endforeach
        </ul>
    @endif
</li>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<!-- Popper.js -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
<!-- Bootstrap JS -->
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<script>
    $(document).ready(function() {
        // Set up collapse toggling
        $('[data-toggle="collapse"]').each(function() {
            var button = $(this);
            var icon = button.find('i');
            var collapseTarget = button.data('target');

            // Toggle icon on shown.bs.collapse and hidden.bs.collapse events
            $(collapseTarget).on('shown.bs.collapse', function() {
                icon.removeClass('fa-chevron-down').addClass('fa-chevron-up');
            });

            $(collapseTarget).on('hidden.bs.collapse', function() {
                icon.removeClass('fa-chevron-up').addClass('fa-chevron-down');
            });
        });

        // Handle click event to toggle collapse
        $('[data-toggle="collapse"]').on('click', function() {
            var button = $(this);
            var icon = button.find('i');
            var collapseTarget = button.data('target');

            $(collapseTarget).collapse('toggle');

            // Toggle icon class immediately
            if ($(collapseTarget).hasClass('show')) {
                icon.removeClass('fa-chevron-down').addClass('fa-chevron-up');
            } else {
                icon.removeClass('fa-chevron-up').addClass('fa-chevron-down');
            }
        });
    });
</script>
