@extends('layouts.dashboard')
@section('toolbar-heading','Settings')
@section('breadcrumb','Home')
@section('breadcrumb1','Settings')
@section('content')
@include('backend.settings.header')
<div class="card">
    <form action="{{ route('settings.smtp') }}" class="form" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="card-body p-9">
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Enable SMTP</label>
                </div>
                <div class="col-lg-9">
                    <div class="form-check form-switch">
                        <input class="form-check-input" name="enable_email" type="checkbox" role="switch" {{ $settings['enable_email'] ? 'checked' : '' }}>
                    </div>
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Driver</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="mail_driver" value="{{ env('MAIL_DRIVER') }}" />
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Host</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="mail_host" value="{{ env('MAIL_HOST') }}" />
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Port</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="mail_port" value="{{ env('MAIL_PORT') }}" />
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Username</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="mail_username" value="{{ env('MAIL_USERNAME') }}" />
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Password</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="mail_password" value="{{ env('MAIL_PASSWORD') }}" />
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Encryption</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="mail_encryption" value="{{ env('MAIL_ENCRYPTION') }}" />
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">From Address</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="mail_from_address" value="{{ env('MAIL_FROM_ADDRESS') }}" />
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">From Name</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="mail_from_name" value="{{ env('MAIL_FROM_NAME') }}" />
                </div>
            </div>
        </div>
        <div class="card-footer d-flex py-6 px-9">
            <button type="button" onclick="modal('{{route('settings.test.mail')}}')" class="btn btn-light">Send test mail</button>
            <button type="submit" class="btn btn-primary ml-auto">Save</button>
        </div>
    </form>
</div>
@endsection
