@extends('layouts.dashboard')
@section('toolbar-heading','Testimonial')
@section('breadcrumb','Home')
@section('breadcrumb1','Testimonial')
@section('action-btn')
@can('create_hero_section')
    <a href="{{ route('testimonial.add') }}" class="btn btn-sm btn-primary">Create</a>
@endcan
@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">#</th>
                    <th class="min-w-125px">Title</th>
                        <th class="min-w-125px">Description</th>
                    <th class="min-w-125px">Image</th>
                        <th class="text-end min-w-70px">Actions</th>
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600 cursor-move" id="sortable">
                @foreach($testimonial as $key => $list)
                    <tr>
                        <td>{{$key+1}}</td>
                        <td>{{ $list->name }}</td>
                        <td>{{ $list->description }}</td>
                        <td><img src="{{ get_file('testimonial',$list->image) }}" width="60px" height="60px" alt="Image"></td>
                        
                        <td class="text-end">
                                <a href="{{ route('testimonial.edit',$list->id) }}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-pencil-fill fs-7"></i>
                                    </span>
                                </a>
                                <a href="#" onclick="delete_this('{{route('testimonial.delete',$list->id)}}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-trash3 fs-7"></i>
                                    </span>
                                </a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.3/jquery-ui.min.js"></script>
    <script>
      $('#kt_users_table').dataTable();
    </script>
@endpush
