@extends('layouts.dashboard')
@section('toolbar-heading','Staff')
@section('breadcrumb','Home')
@section('breadcrumb1','Staff')
@section('action-btn')
    @can('create_staff')
        <a href="{{route('users.create')}}" class="btn btn-sm btn-primary">Create</a>
    @endcan
@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-4">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th>Image</th>
                    <th>Name</th>
                    <th>Email</th>
                    @can('edit_staff')
                        <th>Status</th>
                    @endcan
                    @canany(['edit_staff','reset_staff_password','delete_staff'])
                        <th class="text-end min-w-70px">Actions</th>
                    @endcanany
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($users as $user)
                    <tr>
                        <td>
                            <img src="{{ user_profile($user->profile) }}" width="60px" height="60px" alt="Profile Image">
                        </td>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        @can('edit_staff')
                            <td>
                                <div class="form-check form-switch">
                                    <input class="form-check-input status" type="checkbox" role="switch" value="{{ $user->id }}" {{ $user->status ? 'checked' : '' }}>
                                </div>
                            </td>
                        @endcan
                        @canany(['edit_staff','reset_staff_password','delete_staff'])
                            <td class="text-end">
                                @can('edit_staff')
                                    <a href="{{route('users.edit',$user->id)}}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-pencil-fill fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                                @can('reset_staff_password')
                                    <a href="#" onclick="modal('{{route('reset.user.password',$user->id)}}','{{__('Reset Password')}}')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-key fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                                @can('delete_staff')
                                    <a href="#" onclick="delete_this('{{ route('users.destroy',$user->id) }}','Delete Staff')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-trash3 fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                            </td>
                        @endcanany
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script>
        $('#kt_users_table').dataTable();
        $(document).on('click', '.status', function ()
        {
            var status = $(this).is(":checked") ? 1 : 0;
            var id = $(this).val();
            $.ajax({
                url: '{{ route('user-status') }}',
                type: "GET",
                data: {
                    'id' : id,
                    'status' : status,
                },
                dataType: "json",
                success:function(response) {
                    createToast(response.status,response.message);
                }, error: function (response){
                    createToast('error','{{ __('Something went wrong') }}');
                }
            });
        });
    </script>
@endpush
