<?php

use App\Http\Controllers\BlogCategoryController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\FaqCategoryController;
use App\Http\Controllers\FaqController;
use App\Http\Controllers\HeroController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\OfficesController;
use App\Http\Controllers\PagesController;
use App\Http\Controllers\PageSectionController;
use App\Http\Controllers\PartnersController;
use App\Http\Controllers\PermissionsController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\TeamMembersController;
use App\Http\Controllers\HomeSectionController;
use App\Http\Controllers\GlobalReachController;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\CareerController;
use App\Http\Controllers\AboutUsController;
use App\Http\Controllers\TestimonialController;

use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/controller', function() {
    $exitCode = Artisan::call('make:controller Api/TestimonialController');
    return 'DONE';
});

Auth::routes();

Route::get('/', [HomeController::class, 'dashboard'])->name('home')->middleware('auth');

Route::middleware(['auth'])->group(function ()
{
    Route::get('home', [HomeController::class, 'dashboard'])->name('home');
    Route::get('settings/profile', [UsersController::class, 'profile'])->name('settings.profile');
    Route::post('update-profile', [UsersController::class, 'updateProfile'])->name('update-profile');
    Route::post('update-email', [UsersController::class, 'updateEmail'])->name('update-email');
    Route::post('change-password', [UsersController::class, 'changePassword'])->name('change-password');

    Route::group(['prefix'=>'admin'], function()
    {
        Route::get('enquires', [HomeController::class, 'enquires'])->name('enquires');

        // user
        Route::resource('users', UsersController::class);
        Route::get('user-status', [UsersController::class, 'updateStatus'])->name('user-status');
        Route::post('/removeimage', [UsersController::class, 'removeImage'])->name('remove.image');

        Route::match(['GET', 'POST'],'reset-user-password/{id}', [UsersController::class, 'resetPassword'])->name('reset.user.password');

        // role
        Route::resource('role', RoleController::class);
        // permission
        Route::resource('permission', PermissionsController::class);
        // settings
        Route::match(['GET', 'POST'], 'settings', [SettingsController::class, 'index'])->name('settings.index');
        Route::match(['GET', 'POST'], 'about-us', [AboutUsController::class, 'about_us'])->name('about_us.index');
        Route::match(['GET', 'POST'],'settings/smtp', [SettingsController::class, 'smtp'])->name('settings.smtp');
        Route::match(['GET', 'POST'],'settings/test-mail', [SettingsController::class, 'testMail'])->name('settings.test.mail');
        Route::match(['GET', 'POST'],'settings/footer', [SettingsController::class, 'footer'])->name('settings.footer');
        Route::match(['GET', 'POST'],'settings/menu', [SettingsController::class, 'menuindex'])->name('settings.menu');
        Route::match(['GET', 'POST'],'settings/menu/create', [SettingsController::class, 'menuCreate'])->name('settings.menuCreate');
        Route::match(['GET', 'POST'],'settings/menu/store', [SettingsController::class, 'menuStore'])->name('settings.menuStore');
        Route::match(['GET', 'POST'],'settings/menu/edit/{id}', [SettingsController::class, 'menuEdit'])->name('settings.menuEdit');
        Route::match(['GET', 'POST'],'settings/menu/menuUpdate/{id}', [SettingsController::class, 'menuUpdate'])->name('settings.menuUpdate');
        Route::match(['GET', 'POST'],'settings/menu/menuDelete/{id}', [SettingsController::class, 'menuDelete'])->name('settings.menuDelete');
        // blog category
        Route::resource('blog-category', BlogCategoryController::class);
        Route::get('blog-category-status', [BlogCategoryController::class, 'updateStatus'])->name('blog-category-status');

        // blog
        Route::resource('blog', BlogController::class);
        Route::get('blog-status', [BlogController::class, 'updateStatus'])->name('blog-status');
        Route::post('blog/uploader', [BlogController::class, 'uploader'])->name('ckeditor.upload');
        Route::post('/remove-blogimage', [BlogController::class, 'removeblogImage'])->name('removeblog.image');

        // hero
        Route::resource('hero-section', HeroController::class);
        Route::get('hero-status', [HeroController::class, 'updateStatus'])->name('hero-status');
        Route::post('ajax/sort-hero-section', [HeroController::class, 'sort'])->name('sort-hero-section');
        Route::post('/remove-heroimage', [HeroController::class, 'removeImage'])->name('removehero.image');

        // contact us
        Route::resource('office', OfficesController::class);
        Route::get('office-status', [OfficesController::class, 'updateStatus'])->name('office-status');


        // faq category
        Route::resource('faq-category', FaqCategoryController::class);
        Route::get('faq-category-status', [FaqCategoryController::class, 'updateStatus'])->name('faq-category-status');
        
        Route::get('faq-category/{fc_id}/faq-add', [FaqCategoryController::class, 'faqindex'])->name('faq-faqindex');

        // faq
        Route::resource('faq', FaqController::class);
        Route::get('faq-status', [FaqController::class, 'updateStatus'])->name('faq-status');

        // page section
        Route::resource('page-section', PageSectionController::class);
        Route::get('page-section-status', [PageSectionController::class, 'updateStatus'])->name('page-section-status');
        Route::post('storeourjourney', [PageSectionController::class, 'storeourjourney'])->name('storeourjourney');
        Route::delete('deleteOurjourney/{id}', [PageSectionController::class, 'deleteOurjourney'])->name('deleteOurjourney');
        Route::get('ourjourney/{id}/edit', [PageSectionController::class, 'manage_ourjourney'])->name('edit.manage_ourjourney');
        Route::get('ourjourney/add', [PageSectionController::class, 'manage_ourjourney'])->name('add.manage_ourjourney');
        Route::get('ourjourney', [PageSectionController::class, 'ourjourneyList'])->name('ourjourney.list');
        Route::post('/remove-pagesimage', [PageSectionController::class, 'removeImage'])->name('removepages.image');
        Route::post('/remove-sectionimage', [PageSectionController::class, 'removesectionImage'])->name('removesection.image');
        //crud
        Route::match(['GET', 'POST'], 'career', [CareerController::class, 'ourCareerList'])->name('career.list');
        Route::post('storecareer', [CareerController::class, 'storecareer'])->name('career.storecareer');
        Route::get('careers/add', [CareerController::class, 'manage_career'])->name('add.career');
        Route::get('career/{id}/edit', [CareerController::class, 'manage_career'])->name('career.edit');

        Route::delete('/career/{id}', [CareerController::class, 'delete'])->name('career.delete');
        
        // pages
        Route::resource('pages', PagesController::class);
        Route::get('pages-status', [PagesController::class, 'updateStatus'])->name('pages-status');
        Route::get('pages-pdf-delete/{id}', [PagesController::class, 'pdfDelete'])->name('pages.pdfDelete');
        // Route::post('/remove-pagesimage', [PagesController::class, 'removeImage'])->name('removepages.image');

        // team member
        Route::resource('team-member', TeamMembersController::class);
        Route::get('team-member-status', [TeamMembersController::class, 'updateStatus'])->name('team-member-status');
        Route::post('/remove-teamimage', [TeamMembersController::class, 'removeImage'])->name('removeteam.image');

        // team member
        Route::resource('partners', PartnersController::class);
        Route::get('partners-status', [PartnersController::class, 'updateStatus'])->name('partners-status');
        Route::post('/remove-partimage', [PartnersController::class, 'removeImage'])->name('removepart.image');

        // menu management
        Route::resource('menu', MenuController::class);
        //Get_in_touch Table fetch
        Route::get('get-in-touch', [MenuController::class, 'get_in_touch'])->name('get-in-touch');
        //Resume Table Fetch
         Route::get('resume', [MenuController::class, 'resume'])->name('resume');
         
         
         //Banner Section
         
       
         Route::get('banner-section',[HomeSectionController::class,'index'])->name('banner.list');
        

        //GlobalReach
        Route::match(['GET', 'POST'], 'global-reach', [GlobalReachController::class, 'index'])->name('global-reach.list');
        Route::get('global-reach/add', [GlobalReachController::class, 'manage_global_reach'])->name('global-reach.add');
        Route::post('storebanner_section', [GlobalReachController::class, 'store'])->name('global-reach.store');
        Route::get('global-reach/{id}/edit', [GlobalReachController::class, 'manage_global_reach'])->name('global-reach.edit');
        Route::delete('global-reach-delete/{id}', [GlobalReachController::class, 'delete_global'])->name('global-reach.delete');
        Route::post('/remove-globalimage', [GlobalReachController::class, 'removeImage'])->name('removeglobal.image');
        
        
        //Testimonial
        Route::get('testimonial',[TestimonialController::class,'index'])->name('testimonial.list');
        Route::get('testimonial/add', [TestimonialController::class, 'manage_testimonial'])->name('testimonial.add');
        Route::post('testimonial', [TestimonialController::class, 'store'])->name('testimonial.store');
        Route::get('testimonial/{id}/edit', [TestimonialController::class, 'manage_testimonial'])->name('testimonial.edit');
        Route::delete('testimonial-delete/{id}', [TestimonialController::class, 'delete_testimonial'])->name('testimonial.delete');
        Route::post('/remove-testimonialimage', [TestimonialController::class, 'removeImage'])->name('remove.testimonialimage');


    });
});
