<?php $__env->startSection('toolbar-heading','FAQ'); ?>
<?php $__env->startSection('breadcrumb','Home'); ?>
<?php $__env->startSection('breadcrumb1','FAQ'); ?>
<?php $__env->startSection('content'); ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_faq')): ?>
    <div class="pb-4 text-end">
        <button onclick="modal('<?php echo e(route('faq.create')); ?>','lg')" class="btn btn-sm btn-primary">Create</button>
    </div>
<?php endif; ?>
<div class="card">
    <div class="card-body pt-4">
        <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
            <thead>
            <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                <th>Title</th>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_faq')): ?>
                    <th>Status</th>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['edit_faq','delete_faq'])): ?>
                    <th class="text-end min-w-70px">Actions</th>
                <?php endif; ?>
            </tr>
            </thead>
            <tbody class="fw-semibold text-gray-600">
            <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($faq->title); ?></td>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_faq')): ?>
                        <td>
                            <div class="form-check form-switch">
                                <input class="form-check-input status" type="checkbox" role="switch" value="<?php echo e($faq->id); ?>" <?php echo e($faq->status ? 'checked' : ''); ?>>
                            </div>
                        </td>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['edit_faq','delete_faq'])): ?>
                        <td class="text-end">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_faq')): ?>
                                <button type="button" onclick="modal('<?php echo e(route('faq.edit',$faq->id)); ?>','lg')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-pencil-fill fs-7"></i>
                                    </span>
                                </button>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_faq')): ?>
                                <button type="button" onclick="delete_this('<?php echo e(route('faq.destroy',$faq->id)); ?>','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-trash3 fs-7"></i>
                                    </span>
                                </button>
                            <?php endif; ?>
                        </td>
                    <?php endif; ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('java-script'); ?>
<script>
    $('#kt_users_table').dataTable();

    $(document).on('click', '.status', function ()
    {
        var status = $(this).is(":checked") ? 1 : 0;
        var id = $(this).val();
        $.ajax({
            url: '<?php echo e(route('faq-status')); ?>',
            type: "GET",
            data: {
                'id' : id,
                'status' : status,
            },
            dataType: "json",
            success:function(response) {
                createToast(response.status,response.message);
            }, error: function (response){
                createToast('error','<?php echo e(__('Something went wrong')); ?>');
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/swipetoshared/public_html/admin/resources/views/backend/faq/index.blade.php ENDPATH**/ ?>