<?php $__env->startSection('toolbar-heading','Blogs'); ?>
<?php $__env->startSection('breadcrumb','Home'); ?>
<?php $__env->startSection('breadcrumb1','Blogs'); ?>
<?php $__env->startSection('action-btn'); ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_blog')): ?>
    <a href="<?php echo e(route('blog.create')); ?>" class="btn btn-sm btn-primary">Create</a>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">#</th>
                    <th class="min-w-125px">Title</th>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_blog')): ?>
                        <th class="min-w-125px">Status</th>
                    <?php endif; ?>
                    <th class="min-w-125px">Created At</th>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['edit_blog','delete_blog'])): ?>
                        <th class="text-end min-w-70px">Actions</th>
                    <?php endif; ?>
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key + 1); ?></td>
                        <td><?php echo e($blog->title); ?></td>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_blog')): ?>
                            <td>
                                <div class="form-check form-switch">
                                    <input class="form-check-input status" type="checkbox" role="switch" value="<?php echo e($blog->id); ?>" <?php echo e($blog->status ? 'checked' : ''); ?>>
                                </div>
                            </td>
                        <?php endif; ?>
                        <td>
                            <?php echo e($blog->created_at->format('d M, Y')); ?>

                        </td>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['edit_blog','delete_blog'])): ?>
                            <td class="text-end">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_blog')): ?>
                                    <a href="<?php echo e(route('blog.edit',$blog->id)); ?>" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-pencil-fill fs-7"></i>
                                        </span>
                                    </a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_blog')): ?>
                                    <a href="<?php echo e(route('blog.show',$blog->id)); ?>" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-eye fs-7"></i>
                                        </span>
                                    </a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_blog')): ?>
                                    <a href="#" onclick="delete_this('<?php echo e(route('blog.destroy',$blog->id)); ?>','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-trash3 fs-7"></i>
                                        </span>
                                    </a>
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('java-script'); ?>
    <script>
        $('#kt_users_table').dataTable();
        $(document).on('click', '.status', function ()
        {
            var status = $(this).is(":checked") ? 1 : 0;
            var id = $(this).val();
            $.ajax({
                url: '<?php echo e(route('blog-status')); ?>',
                type: "GET",
                data: {
                    'id' : id,
                    'status' : status,
                },
                dataType: "json",
                success:function(response) {
                    createToast(response.status,response.message);
                }, error: function (response){
                    createToast('error','<?php echo e(__('Something went wrong')); ?>');
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elevatebpm/public_html/admin/resources/views/backend/blog/index.blade.php ENDPATH**/ ?>