<?php $__env->startSection('toolbar-heading','Testimonial'); ?>
<?php $__env->startSection('breadcrumb','Home'); ?>
<?php $__env->startSection('breadcrumb1','Testimonial'); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <div class="card-title fs-3 fw-bold">Testimonial</div>
        </div>
        <form id="kt_project_settings_form" action="<?php echo e(route('testimonial.store')); ?>" class="form" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="card-body p-9">
                <input type="hidden" name="id"  value="<?php echo e($id); ?>" />
                <div class="row mb-5" id="image-div">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Image</div>
                    </div>
                    <label class=" btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow remove-image-btn" id="remove-image" title="Remove image">
                            <i class="bi bi-x fs-4"></i>
                        </label>
                    <div class="col-lg-8">
                        <div class="image-input image-input-outline image-input-empty" data-kt-image-input="true" style="">
                            <div class="image-input-wrapper w-125px h-125px bgi-position-center" style="background-image:url('<?php echo e(get_file('testimonial',$image)); ?>')" id="img-div"></div>
                            <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Change avatar">
                                <i class="bi bi-pencil-fill fs-7"></i>
                                <input type="file" id="image" name="image" accept=".png, .jpg, .jpeg" />
                                <input type="hidden" name="image_remove" />
                            </label>
                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Cancel image">
                                <i class="bi bi-x fs-2"></i>
                            </span>
                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Remove image">
                                <i class="bi bi-x fs-2"></i>
                            </span>
                        </div>
                        <div class="form-text">Allowed file types: png, jpg, jpeg.</div>
                        <input type="hidden" name="image" id="image" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">Name</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" name="name" value="<?php echo e($name); ?>" id="name" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">Designation</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" name="designation" value="<?php echo e($designation); ?>" id="designation" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">Description</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" name="description" value="<?php echo e($description); ?>" id="description" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">Type</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <select name="type" aria-label="<?php echo e(__('Select Type')); ?>" data-control="select2" data-placeholder="<?php echo e(__('Select Type')); ?>" class="form-select form-select-solid form-select-lg" id="type">
                            <option value="">Select Type</option>
                                <option value="client" <?php echo e($type == 'client' ? 'selected' : ''); ?>>Client</option>
                                <option value="team" <?php echo e($type == 'team' ? 'selected' : ''); ?>>Team</option>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Status</div>
                    </div>
                    <div class="col-xl-9">
                        <div class="form-check form-switch form-check-custom form-check-solid">
                            <input class="form-check-input" type="checkbox" id="status" name="status" <?php echo e($status ? 'checked' : ''); ?> />
                            <label class="form-check-label fw-semibold text-gray-400 ms-3" for="status"></label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex justify-content-end py-6 px-9">
                <button type="submit" class="btn btn-primary" id="kt_project_settings_submit">Save</button>
            </div>
        </form>
         <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.1.3/js/bootstrap.bundle.min.js"></script>
<script>
$(document).ready(function() {
    $('#remove-image').click(function() {
       
        if (confirm('Are you sure you want to remove the image?')) {
            $.ajax({
                url: '<?php echo e(route('remove.testimonialimage')); ?>',
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>', // CSRF token
                    id: '<?php echo e($id); ?>' // User ID
                },
                success: function(response) {
                    if (response.success) {
                        $('#img-div').css('background-image', 'none'); // Clear the image
                        alert(response.message);
                    } else {
                        alert(response.message);
                    }
                },
                error: function(xhr) {
                    $('#img-div').css('background-image', 'none'); // Clear the image on error
                    alert('An error occurred while removing the image.');
                }
            });
        }
    });
});
</script>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elevatebpm/public_html/admin/resources/views/backend/testimonial/create.blade.php ENDPATH**/ ?>