<?php

namespace App\Http\Controllers\Api\v2;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class CareerController extends Controller
{
    public function ourCareerList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $career = DB::table('career')->where('id',$id)->first();
        
        }else{
            $career['section_1']  = DB::table('settings')->select('key', 'value')->whereIn('key', ['careers_title', 'careers_subtitle'])->get();
            if($request->input('perpage') > 0){
         $career['section_2'] = DB::table('career')->simplePaginate($request->input('perpage'));  
            }else{
            $career['section_2'] = DB::table('career')->get();    
            }
         
        }
        return response()->json(['career' => $career], 200);
    }
    
    public function storeCareer(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'profile' => 'required',
                'qualification' => 'required',
                'candidate' => 'required',
                'location' => 'required',
                'profile_description' => 'required',
                'no_of_positions' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
        
        $data = [
            'profile' => $request->post('profile'),
            'qualification' => $request->post('qualification'),
            'profile_description' => $request->post('profile_description'),
            'candidate' => $request->post('candidate'),
            'location' => $request->post('location'),
            'no_of_positions' => $request->post('no_of_positions'),
        ];
        
        
        DB::table('career')->insert($data);

         return response()->json(['message' => 'Career Created Successfully']);
    }
    
    public function updateCareer(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'profile' => 'required',
                'qualification' => 'required',
                'candidate' => 'required',
                'location' => 'required',
                'profile_description' => 'required',
                'no_of_positions' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
        
       $career = DB::table('career')->where('id', $request->id)->first();
        
        if (!$career) {
            return response()->json(['error' => 'Career not found'], 404);
        }
        
        $data = [
            'profile' => $request->post('profile'),
            'qualification' => $request->post('qualification'),
            'profile_description' => $request->post('profile_description'),
            'candidate' => $request->post('candidate'),
            'location' => $request->post('location'),
            'no_of_positions' => $request->post('no_of_positions'),
        ];
        
        DB::table('career')->where('id', $request->id)->update($data);

        return response()->json(['message' => 'Career Updated Successfully']);
    }
    
    public function deleteCareer(Request $request)
    {
        $id = $request->input('id');
        $career = DB::table('career')->where('id', $id)->delete();
        if (!$career) {
            return response()->json([
                    'error' => 'Career not found'
                ], 404);
        }
        return response()->json(['message' => 'Career Deleted Successfully']);
    }
    
}
