<?php

namespace App\Http\Controllers\Api\v2;

use App\Http\Controllers\Controller;
use App\Models\Faq;
use App\Models\FaqCategory;
use Illuminate\Http\Request;

class FaqController extends Controller
{
    
    // public function faqList(Request $request)
    // {
    //     $id = $request->input('id');
    //     if($id){
    //     $faq = Faq::where('id',$id)->get();
    //     }else{
    //         if($request->input('perpage') > 0){
    //     $faq = Faq::simplePaginate($request->input('perpage'));    
    //         }else{
    //             $faq = Faq::get();
    //         }
    //     }
    //     return response()->json(['faq' => $faq], 200);
    // }
    public function faqList(Request $request)
    {
        $id = $request->input('id');
        $type = $request->input('type');
        $perPage = $request->input('perpage');
    
        if ($id) {
            // Get FAQ by specific ID
            $faq = Faq::where('id', $id)->get();
        } else {
            // Start query builder
            $query = Faq::query();
    
            if ($type) {
                // Get category ID from FaqCategory
                $category = FaqCategory::where('name', $type)->first();
                if ($category) {
                    $query->where('faq_category', $category->id);
                } else {
                    // If type not found, return empty collection
                    return response()->json(['faq' => []], 200);
                }
            }
    
            // Apply pagination if perpage is provided
            if ($perPage && $perPage > 0) {
                $faq = $query->simplePaginate($perPage);
            } else {
                $faq = $query->get();
            }
        }
    
        return response()->json(['faq' => $faq], 200);
    }


    public function storeFaq(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'question' => 'required',
                'category' => 'required',
                'answer' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['status' => 'error', 'message' => $messages->first()]);
        }
        $faq = new Faq();
        $faq->title = $request->question;
        $faq->faq_category = $request->category;
        $faq->description = $request->answer;
        $faq->status = $request->status;
        $faq->save();
        return response()->json(['message' => 'Faq Created Successfully', 'faq' => $faq]);
    }


    public function updateFaq(Request $request)
    {
        $id = $request->id;
        $validator = \Validator::make(
            $request->all(), [
                'question' => 'required',
                'category' => 'required',
                'answer' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['status' => 'error', 'message' => $messages->first()]);
        }
        $faq = Faq::find($id);
        if (!$faq) {
            return response()->json(['error' => 'Faq not found'], 404);
        }
        $faq->title = $request->question;
        $faq->faq_category = $request->category;
        $faq->description = $request->answer;
        $faq->status = $request->status;
        $faq->update();
        return response()->json(['message' => 'Faq Updated Successfully', 'faq' => $faq]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function deleteFaq(Request $request)
    {
        $id = $request->input('id');
        $faq = Faq::find($id);
        if (!$faq) {
            return response()->json([
                    'error' => 'faq not found'
                ], 404);
        }
        $faq->delete();
        
        return response()->json(['message' => 'Faq Deleted Successfully']);
    }
    
    

    public function updateStatus(Request $request)
    {
        $faq = Faq::find($request->id);
        $faq->status = $request->status;
        $faq->update();
        return response()->json([
            'status' => 'success',
            'message' => __('Status updated')
        ]);
    }
}
