<?php

namespace App\Http\Controllers\Api\v2;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TeamMembers;

class PartnersController extends Controller
{
    public function partnersList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $partners = TeamMembers::where('type','partners')->where('id',$id)->first();
        if ($blogs) {
        $partners->image = $partners->image ? url('/') . '/storage/uploads/partners/' . $partners->image : null;
            }
        }else{
            if($request->input('perpage') > 0){
                $partners = TeamMembers::where('type','partners')->simplePaginate($request->input('perpage')); 
            }else{
                $partners = TeamMembers::where('type','partners')->get();
            }
        foreach ($partners as $list) {
                $list->image = $list->image ? url('/') .'/storage/uploads/partners/'. $list->image : null;
            }
        }
        return response()->json(['partners' => $partners], 200);
    }
    
    public function storePartners(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
                'designation' => 'required|string|max:255',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }


        $partners = new TeamMembers();
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'partners');
            $partners->image = $image;
        }
        $partners->name = $request->name;
        $partners->type = 'partners';
        $partners->designation = $request->designation;
        $partners->department = $request->department;
        $partners->description = $request->description;
        $partners->status = $request->status;
        $partners->save();

        return response()->json(['message' => 'Partners Added Successfully', 'partners' => $partners]);
    }
    
    public function updatePartners(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
                'designation' => 'required|string|max:255',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }

        $id = $request->input('id');
        $partners = TeamMembers::find($id);
        if (!$partners) {
            return response()->json(['error' => 'Partners not found'], 404);
        }
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'partners',$partners->image);
            $partners->image = $image;
        }
        $partners->name = $request->name;
        $partners->designation = $request->designation;
        $partners->department = $request->department;
        $partners->description = $request->description;
        $partners->status = $request->status;
        $partners->update();

        return response()->json(['message' => 'Partners Updated Successfully', 'partners' => $partners]);
    }
    
    public function deletePartners(Request $request)
    {
        $id = $request->input('id');
        $partners = TeamMembers::find($id);
        if (!$partners) {
            return response()->json([
                    'error' => 'Team Member not found'
                ], 404);
        }
        delete_file('partners',$partners->image);
        $partners->delete();
        return redirect()->back()->with('success','Partners Deleted Successfully');
    }
}