<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Mail\TestMail;
use App\Models\Settings;
use App\Models\Timezones;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Models\MenuItem;
use Illuminate\Support\Str;
use App\Models\Pages;
use DB;

class SettingsController extends Controller
{
    public function siteSettings(Request $request)
    {
        if($request->isMethod('POST'))
        {
            // $validator = \Validator::make(
            //     $request->all(), [
            //         'app_name' => 'required',
            //         'favicon' => 'image|mimes:png',
            //         'logo' => 'image|mimes:png',
            //         'logo_light' => 'image|mimes:png',
            //     ]
            // );

            // if ($validator->fails()) {
            //     $messages = $validator->getMessageBag();
            //     return response()->json(['error' => $messages->first()]);
            // }


            $timezone = ['APP_TIMEZONE' => $request->timezone];

            setEnv($timezone);

            foreach($request->only(['app_name','footer_text_admin','logo_light','favicon','logo','careers_title','careers_subtitle','careers_image']) as $key => $value)
            {
                if ($key == 'logo_light') {
                    $logo_light = 'logo_light.png';
                    $request->logo_light->move(public_path('assets/media/img'), $logo_light);
                    $value = 'logo_light.png';
                }
                
                if ($key == 'favicon') {
                    $favicon = 'favicon.png';
                    $request->favicon->move(public_path('assets/media/img'), $favicon);
                    $value = 'favicon.png';
                }
                
                if ($key == 'logo') {
                    $logo = 'logo.png';
                    $request->logo->move(public_path('assets/media/img'), $logo);
                    $value = 'logo.png';
                }
                
                if ($key == 'careers_image') {
                    $careers_image = 'careers_image.png';
                    $request->careers_image->move(public_path('assets/media/img'), $careers_image);
                    $value = 'careers_image.png';
                }
                
                $save = ['key' => $key, 'value' => $value];
                Settings::updateOrCreate(
                    [
                        'key' => $key
                    ], $save
                );
            }

            return response()->json(['message' => 'Settings updated']);
        }

        $timezones = Timezones::all();
        $settings = get_all_setting();
        $response = [
                'success' => true,
                'timezones' => $timezones,
                'settings' => $settings
            ];
            return response()->json($response);
    }
    
    public function getAllsettings(){
      $footer = DB::table('settings')->select('key', 'value')->get();
     
        foreach ($footer as $item) {
            if ($item->key == 'what_we_do' || $item->key == 'who_are_we' || $item->key == 'need_help') {
                $page = DB::table('pages')->select('name','slug')->whereIn('id',json_decode($item->value,true))->get();
                $item->value = $page;
            }
            
            if($item->key == 'logo_light'){
                $item->value = url('/').'/assets/media/img/'.$item->value;
            }
            if($item->key == 'logo'){
                $item->value = url('/').'/assets/media/img/'.$item->value;
            }
            if($item->key == 'favicon'){
                $item->value = url('/').'/assets/media/img/'.$item->value;
            }
            if($item->key == 'careers_image'){
                $item->value = url('/').'/assets/media/img/'.$item->value;
            }
            if($item->key == 'footer_logo'){
                $item->value = url('/').'/assets/media/img/'.$item->value;
            }
        }
        if (!$footer) {
            return response()->json([
                'success' => false,
                'message' => 'blog details not found'
            ], 404);
        }
    
    
        return response()->json([
            'success' => true,
            'message' => '',
            'data' => $footer
        ], 200);
    }
    
}
