<?php

use App\Models\Settings;
use Illuminate\Support\Facades\Storage;

if (!function_exists('default_settings')) {
    function default_settings()
    {
        $defaultData = [
            'currency_symbol' => '$',
            'currency_code' => 'USD',
            'currency_format' => 'left_without_space',
            'app_name' => 'Laravel',
            'footer_text_admin' => '',
            'enable_email' => 0,
            'footer_text_site' => '',
            'social_link_x' => '',
            'social_link_youtube' => '',
            'social_link_facebook' => '',
            'social_link_linkedin' => '',
        ];

        return $defaultData;
    }
}

if (!function_exists('get_setting')) {
    function get_setting($get_this)
    {
        $defaultData = default_settings();
        $settingsData = Settings::pluck('value','key')->all();
        $data = array_merge($defaultData,$settingsData);
        foreach($data as $key => $value) {
            if ($key == strtolower($get_this)){
                return $value;
            }
        }
    }
}

if (!function_exists('get_all_setting')) {
    function get_all_setting()
    {
        $defaultData = default_settings();
        $settingsData = Settings::pluck('value','key')->all();
        $data = array_merge($defaultData,$settingsData);
        return $data;
    }
}

if (!function_exists('currency_format')) {
    function currency_format($value)
    {
        $settingsData = get_all_setting();

        if($settingsData['currency_format'] == 'left_with_space')
        {
            return $settingsData['currency_symbol'] . ' ' . number_format($value, 2);
        }
        elseif($settingsData['currency_format'] == 'left_without_space')
        {
            return $settingsData['currency_symbol'] . number_format($value, 2);
        }
        elseif($settingsData['currency_format'] == 'right_with_space')
        {
            return number_format($value, 2) . ' ' . $settingsData['currency_symbol'];
        }
        elseif($settingsData['currency_format'] == 'right_without_space')
        {
            return number_format($value, 2) . $settingsData['currency_symbol'];
        }
    }
}

if (!function_exists('setEnv')) {
    function setEnv($array)
    {
        $envFile = app()->environmentFilePath();
        $str     = file_get_contents($envFile);
        if(count($array) > 0)
        {
            foreach($array as $envKey => $envValue)
            {
                $keyPosition       = strpos($str, "{$envKey}=");
                $endOfLinePosition = strpos($str, "\n", $keyPosition);
                $oldLine           = substr($str, $keyPosition, $endOfLinePosition - $keyPosition);
                if(!$keyPosition || !$endOfLinePosition || !$oldLine)
                {
                    $str .= "{$envKey}='{$envValue}'\n";
                }
                else
                {
                    $str = str_replace($oldLine, "{$envKey}='{$envValue}'", $str);
                }
            }
        }
        $str .= "\n";
        $str = substr($str, 0, -1);
        $str .= "\n";
        if(!file_put_contents($envFile, $str))
        {
            return false;
        }
        return true;
    }
}

if (!function_exists('get_file')) {
    function get_file($foldername,$filename = '')
    {
        if(!empty($filename) && Storage::exists('uploads/'.$foldername.'/' . $filename))
        {
            return asset(Storage::url('uploads/'.$foldername.'/' . $filename));
        }else{
            return asset(asset('assets/media/img/default-profile.png'));
        }
    }
}

if (!function_exists('user_profile')) {
    function user_profile($profile = null)
    {
        if(!empty($profile) && Storage::exists('uploads/profile/' . $profile)){
            return asset(Storage::url('uploads/profile/' . $profile));
        }else{
            return asset('assets/media/img/default-profile.png');
        }
    }
}

if (!function_exists('upload_file')) {
    function upload_file($file, $folderName, $oldFile = null)
    {
        mkdir(asset(Storage::url('uploads/'.$folderName.'/')), 0777, true);
        if(!empty($oldFile) && Storage::exists('uploads/'.$folderName.'/'.$oldFile))
        {
            asset(Storage::delete('uploads/'.$folderName.'/'.$oldFile));
        }
        $fileNameToStores = time() . rand(1,9999) . '.' . $file->getClientOriginalExtension();
        $path = $file->storeAs('uploads/'.$folderName.'/', $fileNameToStores);
        return $fileNameToStores;
    }
}

if (!function_exists('delete_file')) {
    function delete_file($folderName, $filename)
    {
        if(!empty($filename) && Storage::exists('uploads/'.$folderName.'/'.$filename))
        {
            asset(Storage::delete('uploads/'.$folderName.'/'.$filename));
        }
        return true;
    }
}

if (!function_exists('get_logo'))
{
    function get_logo()
    {
        return asset('assets/media/img/logo_light.png');
    }
}

if (!function_exists('get_favicon'))
{
    function get_favicon()
    {
        return asset('assets/media/img/favicon.png');
    }
}

if (!function_exists('auth_profile')) {
    function auth_profile()
    {
        $authUserProfile = auth()->user()->profile;

        if (!empty($authUserProfile) && Storage::exists('uploads/profile/' . $authUserProfile))
        {
            return asset(Storage::url('uploads/profile/' . $authUserProfile));
        }
        else
        {
            return asset(asset('assets/media/img/default-profile.png'));
        }
    }
}

if (!function_exists('get_auth_data')) {
    function get_auth_data($key)
    {
        $authUser = auth()->user();
        return $authUser[$key];
    }
}
