<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\FaqCategory;
use Illuminate\Http\Request;

class FaqCategoryController extends Controller
{
    public function faqCategoryList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $faqCategory = FaqCategory::where('id',$id)->get();
        }else{
        $faqCategory = FaqCategory::simplePaginate(10);    
        }
        return response()->json(['faqCategory' => $faqCategory], 200);
    }

    public function storeFaqCategory(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|unique:faq_categories',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['status' => 'error', 'message' => $messages->first()]);
        }
        $category = new FaqCategory();
        $category->name = $request->name;
        $category->status = $request->status;
        $category->save();
        return response()->json(['message' => 'FAQ Category Created Successfully', 'category' => $category]);
    }

    public function updateFaqCategory(Request $request)
    {
        $id = $request->id;
        $faqCategory = FaqCategory::find($id);
        if (!$faqCategory) {
            return response()->json(['error' => 'Faq Category not found'], 404);
        }
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|unique:faq_categories,name,' . $faqCategory->id,
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['status' => 'error', 'message' => $messages->first()]);
        }
        $faqCategory->name = $request->name;
        $faqCategory->status = $request->status;
        $faqCategory->update();
        return response()->json(['message' => 'FAQ Category Updated Successfully', 'faqCategory' => $faqCategory]);
    }

    public function deleteFaqCategory(Request $request)
    {
        
        $id = $request->input('id');
        $faqCategories = FaqCategory::find($id);
        if (!$faqCategories) {
            return response()->json([
                    'error' => 'Faq Categories not found'
                ], 404);
        }
        $faqCategories->delete();
        return response()->json(['message' => 'FAQ Category Deleted Successfully']);
    }

    public function updateStatus(Request $request)
    {
        $faq = FaqCategory::find($request->id);
        $faq->status = $request->status;
        $faq->update();
        return response()->json([
            'status' => 'success',
            'message' => __('Status updated')
        ]);
    }
}
